/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.geom.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.intern.math.MathKt;
import org.jetbrains.letsPlot.commons.values.Color;
import org.jetbrains.letsPlot.commons.values.FontFace;
import org.jetbrains.letsPlot.core.plot.base.DataPointAesthetics;
import org.jetbrains.letsPlot.core.plot.base.GeomContext;
import org.jetbrains.letsPlot.core.plot.base.aes.AesScaling;
import org.jetbrains.letsPlot.core.plot.base.aes.AestheticsUtil;
import org.jetbrains.letsPlot.core.plot.base.geom.util.TextUtil;
import org.jetbrains.letsPlot.core.plot.base.render.svg.MultilineLabel;
import org.jetbrains.letsPlot.core.plot.base.render.svg.Text;
import org.jetbrains.letsPlot.core.plot.base.render.svg.TextLabel;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgUtils;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ5\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0000\u00a2\u0006\u0002\b\u0016J*\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u001b\u001a\u00020\u000b2\b\b\u0002\u0010\u001c\u001a\u00020\u0015J*\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001d2\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u001b\u001a\u00020\u000b2\b\b\u0002\u0010\u001c\u001a\u00020\u0015J\u000e\u0010\u001e\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rJ\u0016\u0010\u001f\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u000bJ\u000e\u0010 \u001a\u00020\u00072\u0006\u0010!\u001a\u00020\u0001J \u0010 \u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0012J\u0016\u0010\"\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u000bJ(\u0010#\u001a\u00020\u00122\u0006\u0010$\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010%\u001a\u00020&2\b\b\u0002\u0010\u001b\u001a\u00020\u000bJ\u000e\u0010'\u001a\u00020\t2\u0006\u0010(\u001a\u00020\u0001J \u0010'\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0012R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00070\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\t0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/util/TextUtil;", "", "()V", "FONT_FAMILY_MAP", "", "", "HJUST_MAP", "Lorg/jetbrains/letsPlot/core/plot/base/render/svg/Text$HorizontalAnchor;", "VJUST_MAP", "Lorg/jetbrains/letsPlot/core/plot/base/render/svg/Text$VerticalAnchor;", "angle", "", "p", "Lorg/jetbrains/letsPlot/core/plot/base/DataPointAesthetics;", "computeJustification", "initialJust", "initialAngle", "location", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "center", "isHorizontal", "", "computeJustification$plot_base", "decorate", "", "label", "Lorg/jetbrains/letsPlot/core/plot/base/render/svg/MultilineLabel;", "scale", "applyAlpha", "Lorg/jetbrains/letsPlot/core/plot/base/render/svg/TextLabel;", "fontFamily", "fontSize", "hAnchor", "hjust", "lineheight", "measure", "text", "ctx", "Lorg/jetbrains/letsPlot/core/plot/base/GeomContext;", "vAnchor", "vjust", "plot-base"})
@SourceDebugExtension(value={"SMAP\nTextUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextUtil.kt\norg/jetbrains/letsPlot/core/plot/base/geom/util/TextUtil\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,214:1\n1#2:215\n1549#3:216\n1620#3,3:217\n1789#3,3:220\n*S KotlinDebug\n*F\n+ 1 TextUtil.kt\norg/jetbrains/letsPlot/core/plot/base/geom/util/TextUtil\n*L\n202#1:216\n202#1:217,3\n204#1:220,3\n*E\n"})
public final class TextUtil {
    @NotNull
    public static final TextUtil INSTANCE = new TextUtil();
    @NotNull
    private static final Map<Object, Text.HorizontalAnchor> HJUST_MAP;
    @NotNull
    private static final Map<Object, Text.VerticalAnchor> VJUST_MAP;
    @NotNull
    private static final Map<String, String> FONT_FAMILY_MAP;

    private TextUtil() {
    }

    @NotNull
    public final Text.HorizontalAnchor hAnchor(@NotNull Object hjust) {
        Intrinsics.checkNotNullParameter((Object)hjust, (String)"hjust");
        Text.HorizontalAnchor horizontalAnchor = HJUST_MAP.get(hjust);
        if (horizontalAnchor == null) {
            horizontalAnchor = Text.HorizontalAnchor.MIDDLE;
        }
        return horizontalAnchor;
    }

    @NotNull
    public final Text.HorizontalAnchor hAnchor(@NotNull DataPointAesthetics p, @NotNull DoubleVector location2, @Nullable DoubleVector center) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Intrinsics.checkNotNullParameter((Object)location2, (String)"location");
        Object hjust = p.hjust();
        Object[] objectArray = new String[]{"inward", "outward"};
        if (CollectionsKt.contains((Iterable)CollectionsKt.listOf((Object[])objectArray), (Object)hjust) && center != null) {
            Double d = p.angle();
            Intrinsics.checkNotNull((Object)d);
            hjust = this.computeJustification$plot_base(hjust, d, location2, center, true);
        }
        return this.hAnchor(hjust);
    }

    @NotNull
    public final Text.VerticalAnchor vAnchor(@NotNull Object vjust) {
        Intrinsics.checkNotNullParameter((Object)vjust, (String)"vjust");
        Text.VerticalAnchor verticalAnchor = VJUST_MAP.get(vjust);
        if (verticalAnchor == null) {
            verticalAnchor = Text.VerticalAnchor.CENTER;
        }
        return verticalAnchor;
    }

    @NotNull
    public final Text.VerticalAnchor vAnchor(@NotNull DataPointAesthetics p, @NotNull DoubleVector location2, @Nullable DoubleVector center) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Intrinsics.checkNotNullParameter((Object)location2, (String)"location");
        Object vjust = p.vjust();
        Object[] objectArray = new String[]{"inward", "outward"};
        if (CollectionsKt.contains((Iterable)CollectionsKt.listOf((Object[])objectArray), (Object)vjust) && center != null) {
            Double d = p.angle();
            Intrinsics.checkNotNull((Object)d);
            vjust = this.computeJustification$plot_base(vjust, d, location2, center, false);
        }
        return this.vAnchor(vjust);
    }

    @NotNull
    public final Object computeJustification$plot_base(@NotNull Object initialJust, double initialAngle, @NotNull DoubleVector location2, @NotNull DoubleVector center, boolean isHorizontal) {
        List list2;
        Object object;
        boolean outward;
        Intrinsics.checkNotNullParameter((Object)initialJust, (String)"initialJust");
        Intrinsics.checkNotNullParameter((Object)location2, (String)"location");
        Intrinsics.checkNotNullParameter((Object)center, (String)"center");
        Object[] objectArray = new String[]{"inward", "outward"};
        if (!CollectionsKt.contains((Iterable)CollectionsKt.listOf((Object[])objectArray), (Object)initialJust)) {
            return initialJust;
        }
        double angle = initialAngle % (double)360;
        angle = angle > 180.0 ? angle - (double)360 : angle;
        angle = angle < -180.0 ? angle + (double)360 : angle;
        boolean rotatedForward = angle > 45.0 && angle < 135.0;
        boolean rotatedBackward = angle < -45.0 && angle > -135.0;
        KProperty1 a2 = isHorizontal ? (KProperty1)computeJustification.a.1.INSTANCE : (KProperty1)computeJustification.a.2.INSTANCE;
        KProperty1 b2 = isHorizontal ? (KProperty1)computeJustification.b.1.INSTANCE : (KProperty1)computeJustification.b.2.INSTANCE;
        KProperty1 coord = rotatedForward || rotatedBackward ? b2 : a2;
        boolean swap = isHorizontal && rotatedForward || !isHorizontal && rotatedBackward || Math.abs(angle) >= 135.0;
        boolean bl = outward = Intrinsics.areEqual((Object)initialJust, (Object)"inward") && swap || Intrinsics.areEqual((Object)initialJust, (Object)"outward") && !swap;
        if (isHorizontal) {
            object = new String[]{"left", "middle", "right"};
            list2 = CollectionsKt.listOf((Object[])object);
        } else {
            object = new String[]{"top", "center", "bottom"};
            list2 = CollectionsKt.listOf((Object[])object);
        }
        Object $this$computeJustification_u24lambda_u240 = object = CollectionsKt.toMutableList((Collection)list2);
        boolean bl2 = false;
        if (outward) {
            CollectionsKt.reverse((List)$this$computeJustification_u24lambda_u240);
        }
        Object justifications = object;
        int pos = MathKt.areEqual$default(((Number)coord.invoke((Object)location2)).doubleValue(), ((Number)coord.invoke((Object)center)).doubleValue(), 0.0, 4, null) ? 1 : (((Number)coord.invoke((Object)location2)).doubleValue() < ((Number)coord.invoke((Object)center)).doubleValue() ? 0 : 2);
        return justifications.get(pos);
    }

    @NotNull
    public final String fontFamily(@NotNull DataPointAesthetics p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        String family = p.family();
        if (FONT_FAMILY_MAP.containsKey(family)) {
            String string = FONT_FAMILY_MAP.get(family);
            Intrinsics.checkNotNull((Object)string);
            family = string;
        }
        return family;
    }

    public final double angle(@NotNull DataPointAesthetics p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Double d = p.angle();
        Intrinsics.checkNotNull((Object)d);
        double angle = d;
        if (!(angle == 0.0)) {
            angle = (double)360 - angle % (double)360;
        }
        return angle;
    }

    public final double fontSize(@NotNull DataPointAesthetics p, double scale) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        double d = AesScaling.INSTANCE.textSize(p) * scale;
        return Math.max(0.1, d);
    }

    public final double lineheight(@NotNull DataPointAesthetics p, double scale) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Double d = p.lineheight();
        Intrinsics.checkNotNull((Object)d);
        return d * this.fontSize(p, scale);
    }

    public final void decorate(@NotNull TextLabel label2, @NotNull DataPointAesthetics p, double scale, boolean applyAlpha) {
        Intrinsics.checkNotNullParameter((Object)label2, (String)"label");
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        label2.textColor().set(p.color());
        if (applyAlpha) {
            label2.textOpacity().set(p.alpha());
        }
        label2.setFontSize(this.fontSize(p, scale));
        label2.setFontFamily(this.fontFamily(p));
        FontFace $this$decorate_u24lambda_u241 = FontFace.Companion.fromString(p.fontface());
        boolean bl = false;
        if ($this$decorate_u24lambda_u241.getBold()) {
            label2.setFontWeight("bold");
        }
        if ($this$decorate_u24lambda_u241.getItalic()) {
            label2.setFontStyle("italic");
        }
        Text.HorizontalAnchor hAnchor = this.hAnchor(p.hjust());
        Text.VerticalAnchor vAnchor = this.vAnchor(p.vjust());
        if (hAnchor != Text.HorizontalAnchor.LEFT) {
            label2.setHorizontalAnchor(hAnchor);
        }
        if (vAnchor != Text.VerticalAnchor.BOTTOM) {
            label2.setVerticalAnchor(vAnchor);
        }
        label2.rotate(this.angle(p));
    }

    public static /* synthetic */ void decorate$default(TextUtil textUtil, TextLabel textLabel, DataPointAesthetics dataPointAesthetics, double d, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            d = 1.0;
        }
        if ((n & 8) != 0) {
            bl = true;
        }
        textUtil.decorate(textLabel, dataPointAesthetics, d, bl);
    }

    public final void decorate(@NotNull MultilineLabel label2, @NotNull DataPointAesthetics p, double scale, boolean applyAlpha) {
        Intrinsics.checkNotNullParameter((Object)label2, (String)"label");
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Color color = p.color();
        Intrinsics.checkNotNull((Object)color);
        Color color2 = color;
        label2.textColor().set(color2);
        double alpha = applyAlpha ? AestheticsUtil.INSTANCE.alpha(color2, p) : SvgUtils.INSTANCE.alpha2opacity(color2.getAlpha());
        label2.setTextOpacity(alpha);
        label2.setFontSize(this.fontSize(p, scale));
        label2.setLineHeight(this.lineheight(p, scale));
        label2.setFontFamily(this.fontFamily(p));
        FontFace $this$decorate_u24lambda_u242 = FontFace.Companion.fromString(p.fontface());
        boolean bl = false;
        if ($this$decorate_u24lambda_u242.getBold()) {
            label2.setFontWeight("bold");
        }
        if ($this$decorate_u24lambda_u242.getItalic()) {
            label2.setFontStyle("italic");
        }
    }

    public static /* synthetic */ void decorate$default(TextUtil textUtil, MultilineLabel multilineLabel, DataPointAesthetics dataPointAesthetics, double d, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            d = 1.0;
        }
        if ((n & 8) != 0) {
            bl = true;
        }
        textUtil.decorate(multilineLabel, dataPointAesthetics, d, bl);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final DoubleVector measure(@NotNull String text2, @NotNull DataPointAesthetics p, @NotNull GeomContext ctx2, double scale) {
        void $this$fold$iv;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Intrinsics.checkNotNullParameter((Object)ctx2, (String)"ctx");
        List<String> lines = MultilineLabel.Companion.splitLines(text2);
        double fontSize = this.fontSize(p, scale);
        double lineHeight = this.lineheight(p, scale);
        String fontFamily = this.fontFamily(p);
        FontFace fontFace = FontFace.Companion.fromString(p.fontface());
        Iterable $this$map$iv = lines;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void line2;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(ctx2.estimateTextSize((String)line2, fontFamily, fontSize, fontFace.getBold(), fontFace.getItalic()));
        }
        $this$map$iv = (List)destination$iv$iv;
        DoubleVector initial$iv = DoubleVector.Companion.getZERO();
        boolean $i$f$fold = false;
        DoubleVector accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void sz;
            Object item$iv$iv;
            item$iv$iv = (DoubleVector)element$iv;
            DoubleVector acc = accumulator$iv;
            boolean bl = false;
            accumulator$iv = new DoubleVector(Math.max(acc.getX(), sz.getX()), acc.getY() + sz.getY());
        }
        DoubleVector estimated = accumulator$iv;
        double lineInterval = lineHeight - fontSize;
        double textHeight = estimated.getY() + lineInterval * (double)(lines.size() - 1);
        return new DoubleVector(estimated.getX(), textHeight);
    }

    public static /* synthetic */ DoubleVector measure$default(TextUtil textUtil, String string, DataPointAesthetics dataPointAesthetics, GeomContext geomContext, double d, int n, Object object) {
        if ((n & 8) != 0) {
            d = 1.0;
        }
        return textUtil.measure(string, dataPointAesthetics, geomContext, d);
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"right", (Object)((Object)Text.HorizontalAnchor.RIGHT)), TuplesKt.to((Object)"middle", (Object)((Object)Text.HorizontalAnchor.MIDDLE)), TuplesKt.to((Object)"left", (Object)((Object)Text.HorizontalAnchor.LEFT)), TuplesKt.to((Object)0.0, (Object)((Object)Text.HorizontalAnchor.LEFT)), TuplesKt.to((Object)0.5, (Object)((Object)Text.HorizontalAnchor.MIDDLE)), TuplesKt.to((Object)1.0, (Object)((Object)Text.HorizontalAnchor.RIGHT))};
        HJUST_MAP = MapsKt.mapOf((Pair[])pairArray);
        pairArray = new Pair[]{TuplesKt.to((Object)"bottom", (Object)((Object)Text.VerticalAnchor.BOTTOM)), TuplesKt.to((Object)"center", (Object)((Object)Text.VerticalAnchor.CENTER)), TuplesKt.to((Object)"top", (Object)((Object)Text.VerticalAnchor.TOP)), TuplesKt.to((Object)0.0, (Object)((Object)Text.VerticalAnchor.BOTTOM)), TuplesKt.to((Object)0.5, (Object)((Object)Text.VerticalAnchor.CENTER)), TuplesKt.to((Object)1.0, (Object)((Object)Text.VerticalAnchor.TOP))};
        VJUST_MAP = MapsKt.mapOf((Pair[])pairArray);
        pairArray = new Pair[]{TuplesKt.to((Object)"sans", (Object)"sans-serif"), TuplesKt.to((Object)"serif", (Object)"serif"), TuplesKt.to((Object)"mono", (Object)"monospace")};
        FONT_FAMILY_MAP = MapsKt.mapOf((Pair[])pairArray);
    }
}

