/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.scale.breaks;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.core.commons.data.SeriesUtil;
import org.jetbrains.letsPlot.core.plot.base.scale.breaks.BreaksHelperBase;
import org.jetbrains.letsPlot.core.plot.base.scale.breaks.NumericBreakFormatter;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0007\b\u0000\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016BE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0014\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0018\u00010\b\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\f\u00a2\u0006\u0002\u0010\u000eR\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001d\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001c\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/scale/breaks/LinearBreaksHelper;", "Lorg/jetbrains/letsPlot/core/plot/base/scale/breaks/BreaksHelperBase;", "rangeStart", "", "rangeEnd", "targetCount", "", "providedFormatter", "Lkotlin/Function1;", "", "", "superscriptExponent", "", "precise", "(DDILkotlin/jvm/functions/Function1;ZZ)V", "breaks", "", "getBreaks", "()Ljava/util/List;", "formatter", "getFormatter", "()Lkotlin/jvm/functions/Function1;", "Companion", "plot-base"})
@SourceDebugExtension(value={"SMAP\nLinearBreaksHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LinearBreaksHelper.kt\norg/jetbrains/letsPlot/core/plot/base/scale/breaks/LinearBreaksHelper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,122:1\n1#2:123\n1549#3:124\n1620#3,3:125\n*S KotlinDebug\n*F\n+ 1 LinearBreaksHelper.kt\norg/jetbrains/letsPlot/core/plot/base/scale/breaks/LinearBreaksHelper\n*L\n36#1:124\n36#1:125,3\n*E\n"})
public final class LinearBreaksHelper
extends BreaksHelperBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Function1<Object, String> providedFormatter;
    @NotNull
    private final List<Double> breaks;
    @NotNull
    private final Function1<Object, String> formatter;

    /*
     * WARNING - void declaration
     */
    public LinearBreaksHelper(double rangeStart, double rangeEnd, int targetCount, @Nullable Function1<Object, String> providedFormatter, boolean superscriptExponent, boolean precise) {
        super(rangeStart, rangeEnd, targetCount);
        List breaks;
        List list2;
        double step2;
        this.providedFormatter = providedFormatter;
        if (!(targetCount > 0)) {
            boolean bl = false;
            String string = "Can't compute breaks for count: " + targetCount;
            throw new IllegalStateException(string.toString());
        }
        double d = step2 = precise ? this.getTargetStep() : LinearBreaksHelper.Companion.computeNiceStep(this.getSpan(), targetCount);
        if (SeriesUtil.INSTANCE.isBeyondPrecision(this.getNormalStart(), step2) || SeriesUtil.INSTANCE.isBeyondPrecision(this.getNormalEnd(), step2)) {
            list2 = CollectionsKt.emptyList();
        } else if (precise) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = (Iterable)RangesKt.until((int)0, (int)targetCount);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator2 = $this$mapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                void it;
                int item$iv$iv;
                int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(this.getNormalStart() + step2 / (double)2 + (double)it * step2);
            }
            list2 = (List)destination$iv$iv;
        } else {
            list2 = breaks = LinearBreaksHelper.Companion.computeNiceBreaks(this.getNormalStart(), this.getNormalEnd(), step2);
        }
        List list3 = this.breaks = breaks.isEmpty() ? CollectionsKt.listOf((Object)this.getNormalStart()) : (this.isReversed() ? CollectionsKt.asReversed((List)breaks) : breaks);
        Function1 function1 = this.providedFormatter;
        if (function1 == null) {
            function1 = LinearBreaksHelper.Companion.createFormatter(this.getBreaks(), superscriptExponent);
        }
        this.formatter = function1;
    }

    public /* synthetic */ LinearBreaksHelper(double d, double d2, int n, Function1 function1, boolean bl, boolean bl2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x20) != 0) {
            bl2 = false;
        }
        this(d, d2, n, (Function1<Object, String>)function1, bl, bl2);
    }

    @Override
    @NotNull
    public List<Double> getBreaks() {
        return this.breaks;
    }

    @NotNull
    public final Function1<Object, String> getFormatter() {
        return this.formatter;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0005H\u0002J\u0018\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0002J*\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u000f0\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/scale/breaks/LinearBreaksHelper$Companion;", "", "()V", "computeNiceBreaks", "", "", "start", "end", "step", "computeNiceStep", "span", "count", "", "createFormatter", "Lkotlin/Function1;", "", "breakValues", "superscriptExponent", "", "plot-base"})
    public static final class Companion {
        private Companion() {
        }

        private final double computeNiceStep(double span, int count2) {
            double stepRaw = span / (double)count2;
            double step10Power = Math.floor(Math.log10(stepRaw));
            double step2 = Math.pow(10.0, step10Power);
            double error = step2 * (double)count2 / span;
            return error <= 0.15 ? step2 * 10.0 : (error <= 0.35 ? step2 * 5.0 : (error <= 0.75 ? step2 * 2.0 : step2));
        }

        private final List<Double> computeNiceBreaks(double start2, double end, double step2) {
            if (step2 == 0.0) {
                return CollectionsKt.emptyList();
            }
            double delta = step2 / (double)10000;
            double startE = start2 - delta;
            double endE = end + delta;
            ArrayList<Double> breaks = new ArrayList<Double>();
            double tick = Math.ceil(startE / step2) * step2;
            if (start2 >= 0.0 && startE < 0.0) {
                tick = 0.0;
            }
            while (tick <= endE) {
                tick = Math.min(tick, end);
                breaks.add(tick);
                tick += step2;
            }
            return breaks;
        }

        private final Function1<Object, String> createFormatter(List<Double> breakValues, boolean superscriptExponent) {
            Pair pair2;
            if (breakValues.isEmpty()) {
                pair2 = new Pair((Object)0.0, (Object)0.5);
            } else {
                double v = Math.max(Math.abs(((Number)CollectionsKt.first(breakValues)).doubleValue()), Math.abs(((Number)CollectionsKt.last(breakValues)).doubleValue()));
                double s = breakValues.size() == 1 ? v / (double)10 : Math.abs(((Number)breakValues.get(1)).doubleValue() - ((Number)breakValues.get(0)).doubleValue());
                pair2 = new Pair((Object)v, (Object)s);
            }
            Pair pair3 = pair2;
            double referenceValue = ((Number)pair3.component1()).doubleValue();
            double step2 = ((Number)pair3.component2()).doubleValue();
            NumericBreakFormatter formatter2 = new NumericBreakFormatter(referenceValue, step2, true, superscriptExponent);
            return (Function1)new Function1<Object, String>((Object)formatter2){

                @NotNull
                public final String invoke(@NotNull Object p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return ((NumericBreakFormatter)this.receiver).apply(p0);
                }
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

