/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.stat;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.RandomKt;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.interval.DoubleSpan;
import org.jetbrains.letsPlot.core.commons.data.SeriesUtil;
import org.jetbrains.letsPlot.core.plot.base.Aes;
import org.jetbrains.letsPlot.core.plot.base.DataFrame;
import org.jetbrains.letsPlot.core.plot.base.StatContext;
import org.jetbrains.letsPlot.core.plot.base.data.TransformVar;
import org.jetbrains.letsPlot.core.plot.base.stat.BaseStat;
import org.jetbrains.letsPlot.core.plot.base.stat.Stats;
import org.jetbrains.letsPlot.core.plot.base.stat.regression.EvalResult;
import org.jetbrains.letsPlot.core.plot.base.stat.regression.LinearRegression;
import org.jetbrains.letsPlot.core.plot.base.stat.regression.LocalPolynomialRegression;
import org.jetbrains.letsPlot.core.plot.base.stat.regression.PolynomialRegression;
import org.jetbrains.letsPlot.core.plot.base.stat.regression.RegressionEvaluator;
import org.jetbrains.letsPlot.core.plot.base.util.SamplingUtil;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 *2\u00020\u0001:\u0002*+BE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u0007\u0012\u0006\u0010\u000b\u001a\u00020\u0003\u0012\u0006\u0010\f\u001a\u00020\u0003\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ;\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00142!\u0010\u0015\u001a\u001d\u0012\u0013\u0012\u00110\u0017\u00a2\u0006\f\b\u0018\u0012\b\b\u0019\u0012\u0004\b\b(\u001a\u0012\u0004\u0012\u00020\u001b0\u0016H\u0016J3\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112!\u0010\u0015\u001a\u001d\u0012\u0013\u0012\u00110\u0017\u00a2\u0006\f\b\u0018\u0012\b\b\u0019\u0012\u0004\b\b(\u001a\u0012\u0004\u0012\u00020\u001b0\u0016H\u0002J:\u0010\u001d\u001a\u0014\u0012\u0004\u0012\u00020\u001f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070 0\u001e2\u000e\u0010!\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070 2\u000e\u0010\"\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070 H\u0002J\u0012\u0010#\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030$0 H\u0016J\u0014\u0010%\u001a\u00020\u001f2\n\u0010&\u001a\u0006\u0012\u0002\b\u00030$H\u0016J\u0014\u0010'\u001a\u00020\t2\n\u0010&\u001a\u0006\u0012\u0002\b\u00030$H\u0016J\u0010\u0010(\u001a\u00020\t2\u0006\u0010)\u001a\u00020\u0003H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/stat/SmoothStat;", "Lorg/jetbrains/letsPlot/core/plot/base/stat/BaseStat;", "smootherPointCount", "", "smoothingMethod", "Lorg/jetbrains/letsPlot/core/plot/base/stat/SmoothStat$Method;", "confidenceLevel", "", "displayConfidenceInterval", "", "span", "polynomialDegree", "loessCriticalSize", "samplingSeed", "", "(ILorg/jetbrains/letsPlot/core/plot/base/stat/SmoothStat$Method;DZDIIJ)V", "apply", "Lorg/jetbrains/letsPlot/core/plot/base/DataFrame;", "data", "statCtx", "Lorg/jetbrains/letsPlot/core/plot/base/StatContext;", "messageConsumer", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "s", "", "applySampling", "applySmoothing", "", "Lorg/jetbrains/letsPlot/core/plot/base/DataFrame$Variable;", "", "valuesX", "valuesY", "consumes", "Lorg/jetbrains/letsPlot/core/plot/base/Aes;", "getDefaultMapping", "aes", "hasDefaultMapping", "needSampling", "rowCount", "Companion", "Method", "plot-base"})
@SourceDebugExtension(value={"SMAP\nSmoothStat.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SmoothStat.kt\norg/jetbrains/letsPlot/core/plot/base/stat/SmoothStat\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,233:1\n1#2:234\n*E\n"})
public final class SmoothStat
extends BaseStat {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int smootherPointCount;
    @NotNull
    private final Method smoothingMethod;
    private final double confidenceLevel;
    private final boolean displayConfidenceInterval;
    private final double span;
    private final int polynomialDegree;
    private final int loessCriticalSize;
    private final long samplingSeed;
    @NotNull
    private static final Map<Aes<?>, DataFrame.Variable> DEF_MAPPING;
    public static final int DEF_EVAL_POINT_COUNT = 80;
    @NotNull
    private static final Method DEF_SMOOTHING_METHOD;
    public static final double DEF_CONFIDENCE_LEVEL = 0.95;
    public static final boolean DEF_DISPLAY_CONFIDENCE_INTERVAL = true;
    public static final double DEF_SPAN = 0.5;
    public static final int DEF_DEG = 1;
    public static final int DEF_LOESS_CRITICAL_SIZE = 1000;
    public static final long DEF_SAMPLING_SEED = 37L;

    public SmoothStat(int smootherPointCount, @NotNull Method smoothingMethod, double confidenceLevel, boolean displayConfidenceInterval, double span, int polynomialDegree, int loessCriticalSize, long samplingSeed) {
        Intrinsics.checkNotNullParameter((Object)((Object)smoothingMethod), (String)"smoothingMethod");
        super(DEF_MAPPING);
        this.smootherPointCount = smootherPointCount;
        this.smoothingMethod = smoothingMethod;
        this.confidenceLevel = confidenceLevel;
        this.displayConfidenceInterval = displayConfidenceInterval;
        this.span = span;
        this.polynomialDegree = polynomialDegree;
        this.loessCriticalSize = loessCriticalSize;
        this.samplingSeed = samplingSeed;
    }

    @Override
    public boolean hasDefaultMapping(@NotNull Aes<?> aes2) {
        Intrinsics.checkNotNullParameter(aes2, (String)"aes");
        return super.hasDefaultMapping(aes2) || Intrinsics.areEqual(aes2, Aes.Companion.getYMIN()) && this.displayConfidenceInterval || Intrinsics.areEqual(aes2, Aes.Companion.getYMAX()) && this.displayConfidenceInterval;
    }

    @Override
    @NotNull
    public DataFrame.Variable getDefaultMapping(@NotNull Aes<?> aes2) {
        Intrinsics.checkNotNullParameter(aes2, (String)"aes");
        if (Intrinsics.areEqual(aes2, Aes.Companion.getYMIN())) {
            return Stats.INSTANCE.getY_MIN();
        }
        return Intrinsics.areEqual(aes2, Aes.Companion.getYMAX()) ? Stats.INSTANCE.getY_MAX() : super.getDefaultMapping(aes2);
    }

    @Override
    @NotNull
    public List<Aes<?>> consumes() {
        Object[] objectArray = new Aes[]{Aes.Companion.getX(), Aes.Companion.getY()};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    private final boolean needSampling(int rowCount) {
        if (this.smoothingMethod != Method.LOESS) {
            return false;
        }
        return rowCount > this.loessCriticalSize;
    }

    private final DataFrame applySampling(DataFrame data, Function1<? super String, Unit> messageConsumer) {
        String msg = "LOESS drew a random sample with max_n=" + this.loessCriticalSize + ", seed=" + this.samplingSeed;
        messageConsumer.invoke((Object)msg);
        return SamplingUtil.INSTANCE.sampleWithoutReplacement(this.loessCriticalSize, RandomKt.Random((long)this.samplingSeed), data);
    }

    @Override
    @NotNull
    public DataFrame apply(@NotNull DataFrame data, @NotNull StatContext statCtx, @NotNull Function1<? super String, Unit> messageConsumer) {
        List<Double> valuesY;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)statCtx, (String)"statCtx");
        Intrinsics.checkNotNullParameter(messageConsumer, (String)"messageConsumer");
        Aes[] aesArray = new Aes[]{Aes.Companion.getY()};
        if (!this.hasRequiredValues(data, aesArray)) {
            return this.withEmptyStatValues();
        }
        DataFrame data2 = data;
        if (this.needSampling(data2.rowCount())) {
            data2 = this.applySampling(data2, messageConsumer);
        }
        if ((valuesY = data2.getNumeric(TransformVar.INSTANCE.getY())).size() < 3) {
            return this.withEmptyStatValues();
        }
        List valuesX = null;
        if (data2.has(TransformVar.INSTANCE.getX())) {
            valuesX = data2.getNumeric(TransformVar.INSTANCE.getX());
        } else {
            valuesX = new ArrayList();
            int n = valuesY.size();
            for (int i = 0; i < n; ++i) {
                ((ArrayList)valuesX).add(Double.valueOf(i));
            }
        }
        if (SeriesUtil.INSTANCE.range(valuesX) == null) {
            return this.withEmptyStatValues();
        }
        List<Double> statX = null;
        List<Double> statY = null;
        List<Double> statMinY = null;
        List<Double> statMaxY = null;
        List<Double> statSE = null;
        Map<DataFrame.Variable, List<Double>> statValues = this.applySmoothing(valuesX, valuesY);
        List<Double> list2 = statValues.get(Stats.INSTANCE.getX());
        Intrinsics.checkNotNull(list2);
        statX = list2;
        List<Double> list3 = statValues.get(Stats.INSTANCE.getY());
        Intrinsics.checkNotNull(list3);
        statY = list3;
        List<Double> list4 = statValues.get(Stats.INSTANCE.getY_MIN());
        Intrinsics.checkNotNull(list4);
        statMinY = list4;
        List<Double> list5 = statValues.get(Stats.INSTANCE.getY_MAX());
        Intrinsics.checkNotNull(list5);
        statMaxY = list5;
        List<Double> list6 = statValues.get(Stats.INSTANCE.getSE());
        Intrinsics.checkNotNull(list6);
        statSE = list6;
        DataFrame.Builder statData = new DataFrame.Builder().putNumeric(Stats.INSTANCE.getX(), statX).putNumeric(Stats.INSTANCE.getY(), statY);
        if (this.displayConfidenceInterval) {
            statData.putNumeric(Stats.INSTANCE.getY_MIN(), statMinY).putNumeric(Stats.INSTANCE.getY_MAX(), statMaxY).putNumeric(Stats.INSTANCE.getSE(), statSE);
        }
        return statData.build();
    }

    private final Map<DataFrame.Variable, List<Double>> applySmoothing(List<Double> valuesX, List<Double> valuesY) {
        RegressionEvaluator regressionEvaluator;
        ArrayList<Double> statX = new ArrayList<Double>();
        ArrayList<Double> statY = new ArrayList<Double>();
        ArrayList<Double> statMinY = new ArrayList<Double>();
        ArrayList<Double> statMaxY = new ArrayList<Double>();
        ArrayList<Double> statSE = new ArrayList<Double>();
        HashMap result2 = new HashMap();
        ((Map)result2).put(Stats.INSTANCE.getX(), statX);
        ((Map)result2).put(Stats.INSTANCE.getY(), statY);
        ((Map)result2).put(Stats.INSTANCE.getY_MIN(), statMinY);
        ((Map)result2).put(Stats.INSTANCE.getY_MAX(), statMaxY);
        ((Map)result2).put(Stats.INSTANCE.getSE(), statSE);
        switch (WhenMappings.$EnumSwitchMapping$0[this.smoothingMethod.ordinal()]) {
            case 1: {
                if (!(this.polynomialDegree >= 1)) {
                    boolean bl = false;
                    String string = "Degree of polynomial regression must be at least 1";
                    throw new IllegalArgumentException(string.toString());
                }
                if (this.polynomialDegree == 1) {
                    regressionEvaluator = LinearRegression.Companion.fit(valuesX, valuesY, this.confidenceLevel);
                    break;
                }
                regressionEvaluator = PolynomialRegression.Companion.fit(valuesX, valuesY, this.confidenceLevel, this.polynomialDegree);
                break;
            }
            case 2: {
                regressionEvaluator = LocalPolynomialRegression.Companion.fit(valuesX, valuesY, this.confidenceLevel, this.span);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported smoother method: " + (Object)((Object)this.smoothingMethod) + " (only 'lm' and 'loess' methods are currently available)");
            }
        }
        if (regressionEvaluator == null) {
            return result2;
        }
        RegressionEvaluator regression = regressionEvaluator;
        DoubleSpan doubleSpan = SeriesUtil.INSTANCE.range((Iterable<Double>)valuesX);
        if (doubleSpan == null) {
            return result2;
        }
        DoubleSpan rangeX = doubleSpan;
        double startX = rangeX.getLowerEnd();
        double spanX = rangeX.getUpperEnd() - startX;
        double stepX = spanX / (double)(this.smootherPointCount - 1);
        int n = this.smootherPointCount;
        for (int i = 0; i < n; ++i) {
            double x2 = startX + (double)i * stepX;
            EvalResult eval2 = regression.evalX(RangesKt.coerceIn((double)x2, (double)rangeX.getLowerEnd(), (double)rangeX.getUpperEnd()));
            statX.add(x2);
            statY.add(eval2.getY());
            statMinY.add(eval2.getYmin());
            statMaxY.add(eval2.getYmax());
            statSE.add(eval2.getSe());
        }
        return result2;
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to(Aes.Companion.getX(), (Object)Stats.INSTANCE.getX()), TuplesKt.to(Aes.Companion.getY(), (Object)Stats.INSTANCE.getY())};
        DEF_MAPPING = MapsKt.mapOf((Pair[])pairArray);
        DEF_SMOOTHING_METHOD = Method.LM;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000b\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r\u0012\u0004\u0012\u00020\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/stat/SmoothStat$Companion;", "", "()V", "DEF_CONFIDENCE_LEVEL", "", "DEF_DEG", "", "DEF_DISPLAY_CONFIDENCE_INTERVAL", "", "DEF_EVAL_POINT_COUNT", "DEF_LOESS_CRITICAL_SIZE", "DEF_MAPPING", "", "Lorg/jetbrains/letsPlot/core/plot/base/Aes;", "Lorg/jetbrains/letsPlot/core/plot/base/DataFrame$Variable;", "DEF_SAMPLING_SEED", "", "DEF_SMOOTHING_METHOD", "Lorg/jetbrains/letsPlot/core/plot/base/stat/SmoothStat$Method;", "getDEF_SMOOTHING_METHOD", "()Lorg/jetbrains/letsPlot/core/plot/base/stat/SmoothStat$Method;", "DEF_SPAN", "plot-base"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Method getDEF_SMOOTHING_METHOD() {
            return DEF_SMOOTHING_METHOD;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/stat/SmoothStat$Method;", "", "(Ljava/lang/String;I)V", "LM", "GLM", "GAM", "LOESS", "RLM", "plot-base"})
    public static final class Method
    extends Enum<Method> {
        public static final /* enum */ Method LM = new Method();
        public static final /* enum */ Method GLM = new Method();
        public static final /* enum */ Method GAM = new Method();
        public static final /* enum */ Method LOESS = new Method();
        public static final /* enum */ Method RLM = new Method();
        private static final /* synthetic */ Method[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Method[] values() {
            return (Method[])$VALUES.clone();
        }

        public static Method valueOf(String value) {
            return Enum.valueOf(Method.class, value);
        }

        @NotNull
        public static EnumEntries<Method> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = methodArray = new Method[]{Method.LM, Method.GLM, Method.GAM, Method.LOESS, Method.RLM};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Method.values().length];
            try {
                nArray[Method.LM.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Method.LOESS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

