/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder.layout;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.core.plot.base.layout.Thickness;
import org.jetbrains.letsPlot.core.plot.base.theme.AxisTheme;
import org.jetbrains.letsPlot.core.plot.base.theme.FacetsTheme;
import org.jetbrains.letsPlot.core.plot.base.theme.PlotTheme;
import org.jetbrains.letsPlot.core.plot.builder.assemble.PlotFacets;
import org.jetbrains.letsPlot.core.plot.builder.coord.CoordProvider;
import org.jetbrains.letsPlot.core.plot.builder.layout.FacetedPlotLayout;
import org.jetbrains.letsPlot.core.plot.builder.layout.FacetedPlotLayoutUtil;
import org.jetbrains.letsPlot.core.plot.builder.layout.PlotLabelSpecFactory;
import org.jetbrains.letsPlot.core.plot.builder.layout.PlotLayout;
import org.jetbrains.letsPlot.core.plot.builder.layout.PlotLayoutInfo;
import org.jetbrains.letsPlot.core.plot.builder.layout.PlotLayoutUtil;
import org.jetbrains.letsPlot.core.plot.builder.layout.TileLayoutInfo;
import org.jetbrains.letsPlot.core.plot.builder.layout.TileLayoutProvider;
import org.jetbrains.letsPlot.core.plot.builder.layout.facet.FixedScalesTilesLayouter;
import org.jetbrains.letsPlot.core.plot.builder.layout.facet.FreeScalesTilesLayouter;
import org.jetbrains.letsPlot.core.plot.builder.layout.util.Insets;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cBC\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/layout/FacetedPlotLayout;", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/PlotLayout;", "facets", "Lorg/jetbrains/letsPlot/core/plot/builder/assemble/PlotFacets;", "layoutProviderByTile", "", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/TileLayoutProvider;", "showFacetStrip", "", "hAxisTheme", "Lorg/jetbrains/letsPlot/core/plot/base/theme/AxisTheme;", "vAxisTheme", "plotTheme", "Lorg/jetbrains/letsPlot/core/plot/base/theme/PlotTheme;", "facetsTheme", "Lorg/jetbrains/letsPlot/core/plot/base/theme/FacetsTheme;", "(Lorg/jetbrains/letsPlot/core/plot/builder/assemble/PlotFacets;Ljava/util/List;ZLorg/jetbrains/letsPlot/core/plot/base/theme/AxisTheme;Lorg/jetbrains/letsPlot/core/plot/base/theme/AxisTheme;Lorg/jetbrains/letsPlot/core/plot/base/theme/PlotTheme;Lorg/jetbrains/letsPlot/core/plot/base/theme/FacetsTheme;)V", "insets", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/util/Insets;", "totalAddedHSize", "", "totalAddedVSize", "doLayout", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/PlotLayoutInfo;", "preferredSize", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "coordProvider", "Lorg/jetbrains/letsPlot/core/plot/builder/coord/CoordProvider;", "Companion", "plot-builder"})
@SourceDebugExtension(value={"SMAP\nFacetedPlotLayout.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FacetedPlotLayout.kt\norg/jetbrains/letsPlot/core/plot/builder/layout/FacetedPlotLayout\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,267:1\n1#2:268\n1#2:303\n1490#3:269\n1520#3,3:270\n1523#3,3:280\n1238#3,2:285\n1855#3:287\n1864#3,3:288\n1856#3:291\n1241#3:292\n1603#3,9:293\n1855#3:302\n1856#3:304\n1612#3:305\n2661#3,7:306\n1549#3:313\n1620#3,3:314\n372#4,7:273\n453#4:283\n403#4:284\n*S KotlinDebug\n*F\n+ 1 FacetedPlotLayout.kt\norg/jetbrains/letsPlot/core/plot/builder/layout/FacetedPlotLayout\n*L\n70#1:303\n57#1:269\n57#1:270,3\n57#1:280,3\n58#1:285,2\n60#1:287\n61#1:288,3\n60#1:291\n58#1:292\n70#1:293,9\n70#1:302\n70#1:304\n70#1:305\n189#1:306,7\n224#1:313\n224#1:314,3\n57#1:273,7\n58#1:283\n58#1:284\n*E\n"})
public final class FacetedPlotLayout
implements PlotLayout {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PlotFacets facets;
    @NotNull
    private final List<TileLayoutProvider> layoutProviderByTile;
    private final boolean showFacetStrip;
    @NotNull
    private final AxisTheme hAxisTheme;
    @NotNull
    private final AxisTheme vAxisTheme;
    @NotNull
    private final PlotTheme plotTheme;
    @NotNull
    private final FacetsTheme facetsTheme;
    private final double totalAddedHSize;
    private final double totalAddedVSize;
    @NotNull
    private final Insets insets;
    public static final int FACET_PADDING = 3;
    private static final double PANEL_PADDING = 10.0;

    public FacetedPlotLayout(@NotNull PlotFacets facets, @NotNull List<? extends TileLayoutProvider> layoutProviderByTile, boolean showFacetStrip, @NotNull AxisTheme hAxisTheme, @NotNull AxisTheme vAxisTheme, @NotNull PlotTheme plotTheme, @NotNull FacetsTheme facetsTheme) {
        Intrinsics.checkNotNullParameter((Object)facets, (String)"facets");
        Intrinsics.checkNotNullParameter(layoutProviderByTile, (String)"layoutProviderByTile");
        Intrinsics.checkNotNullParameter((Object)hAxisTheme, (String)"hAxisTheme");
        Intrinsics.checkNotNullParameter((Object)vAxisTheme, (String)"vAxisTheme");
        Intrinsics.checkNotNullParameter((Object)plotTheme, (String)"plotTheme");
        Intrinsics.checkNotNullParameter((Object)facetsTheme, (String)"facetsTheme");
        this.facets = facets;
        this.layoutProviderByTile = layoutProviderByTile;
        this.showFacetStrip = showFacetStrip;
        this.hAxisTheme = hAxisTheme;
        this.vAxisTheme = vAxisTheme;
        this.plotTheme = plotTheme;
        this.facetsTheme = facetsTheme;
        this.totalAddedHSize = 10.0 * (double)(this.facets.getColCount() - 1);
        this.totalAddedVSize = 10.0 * (double)(this.facets.getRowCount() - 1);
        this.insets = PlotLayoutUtil.INSTANCE.plotInsets(this.plotTheme.plotInset());
        if (!this.facets.isDefined()) {
            boolean bl = false;
            String string = "Undefined facets.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public PlotLayoutInfo doLayout(@NotNull DoubleVector preferredSize, @NotNull CoordProvider coordProvider) {
        void $this$reduce$iv;
        Object it;
        Iterator<PlotFacets.FacetTileInfo> $this$forEach$iv$iv$iv;
        Object object;
        Intrinsics.checkNotNullParameter((Object)preferredSize, (String)"preferredSize");
        Intrinsics.checkNotNullParameter((Object)coordProvider, (String)"coordProvider");
        Thickness plotMargins = this.plotTheme.plotMargins();
        DoubleVector tilesAreaSize = new DoubleVector(preferredSize.getX() - (this.insets.getLeft() + this.insets.getRight()), preferredSize.getY() - (this.insets.getTop() + this.insets.getBottom())).subtract(new DoubleVector(plotMargins.getWidth(), plotMargins.getHeight()));
        List<PlotFacets.FacetTileInfo> facetTiles = this.facets.tileInfos();
        Map facetColTabHeights = null;
        double facetRowTabWidth = 0.0;
        if (this.showFacetStrip) {
            Double d;
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            PlotFacets.FacetTileInfo it2;
            Object element$iv$iv$iv2;
            void $this$mapValuesTo$iv$iv;
            void $this$mapValues$iv;
            Object object2;
            Object value$iv$iv$iv;
            Map $this$getOrPut$iv$iv$iv;
            Object key$iv$iv;
            void $this$groupByTo$iv$iv;
            Map $this$groupBy$iv;
            Iterable iterable = facetTiles;
            boolean $i$f$groupBy = false;
            void var11_13 = $this$groupBy$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                void it3;
                Object object3;
                PlotFacets.FacetTileInfo it4 = (PlotFacets.FacetTileInfo)element$iv$iv;
                boolean $i$a$-groupBy-FacetedPlotLayout$doLayout$32 = false;
                key$iv$iv = it4.getRow();
                $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object3 = answer$iv$iv$iv;
                } else {
                    object3 = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object3;
                PlotFacets.FacetTileInfo $i$a$-groupBy-FacetedPlotLayout$doLayout$32 = (PlotFacets.FacetTileInfo)element$iv$iv;
                object2 = list$iv$iv;
                boolean bl = false;
                object2.add(it3.getColLabs());
            }
            $this$groupBy$iv = destination$iv$iv;
            boolean $i$f$mapValues22 = false;
            $this$groupByTo$iv$iv = $this$mapValues$iv;
            destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv2 : $this$associateByTo$iv$iv$iv) {
                void it$iv$iv;
                key$iv$iv = (Map.Entry)element$iv$iv$iv2;
                $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean bl = false;
                value$iv$iv$iv = (Map.Entry)element$iv$iv$iv2;
                object = it$iv$iv.getKey();
                object2 = $this$getOrPut$iv$iv$iv;
                boolean bl2 = false;
                HashMap subColLabels = new HashMap();
                Iterable $this$forEach$iv = (Iterable)it2.getValue();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    List colLabs = (List)element$iv;
                    boolean bl3 = false;
                    Iterable $this$forEachIndexed$iv = colLabs;
                    boolean $i$f$forEachIndexed = false;
                    int index$iv = 0;
                    for (Object item$iv : $this$forEachIndexed$iv) {
                        void colLab;
                        int n;
                        if ((n = index$iv++) < 0) {
                            CollectionsKt.throwIndexOverflow();
                        }
                        String string = (String)item$iv;
                        int index = n;
                        boolean bl4 = false;
                        double labHeight2 = Companion.facetLabelSize((String)colLab, this.facetsTheme, (Function1<? super Thickness, Double>)((Function1)doLayout.3.1.1.labHeight.1.INSTANCE));
                        Map map2 = subColLabels;
                        Integer n2 = index;
                        Double d2 = (Double)subColLabels.get(index);
                        if (d2 == null) {
                            d2 = 0.0;
                        }
                        Double d3 = d2;
                        Intrinsics.checkNotNull((Object)d3);
                        double d4 = ((Number)d3).doubleValue();
                        d3 = Math.max(labHeight2, d4);
                        map2.put(n2, d3);
                    }
                }
                Collection collection = subColLabels.values();
                Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
                List list2 = CollectionsKt.toList((Iterable)collection);
                object2.put(object, list2);
            }
            facetColTabHeights = destination$iv$iv;
            Iterable $i$f$mapValues22 = facetTiles;
            boolean $i$f$mapNotNull22 = false;
            destination$iv$iv = $this$mapNotNull$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo2 = false;
            $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            element$iv$iv$iv2 = $this$forEach$iv$iv$iv.iterator();
            while (element$iv$iv$iv2.hasNext()) {
                String it$iv$iv;
                Object element$iv$iv$iv3;
                Object element$iv$iv = element$iv$iv$iv3 = element$iv$iv$iv2.next();
                boolean bl = false;
                it2 = (PlotFacets.FacetTileInfo)element$iv$iv;
                boolean bl5 = false;
                if (it2.getRowLab() == null) continue;
                boolean bl6 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            Iterator $i$f$mapNotNull22 = ((Iterable)((List)destination$iv$iv2)).iterator();
            if (!$i$f$mapNotNull22.hasNext()) {
                d = null;
            } else {
                it = (String)$i$f$mapNotNull22.next();
                boolean bl = false;
                double $i$f$mapNotNullTo2 = Companion.facetLabelSize((String)it, this.facetsTheme, (Function1<? super Thickness, Double>)((Function1)doLayout.5.1.INSTANCE));
                while ($i$f$mapNotNull22.hasNext()) {
                    String it222 = (String)$i$f$mapNotNull22.next();
                    t = false;
                    double element$iv$iv$iv3 = Companion.facetLabelSize(it222, this.facetsTheme, (Function1<? super Thickness, Double>)((Function1)doLayout.5.1.INSTANCE));
                    $i$f$mapNotNullTo2 = Math.max($i$f$mapNotNullTo2, element$iv$iv$iv3);
                }
                d = $i$f$mapNotNullTo2;
            }
            facetRowTabWidth = d != null ? d : 0.0;
        } else {
            facetColTabHeights = MapsKt.emptyMap();
            facetRowTabWidth = 0.0;
        }
        Function1 facetColHeadHeightGetter2 = (Function1)new Function1<PlotFacets.FacetTileInfo, Double>((Map<Integer, ? extends List<Double>>)facetColTabHeights, this){
            final /* synthetic */ Map<Integer, List<Double>> $facetColTabHeights;
            final /* synthetic */ FacetedPlotLayout this$0;
            {
                this.$facetColTabHeights = $facetColTabHeights;
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Double invoke(@NotNull PlotFacets.FacetTileInfo facetTile) {
                double d;
                Intrinsics.checkNotNullParameter((Object)facetTile, (String)"facetTile");
                List<Double> list2 = this.$facetColTabHeights.get(facetTile.getRow());
                if (list2 != null) {
                    List<Double> list3 = list2;
                    Companion companion = FacetedPlotLayout.Companion;
                    List<Double> p0 = list3;
                    boolean bl = false;
                    d = companion.facetColHeadTotalHeight(p0);
                } else {
                    d = org.jetbrains.letsPlot.core.plot.builder.layout.FacetedPlotLayout$Companion.access$facetColHeadTotalHeight(FacetedPlotLayout.Companion, facetTile.getColLabs(), FacetedPlotLayout.access$getFacetsTheme$p(this.this$0));
                }
                return d;
            }
        };
        if (this.showFacetStrip) {
            it = facetColTabHeights.values();
            Companion bl = Companion;
            double $i$f$mapNotNullTo2 = 0.0;
            Iterator it222 = it.iterator();
            while (it222.hasNext()) {
                void p0;
                Object t = it222.next();
                List element$iv$iv$iv3 = (List)t;
                double d = $i$f$mapNotNullTo2;
                boolean bl7 = false;
                double d5 = bl.facetColHeadTotalHeight((List<Double>)p0);
                $i$f$mapNotNullTo2 = d + d5;
            }
            double totalAddedHeight = $i$f$mapNotNullTo2;
            double totalAddedWidth = facetRowTabWidth + (double)3;
            DoubleVector labsTotalDim = new DoubleVector(totalAddedWidth, totalAddedHeight);
            tilesAreaSize = tilesAreaSize.subtract(labsTotalDim);
        }
        List<TileLayoutInfo> layoutInfos = this.facets.getFreeHScale() || this.facets.getFreeVScale() ? FreeScalesTilesLayouter.INSTANCE.createTileLayoutInfos(tilesAreaSize, this.facets, this.layoutProviderByTile, this.totalAddedHSize, this.totalAddedVSize, coordProvider, this.hAxisTheme, this.vAxisTheme) : FixedScalesTilesLayouter.INSTANCE.createTileLayoutInfos(tilesAreaSize, this.facets, this.layoutProviderByTile, this.totalAddedHSize, this.totalAddedVSize, coordProvider, this.hAxisTheme, this.vAxisTheme);
        List<Double> geomOffsetByCol = FacetedPlotLayoutUtil.INSTANCE.geomOffsetsByCol(layoutInfos, facetTiles, 10.0, this.facets.getColCount());
        List<Double> geomOffsetByRow = FacetedPlotLayoutUtil.INSTANCE.geomOffsetsByRow(layoutInfos, facetTiles, this.showFacetStrip, 10.0, this.facets.getRowCount(), (Function1<? super PlotFacets.FacetTileInfo, Double>)facetColHeadHeightGetter2);
        ArrayList<DoubleRectangle> tileBoundsList = new ArrayList<DoubleRectangle>();
        ArrayList<DoubleRectangle> geomOuterBoundsList = new ArrayList<DoubleRectangle>();
        $this$forEach$iv$iv$iv = facetTiles.iterator();
        int it222 = 0;
        while ($this$forEach$iv$iv$iv.hasNext()) {
            int index = it222++;
            PlotFacets.FacetTileInfo facetTile = $this$forEach$iv$iv$iv.next();
            TileLayoutInfo layoutInfo = layoutInfos.get(index);
            int col = facetTile.getCol();
            int row = facetTile.getRow();
            double geomX = ((Number)geomOffsetByCol.get(col)).doubleValue();
            double geomY = ((Number)geomOffsetByRow.get(row)).doubleValue();
            DoubleVector outerGeomSize = layoutInfo.getGeomOuterBounds().getDimension();
            double tileLabelWidth = facetTile.getRowLab() != null && this.showFacetStrip ? facetRowTabWidth + (double)3 : 0.0;
            double axisWidth = facetTile.getHasVAxis() ? layoutInfo.axisThicknessY() : 0.0;
            double tileX = geomX - axisWidth;
            double tileWidth = outerGeomSize.getX() + axisWidth + tileLabelWidth;
            double tileLabelHeight = this.showFacetStrip ? ((Number)facetColHeadHeightGetter2.invoke((Object)facetTile)).doubleValue() : 0.0;
            double axisHeight = facetTile.getHasHAxis() ? layoutInfo.axisThicknessX() : 0.0;
            double tileY = geomY - tileLabelHeight;
            double tileHeight = outerGeomSize.getY() + tileLabelHeight + axisHeight;
            DoubleRectangle tileBounds = new DoubleRectangle(new DoubleVector(tileX, tileY), new DoubleVector(tileWidth, tileHeight));
            DoubleRectangle geomOuterBounds = new DoubleRectangle(new DoubleVector(geomX, geomY), outerGeomSize);
            tileBoundsList.add(tileBounds);
            geomOuterBoundsList.add(geomOuterBounds);
        }
        Iterable it222 = tileBoundsList;
        boolean $i$f$reduce = false;
        Iterator iterator$iv = $this$reduce$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw new UnsupportedOperationException("Empty collection can't be reduced.");
        }
        Object accumulator$iv = iterator$iv.next();
        while (iterator$iv.hasNext()) {
            void b1;
            DoubleRectangle col = (DoubleRectangle)iterator$iv.next();
            DoubleRectangle b0 = (DoubleRectangle)accumulator$iv;
            boolean bl = false;
            accumulator$iv = b0.union((DoubleRectangle)b1);
        }
        DoubleVector tilesAreaOrigin = ((DoubleRectangle)accumulator$iv).getOrigin();
        DoubleVector originDelta = tilesAreaOrigin.negate();
        DoubleVector tilesPaddingLeftTop = this.insets.getLeftTop();
        ArrayList<TileLayoutInfo> finalLayoutInfos = new ArrayList<TileLayoutInfo>();
        accumulator$iv = facetTiles.iterator();
        int n = 0;
        while (accumulator$iv.hasNext()) {
            TileLayoutInfo tileLayoutInfo;
            int index = n++;
            PlotFacets.FacetTileInfo facetTile = (PlotFacets.FacetTileInfo)accumulator$iv.next();
            TileLayoutInfo layoutInfo = layoutInfos.get(index);
            DoubleVector geomInnerBoundsOffset = layoutInfo.getGeomInnerBounds().getOrigin().subtract(layoutInfo.getGeomOuterBounds().getOrigin());
            Object e = tileBoundsList.get(index);
            Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
            DoubleRectangle tileBounds = (DoubleRectangle)e;
            Object e2 = geomOuterBoundsList.get(index);
            Intrinsics.checkNotNullExpressionValue(e2, (String)"get(...)");
            DoubleRectangle geomOuterBounds = (DoubleRectangle)e2;
            DoubleRectangle geomInnerBounds = new DoubleRectangle(geomOuterBounds.getOrigin().add(geomInnerBoundsOffset), layoutInfo.getGeomInnerBounds().getDimension());
            TileLayoutInfo newLayoutInfo = new TileLayoutInfo(tilesPaddingLeftTop, tileBounds.add(originDelta), geomOuterBounds.add(originDelta), geomInnerBounds.add(originDelta), geomInnerBounds.add(originDelta), layoutInfo.getAxisInfos(), facetTile.getHasHAxis(), facetTile.getHasVAxis(), null, null, facetTile.getTrueIndex(), 768, null);
            ArrayList<TileLayoutInfo> arrayList = finalLayoutInfos;
            if (this.showFacetStrip) {
                Pair pair2;
                ArrayList<TileLayoutInfo> arrayList2;
                List list3 = (List)facetColTabHeights.get(facetTile.getRow());
                if (list3 == null) {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    Iterable tileX = facetTile.getColLabs();
                    arrayList2 = arrayList;
                    boolean $i$f$map = false;
                    void tileWidth = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it5;
                        String bl4 = (String)item$iv$iv;
                        object = destination$iv$iv;
                        boolean bl = false;
                        object.add(Companion.facetLabelSize((String)it5, this.facetsTheme, (Function1<? super Thickness, Double>)((Function1)doLayout.colHeights.1.1.INSTANCE)));
                    }
                    list3 = (List)destination$iv$iv;
                    arrayList = arrayList2;
                }
                List colHeights2 = list3;
                TileLayoutInfo tileLayoutInfo2 = newLayoutInfo;
                List list4 = CollectionsKt.zip((Iterable)facetTile.getColLabs(), (Iterable)colHeights2);
                if (facetTile.getRowLab() != null) {
                    void it6;
                    List list5 = list4;
                    object = tileLayoutInfo2;
                    arrayList2 = arrayList;
                    boolean bl = false;
                    Pair pair3 = TuplesKt.to((Object)it6, (Object)facetRowTabWidth);
                    arrayList = arrayList2;
                    tileLayoutInfo2 = object;
                    list4 = list5;
                    pair2 = pair3;
                } else {
                    pair2 = null;
                }
                tileLayoutInfo = tileLayoutInfo2.withFacetLabels(list4, pair2);
            } else {
                tileLayoutInfo = newLayoutInfo;
            }
            arrayList.add(tileLayoutInfo);
        }
        Insets plotInsets = new Insets(tilesPaddingLeftTop, this.insets.getRightBottom());
        return new PlotLayoutInfo((List<TileLayoutInfo>)finalLayoutInfos, plotInsets);
    }

    public static final /* synthetic */ FacetsTheme access$getFacetsTheme$p(FacetedPlotLayout $this) {
        return $this.facetsTheme;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0007\u001a\u00020\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\tJ\u001e\u0010\u0007\u001a\u00020\u00062\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\t2\u0006\u0010\f\u001a\u00020\rH\u0002J*\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\r2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00060\u0012J\u0016\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\rR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/layout/FacetedPlotLayout$Companion;", "", "()V", "FACET_PADDING", "", "PANEL_PADDING", "", "facetColHeadTotalHeight", "colLabHeights", "", "colLabs", "", "facetsTheme", "Lorg/jetbrains/letsPlot/core/plot/base/theme/FacetsTheme;", "facetLabelSize", "title", "theme", "marginSize", "Lkotlin/Function1;", "Lorg/jetbrains/letsPlot/core/plot/base/layout/Thickness;", "titleSize", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "plot-builder"})
    @SourceDebugExtension(value={"SMAP\nFacetedPlotLayout.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FacetedPlotLayout.kt\norg/jetbrains/letsPlot/core/plot/builder/layout/FacetedPlotLayout$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,267:1\n1#2:268\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final double facetLabelSize(@NotNull String title, @NotNull FacetsTheme theme2, @NotNull Function1<? super Thickness, Double> marginSize) {
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter((Object)theme2, (String)"theme");
            Intrinsics.checkNotNullParameter(marginSize, (String)"marginSize");
            return this.titleSize(title, theme2).getY() + ((Number)marginSize.invoke((Object)theme2.stripMargins())).doubleValue();
        }

        /*
         * WARNING - void declaration
         */
        private final double facetColHeadTotalHeight(List<String> colLabs, FacetsTheme facetsTheme) {
            double d;
            if (!((Collection)colLabs).isEmpty()) {
                Iterable iterable = colLabs;
                double d2 = 0.0;
                for (Object t : iterable) {
                    void it;
                    String string = (String)t;
                    double d3 = d2;
                    boolean bl = false;
                    double d4 = Companion.facetLabelSize((String)it, facetsTheme, (Function1<? super Thickness, Double>)((Function1)facetColHeadTotalHeight.1.1.INSTANCE));
                    d2 = d3 + d4;
                }
                d = d2 + (double)3;
            } else {
                d = 0.0;
            }
            return d;
        }

        /*
         * WARNING - void declaration
         */
        public final double facetColHeadTotalHeight(@NotNull List<Double> colLabHeights) {
            void var2_2;
            Intrinsics.checkNotNullParameter(colLabHeights, (String)"colLabHeights");
            double labHeight2 = CollectionsKt.sumOfDouble((Iterable)colLabHeights);
            boolean bl = false;
            return labHeight2 > 0.0 ? labHeight2 + (double)3 : var2_2;
        }

        @NotNull
        public final DoubleVector titleSize(@NotNull String title, @NotNull FacetsTheme theme2) {
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter((Object)theme2, (String)"theme");
            return PlotLayoutUtil.INSTANCE.textDimensions$plot_builder(title, PlotLabelSpecFactory.INSTANCE.facetText(theme2));
        }

        public static final /* synthetic */ double access$facetColHeadTotalHeight(Companion $this, List colLabs, FacetsTheme facetsTheme) {
            return $this.facetColHeadTotalHeight(colLabs, facetsTheme);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

