/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.vuejs.inspections;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ecmascript6.psi.JSExportAssignment;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionProperty;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.vuejs.VueBundle;
import org.jetbrains.vuejs.inspections.WrapWithFunctionFix;
import org.jetbrains.vuejs.lang.html.VueFileTypeKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u000e\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f\u00a8\u0006\r"}, d2={"Lorg/jetbrains/vuejs/inspections/DataFunctionInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "isComponent", "property", "Lcom/intellij/lang/javascript/psi/JSProperty;", "intellij.vuejs"})
public final class DataFunctionInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return (PsiElementVisitor)new JSElementVisitor(this, holder){
            final /* synthetic */ DataFunctionInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.this$0 = $receiver;
                this.$holder = $holder;
            }

            public void visitJSProperty(JSProperty node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                if (!Intrinsics.areEqual((Object)"data", (Object)node.getName()) || node.getValue() instanceof JSFunction || node.getValue() instanceof JSReferenceExpression) {
                    return;
                }
                if (this.this$0.isComponent(node)) {
                    LocalQuickFix[] localQuickFixArray;
                    if (node.getValue() instanceof JSObjectLiteralExpression) {
                        LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
                        JSExpression jSExpression = node.getValue();
                        Intrinsics.checkNotNull((Object)jSExpression);
                        localQuickFixArray2[0] = new WrapWithFunctionFix((PsiElement)jSExpression);
                        localQuickFixArray = localQuickFixArray2;
                    } else {
                        localQuickFixArray = new LocalQuickFix[]{};
                    }
                    LocalQuickFix[] quickFixes = localQuickFixArray;
                    PsiElement psiElement = node.getNameIdentifier();
                    Intrinsics.checkNotNull((Object)psiElement);
                    this.$holder.registerProblem(psiElement, VueBundle.message("vue.inspection.message.data.property.should.be.function", new Object[0]), Arrays.copyOf(quickFixes, quickFixes.length));
                }
            }

            public void visitJSFunctionProperty(JSFunctionProperty functionProperty) {
                Intrinsics.checkNotNullParameter((Object)functionProperty, (String)"functionProperty");
            }
        };
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isComponent(@NotNull JSProperty property) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        if (!(property.getParent() instanceof JSObjectLiteralExpression)) return false;
        if (!(property.getParent().getParent() instanceof JSExportAssignment)) return false;
        PsiFile psiFile = property.getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
        if (!VueFileTypeKt.isVueFile(psiFile)) return false;
        return true;
    }
}

