/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.vuejs.options;

import com.intellij.javascript.nodejs.util.NodePackageRef;
import com.intellij.lang.javascript.library.typings.TypeScriptPackageName;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerSettings;
import com.intellij.lang.typescript.compiler.ui.TypeScriptServiceRestartService;
import com.intellij.lang.typescript.lsp.ExternalDefinitionsNodePackageKt;
import com.intellij.lang.typescript.lsp.JSFrameworkLspServerDescriptorKt;
import com.intellij.openapi.components.BaseState;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.components.SimplePersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.vuejs.lang.typescript.service.VueLspServerLoader;
import org.jetbrains.vuejs.options.VueServiceSettings;
import org.jetbrains.vuejs.options.VueSettingsState;

@Service(value={Service.Level.PROJECT})
@State(name="VueSettings", storages={@Storage(value="$WORKSPACE_FILE$")})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR$\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR$\u0010\u0011\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\u00108F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R$\u0010\u0017\u001a\u00020\u00162\u0006\u0010\t\u001a\u00020\u00168F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/vuejs/options/VueSettings;", "Lcom/intellij/openapi/components/SimplePersistentStateComponent;", "Lorg/jetbrains/vuejs/options/VueSettingsState;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "value", "Lorg/jetbrains/vuejs/options/VueServiceSettings;", "serviceType", "getServiceType", "()Lorg/jetbrains/vuejs/options/VueServiceSettings;", "setServiceType", "(Lorg/jetbrains/vuejs/options/VueServiceSettings;)V", "Lcom/intellij/javascript/nodejs/util/NodePackageRef;", "packageRef", "getPackageRef", "()Lcom/intellij/javascript/nodejs/util/NodePackageRef;", "setPackageRef", "(Lcom/intellij/javascript/nodejs/util/NodePackageRef;)V", "", "useTypesFromServer", "getUseTypesFromServer", "()Z", "setUseTypesFromServer", "(Z)V", "intellij.vuejs"})
@SourceDebugExtension(value={"SMAP\nVueSettings.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VueSettings.kt\norg/jetbrains/vuejs/options/VueSettings\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,90:1\n31#2,2:91\n31#2,2:93\n*S KotlinDebug\n*F\n+ 1 VueSettings.kt\norg/jetbrains/vuejs/options/VueSettings\n*L\n42#1:91,2\n66#1:93,2\n*E\n"})
public final class VueSettings
extends SimplePersistentStateComponent<VueSettingsState> {
    @NotNull
    private final Project project;

    public VueSettings(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super((BaseState)new VueSettingsState());
        this.project = project;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final VueServiceSettings getServiceType() {
        return ((VueSettingsState)this.getState()).getInnerServiceType();
    }

    public final void setServiceType(@NotNull VueServiceSettings value) {
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        VueServiceSettings prevServiceType = ((VueSettingsState)this.getState()).getInnerServiceType();
        ((VueSettingsState)this.getState()).setInnerServiceType(value);
        if (prevServiceType != value) {
            ComponentManager $this$service$iv = (ComponentManager)this.project;
            boolean $i$f$service = false;
            Class<TypeScriptServiceRestartService> serviceClass$iv = TypeScriptServiceRestartService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            ((TypeScriptServiceRestartService)object).restartServices(TypeScriptCompilerSettings.isEffectiveUseTypesFromServer((boolean)prevServiceType.isEnabled(), (boolean)((VueSettingsState)this.getState()).getUseTypesFromServer()) != TypeScriptCompilerSettings.isEffectiveUseTypesFromServer((boolean)this.getServiceType().isEnabled(), (boolean)((VueSettingsState)this.getState()).getUseTypesFromServer()));
        }
    }

    @NotNull
    public final NodePackageRef getPackageRef() {
        return ExternalDefinitionsNodePackageKt.createPackageRef((String)((VueSettingsState)this.getState()).getPackageName(), (TypeScriptPackageName)VueLspServerLoader.INSTANCE.getPackageDescriptor().getServerPackage());
    }

    public final void setPackageRef(@NotNull NodePackageRef value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        String refText = ExternalDefinitionsNodePackageKt.extractRefText((NodePackageRef)value);
        boolean changed = !Intrinsics.areEqual((Object)((VueSettingsState)this.getState()).getPackageName(), (Object)refText);
        ((VueSettingsState)this.getState()).setPackageName(refText);
        if (changed) {
            JSFrameworkLspServerDescriptorKt.restartTypeScriptServicesAsync((Project)this.project);
        }
    }

    public final boolean getUseTypesFromServer() {
        Boolean useTypesFromServerInTests;
        Boolean bl = useTypesFromServerInTests = TypeScriptCompilerSettings.isUseTypesFromServerInTests();
        return bl != null ? bl.booleanValue() : ((VueSettingsState)this.getState()).getUseTypesFromServer();
    }

    public final void setUseTypesFromServer(boolean value) {
        boolean prevUseTypesFromServer = ((VueSettingsState)this.getState()).getUseTypesFromServer();
        ((VueSettingsState)this.getState()).setUseTypesFromServer(value);
        if (prevUseTypesFromServer != value) {
            ComponentManager $this$service$iv = (ComponentManager)this.project;
            boolean $i$f$service = false;
            Class<TypeScriptServiceRestartService> serviceClass$iv = TypeScriptServiceRestartService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            ((TypeScriptServiceRestartService)object).restartServices(TypeScriptCompilerSettings.isEffectiveUseTypesFromServer((boolean)this.getServiceType().isEnabled(), (boolean)prevUseTypesFromServer) != TypeScriptCompilerSettings.isEffectiveUseTypesFromServer((boolean)this.getServiceType().isEnabled(), (boolean)((VueSettingsState)this.getState()).getUseTypesFromServer()));
        }
    }
}

