/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.tables;

import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.jupyter.actions.utils.JupyterDebugger;
import com.intellij.jupyter.core.jupyter.connections.JupyterConnectionParameters;
import com.intellij.jupyter.core.jupyter.connections.execution.JupyterCellExecutionListener;
import com.intellij.jupyter.core.jupyter.connections.execution.MessageTracker;
import com.intellij.jupyter.core.jupyter.connections.execution.core.JupyterNotebookSession;
import com.intellij.jupyter.core.jupyter.connections.execution.notebook.JupyterRuntimeService;
import com.intellij.jupyter.core.jupyter.execution.JupyterRunningNotebookTracker;
import com.intellij.jupyter.core.jupyter.helper.JupyterEditorExtensionsKt;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterListenersKt;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterNotebook;
import com.intellij.jupyter.core.jupyter.tables.CommandOutputType;
import com.intellij.jupyter.core.jupyter.variables.common.JupyterVarsCommandExecutor;
import com.intellij.notebooks.visualization.NotebookIntervalPointer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IntellijInternalApi;
import com.intellij.scientific.tables.api.DSSessionListener;
import com.intellij.scientific.tables.api.DSTableCommandExecutor;
import com.intellij.scientific.tables.api.DescribeTableCommand;
import com.intellij.scientific.tables.api.InfoTableCommand;
import com.intellij.scientific.tables.api.SliceTableCommand;
import com.intellij.scientific.tables.api.TableCommand;
import com.intellij.scientific.tables.api.TableCommandCodeProvider;
import com.intellij.scientific.tables.api.VisualizationDataTableCommand;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.messages.MessageBus;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0017J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u0014H\u0017J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u001cH\u0007J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020 2\u0006\u0010\"\u001a\u00020\u000eH\u0016J\u0010\u0010#\u001a\u00020 2\u0006\u0010\"\u001a\u00020\u000eH\u0016J\b\u0010$\u001a\u00020 H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006%"}, d2={"Lcom/intellij/jupyter/tables/JupyterTableCommandExecutor;", "Lcom/intellij/scientific/tables/api/DSTableCommandExecutor;", "project", "Lcom/intellij/openapi/project/Project;", "notebookVirtualFile", "Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "cellPointer", "Lcom/intellij/notebooks/visualization/NotebookIntervalPointer;", "editor", "Lcom/intellij/openapi/editor/Editor;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;Lcom/intellij/notebooks/visualization/NotebookIntervalPointer;Lcom/intellij/openapi/editor/Editor;)V", "sessionListeners", "", "Lcom/intellij/scientific/tables/api/DSSessionListener;", "dataAccessorClass", "Ljava/lang/Class;", "getDataAccessorClass", "()Ljava/lang/Class;", "executeCommand", "", "tableCommand", "Lcom/intellij/scientific/tables/api/TableCommand;", "tableCommandCodeProvider", "Lcom/intellij/scientific/tables/api/TableCommandCodeProvider;", "commandCode", "commandText", "outputType", "Lcom/intellij/jupyter/core/jupyter/tables/CommandOutputType;", "isExecutionAvailable", "", "notifyAsyncOutputLoaded", "", "addSessionListener", "listener", "removeSessionListener", "restoreOutputWithoutStaticTableData", "intellij.jupyter.tables"})
public final class JupyterTableCommandExecutor
implements DSTableCommandExecutor {
    @NotNull
    private final Project project;
    @NotNull
    private final BackedNotebookVirtualFile notebookVirtualFile;
    @Nullable
    private final NotebookIntervalPointer cellPointer;
    @NotNull
    private final Editor editor;
    @NotNull
    private final List<DSSessionListener> sessionListeners;

    public JupyterTableCommandExecutor(@NotNull Project project, @NotNull BackedNotebookVirtualFile notebookVirtualFile, @Nullable NotebookIntervalPointer cellPointer, @NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)notebookVirtualFile, (String)"notebookVirtualFile");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.project = project;
        this.notebookVirtualFile = notebookVirtualFile;
        this.cellPointer = cellPointer;
        this.editor = editor;
        this.sessionListeners = new ArrayList();
        MessageBus messageBus = this.project.getMessageBus();
        Editor editor2 = this.editor;
        Intrinsics.checkNotNull((Object)editor2, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.impl.EditorImpl");
        Disposable disposable = ((EditorImpl)editor2).getDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"getDisposable(...)");
        messageBus.connect(disposable).subscribe(JupyterRunningNotebookTracker.Listener.TOPIC, (Object)new JupyterRunningNotebookTracker.Listener(){

            public void sessionStarted(JupyterConnectionParameters connParameters, String path) {
                Intrinsics.checkNotNullParameter((Object)connParameters, (String)"connParameters");
                Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            }

            public void sessionStopped(JupyterConnectionParameters connParameters, String path) {
                Intrinsics.checkNotNullParameter((Object)connParameters, (String)"connParameters");
                Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                for (DSSessionListener listener : sessionListeners) {
                    listener.sessionStopped();
                }
            }
        });
    }

    @NotNull
    public Class<?> getDataAccessorClass() {
        return JupyterTableCommandExecutor.class;
    }

    @IntellijInternalApi
    @NotNull
    public String executeCommand(@NotNull TableCommand tableCommand, @NotNull TableCommandCodeProvider tableCommandCodeProvider) {
        CommandOutputType commandOutputType;
        Intrinsics.checkNotNullParameter((Object)tableCommand, (String)"tableCommand");
        Intrinsics.checkNotNullParameter((Object)tableCommandCodeProvider, (String)"tableCommandCodeProvider");
        String commandText = tableCommandCodeProvider.getCommandCode(tableCommand);
        TableCommand tableCommand2 = tableCommand;
        if (tableCommand2 instanceof SliceTableCommand) {
            commandOutputType = CommandOutputType.DISPLAY;
        } else if (tableCommand2 instanceof DescribeTableCommand || tableCommand2 instanceof InfoTableCommand || tableCommand2 instanceof VisualizationDataTableCommand) {
            commandOutputType = CommandOutputType.STREAM;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        CommandOutputType outputType = commandOutputType;
        return this.executeCommand(commandText, outputType);
    }

    @IntellijInternalApi
    @NotNull
    public String executeCommand(@NotNull String commandCode) {
        Intrinsics.checkNotNullParameter((Object)commandCode, (String)"commandCode");
        return this.executeCommand(commandCode, CommandOutputType.STREAM);
    }

    @IntellijInternalApi
    @NotNull
    public final String executeCommand(@NotNull String commandText, @NotNull CommandOutputType outputType) {
        Intrinsics.checkNotNullParameter((Object)commandText, (String)"commandText");
        Intrinsics.checkNotNullParameter((Object)outputType, (String)"outputType");
        return JupyterVarsCommandExecutor.Companion.getInstance(this.project).executeCommands(commandText, this.notebookVirtualFile, outputType);
    }

    public boolean isExecutionAvailable() {
        if (this.project.isDisposed()) {
            return false;
        }
        return JupyterRuntimeService.Companion.getInstance(this.project).getNotebookSession(this.notebookVirtualFile) != null;
    }

    public void notifyAsyncOutputLoaded() {
        boolean executionHandled;
        ThreadingAssertions.assertEventDispatchThread();
        JupyterNotebookSession jupyterNotebookSession = JupyterRuntimeService.Companion.getInstance(this.project).getNotebookSession(this.notebookVirtualFile);
        if (jupyterNotebookSession == null) {
            return;
        }
        String sessionId = jupyterNotebookSession.getSessionId-PaPw8_s();
        MessageTracker messageTracker = MessageTracker.Companion.getInstance(this.project);
        if (this.cellPointer != null) {
            messageTracker.asyncOutputLoaded-sG23Yws(sessionId, this.cellPointer);
        }
        if ((executionHandled = messageTracker.handleExecutionFinished-d3ImeOY(sessionId, null, this.project, this.notebookVirtualFile)) && !JupyterDebugger.INSTANCE.isUnderDebugger(this.project, this.notebookVirtualFile)) {
            ((JupyterCellExecutionListener)this.project.getMessageBus().syncPublisher(JupyterCellExecutionListener.Companion.getTOPIC())).executionFinished(this.notebookVirtualFile);
        }
    }

    public void addSessionListener(@NotNull DSSessionListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.sessionListeners.add(listener);
    }

    public void removeSessionListener(@NotNull DSSessionListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.sessionListeners.remove(listener);
    }

    public void restoreOutputWithoutStaticTableData() {
        if (this.cellPointer != null) {
            JupyterListenersKt.outputUpdated((JupyterNotebook)JupyterEditorExtensionsKt.getNotebookFile((Editor)this.editor).getNotebook(), (NotebookIntervalPointer)this.cellPointer);
        }
    }
}

