/*
 * main.h --- main program.
 *
 * Copyright (c) 1997, 98, 99, 2000, 2001, 2004 by Pascal Wassong All Rights Reserved.
 *
 * Time-stamp: <2004-06-29 23:27:26 pascal>
 *
 * This file is part of Natch.
 *
 * Natch is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Natch is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef MAIN_H
#define MAIN_H

#include	<stdio.h>

#include	"types.h"

#ifndef EXTERN_MAIN
#define EXTERN_MAIN		extern

extern		piece_type_t	Type_Pieces[NOMBRE_MAXIMUM_DE_PIECES];
extern		square_t	Position_Pieces[NOMBRE_MAXIMUM_DE_PIECES];

extern		piece_type_t*	Type_Pieces_Blanches;
extern		piece_type_t*	Type_Pieces_Noires;
extern		square_t*	Position_Pieces_Blanches;
extern		square_t*	Position_Pieces_Noires;

#else /* EXTERN_MAIN */

piece_type_t	Type_Pieces[NOMBRE_MAXIMUM_DE_PIECES];
square_t	Position_Pieces[NOMBRE_MAXIMUM_DE_PIECES];

piece_type_t*	Type_Pieces_Blanches     = &Type_Pieces[INDEX_ROI_BLANC];
piece_type_t*	Type_Pieces_Noires       = &Type_Pieces[INDEX_ROI_NOIR];
square_t*	Position_Pieces_Blanches = &Position_Pieces[INDEX_ROI_BLANC];
square_t*	Position_Pieces_Noires   = &Position_Pieces[INDEX_ROI_NOIR];

#endif	/* EXTERN_MAIN */


EXTERN_MAIN		const char*	InitialePieces;

EXTERN_MAIN		square_t	Echiquier[8 * 16];

EXTERN_MAIN		bool_t		MainExplorationFlag;
EXTERN_MAIN		unsigned int	MainPrintPositionLevel;
EXTERN_MAIN		bool_t		MainVerboseFlag;
EXTERN_MAIN		bool_t		MainVisualFlag;
EXTERN_MAIN		unsigned long	MainContinueValue;
EXTERN_MAIN		unsigned int	MainStopValue;
EXTERN_MAIN		bool_t		MainBeepFlag;

/* Variables pour algo traite_nouvelle_case_interdite */
#define	MAX_NOUVELLES_CASES_INTERDITES	32
EXTERN_MAIN		unsigned int	MainLimiteTrajet;
EXTERN_MAIN		square_t	MainNouvellesCasesInterdites[
    MAX_NOUVELLES_CASES_INTERDITES ];
EXTERN_MAIN		unsigned int	MainNombreNouvellesCasesInterdites;


EXTERN_MAIN		FILE*		MainFD;
EXTERN_MAIN		long		MainExploTicks;
EXTERN_MAIN		long		MainTicks1;
EXTERN_MAIN		long		MainTicks2;

#define		CASE_OK(c)		(! ((c) & 0x88))

#endif /* MAIN_H */
