const int8 YM2413::levelScaling[16] = {
  //-6 dB/octave, -6 dB/8 units
  //input: fnumber.bits(5,8)
  0, 24, 32, 37, 40, 43, 45, 47, 48, 50, 51, 52, 53, 54, 55, 56,
};

const uint64 YM2413::envelopeSteps[17][2] = {
//{attack sequence,    decay sequence    },
  {0x0101010101010101, 0x0101010101010101},  // 4..44
  {0x0101110101011101, 0x0101110101011101},  // 5..45
  {0x0111011101110111, 0x0111011101110111},  // 6..46
  {0x0111111101111111, 0x0111111101111111},  // 7..47
  {0x1111111111111111, 0x0101010101010101},  //48
  {0x1121112111211121, 0x0101110101011101},  //49
  {0x1212121212121212, 0x0111011101110111},  //50
  {0x1222122212221222, 0x0111111101111111},  //51
  {0x2222222222222222, 0x0101010101010101},  //52
  {0x2242224222422242, 0x0101010111110101},  //53
  {0x2424242424242424, 0x0101111101011111},  //54
  {0x2444244424442444, 0x0101111111111111},  //55
  {0x4444444444444444, 0x1111111111111111},  //56
  {0x4484448444844484, 0x1111111122221111},  //57
  {0x4848484848484848, 0x1111222211112222},  //58
  {0x4888488848884888, 0x1111222222222222},  //59
  {0x0000000000000000, 0x2222222222222222},  //60+
};

/* these are approximations and are not hardware accurate */

const uint8 YM2413::melodicTonesOPLL[15][8] = {
  {0x61, 0x61, 0x1e, 0x17, 0xf0, 0x78, 0x00, 0x17},
  {0x13, 0x41, 0x1e, 0x0d, 0xd7, 0xf7, 0x13, 0x13},
  {0x13, 0x01, 0x99, 0x04, 0xf2, 0xf4, 0x11, 0x23},
  {0x21, 0x61, 0x1b, 0x07, 0xaf, 0x64, 0x40, 0x27},
  {0x22, 0x21, 0x1e, 0x06, 0xf0, 0x75, 0x08, 0x18},
  {0x31, 0x22, 0x16, 0x05, 0x90, 0x71, 0x00, 0x13},
  {0x21, 0x61, 0x1d, 0x07, 0x82, 0x80, 0x10, 0x17},
  {0x23, 0x21, 0x2d, 0x16, 0xc0, 0x70, 0x07, 0x07},
  {0x61, 0x61, 0x1b, 0x06, 0x64, 0x65, 0x10, 0x17},
  {0x61, 0x61, 0x0c, 0x18, 0x85, 0xf0, 0x70, 0x07},
  {0x23, 0x01, 0x07, 0x11, 0xf0, 0xa4, 0x00, 0x22},
  {0x97, 0xc1, 0x24, 0x07, 0xff, 0xf8, 0x22, 0x12},
  {0x61, 0x10, 0x0c, 0x05, 0xf2, 0xf4, 0x40, 0x44},
  {0x01, 0x01, 0x55, 0x03, 0xf3, 0x92, 0xf3, 0xf3},
  {0x61, 0x41, 0x89, 0x03, 0xf1, 0xf4, 0xf0, 0x13},
};

const uint8 YM2413::rhythmTonesOPLL[3][8] = {
  {0x01, 0x01, 0x16, 0x00, 0xfd, 0xf8, 0x2f, 0x6d},
  {0x01, 0x01, 0x00, 0x00, 0xd8, 0xd8, 0xf9, 0xf8},
  {0x05, 0x01, 0x00, 0x00, 0xf8, 0xba, 0x49, 0x55},
};

/* these tables were extracted from the VRC7 debug mode: likely inaccurate for the YM2413 */

const uint8 YM2413::melodicTonesVRC7[15][8] = {
  {0x03, 0x21, 0x05, 0x06, 0xe8, 0x81, 0x42, 0x27},  //1: violin
  {0x13, 0x41, 0x14, 0x0d, 0xd8, 0xf6, 0x23, 0x12},  //2: guitar
  {0x11, 0x11, 0x08, 0x08, 0xfa, 0xb2, 0x20, 0x12},  //3: piano
  {0x31, 0x61, 0x0c, 0x07, 0xa8, 0x64, 0x61, 0x27},  //4: flute
  {0x32, 0x21, 0x1e, 0x06, 0xe1, 0x76, 0x01, 0x28},  //5: clarinet
  {0x02, 0x01, 0x06, 0x00, 0xa3, 0xe2, 0xf4, 0xf4},  //6: oboe
  {0x21, 0x61, 0x1d, 0x07, 0x82, 0x81, 0x11, 0x07},  //7: trumpet
  {0x23, 0x21, 0x22, 0x17, 0xa2, 0x72, 0x01, 0x17},  //8: organ
  {0x35, 0x11, 0x25, 0x00, 0x40, 0x73, 0x72, 0x01},  //9: horn
  {0xb5, 0x01, 0x0f, 0x0f, 0xa8, 0xa5, 0x51, 0x02},  //a: synthesizer
  {0x17, 0xc1, 0x24, 0x07, 0xf8, 0xf8, 0x22, 0x12},  //b: harpischord
  {0x71, 0x23, 0x11, 0x06, 0x65, 0x74, 0x18, 0x16},  //c: vibraphone
  {0x01, 0x02, 0xd3, 0x05, 0xc9, 0x95, 0x03, 0x02},  //d: synthesizer bass
  {0x61, 0x63, 0x0c, 0x00, 0x94, 0xc0, 0x33, 0xf6},  //e: acoustic bass
  {0x21, 0x72, 0x0d, 0x00, 0xc1, 0xd5, 0x56, 0x06},  //f: electric guitar
};

const uint8 YM2413::rhythmTonesVRC7[3][8] = {
  {0x01, 0x01, 0x18, 0x0f, 0xdf, 0xf8, 0x6a, 0x6d},  //7, 13/16: bass drum
  {0x01, 0x01, 0x00, 0x00, 0xc8, 0xd8, 0xa7, 0x68},  //8, 14/17: hihat, snare drum
  {0x05, 0x01, 0x00, 0x00, 0xf8, 0xaa, 0x59, 0x55},  //9, 15/18: tomtom, top cymbal
};

uint13 YM2413::sinTable[1 << 10];
 int12 YM2413::expTable[1 <<  9];
