/*
 * Decompiled with CFR 0.152.
 */
package com.android.utils;

import com.android.utils.TokenizedCommandLine;
import com.google.common.base.CharMatcher;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, xi=48, d1={"\u0000N\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\n\n\u0002\u0010\u001c\n\u0002\b\u0006\u001a.\u0010\u0005\u001a\u00020\u0006\"\u0004\b\u0000\u0010\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00070\t2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u0002H\u0007\u0012\u0004\u0012\u00020\u00060\u000b\u001a:\u0010\u0005\u001a\u00020\f\"\u0004\b\u0000\u0010\u00072\n\u0010\r\u001a\u00060\u000ej\u0002`\u000f2\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00070\t2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u0002H\u0007\u0012\u0004\u0012\u00020\u00060\u000b\u001a\u0018\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0006H\u0002\u001a%\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00060\u00142\u0012\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00170\u0016\"\u00020\u0017\u00a2\u0006\u0002\u0010\u0018\u001a\u001a\u0010\u0019\u001a\u00060\u000ej\u0002`\u000f*\u00060\u000ej\u0002`\u000f2\u0006\u0010\u001a\u001a\u00020\u0006\u001a#\u0010\u001b\u001a\u00020\u0006*\u00020\u00062\u0012\u0010\u001c\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0016\"\u00020\u0006\u00a2\u0006\u0002\u0010\u001d\u001a\u0012\u0010\u001b\u001a\u00020\u0006*\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u0006\u001a\u001a\u0010\u001b\u001a\u00020\u0006*\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020\u0006\u001a\u001a\u0010\u001b\u001a\u00060\u000ej\u0002`\u000f*\u00060\u000ej\u0002`\u000f2\u0006\u0010\u001a\u001a\u00020\u0006\u001a\u0012\u0010 \u001a\u00020\u0006*\u00020\u00062\u0006\u0010!\u001a\u00020\u0006\u001a\u0010\u0010\u0005\u001a\u00020\u0006*\b\u0012\u0004\u0012\u00020\u00060\"\u001a\n\u0010#\u001a\u00020\u0006*\u00020\u0006\u001a\u0010\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00060\u0014*\u00020\u0006\u001a\u0010\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00060\u0014*\u00020\u0006\u001a\n\u0010&\u001a\u00020\u0006*\u00020\u0006\u001a\n\u0010'\u001a\u00020\u0006*\u00020\u0006\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0003\u001a\n \u0002*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"CR", "Lcom/google/common/base/CharMatcher;", "kotlin.jvm.PlatformType", "LF", "Ljava/util/regex/Pattern;", "combineAsCamelCase", "", "T", "objectList", "", "mapFunction", "Lkotlin/Function1;", "", "sb", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "toLineSeparator", "separator", "input", "toStrings", "", "objects", "", "", "([Ljava/lang/Object;)Ljava/util/List;", "appendCamelCase", "word", "appendCapitalized", "words", "(Ljava/lang/String;[Ljava/lang/String;)Ljava/lang/String;", "word1", "word2", "capitalizeAndAppend", "suffix", "", "toSystemLineSeparator", "tokenizeCommandLineToEscaped", "tokenizeCommandLineToRaw", "usLocaleCapitalize", "usLocaleDecapitalize", "common"})
@JvmName(name="StringHelper")
public final class StringHelper {
    private static final CharMatcher CR = CharMatcher.is('\r');
    private static final Pattern LF = Pattern.compile("\n", 16);

    @NotNull
    public static final StringBuilder appendCapitalized(@NotNull StringBuilder $this$appendCapitalized, @NotNull String word) {
        Intrinsics.checkParameterIsNotNull($this$appendCapitalized, "<this>");
        Intrinsics.checkParameterIsNotNull(word, "word");
        CharSequence charSequence = word;
        boolean bl2 = false;
        if (charSequence.length() == 0) {
            return $this$appendCapitalized;
        }
        int c11 = word.charAt(0);
        if (c11 >= 55296 && c11 <= 56319) {
            String string = word;
            int n11 = 0;
            boolean bl3 = false;
            c11 = string.codePointAt(n11);
            int charCount = Character.charCount(c11);
            String string2 = word;
            int n12 = 0;
            boolean bl4 = false;
            String string3 = string2.substring(n12, charCount);
            Intrinsics.checkNotNullExpressionValue(string3, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            string2 = string3;
            Locale locale = Locale.US;
            Intrinsics.checkExpressionValueIsNotNull(locale, "US");
            bl4 = false;
            String string4 = string2;
            boolean bl5 = false;
            String string5 = string4;
            if (string5 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string6 = string5.toUpperCase(locale);
            Intrinsics.checkNotNullExpressionValue(string6, "(this as java.lang.String).toUpperCase(locale)");
            String upperString = string6;
            $this$appendCapitalized.append(upperString);
            $this$appendCapitalized.append(word, charCount, word.length());
        } else {
            char c12;
            int result = Character.toUpperCase(c11);
            char upperChar = '\u0000';
            if (result != -1) {
                c12 = (char)result;
            } else {
                String string = word;
                int n13 = 0;
                int n14 = 1;
                boolean bl6 = false;
                String string7 = string.substring(n13, n14);
                Intrinsics.checkNotNullExpressionValue(string7, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                string = string7;
                Locale locale = Locale.US;
                Intrinsics.checkExpressionValueIsNotNull(locale, "US");
                n14 = 0;
                String string8 = string;
                boolean bl7 = false;
                String string9 = string8;
                if (string9 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string10 = string9.toUpperCase(locale);
                Intrinsics.checkNotNullExpressionValue(string10, "(this as java.lang.String).toUpperCase(locale)");
                c12 = string10.charAt(0);
            }
            upperChar = c12;
            $this$appendCapitalized.append(upperChar);
            $this$appendCapitalized.append(word, 1, word.length());
        }
        return $this$appendCapitalized;
    }

    @NotNull
    public static final String usLocaleCapitalize(@NotNull String $this$usLocaleCapitalize) {
        Intrinsics.checkParameterIsNotNull($this$usLocaleCapitalize, "<this>");
        StringBuilder sb2 = new StringBuilder($this$usLocaleCapitalize.length());
        StringHelper.appendCapitalized(sb2, $this$usLocaleCapitalize);
        String string = sb2.toString();
        Intrinsics.checkExpressionValueIsNotNull(string, "sb.toString()");
        return string;
    }

    @NotNull
    public static final String usLocaleDecapitalize(@NotNull String $this$usLocaleDecapitalize) {
        Intrinsics.checkParameterIsNotNull($this$usLocaleDecapitalize, "<this>");
        CharSequence charSequence = $this$usLocaleDecapitalize;
        boolean bl2 = false;
        if (charSequence.length() == 0) {
            return $this$usLocaleDecapitalize;
        }
        StringBuilder sb2 = new StringBuilder($this$usLocaleDecapitalize.length());
        String string = $this$usLocaleDecapitalize;
        int n11 = 0;
        int n12 = 1;
        boolean bl3 = false;
        String string2 = string.substring(n11, n12);
        Intrinsics.checkNotNullExpressionValue(string2, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        string = string2;
        Locale locale = Locale.US;
        Intrinsics.checkExpressionValueIsNotNull(locale, "US");
        n12 = 0;
        String string3 = string;
        boolean bl4 = false;
        String string4 = string3;
        if (string4 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string5 = string4.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue(string5, "(this as java.lang.String).toLowerCase(locale)");
        sb2.append(string5);
        string = $this$usLocaleDecapitalize;
        int n13 = 1;
        n12 = 0;
        String string6 = string.substring(n13);
        Intrinsics.checkNotNullExpressionValue(string6, "(this as java.lang.String).substring(startIndex)");
        sb2.append(string6);
        string = sb2.toString();
        Intrinsics.checkExpressionValueIsNotNull(string, "sb.toString()");
        return string;
    }

    @NotNull
    public static final String appendCapitalized(@NotNull String $this$appendCapitalized, @NotNull String word) {
        Intrinsics.checkParameterIsNotNull($this$appendCapitalized, "<this>");
        Intrinsics.checkParameterIsNotNull(word, "word");
        StringBuilder sb2 = new StringBuilder($this$appendCapitalized.length() + word.length());
        sb2.append($this$appendCapitalized);
        StringHelper.appendCapitalized(sb2, word);
        String string = sb2.toString();
        Intrinsics.checkExpressionValueIsNotNull(string, "sb.toString()");
        return string;
    }

    @NotNull
    public static final String appendCapitalized(@NotNull String $this$appendCapitalized, @NotNull String word1, @NotNull String word2) {
        Intrinsics.checkParameterIsNotNull($this$appendCapitalized, "<this>");
        Intrinsics.checkParameterIsNotNull(word1, "word1");
        Intrinsics.checkParameterIsNotNull(word2, "word2");
        StringBuilder sb2 = new StringBuilder($this$appendCapitalized.length() + word1.length() + word2.length());
        sb2.append($this$appendCapitalized);
        StringHelper.appendCapitalized(sb2, word1);
        StringHelper.appendCapitalized(sb2, word2);
        String string = sb2.toString();
        Intrinsics.checkExpressionValueIsNotNull(string, "sb.toString()");
        return string;
    }

    @NotNull
    public static final String appendCapitalized(@NotNull String $this$appendCapitalized, String ... words) {
        Intrinsics.checkParameterIsNotNull($this$appendCapitalized, "<this>");
        Intrinsics.checkParameterIsNotNull(words, "words");
        int length = $this$appendCapitalized.length();
        int i11 = 0;
        int max = words.length;
        while (i11 < max) {
            length += words[i11].length();
            int n11 = i11;
            i11 = n11 + 1;
        }
        StringBuilder sb2 = new StringBuilder(length);
        sb2.append($this$appendCapitalized);
        for (String word : words) {
            StringHelper.appendCapitalized(sb2, word);
        }
        String string = sb2.toString();
        Intrinsics.checkExpressionValueIsNotNull(string, "sb.toString()");
        return string;
    }

    @NotNull
    public static final String capitalizeAndAppend(@NotNull String $this$capitalizeAndAppend, @NotNull String suffix) {
        Intrinsics.checkParameterIsNotNull($this$capitalizeAndAppend, "<this>");
        Intrinsics.checkParameterIsNotNull(suffix, "suffix");
        StringBuilder sb2 = new StringBuilder($this$capitalizeAndAppend.length() + suffix.length());
        StringHelper.appendCapitalized(sb2, $this$capitalizeAndAppend);
        sb2.append(suffix);
        String string = sb2.toString();
        Intrinsics.checkExpressionValueIsNotNull(string, "sb.toString()");
        return string;
    }

    @NotNull
    public static final StringBuilder appendCamelCase(@NotNull StringBuilder $this$appendCamelCase, @NotNull String word) {
        Intrinsics.checkParameterIsNotNull($this$appendCamelCase, "<this>");
        Intrinsics.checkParameterIsNotNull(word, "word");
        CharSequence charSequence = $this$appendCamelCase;
        boolean bl2 = false;
        if (charSequence.length() == 0) {
            $this$appendCamelCase.append(word);
        } else {
            StringHelper.appendCapitalized($this$appendCamelCase, word);
        }
        return $this$appendCamelCase;
    }

    @NotNull
    public static final String combineAsCamelCase(@NotNull Iterable<String> $this$combineAsCamelCase) {
        Intrinsics.checkParameterIsNotNull($this$combineAsCamelCase, "<this>");
        int count = 0;
        for (String s11 : $this$combineAsCamelCase) {
            count += s11.length();
        }
        StringBuilder sb2 = new StringBuilder(count);
        boolean first = true;
        for (String str : $this$combineAsCamelCase) {
            if (first) {
                sb2.append(str);
                first = false;
                continue;
            }
            StringHelper.appendCapitalized(sb2, str);
        }
        String string = sb2.toString();
        Intrinsics.checkExpressionValueIsNotNull(string, "sb.toString()");
        return string;
    }

    @NotNull
    public static final <T> String combineAsCamelCase(@NotNull Collection<? extends T> objectList, @NotNull Function1<? super T, String> mapFunction) {
        Intrinsics.checkParameterIsNotNull(objectList, "objectList");
        Intrinsics.checkParameterIsNotNull(mapFunction, "mapFunction");
        StringBuilder sb2 = new StringBuilder(objectList.size() * 20);
        StringHelper.combineAsCamelCase(sb2, objectList, mapFunction);
        String string = sb2.toString();
        Intrinsics.checkExpressionValueIsNotNull(string, "sb.toString()");
        return string;
    }

    public static final <T> void combineAsCamelCase(@NotNull StringBuilder sb2, @NotNull Collection<? extends T> objectList, @NotNull Function1<? super T, String> mapFunction) {
        Intrinsics.checkParameterIsNotNull(sb2, "sb");
        Intrinsics.checkParameterIsNotNull(objectList, "objectList");
        Intrinsics.checkParameterIsNotNull(mapFunction, "mapFunction");
        boolean first = true;
        for (T obj : objectList) {
            if (first) {
                sb2.append(mapFunction.invoke(obj));
                first = false;
                continue;
            }
            StringHelper.appendCapitalized(sb2, mapFunction.invoke(obj));
        }
    }

    @NotNull
    public static final List<String> toStrings(Object ... objects) {
        Intrinsics.checkParameterIsNotNull(objects, "objects");
        ImmutableList.Builder builder = ImmutableList.builder();
        Object object = objects;
        int n11 = 0;
        int n12 = ((Object[])object).length;
        while (n11 < n12) {
            Object path = object[n11];
            ++n11;
            if (path instanceof String) {
                builder.add(path);
                continue;
            }
            if (path instanceof Collection) {
                for (Object item : (Collection)path) {
                    if (item instanceof String) {
                        builder.add(item);
                        continue;
                    }
                    builder.add(path.toString());
                }
                continue;
            }
            builder.add(path.toString());
        }
        object = builder.build();
        Intrinsics.checkExpressionValueIsNotNull(object, "builder.build()");
        return (List)object;
    }

    @NotNull
    public static final List<String> tokenizeCommandLineToEscaped(@NotNull String $this$tokenizeCommandLineToEscaped) {
        Intrinsics.checkParameterIsNotNull($this$tokenizeCommandLineToEscaped, "<this>");
        return new TokenizedCommandLine($this$tokenizeCommandLineToEscaped, false, 0, null, 12, null).toTokenList();
    }

    @NotNull
    public static final List<String> tokenizeCommandLineToRaw(@NotNull String $this$tokenizeCommandLineToRaw) {
        Intrinsics.checkParameterIsNotNull($this$tokenizeCommandLineToRaw, "<this>");
        return new TokenizedCommandLine($this$tokenizeCommandLineToRaw, true, 0, null, 12, null).toTokenList();
    }

    @NotNull
    public static final String toSystemLineSeparator(@NotNull String $this$toSystemLineSeparator) {
        Intrinsics.checkParameterIsNotNull($this$toSystemLineSeparator, "<this>");
        String string = System.lineSeparator();
        Intrinsics.checkExpressionValueIsNotNull(string, "lineSeparator()");
        return StringHelper.toLineSeparator(string, $this$toSystemLineSeparator);
    }

    private static final String toLineSeparator(String separator, String input) {
        String string;
        String unixStyle;
        String string2 = unixStyle = CR.matchesAnyOf(input) ? CR.removeFrom(input) : input;
        if (Intrinsics.areEqual(separator, "\n")) {
            Intrinsics.checkExpressionValueIsNotNull(unixStyle, "unixStyle");
            string = unixStyle;
        } else {
            String string3 = LF.matcher(unixStyle).replaceAll("\r\n");
            Intrinsics.checkExpressionValueIsNotNull(string3, "LF.matcher(unixStyle).replaceAll(\"\\r\\n\")");
            string = string3;
        }
        return string;
    }
}

