#include "gimme_config_h.h"

#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif

#ifdef HAVE_STRING_H
#include <string.h>
#endif

#ifdef HAVE_STDIO_H
#include <stdio.h>
#endif

#ifdef HAVE_SYS_TYPES_H
#include <sys/types.h>
#endif

#ifdef HAVE_SYS_SOCKET_H
#include <sys/socket.h>
#endif

#ifdef HAVE_LINUX_CDROM_H
#include <linux/cdrom.h>
#else
#ifndef CD_FRAMES
#define CD_FRAMES 75
#endif
#endif

#include "cddb_perform_lookup.h"
#include "cddb_hearken.h"
#include "cdstatus_cddb.h"
#include "cddb_send.h"
#include "cdstatus_output.h"

int cddbPerformLookup(int client_sock, void * buffer, void * scratchbuffer, unsigned int discid, unsigned int tracks, const cd_toc_info * cdtocinfo, char *category, unsigned int first_inexact)
{
	char *token;
	int result;
	unsigned int index;

	memset(buffer, 0, BUFFSIZE);
	(void)snprintf((char *) buffer, BUFFSIZE-1, "cddb query %08x %u", discid, tracks);
	for (index = 1; index <= tracks; ++index)
	{
		(void)snprintf(scratchbuffer, SCRATCHBUFFER_SIZE-1, " %u", cdtocinfo[index].frame_global);
		strncat((char *) buffer, scratchbuffer, (sizeof(buffer)-strlen(buffer))-1);
	} 
	(void)snprintf(scratchbuffer, SCRATCHBUFFER_SIZE-1, " %u\n", cdtocinfo[0].frame_global / CD_FRAMES);
	strncat((char *) buffer, scratchbuffer, (sizeof(buffer)-strlen(buffer))-1);
	cddb_send(client_sock, buffer);
	result = hearken(client_sock, buffer);
	switch (result)
	{
	case 200:
		conditional_printf(NORMAL, "Found exact match: %s\n", (char *) buffer);
		token = strtok((char *) buffer, " ");
		token = strtok(NULL, " ");
		if(token==NULL)
		{
			conditional_puts(WARNING, "Received invalid response from cddb server, aborting.\n");
			return 0;
		}
		strncpy(category, token, 64);
		token = strtok(NULL, " ");
		if(token==NULL)
		{
			conditional_puts(WARNING, "Error, invalid response received from cddb server");
			return 0;
		}
		if(sscanf(token, "%x", &discid)!=1)
		{
			conditional_puts(WARNING, "Error parsing cddb server response or invalid response. Exiting.");
			return 0;
		}
		break;
	case 211:
		conditional_puts(CRITICAL, "Found several inexact matches.");
		if (first_inexact==0)
		{
			conditional_puts(CRITICAL, "Please select a number from the list below.");
		}
		else
		{
			conditional_puts(NORMAL, "Defaulting to first match.");
		}
		break;
	case 210:
		conditional_puts(NORMAL, "Found more than one exact match.");
		if (first_inexact==0)
		{
			conditional_puts(CRITICAL, "Please select a number from the list below.");
		}
		else
		{
			conditional_puts(NORMAL, "Defaulting to first match.");
		}
		break;
	case 202:
		conditional_puts(WARNING, "No match was found.  Please note that cdstatus does not currently support cddb entry submission.  Exiting.");
		return 0;
	case 403:
		conditional_puts(WARNING, "The server reports that this database entry is corrupt. This is an ugly and unfortunate server-side error.  Exiting");
		return 0;
	case 409:
		conditional_puts(CRITICAL, "The server is being either forgetful or haughty.  Then again, it's probably just broken.  Try a different server.");
		return 0;
	default:
		conditional_puts(CRITICAL, "The server has responded with an invalid/undocumented response code that is not part of the spec.  Exiting.");
		return 0;
	}
	return result;
}
