/*
   Copyright (C) 2004 by James Gregory
   Part of the GalaxyHack project

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License.
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY.

   See the COPYING file for more details.
*/

#ifndef GUARD_LookupTables
#define GUARD_LookupTables

#include "RTSStructs.h"
#include "Stuff.h"

#include <iterator>
#include <sstream>

using std::istringstream;

class OptionSkipIter: public std::istreambuf_iterator<char> {
public:
	OptionSkipIter(): std::istreambuf_iterator<char>() {}
	OptionSkipIter(std::istringstream& is): std::istreambuf_iterator<char>(is) {}
	
	void PlusPlusSS() {++(*this); SkipSpace();}
	void EqualsSS(std::istringstream& is) {*this = OptionSkipIter(is); SkipSpace();}

private:
	void SkipSpace() {while ((*this) != OptionSkipIter() && isspace(*(*this))) ++(*this);}
};

void SetupLookupTables();

void FillWeaponValues(WeaponType i, WindowChoice j, istringstream& input, OptionSkipIter& iter, const OptionSkipIter& fileEnd);
void FillEquipValues(int i, WindowChoice j, istringstream& input, OptionSkipIter& iter, const OptionSkipIter& fileEnd);

void SkipToNextSection(istringstream& input, OptionSkipIter& iter, const OptionSkipIter& fileEnd);

#endif


