/*
   Copyright (C) 2004 by James Gregory
   Part of the GalaxyHack project
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License.
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY.
 
   See the COPYING file for more details.
*/

#include "Stuff.h"
#include "Globals.h"

#include <string>

using std::string;

//0 is ended, 1 is keep going, -1 is escaped,
int StringInput(SDL_keysym& keysym, string& giveString, int maxLength) {
	if (keysym.sym == SDLK_ESCAPE)
		return -1;

	else if (keysym.sym == SDLK_RETURN)
		return 0;

	else if (keysym.sym == SDLK_BACKSPACE) {
		if (giveString.size() != 0)
			giveString.erase(--giveString.end());
	}
	else if (giveString.size() < maxLength) {
		if ((keysym.unicode & 0x7F) != 0) {
			giveString += keysym.unicode & 0x7F;

			char newestChar = giveString[giveString.size() -1];
			//throw away characters we are unable to display, they may cause blit string to crash
			if (normalFonts.fontLookup.find(newestChar) == normalFonts.fontLookup.end() && newestChar != ' ')
				giveString.erase(--giveString.end());

			//FIXME: doesn't work for non alpha characters, but then again it is only needed at all when using dga video driver
			else if (keysym.mod == KMOD_LSHIFT
			         || keysym.mod == KMOD_RSHIFT
			         || keysym.mod == KMOD_CAPS) {
				int endChar = giveString.size() - 1;
				giveString[endChar] = toupper(giveString[endChar]);
			}
		}
	}

	return 1;
}


