/*This file contains the colorlist class, to save a list of
  RGB colors to exclude from the motion check*/

/*Maybe i should be proud of this, this is a classical!
  I always said "Who needs C++?"
  >;>>> */

struct colorlist;
/*The structure colorlist, public for pointers, members are private*/

struct colorlist* colorlist_new();
/*A constructor, NULL on failure*/

int colorlist_remcolor (struct colorlist* list,int color);
/*Removes a color from the list, 0 on success, 1 on not found, -1 on error*/

int colorlist_kill(struct colorlist* list);
/*A destructor*/

int colorlist_setcolor (struct colorlist* list,int color,int red, int green, int blue, int width);
/*Sets a color on the list to specified value
  0 added, 1, changed, -1 error
*/

int colorlist_addcolor (struct colorlist* list,int red, int green, int blue, int width);
/*Adds a color to the end of the list
  0 success, -1 error
*/

int colorlist_getvalue (struct colorlist* list, int red, int green, int blue);
/*Gives back the alphablend value of a color.
  This has to do with color exclusion. if the specified color is "near" a
  "excluded color" (within "width") this will be close to 0 to let the
  caller know to ignore this color.
  if the color in not near any of the excluded, it has to be calculated and
  this value is up to 255 */


