// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package comprehend

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opBatchDetectDominantLanguage = "BatchDetectDominantLanguage"

// BatchDetectDominantLanguageRequest generates a "aws/request.Request" representing the
// client's request for the BatchDetectDominantLanguage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchDetectDominantLanguage for more information on using the BatchDetectDominantLanguage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchDetectDominantLanguageRequest method.
//    req, resp := client.BatchDetectDominantLanguageRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/BatchDetectDominantLanguage
func (c *Comprehend) BatchDetectDominantLanguageRequest(input *BatchDetectDominantLanguageInput) (req *request.Request, output *BatchDetectDominantLanguageOutput) {
	op := &request.Operation{
		Name:       opBatchDetectDominantLanguage,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchDetectDominantLanguageInput{}
	}

	output = &BatchDetectDominantLanguageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchDetectDominantLanguage API operation for Amazon Comprehend.
//
// Determines the dominant language of the input text for a batch of documents.
// For a list of languages that Amazon Comprehend can detect, see Amazon Comprehend
// Supported Languages (https://docs.aws.amazon.com/comprehend/latest/dg/how-languages.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation BatchDetectDominantLanguage for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is invalid.
//
//   * TextSizeLimitExceededException
//   The size of the input text exceeds the limit. Use a smaller document.
//
//   * BatchSizeLimitExceededException
//   The number of documents in the request exceeds the limit of 25. Try your
//   request again with fewer documents.
//
//   * InternalServerException
//   An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/BatchDetectDominantLanguage
func (c *Comprehend) BatchDetectDominantLanguage(input *BatchDetectDominantLanguageInput) (*BatchDetectDominantLanguageOutput, error) {
	req, out := c.BatchDetectDominantLanguageRequest(input)
	return out, req.Send()
}

// BatchDetectDominantLanguageWithContext is the same as BatchDetectDominantLanguage with the addition of
// the ability to pass a context and additional request options.
//
// See BatchDetectDominantLanguage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) BatchDetectDominantLanguageWithContext(ctx aws.Context, input *BatchDetectDominantLanguageInput, opts ...request.Option) (*BatchDetectDominantLanguageOutput, error) {
	req, out := c.BatchDetectDominantLanguageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchDetectEntities = "BatchDetectEntities"

// BatchDetectEntitiesRequest generates a "aws/request.Request" representing the
// client's request for the BatchDetectEntities operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchDetectEntities for more information on using the BatchDetectEntities
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchDetectEntitiesRequest method.
//    req, resp := client.BatchDetectEntitiesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/BatchDetectEntities
func (c *Comprehend) BatchDetectEntitiesRequest(input *BatchDetectEntitiesInput) (req *request.Request, output *BatchDetectEntitiesOutput) {
	op := &request.Operation{
		Name:       opBatchDetectEntities,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchDetectEntitiesInput{}
	}

	output = &BatchDetectEntitiesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchDetectEntities API operation for Amazon Comprehend.
//
// Inspects the text of a batch of documents for named entities and returns
// information about them. For more information about named entities, see how-entities
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation BatchDetectEntities for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is invalid.
//
//   * TextSizeLimitExceededException
//   The size of the input text exceeds the limit. Use a smaller document.
//
//   * UnsupportedLanguageException
//   Amazon Comprehend can't process the language of the input text. For all custom
//   entity recognition APIs (such as CreateEntityRecognizer), only English, Spanish,
//   French, Italian, German, or Portuguese are accepted. For most other APIs,
//   such as those for Custom Classification, Amazon Comprehend accepts text in
//   all supported languages. For a list of supported languages, see supported-languages.
//
//   * BatchSizeLimitExceededException
//   The number of documents in the request exceeds the limit of 25. Try your
//   request again with fewer documents.
//
//   * InternalServerException
//   An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/BatchDetectEntities
func (c *Comprehend) BatchDetectEntities(input *BatchDetectEntitiesInput) (*BatchDetectEntitiesOutput, error) {
	req, out := c.BatchDetectEntitiesRequest(input)
	return out, req.Send()
}

// BatchDetectEntitiesWithContext is the same as BatchDetectEntities with the addition of
// the ability to pass a context and additional request options.
//
// See BatchDetectEntities for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) BatchDetectEntitiesWithContext(ctx aws.Context, input *BatchDetectEntitiesInput, opts ...request.Option) (*BatchDetectEntitiesOutput, error) {
	req, out := c.BatchDetectEntitiesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchDetectKeyPhrases = "BatchDetectKeyPhrases"

// BatchDetectKeyPhrasesRequest generates a "aws/request.Request" representing the
// client's request for the BatchDetectKeyPhrases operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchDetectKeyPhrases for more information on using the BatchDetectKeyPhrases
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchDetectKeyPhrasesRequest method.
//    req, resp := client.BatchDetectKeyPhrasesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/BatchDetectKeyPhrases
func (c *Comprehend) BatchDetectKeyPhrasesRequest(input *BatchDetectKeyPhrasesInput) (req *request.Request, output *BatchDetectKeyPhrasesOutput) {
	op := &request.Operation{
		Name:       opBatchDetectKeyPhrases,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchDetectKeyPhrasesInput{}
	}

	output = &BatchDetectKeyPhrasesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchDetectKeyPhrases API operation for Amazon Comprehend.
//
// Detects the key noun phrases found in a batch of documents.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation BatchDetectKeyPhrases for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is invalid.
//
//   * TextSizeLimitExceededException
//   The size of the input text exceeds the limit. Use a smaller document.
//
//   * UnsupportedLanguageException
//   Amazon Comprehend can't process the language of the input text. For all custom
//   entity recognition APIs (such as CreateEntityRecognizer), only English, Spanish,
//   French, Italian, German, or Portuguese are accepted. For most other APIs,
//   such as those for Custom Classification, Amazon Comprehend accepts text in
//   all supported languages. For a list of supported languages, see supported-languages.
//
//   * BatchSizeLimitExceededException
//   The number of documents in the request exceeds the limit of 25. Try your
//   request again with fewer documents.
//
//   * InternalServerException
//   An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/BatchDetectKeyPhrases
func (c *Comprehend) BatchDetectKeyPhrases(input *BatchDetectKeyPhrasesInput) (*BatchDetectKeyPhrasesOutput, error) {
	req, out := c.BatchDetectKeyPhrasesRequest(input)
	return out, req.Send()
}

// BatchDetectKeyPhrasesWithContext is the same as BatchDetectKeyPhrases with the addition of
// the ability to pass a context and additional request options.
//
// See BatchDetectKeyPhrases for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) BatchDetectKeyPhrasesWithContext(ctx aws.Context, input *BatchDetectKeyPhrasesInput, opts ...request.Option) (*BatchDetectKeyPhrasesOutput, error) {
	req, out := c.BatchDetectKeyPhrasesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchDetectSentiment = "BatchDetectSentiment"

// BatchDetectSentimentRequest generates a "aws/request.Request" representing the
// client's request for the BatchDetectSentiment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchDetectSentiment for more information on using the BatchDetectSentiment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchDetectSentimentRequest method.
//    req, resp := client.BatchDetectSentimentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/BatchDetectSentiment
func (c *Comprehend) BatchDetectSentimentRequest(input *BatchDetectSentimentInput) (req *request.Request, output *BatchDetectSentimentOutput) {
	op := &request.Operation{
		Name:       opBatchDetectSentiment,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchDetectSentimentInput{}
	}

	output = &BatchDetectSentimentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchDetectSentiment API operation for Amazon Comprehend.
//
// Inspects a batch of documents and returns an inference of the prevailing
// sentiment, POSITIVE, NEUTRAL, MIXED, or NEGATIVE, in each one.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation BatchDetectSentiment for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is invalid.
//
//   * TextSizeLimitExceededException
//   The size of the input text exceeds the limit. Use a smaller document.
//
//   * UnsupportedLanguageException
//   Amazon Comprehend can't process the language of the input text. For all custom
//   entity recognition APIs (such as CreateEntityRecognizer), only English, Spanish,
//   French, Italian, German, or Portuguese are accepted. For most other APIs,
//   such as those for Custom Classification, Amazon Comprehend accepts text in
//   all supported languages. For a list of supported languages, see supported-languages.
//
//   * BatchSizeLimitExceededException
//   The number of documents in the request exceeds the limit of 25. Try your
//   request again with fewer documents.
//
//   * InternalServerException
//   An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/BatchDetectSentiment
func (c *Comprehend) BatchDetectSentiment(input *BatchDetectSentimentInput) (*BatchDetectSentimentOutput, error) {
	req, out := c.BatchDetectSentimentRequest(input)
	return out, req.Send()
}

// BatchDetectSentimentWithContext is the same as BatchDetectSentiment with the addition of
// the ability to pass a context and additional request options.
//
// See BatchDetectSentiment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) BatchDetectSentimentWithContext(ctx aws.Context, input *BatchDetectSentimentInput, opts ...request.Option) (*BatchDetectSentimentOutput, error) {
	req, out := c.BatchDetectSentimentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchDetectSyntax = "BatchDetectSyntax"

// BatchDetectSyntaxRequest generates a "aws/request.Request" representing the
// client's request for the BatchDetectSyntax operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchDetectSyntax for more information on using the BatchDetectSyntax
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchDetectSyntaxRequest method.
//    req, resp := client.BatchDetectSyntaxRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/BatchDetectSyntax
func (c *Comprehend) BatchDetectSyntaxRequest(input *BatchDetectSyntaxInput) (req *request.Request, output *BatchDetectSyntaxOutput) {
	op := &request.Operation{
		Name:       opBatchDetectSyntax,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchDetectSyntaxInput{}
	}

	output = &BatchDetectSyntaxOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchDetectSyntax API operation for Amazon Comprehend.
//
// Inspects the text of a batch of documents for the syntax and part of speech
// of the words in the document and returns information about them. For more
// information, see how-syntax.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation BatchDetectSyntax for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is invalid.
//
//   * TextSizeLimitExceededException
//   The size of the input text exceeds the limit. Use a smaller document.
//
//   * UnsupportedLanguageException
//   Amazon Comprehend can't process the language of the input text. For all custom
//   entity recognition APIs (such as CreateEntityRecognizer), only English, Spanish,
//   French, Italian, German, or Portuguese are accepted. For most other APIs,
//   such as those for Custom Classification, Amazon Comprehend accepts text in
//   all supported languages. For a list of supported languages, see supported-languages.
//
//   * BatchSizeLimitExceededException
//   The number of documents in the request exceeds the limit of 25. Try your
//   request again with fewer documents.
//
//   * InternalServerException
//   An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/BatchDetectSyntax
func (c *Comprehend) BatchDetectSyntax(input *BatchDetectSyntaxInput) (*BatchDetectSyntaxOutput, error) {
	req, out := c.BatchDetectSyntaxRequest(input)
	return out, req.Send()
}

// BatchDetectSyntaxWithContext is the same as BatchDetectSyntax with the addition of
// the ability to pass a context and additional request options.
//
// See BatchDetectSyntax for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) BatchDetectSyntaxWithContext(ctx aws.Context, input *BatchDetectSyntaxInput, opts ...request.Option) (*BatchDetectSyntaxOutput, error) {
	req, out := c.BatchDetectSyntaxRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opClassifyDocument = "ClassifyDocument"

// ClassifyDocumentRequest generates a "aws/request.Request" representing the
// client's request for the ClassifyDocument operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ClassifyDocument for more information on using the ClassifyDocument
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ClassifyDocumentRequest method.
//    req, resp := client.ClassifyDocumentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ClassifyDocument
func (c *Comprehend) ClassifyDocumentRequest(input *ClassifyDocumentInput) (req *request.Request, output *ClassifyDocumentOutput) {
	op := &request.Operation{
		Name:       opClassifyDocument,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ClassifyDocumentInput{}
	}

	output = &ClassifyDocumentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ClassifyDocument API operation for Amazon Comprehend.
//
// Creates a new document classification request to analyze a single document
// in real-time, using a previously created and trained custom model and an
// endpoint.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation ClassifyDocument for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is invalid.
//
//   * ResourceUnavailableException
//   The specified resource is not available. Check the resource and try your
//   request again.
//
//   * TextSizeLimitExceededException
//   The size of the input text exceeds the limit. Use a smaller document.
//
//   * InternalServerException
//   An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ClassifyDocument
func (c *Comprehend) ClassifyDocument(input *ClassifyDocumentInput) (*ClassifyDocumentOutput, error) {
	req, out := c.ClassifyDocumentRequest(input)
	return out, req.Send()
}

// ClassifyDocumentWithContext is the same as ClassifyDocument with the addition of
// the ability to pass a context and additional request options.
//
// See ClassifyDocument for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) ClassifyDocumentWithContext(ctx aws.Context, input *ClassifyDocumentInput, opts ...request.Option) (*ClassifyDocumentOutput, error) {
	req, out := c.ClassifyDocumentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDocumentClassifier = "CreateDocumentClassifier"

// CreateDocumentClassifierRequest generates a "aws/request.Request" representing the
// client's request for the CreateDocumentClassifier operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDocumentClassifier for more information on using the CreateDocumentClassifier
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDocumentClassifierRequest method.
//    req, resp := client.CreateDocumentClassifierRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/CreateDocumentClassifier
func (c *Comprehend) CreateDocumentClassifierRequest(input *CreateDocumentClassifierInput) (req *request.Request, output *CreateDocumentClassifierOutput) {
	op := &request.Operation{
		Name:       opCreateDocumentClassifier,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDocumentClassifierInput{}
	}

	output = &CreateDocumentClassifierOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDocumentClassifier API operation for Amazon Comprehend.
//
// Creates a new document classifier that you can use to categorize documents.
// To create a classifier, you provide a set of training documents that labeled
// with the categories that you want to use. After the classifier is trained
// you can use it to categorize a set of labeled documents into the categories.
// For more information, see how-document-classification.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation CreateDocumentClassifier for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is invalid.
//
//   * ResourceInUseException
//   The specified resource name is already in use. Use a different name and try
//   your request again.
//
//   * TooManyTagsException
//   The request contains more tags than can be associated with a resource (50
//   tags per resource). The maximum number of tags includes both existing tags
//   and those included in your current request.
//
//   * TooManyRequestsException
//   The number of requests exceeds the limit. Resubmit your request later.
//
//   * ResourceLimitExceededException
//   The maximum number of resources per account has been exceeded. Review the
//   resources, and then try your request again.
//
//   * UnsupportedLanguageException
//   Amazon Comprehend can't process the language of the input text. For all custom
//   entity recognition APIs (such as CreateEntityRecognizer), only English, Spanish,
//   French, Italian, German, or Portuguese are accepted. For most other APIs,
//   such as those for Custom Classification, Amazon Comprehend accepts text in
//   all supported languages. For a list of supported languages, see supported-languages.
//
//   * KmsKeyValidationException
//   The KMS customer managed key (CMK) entered cannot be validated. Verify the
//   key and re-enter it.
//
//   * InternalServerException
//   An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/CreateDocumentClassifier
func (c *Comprehend) CreateDocumentClassifier(input *CreateDocumentClassifierInput) (*CreateDocumentClassifierOutput, error) {
	req, out := c.CreateDocumentClassifierRequest(input)
	return out, req.Send()
}

// CreateDocumentClassifierWithContext is the same as CreateDocumentClassifier with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDocumentClassifier for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) CreateDocumentClassifierWithContext(ctx aws.Context, input *CreateDocumentClassifierInput, opts ...request.Option) (*CreateDocumentClassifierOutput, error) {
	req, out := c.CreateDocumentClassifierRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateEndpoint = "CreateEndpoint"

// CreateEndpointRequest generates a "aws/request.Request" representing the
// client's request for the CreateEndpoint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateEndpoint for more information on using the CreateEndpoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateEndpointRequest method.
//    req, resp := client.CreateEndpointRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/CreateEndpoint
func (c *Comprehend) CreateEndpointRequest(input *CreateEndpointInput) (req *request.Request, output *CreateEndpointOutput) {
	op := &request.Operation{
		Name:       opCreateEndpoint,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateEndpointInput{}
	}

	output = &CreateEndpointOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateEndpoint API operation for Amazon Comprehend.
//
// Creates a model-specific endpoint for synchronous inference for a previously
// trained custom model
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation CreateEndpoint for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is invalid.
//
//   * ResourceInUseException
//   The specified resource name is already in use. Use a different name and try
//   your request again.
//
//   * ResourceLimitExceededException
//   The maximum number of resources per account has been exceeded. Review the
//   resources, and then try your request again.
//
//   * ResourceNotFoundException
//   The specified resource ARN was not found. Check the ARN and try your request
//   again.
//
//   * ResourceUnavailableException
//   The specified resource is not available. Check the resource and try your
//   request again.
//
//   * TooManyRequestsException
//   The number of requests exceeds the limit. Resubmit your request later.
//
//   * TooManyTagsException
//   The request contains more tags than can be associated with a resource (50
//   tags per resource). The maximum number of tags includes both existing tags
//   and those included in your current request.
//
//   * InternalServerException
//   An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/CreateEndpoint
func (c *Comprehend) CreateEndpoint(input *CreateEndpointInput) (*CreateEndpointOutput, error) {
	req, out := c.CreateEndpointRequest(input)
	return out, req.Send()
}

// CreateEndpointWithContext is the same as CreateEndpoint with the addition of
// the ability to pass a context and additional request options.
//
// See CreateEndpoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) CreateEndpointWithContext(ctx aws.Context, input *CreateEndpointInput, opts ...request.Option) (*CreateEndpointOutput, error) {
	req, out := c.CreateEndpointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateEntityRecognizer = "CreateEntityRecognizer"

// CreateEntityRecognizerRequest generates a "aws/request.Request" representing the
// client's request for the CreateEntityRecognizer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateEntityRecognizer for more information on using the CreateEntityRecognizer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateEntityRecognizerRequest method.
//    req, resp := client.CreateEntityRecognizerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/CreateEntityRecognizer
func (c *Comprehend) CreateEntityRecognizerRequest(input *CreateEntityRecognizerInput) (req *request.Request, output *CreateEntityRecognizerOutput) {
	op := &request.Operation{
		Name:       opCreateEntityRecognizer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateEntityRecognizerInput{}
	}

	output = &CreateEntityRecognizerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateEntityRecognizer API operation for Amazon Comprehend.
//
// Creates an entity recognizer using submitted files. After your CreateEntityRecognizer
// request is submitted, you can check job status using the API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation CreateEntityRecognizer for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is invalid.
//
//   * ResourceInUseException
//   The specified resource name is already in use. Use a different name and try
//   your request again.
//
//   * TooManyTagsException
//   The request contains more tags than can be associated with a resource (50
//   tags per resource). The maximum number of tags includes both existing tags
//   and those included in your current request.
//
//   * TooManyRequestsException
//   The number of requests exceeds the limit. Resubmit your request later.
//
//   * ResourceLimitExceededException
//   The maximum number of resources per account has been exceeded. Review the
//   resources, and then try your request again.
//
//   * UnsupportedLanguageException
//   Amazon Comprehend can't process the language of the input text. For all custom
//   entity recognition APIs (such as CreateEntityRecognizer), only English, Spanish,
//   French, Italian, German, or Portuguese are accepted. For most other APIs,
//   such as those for Custom Classification, Amazon Comprehend accepts text in
//   all supported languages. For a list of supported languages, see supported-languages.
//
//   * KmsKeyValidationException
//   The KMS customer managed key (CMK) entered cannot be validated. Verify the
//   key and re-enter it.
//
//   * InternalServerException
//   An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/CreateEntityRecognizer
func (c *Comprehend) CreateEntityRecognizer(input *CreateEntityRecognizerInput) (*CreateEntityRecognizerOutput, error) {
	req, out := c.CreateEntityRecognizerRequest(input)
	return out, req.Send()
}

// CreateEntityRecognizerWithContext is the same as CreateEntityRecognizer with the addition of
// the ability to pass a context and additional request options.
//
// See CreateEntityRecognizer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) CreateEntityRecognizerWithContext(ctx aws.Context, input *CreateEntityRecognizerInput, opts ...request.Option) (*CreateEntityRecognizerOutput, error) {
	req, out := c.CreateEntityRecognizerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDocumentClassifier = "DeleteDocumentClassifier"

// DeleteDocumentClassifierRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDocumentClassifier operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDocumentClassifier for more information on using the DeleteDocumentClassifier
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteDocumentClassifierRequest method.
//    req, resp := client.DeleteDocumentClassifierRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DeleteDocumentClassifier
func (c *Comprehend) DeleteDocumentClassifierRequest(input *DeleteDocumentClassifierInput) (req *request.Request, output *DeleteDocumentClassifierOutput) {
	op := &request.Operation{
		Name:       opDeleteDocumentClassifier,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDocumentClassifierInput{}
	}

	output = &DeleteDocumentClassifierOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteDocumentClassifier API operation for Amazon Comprehend.
//
// Deletes a previously created document classifier
//
// Only those classifiers that are in terminated states (IN_ERROR, TRAINED)
// will be deleted. If an active inference job is using the model, a ResourceInUseException
// will be returned.
//
// This is an asynchronous action that puts the classifier into a DELETING state,
// and it is then removed by a background job. Once removed, the classifier
// disappears from your account and is no longer available for use.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation DeleteDocumentClassifier for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is invalid.
//
//   * TooManyRequestsException
//   The number of requests exceeds the limit. Resubmit your request later.
//
//   * ResourceNotFoundException
//   The specified resource ARN was not found. Check the ARN and try your request
//   again.
//
//   * ResourceUnavailableException
//   The specified resource is not available. Check the resource and try your
//   request again.
//
//   * ResourceInUseException
//   The specified resource name is already in use. Use a different name and try
//   your request again.
//
//   * InternalServerException
//   An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DeleteDocumentClassifier
func (c *Comprehend) DeleteDocumentClassifier(input *DeleteDocumentClassifierInput) (*DeleteDocumentClassifierOutput, error) {
	req, out := c.DeleteDocumentClassifierRequest(input)
	return out, req.Send()
}

// DeleteDocumentClassifierWithContext is the same as DeleteDocumentClassifier with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDocumentClassifier for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) DeleteDocumentClassifierWithContext(ctx aws.Context, input *DeleteDocumentClassifierInput, opts ...request.Option) (*DeleteDocumentClassifierOutput, error) {
	req, out := c.DeleteDocumentClassifierRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteEndpoint = "DeleteEndpoint"

// DeleteEndpointRequest generates a "aws/request.Request" representing the
// client's request for the DeleteEndpoint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteEndpoint for more information on using the DeleteEndpoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteEndpointRequest method.
//    req, resp := client.DeleteEndpointRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DeleteEndpoint
func (c *Comprehend) DeleteEndpointRequest(input *DeleteEndpointInput) (req *request.Request, output *DeleteEndpointOutput) {
	op := &request.Operation{
		Name:       opDeleteEndpoint,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteEndpointInput{}
	}

	output = &DeleteEndpointOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteEndpoint API operation for Amazon Comprehend.
//
// Deletes a model-specific endpoint for a previously-trained custom model.
// All endpoints must be deleted in order for the model to be deleted.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation DeleteEndpoint for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is invalid.
//
//   * ResourceInUseException
//   The specified resource name is already in use. Use a different name and try
//   your request again.
//
//   * ResourceNotFoundException
//   The specified resource ARN was not found. Check the ARN and try your request
//   again.
//
//   * TooManyRequestsException
//   The number of requests exceeds the limit. Resubmit your request later.
//
//   * InternalServerException
//   An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DeleteEndpoint
func (c *Comprehend) DeleteEndpoint(input *DeleteEndpointInput) (*DeleteEndpointOutput, error) {
	req, out := c.DeleteEndpointRequest(input)
	return out, req.Send()
}

// DeleteEndpointWithContext is the same as DeleteEndpoint with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteEndpoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) DeleteEndpointWithContext(ctx aws.Context, input *DeleteEndpointInput, opts ...request.Option) (*DeleteEndpointOutput, error) {
	req, out := c.DeleteEndpointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteEntityRecognizer = "DeleteEntityRecognizer"

// DeleteEntityRecognizerRequest generates a "aws/request.Request" representing the
// client's request for the DeleteEntityRecognizer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteEntityRecognizer for more information on using the DeleteEntityRecognizer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteEntityRecognizerRequest method.
//    req, resp := client.DeleteEntityRecognizerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DeleteEntityRecognizer
func (c *Comprehend) DeleteEntityRecognizerRequest(input *DeleteEntityRecognizerInput) (req *request.Request, output *DeleteEntityRecognizerOutput) {
	op := &request.Operation{
		Name:       opDeleteEntityRecognizer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteEntityRecognizerInput{}
	}

	output = &DeleteEntityRecognizerOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteEntityRecognizer API operation for Amazon Comprehend.
//
// Deletes an entity recognizer.
//
// Only those recognizers that are in terminated states (IN_ERROR, TRAINED)
// will be deleted. If an active inference job is using the model, a ResourceInUseException
// will be returned.
//
// This is an asynchronous action that puts the recognizer into a DELETING state,
// and it is then removed by a background job. Once removed, the recognizer
// disappears from your account and is no longer available for use.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation DeleteEntityRecognizer for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is invalid.
//
//   * TooManyRequestsException
//   The number of requests exceeds the limit. Resubmit your request later.
//
//   * ResourceNotFoundException
//   The specified resource ARN was not found. Check the ARN and try your request
//   again.
//
//   * ResourceUnavailableException
//   The specified resource is not available. Check the resource and try your
//   request again.
//
//   * ResourceInUseException
//   The specified resource name is already in use. Use a different name and try
//   your request again.
//
//   * InternalServerException
//   An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DeleteEntityRecognizer
func (c *Comprehend) DeleteEntityRecognizer(input *DeleteEntityRecognizerInput) (*DeleteEntityRecognizerOutput, error) {
	req, out := c.DeleteEntityRecognizerRequest(input)
	return out, req.Send()
}

// DeleteEntityRecognizerWithContext is the same as DeleteEntityRecognizer with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteEntityRecognizer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) DeleteEntityRecognizerWithContext(ctx aws.Context, input *DeleteEntityRecognizerInput, opts ...request.Option) (*DeleteEntityRecognizerOutput, error) {
	req, out := c.DeleteEntityRecognizerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDocumentClassificationJob = "DescribeDocumentClassificationJob"

// DescribeDocumentClassificationJobRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDocumentClassificationJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDocumentClassificationJob for more information on using the DescribeDocumentClassificationJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDocumentClassificationJobRequest method.
//    req, resp := client.DescribeDocumentClassificationJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeDocumentClassificationJob
func (c *Comprehend) DescribeDocumentClassificationJobRequest(input *DescribeDocumentClassificationJobInput) (req *request.Request, output *DescribeDocumentClassificationJobOutput) {
	op := &request.Operation{
		Name:       opDescribeDocumentClassificationJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeDocumentClassificationJobInput{}
	}

	output = &DescribeDocumentClassificationJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDocumentClassificationJob API operation for Amazon Comprehend.
//
// Gets the properties associated with a document classification job. Use this
// operation to get the status of a classification job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation DescribeDocumentClassificationJob for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is invalid.
//
//   * TooManyRequestsException
//   The number of requests exceeds the limit. Resubmit your request later.
//
//   * JobNotFoundException
//   The specified job was not found. Check the job ID and try again.
//
//   * InternalServerException
//   An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeDocumentClassificationJob
func (c *Comprehend) DescribeDocumentClassificationJob(input *DescribeDocumentClassificationJobInput) (*DescribeDocumentClassificationJobOutput, error) {
	req, out := c.DescribeDocumentClassificationJobRequest(input)
	return out, req.Send()
}

// DescribeDocumentClassificationJobWithContext is the same as DescribeDocumentClassificationJob with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDocumentClassificationJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) DescribeDocumentClassificationJobWithContext(ctx aws.Context, input *DescribeDocumentClassificationJobInput, opts ...request.Option) (*DescribeDocumentClassificationJobOutput, error) {
	req, out := c.DescribeDocumentClassificationJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDocumentClassifier = "DescribeDocumentClassifier"

// DescribeDocumentClassifierRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDocumentClassifier operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDocumentClassifier for more information on using the DescribeDocumentClassifier
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDocumentClassifierRequest method.
//    req, resp := client.DescribeDocumentClassifierRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeDocumentClassifier
func (c *Comprehend) DescribeDocumentClassifierRequest(input *DescribeDocumentClassifierInput) (req *request.Request, output *DescribeDocumentClassifierOutput) {
	op := &request.Operation{
		Name:       opDescribeDocumentClassifier,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeDocumentClassifierInput{}
	}

	output = &DescribeDocumentClassifierOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDocumentClassifier API operation for Amazon Comprehend.
//
// Gets the properties associated with a document classifier.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation DescribeDocumentClassifier for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is invalid.
//
//   * TooManyRequestsException
//   The number of requests exceeds the limit. Resubmit your request later.
//
//   * ResourceNotFoundException
//   The specified resource ARN was not found. Check the ARN and try your request
//   again.
//
//   * InternalServerException
//   An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeDocumentClassifier
func (c *Comprehend) DescribeDocumentClassifier(input *DescribeDocumentClassifierInput) (*DescribeDocumentClassifierOutput, error) {
	req, out := c.DescribeDocumentClassifierRequest(input)
	return out, req.Send()
}

// DescribeDocumentClassifierWithContext is the same as DescribeDocumentClassifier with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDocumentClassifier for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) DescribeDocumentClassifierWithContext(ctx aws.Context, input *DescribeDocumentClassifierInput, opts ...request.Option) (*DescribeDocumentClassifierOutput, error) {
	req, out := c.DescribeDocumentClassifierRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDominantLanguageDetectionJob = "DescribeDominantLanguageDetectionJob"

// DescribeDominantLanguageDetectionJobRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDominantLanguageDetectionJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDominantLanguageDetectionJob for more information on using the DescribeDominantLanguageDetectionJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDominantLanguageDetectionJobRequest method.
//    req, resp := client.DescribeDominantLanguageDetectionJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeDominantLanguageDetectionJob
func (c *Comprehend) DescribeDominantLanguageDetectionJobRequest(input *DescribeDominantLanguageDetectionJobInput) (req *request.Request, output *DescribeDominantLanguageDetectionJobOutput) {
	op := &request.Operation{
		Name:       opDescribeDominantLanguageDetectionJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeDominantLanguageDetectionJobInput{}
	}

	output = &DescribeDominantLanguageDetectionJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDominantLanguageDetectionJob API operation for Amazon Comprehend.
//
// Gets the properties associated with a dominant language detection job. Use
// this operation to get the status of a detection job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation DescribeDominantLanguageDetectionJob for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is invalid.
//
//   * JobNotFoundException
//   The specified job was not found. Check the job ID and try again.
//
//   * TooManyRequestsException
//   The number of requests exceeds the limit. Resubmit your request later.
//
//   * InternalServerException
//   An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeDominantLanguageDetectionJob
func (c *Comprehend) DescribeDominantLanguageDetectionJob(input *DescribeDominantLanguageDetectionJobInput) (*DescribeDominantLanguageDetectionJobOutput, error) {
	req, out := c.DescribeDominantLanguageDetectionJobRequest(input)
	return out, req.Send()
}

// DescribeDominantLanguageDetectionJobWithContext is the same as DescribeDominantLanguageDetectionJob with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDominantLanguageDetectionJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) DescribeDominantLanguageDetectionJobWithContext(ctx aws.Context, input *DescribeDominantLanguageDetectionJobInput, opts ...request.Option) (*DescribeDominantLanguageDetectionJobOutput, error) {
	req, out := c.DescribeDominantLanguageDetectionJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeEndpoint = "DescribeEndpoint"

// DescribeEndpointRequest generates a "aws/request.Request" representing the
// client's request for the DescribeEndpoint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeEndpoint for more information on using the DescribeEndpoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeEndpointRequest method.
//    req, resp := client.DescribeEndpointRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeEndpoint
func (c *Comprehend) DescribeEndpointRequest(input *DescribeEndpointInput) (req *request.Request, output *DescribeEndpointOutput) {
	op := &request.Operation{
		Name:       opDescribeEndpoint,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeEndpointInput{}
	}

	output = &DescribeEndpointOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeEndpoint API operation for Amazon Comprehend.
//
// Gets the properties associated with a specific endpoint. Use this operation
// to get the status of an endpoint.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation DescribeEndpoint for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is invalid.
//
//   * TooManyRequestsException
//   The number of requests exceeds the limit. Resubmit your request later.
//
//   * ResourceNotFoundException
//   The specified resource ARN was not found. Check the ARN and try your request
//   again.
//
//   * InternalServerException
//   An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeEndpoint
func (c *Comprehend) DescribeEndpoint(input *DescribeEndpointInput) (*DescribeEndpointOutput, error) {
	req, out := c.DescribeEndpointRequest(input)
	return out, req.Send()
}

// DescribeEndpointWithContext is the same as DescribeEndpoint with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeEndpoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) DescribeEndpointWithContext(ctx aws.Context, input *DescribeEndpointInput, opts ...request.Option) (*DescribeEndpointOutput, error) {
	req, out := c.DescribeEndpointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeEntitiesDetectionJob = "DescribeEntitiesDetectionJob"

// DescribeEntitiesDetectionJobRequest generates a "aws/request.Request" representing the
// client's request for the DescribeEntitiesDetectionJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeEntitiesDetectionJob for more information on using the DescribeEntitiesDetectionJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeEntitiesDetectionJobRequest method.
//    req, resp := client.DescribeEntitiesDetectionJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeEntitiesDetectionJob
func (c *Comprehend) DescribeEntitiesDetectionJobRequest(input *DescribeEntitiesDetectionJobInput) (req *request.Request, output *DescribeEntitiesDetectionJobOutput) {
	op := &request.Operation{
		Name:       opDescribeEntitiesDetectionJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeEntitiesDetectionJobInput{}
	}

	output = &DescribeEntitiesDetectionJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeEntitiesDetectionJob API operation for Amazon Comprehend.
//
// Gets the properties associated with an entities detection job. Use this operation
// to get the status of a detection job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation DescribeEntitiesDetectionJob for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is invalid.
//
//   * JobNotFoundException
//   The specified job was not found. Check the job ID and try again.
//
//   * TooManyRequestsException
//   The number of requests exceeds the limit. Resubmit your request later.
//
//   * InternalServerException
//   An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeEntitiesDetectionJob
func (c *Comprehend) DescribeEntitiesDetectionJob(input *DescribeEntitiesDetectionJobInput) (*DescribeEntitiesDetectionJobOutput, error) {
	req, out := c.DescribeEntitiesDetectionJobRequest(input)
	return out, req.Send()
}

// DescribeEntitiesDetectionJobWithContext is the same as DescribeEntitiesDetectionJob with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeEntitiesDetectionJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) DescribeEntitiesDetectionJobWithContext(ctx aws.Context, input *DescribeEntitiesDetectionJobInput, opts ...request.Option) (*DescribeEntitiesDetectionJobOutput, error) {
	req, out := c.DescribeEntitiesDetectionJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeEntityRecognizer = "DescribeEntityRecognizer"

// DescribeEntityRecognizerRequest generates a "aws/request.Request" representing the
// client's request for the DescribeEntityRecognizer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeEntityRecognizer for more information on using the DescribeEntityRecognizer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeEntityRecognizerRequest method.
//    req, resp := client.DescribeEntityRecognizerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeEntityRecognizer
func (c *Comprehend) DescribeEntityRecognizerRequest(input *DescribeEntityRecognizerInput) (req *request.Request, output *DescribeEntityRecognizerOutput) {
	op := &request.Operation{
		Name:       opDescribeEntityRecognizer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeEntityRecognizerInput{}
	}

	output = &DescribeEntityRecognizerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeEntityRecognizer API operation for Amazon Comprehend.
//
// Provides details about an entity recognizer including status, S3 buckets
// containing training data, recognizer metadata, metrics, and so on.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation DescribeEntityRecognizer for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is invalid.
//
//   * TooManyRequestsException
//   The number of requests exceeds the limit. Resubmit your request later.
//
//   * ResourceNotFoundException
//   The specified resource ARN was not found. Check the ARN and try your request
//   again.
//
//   * InternalServerException
//   An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeEntityRecognizer
func (c *Comprehend) DescribeEntityRecognizer(input *DescribeEntityRecognizerInput) (*DescribeEntityRecognizerOutput, error) {
	req, out := c.DescribeEntityRecognizerRequest(input)
	return out, req.Send()
}

// DescribeEntityRecognizerWithContext is the same as DescribeEntityRecognizer with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeEntityRecognizer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) DescribeEntityRecognizerWithContext(ctx aws.Context, input *DescribeEntityRecognizerInput, opts ...request.Option) (*DescribeEntityRecognizerOutput, error) {
	req, out := c.DescribeEntityRecognizerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeKeyPhrasesDetectionJob = "DescribeKeyPhrasesDetectionJob"

// DescribeKeyPhrasesDetectionJobRequest generates a "aws/request.Request" representing the
// client's request for the DescribeKeyPhrasesDetectionJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeKeyPhrasesDetectionJob for more information on using the DescribeKeyPhrasesDetectionJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeKeyPhrasesDetectionJobRequest method.
//    req, resp := client.DescribeKeyPhrasesDetectionJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeKeyPhrasesDetectionJob
func (c *Comprehend) DescribeKeyPhrasesDetectionJobRequest(input *DescribeKeyPhrasesDetectionJobInput) (req *request.Request, output *DescribeKeyPhrasesDetectionJobOutput) {
	op := &request.Operation{
		Name:       opDescribeKeyPhrasesDetectionJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeKeyPhrasesDetectionJobInput{}
	}

	output = &DescribeKeyPhrasesDetectionJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeKeyPhrasesDetectionJob API operation for Amazon Comprehend.
//
// Gets the properties associated with a key phrases detection job. Use this
// operation to get the status of a detection job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation DescribeKeyPhrasesDetectionJob for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is invalid.
//
//   * JobNotFoundException
//   The specified job was not found. Check the job ID and try again.
//
//   * TooManyRequestsException
//   The number of requests exceeds the limit. Resubmit your request later.
//
//   * InternalServerException
//   An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeKeyPhrasesDetectionJob
func (c *Comprehend) DescribeKeyPhrasesDetectionJob(input *DescribeKeyPhrasesDetectionJobInput) (*DescribeKeyPhrasesDetectionJobOutput, error) {
	req, out := c.DescribeKeyPhrasesDetectionJobRequest(input)
	return out, req.Send()
}

// DescribeKeyPhrasesDetectionJobWithContext is the same as DescribeKeyPhrasesDetectionJob with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeKeyPhrasesDetectionJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) DescribeKeyPhrasesDetectionJobWithContext(ctx aws.Context, input *DescribeKeyPhrasesDetectionJobInput, opts ...request.Option) (*DescribeKeyPhrasesDetectionJobOutput, error) {
	req, out := c.DescribeKeyPhrasesDetectionJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribePiiEntitiesDetectionJob = "DescribePiiEntitiesDetectionJob"

// DescribePiiEntitiesDetectionJobRequest generates a "aws/request.Request" representing the
// client's request for the DescribePiiEntitiesDetectionJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribePiiEntitiesDetectionJob for more information on using the DescribePiiEntitiesDetectionJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribePiiEntitiesDetectionJobRequest method.
//    req, resp := client.DescribePiiEntitiesDetectionJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribePiiEntitiesDetectionJob
func (c *Comprehend) DescribePiiEntitiesDetectionJobRequest(input *DescribePiiEntitiesDetectionJobInput) (req *request.Request, output *DescribePiiEntitiesDetectionJobOutput) {
	op := &request.Operation{
		Name:       opDescribePiiEntitiesDetectionJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribePiiEntitiesDetectionJobInput{}
	}

	output = &DescribePiiEntitiesDetectionJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribePiiEntitiesDetectionJob API operation for Amazon Comprehend.
//
// Gets the properties associated with a PII entities detection job. For example,
// you can use this operation to get the job status.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation DescribePiiEntitiesDetectionJob for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is invalid.
//
//   * JobNotFoundException
//   The specified job was not found. Check the job ID and try again.
//
//   * TooManyRequestsException
//   The number of requests exceeds the limit. Resubmit your request later.
//
//   * InternalServerException
//   An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribePiiEntitiesDetectionJob
func (c *Comprehend) DescribePiiEntitiesDetectionJob(input *DescribePiiEntitiesDetectionJobInput) (*DescribePiiEntitiesDetectionJobOutput, error) {
	req, out := c.DescribePiiEntitiesDetectionJobRequest(input)
	return out, req.Send()
}

// DescribePiiEntitiesDetectionJobWithContext is the same as DescribePiiEntitiesDetectionJob with the addition of
// the ability to pass a context and additional request options.
//
// See DescribePiiEntitiesDetectionJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) DescribePiiEntitiesDetectionJobWithContext(ctx aws.Context, input *DescribePiiEntitiesDetectionJobInput, opts ...request.Option) (*DescribePiiEntitiesDetectionJobOutput, error) {
	req, out := c.DescribePiiEntitiesDetectionJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeSentimentDetectionJob = "DescribeSentimentDetectionJob"

// DescribeSentimentDetectionJobRequest generates a "aws/request.Request" representing the
// client's request for the DescribeSentimentDetectionJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeSentimentDetectionJob for more information on using the DescribeSentimentDetectionJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeSentimentDetectionJobRequest method.
//    req, resp := client.DescribeSentimentDetectionJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeSentimentDetectionJob
func (c *Comprehend) DescribeSentimentDetectionJobRequest(input *DescribeSentimentDetectionJobInput) (req *request.Request, output *DescribeSentimentDetectionJobOutput) {
	op := &request.Operation{
		Name:       opDescribeSentimentDetectionJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeSentimentDetectionJobInput{}
	}

	output = &DescribeSentimentDetectionJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeSentimentDetectionJob API operation for Amazon Comprehend.
//
// Gets the properties associated with a sentiment detection job. Use this operation
// to get the status of a detection job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation DescribeSentimentDetectionJob for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is invalid.
//
//   * JobNotFoundException
//   The specified job was not found. Check the job ID and try again.
//
//   * TooManyRequestsException
//   The number of requests exceeds the limit. Resubmit your request later.
//
//   * InternalServerException
//   An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeSentimentDetectionJob
func (c *Comprehend) DescribeSentimentDetectionJob(input *DescribeSentimentDetectionJobInput) (*DescribeSentimentDetectionJobOutput, error) {
	req, out := c.DescribeSentimentDetectionJobRequest(input)
	return out, req.Send()
}

// DescribeSentimentDetectionJobWithContext is the same as DescribeSentimentDetectionJob with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeSentimentDetectionJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) DescribeSentimentDetectionJobWithContext(ctx aws.Context, input *DescribeSentimentDetectionJobInput, opts ...request.Option) (*DescribeSentimentDetectionJobOutput, error) {
	req, out := c.DescribeSentimentDetectionJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeTopicsDetectionJob = "DescribeTopicsDetectionJob"

// DescribeTopicsDetectionJobRequest generates a "aws/request.Request" representing the
// client's request for the DescribeTopicsDetectionJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeTopicsDetectionJob for more information on using the DescribeTopicsDetectionJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeTopicsDetectionJobRequest method.
//    req, resp := client.DescribeTopicsDetectionJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeTopicsDetectionJob
func (c *Comprehend) DescribeTopicsDetectionJobRequest(input *DescribeTopicsDetectionJobInput) (req *request.Request, output *DescribeTopicsDetectionJobOutput) {
	op := &request.Operation{
		Name:       opDescribeTopicsDetectionJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeTopicsDetectionJobInput{}
	}

	output = &DescribeTopicsDetectionJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeTopicsDetectionJob API operation for Amazon Comprehend.
//
// Gets the properties associated with a topic detection job. Use this operation
// to get the status of a detection job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation DescribeTopicsDetectionJob for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is invalid.
//
//   * JobNotFoundException
//   The specified job was not found. Check the job ID and try again.
//
//   * TooManyRequestsException
//   The number of requests exceeds the limit. Resubmit your request later.
//
//   * InternalServerException
//   An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DescribeTopicsDetectionJob
func (c *Comprehend) DescribeTopicsDetectionJob(input *DescribeTopicsDetectionJobInput) (*DescribeTopicsDetectionJobOutput, error) {
	req, out := c.DescribeTopicsDetectionJobRequest(input)
	return out, req.Send()
}

// DescribeTopicsDetectionJobWithContext is the same as DescribeTopicsDetectionJob with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeTopicsDetectionJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) DescribeTopicsDetectionJobWithContext(ctx aws.Context, input *DescribeTopicsDetectionJobInput, opts ...request.Option) (*DescribeTopicsDetectionJobOutput, error) {
	req, out := c.DescribeTopicsDetectionJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDetectDominantLanguage = "DetectDominantLanguage"

// DetectDominantLanguageRequest generates a "aws/request.Request" representing the
// client's request for the DetectDominantLanguage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DetectDominantLanguage for more information on using the DetectDominantLanguage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DetectDominantLanguageRequest method.
//    req, resp := client.DetectDominantLanguageRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DetectDominantLanguage
func (c *Comprehend) DetectDominantLanguageRequest(input *DetectDominantLanguageInput) (req *request.Request, output *DetectDominantLanguageOutput) {
	op := &request.Operation{
		Name:       opDetectDominantLanguage,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DetectDominantLanguageInput{}
	}

	output = &DetectDominantLanguageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DetectDominantLanguage API operation for Amazon Comprehend.
//
// Determines the dominant language of the input text. For a list of languages
// that Amazon Comprehend can detect, see Amazon Comprehend Supported Languages
// (https://docs.aws.amazon.com/comprehend/latest/dg/how-languages.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation DetectDominantLanguage for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is invalid.
//
//   * TextSizeLimitExceededException
//   The size of the input text exceeds the limit. Use a smaller document.
//
//   * InternalServerException
//   An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DetectDominantLanguage
func (c *Comprehend) DetectDominantLanguage(input *DetectDominantLanguageInput) (*DetectDominantLanguageOutput, error) {
	req, out := c.DetectDominantLanguageRequest(input)
	return out, req.Send()
}

// DetectDominantLanguageWithContext is the same as DetectDominantLanguage with the addition of
// the ability to pass a context and additional request options.
//
// See DetectDominantLanguage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) DetectDominantLanguageWithContext(ctx aws.Context, input *DetectDominantLanguageInput, opts ...request.Option) (*DetectDominantLanguageOutput, error) {
	req, out := c.DetectDominantLanguageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDetectEntities = "DetectEntities"

// DetectEntitiesRequest generates a "aws/request.Request" representing the
// client's request for the DetectEntities operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DetectEntities for more information on using the DetectEntities
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DetectEntitiesRequest method.
//    req, resp := client.DetectEntitiesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DetectEntities
func (c *Comprehend) DetectEntitiesRequest(input *DetectEntitiesInput) (req *request.Request, output *DetectEntitiesOutput) {
	op := &request.Operation{
		Name:       opDetectEntities,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DetectEntitiesInput{}
	}

	output = &DetectEntitiesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DetectEntities API operation for Amazon Comprehend.
//
// Inspects text for named entities, and returns information about them. For
// more information, about named entities, see how-entities.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation DetectEntities for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is invalid.
//
//   * ResourceUnavailableException
//   The specified resource is not available. Check the resource and try your
//   request again.
//
//   * TextSizeLimitExceededException
//   The size of the input text exceeds the limit. Use a smaller document.
//
//   * UnsupportedLanguageException
//   Amazon Comprehend can't process the language of the input text. For all custom
//   entity recognition APIs (such as CreateEntityRecognizer), only English, Spanish,
//   French, Italian, German, or Portuguese are accepted. For most other APIs,
//   such as those for Custom Classification, Amazon Comprehend accepts text in
//   all supported languages. For a list of supported languages, see supported-languages.
//
//   * InternalServerException
//   An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DetectEntities
func (c *Comprehend) DetectEntities(input *DetectEntitiesInput) (*DetectEntitiesOutput, error) {
	req, out := c.DetectEntitiesRequest(input)
	return out, req.Send()
}

// DetectEntitiesWithContext is the same as DetectEntities with the addition of
// the ability to pass a context and additional request options.
//
// See DetectEntities for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) DetectEntitiesWithContext(ctx aws.Context, input *DetectEntitiesInput, opts ...request.Option) (*DetectEntitiesOutput, error) {
	req, out := c.DetectEntitiesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDetectKeyPhrases = "DetectKeyPhrases"

// DetectKeyPhrasesRequest generates a "aws/request.Request" representing the
// client's request for the DetectKeyPhrases operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DetectKeyPhrases for more information on using the DetectKeyPhrases
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DetectKeyPhrasesRequest method.
//    req, resp := client.DetectKeyPhrasesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DetectKeyPhrases
func (c *Comprehend) DetectKeyPhrasesRequest(input *DetectKeyPhrasesInput) (req *request.Request, output *DetectKeyPhrasesOutput) {
	op := &request.Operation{
		Name:       opDetectKeyPhrases,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DetectKeyPhrasesInput{}
	}

	output = &DetectKeyPhrasesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DetectKeyPhrases API operation for Amazon Comprehend.
//
// Detects the key noun phrases found in the text.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation DetectKeyPhrases for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is invalid.
//
//   * TextSizeLimitExceededException
//   The size of the input text exceeds the limit. Use a smaller document.
//
//   * UnsupportedLanguageException
//   Amazon Comprehend can't process the language of the input text. For all custom
//   entity recognition APIs (such as CreateEntityRecognizer), only English, Spanish,
//   French, Italian, German, or Portuguese are accepted. For most other APIs,
//   such as those for Custom Classification, Amazon Comprehend accepts text in
//   all supported languages. For a list of supported languages, see supported-languages.
//
//   * InternalServerException
//   An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DetectKeyPhrases
func (c *Comprehend) DetectKeyPhrases(input *DetectKeyPhrasesInput) (*DetectKeyPhrasesOutput, error) {
	req, out := c.DetectKeyPhrasesRequest(input)
	return out, req.Send()
}

// DetectKeyPhrasesWithContext is the same as DetectKeyPhrases with the addition of
// the ability to pass a context and additional request options.
//
// See DetectKeyPhrases for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) DetectKeyPhrasesWithContext(ctx aws.Context, input *DetectKeyPhrasesInput, opts ...request.Option) (*DetectKeyPhrasesOutput, error) {
	req, out := c.DetectKeyPhrasesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDetectPiiEntities = "DetectPiiEntities"

// DetectPiiEntitiesRequest generates a "aws/request.Request" representing the
// client's request for the DetectPiiEntities operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DetectPiiEntities for more information on using the DetectPiiEntities
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DetectPiiEntitiesRequest method.
//    req, resp := client.DetectPiiEntitiesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DetectPiiEntities
func (c *Comprehend) DetectPiiEntitiesRequest(input *DetectPiiEntitiesInput) (req *request.Request, output *DetectPiiEntitiesOutput) {
	op := &request.Operation{
		Name:       opDetectPiiEntities,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DetectPiiEntitiesInput{}
	}

	output = &DetectPiiEntitiesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DetectPiiEntities API operation for Amazon Comprehend.
//
// Inspects the input text for entities that contain personally identifiable
// information (PII) and returns information about them.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation DetectPiiEntities for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is invalid.
//
//   * TextSizeLimitExceededException
//   The size of the input text exceeds the limit. Use a smaller document.
//
//   * UnsupportedLanguageException
//   Amazon Comprehend can't process the language of the input text. For all custom
//   entity recognition APIs (such as CreateEntityRecognizer), only English, Spanish,
//   French, Italian, German, or Portuguese are accepted. For most other APIs,
//   such as those for Custom Classification, Amazon Comprehend accepts text in
//   all supported languages. For a list of supported languages, see supported-languages.
//
//   * InternalServerException
//   An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DetectPiiEntities
func (c *Comprehend) DetectPiiEntities(input *DetectPiiEntitiesInput) (*DetectPiiEntitiesOutput, error) {
	req, out := c.DetectPiiEntitiesRequest(input)
	return out, req.Send()
}

// DetectPiiEntitiesWithContext is the same as DetectPiiEntities with the addition of
// the ability to pass a context and additional request options.
//
// See DetectPiiEntities for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) DetectPiiEntitiesWithContext(ctx aws.Context, input *DetectPiiEntitiesInput, opts ...request.Option) (*DetectPiiEntitiesOutput, error) {
	req, out := c.DetectPiiEntitiesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDetectSentiment = "DetectSentiment"

// DetectSentimentRequest generates a "aws/request.Request" representing the
// client's request for the DetectSentiment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DetectSentiment for more information on using the DetectSentiment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DetectSentimentRequest method.
//    req, resp := client.DetectSentimentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DetectSentiment
func (c *Comprehend) DetectSentimentRequest(input *DetectSentimentInput) (req *request.Request, output *DetectSentimentOutput) {
	op := &request.Operation{
		Name:       opDetectSentiment,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DetectSentimentInput{}
	}

	output = &DetectSentimentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DetectSentiment API operation for Amazon Comprehend.
//
// Inspects text and returns an inference of the prevailing sentiment (POSITIVE,
// NEUTRAL, MIXED, or NEGATIVE).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation DetectSentiment for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is invalid.
//
//   * TextSizeLimitExceededException
//   The size of the input text exceeds the limit. Use a smaller document.
//
//   * UnsupportedLanguageException
//   Amazon Comprehend can't process the language of the input text. For all custom
//   entity recognition APIs (such as CreateEntityRecognizer), only English, Spanish,
//   French, Italian, German, or Portuguese are accepted. For most other APIs,
//   such as those for Custom Classification, Amazon Comprehend accepts text in
//   all supported languages. For a list of supported languages, see supported-languages.
//
//   * InternalServerException
//   An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DetectSentiment
func (c *Comprehend) DetectSentiment(input *DetectSentimentInput) (*DetectSentimentOutput, error) {
	req, out := c.DetectSentimentRequest(input)
	return out, req.Send()
}

// DetectSentimentWithContext is the same as DetectSentiment with the addition of
// the ability to pass a context and additional request options.
//
// See DetectSentiment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) DetectSentimentWithContext(ctx aws.Context, input *DetectSentimentInput, opts ...request.Option) (*DetectSentimentOutput, error) {
	req, out := c.DetectSentimentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDetectSyntax = "DetectSyntax"

// DetectSyntaxRequest generates a "aws/request.Request" representing the
// client's request for the DetectSyntax operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DetectSyntax for more information on using the DetectSyntax
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DetectSyntaxRequest method.
//    req, resp := client.DetectSyntaxRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DetectSyntax
func (c *Comprehend) DetectSyntaxRequest(input *DetectSyntaxInput) (req *request.Request, output *DetectSyntaxOutput) {
	op := &request.Operation{
		Name:       opDetectSyntax,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DetectSyntaxInput{}
	}

	output = &DetectSyntaxOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DetectSyntax API operation for Amazon Comprehend.
//
// Inspects text for syntax and the part of speech of words in the document.
// For more information, how-syntax.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation DetectSyntax for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is invalid.
//
//   * TextSizeLimitExceededException
//   The size of the input text exceeds the limit. Use a smaller document.
//
//   * UnsupportedLanguageException
//   Amazon Comprehend can't process the language of the input text. For all custom
//   entity recognition APIs (such as CreateEntityRecognizer), only English, Spanish,
//   French, Italian, German, or Portuguese are accepted. For most other APIs,
//   such as those for Custom Classification, Amazon Comprehend accepts text in
//   all supported languages. For a list of supported languages, see supported-languages.
//
//   * InternalServerException
//   An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DetectSyntax
func (c *Comprehend) DetectSyntax(input *DetectSyntaxInput) (*DetectSyntaxOutput, error) {
	req, out := c.DetectSyntaxRequest(input)
	return out, req.Send()
}

// DetectSyntaxWithContext is the same as DetectSyntax with the addition of
// the ability to pass a context and additional request options.
//
// See DetectSyntax for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) DetectSyntaxWithContext(ctx aws.Context, input *DetectSyntaxInput, opts ...request.Option) (*DetectSyntaxOutput, error) {
	req, out := c.DetectSyntaxRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListDocumentClassificationJobs = "ListDocumentClassificationJobs"

// ListDocumentClassificationJobsRequest generates a "aws/request.Request" representing the
// client's request for the ListDocumentClassificationJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDocumentClassificationJobs for more information on using the ListDocumentClassificationJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListDocumentClassificationJobsRequest method.
//    req, resp := client.ListDocumentClassificationJobsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListDocumentClassificationJobs
func (c *Comprehend) ListDocumentClassificationJobsRequest(input *ListDocumentClassificationJobsInput) (req *request.Request, output *ListDocumentClassificationJobsOutput) {
	op := &request.Operation{
		Name:       opListDocumentClassificationJobs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDocumentClassificationJobsInput{}
	}

	output = &ListDocumentClassificationJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDocumentClassificationJobs API operation for Amazon Comprehend.
//
// Gets a list of the documentation classification jobs that you have submitted.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation ListDocumentClassificationJobs for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is invalid.
//
//   * TooManyRequestsException
//   The number of requests exceeds the limit. Resubmit your request later.
//
//   * InvalidFilterException
//   The filter specified for the operation is invalid. Specify a different filter.
//
//   * InternalServerException
//   An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListDocumentClassificationJobs
func (c *Comprehend) ListDocumentClassificationJobs(input *ListDocumentClassificationJobsInput) (*ListDocumentClassificationJobsOutput, error) {
	req, out := c.ListDocumentClassificationJobsRequest(input)
	return out, req.Send()
}

// ListDocumentClassificationJobsWithContext is the same as ListDocumentClassificationJobs with the addition of
// the ability to pass a context and additional request options.
//
// See ListDocumentClassificationJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) ListDocumentClassificationJobsWithContext(ctx aws.Context, input *ListDocumentClassificationJobsInput, opts ...request.Option) (*ListDocumentClassificationJobsOutput, error) {
	req, out := c.ListDocumentClassificationJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDocumentClassificationJobsPages iterates over the pages of a ListDocumentClassificationJobs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDocumentClassificationJobs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListDocumentClassificationJobs operation.
//    pageNum := 0
//    err := client.ListDocumentClassificationJobsPages(params,
//        func(page *comprehend.ListDocumentClassificationJobsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Comprehend) ListDocumentClassificationJobsPages(input *ListDocumentClassificationJobsInput, fn func(*ListDocumentClassificationJobsOutput, bool) bool) error {
	return c.ListDocumentClassificationJobsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDocumentClassificationJobsPagesWithContext same as ListDocumentClassificationJobsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) ListDocumentClassificationJobsPagesWithContext(ctx aws.Context, input *ListDocumentClassificationJobsInput, fn func(*ListDocumentClassificationJobsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDocumentClassificationJobsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDocumentClassificationJobsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListDocumentClassificationJobsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListDocumentClassifiers = "ListDocumentClassifiers"

// ListDocumentClassifiersRequest generates a "aws/request.Request" representing the
// client's request for the ListDocumentClassifiers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDocumentClassifiers for more information on using the ListDocumentClassifiers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListDocumentClassifiersRequest method.
//    req, resp := client.ListDocumentClassifiersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListDocumentClassifiers
func (c *Comprehend) ListDocumentClassifiersRequest(input *ListDocumentClassifiersInput) (req *request.Request, output *ListDocumentClassifiersOutput) {
	op := &request.Operation{
		Name:       opListDocumentClassifiers,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDocumentClassifiersInput{}
	}

	output = &ListDocumentClassifiersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDocumentClassifiers API operation for Amazon Comprehend.
//
// Gets a list of the document classifiers that you have created.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation ListDocumentClassifiers for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is invalid.
//
//   * TooManyRequestsException
//   The number of requests exceeds the limit. Resubmit your request later.
//
//   * InvalidFilterException
//   The filter specified for the operation is invalid. Specify a different filter.
//
//   * InternalServerException
//   An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListDocumentClassifiers
func (c *Comprehend) ListDocumentClassifiers(input *ListDocumentClassifiersInput) (*ListDocumentClassifiersOutput, error) {
	req, out := c.ListDocumentClassifiersRequest(input)
	return out, req.Send()
}

// ListDocumentClassifiersWithContext is the same as ListDocumentClassifiers with the addition of
// the ability to pass a context and additional request options.
//
// See ListDocumentClassifiers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) ListDocumentClassifiersWithContext(ctx aws.Context, input *ListDocumentClassifiersInput, opts ...request.Option) (*ListDocumentClassifiersOutput, error) {
	req, out := c.ListDocumentClassifiersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDocumentClassifiersPages iterates over the pages of a ListDocumentClassifiers operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDocumentClassifiers method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListDocumentClassifiers operation.
//    pageNum := 0
//    err := client.ListDocumentClassifiersPages(params,
//        func(page *comprehend.ListDocumentClassifiersOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Comprehend) ListDocumentClassifiersPages(input *ListDocumentClassifiersInput, fn func(*ListDocumentClassifiersOutput, bool) bool) error {
	return c.ListDocumentClassifiersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDocumentClassifiersPagesWithContext same as ListDocumentClassifiersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) ListDocumentClassifiersPagesWithContext(ctx aws.Context, input *ListDocumentClassifiersInput, fn func(*ListDocumentClassifiersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDocumentClassifiersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDocumentClassifiersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListDocumentClassifiersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListDominantLanguageDetectionJobs = "ListDominantLanguageDetectionJobs"

// ListDominantLanguageDetectionJobsRequest generates a "aws/request.Request" representing the
// client's request for the ListDominantLanguageDetectionJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDominantLanguageDetectionJobs for more information on using the ListDominantLanguageDetectionJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListDominantLanguageDetectionJobsRequest method.
//    req, resp := client.ListDominantLanguageDetectionJobsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListDominantLanguageDetectionJobs
func (c *Comprehend) ListDominantLanguageDetectionJobsRequest(input *ListDominantLanguageDetectionJobsInput) (req *request.Request, output *ListDominantLanguageDetectionJobsOutput) {
	op := &request.Operation{
		Name:       opListDominantLanguageDetectionJobs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDominantLanguageDetectionJobsInput{}
	}

	output = &ListDominantLanguageDetectionJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDominantLanguageDetectionJobs API operation for Amazon Comprehend.
//
// Gets a list of the dominant language detection jobs that you have submitted.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation ListDominantLanguageDetectionJobs for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is invalid.
//
//   * TooManyRequestsException
//   The number of requests exceeds the limit. Resubmit your request later.
//
//   * InvalidFilterException
//   The filter specified for the operation is invalid. Specify a different filter.
//
//   * InternalServerException
//   An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListDominantLanguageDetectionJobs
func (c *Comprehend) ListDominantLanguageDetectionJobs(input *ListDominantLanguageDetectionJobsInput) (*ListDominantLanguageDetectionJobsOutput, error) {
	req, out := c.ListDominantLanguageDetectionJobsRequest(input)
	return out, req.Send()
}

// ListDominantLanguageDetectionJobsWithContext is the same as ListDominantLanguageDetectionJobs with the addition of
// the ability to pass a context and additional request options.
//
// See ListDominantLanguageDetectionJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) ListDominantLanguageDetectionJobsWithContext(ctx aws.Context, input *ListDominantLanguageDetectionJobsInput, opts ...request.Option) (*ListDominantLanguageDetectionJobsOutput, error) {
	req, out := c.ListDominantLanguageDetectionJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDominantLanguageDetectionJobsPages iterates over the pages of a ListDominantLanguageDetectionJobs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDominantLanguageDetectionJobs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListDominantLanguageDetectionJobs operation.
//    pageNum := 0
//    err := client.ListDominantLanguageDetectionJobsPages(params,
//        func(page *comprehend.ListDominantLanguageDetectionJobsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Comprehend) ListDominantLanguageDetectionJobsPages(input *ListDominantLanguageDetectionJobsInput, fn func(*ListDominantLanguageDetectionJobsOutput, bool) bool) error {
	return c.ListDominantLanguageDetectionJobsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDominantLanguageDetectionJobsPagesWithContext same as ListDominantLanguageDetectionJobsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) ListDominantLanguageDetectionJobsPagesWithContext(ctx aws.Context, input *ListDominantLanguageDetectionJobsInput, fn func(*ListDominantLanguageDetectionJobsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDominantLanguageDetectionJobsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDominantLanguageDetectionJobsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListDominantLanguageDetectionJobsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListEndpoints = "ListEndpoints"

// ListEndpointsRequest generates a "aws/request.Request" representing the
// client's request for the ListEndpoints operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListEndpoints for more information on using the ListEndpoints
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListEndpointsRequest method.
//    req, resp := client.ListEndpointsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListEndpoints
func (c *Comprehend) ListEndpointsRequest(input *ListEndpointsInput) (req *request.Request, output *ListEndpointsOutput) {
	op := &request.Operation{
		Name:       opListEndpoints,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListEndpointsInput{}
	}

	output = &ListEndpointsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListEndpoints API operation for Amazon Comprehend.
//
// Gets a list of all existing endpoints that you've created.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation ListEndpoints for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is invalid.
//
//   * TooManyRequestsException
//   The number of requests exceeds the limit. Resubmit your request later.
//
//   * InternalServerException
//   An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListEndpoints
func (c *Comprehend) ListEndpoints(input *ListEndpointsInput) (*ListEndpointsOutput, error) {
	req, out := c.ListEndpointsRequest(input)
	return out, req.Send()
}

// ListEndpointsWithContext is the same as ListEndpoints with the addition of
// the ability to pass a context and additional request options.
//
// See ListEndpoints for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) ListEndpointsWithContext(ctx aws.Context, input *ListEndpointsInput, opts ...request.Option) (*ListEndpointsOutput, error) {
	req, out := c.ListEndpointsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListEntitiesDetectionJobs = "ListEntitiesDetectionJobs"

// ListEntitiesDetectionJobsRequest generates a "aws/request.Request" representing the
// client's request for the ListEntitiesDetectionJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListEntitiesDetectionJobs for more information on using the ListEntitiesDetectionJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListEntitiesDetectionJobsRequest method.
//    req, resp := client.ListEntitiesDetectionJobsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListEntitiesDetectionJobs
func (c *Comprehend) ListEntitiesDetectionJobsRequest(input *ListEntitiesDetectionJobsInput) (req *request.Request, output *ListEntitiesDetectionJobsOutput) {
	op := &request.Operation{
		Name:       opListEntitiesDetectionJobs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListEntitiesDetectionJobsInput{}
	}

	output = &ListEntitiesDetectionJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListEntitiesDetectionJobs API operation for Amazon Comprehend.
//
// Gets a list of the entity detection jobs that you have submitted.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation ListEntitiesDetectionJobs for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is invalid.
//
//   * TooManyRequestsException
//   The number of requests exceeds the limit. Resubmit your request later.
//
//   * InvalidFilterException
//   The filter specified for the operation is invalid. Specify a different filter.
//
//   * InternalServerException
//   An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListEntitiesDetectionJobs
func (c *Comprehend) ListEntitiesDetectionJobs(input *ListEntitiesDetectionJobsInput) (*ListEntitiesDetectionJobsOutput, error) {
	req, out := c.ListEntitiesDetectionJobsRequest(input)
	return out, req.Send()
}

// ListEntitiesDetectionJobsWithContext is the same as ListEntitiesDetectionJobs with the addition of
// the ability to pass a context and additional request options.
//
// See ListEntitiesDetectionJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) ListEntitiesDetectionJobsWithContext(ctx aws.Context, input *ListEntitiesDetectionJobsInput, opts ...request.Option) (*ListEntitiesDetectionJobsOutput, error) {
	req, out := c.ListEntitiesDetectionJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListEntitiesDetectionJobsPages iterates over the pages of a ListEntitiesDetectionJobs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListEntitiesDetectionJobs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListEntitiesDetectionJobs operation.
//    pageNum := 0
//    err := client.ListEntitiesDetectionJobsPages(params,
//        func(page *comprehend.ListEntitiesDetectionJobsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Comprehend) ListEntitiesDetectionJobsPages(input *ListEntitiesDetectionJobsInput, fn func(*ListEntitiesDetectionJobsOutput, bool) bool) error {
	return c.ListEntitiesDetectionJobsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListEntitiesDetectionJobsPagesWithContext same as ListEntitiesDetectionJobsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) ListEntitiesDetectionJobsPagesWithContext(ctx aws.Context, input *ListEntitiesDetectionJobsInput, fn func(*ListEntitiesDetectionJobsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListEntitiesDetectionJobsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListEntitiesDetectionJobsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListEntitiesDetectionJobsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListEntityRecognizers = "ListEntityRecognizers"

// ListEntityRecognizersRequest generates a "aws/request.Request" representing the
// client's request for the ListEntityRecognizers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListEntityRecognizers for more information on using the ListEntityRecognizers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListEntityRecognizersRequest method.
//    req, resp := client.ListEntityRecognizersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListEntityRecognizers
func (c *Comprehend) ListEntityRecognizersRequest(input *ListEntityRecognizersInput) (req *request.Request, output *ListEntityRecognizersOutput) {
	op := &request.Operation{
		Name:       opListEntityRecognizers,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListEntityRecognizersInput{}
	}

	output = &ListEntityRecognizersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListEntityRecognizers API operation for Amazon Comprehend.
//
// Gets a list of the properties of all entity recognizers that you created,
// including recognizers currently in training. Allows you to filter the list
// of recognizers based on criteria such as status and submission time. This
// call returns up to 500 entity recognizers in the list, with a default number
// of 100 recognizers in the list.
//
// The results of this list are not in any particular order. Please get the
// list and sort locally if needed.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation ListEntityRecognizers for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is invalid.
//
//   * TooManyRequestsException
//   The number of requests exceeds the limit. Resubmit your request later.
//
//   * InvalidFilterException
//   The filter specified for the operation is invalid. Specify a different filter.
//
//   * InternalServerException
//   An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListEntityRecognizers
func (c *Comprehend) ListEntityRecognizers(input *ListEntityRecognizersInput) (*ListEntityRecognizersOutput, error) {
	req, out := c.ListEntityRecognizersRequest(input)
	return out, req.Send()
}

// ListEntityRecognizersWithContext is the same as ListEntityRecognizers with the addition of
// the ability to pass a context and additional request options.
//
// See ListEntityRecognizers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) ListEntityRecognizersWithContext(ctx aws.Context, input *ListEntityRecognizersInput, opts ...request.Option) (*ListEntityRecognizersOutput, error) {
	req, out := c.ListEntityRecognizersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListEntityRecognizersPages iterates over the pages of a ListEntityRecognizers operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListEntityRecognizers method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListEntityRecognizers operation.
//    pageNum := 0
//    err := client.ListEntityRecognizersPages(params,
//        func(page *comprehend.ListEntityRecognizersOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Comprehend) ListEntityRecognizersPages(input *ListEntityRecognizersInput, fn func(*ListEntityRecognizersOutput, bool) bool) error {
	return c.ListEntityRecognizersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListEntityRecognizersPagesWithContext same as ListEntityRecognizersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) ListEntityRecognizersPagesWithContext(ctx aws.Context, input *ListEntityRecognizersInput, fn func(*ListEntityRecognizersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListEntityRecognizersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListEntityRecognizersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListEntityRecognizersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListKeyPhrasesDetectionJobs = "ListKeyPhrasesDetectionJobs"

// ListKeyPhrasesDetectionJobsRequest generates a "aws/request.Request" representing the
// client's request for the ListKeyPhrasesDetectionJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListKeyPhrasesDetectionJobs for more information on using the ListKeyPhrasesDetectionJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListKeyPhrasesDetectionJobsRequest method.
//    req, resp := client.ListKeyPhrasesDetectionJobsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListKeyPhrasesDetectionJobs
func (c *Comprehend) ListKeyPhrasesDetectionJobsRequest(input *ListKeyPhrasesDetectionJobsInput) (req *request.Request, output *ListKeyPhrasesDetectionJobsOutput) {
	op := &request.Operation{
		Name:       opListKeyPhrasesDetectionJobs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListKeyPhrasesDetectionJobsInput{}
	}

	output = &ListKeyPhrasesDetectionJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListKeyPhrasesDetectionJobs API operation for Amazon Comprehend.
//
// Get a list of key phrase detection jobs that you have submitted.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation ListKeyPhrasesDetectionJobs for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is invalid.
//
//   * TooManyRequestsException
//   The number of requests exceeds the limit. Resubmit your request later.
//
//   * InvalidFilterException
//   The filter specified for the operation is invalid. Specify a different filter.
//
//   * InternalServerException
//   An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListKeyPhrasesDetectionJobs
func (c *Comprehend) ListKeyPhrasesDetectionJobs(input *ListKeyPhrasesDetectionJobsInput) (*ListKeyPhrasesDetectionJobsOutput, error) {
	req, out := c.ListKeyPhrasesDetectionJobsRequest(input)
	return out, req.Send()
}

// ListKeyPhrasesDetectionJobsWithContext is the same as ListKeyPhrasesDetectionJobs with the addition of
// the ability to pass a context and additional request options.
//
// See ListKeyPhrasesDetectionJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) ListKeyPhrasesDetectionJobsWithContext(ctx aws.Context, input *ListKeyPhrasesDetectionJobsInput, opts ...request.Option) (*ListKeyPhrasesDetectionJobsOutput, error) {
	req, out := c.ListKeyPhrasesDetectionJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListKeyPhrasesDetectionJobsPages iterates over the pages of a ListKeyPhrasesDetectionJobs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListKeyPhrasesDetectionJobs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListKeyPhrasesDetectionJobs operation.
//    pageNum := 0
//    err := client.ListKeyPhrasesDetectionJobsPages(params,
//        func(page *comprehend.ListKeyPhrasesDetectionJobsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Comprehend) ListKeyPhrasesDetectionJobsPages(input *ListKeyPhrasesDetectionJobsInput, fn func(*ListKeyPhrasesDetectionJobsOutput, bool) bool) error {
	return c.ListKeyPhrasesDetectionJobsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListKeyPhrasesDetectionJobsPagesWithContext same as ListKeyPhrasesDetectionJobsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) ListKeyPhrasesDetectionJobsPagesWithContext(ctx aws.Context, input *ListKeyPhrasesDetectionJobsInput, fn func(*ListKeyPhrasesDetectionJobsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListKeyPhrasesDetectionJobsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListKeyPhrasesDetectionJobsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListKeyPhrasesDetectionJobsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListPiiEntitiesDetectionJobs = "ListPiiEntitiesDetectionJobs"

// ListPiiEntitiesDetectionJobsRequest generates a "aws/request.Request" representing the
// client's request for the ListPiiEntitiesDetectionJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListPiiEntitiesDetectionJobs for more information on using the ListPiiEntitiesDetectionJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListPiiEntitiesDetectionJobsRequest method.
//    req, resp := client.ListPiiEntitiesDetectionJobsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListPiiEntitiesDetectionJobs
func (c *Comprehend) ListPiiEntitiesDetectionJobsRequest(input *ListPiiEntitiesDetectionJobsInput) (req *request.Request, output *ListPiiEntitiesDetectionJobsOutput) {
	op := &request.Operation{
		Name:       opListPiiEntitiesDetectionJobs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListPiiEntitiesDetectionJobsInput{}
	}

	output = &ListPiiEntitiesDetectionJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListPiiEntitiesDetectionJobs API operation for Amazon Comprehend.
//
// Gets a list of the PII entity detection jobs that you have submitted.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation ListPiiEntitiesDetectionJobs for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is invalid.
//
//   * TooManyRequestsException
//   The number of requests exceeds the limit. Resubmit your request later.
//
//   * InvalidFilterException
//   The filter specified for the operation is invalid. Specify a different filter.
//
//   * InternalServerException
//   An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListPiiEntitiesDetectionJobs
func (c *Comprehend) ListPiiEntitiesDetectionJobs(input *ListPiiEntitiesDetectionJobsInput) (*ListPiiEntitiesDetectionJobsOutput, error) {
	req, out := c.ListPiiEntitiesDetectionJobsRequest(input)
	return out, req.Send()
}

// ListPiiEntitiesDetectionJobsWithContext is the same as ListPiiEntitiesDetectionJobs with the addition of
// the ability to pass a context and additional request options.
//
// See ListPiiEntitiesDetectionJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) ListPiiEntitiesDetectionJobsWithContext(ctx aws.Context, input *ListPiiEntitiesDetectionJobsInput, opts ...request.Option) (*ListPiiEntitiesDetectionJobsOutput, error) {
	req, out := c.ListPiiEntitiesDetectionJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListSentimentDetectionJobs = "ListSentimentDetectionJobs"

// ListSentimentDetectionJobsRequest generates a "aws/request.Request" representing the
// client's request for the ListSentimentDetectionJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListSentimentDetectionJobs for more information on using the ListSentimentDetectionJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListSentimentDetectionJobsRequest method.
//    req, resp := client.ListSentimentDetectionJobsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListSentimentDetectionJobs
func (c *Comprehend) ListSentimentDetectionJobsRequest(input *ListSentimentDetectionJobsInput) (req *request.Request, output *ListSentimentDetectionJobsOutput) {
	op := &request.Operation{
		Name:       opListSentimentDetectionJobs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListSentimentDetectionJobsInput{}
	}

	output = &ListSentimentDetectionJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListSentimentDetectionJobs API operation for Amazon Comprehend.
//
// Gets a list of sentiment detection jobs that you have submitted.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation ListSentimentDetectionJobs for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is invalid.
//
//   * TooManyRequestsException
//   The number of requests exceeds the limit. Resubmit your request later.
//
//   * InvalidFilterException
//   The filter specified for the operation is invalid. Specify a different filter.
//
//   * InternalServerException
//   An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListSentimentDetectionJobs
func (c *Comprehend) ListSentimentDetectionJobs(input *ListSentimentDetectionJobsInput) (*ListSentimentDetectionJobsOutput, error) {
	req, out := c.ListSentimentDetectionJobsRequest(input)
	return out, req.Send()
}

// ListSentimentDetectionJobsWithContext is the same as ListSentimentDetectionJobs with the addition of
// the ability to pass a context and additional request options.
//
// See ListSentimentDetectionJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) ListSentimentDetectionJobsWithContext(ctx aws.Context, input *ListSentimentDetectionJobsInput, opts ...request.Option) (*ListSentimentDetectionJobsOutput, error) {
	req, out := c.ListSentimentDetectionJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListSentimentDetectionJobsPages iterates over the pages of a ListSentimentDetectionJobs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListSentimentDetectionJobs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListSentimentDetectionJobs operation.
//    pageNum := 0
//    err := client.ListSentimentDetectionJobsPages(params,
//        func(page *comprehend.ListSentimentDetectionJobsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Comprehend) ListSentimentDetectionJobsPages(input *ListSentimentDetectionJobsInput, fn func(*ListSentimentDetectionJobsOutput, bool) bool) error {
	return c.ListSentimentDetectionJobsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListSentimentDetectionJobsPagesWithContext same as ListSentimentDetectionJobsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) ListSentimentDetectionJobsPagesWithContext(ctx aws.Context, input *ListSentimentDetectionJobsInput, fn func(*ListSentimentDetectionJobsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListSentimentDetectionJobsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListSentimentDetectionJobsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListSentimentDetectionJobsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsForResourceRequest method.
//    req, resp := client.ListTagsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListTagsForResource
func (c *Comprehend) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for Amazon Comprehend.
//
// Lists all tags associated with a given Amazon Comprehend resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is invalid.
//
//   * ResourceNotFoundException
//   The specified resource ARN was not found. Check the ARN and try your request
//   again.
//
//   * InternalServerException
//   An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListTagsForResource
func (c *Comprehend) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListTopicsDetectionJobs = "ListTopicsDetectionJobs"

// ListTopicsDetectionJobsRequest generates a "aws/request.Request" representing the
// client's request for the ListTopicsDetectionJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTopicsDetectionJobs for more information on using the ListTopicsDetectionJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTopicsDetectionJobsRequest method.
//    req, resp := client.ListTopicsDetectionJobsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListTopicsDetectionJobs
func (c *Comprehend) ListTopicsDetectionJobsRequest(input *ListTopicsDetectionJobsInput) (req *request.Request, output *ListTopicsDetectionJobsOutput) {
	op := &request.Operation{
		Name:       opListTopicsDetectionJobs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTopicsDetectionJobsInput{}
	}

	output = &ListTopicsDetectionJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTopicsDetectionJobs API operation for Amazon Comprehend.
//
// Gets a list of the topic detection jobs that you have submitted.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation ListTopicsDetectionJobs for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is invalid.
//
//   * TooManyRequestsException
//   The number of requests exceeds the limit. Resubmit your request later.
//
//   * InvalidFilterException
//   The filter specified for the operation is invalid. Specify a different filter.
//
//   * InternalServerException
//   An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/ListTopicsDetectionJobs
func (c *Comprehend) ListTopicsDetectionJobs(input *ListTopicsDetectionJobsInput) (*ListTopicsDetectionJobsOutput, error) {
	req, out := c.ListTopicsDetectionJobsRequest(input)
	return out, req.Send()
}

// ListTopicsDetectionJobsWithContext is the same as ListTopicsDetectionJobs with the addition of
// the ability to pass a context and additional request options.
//
// See ListTopicsDetectionJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) ListTopicsDetectionJobsWithContext(ctx aws.Context, input *ListTopicsDetectionJobsInput, opts ...request.Option) (*ListTopicsDetectionJobsOutput, error) {
	req, out := c.ListTopicsDetectionJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTopicsDetectionJobsPages iterates over the pages of a ListTopicsDetectionJobs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTopicsDetectionJobs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListTopicsDetectionJobs operation.
//    pageNum := 0
//    err := client.ListTopicsDetectionJobsPages(params,
//        func(page *comprehend.ListTopicsDetectionJobsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Comprehend) ListTopicsDetectionJobsPages(input *ListTopicsDetectionJobsInput, fn func(*ListTopicsDetectionJobsOutput, bool) bool) error {
	return c.ListTopicsDetectionJobsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTopicsDetectionJobsPagesWithContext same as ListTopicsDetectionJobsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) ListTopicsDetectionJobsPagesWithContext(ctx aws.Context, input *ListTopicsDetectionJobsInput, fn func(*ListTopicsDetectionJobsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTopicsDetectionJobsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTopicsDetectionJobsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTopicsDetectionJobsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opStartDocumentClassificationJob = "StartDocumentClassificationJob"

// StartDocumentClassificationJobRequest generates a "aws/request.Request" representing the
// client's request for the StartDocumentClassificationJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartDocumentClassificationJob for more information on using the StartDocumentClassificationJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartDocumentClassificationJobRequest method.
//    req, resp := client.StartDocumentClassificationJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StartDocumentClassificationJob
func (c *Comprehend) StartDocumentClassificationJobRequest(input *StartDocumentClassificationJobInput) (req *request.Request, output *StartDocumentClassificationJobOutput) {
	op := &request.Operation{
		Name:       opStartDocumentClassificationJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartDocumentClassificationJobInput{}
	}

	output = &StartDocumentClassificationJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartDocumentClassificationJob API operation for Amazon Comprehend.
//
// Starts an asynchronous document classification job. Use the operation to
// track the progress of the job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation StartDocumentClassificationJob for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is invalid.
//
//   * TooManyRequestsException
//   The number of requests exceeds the limit. Resubmit your request later.
//
//   * ResourceNotFoundException
//   The specified resource ARN was not found. Check the ARN and try your request
//   again.
//
//   * ResourceUnavailableException
//   The specified resource is not available. Check the resource and try your
//   request again.
//
//   * KmsKeyValidationException
//   The KMS customer managed key (CMK) entered cannot be validated. Verify the
//   key and re-enter it.
//
//   * InternalServerException
//   An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StartDocumentClassificationJob
func (c *Comprehend) StartDocumentClassificationJob(input *StartDocumentClassificationJobInput) (*StartDocumentClassificationJobOutput, error) {
	req, out := c.StartDocumentClassificationJobRequest(input)
	return out, req.Send()
}

// StartDocumentClassificationJobWithContext is the same as StartDocumentClassificationJob with the addition of
// the ability to pass a context and additional request options.
//
// See StartDocumentClassificationJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) StartDocumentClassificationJobWithContext(ctx aws.Context, input *StartDocumentClassificationJobInput, opts ...request.Option) (*StartDocumentClassificationJobOutput, error) {
	req, out := c.StartDocumentClassificationJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartDominantLanguageDetectionJob = "StartDominantLanguageDetectionJob"

// StartDominantLanguageDetectionJobRequest generates a "aws/request.Request" representing the
// client's request for the StartDominantLanguageDetectionJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartDominantLanguageDetectionJob for more information on using the StartDominantLanguageDetectionJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartDominantLanguageDetectionJobRequest method.
//    req, resp := client.StartDominantLanguageDetectionJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StartDominantLanguageDetectionJob
func (c *Comprehend) StartDominantLanguageDetectionJobRequest(input *StartDominantLanguageDetectionJobInput) (req *request.Request, output *StartDominantLanguageDetectionJobOutput) {
	op := &request.Operation{
		Name:       opStartDominantLanguageDetectionJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartDominantLanguageDetectionJobInput{}
	}

	output = &StartDominantLanguageDetectionJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartDominantLanguageDetectionJob API operation for Amazon Comprehend.
//
// Starts an asynchronous dominant language detection job for a collection of
// documents. Use the operation to track the status of a job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation StartDominantLanguageDetectionJob for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is invalid.
//
//   * TooManyRequestsException
//   The number of requests exceeds the limit. Resubmit your request later.
//
//   * KmsKeyValidationException
//   The KMS customer managed key (CMK) entered cannot be validated. Verify the
//   key and re-enter it.
//
//   * InternalServerException
//   An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StartDominantLanguageDetectionJob
func (c *Comprehend) StartDominantLanguageDetectionJob(input *StartDominantLanguageDetectionJobInput) (*StartDominantLanguageDetectionJobOutput, error) {
	req, out := c.StartDominantLanguageDetectionJobRequest(input)
	return out, req.Send()
}

// StartDominantLanguageDetectionJobWithContext is the same as StartDominantLanguageDetectionJob with the addition of
// the ability to pass a context and additional request options.
//
// See StartDominantLanguageDetectionJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) StartDominantLanguageDetectionJobWithContext(ctx aws.Context, input *StartDominantLanguageDetectionJobInput, opts ...request.Option) (*StartDominantLanguageDetectionJobOutput, error) {
	req, out := c.StartDominantLanguageDetectionJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartEntitiesDetectionJob = "StartEntitiesDetectionJob"

// StartEntitiesDetectionJobRequest generates a "aws/request.Request" representing the
// client's request for the StartEntitiesDetectionJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartEntitiesDetectionJob for more information on using the StartEntitiesDetectionJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartEntitiesDetectionJobRequest method.
//    req, resp := client.StartEntitiesDetectionJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StartEntitiesDetectionJob
func (c *Comprehend) StartEntitiesDetectionJobRequest(input *StartEntitiesDetectionJobInput) (req *request.Request, output *StartEntitiesDetectionJobOutput) {
	op := &request.Operation{
		Name:       opStartEntitiesDetectionJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartEntitiesDetectionJobInput{}
	}

	output = &StartEntitiesDetectionJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartEntitiesDetectionJob API operation for Amazon Comprehend.
//
// Starts an asynchronous entity detection job for a collection of documents.
// Use the operation to track the status of a job.
//
// This API can be used for either standard entity detection or custom entity
// recognition. In order to be used for custom entity recognition, the optional
// EntityRecognizerArn must be used in order to provide access to the recognizer
// being used to detect the custom entity.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation StartEntitiesDetectionJob for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is invalid.
//
//   * TooManyRequestsException
//   The number of requests exceeds the limit. Resubmit your request later.
//
//   * ResourceNotFoundException
//   The specified resource ARN was not found. Check the ARN and try your request
//   again.
//
//   * ResourceUnavailableException
//   The specified resource is not available. Check the resource and try your
//   request again.
//
//   * KmsKeyValidationException
//   The KMS customer managed key (CMK) entered cannot be validated. Verify the
//   key and re-enter it.
//
//   * InternalServerException
//   An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StartEntitiesDetectionJob
func (c *Comprehend) StartEntitiesDetectionJob(input *StartEntitiesDetectionJobInput) (*StartEntitiesDetectionJobOutput, error) {
	req, out := c.StartEntitiesDetectionJobRequest(input)
	return out, req.Send()
}

// StartEntitiesDetectionJobWithContext is the same as StartEntitiesDetectionJob with the addition of
// the ability to pass a context and additional request options.
//
// See StartEntitiesDetectionJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) StartEntitiesDetectionJobWithContext(ctx aws.Context, input *StartEntitiesDetectionJobInput, opts ...request.Option) (*StartEntitiesDetectionJobOutput, error) {
	req, out := c.StartEntitiesDetectionJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartKeyPhrasesDetectionJob = "StartKeyPhrasesDetectionJob"

// StartKeyPhrasesDetectionJobRequest generates a "aws/request.Request" representing the
// client's request for the StartKeyPhrasesDetectionJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartKeyPhrasesDetectionJob for more information on using the StartKeyPhrasesDetectionJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartKeyPhrasesDetectionJobRequest method.
//    req, resp := client.StartKeyPhrasesDetectionJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StartKeyPhrasesDetectionJob
func (c *Comprehend) StartKeyPhrasesDetectionJobRequest(input *StartKeyPhrasesDetectionJobInput) (req *request.Request, output *StartKeyPhrasesDetectionJobOutput) {
	op := &request.Operation{
		Name:       opStartKeyPhrasesDetectionJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartKeyPhrasesDetectionJobInput{}
	}

	output = &StartKeyPhrasesDetectionJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartKeyPhrasesDetectionJob API operation for Amazon Comprehend.
//
// Starts an asynchronous key phrase detection job for a collection of documents.
// Use the operation to track the status of a job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation StartKeyPhrasesDetectionJob for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is invalid.
//
//   * TooManyRequestsException
//   The number of requests exceeds the limit. Resubmit your request later.
//
//   * KmsKeyValidationException
//   The KMS customer managed key (CMK) entered cannot be validated. Verify the
//   key and re-enter it.
//
//   * InternalServerException
//   An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StartKeyPhrasesDetectionJob
func (c *Comprehend) StartKeyPhrasesDetectionJob(input *StartKeyPhrasesDetectionJobInput) (*StartKeyPhrasesDetectionJobOutput, error) {
	req, out := c.StartKeyPhrasesDetectionJobRequest(input)
	return out, req.Send()
}

// StartKeyPhrasesDetectionJobWithContext is the same as StartKeyPhrasesDetectionJob with the addition of
// the ability to pass a context and additional request options.
//
// See StartKeyPhrasesDetectionJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) StartKeyPhrasesDetectionJobWithContext(ctx aws.Context, input *StartKeyPhrasesDetectionJobInput, opts ...request.Option) (*StartKeyPhrasesDetectionJobOutput, error) {
	req, out := c.StartKeyPhrasesDetectionJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartPiiEntitiesDetectionJob = "StartPiiEntitiesDetectionJob"

// StartPiiEntitiesDetectionJobRequest generates a "aws/request.Request" representing the
// client's request for the StartPiiEntitiesDetectionJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartPiiEntitiesDetectionJob for more information on using the StartPiiEntitiesDetectionJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartPiiEntitiesDetectionJobRequest method.
//    req, resp := client.StartPiiEntitiesDetectionJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StartPiiEntitiesDetectionJob
func (c *Comprehend) StartPiiEntitiesDetectionJobRequest(input *StartPiiEntitiesDetectionJobInput) (req *request.Request, output *StartPiiEntitiesDetectionJobOutput) {
	op := &request.Operation{
		Name:       opStartPiiEntitiesDetectionJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartPiiEntitiesDetectionJobInput{}
	}

	output = &StartPiiEntitiesDetectionJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartPiiEntitiesDetectionJob API operation for Amazon Comprehend.
//
// Starts an asynchronous PII entity detection job for a collection of documents.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation StartPiiEntitiesDetectionJob for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is invalid.
//
//   * TooManyRequestsException
//   The number of requests exceeds the limit. Resubmit your request later.
//
//   * KmsKeyValidationException
//   The KMS customer managed key (CMK) entered cannot be validated. Verify the
//   key and re-enter it.
//
//   * InternalServerException
//   An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StartPiiEntitiesDetectionJob
func (c *Comprehend) StartPiiEntitiesDetectionJob(input *StartPiiEntitiesDetectionJobInput) (*StartPiiEntitiesDetectionJobOutput, error) {
	req, out := c.StartPiiEntitiesDetectionJobRequest(input)
	return out, req.Send()
}

// StartPiiEntitiesDetectionJobWithContext is the same as StartPiiEntitiesDetectionJob with the addition of
// the ability to pass a context and additional request options.
//
// See StartPiiEntitiesDetectionJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) StartPiiEntitiesDetectionJobWithContext(ctx aws.Context, input *StartPiiEntitiesDetectionJobInput, opts ...request.Option) (*StartPiiEntitiesDetectionJobOutput, error) {
	req, out := c.StartPiiEntitiesDetectionJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartSentimentDetectionJob = "StartSentimentDetectionJob"

// StartSentimentDetectionJobRequest generates a "aws/request.Request" representing the
// client's request for the StartSentimentDetectionJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartSentimentDetectionJob for more information on using the StartSentimentDetectionJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartSentimentDetectionJobRequest method.
//    req, resp := client.StartSentimentDetectionJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StartSentimentDetectionJob
func (c *Comprehend) StartSentimentDetectionJobRequest(input *StartSentimentDetectionJobInput) (req *request.Request, output *StartSentimentDetectionJobOutput) {
	op := &request.Operation{
		Name:       opStartSentimentDetectionJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartSentimentDetectionJobInput{}
	}

	output = &StartSentimentDetectionJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartSentimentDetectionJob API operation for Amazon Comprehend.
//
// Starts an asynchronous sentiment detection job for a collection of documents.
// use the operation to track the status of a job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation StartSentimentDetectionJob for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is invalid.
//
//   * TooManyRequestsException
//   The number of requests exceeds the limit. Resubmit your request later.
//
//   * KmsKeyValidationException
//   The KMS customer managed key (CMK) entered cannot be validated. Verify the
//   key and re-enter it.
//
//   * InternalServerException
//   An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StartSentimentDetectionJob
func (c *Comprehend) StartSentimentDetectionJob(input *StartSentimentDetectionJobInput) (*StartSentimentDetectionJobOutput, error) {
	req, out := c.StartSentimentDetectionJobRequest(input)
	return out, req.Send()
}

// StartSentimentDetectionJobWithContext is the same as StartSentimentDetectionJob with the addition of
// the ability to pass a context and additional request options.
//
// See StartSentimentDetectionJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) StartSentimentDetectionJobWithContext(ctx aws.Context, input *StartSentimentDetectionJobInput, opts ...request.Option) (*StartSentimentDetectionJobOutput, error) {
	req, out := c.StartSentimentDetectionJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartTopicsDetectionJob = "StartTopicsDetectionJob"

// StartTopicsDetectionJobRequest generates a "aws/request.Request" representing the
// client's request for the StartTopicsDetectionJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartTopicsDetectionJob for more information on using the StartTopicsDetectionJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartTopicsDetectionJobRequest method.
//    req, resp := client.StartTopicsDetectionJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StartTopicsDetectionJob
func (c *Comprehend) StartTopicsDetectionJobRequest(input *StartTopicsDetectionJobInput) (req *request.Request, output *StartTopicsDetectionJobOutput) {
	op := &request.Operation{
		Name:       opStartTopicsDetectionJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartTopicsDetectionJobInput{}
	}

	output = &StartTopicsDetectionJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartTopicsDetectionJob API operation for Amazon Comprehend.
//
// Starts an asynchronous topic detection job. Use the DescribeTopicDetectionJob
// operation to track the status of a job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation StartTopicsDetectionJob for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is invalid.
//
//   * TooManyRequestsException
//   The number of requests exceeds the limit. Resubmit your request later.
//
//   * KmsKeyValidationException
//   The KMS customer managed key (CMK) entered cannot be validated. Verify the
//   key and re-enter it.
//
//   * InternalServerException
//   An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StartTopicsDetectionJob
func (c *Comprehend) StartTopicsDetectionJob(input *StartTopicsDetectionJobInput) (*StartTopicsDetectionJobOutput, error) {
	req, out := c.StartTopicsDetectionJobRequest(input)
	return out, req.Send()
}

// StartTopicsDetectionJobWithContext is the same as StartTopicsDetectionJob with the addition of
// the ability to pass a context and additional request options.
//
// See StartTopicsDetectionJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) StartTopicsDetectionJobWithContext(ctx aws.Context, input *StartTopicsDetectionJobInput, opts ...request.Option) (*StartTopicsDetectionJobOutput, error) {
	req, out := c.StartTopicsDetectionJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopDominantLanguageDetectionJob = "StopDominantLanguageDetectionJob"

// StopDominantLanguageDetectionJobRequest generates a "aws/request.Request" representing the
// client's request for the StopDominantLanguageDetectionJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopDominantLanguageDetectionJob for more information on using the StopDominantLanguageDetectionJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StopDominantLanguageDetectionJobRequest method.
//    req, resp := client.StopDominantLanguageDetectionJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StopDominantLanguageDetectionJob
func (c *Comprehend) StopDominantLanguageDetectionJobRequest(input *StopDominantLanguageDetectionJobInput) (req *request.Request, output *StopDominantLanguageDetectionJobOutput) {
	op := &request.Operation{
		Name:       opStopDominantLanguageDetectionJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopDominantLanguageDetectionJobInput{}
	}

	output = &StopDominantLanguageDetectionJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StopDominantLanguageDetectionJob API operation for Amazon Comprehend.
//
// Stops a dominant language detection job in progress.
//
// If the job state is IN_PROGRESS the job is marked for termination and put
// into the STOP_REQUESTED state. If the job completes before it can be stopped,
// it is put into the COMPLETED state; otherwise the job is stopped and put
// into the STOPPED state.
//
// If the job is in the COMPLETED or FAILED state when you call the StopDominantLanguageDetectionJob
// operation, the operation returns a 400 Internal Request Exception.
//
// When a job is stopped, any documents already processed are written to the
// output location.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation StopDominantLanguageDetectionJob for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is invalid.
//
//   * JobNotFoundException
//   The specified job was not found. Check the job ID and try again.
//
//   * InternalServerException
//   An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StopDominantLanguageDetectionJob
func (c *Comprehend) StopDominantLanguageDetectionJob(input *StopDominantLanguageDetectionJobInput) (*StopDominantLanguageDetectionJobOutput, error) {
	req, out := c.StopDominantLanguageDetectionJobRequest(input)
	return out, req.Send()
}

// StopDominantLanguageDetectionJobWithContext is the same as StopDominantLanguageDetectionJob with the addition of
// the ability to pass a context and additional request options.
//
// See StopDominantLanguageDetectionJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) StopDominantLanguageDetectionJobWithContext(ctx aws.Context, input *StopDominantLanguageDetectionJobInput, opts ...request.Option) (*StopDominantLanguageDetectionJobOutput, error) {
	req, out := c.StopDominantLanguageDetectionJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopEntitiesDetectionJob = "StopEntitiesDetectionJob"

// StopEntitiesDetectionJobRequest generates a "aws/request.Request" representing the
// client's request for the StopEntitiesDetectionJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopEntitiesDetectionJob for more information on using the StopEntitiesDetectionJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StopEntitiesDetectionJobRequest method.
//    req, resp := client.StopEntitiesDetectionJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StopEntitiesDetectionJob
func (c *Comprehend) StopEntitiesDetectionJobRequest(input *StopEntitiesDetectionJobInput) (req *request.Request, output *StopEntitiesDetectionJobOutput) {
	op := &request.Operation{
		Name:       opStopEntitiesDetectionJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopEntitiesDetectionJobInput{}
	}

	output = &StopEntitiesDetectionJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StopEntitiesDetectionJob API operation for Amazon Comprehend.
//
// Stops an entities detection job in progress.
//
// If the job state is IN_PROGRESS the job is marked for termination and put
// into the STOP_REQUESTED state. If the job completes before it can be stopped,
// it is put into the COMPLETED state; otherwise the job is stopped and put
// into the STOPPED state.
//
// If the job is in the COMPLETED or FAILED state when you call the StopDominantLanguageDetectionJob
// operation, the operation returns a 400 Internal Request Exception.
//
// When a job is stopped, any documents already processed are written to the
// output location.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation StopEntitiesDetectionJob for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is invalid.
//
//   * JobNotFoundException
//   The specified job was not found. Check the job ID and try again.
//
//   * InternalServerException
//   An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StopEntitiesDetectionJob
func (c *Comprehend) StopEntitiesDetectionJob(input *StopEntitiesDetectionJobInput) (*StopEntitiesDetectionJobOutput, error) {
	req, out := c.StopEntitiesDetectionJobRequest(input)
	return out, req.Send()
}

// StopEntitiesDetectionJobWithContext is the same as StopEntitiesDetectionJob with the addition of
// the ability to pass a context and additional request options.
//
// See StopEntitiesDetectionJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) StopEntitiesDetectionJobWithContext(ctx aws.Context, input *StopEntitiesDetectionJobInput, opts ...request.Option) (*StopEntitiesDetectionJobOutput, error) {
	req, out := c.StopEntitiesDetectionJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopKeyPhrasesDetectionJob = "StopKeyPhrasesDetectionJob"

// StopKeyPhrasesDetectionJobRequest generates a "aws/request.Request" representing the
// client's request for the StopKeyPhrasesDetectionJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopKeyPhrasesDetectionJob for more information on using the StopKeyPhrasesDetectionJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StopKeyPhrasesDetectionJobRequest method.
//    req, resp := client.StopKeyPhrasesDetectionJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StopKeyPhrasesDetectionJob
func (c *Comprehend) StopKeyPhrasesDetectionJobRequest(input *StopKeyPhrasesDetectionJobInput) (req *request.Request, output *StopKeyPhrasesDetectionJobOutput) {
	op := &request.Operation{
		Name:       opStopKeyPhrasesDetectionJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopKeyPhrasesDetectionJobInput{}
	}

	output = &StopKeyPhrasesDetectionJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StopKeyPhrasesDetectionJob API operation for Amazon Comprehend.
//
// Stops a key phrases detection job in progress.
//
// If the job state is IN_PROGRESS the job is marked for termination and put
// into the STOP_REQUESTED state. If the job completes before it can be stopped,
// it is put into the COMPLETED state; otherwise the job is stopped and put
// into the STOPPED state.
//
// If the job is in the COMPLETED or FAILED state when you call the StopDominantLanguageDetectionJob
// operation, the operation returns a 400 Internal Request Exception.
//
// When a job is stopped, any documents already processed are written to the
// output location.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation StopKeyPhrasesDetectionJob for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is invalid.
//
//   * JobNotFoundException
//   The specified job was not found. Check the job ID and try again.
//
//   * InternalServerException
//   An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StopKeyPhrasesDetectionJob
func (c *Comprehend) StopKeyPhrasesDetectionJob(input *StopKeyPhrasesDetectionJobInput) (*StopKeyPhrasesDetectionJobOutput, error) {
	req, out := c.StopKeyPhrasesDetectionJobRequest(input)
	return out, req.Send()
}

// StopKeyPhrasesDetectionJobWithContext is the same as StopKeyPhrasesDetectionJob with the addition of
// the ability to pass a context and additional request options.
//
// See StopKeyPhrasesDetectionJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) StopKeyPhrasesDetectionJobWithContext(ctx aws.Context, input *StopKeyPhrasesDetectionJobInput, opts ...request.Option) (*StopKeyPhrasesDetectionJobOutput, error) {
	req, out := c.StopKeyPhrasesDetectionJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopPiiEntitiesDetectionJob = "StopPiiEntitiesDetectionJob"

// StopPiiEntitiesDetectionJobRequest generates a "aws/request.Request" representing the
// client's request for the StopPiiEntitiesDetectionJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopPiiEntitiesDetectionJob for more information on using the StopPiiEntitiesDetectionJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StopPiiEntitiesDetectionJobRequest method.
//    req, resp := client.StopPiiEntitiesDetectionJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StopPiiEntitiesDetectionJob
func (c *Comprehend) StopPiiEntitiesDetectionJobRequest(input *StopPiiEntitiesDetectionJobInput) (req *request.Request, output *StopPiiEntitiesDetectionJobOutput) {
	op := &request.Operation{
		Name:       opStopPiiEntitiesDetectionJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopPiiEntitiesDetectionJobInput{}
	}

	output = &StopPiiEntitiesDetectionJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StopPiiEntitiesDetectionJob API operation for Amazon Comprehend.
//
// Stops a PII entities detection job in progress.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation StopPiiEntitiesDetectionJob for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is invalid.
//
//   * JobNotFoundException
//   The specified job was not found. Check the job ID and try again.
//
//   * InternalServerException
//   An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StopPiiEntitiesDetectionJob
func (c *Comprehend) StopPiiEntitiesDetectionJob(input *StopPiiEntitiesDetectionJobInput) (*StopPiiEntitiesDetectionJobOutput, error) {
	req, out := c.StopPiiEntitiesDetectionJobRequest(input)
	return out, req.Send()
}

// StopPiiEntitiesDetectionJobWithContext is the same as StopPiiEntitiesDetectionJob with the addition of
// the ability to pass a context and additional request options.
//
// See StopPiiEntitiesDetectionJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) StopPiiEntitiesDetectionJobWithContext(ctx aws.Context, input *StopPiiEntitiesDetectionJobInput, opts ...request.Option) (*StopPiiEntitiesDetectionJobOutput, error) {
	req, out := c.StopPiiEntitiesDetectionJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopSentimentDetectionJob = "StopSentimentDetectionJob"

// StopSentimentDetectionJobRequest generates a "aws/request.Request" representing the
// client's request for the StopSentimentDetectionJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopSentimentDetectionJob for more information on using the StopSentimentDetectionJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StopSentimentDetectionJobRequest method.
//    req, resp := client.StopSentimentDetectionJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StopSentimentDetectionJob
func (c *Comprehend) StopSentimentDetectionJobRequest(input *StopSentimentDetectionJobInput) (req *request.Request, output *StopSentimentDetectionJobOutput) {
	op := &request.Operation{
		Name:       opStopSentimentDetectionJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopSentimentDetectionJobInput{}
	}

	output = &StopSentimentDetectionJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StopSentimentDetectionJob API operation for Amazon Comprehend.
//
// Stops a sentiment detection job in progress.
//
// If the job state is IN_PROGRESS the job is marked for termination and put
// into the STOP_REQUESTED state. If the job completes before it can be stopped,
// it is put into the COMPLETED state; otherwise the job is be stopped and put
// into the STOPPED state.
//
// If the job is in the COMPLETED or FAILED state when you call the StopDominantLanguageDetectionJob
// operation, the operation returns a 400 Internal Request Exception.
//
// When a job is stopped, any documents already processed are written to the
// output location.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation StopSentimentDetectionJob for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is invalid.
//
//   * JobNotFoundException
//   The specified job was not found. Check the job ID and try again.
//
//   * InternalServerException
//   An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StopSentimentDetectionJob
func (c *Comprehend) StopSentimentDetectionJob(input *StopSentimentDetectionJobInput) (*StopSentimentDetectionJobOutput, error) {
	req, out := c.StopSentimentDetectionJobRequest(input)
	return out, req.Send()
}

// StopSentimentDetectionJobWithContext is the same as StopSentimentDetectionJob with the addition of
// the ability to pass a context and additional request options.
//
// See StopSentimentDetectionJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) StopSentimentDetectionJobWithContext(ctx aws.Context, input *StopSentimentDetectionJobInput, opts ...request.Option) (*StopSentimentDetectionJobOutput, error) {
	req, out := c.StopSentimentDetectionJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopTrainingDocumentClassifier = "StopTrainingDocumentClassifier"

// StopTrainingDocumentClassifierRequest generates a "aws/request.Request" representing the
// client's request for the StopTrainingDocumentClassifier operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopTrainingDocumentClassifier for more information on using the StopTrainingDocumentClassifier
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StopTrainingDocumentClassifierRequest method.
//    req, resp := client.StopTrainingDocumentClassifierRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StopTrainingDocumentClassifier
func (c *Comprehend) StopTrainingDocumentClassifierRequest(input *StopTrainingDocumentClassifierInput) (req *request.Request, output *StopTrainingDocumentClassifierOutput) {
	op := &request.Operation{
		Name:       opStopTrainingDocumentClassifier,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopTrainingDocumentClassifierInput{}
	}

	output = &StopTrainingDocumentClassifierOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StopTrainingDocumentClassifier API operation for Amazon Comprehend.
//
// Stops a document classifier training job while in progress.
//
// If the training job state is TRAINING, the job is marked for termination
// and put into the STOP_REQUESTED state. If the training job completes before
// it can be stopped, it is put into the TRAINED; otherwise the training job
// is stopped and put into the STOPPED state and the service sends back an HTTP
// 200 response with an empty HTTP body.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation StopTrainingDocumentClassifier for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is invalid.
//
//   * TooManyRequestsException
//   The number of requests exceeds the limit. Resubmit your request later.
//
//   * ResourceNotFoundException
//   The specified resource ARN was not found. Check the ARN and try your request
//   again.
//
//   * InternalServerException
//   An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StopTrainingDocumentClassifier
func (c *Comprehend) StopTrainingDocumentClassifier(input *StopTrainingDocumentClassifierInput) (*StopTrainingDocumentClassifierOutput, error) {
	req, out := c.StopTrainingDocumentClassifierRequest(input)
	return out, req.Send()
}

// StopTrainingDocumentClassifierWithContext is the same as StopTrainingDocumentClassifier with the addition of
// the ability to pass a context and additional request options.
//
// See StopTrainingDocumentClassifier for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) StopTrainingDocumentClassifierWithContext(ctx aws.Context, input *StopTrainingDocumentClassifierInput, opts ...request.Option) (*StopTrainingDocumentClassifierOutput, error) {
	req, out := c.StopTrainingDocumentClassifierRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopTrainingEntityRecognizer = "StopTrainingEntityRecognizer"

// StopTrainingEntityRecognizerRequest generates a "aws/request.Request" representing the
// client's request for the StopTrainingEntityRecognizer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopTrainingEntityRecognizer for more information on using the StopTrainingEntityRecognizer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StopTrainingEntityRecognizerRequest method.
//    req, resp := client.StopTrainingEntityRecognizerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StopTrainingEntityRecognizer
func (c *Comprehend) StopTrainingEntityRecognizerRequest(input *StopTrainingEntityRecognizerInput) (req *request.Request, output *StopTrainingEntityRecognizerOutput) {
	op := &request.Operation{
		Name:       opStopTrainingEntityRecognizer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopTrainingEntityRecognizerInput{}
	}

	output = &StopTrainingEntityRecognizerOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StopTrainingEntityRecognizer API operation for Amazon Comprehend.
//
// Stops an entity recognizer training job while in progress.
//
// If the training job state is TRAINING, the job is marked for termination
// and put into the STOP_REQUESTED state. If the training job completes before
// it can be stopped, it is put into the TRAINED; otherwise the training job
// is stopped and putted into the STOPPED state and the service sends back an
// HTTP 200 response with an empty HTTP body.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation StopTrainingEntityRecognizer for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is invalid.
//
//   * TooManyRequestsException
//   The number of requests exceeds the limit. Resubmit your request later.
//
//   * ResourceNotFoundException
//   The specified resource ARN was not found. Check the ARN and try your request
//   again.
//
//   * InternalServerException
//   An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/StopTrainingEntityRecognizer
func (c *Comprehend) StopTrainingEntityRecognizer(input *StopTrainingEntityRecognizerInput) (*StopTrainingEntityRecognizerOutput, error) {
	req, out := c.StopTrainingEntityRecognizerRequest(input)
	return out, req.Send()
}

// StopTrainingEntityRecognizerWithContext is the same as StopTrainingEntityRecognizer with the addition of
// the ability to pass a context and additional request options.
//
// See StopTrainingEntityRecognizer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) StopTrainingEntityRecognizerWithContext(ctx aws.Context, input *StopTrainingEntityRecognizerInput, opts ...request.Option) (*StopTrainingEntityRecognizerOutput, error) {
	req, out := c.StopTrainingEntityRecognizerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TagResourceRequest method.
//    req, resp := client.TagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/TagResource
func (c *Comprehend) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for Amazon Comprehend.
//
// Associates a specific tag with an Amazon Comprehend resource. A tag is a
// key-value pair that adds as a metadata to a resource used by Amazon Comprehend.
// For example, a tag with "Sales" as the key might be added to a resource to
// indicate its use by the sales department.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is invalid.
//
//   * ConcurrentModificationException
//   Concurrent modification of the tags associated with an Amazon Comprehend
//   resource is not supported.
//
//   * ResourceNotFoundException
//   The specified resource ARN was not found. Check the ARN and try your request
//   again.
//
//   * TooManyTagsException
//   The request contains more tags than can be associated with a resource (50
//   tags per resource). The maximum number of tags includes both existing tags
//   and those included in your current request.
//
//   * InternalServerException
//   An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/TagResource
func (c *Comprehend) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UntagResourceRequest method.
//    req, resp := client.UntagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/UntagResource
func (c *Comprehend) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for Amazon Comprehend.
//
// Removes a specific tag associated with an Amazon Comprehend resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//   * TooManyTagKeysException
//   The request contains more tag keys than can be associated with a resource
//   (50 tag keys per resource).
//
//   * InvalidRequestException
//   The request is invalid.
//
//   * ConcurrentModificationException
//   Concurrent modification of the tags associated with an Amazon Comprehend
//   resource is not supported.
//
//   * ResourceNotFoundException
//   The specified resource ARN was not found. Check the ARN and try your request
//   again.
//
//   * InternalServerException
//   An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/UntagResource
func (c *Comprehend) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateEndpoint = "UpdateEndpoint"

// UpdateEndpointRequest generates a "aws/request.Request" representing the
// client's request for the UpdateEndpoint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateEndpoint for more information on using the UpdateEndpoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateEndpointRequest method.
//    req, resp := client.UpdateEndpointRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/UpdateEndpoint
func (c *Comprehend) UpdateEndpointRequest(input *UpdateEndpointInput) (req *request.Request, output *UpdateEndpointOutput) {
	op := &request.Operation{
		Name:       opUpdateEndpoint,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateEndpointInput{}
	}

	output = &UpdateEndpointOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateEndpoint API operation for Amazon Comprehend.
//
// Updates information about the specified endpoint.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Comprehend's
// API operation UpdateEndpoint for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is invalid.
//
//   * TooManyRequestsException
//   The number of requests exceeds the limit. Resubmit your request later.
//
//   * ResourceInUseException
//   The specified resource name is already in use. Use a different name and try
//   your request again.
//
//   * ResourceLimitExceededException
//   The maximum number of resources per account has been exceeded. Review the
//   resources, and then try your request again.
//
//   * ResourceNotFoundException
//   The specified resource ARN was not found. Check the ARN and try your request
//   again.
//
//   * ResourceUnavailableException
//   The specified resource is not available. Check the resource and try your
//   request again.
//
//   * InternalServerException
//   An internal server error occurred. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/UpdateEndpoint
func (c *Comprehend) UpdateEndpoint(input *UpdateEndpointInput) (*UpdateEndpointOutput, error) {
	req, out := c.UpdateEndpointRequest(input)
	return out, req.Send()
}

// UpdateEndpointWithContext is the same as UpdateEndpoint with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateEndpoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Comprehend) UpdateEndpointWithContext(ctx aws.Context, input *UpdateEndpointInput, opts ...request.Option) (*UpdateEndpointOutput, error) {
	req, out := c.UpdateEndpointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// An augmented manifest file that provides training data for your custom model.
// An augmented manifest file is a labeled dataset that is produced by Amazon
// SageMaker Ground Truth.
type AugmentedManifestsListItem struct {
	_ struct{} `type:"structure"`

	// The JSON attribute that contains the annotations for your training documents.
	// The number of attribute names that you specify depends on whether your augmented
	// manifest file is the output of a single labeling job or a chained labeling
	// job.
	//
	// If your file is the output of a single labeling job, specify the LabelAttributeName
	// key that was used when the job was created in Ground Truth.
	//
	// If your file is the output of a chained labeling job, specify the LabelAttributeName
	// key for one or more jobs in the chain. Each LabelAttributeName key provides
	// the annotations from an individual job.
	//
	// AttributeNames is a required field
	AttributeNames []*string `type:"list" required:"true"`

	// The Amazon S3 location of the augmented manifest file.
	//
	// S3Uri is a required field
	S3Uri *string `type:"string" required:"true"`
}

// String returns the string representation
func (s AugmentedManifestsListItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AugmentedManifestsListItem) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AugmentedManifestsListItem) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AugmentedManifestsListItem"}
	if s.AttributeNames == nil {
		invalidParams.Add(request.NewErrParamRequired("AttributeNames"))
	}
	if s.S3Uri == nil {
		invalidParams.Add(request.NewErrParamRequired("S3Uri"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributeNames sets the AttributeNames field's value.
func (s *AugmentedManifestsListItem) SetAttributeNames(v []*string) *AugmentedManifestsListItem {
	s.AttributeNames = v
	return s
}

// SetS3Uri sets the S3Uri field's value.
func (s *AugmentedManifestsListItem) SetS3Uri(v string) *AugmentedManifestsListItem {
	s.S3Uri = &v
	return s
}

type BatchDetectDominantLanguageInput struct {
	_ struct{} `type:"structure"`

	// A list containing the text of the input documents. The list can contain a
	// maximum of 25 documents. Each document should contain at least 20 characters
	// and must contain fewer than 5,000 bytes of UTF-8 encoded characters.
	//
	// TextList is a required field
	TextList []*string `type:"list" required:"true" sensitive:"true"`
}

// String returns the string representation
func (s BatchDetectDominantLanguageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchDetectDominantLanguageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchDetectDominantLanguageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchDetectDominantLanguageInput"}
	if s.TextList == nil {
		invalidParams.Add(request.NewErrParamRequired("TextList"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTextList sets the TextList field's value.
func (s *BatchDetectDominantLanguageInput) SetTextList(v []*string) *BatchDetectDominantLanguageInput {
	s.TextList = v
	return s
}

// The result of calling the operation. The operation returns one object for
// each document that is successfully processed by the operation.
type BatchDetectDominantLanguageItemResult struct {
	_ struct{} `type:"structure"`

	// The zero-based index of the document in the input list.
	Index *int64 `type:"integer"`

	// One or more DominantLanguage objects describing the dominant languages in
	// the document.
	Languages []*DominantLanguage `type:"list"`
}

// String returns the string representation
func (s BatchDetectDominantLanguageItemResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchDetectDominantLanguageItemResult) GoString() string {
	return s.String()
}

// SetIndex sets the Index field's value.
func (s *BatchDetectDominantLanguageItemResult) SetIndex(v int64) *BatchDetectDominantLanguageItemResult {
	s.Index = &v
	return s
}

// SetLanguages sets the Languages field's value.
func (s *BatchDetectDominantLanguageItemResult) SetLanguages(v []*DominantLanguage) *BatchDetectDominantLanguageItemResult {
	s.Languages = v
	return s
}

type BatchDetectDominantLanguageOutput struct {
	_ struct{} `type:"structure" sensitive:"true"`

	// A list containing one object for each document that contained an error. The
	// results are sorted in ascending order by the Index field and match the order
	// of the documents in the input list. If there are no errors in the batch,
	// the ErrorList is empty.
	//
	// ErrorList is a required field
	ErrorList []*BatchItemError `type:"list" required:"true"`

	// A list of objects containing the results of the operation. The results are
	// sorted in ascending order by the Index field and match the order of the documents
	// in the input list. If all of the documents contain an error, the ResultList
	// is empty.
	//
	// ResultList is a required field
	ResultList []*BatchDetectDominantLanguageItemResult `type:"list" required:"true"`
}

// String returns the string representation
func (s BatchDetectDominantLanguageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchDetectDominantLanguageOutput) GoString() string {
	return s.String()
}

// SetErrorList sets the ErrorList field's value.
func (s *BatchDetectDominantLanguageOutput) SetErrorList(v []*BatchItemError) *BatchDetectDominantLanguageOutput {
	s.ErrorList = v
	return s
}

// SetResultList sets the ResultList field's value.
func (s *BatchDetectDominantLanguageOutput) SetResultList(v []*BatchDetectDominantLanguageItemResult) *BatchDetectDominantLanguageOutput {
	s.ResultList = v
	return s
}

type BatchDetectEntitiesInput struct {
	_ struct{} `type:"structure"`

	// The language of the input documents. You can specify any of the primary languages
	// supported by Amazon Comprehend. All documents must be in the same language.
	//
	// LanguageCode is a required field
	LanguageCode *string `type:"string" required:"true" enum:"LanguageCode"`

	// A list containing the text of the input documents. The list can contain a
	// maximum of 25 documents. Each document must contain fewer than 5,000 bytes
	// of UTF-8 encoded characters.
	//
	// TextList is a required field
	TextList []*string `type:"list" required:"true" sensitive:"true"`
}

// String returns the string representation
func (s BatchDetectEntitiesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchDetectEntitiesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchDetectEntitiesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchDetectEntitiesInput"}
	if s.LanguageCode == nil {
		invalidParams.Add(request.NewErrParamRequired("LanguageCode"))
	}
	if s.TextList == nil {
		invalidParams.Add(request.NewErrParamRequired("TextList"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *BatchDetectEntitiesInput) SetLanguageCode(v string) *BatchDetectEntitiesInput {
	s.LanguageCode = &v
	return s
}

// SetTextList sets the TextList field's value.
func (s *BatchDetectEntitiesInput) SetTextList(v []*string) *BatchDetectEntitiesInput {
	s.TextList = v
	return s
}

// The result of calling the operation. The operation returns one object for
// each document that is successfully processed by the operation.
type BatchDetectEntitiesItemResult struct {
	_ struct{} `type:"structure"`

	// One or more Entity objects, one for each entity detected in the document.
	Entities []*Entity `type:"list"`

	// The zero-based index of the document in the input list.
	Index *int64 `type:"integer"`
}

// String returns the string representation
func (s BatchDetectEntitiesItemResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchDetectEntitiesItemResult) GoString() string {
	return s.String()
}

// SetEntities sets the Entities field's value.
func (s *BatchDetectEntitiesItemResult) SetEntities(v []*Entity) *BatchDetectEntitiesItemResult {
	s.Entities = v
	return s
}

// SetIndex sets the Index field's value.
func (s *BatchDetectEntitiesItemResult) SetIndex(v int64) *BatchDetectEntitiesItemResult {
	s.Index = &v
	return s
}

type BatchDetectEntitiesOutput struct {
	_ struct{} `type:"structure" sensitive:"true"`

	// A list containing one object for each document that contained an error. The
	// results are sorted in ascending order by the Index field and match the order
	// of the documents in the input list. If there are no errors in the batch,
	// the ErrorList is empty.
	//
	// ErrorList is a required field
	ErrorList []*BatchItemError `type:"list" required:"true"`

	// A list of objects containing the results of the operation. The results are
	// sorted in ascending order by the Index field and match the order of the documents
	// in the input list. If all of the documents contain an error, the ResultList
	// is empty.
	//
	// ResultList is a required field
	ResultList []*BatchDetectEntitiesItemResult `type:"list" required:"true"`
}

// String returns the string representation
func (s BatchDetectEntitiesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchDetectEntitiesOutput) GoString() string {
	return s.String()
}

// SetErrorList sets the ErrorList field's value.
func (s *BatchDetectEntitiesOutput) SetErrorList(v []*BatchItemError) *BatchDetectEntitiesOutput {
	s.ErrorList = v
	return s
}

// SetResultList sets the ResultList field's value.
func (s *BatchDetectEntitiesOutput) SetResultList(v []*BatchDetectEntitiesItemResult) *BatchDetectEntitiesOutput {
	s.ResultList = v
	return s
}

type BatchDetectKeyPhrasesInput struct {
	_ struct{} `type:"structure"`

	// The language of the input documents. You can specify any of the primary languages
	// supported by Amazon Comprehend. All documents must be in the same language.
	//
	// LanguageCode is a required field
	LanguageCode *string `type:"string" required:"true" enum:"LanguageCode"`

	// A list containing the text of the input documents. The list can contain a
	// maximum of 25 documents. Each document must contain fewer that 5,000 bytes
	// of UTF-8 encoded characters.
	//
	// TextList is a required field
	TextList []*string `type:"list" required:"true" sensitive:"true"`
}

// String returns the string representation
func (s BatchDetectKeyPhrasesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchDetectKeyPhrasesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchDetectKeyPhrasesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchDetectKeyPhrasesInput"}
	if s.LanguageCode == nil {
		invalidParams.Add(request.NewErrParamRequired("LanguageCode"))
	}
	if s.TextList == nil {
		invalidParams.Add(request.NewErrParamRequired("TextList"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *BatchDetectKeyPhrasesInput) SetLanguageCode(v string) *BatchDetectKeyPhrasesInput {
	s.LanguageCode = &v
	return s
}

// SetTextList sets the TextList field's value.
func (s *BatchDetectKeyPhrasesInput) SetTextList(v []*string) *BatchDetectKeyPhrasesInput {
	s.TextList = v
	return s
}

// The result of calling the operation. The operation returns one object for
// each document that is successfully processed by the operation.
type BatchDetectKeyPhrasesItemResult struct {
	_ struct{} `type:"structure"`

	// The zero-based index of the document in the input list.
	Index *int64 `type:"integer"`

	// One or more KeyPhrase objects, one for each key phrase detected in the document.
	KeyPhrases []*KeyPhrase `type:"list"`
}

// String returns the string representation
func (s BatchDetectKeyPhrasesItemResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchDetectKeyPhrasesItemResult) GoString() string {
	return s.String()
}

// SetIndex sets the Index field's value.
func (s *BatchDetectKeyPhrasesItemResult) SetIndex(v int64) *BatchDetectKeyPhrasesItemResult {
	s.Index = &v
	return s
}

// SetKeyPhrases sets the KeyPhrases field's value.
func (s *BatchDetectKeyPhrasesItemResult) SetKeyPhrases(v []*KeyPhrase) *BatchDetectKeyPhrasesItemResult {
	s.KeyPhrases = v
	return s
}

type BatchDetectKeyPhrasesOutput struct {
	_ struct{} `type:"structure" sensitive:"true"`

	// A list containing one object for each document that contained an error. The
	// results are sorted in ascending order by the Index field and match the order
	// of the documents in the input list. If there are no errors in the batch,
	// the ErrorList is empty.
	//
	// ErrorList is a required field
	ErrorList []*BatchItemError `type:"list" required:"true"`

	// A list of objects containing the results of the operation. The results are
	// sorted in ascending order by the Index field and match the order of the documents
	// in the input list. If all of the documents contain an error, the ResultList
	// is empty.
	//
	// ResultList is a required field
	ResultList []*BatchDetectKeyPhrasesItemResult `type:"list" required:"true"`
}

// String returns the string representation
func (s BatchDetectKeyPhrasesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchDetectKeyPhrasesOutput) GoString() string {
	return s.String()
}

// SetErrorList sets the ErrorList field's value.
func (s *BatchDetectKeyPhrasesOutput) SetErrorList(v []*BatchItemError) *BatchDetectKeyPhrasesOutput {
	s.ErrorList = v
	return s
}

// SetResultList sets the ResultList field's value.
func (s *BatchDetectKeyPhrasesOutput) SetResultList(v []*BatchDetectKeyPhrasesItemResult) *BatchDetectKeyPhrasesOutput {
	s.ResultList = v
	return s
}

type BatchDetectSentimentInput struct {
	_ struct{} `type:"structure"`

	// The language of the input documents. You can specify any of the primary languages
	// supported by Amazon Comprehend. All documents must be in the same language.
	//
	// LanguageCode is a required field
	LanguageCode *string `type:"string" required:"true" enum:"LanguageCode"`

	// A list containing the text of the input documents. The list can contain a
	// maximum of 25 documents. Each document must contain fewer that 5,000 bytes
	// of UTF-8 encoded characters.
	//
	// TextList is a required field
	TextList []*string `type:"list" required:"true" sensitive:"true"`
}

// String returns the string representation
func (s BatchDetectSentimentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchDetectSentimentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchDetectSentimentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchDetectSentimentInput"}
	if s.LanguageCode == nil {
		invalidParams.Add(request.NewErrParamRequired("LanguageCode"))
	}
	if s.TextList == nil {
		invalidParams.Add(request.NewErrParamRequired("TextList"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *BatchDetectSentimentInput) SetLanguageCode(v string) *BatchDetectSentimentInput {
	s.LanguageCode = &v
	return s
}

// SetTextList sets the TextList field's value.
func (s *BatchDetectSentimentInput) SetTextList(v []*string) *BatchDetectSentimentInput {
	s.TextList = v
	return s
}

// The result of calling the operation. The operation returns one object for
// each document that is successfully processed by the operation.
type BatchDetectSentimentItemResult struct {
	_ struct{} `type:"structure"`

	// The zero-based index of the document in the input list.
	Index *int64 `type:"integer"`

	// The sentiment detected in the document.
	Sentiment *string `type:"string" enum:"SentimentType"`

	// The level of confidence that Amazon Comprehend has in the accuracy of its
	// sentiment detection.
	SentimentScore *SentimentScore `type:"structure"`
}

// String returns the string representation
func (s BatchDetectSentimentItemResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchDetectSentimentItemResult) GoString() string {
	return s.String()
}

// SetIndex sets the Index field's value.
func (s *BatchDetectSentimentItemResult) SetIndex(v int64) *BatchDetectSentimentItemResult {
	s.Index = &v
	return s
}

// SetSentiment sets the Sentiment field's value.
func (s *BatchDetectSentimentItemResult) SetSentiment(v string) *BatchDetectSentimentItemResult {
	s.Sentiment = &v
	return s
}

// SetSentimentScore sets the SentimentScore field's value.
func (s *BatchDetectSentimentItemResult) SetSentimentScore(v *SentimentScore) *BatchDetectSentimentItemResult {
	s.SentimentScore = v
	return s
}

type BatchDetectSentimentOutput struct {
	_ struct{} `type:"structure" sensitive:"true"`

	// A list containing one object for each document that contained an error. The
	// results are sorted in ascending order by the Index field and match the order
	// of the documents in the input list. If there are no errors in the batch,
	// the ErrorList is empty.
	//
	// ErrorList is a required field
	ErrorList []*BatchItemError `type:"list" required:"true"`

	// A list of objects containing the results of the operation. The results are
	// sorted in ascending order by the Index field and match the order of the documents
	// in the input list. If all of the documents contain an error, the ResultList
	// is empty.
	//
	// ResultList is a required field
	ResultList []*BatchDetectSentimentItemResult `type:"list" required:"true"`
}

// String returns the string representation
func (s BatchDetectSentimentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchDetectSentimentOutput) GoString() string {
	return s.String()
}

// SetErrorList sets the ErrorList field's value.
func (s *BatchDetectSentimentOutput) SetErrorList(v []*BatchItemError) *BatchDetectSentimentOutput {
	s.ErrorList = v
	return s
}

// SetResultList sets the ResultList field's value.
func (s *BatchDetectSentimentOutput) SetResultList(v []*BatchDetectSentimentItemResult) *BatchDetectSentimentOutput {
	s.ResultList = v
	return s
}

type BatchDetectSyntaxInput struct {
	_ struct{} `type:"structure"`

	// The language of the input documents. You can specify any of the following
	// languages supported by Amazon Comprehend: German ("de"), English ("en"),
	// Spanish ("es"), French ("fr"), Italian ("it"), or Portuguese ("pt"). All
	// documents must be in the same language.
	//
	// LanguageCode is a required field
	LanguageCode *string `type:"string" required:"true" enum:"SyntaxLanguageCode"`

	// A list containing the text of the input documents. The list can contain a
	// maximum of 25 documents. Each document must contain fewer that 5,000 bytes
	// of UTF-8 encoded characters.
	//
	// TextList is a required field
	TextList []*string `type:"list" required:"true" sensitive:"true"`
}

// String returns the string representation
func (s BatchDetectSyntaxInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchDetectSyntaxInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchDetectSyntaxInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchDetectSyntaxInput"}
	if s.LanguageCode == nil {
		invalidParams.Add(request.NewErrParamRequired("LanguageCode"))
	}
	if s.TextList == nil {
		invalidParams.Add(request.NewErrParamRequired("TextList"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *BatchDetectSyntaxInput) SetLanguageCode(v string) *BatchDetectSyntaxInput {
	s.LanguageCode = &v
	return s
}

// SetTextList sets the TextList field's value.
func (s *BatchDetectSyntaxInput) SetTextList(v []*string) *BatchDetectSyntaxInput {
	s.TextList = v
	return s
}

// The result of calling the operation. The operation returns one object that
// is successfully processed by the operation.
type BatchDetectSyntaxItemResult struct {
	_ struct{} `type:"structure"`

	// The zero-based index of the document in the input list.
	Index *int64 `type:"integer"`

	// The syntax tokens for the words in the document, one token for each word.
	SyntaxTokens []*SyntaxToken `type:"list"`
}

// String returns the string representation
func (s BatchDetectSyntaxItemResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchDetectSyntaxItemResult) GoString() string {
	return s.String()
}

// SetIndex sets the Index field's value.
func (s *BatchDetectSyntaxItemResult) SetIndex(v int64) *BatchDetectSyntaxItemResult {
	s.Index = &v
	return s
}

// SetSyntaxTokens sets the SyntaxTokens field's value.
func (s *BatchDetectSyntaxItemResult) SetSyntaxTokens(v []*SyntaxToken) *BatchDetectSyntaxItemResult {
	s.SyntaxTokens = v
	return s
}

type BatchDetectSyntaxOutput struct {
	_ struct{} `type:"structure" sensitive:"true"`

	// A list containing one object for each document that contained an error. The
	// results are sorted in ascending order by the Index field and match the order
	// of the documents in the input list. If there are no errors in the batch,
	// the ErrorList is empty.
	//
	// ErrorList is a required field
	ErrorList []*BatchItemError `type:"list" required:"true"`

	// A list of objects containing the results of the operation. The results are
	// sorted in ascending order by the Index field and match the order of the documents
	// in the input list. If all of the documents contain an error, the ResultList
	// is empty.
	//
	// ResultList is a required field
	ResultList []*BatchDetectSyntaxItemResult `type:"list" required:"true"`
}

// String returns the string representation
func (s BatchDetectSyntaxOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchDetectSyntaxOutput) GoString() string {
	return s.String()
}

// SetErrorList sets the ErrorList field's value.
func (s *BatchDetectSyntaxOutput) SetErrorList(v []*BatchItemError) *BatchDetectSyntaxOutput {
	s.ErrorList = v
	return s
}

// SetResultList sets the ResultList field's value.
func (s *BatchDetectSyntaxOutput) SetResultList(v []*BatchDetectSyntaxItemResult) *BatchDetectSyntaxOutput {
	s.ResultList = v
	return s
}

// Describes an error that occurred while processing a document in a batch.
// The operation returns on BatchItemError object for each document that contained
// an error.
type BatchItemError struct {
	_ struct{} `type:"structure"`

	// The numeric error code of the error.
	ErrorCode *string `min:"1" type:"string"`

	// A text description of the error.
	ErrorMessage *string `min:"1" type:"string"`

	// The zero-based index of the document in the input list.
	Index *int64 `type:"integer"`
}

// String returns the string representation
func (s BatchItemError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchItemError) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *BatchItemError) SetErrorCode(v string) *BatchItemError {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *BatchItemError) SetErrorMessage(v string) *BatchItemError {
	s.ErrorMessage = &v
	return s
}

// SetIndex sets the Index field's value.
func (s *BatchItemError) SetIndex(v int64) *BatchItemError {
	s.Index = &v
	return s
}

// The number of documents in the request exceeds the limit of 25. Try your
// request again with fewer documents.
type BatchSizeLimitExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation
func (s BatchSizeLimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchSizeLimitExceededException) GoString() string {
	return s.String()
}

func newErrorBatchSizeLimitExceededException(v protocol.ResponseMetadata) error {
	return &BatchSizeLimitExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *BatchSizeLimitExceededException) Code() string {
	return "BatchSizeLimitExceededException"
}

// Message returns the exception's message.
func (s *BatchSizeLimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *BatchSizeLimitExceededException) OrigErr() error {
	return nil
}

func (s *BatchSizeLimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *BatchSizeLimitExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *BatchSizeLimitExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Describes the result metrics for the test data associated with an documentation
// classifier.
type ClassifierEvaluationMetrics struct {
	_ struct{} `type:"structure"`

	// The fraction of the labels that were correct recognized. It is computed by
	// dividing the number of labels in the test documents that were correctly recognized
	// by the total number of labels in the test documents.
	Accuracy *float64 `type:"double"`

	// A measure of how accurate the classifier results are for the test data. It
	// is derived from the Precision and Recall values. The F1Score is the harmonic
	// average of the two scores. The highest score is 1, and the worst score is
	// 0.
	F1Score *float64 `type:"double"`

	// Indicates the fraction of labels that are incorrectly predicted. Also seen
	// as the fraction of wrong labels compared to the total number of labels. Scores
	// closer to zero are better.
	HammingLoss *float64 `type:"double"`

	// A measure of how accurate the classifier results are for the test data. It
	// is a combination of the Micro Precision and Micro Recall values. The Micro
	// F1Score is the harmonic mean of the two scores. The highest score is 1, and
	// the worst score is 0.
	MicroF1Score *float64 `type:"double"`

	// A measure of the usefulness of the recognizer results in the test data. High
	// precision means that the recognizer returned substantially more relevant
	// results than irrelevant ones. Unlike the Precision metric which comes from
	// averaging the precision of all available labels, this is based on the overall
	// score of all precision scores added together.
	MicroPrecision *float64 `type:"double"`

	// A measure of how complete the classifier results are for the test data. High
	// recall means that the classifier returned most of the relevant results. Specifically,
	// this indicates how many of the correct categories in the text that the model
	// can predict. It is a percentage of correct categories in the text that can
	// found. Instead of averaging the recall scores of all labels (as with Recall),
	// micro Recall is based on the overall score of all recall scores added together.
	MicroRecall *float64 `type:"double"`

	// A measure of the usefulness of the classifier results in the test data. High
	// precision means that the classifier returned substantially more relevant
	// results than irrelevant ones.
	Precision *float64 `type:"double"`

	// A measure of how complete the classifier results are for the test data. High
	// recall means that the classifier returned most of the relevant results.
	Recall *float64 `type:"double"`
}

// String returns the string representation
func (s ClassifierEvaluationMetrics) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ClassifierEvaluationMetrics) GoString() string {
	return s.String()
}

// SetAccuracy sets the Accuracy field's value.
func (s *ClassifierEvaluationMetrics) SetAccuracy(v float64) *ClassifierEvaluationMetrics {
	s.Accuracy = &v
	return s
}

// SetF1Score sets the F1Score field's value.
func (s *ClassifierEvaluationMetrics) SetF1Score(v float64) *ClassifierEvaluationMetrics {
	s.F1Score = &v
	return s
}

// SetHammingLoss sets the HammingLoss field's value.
func (s *ClassifierEvaluationMetrics) SetHammingLoss(v float64) *ClassifierEvaluationMetrics {
	s.HammingLoss = &v
	return s
}

// SetMicroF1Score sets the MicroF1Score field's value.
func (s *ClassifierEvaluationMetrics) SetMicroF1Score(v float64) *ClassifierEvaluationMetrics {
	s.MicroF1Score = &v
	return s
}

// SetMicroPrecision sets the MicroPrecision field's value.
func (s *ClassifierEvaluationMetrics) SetMicroPrecision(v float64) *ClassifierEvaluationMetrics {
	s.MicroPrecision = &v
	return s
}

// SetMicroRecall sets the MicroRecall field's value.
func (s *ClassifierEvaluationMetrics) SetMicroRecall(v float64) *ClassifierEvaluationMetrics {
	s.MicroRecall = &v
	return s
}

// SetPrecision sets the Precision field's value.
func (s *ClassifierEvaluationMetrics) SetPrecision(v float64) *ClassifierEvaluationMetrics {
	s.Precision = &v
	return s
}

// SetRecall sets the Recall field's value.
func (s *ClassifierEvaluationMetrics) SetRecall(v float64) *ClassifierEvaluationMetrics {
	s.Recall = &v
	return s
}

// Provides information about a document classifier.
type ClassifierMetadata struct {
	_ struct{} `type:"structure" sensitive:"true"`

	// Describes the result metrics for the test data associated with an documentation
	// classifier.
	EvaluationMetrics *ClassifierEvaluationMetrics `type:"structure"`

	// The number of labels in the input data.
	NumberOfLabels *int64 `type:"integer"`

	// The number of documents in the input data that were used to test the classifier.
	// Typically this is 10 to 20 percent of the input documents, up to 10,000 documents.
	NumberOfTestDocuments *int64 `type:"integer"`

	// The number of documents in the input data that were used to train the classifier.
	// Typically this is 80 to 90 percent of the input documents.
	NumberOfTrainedDocuments *int64 `type:"integer"`
}

// String returns the string representation
func (s ClassifierMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ClassifierMetadata) GoString() string {
	return s.String()
}

// SetEvaluationMetrics sets the EvaluationMetrics field's value.
func (s *ClassifierMetadata) SetEvaluationMetrics(v *ClassifierEvaluationMetrics) *ClassifierMetadata {
	s.EvaluationMetrics = v
	return s
}

// SetNumberOfLabels sets the NumberOfLabels field's value.
func (s *ClassifierMetadata) SetNumberOfLabels(v int64) *ClassifierMetadata {
	s.NumberOfLabels = &v
	return s
}

// SetNumberOfTestDocuments sets the NumberOfTestDocuments field's value.
func (s *ClassifierMetadata) SetNumberOfTestDocuments(v int64) *ClassifierMetadata {
	s.NumberOfTestDocuments = &v
	return s
}

// SetNumberOfTrainedDocuments sets the NumberOfTrainedDocuments field's value.
func (s *ClassifierMetadata) SetNumberOfTrainedDocuments(v int64) *ClassifierMetadata {
	s.NumberOfTrainedDocuments = &v
	return s
}

type ClassifyDocumentInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Number (ARN) of the endpoint.
	//
	// EndpointArn is a required field
	EndpointArn *string `type:"string" required:"true"`

	// The document text to be analyzed.
	//
	// Text is a required field
	Text *string `min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation
func (s ClassifyDocumentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ClassifyDocumentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ClassifyDocumentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ClassifyDocumentInput"}
	if s.EndpointArn == nil {
		invalidParams.Add(request.NewErrParamRequired("EndpointArn"))
	}
	if s.Text == nil {
		invalidParams.Add(request.NewErrParamRequired("Text"))
	}
	if s.Text != nil && len(*s.Text) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Text", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndpointArn sets the EndpointArn field's value.
func (s *ClassifyDocumentInput) SetEndpointArn(v string) *ClassifyDocumentInput {
	s.EndpointArn = &v
	return s
}

// SetText sets the Text field's value.
func (s *ClassifyDocumentInput) SetText(v string) *ClassifyDocumentInput {
	s.Text = &v
	return s
}

type ClassifyDocumentOutput struct {
	_ struct{} `type:"structure" sensitive:"true"`

	// The classes used by the document being analyzed. These are used for multi-class
	// trained models. Individual classes are mutually exclusive and each document
	// is expected to have only a single class assigned to it. For example, an animal
	// can be a dog or a cat, but not both at the same time.
	Classes []*DocumentClass `type:"list"`

	// The labels used the document being analyzed. These are used for multi-label
	// trained models. Individual labels represent different categories that are
	// related in some manner and are not multually exclusive. For example, a movie
	// can be just an action movie, or it can be an action movie, a science fiction
	// movie, and a comedy, all at the same time.
	Labels []*DocumentLabel `type:"list"`
}

// String returns the string representation
func (s ClassifyDocumentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ClassifyDocumentOutput) GoString() string {
	return s.String()
}

// SetClasses sets the Classes field's value.
func (s *ClassifyDocumentOutput) SetClasses(v []*DocumentClass) *ClassifyDocumentOutput {
	s.Classes = v
	return s
}

// SetLabels sets the Labels field's value.
func (s *ClassifyDocumentOutput) SetLabels(v []*DocumentLabel) *ClassifyDocumentOutput {
	s.Labels = v
	return s
}

// Concurrent modification of the tags associated with an Amazon Comprehend
// resource is not supported.
type ConcurrentModificationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation
func (s ConcurrentModificationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConcurrentModificationException) GoString() string {
	return s.String()
}

func newErrorConcurrentModificationException(v protocol.ResponseMetadata) error {
	return &ConcurrentModificationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConcurrentModificationException) Code() string {
	return "ConcurrentModificationException"
}

// Message returns the exception's message.
func (s *ConcurrentModificationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConcurrentModificationException) OrigErr() error {
	return nil
}

func (s *ConcurrentModificationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConcurrentModificationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConcurrentModificationException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CreateDocumentClassifierInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the request. If you don't set the client request
	// token, Amazon Comprehend generates one.
	ClientRequestToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// The Amazon Resource Name (ARN) of the AWS Identity and Management (IAM) role
	// that grants Amazon Comprehend read access to your input data.
	//
	// DataAccessRoleArn is a required field
	DataAccessRoleArn *string `min:"20" type:"string" required:"true"`

	// The name of the document classifier.
	//
	// DocumentClassifierName is a required field
	DocumentClassifierName *string `type:"string" required:"true"`

	// Specifies the format and location of the input data for the job.
	//
	// InputDataConfig is a required field
	InputDataConfig *DocumentClassifierInputDataConfig `type:"structure" required:"true"`

	// The language of the input documents. You can specify any of the following
	// languages supported by Amazon Comprehend: German ("de"), English ("en"),
	// Spanish ("es"), French ("fr"), Italian ("it"), or Portuguese ("pt"). All
	// documents must be in the same language.
	//
	// LanguageCode is a required field
	LanguageCode *string `type:"string" required:"true" enum:"LanguageCode"`

	// Indicates the mode in which the classifier will be trained. The classifier
	// can be trained in multi-class mode, which identifies one and only one class
	// for each document, or multi-label mode, which identifies one or more labels
	// for each document. In multi-label mode, multiple labels for an individual
	// document are separated by a delimiter. The default delimiter between labels
	// is a pipe (|).
	Mode *string `type:"string" enum:"DocumentClassifierMode"`

	// Enables the addition of output results configuration parameters for custom
	// classifier jobs.
	OutputDataConfig *DocumentClassifierOutputDataConfig `type:"structure"`

	// Tags to be associated with the document classifier being created. A tag is
	// a key-value pair that adds as a metadata to a resource used by Amazon Comprehend.
	// For example, a tag with "Sales" as the key might be added to a resource to
	// indicate its use by the sales department.
	Tags []*Tag `type:"list"`

	// ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses
	// to encrypt data on the storage volume attached to the ML compute instance(s)
	// that process the analysis job. The VolumeKmsKeyId can be either of the following
	// formats:
	//
	//    * KMS Key ID: "1234abcd-12ab-34cd-56ef-1234567890ab"
	//
	//    * Amazon Resource Name (ARN) of a KMS Key: "arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"
	VolumeKmsKeyId *string `type:"string"`

	// Configuration parameters for an optional private Virtual Private Cloud (VPC)
	// containing the resources you are using for your custom classifier. For more
	// information, see Amazon VPC (https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html).
	VpcConfig *VpcConfig `type:"structure"`
}

// String returns the string representation
func (s CreateDocumentClassifierInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDocumentClassifierInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDocumentClassifierInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDocumentClassifierInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.DataAccessRoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DataAccessRoleArn"))
	}
	if s.DataAccessRoleArn != nil && len(*s.DataAccessRoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("DataAccessRoleArn", 20))
	}
	if s.DocumentClassifierName == nil {
		invalidParams.Add(request.NewErrParamRequired("DocumentClassifierName"))
	}
	if s.InputDataConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("InputDataConfig"))
	}
	if s.LanguageCode == nil {
		invalidParams.Add(request.NewErrParamRequired("LanguageCode"))
	}
	if s.InputDataConfig != nil {
		if err := s.InputDataConfig.Validate(); err != nil {
			invalidParams.AddNested("InputDataConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.VpcConfig != nil {
		if err := s.VpcConfig.Validate(); err != nil {
			invalidParams.AddNested("VpcConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *CreateDocumentClassifierInput) SetClientRequestToken(v string) *CreateDocumentClassifierInput {
	s.ClientRequestToken = &v
	return s
}

// SetDataAccessRoleArn sets the DataAccessRoleArn field's value.
func (s *CreateDocumentClassifierInput) SetDataAccessRoleArn(v string) *CreateDocumentClassifierInput {
	s.DataAccessRoleArn = &v
	return s
}

// SetDocumentClassifierName sets the DocumentClassifierName field's value.
func (s *CreateDocumentClassifierInput) SetDocumentClassifierName(v string) *CreateDocumentClassifierInput {
	s.DocumentClassifierName = &v
	return s
}

// SetInputDataConfig sets the InputDataConfig field's value.
func (s *CreateDocumentClassifierInput) SetInputDataConfig(v *DocumentClassifierInputDataConfig) *CreateDocumentClassifierInput {
	s.InputDataConfig = v
	return s
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *CreateDocumentClassifierInput) SetLanguageCode(v string) *CreateDocumentClassifierInput {
	s.LanguageCode = &v
	return s
}

// SetMode sets the Mode field's value.
func (s *CreateDocumentClassifierInput) SetMode(v string) *CreateDocumentClassifierInput {
	s.Mode = &v
	return s
}

// SetOutputDataConfig sets the OutputDataConfig field's value.
func (s *CreateDocumentClassifierInput) SetOutputDataConfig(v *DocumentClassifierOutputDataConfig) *CreateDocumentClassifierInput {
	s.OutputDataConfig = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateDocumentClassifierInput) SetTags(v []*Tag) *CreateDocumentClassifierInput {
	s.Tags = v
	return s
}

// SetVolumeKmsKeyId sets the VolumeKmsKeyId field's value.
func (s *CreateDocumentClassifierInput) SetVolumeKmsKeyId(v string) *CreateDocumentClassifierInput {
	s.VolumeKmsKeyId = &v
	return s
}

// SetVpcConfig sets the VpcConfig field's value.
func (s *CreateDocumentClassifierInput) SetVpcConfig(v *VpcConfig) *CreateDocumentClassifierInput {
	s.VpcConfig = v
	return s
}

type CreateDocumentClassifierOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) that identifies the document classifier.
	DocumentClassifierArn *string `type:"string"`
}

// String returns the string representation
func (s CreateDocumentClassifierOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDocumentClassifierOutput) GoString() string {
	return s.String()
}

// SetDocumentClassifierArn sets the DocumentClassifierArn field's value.
func (s *CreateDocumentClassifierOutput) SetDocumentClassifierArn(v string) *CreateDocumentClassifierOutput {
	s.DocumentClassifierArn = &v
	return s
}

type CreateEndpointInput struct {
	_ struct{} `type:"structure"`

	// An idempotency token provided by the customer. If this token matches a previous
	// endpoint creation request, Amazon Comprehend will not return a ResourceInUseException.
	ClientRequestToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// The desired number of inference units to be used by the model using this
	// endpoint. Each inference unit represents of a throughput of 100 characters
	// per second.
	//
	// DesiredInferenceUnits is a required field
	DesiredInferenceUnits *int64 `min:"1" type:"integer" required:"true"`

	// This is the descriptive suffix that becomes part of the EndpointArn used
	// for all subsequent requests to this resource.
	//
	// EndpointName is a required field
	EndpointName *string `type:"string" required:"true"`

	// The Amazon Resource Number (ARN) of the model to which the endpoint will
	// be attached.
	//
	// ModelArn is a required field
	ModelArn *string `type:"string" required:"true"`

	// Tags associated with the endpoint being created. A tag is a key-value pair
	// that adds metadata to the endpoint. For example, a tag with "Sales" as the
	// key might be added to an endpoint to indicate its use by the sales department.
	Tags []*Tag `type:"list"`
}

// String returns the string representation
func (s CreateEndpointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateEndpointInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateEndpointInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateEndpointInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.DesiredInferenceUnits == nil {
		invalidParams.Add(request.NewErrParamRequired("DesiredInferenceUnits"))
	}
	if s.DesiredInferenceUnits != nil && *s.DesiredInferenceUnits < 1 {
		invalidParams.Add(request.NewErrParamMinValue("DesiredInferenceUnits", 1))
	}
	if s.EndpointName == nil {
		invalidParams.Add(request.NewErrParamRequired("EndpointName"))
	}
	if s.ModelArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ModelArn"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *CreateEndpointInput) SetClientRequestToken(v string) *CreateEndpointInput {
	s.ClientRequestToken = &v
	return s
}

// SetDesiredInferenceUnits sets the DesiredInferenceUnits field's value.
func (s *CreateEndpointInput) SetDesiredInferenceUnits(v int64) *CreateEndpointInput {
	s.DesiredInferenceUnits = &v
	return s
}

// SetEndpointName sets the EndpointName field's value.
func (s *CreateEndpointInput) SetEndpointName(v string) *CreateEndpointInput {
	s.EndpointName = &v
	return s
}

// SetModelArn sets the ModelArn field's value.
func (s *CreateEndpointInput) SetModelArn(v string) *CreateEndpointInput {
	s.ModelArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateEndpointInput) SetTags(v []*Tag) *CreateEndpointInput {
	s.Tags = v
	return s
}

type CreateEndpointOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Number (ARN) of the endpoint being created.
	EndpointArn *string `type:"string"`
}

// String returns the string representation
func (s CreateEndpointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateEndpointOutput) GoString() string {
	return s.String()
}

// SetEndpointArn sets the EndpointArn field's value.
func (s *CreateEndpointOutput) SetEndpointArn(v string) *CreateEndpointOutput {
	s.EndpointArn = &v
	return s
}

type CreateEntityRecognizerInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the request. If you don't set the client request
	// token, Amazon Comprehend generates one.
	ClientRequestToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// The Amazon Resource Name (ARN) of the AWS Identity and Management (IAM) role
	// that grants Amazon Comprehend read access to your input data.
	//
	// DataAccessRoleArn is a required field
	DataAccessRoleArn *string `min:"20" type:"string" required:"true"`

	// Specifies the format and location of the input data. The S3 bucket containing
	// the input data must be located in the same region as the entity recognizer
	// being created.
	//
	// InputDataConfig is a required field
	InputDataConfig *EntityRecognizerInputDataConfig `type:"structure" required:"true"`

	// You can specify any of the following languages supported by Amazon Comprehend:
	// English ("en"), Spanish ("es"), French ("fr"), Italian ("it"), German ("de"),
	// or Portuguese ("pt"). All documents must be in the same language.
	//
	// LanguageCode is a required field
	LanguageCode *string `type:"string" required:"true" enum:"LanguageCode"`

	// The name given to the newly created recognizer. Recognizer names can be a
	// maximum of 256 characters. Alphanumeric characters, hyphens (-) and underscores
	// (_) are allowed. The name must be unique in the account/region.
	//
	// RecognizerName is a required field
	RecognizerName *string `type:"string" required:"true"`

	// Tags to be associated with the entity recognizer being created. A tag is
	// a key-value pair that adds as a metadata to a resource used by Amazon Comprehend.
	// For example, a tag with "Sales" as the key might be added to a resource to
	// indicate its use by the sales department.
	Tags []*Tag `type:"list"`

	// ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses
	// to encrypt data on the storage volume attached to the ML compute instance(s)
	// that process the analysis job. The VolumeKmsKeyId can be either of the following
	// formats:
	//
	//    * KMS Key ID: "1234abcd-12ab-34cd-56ef-1234567890ab"
	//
	//    * Amazon Resource Name (ARN) of a KMS Key: "arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"
	VolumeKmsKeyId *string `type:"string"`

	// Configuration parameters for an optional private Virtual Private Cloud (VPC)
	// containing the resources you are using for your custom entity recognizer.
	// For more information, see Amazon VPC (https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html).
	VpcConfig *VpcConfig `type:"structure"`
}

// String returns the string representation
func (s CreateEntityRecognizerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateEntityRecognizerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateEntityRecognizerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateEntityRecognizerInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.DataAccessRoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DataAccessRoleArn"))
	}
	if s.DataAccessRoleArn != nil && len(*s.DataAccessRoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("DataAccessRoleArn", 20))
	}
	if s.InputDataConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("InputDataConfig"))
	}
	if s.LanguageCode == nil {
		invalidParams.Add(request.NewErrParamRequired("LanguageCode"))
	}
	if s.RecognizerName == nil {
		invalidParams.Add(request.NewErrParamRequired("RecognizerName"))
	}
	if s.InputDataConfig != nil {
		if err := s.InputDataConfig.Validate(); err != nil {
			invalidParams.AddNested("InputDataConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.VpcConfig != nil {
		if err := s.VpcConfig.Validate(); err != nil {
			invalidParams.AddNested("VpcConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *CreateEntityRecognizerInput) SetClientRequestToken(v string) *CreateEntityRecognizerInput {
	s.ClientRequestToken = &v
	return s
}

// SetDataAccessRoleArn sets the DataAccessRoleArn field's value.
func (s *CreateEntityRecognizerInput) SetDataAccessRoleArn(v string) *CreateEntityRecognizerInput {
	s.DataAccessRoleArn = &v
	return s
}

// SetInputDataConfig sets the InputDataConfig field's value.
func (s *CreateEntityRecognizerInput) SetInputDataConfig(v *EntityRecognizerInputDataConfig) *CreateEntityRecognizerInput {
	s.InputDataConfig = v
	return s
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *CreateEntityRecognizerInput) SetLanguageCode(v string) *CreateEntityRecognizerInput {
	s.LanguageCode = &v
	return s
}

// SetRecognizerName sets the RecognizerName field's value.
func (s *CreateEntityRecognizerInput) SetRecognizerName(v string) *CreateEntityRecognizerInput {
	s.RecognizerName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateEntityRecognizerInput) SetTags(v []*Tag) *CreateEntityRecognizerInput {
	s.Tags = v
	return s
}

// SetVolumeKmsKeyId sets the VolumeKmsKeyId field's value.
func (s *CreateEntityRecognizerInput) SetVolumeKmsKeyId(v string) *CreateEntityRecognizerInput {
	s.VolumeKmsKeyId = &v
	return s
}

// SetVpcConfig sets the VpcConfig field's value.
func (s *CreateEntityRecognizerInput) SetVpcConfig(v *VpcConfig) *CreateEntityRecognizerInput {
	s.VpcConfig = v
	return s
}

type CreateEntityRecognizerOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) that identifies the entity recognizer.
	EntityRecognizerArn *string `type:"string"`
}

// String returns the string representation
func (s CreateEntityRecognizerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateEntityRecognizerOutput) GoString() string {
	return s.String()
}

// SetEntityRecognizerArn sets the EntityRecognizerArn field's value.
func (s *CreateEntityRecognizerOutput) SetEntityRecognizerArn(v string) *CreateEntityRecognizerOutput {
	s.EntityRecognizerArn = &v
	return s
}

type DeleteDocumentClassifierInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) that identifies the document classifier.
	//
	// DocumentClassifierArn is a required field
	DocumentClassifierArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteDocumentClassifierInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDocumentClassifierInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDocumentClassifierInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDocumentClassifierInput"}
	if s.DocumentClassifierArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DocumentClassifierArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDocumentClassifierArn sets the DocumentClassifierArn field's value.
func (s *DeleteDocumentClassifierInput) SetDocumentClassifierArn(v string) *DeleteDocumentClassifierInput {
	s.DocumentClassifierArn = &v
	return s
}

type DeleteDocumentClassifierOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteDocumentClassifierOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDocumentClassifierOutput) GoString() string {
	return s.String()
}

type DeleteEndpointInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Number (ARN) of the endpoint being deleted.
	//
	// EndpointArn is a required field
	EndpointArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteEndpointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteEndpointInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteEndpointInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteEndpointInput"}
	if s.EndpointArn == nil {
		invalidParams.Add(request.NewErrParamRequired("EndpointArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndpointArn sets the EndpointArn field's value.
func (s *DeleteEndpointInput) SetEndpointArn(v string) *DeleteEndpointInput {
	s.EndpointArn = &v
	return s
}

type DeleteEndpointOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteEndpointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteEndpointOutput) GoString() string {
	return s.String()
}

type DeleteEntityRecognizerInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) that identifies the entity recognizer.
	//
	// EntityRecognizerArn is a required field
	EntityRecognizerArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteEntityRecognizerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteEntityRecognizerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteEntityRecognizerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteEntityRecognizerInput"}
	if s.EntityRecognizerArn == nil {
		invalidParams.Add(request.NewErrParamRequired("EntityRecognizerArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEntityRecognizerArn sets the EntityRecognizerArn field's value.
func (s *DeleteEntityRecognizerInput) SetEntityRecognizerArn(v string) *DeleteEntityRecognizerInput {
	s.EntityRecognizerArn = &v
	return s
}

type DeleteEntityRecognizerOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteEntityRecognizerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteEntityRecognizerOutput) GoString() string {
	return s.String()
}

type DescribeDocumentClassificationJobInput struct {
	_ struct{} `type:"structure"`

	// The identifier that Amazon Comprehend generated for the job. The operation
	// returns this identifier in its response.
	//
	// JobId is a required field
	JobId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeDocumentClassificationJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDocumentClassificationJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDocumentClassificationJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDocumentClassificationJobInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobId sets the JobId field's value.
func (s *DescribeDocumentClassificationJobInput) SetJobId(v string) *DescribeDocumentClassificationJobInput {
	s.JobId = &v
	return s
}

type DescribeDocumentClassificationJobOutput struct {
	_ struct{} `type:"structure"`

	// An object that describes the properties associated with the document classification
	// job.
	DocumentClassificationJobProperties *DocumentClassificationJobProperties `type:"structure"`
}

// String returns the string representation
func (s DescribeDocumentClassificationJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDocumentClassificationJobOutput) GoString() string {
	return s.String()
}

// SetDocumentClassificationJobProperties sets the DocumentClassificationJobProperties field's value.
func (s *DescribeDocumentClassificationJobOutput) SetDocumentClassificationJobProperties(v *DocumentClassificationJobProperties) *DescribeDocumentClassificationJobOutput {
	s.DocumentClassificationJobProperties = v
	return s
}

type DescribeDocumentClassifierInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) that identifies the document classifier. The
	// operation returns this identifier in its response.
	//
	// DocumentClassifierArn is a required field
	DocumentClassifierArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeDocumentClassifierInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDocumentClassifierInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDocumentClassifierInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDocumentClassifierInput"}
	if s.DocumentClassifierArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DocumentClassifierArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDocumentClassifierArn sets the DocumentClassifierArn field's value.
func (s *DescribeDocumentClassifierInput) SetDocumentClassifierArn(v string) *DescribeDocumentClassifierInput {
	s.DocumentClassifierArn = &v
	return s
}

type DescribeDocumentClassifierOutput struct {
	_ struct{} `type:"structure"`

	// An object that contains the properties associated with a document classifier.
	DocumentClassifierProperties *DocumentClassifierProperties `type:"structure"`
}

// String returns the string representation
func (s DescribeDocumentClassifierOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDocumentClassifierOutput) GoString() string {
	return s.String()
}

// SetDocumentClassifierProperties sets the DocumentClassifierProperties field's value.
func (s *DescribeDocumentClassifierOutput) SetDocumentClassifierProperties(v *DocumentClassifierProperties) *DescribeDocumentClassifierOutput {
	s.DocumentClassifierProperties = v
	return s
}

type DescribeDominantLanguageDetectionJobInput struct {
	_ struct{} `type:"structure"`

	// The identifier that Amazon Comprehend generated for the job. The operation
	// returns this identifier in its response.
	//
	// JobId is a required field
	JobId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeDominantLanguageDetectionJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDominantLanguageDetectionJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDominantLanguageDetectionJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDominantLanguageDetectionJobInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobId sets the JobId field's value.
func (s *DescribeDominantLanguageDetectionJobInput) SetJobId(v string) *DescribeDominantLanguageDetectionJobInput {
	s.JobId = &v
	return s
}

type DescribeDominantLanguageDetectionJobOutput struct {
	_ struct{} `type:"structure"`

	// An object that contains the properties associated with a dominant language
	// detection job.
	DominantLanguageDetectionJobProperties *DominantLanguageDetectionJobProperties `type:"structure"`
}

// String returns the string representation
func (s DescribeDominantLanguageDetectionJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDominantLanguageDetectionJobOutput) GoString() string {
	return s.String()
}

// SetDominantLanguageDetectionJobProperties sets the DominantLanguageDetectionJobProperties field's value.
func (s *DescribeDominantLanguageDetectionJobOutput) SetDominantLanguageDetectionJobProperties(v *DominantLanguageDetectionJobProperties) *DescribeDominantLanguageDetectionJobOutput {
	s.DominantLanguageDetectionJobProperties = v
	return s
}

type DescribeEndpointInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Number (ARN) of the endpoint being described.
	//
	// EndpointArn is a required field
	EndpointArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeEndpointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEndpointInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeEndpointInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeEndpointInput"}
	if s.EndpointArn == nil {
		invalidParams.Add(request.NewErrParamRequired("EndpointArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndpointArn sets the EndpointArn field's value.
func (s *DescribeEndpointInput) SetEndpointArn(v string) *DescribeEndpointInput {
	s.EndpointArn = &v
	return s
}

type DescribeEndpointOutput struct {
	_ struct{} `type:"structure"`

	// Describes information associated with the specific endpoint.
	EndpointProperties *EndpointProperties `type:"structure"`
}

// String returns the string representation
func (s DescribeEndpointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEndpointOutput) GoString() string {
	return s.String()
}

// SetEndpointProperties sets the EndpointProperties field's value.
func (s *DescribeEndpointOutput) SetEndpointProperties(v *EndpointProperties) *DescribeEndpointOutput {
	s.EndpointProperties = v
	return s
}

type DescribeEntitiesDetectionJobInput struct {
	_ struct{} `type:"structure"`

	// The identifier that Amazon Comprehend generated for the job. The operation
	// returns this identifier in its response.
	//
	// JobId is a required field
	JobId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeEntitiesDetectionJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEntitiesDetectionJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeEntitiesDetectionJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeEntitiesDetectionJobInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobId sets the JobId field's value.
func (s *DescribeEntitiesDetectionJobInput) SetJobId(v string) *DescribeEntitiesDetectionJobInput {
	s.JobId = &v
	return s
}

type DescribeEntitiesDetectionJobOutput struct {
	_ struct{} `type:"structure"`

	// An object that contains the properties associated with an entities detection
	// job.
	EntitiesDetectionJobProperties *EntitiesDetectionJobProperties `type:"structure"`
}

// String returns the string representation
func (s DescribeEntitiesDetectionJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEntitiesDetectionJobOutput) GoString() string {
	return s.String()
}

// SetEntitiesDetectionJobProperties sets the EntitiesDetectionJobProperties field's value.
func (s *DescribeEntitiesDetectionJobOutput) SetEntitiesDetectionJobProperties(v *EntitiesDetectionJobProperties) *DescribeEntitiesDetectionJobOutput {
	s.EntitiesDetectionJobProperties = v
	return s
}

type DescribeEntityRecognizerInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) that identifies the entity recognizer.
	//
	// EntityRecognizerArn is a required field
	EntityRecognizerArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeEntityRecognizerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEntityRecognizerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeEntityRecognizerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeEntityRecognizerInput"}
	if s.EntityRecognizerArn == nil {
		invalidParams.Add(request.NewErrParamRequired("EntityRecognizerArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEntityRecognizerArn sets the EntityRecognizerArn field's value.
func (s *DescribeEntityRecognizerInput) SetEntityRecognizerArn(v string) *DescribeEntityRecognizerInput {
	s.EntityRecognizerArn = &v
	return s
}

type DescribeEntityRecognizerOutput struct {
	_ struct{} `type:"structure"`

	// Describes information associated with an entity recognizer.
	EntityRecognizerProperties *EntityRecognizerProperties `type:"structure"`
}

// String returns the string representation
func (s DescribeEntityRecognizerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEntityRecognizerOutput) GoString() string {
	return s.String()
}

// SetEntityRecognizerProperties sets the EntityRecognizerProperties field's value.
func (s *DescribeEntityRecognizerOutput) SetEntityRecognizerProperties(v *EntityRecognizerProperties) *DescribeEntityRecognizerOutput {
	s.EntityRecognizerProperties = v
	return s
}

type DescribeKeyPhrasesDetectionJobInput struct {
	_ struct{} `type:"structure"`

	// The identifier that Amazon Comprehend generated for the job. The operation
	// returns this identifier in its response.
	//
	// JobId is a required field
	JobId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeKeyPhrasesDetectionJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeKeyPhrasesDetectionJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeKeyPhrasesDetectionJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeKeyPhrasesDetectionJobInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobId sets the JobId field's value.
func (s *DescribeKeyPhrasesDetectionJobInput) SetJobId(v string) *DescribeKeyPhrasesDetectionJobInput {
	s.JobId = &v
	return s
}

type DescribeKeyPhrasesDetectionJobOutput struct {
	_ struct{} `type:"structure"`

	// An object that contains the properties associated with a key phrases detection
	// job.
	KeyPhrasesDetectionJobProperties *KeyPhrasesDetectionJobProperties `type:"structure"`
}

// String returns the string representation
func (s DescribeKeyPhrasesDetectionJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeKeyPhrasesDetectionJobOutput) GoString() string {
	return s.String()
}

// SetKeyPhrasesDetectionJobProperties sets the KeyPhrasesDetectionJobProperties field's value.
func (s *DescribeKeyPhrasesDetectionJobOutput) SetKeyPhrasesDetectionJobProperties(v *KeyPhrasesDetectionJobProperties) *DescribeKeyPhrasesDetectionJobOutput {
	s.KeyPhrasesDetectionJobProperties = v
	return s
}

type DescribePiiEntitiesDetectionJobInput struct {
	_ struct{} `type:"structure"`

	// The identifier that Amazon Comprehend generated for the job. The operation
	// returns this identifier in its response.
	//
	// JobId is a required field
	JobId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribePiiEntitiesDetectionJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribePiiEntitiesDetectionJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribePiiEntitiesDetectionJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribePiiEntitiesDetectionJobInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobId sets the JobId field's value.
func (s *DescribePiiEntitiesDetectionJobInput) SetJobId(v string) *DescribePiiEntitiesDetectionJobInput {
	s.JobId = &v
	return s
}

type DescribePiiEntitiesDetectionJobOutput struct {
	_ struct{} `type:"structure"`

	// Provides information about a PII entities detection job.
	PiiEntitiesDetectionJobProperties *PiiEntitiesDetectionJobProperties `type:"structure"`
}

// String returns the string representation
func (s DescribePiiEntitiesDetectionJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribePiiEntitiesDetectionJobOutput) GoString() string {
	return s.String()
}

// SetPiiEntitiesDetectionJobProperties sets the PiiEntitiesDetectionJobProperties field's value.
func (s *DescribePiiEntitiesDetectionJobOutput) SetPiiEntitiesDetectionJobProperties(v *PiiEntitiesDetectionJobProperties) *DescribePiiEntitiesDetectionJobOutput {
	s.PiiEntitiesDetectionJobProperties = v
	return s
}

type DescribeSentimentDetectionJobInput struct {
	_ struct{} `type:"structure"`

	// The identifier that Amazon Comprehend generated for the job. The operation
	// returns this identifier in its response.
	//
	// JobId is a required field
	JobId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeSentimentDetectionJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeSentimentDetectionJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeSentimentDetectionJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeSentimentDetectionJobInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobId sets the JobId field's value.
func (s *DescribeSentimentDetectionJobInput) SetJobId(v string) *DescribeSentimentDetectionJobInput {
	s.JobId = &v
	return s
}

type DescribeSentimentDetectionJobOutput struct {
	_ struct{} `type:"structure"`

	// An object that contains the properties associated with a sentiment detection
	// job.
	SentimentDetectionJobProperties *SentimentDetectionJobProperties `type:"structure"`
}

// String returns the string representation
func (s DescribeSentimentDetectionJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeSentimentDetectionJobOutput) GoString() string {
	return s.String()
}

// SetSentimentDetectionJobProperties sets the SentimentDetectionJobProperties field's value.
func (s *DescribeSentimentDetectionJobOutput) SetSentimentDetectionJobProperties(v *SentimentDetectionJobProperties) *DescribeSentimentDetectionJobOutput {
	s.SentimentDetectionJobProperties = v
	return s
}

type DescribeTopicsDetectionJobInput struct {
	_ struct{} `type:"structure"`

	// The identifier assigned by the user to the detection job.
	//
	// JobId is a required field
	JobId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeTopicsDetectionJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTopicsDetectionJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeTopicsDetectionJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeTopicsDetectionJobInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobId sets the JobId field's value.
func (s *DescribeTopicsDetectionJobInput) SetJobId(v string) *DescribeTopicsDetectionJobInput {
	s.JobId = &v
	return s
}

type DescribeTopicsDetectionJobOutput struct {
	_ struct{} `type:"structure"`

	// The list of properties for the requested job.
	TopicsDetectionJobProperties *TopicsDetectionJobProperties `type:"structure"`
}

// String returns the string representation
func (s DescribeTopicsDetectionJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTopicsDetectionJobOutput) GoString() string {
	return s.String()
}

// SetTopicsDetectionJobProperties sets the TopicsDetectionJobProperties field's value.
func (s *DescribeTopicsDetectionJobOutput) SetTopicsDetectionJobProperties(v *TopicsDetectionJobProperties) *DescribeTopicsDetectionJobOutput {
	s.TopicsDetectionJobProperties = v
	return s
}

type DetectDominantLanguageInput struct {
	_ struct{} `type:"structure"`

	// A UTF-8 text string. Each string should contain at least 20 characters and
	// must contain fewer that 5,000 bytes of UTF-8 encoded characters.
	//
	// Text is a required field
	Text *string `min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation
func (s DetectDominantLanguageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetectDominantLanguageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DetectDominantLanguageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DetectDominantLanguageInput"}
	if s.Text == nil {
		invalidParams.Add(request.NewErrParamRequired("Text"))
	}
	if s.Text != nil && len(*s.Text) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Text", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetText sets the Text field's value.
func (s *DetectDominantLanguageInput) SetText(v string) *DetectDominantLanguageInput {
	s.Text = &v
	return s
}

type DetectDominantLanguageOutput struct {
	_ struct{} `type:"structure" sensitive:"true"`

	// The languages that Amazon Comprehend detected in the input text. For each
	// language, the response returns the RFC 5646 language code and the level of
	// confidence that Amazon Comprehend has in the accuracy of its inference. For
	// more information about RFC 5646, see Tags for Identifying Languages (https://tools.ietf.org/html/rfc5646)
	// on the IETF Tools web site.
	Languages []*DominantLanguage `type:"list"`
}

// String returns the string representation
func (s DetectDominantLanguageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetectDominantLanguageOutput) GoString() string {
	return s.String()
}

// SetLanguages sets the Languages field's value.
func (s *DetectDominantLanguageOutput) SetLanguages(v []*DominantLanguage) *DetectDominantLanguageOutput {
	s.Languages = v
	return s
}

type DetectEntitiesInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name of an endpoint that is associated with a custom
	// entity recognition model. Provide an endpoint if you want to detect entities
	// by using your own custom model instead of the default model that is used
	// by Amazon Comprehend.
	//
	// If you specify an endpoint, Amazon Comprehend uses the language of your custom
	// model, and it ignores any language code that you provide in your request.
	EndpointArn *string `type:"string"`

	// The language of the input documents. You can specify any of the primary languages
	// supported by Amazon Comprehend. All documents must be in the same language.
	//
	// If your request includes the endpoint for a custom entity recognition model,
	// Amazon Comprehend uses the language of your custom model, and it ignores
	// any language code that you specify here.
	LanguageCode *string `type:"string" enum:"LanguageCode"`

	// A UTF-8 text string. Each string must contain fewer that 5,000 bytes of UTF-8
	// encoded characters.
	//
	// Text is a required field
	Text *string `min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation
func (s DetectEntitiesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetectEntitiesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DetectEntitiesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DetectEntitiesInput"}
	if s.Text == nil {
		invalidParams.Add(request.NewErrParamRequired("Text"))
	}
	if s.Text != nil && len(*s.Text) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Text", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndpointArn sets the EndpointArn field's value.
func (s *DetectEntitiesInput) SetEndpointArn(v string) *DetectEntitiesInput {
	s.EndpointArn = &v
	return s
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *DetectEntitiesInput) SetLanguageCode(v string) *DetectEntitiesInput {
	s.LanguageCode = &v
	return s
}

// SetText sets the Text field's value.
func (s *DetectEntitiesInput) SetText(v string) *DetectEntitiesInput {
	s.Text = &v
	return s
}

type DetectEntitiesOutput struct {
	_ struct{} `type:"structure" sensitive:"true"`

	// A collection of entities identified in the input text. For each entity, the
	// response provides the entity text, entity type, where the entity text begins
	// and ends, and the level of confidence that Amazon Comprehend has in the detection.
	//
	// If your request uses a custom entity recognition model, Amazon Comprehend
	// detects the entities that the model is trained to recognize. Otherwise, it
	// detects the default entity types. For a list of default entity types, see
	// how-entities.
	Entities []*Entity `type:"list"`
}

// String returns the string representation
func (s DetectEntitiesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetectEntitiesOutput) GoString() string {
	return s.String()
}

// SetEntities sets the Entities field's value.
func (s *DetectEntitiesOutput) SetEntities(v []*Entity) *DetectEntitiesOutput {
	s.Entities = v
	return s
}

type DetectKeyPhrasesInput struct {
	_ struct{} `type:"structure"`

	// The language of the input documents. You can specify any of the primary languages
	// supported by Amazon Comprehend. All documents must be in the same language.
	//
	// LanguageCode is a required field
	LanguageCode *string `type:"string" required:"true" enum:"LanguageCode"`

	// A UTF-8 text string. Each string must contain fewer that 5,000 bytes of UTF-8
	// encoded characters.
	//
	// Text is a required field
	Text *string `min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation
func (s DetectKeyPhrasesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetectKeyPhrasesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DetectKeyPhrasesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DetectKeyPhrasesInput"}
	if s.LanguageCode == nil {
		invalidParams.Add(request.NewErrParamRequired("LanguageCode"))
	}
	if s.Text == nil {
		invalidParams.Add(request.NewErrParamRequired("Text"))
	}
	if s.Text != nil && len(*s.Text) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Text", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *DetectKeyPhrasesInput) SetLanguageCode(v string) *DetectKeyPhrasesInput {
	s.LanguageCode = &v
	return s
}

// SetText sets the Text field's value.
func (s *DetectKeyPhrasesInput) SetText(v string) *DetectKeyPhrasesInput {
	s.Text = &v
	return s
}

type DetectKeyPhrasesOutput struct {
	_ struct{} `type:"structure" sensitive:"true"`

	// A collection of key phrases that Amazon Comprehend identified in the input
	// text. For each key phrase, the response provides the text of the key phrase,
	// where the key phrase begins and ends, and the level of confidence that Amazon
	// Comprehend has in the accuracy of the detection.
	KeyPhrases []*KeyPhrase `type:"list"`
}

// String returns the string representation
func (s DetectKeyPhrasesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetectKeyPhrasesOutput) GoString() string {
	return s.String()
}

// SetKeyPhrases sets the KeyPhrases field's value.
func (s *DetectKeyPhrasesOutput) SetKeyPhrases(v []*KeyPhrase) *DetectKeyPhrasesOutput {
	s.KeyPhrases = v
	return s
}

type DetectPiiEntitiesInput struct {
	_ struct{} `type:"structure"`

	// The language of the input documents.
	//
	// LanguageCode is a required field
	LanguageCode *string `type:"string" required:"true" enum:"LanguageCode"`

	// A UTF-8 text string. Each string must contain fewer that 5,000 bytes of UTF-8
	// encoded characters.
	//
	// Text is a required field
	Text *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DetectPiiEntitiesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetectPiiEntitiesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DetectPiiEntitiesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DetectPiiEntitiesInput"}
	if s.LanguageCode == nil {
		invalidParams.Add(request.NewErrParamRequired("LanguageCode"))
	}
	if s.Text == nil {
		invalidParams.Add(request.NewErrParamRequired("Text"))
	}
	if s.Text != nil && len(*s.Text) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Text", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *DetectPiiEntitiesInput) SetLanguageCode(v string) *DetectPiiEntitiesInput {
	s.LanguageCode = &v
	return s
}

// SetText sets the Text field's value.
func (s *DetectPiiEntitiesInput) SetText(v string) *DetectPiiEntitiesInput {
	s.Text = &v
	return s
}

type DetectPiiEntitiesOutput struct {
	_ struct{} `type:"structure"`

	// A collection of PII entities identified in the input text. For each entity,
	// the response provides the entity type, where the entity text begins and ends,
	// and the level of confidence that Amazon Comprehend has in the detection.
	Entities []*PiiEntity `type:"list"`
}

// String returns the string representation
func (s DetectPiiEntitiesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetectPiiEntitiesOutput) GoString() string {
	return s.String()
}

// SetEntities sets the Entities field's value.
func (s *DetectPiiEntitiesOutput) SetEntities(v []*PiiEntity) *DetectPiiEntitiesOutput {
	s.Entities = v
	return s
}

type DetectSentimentInput struct {
	_ struct{} `type:"structure"`

	// The language of the input documents. You can specify any of the primary languages
	// supported by Amazon Comprehend. All documents must be in the same language.
	//
	// LanguageCode is a required field
	LanguageCode *string `type:"string" required:"true" enum:"LanguageCode"`

	// A UTF-8 text string. Each string must contain fewer that 5,000 bytes of UTF-8
	// encoded characters.
	//
	// Text is a required field
	Text *string `min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation
func (s DetectSentimentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetectSentimentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DetectSentimentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DetectSentimentInput"}
	if s.LanguageCode == nil {
		invalidParams.Add(request.NewErrParamRequired("LanguageCode"))
	}
	if s.Text == nil {
		invalidParams.Add(request.NewErrParamRequired("Text"))
	}
	if s.Text != nil && len(*s.Text) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Text", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *DetectSentimentInput) SetLanguageCode(v string) *DetectSentimentInput {
	s.LanguageCode = &v
	return s
}

// SetText sets the Text field's value.
func (s *DetectSentimentInput) SetText(v string) *DetectSentimentInput {
	s.Text = &v
	return s
}

type DetectSentimentOutput struct {
	_ struct{} `type:"structure" sensitive:"true"`

	// The inferred sentiment that Amazon Comprehend has the highest level of confidence
	// in.
	Sentiment *string `type:"string" enum:"SentimentType"`

	// An object that lists the sentiments, and their corresponding confidence levels.
	SentimentScore *SentimentScore `type:"structure"`
}

// String returns the string representation
func (s DetectSentimentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetectSentimentOutput) GoString() string {
	return s.String()
}

// SetSentiment sets the Sentiment field's value.
func (s *DetectSentimentOutput) SetSentiment(v string) *DetectSentimentOutput {
	s.Sentiment = &v
	return s
}

// SetSentimentScore sets the SentimentScore field's value.
func (s *DetectSentimentOutput) SetSentimentScore(v *SentimentScore) *DetectSentimentOutput {
	s.SentimentScore = v
	return s
}

type DetectSyntaxInput struct {
	_ struct{} `type:"structure"`

	// The language code of the input documents. You can specify any of the following
	// languages supported by Amazon Comprehend: German ("de"), English ("en"),
	// Spanish ("es"), French ("fr"), Italian ("it"), or Portuguese ("pt").
	//
	// LanguageCode is a required field
	LanguageCode *string `type:"string" required:"true" enum:"SyntaxLanguageCode"`

	// A UTF-8 string. Each string must contain fewer that 5,000 bytes of UTF encoded
	// characters.
	//
	// Text is a required field
	Text *string `min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation
func (s DetectSyntaxInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetectSyntaxInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DetectSyntaxInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DetectSyntaxInput"}
	if s.LanguageCode == nil {
		invalidParams.Add(request.NewErrParamRequired("LanguageCode"))
	}
	if s.Text == nil {
		invalidParams.Add(request.NewErrParamRequired("Text"))
	}
	if s.Text != nil && len(*s.Text) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Text", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *DetectSyntaxInput) SetLanguageCode(v string) *DetectSyntaxInput {
	s.LanguageCode = &v
	return s
}

// SetText sets the Text field's value.
func (s *DetectSyntaxInput) SetText(v string) *DetectSyntaxInput {
	s.Text = &v
	return s
}

type DetectSyntaxOutput struct {
	_ struct{} `type:"structure" sensitive:"true"`

	// A collection of syntax tokens describing the text. For each token, the response
	// provides the text, the token type, where the text begins and ends, and the
	// level of confidence that Amazon Comprehend has that the token is correct.
	// For a list of token types, see how-syntax.
	SyntaxTokens []*SyntaxToken `type:"list"`
}

// String returns the string representation
func (s DetectSyntaxOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetectSyntaxOutput) GoString() string {
	return s.String()
}

// SetSyntaxTokens sets the SyntaxTokens field's value.
func (s *DetectSyntaxOutput) SetSyntaxTokens(v []*SyntaxToken) *DetectSyntaxOutput {
	s.SyntaxTokens = v
	return s
}

// Specifies the class that categorizes the document being analyzed
type DocumentClass struct {
	_ struct{} `type:"structure"`

	// The name of the class.
	Name *string `min:"1" type:"string"`

	// The confidence score that Amazon Comprehend has this class correctly attributed.
	Score *float64 `type:"float"`
}

// String returns the string representation
func (s DocumentClass) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DocumentClass) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *DocumentClass) SetName(v string) *DocumentClass {
	s.Name = &v
	return s
}

// SetScore sets the Score field's value.
func (s *DocumentClass) SetScore(v float64) *DocumentClass {
	s.Score = &v
	return s
}

// Provides information for filtering a list of document classification jobs.
// For more information, see the operation. You can provide only one filter
// parameter in each request.
type DocumentClassificationJobFilter struct {
	_ struct{} `type:"structure"`

	// Filters on the name of the job.
	JobName *string `min:"1" type:"string"`

	// Filters the list based on job status. Returns only jobs with the specified
	// status.
	JobStatus *string `type:"string" enum:"JobStatus"`

	// Filters the list of jobs based on the time that the job was submitted for
	// processing. Returns only jobs submitted after the specified time. Jobs are
	// returned in descending order, newest to oldest.
	SubmitTimeAfter *time.Time `type:"timestamp"`

	// Filters the list of jobs based on the time that the job was submitted for
	// processing. Returns only jobs submitted before the specified time. Jobs are
	// returned in ascending order, oldest to newest.
	SubmitTimeBefore *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s DocumentClassificationJobFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DocumentClassificationJobFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DocumentClassificationJobFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DocumentClassificationJobFilter"}
	if s.JobName != nil && len(*s.JobName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobName sets the JobName field's value.
func (s *DocumentClassificationJobFilter) SetJobName(v string) *DocumentClassificationJobFilter {
	s.JobName = &v
	return s
}

// SetJobStatus sets the JobStatus field's value.
func (s *DocumentClassificationJobFilter) SetJobStatus(v string) *DocumentClassificationJobFilter {
	s.JobStatus = &v
	return s
}

// SetSubmitTimeAfter sets the SubmitTimeAfter field's value.
func (s *DocumentClassificationJobFilter) SetSubmitTimeAfter(v time.Time) *DocumentClassificationJobFilter {
	s.SubmitTimeAfter = &v
	return s
}

// SetSubmitTimeBefore sets the SubmitTimeBefore field's value.
func (s *DocumentClassificationJobFilter) SetSubmitTimeBefore(v time.Time) *DocumentClassificationJobFilter {
	s.SubmitTimeBefore = &v
	return s
}

// Provides information about a document classification job.
type DocumentClassificationJobProperties struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the AWS identity and Access Management
	// (IAM) role that grants Amazon Comprehend read access to your input data.
	DataAccessRoleArn *string `min:"20" type:"string"`

	// The Amazon Resource Name (ARN) that identifies the document classifier.
	DocumentClassifierArn *string `type:"string"`

	// The time that the document classification job completed.
	EndTime *time.Time `type:"timestamp"`

	// The input data configuration that you supplied when you created the document
	// classification job.
	InputDataConfig *InputDataConfig `type:"structure"`

	// The identifier assigned to the document classification job.
	JobId *string `min:"1" type:"string"`

	// The name that you assigned to the document classification job.
	JobName *string `min:"1" type:"string"`

	// The current status of the document classification job. If the status is FAILED,
	// the Message field shows the reason for the failure.
	JobStatus *string `type:"string" enum:"JobStatus"`

	// A description of the status of the job.
	Message *string `type:"string"`

	// The output data configuration that you supplied when you created the document
	// classification job.
	OutputDataConfig *OutputDataConfig `type:"structure"`

	// The time that the document classification job was submitted for processing.
	SubmitTime *time.Time `type:"timestamp"`

	// ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses
	// to encrypt data on the storage volume attached to the ML compute instance(s)
	// that process the analysis job. The VolumeKmsKeyId can be either of the following
	// formats:
	//
	//    * KMS Key ID: "1234abcd-12ab-34cd-56ef-1234567890ab"
	//
	//    * Amazon Resource Name (ARN) of a KMS Key: "arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"
	VolumeKmsKeyId *string `type:"string"`

	// Configuration parameters for a private Virtual Private Cloud (VPC) containing
	// the resources you are using for your document classification job. For more
	// information, see Amazon VPC (https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html).
	VpcConfig *VpcConfig `type:"structure"`
}

// String returns the string representation
func (s DocumentClassificationJobProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DocumentClassificationJobProperties) GoString() string {
	return s.String()
}

// SetDataAccessRoleArn sets the DataAccessRoleArn field's value.
func (s *DocumentClassificationJobProperties) SetDataAccessRoleArn(v string) *DocumentClassificationJobProperties {
	s.DataAccessRoleArn = &v
	return s
}

// SetDocumentClassifierArn sets the DocumentClassifierArn field's value.
func (s *DocumentClassificationJobProperties) SetDocumentClassifierArn(v string) *DocumentClassificationJobProperties {
	s.DocumentClassifierArn = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *DocumentClassificationJobProperties) SetEndTime(v time.Time) *DocumentClassificationJobProperties {
	s.EndTime = &v
	return s
}

// SetInputDataConfig sets the InputDataConfig field's value.
func (s *DocumentClassificationJobProperties) SetInputDataConfig(v *InputDataConfig) *DocumentClassificationJobProperties {
	s.InputDataConfig = v
	return s
}

// SetJobId sets the JobId field's value.
func (s *DocumentClassificationJobProperties) SetJobId(v string) *DocumentClassificationJobProperties {
	s.JobId = &v
	return s
}

// SetJobName sets the JobName field's value.
func (s *DocumentClassificationJobProperties) SetJobName(v string) *DocumentClassificationJobProperties {
	s.JobName = &v
	return s
}

// SetJobStatus sets the JobStatus field's value.
func (s *DocumentClassificationJobProperties) SetJobStatus(v string) *DocumentClassificationJobProperties {
	s.JobStatus = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *DocumentClassificationJobProperties) SetMessage(v string) *DocumentClassificationJobProperties {
	s.Message = &v
	return s
}

// SetOutputDataConfig sets the OutputDataConfig field's value.
func (s *DocumentClassificationJobProperties) SetOutputDataConfig(v *OutputDataConfig) *DocumentClassificationJobProperties {
	s.OutputDataConfig = v
	return s
}

// SetSubmitTime sets the SubmitTime field's value.
func (s *DocumentClassificationJobProperties) SetSubmitTime(v time.Time) *DocumentClassificationJobProperties {
	s.SubmitTime = &v
	return s
}

// SetVolumeKmsKeyId sets the VolumeKmsKeyId field's value.
func (s *DocumentClassificationJobProperties) SetVolumeKmsKeyId(v string) *DocumentClassificationJobProperties {
	s.VolumeKmsKeyId = &v
	return s
}

// SetVpcConfig sets the VpcConfig field's value.
func (s *DocumentClassificationJobProperties) SetVpcConfig(v *VpcConfig) *DocumentClassificationJobProperties {
	s.VpcConfig = v
	return s
}

// Provides information for filtering a list of document classifiers. You can
// only specify one filtering parameter in a request. For more information,
// see the operation.
type DocumentClassifierFilter struct {
	_ struct{} `type:"structure"`

	// Filters the list of classifiers based on status.
	Status *string `type:"string" enum:"ModelStatus"`

	// Filters the list of classifiers based on the time that the classifier was
	// submitted for processing. Returns only classifiers submitted after the specified
	// time. Classifiers are returned in descending order, newest to oldest.
	SubmitTimeAfter *time.Time `type:"timestamp"`

	// Filters the list of classifiers based on the time that the classifier was
	// submitted for processing. Returns only classifiers submitted before the specified
	// time. Classifiers are returned in ascending order, oldest to newest.
	SubmitTimeBefore *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s DocumentClassifierFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DocumentClassifierFilter) GoString() string {
	return s.String()
}

// SetStatus sets the Status field's value.
func (s *DocumentClassifierFilter) SetStatus(v string) *DocumentClassifierFilter {
	s.Status = &v
	return s
}

// SetSubmitTimeAfter sets the SubmitTimeAfter field's value.
func (s *DocumentClassifierFilter) SetSubmitTimeAfter(v time.Time) *DocumentClassifierFilter {
	s.SubmitTimeAfter = &v
	return s
}

// SetSubmitTimeBefore sets the SubmitTimeBefore field's value.
func (s *DocumentClassifierFilter) SetSubmitTimeBefore(v time.Time) *DocumentClassifierFilter {
	s.SubmitTimeBefore = &v
	return s
}

// The input properties for training a document classifier.
//
// For more information on how the input file is formatted, see how-document-classification-training-data.
type DocumentClassifierInputDataConfig struct {
	_ struct{} `type:"structure"`

	// A list of augmented manifest files that provide training data for your custom
	// model. An augmented manifest file is a labeled dataset that is produced by
	// Amazon SageMaker Ground Truth.
	//
	// This parameter is required if you set DataFormat to AUGMENTED_MANIFEST.
	AugmentedManifests []*AugmentedManifestsListItem `type:"list"`

	// The format of your training data:
	//
	//    * COMPREHEND_CSV: A two-column CSV file, where labels are provided in
	//    the first column, and documents are provided in the second. If you use
	//    this value, you must provide the S3Uri parameter in your request.
	//
	//    * AUGMENTED_MANIFEST: A labeled dataset that is produced by Amazon SageMaker
	//    Ground Truth. This file is in JSON lines format. Each line is a complete
	//    JSON object that contains a training document and its associated labels.
	//    If you use this value, you must provide the AugmentedManifests parameter
	//    in your request.
	//
	// If you don't specify a value, Amazon Comprehend uses COMPREHEND_CSV as the
	// default.
	DataFormat *string `type:"string" enum:"DocumentClassifierDataFormat"`

	// Indicates the delimiter used to separate each label for training a multi-label
	// classifier. The default delimiter between labels is a pipe (|). You can use
	// a different character as a delimiter (if it's an allowed character) by specifying
	// it under Delimiter for labels. If the training documents use a delimiter
	// other than the default or the delimiter you specify, the labels on that line
	// will be combined to make a single unique label, such as LABELLABELLABEL.
	LabelDelimiter *string `min:"1" type:"string"`

	// The Amazon S3 URI for the input data. The S3 bucket must be in the same region
	// as the API endpoint that you are calling. The URI can point to a single input
	// file or it can provide the prefix for a collection of input files.
	//
	// For example, if you use the URI S3://bucketName/prefix, if the prefix is
	// a single file, Amazon Comprehend uses that file as input. If more than one
	// file begins with the prefix, Amazon Comprehend uses all of them as input.
	//
	// This parameter is required if you set DataFormat to COMPREHEND_CSV.
	S3Uri *string `type:"string"`
}

// String returns the string representation
func (s DocumentClassifierInputDataConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DocumentClassifierInputDataConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DocumentClassifierInputDataConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DocumentClassifierInputDataConfig"}
	if s.LabelDelimiter != nil && len(*s.LabelDelimiter) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LabelDelimiter", 1))
	}
	if s.AugmentedManifests != nil {
		for i, v := range s.AugmentedManifests {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AugmentedManifests", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAugmentedManifests sets the AugmentedManifests field's value.
func (s *DocumentClassifierInputDataConfig) SetAugmentedManifests(v []*AugmentedManifestsListItem) *DocumentClassifierInputDataConfig {
	s.AugmentedManifests = v
	return s
}

// SetDataFormat sets the DataFormat field's value.
func (s *DocumentClassifierInputDataConfig) SetDataFormat(v string) *DocumentClassifierInputDataConfig {
	s.DataFormat = &v
	return s
}

// SetLabelDelimiter sets the LabelDelimiter field's value.
func (s *DocumentClassifierInputDataConfig) SetLabelDelimiter(v string) *DocumentClassifierInputDataConfig {
	s.LabelDelimiter = &v
	return s
}

// SetS3Uri sets the S3Uri field's value.
func (s *DocumentClassifierInputDataConfig) SetS3Uri(v string) *DocumentClassifierInputDataConfig {
	s.S3Uri = &v
	return s
}

// Provides output results configuration parameters for custom classifier jobs.
type DocumentClassifierOutputDataConfig struct {
	_ struct{} `type:"structure"`

	// ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses
	// to encrypt the output results from an analysis job. The KmsKeyId can be one
	// of the following formats:
	//
	//    * KMS Key ID: "1234abcd-12ab-34cd-56ef-1234567890ab"
	//
	//    * Amazon Resource Name (ARN) of a KMS Key: "arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"
	//
	//    * KMS Key Alias: "alias/ExampleAlias"
	//
	//    * ARN of a KMS Key Alias: "arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias"
	KmsKeyId *string `type:"string"`

	// When you use the OutputDataConfig object while creating a custom classifier,
	// you specify the Amazon S3 location where you want to write the confusion
	// matrix. The URI must be in the same region as the API endpoint that you are
	// calling. The location is used as the prefix for the actual location of this
	// output file.
	//
	// When the custom classifier job is finished, the service creates the output
	// file in a directory specific to the job. The S3Uri field contains the location
	// of the output file, called output.tar.gz. It is a compressed archive that
	// contains the confusion matrix.
	S3Uri *string `type:"string"`
}

// String returns the string representation
func (s DocumentClassifierOutputDataConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DocumentClassifierOutputDataConfig) GoString() string {
	return s.String()
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *DocumentClassifierOutputDataConfig) SetKmsKeyId(v string) *DocumentClassifierOutputDataConfig {
	s.KmsKeyId = &v
	return s
}

// SetS3Uri sets the S3Uri field's value.
func (s *DocumentClassifierOutputDataConfig) SetS3Uri(v string) *DocumentClassifierOutputDataConfig {
	s.S3Uri = &v
	return s
}

// Provides information about a document classifier.
type DocumentClassifierProperties struct {
	_ struct{} `type:"structure"`

	// Information about the document classifier, including the number of documents
	// used for training the classifier, the number of documents used for test the
	// classifier, and an accuracy rating.
	ClassifierMetadata *ClassifierMetadata `type:"structure" sensitive:"true"`

	// The Amazon Resource Name (ARN) of the AWS Identity and Management (IAM) role
	// that grants Amazon Comprehend read access to your input data.
	DataAccessRoleArn *string `min:"20" type:"string"`

	// The Amazon Resource Name (ARN) that identifies the document classifier.
	DocumentClassifierArn *string `type:"string"`

	// The time that training the document classifier completed.
	EndTime *time.Time `type:"timestamp"`

	// The input data configuration that you supplied when you created the document
	// classifier for training.
	InputDataConfig *DocumentClassifierInputDataConfig `type:"structure"`

	// The language code for the language of the documents that the classifier was
	// trained on.
	LanguageCode *string `type:"string" enum:"LanguageCode"`

	// Additional information about the status of the classifier.
	Message *string `type:"string"`

	// Indicates the mode in which the specific classifier was trained. This also
	// indicates the format of input documents and the format of the confusion matrix.
	// Each classifier can only be trained in one mode and this cannot be changed
	// once the classifier is trained.
	Mode *string `type:"string" enum:"DocumentClassifierMode"`

	// Provides output results configuration parameters for custom classifier jobs.
	OutputDataConfig *DocumentClassifierOutputDataConfig `type:"structure"`

	// The status of the document classifier. If the status is TRAINED the classifier
	// is ready to use. If the status is FAILED you can see additional information
	// about why the classifier wasn't trained in the Message field.
	Status *string `type:"string" enum:"ModelStatus"`

	// The time that the document classifier was submitted for training.
	SubmitTime *time.Time `type:"timestamp"`

	// The time that training of the document classifier was completed. Indicates
	// the time when the training completes on documentation classifiers. You are
	// billed for the time interval between this time and the value of TrainingStartTime.
	TrainingEndTime *time.Time `type:"timestamp"`

	// Indicates the time when the training starts on documentation classifiers.
	// You are billed for the time interval between this time and the value of TrainingEndTime.
	TrainingStartTime *time.Time `type:"timestamp"`

	// ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses
	// to encrypt data on the storage volume attached to the ML compute instance(s)
	// that process the analysis job. The VolumeKmsKeyId can be either of the following
	// formats:
	//
	//    * KMS Key ID: "1234abcd-12ab-34cd-56ef-1234567890ab"
	//
	//    * Amazon Resource Name (ARN) of a KMS Key: "arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"
	VolumeKmsKeyId *string `type:"string"`

	// Configuration parameters for a private Virtual Private Cloud (VPC) containing
	// the resources you are using for your custom classifier. For more information,
	// see Amazon VPC (https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html).
	VpcConfig *VpcConfig `type:"structure"`
}

// String returns the string representation
func (s DocumentClassifierProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DocumentClassifierProperties) GoString() string {
	return s.String()
}

// SetClassifierMetadata sets the ClassifierMetadata field's value.
func (s *DocumentClassifierProperties) SetClassifierMetadata(v *ClassifierMetadata) *DocumentClassifierProperties {
	s.ClassifierMetadata = v
	return s
}

// SetDataAccessRoleArn sets the DataAccessRoleArn field's value.
func (s *DocumentClassifierProperties) SetDataAccessRoleArn(v string) *DocumentClassifierProperties {
	s.DataAccessRoleArn = &v
	return s
}

// SetDocumentClassifierArn sets the DocumentClassifierArn field's value.
func (s *DocumentClassifierProperties) SetDocumentClassifierArn(v string) *DocumentClassifierProperties {
	s.DocumentClassifierArn = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *DocumentClassifierProperties) SetEndTime(v time.Time) *DocumentClassifierProperties {
	s.EndTime = &v
	return s
}

// SetInputDataConfig sets the InputDataConfig field's value.
func (s *DocumentClassifierProperties) SetInputDataConfig(v *DocumentClassifierInputDataConfig) *DocumentClassifierProperties {
	s.InputDataConfig = v
	return s
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *DocumentClassifierProperties) SetLanguageCode(v string) *DocumentClassifierProperties {
	s.LanguageCode = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *DocumentClassifierProperties) SetMessage(v string) *DocumentClassifierProperties {
	s.Message = &v
	return s
}

// SetMode sets the Mode field's value.
func (s *DocumentClassifierProperties) SetMode(v string) *DocumentClassifierProperties {
	s.Mode = &v
	return s
}

// SetOutputDataConfig sets the OutputDataConfig field's value.
func (s *DocumentClassifierProperties) SetOutputDataConfig(v *DocumentClassifierOutputDataConfig) *DocumentClassifierProperties {
	s.OutputDataConfig = v
	return s
}

// SetStatus sets the Status field's value.
func (s *DocumentClassifierProperties) SetStatus(v string) *DocumentClassifierProperties {
	s.Status = &v
	return s
}

// SetSubmitTime sets the SubmitTime field's value.
func (s *DocumentClassifierProperties) SetSubmitTime(v time.Time) *DocumentClassifierProperties {
	s.SubmitTime = &v
	return s
}

// SetTrainingEndTime sets the TrainingEndTime field's value.
func (s *DocumentClassifierProperties) SetTrainingEndTime(v time.Time) *DocumentClassifierProperties {
	s.TrainingEndTime = &v
	return s
}

// SetTrainingStartTime sets the TrainingStartTime field's value.
func (s *DocumentClassifierProperties) SetTrainingStartTime(v time.Time) *DocumentClassifierProperties {
	s.TrainingStartTime = &v
	return s
}

// SetVolumeKmsKeyId sets the VolumeKmsKeyId field's value.
func (s *DocumentClassifierProperties) SetVolumeKmsKeyId(v string) *DocumentClassifierProperties {
	s.VolumeKmsKeyId = &v
	return s
}

// SetVpcConfig sets the VpcConfig field's value.
func (s *DocumentClassifierProperties) SetVpcConfig(v *VpcConfig) *DocumentClassifierProperties {
	s.VpcConfig = v
	return s
}

// Specifies one of the label or labels that categorize the document being analyzed.
type DocumentLabel struct {
	_ struct{} `type:"structure"`

	// The name of the label.
	Name *string `min:"1" type:"string"`

	// The confidence score that Amazon Comprehend has this label correctly attributed.
	Score *float64 `type:"float"`
}

// String returns the string representation
func (s DocumentLabel) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DocumentLabel) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *DocumentLabel) SetName(v string) *DocumentLabel {
	s.Name = &v
	return s
}

// SetScore sets the Score field's value.
func (s *DocumentLabel) SetScore(v float64) *DocumentLabel {
	s.Score = &v
	return s
}

// Returns the code for the dominant language in the input text and the level
// of confidence that Amazon Comprehend has in the accuracy of the detection.
type DominantLanguage struct {
	_ struct{} `type:"structure"`

	// The RFC 5646 language code for the dominant language. For more information
	// about RFC 5646, see Tags for Identifying Languages (https://tools.ietf.org/html/rfc5646)
	// on the IETF Tools web site.
	LanguageCode *string `min:"1" type:"string"`

	// The level of confidence that Amazon Comprehend has in the accuracy of the
	// detection.
	Score *float64 `type:"float"`
}

// String returns the string representation
func (s DominantLanguage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DominantLanguage) GoString() string {
	return s.String()
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *DominantLanguage) SetLanguageCode(v string) *DominantLanguage {
	s.LanguageCode = &v
	return s
}

// SetScore sets the Score field's value.
func (s *DominantLanguage) SetScore(v float64) *DominantLanguage {
	s.Score = &v
	return s
}

// Provides information for filtering a list of dominant language detection
// jobs. For more information, see the operation.
type DominantLanguageDetectionJobFilter struct {
	_ struct{} `type:"structure"`

	// Filters on the name of the job.
	JobName *string `min:"1" type:"string"`

	// Filters the list of jobs based on job status. Returns only jobs with the
	// specified status.
	JobStatus *string `type:"string" enum:"JobStatus"`

	// Filters the list of jobs based on the time that the job was submitted for
	// processing. Returns only jobs submitted after the specified time. Jobs are
	// returned in descending order, newest to oldest.
	SubmitTimeAfter *time.Time `type:"timestamp"`

	// Filters the list of jobs based on the time that the job was submitted for
	// processing. Returns only jobs submitted before the specified time. Jobs are
	// returned in ascending order, oldest to newest.
	SubmitTimeBefore *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s DominantLanguageDetectionJobFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DominantLanguageDetectionJobFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DominantLanguageDetectionJobFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DominantLanguageDetectionJobFilter"}
	if s.JobName != nil && len(*s.JobName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobName sets the JobName field's value.
func (s *DominantLanguageDetectionJobFilter) SetJobName(v string) *DominantLanguageDetectionJobFilter {
	s.JobName = &v
	return s
}

// SetJobStatus sets the JobStatus field's value.
func (s *DominantLanguageDetectionJobFilter) SetJobStatus(v string) *DominantLanguageDetectionJobFilter {
	s.JobStatus = &v
	return s
}

// SetSubmitTimeAfter sets the SubmitTimeAfter field's value.
func (s *DominantLanguageDetectionJobFilter) SetSubmitTimeAfter(v time.Time) *DominantLanguageDetectionJobFilter {
	s.SubmitTimeAfter = &v
	return s
}

// SetSubmitTimeBefore sets the SubmitTimeBefore field's value.
func (s *DominantLanguageDetectionJobFilter) SetSubmitTimeBefore(v time.Time) *DominantLanguageDetectionJobFilter {
	s.SubmitTimeBefore = &v
	return s
}

// Provides information about a dominant language detection job.
type DominantLanguageDetectionJobProperties struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) that gives Amazon Comprehend read access to
	// your input data.
	DataAccessRoleArn *string `min:"20" type:"string"`

	// The time that the dominant language detection job completed.
	EndTime *time.Time `type:"timestamp"`

	// The input data configuration that you supplied when you created the dominant
	// language detection job.
	InputDataConfig *InputDataConfig `type:"structure"`

	// The identifier assigned to the dominant language detection job.
	JobId *string `min:"1" type:"string"`

	// The name that you assigned to the dominant language detection job.
	JobName *string `min:"1" type:"string"`

	// The current status of the dominant language detection job. If the status
	// is FAILED, the Message field shows the reason for the failure.
	JobStatus *string `type:"string" enum:"JobStatus"`

	// A description for the status of a job.
	Message *string `type:"string"`

	// The output data configuration that you supplied when you created the dominant
	// language detection job.
	OutputDataConfig *OutputDataConfig `type:"structure"`

	// The time that the dominant language detection job was submitted for processing.
	SubmitTime *time.Time `type:"timestamp"`

	// ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses
	// to encrypt data on the storage volume attached to the ML compute instance(s)
	// that process the analysis job. The VolumeKmsKeyId can be either of the following
	// formats:
	//
	//    * KMS Key ID: "1234abcd-12ab-34cd-56ef-1234567890ab"
	//
	//    * Amazon Resource Name (ARN) of a KMS Key: "arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"
	VolumeKmsKeyId *string `type:"string"`

	// Configuration parameters for a private Virtual Private Cloud (VPC) containing
	// the resources you are using for your dominant language detection job. For
	// more information, see Amazon VPC (https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html).
	VpcConfig *VpcConfig `type:"structure"`
}

// String returns the string representation
func (s DominantLanguageDetectionJobProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DominantLanguageDetectionJobProperties) GoString() string {
	return s.String()
}

// SetDataAccessRoleArn sets the DataAccessRoleArn field's value.
func (s *DominantLanguageDetectionJobProperties) SetDataAccessRoleArn(v string) *DominantLanguageDetectionJobProperties {
	s.DataAccessRoleArn = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *DominantLanguageDetectionJobProperties) SetEndTime(v time.Time) *DominantLanguageDetectionJobProperties {
	s.EndTime = &v
	return s
}

// SetInputDataConfig sets the InputDataConfig field's value.
func (s *DominantLanguageDetectionJobProperties) SetInputDataConfig(v *InputDataConfig) *DominantLanguageDetectionJobProperties {
	s.InputDataConfig = v
	return s
}

// SetJobId sets the JobId field's value.
func (s *DominantLanguageDetectionJobProperties) SetJobId(v string) *DominantLanguageDetectionJobProperties {
	s.JobId = &v
	return s
}

// SetJobName sets the JobName field's value.
func (s *DominantLanguageDetectionJobProperties) SetJobName(v string) *DominantLanguageDetectionJobProperties {
	s.JobName = &v
	return s
}

// SetJobStatus sets the JobStatus field's value.
func (s *DominantLanguageDetectionJobProperties) SetJobStatus(v string) *DominantLanguageDetectionJobProperties {
	s.JobStatus = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *DominantLanguageDetectionJobProperties) SetMessage(v string) *DominantLanguageDetectionJobProperties {
	s.Message = &v
	return s
}

// SetOutputDataConfig sets the OutputDataConfig field's value.
func (s *DominantLanguageDetectionJobProperties) SetOutputDataConfig(v *OutputDataConfig) *DominantLanguageDetectionJobProperties {
	s.OutputDataConfig = v
	return s
}

// SetSubmitTime sets the SubmitTime field's value.
func (s *DominantLanguageDetectionJobProperties) SetSubmitTime(v time.Time) *DominantLanguageDetectionJobProperties {
	s.SubmitTime = &v
	return s
}

// SetVolumeKmsKeyId sets the VolumeKmsKeyId field's value.
func (s *DominantLanguageDetectionJobProperties) SetVolumeKmsKeyId(v string) *DominantLanguageDetectionJobProperties {
	s.VolumeKmsKeyId = &v
	return s
}

// SetVpcConfig sets the VpcConfig field's value.
func (s *DominantLanguageDetectionJobProperties) SetVpcConfig(v *VpcConfig) *DominantLanguageDetectionJobProperties {
	s.VpcConfig = v
	return s
}

// The filter used to determine which endpoints are are returned. You can filter
// jobs on their name, model, status, or the date and time that they were created.
// You can only set one filter at a time.
type EndpointFilter struct {
	_ struct{} `type:"structure"`

	// Specifies a date after which the returned endpoint or endpoints were created.
	CreationTimeAfter *time.Time `type:"timestamp"`

	// Specifies a date before which the returned endpoint or endpoints were created.
	CreationTimeBefore *time.Time `type:"timestamp"`

	// The Amazon Resource Number (ARN) of the model to which the endpoint is attached.
	ModelArn *string `type:"string"`

	// Specifies the status of the endpoint being returned. Possible values are:
	// Creating, Ready, Updating, Deleting, Failed.
	Status *string `type:"string" enum:"EndpointStatus"`
}

// String returns the string representation
func (s EndpointFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EndpointFilter) GoString() string {
	return s.String()
}

// SetCreationTimeAfter sets the CreationTimeAfter field's value.
func (s *EndpointFilter) SetCreationTimeAfter(v time.Time) *EndpointFilter {
	s.CreationTimeAfter = &v
	return s
}

// SetCreationTimeBefore sets the CreationTimeBefore field's value.
func (s *EndpointFilter) SetCreationTimeBefore(v time.Time) *EndpointFilter {
	s.CreationTimeBefore = &v
	return s
}

// SetModelArn sets the ModelArn field's value.
func (s *EndpointFilter) SetModelArn(v string) *EndpointFilter {
	s.ModelArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *EndpointFilter) SetStatus(v string) *EndpointFilter {
	s.Status = &v
	return s
}

// Specifies information about the specified endpoint.
type EndpointProperties struct {
	_ struct{} `type:"structure"`

	// The creation date and time of the endpoint.
	CreationTime *time.Time `type:"timestamp"`

	// The number of inference units currently used by the model using this endpoint.
	CurrentInferenceUnits *int64 `min:"1" type:"integer"`

	// The desired number of inference units to be used by the model using this
	// endpoint. Each inference unit represents of a throughput of 100 characters
	// per second.
	DesiredInferenceUnits *int64 `min:"1" type:"integer"`

	// The Amazon Resource Number (ARN) of the endpoint.
	EndpointArn *string `type:"string"`

	// The date and time that the endpoint was last modified.
	LastModifiedTime *time.Time `type:"timestamp"`

	// Specifies a reason for failure in cases of Failed status.
	Message *string `type:"string"`

	// The Amazon Resource Number (ARN) of the model to which the endpoint is attached.
	ModelArn *string `type:"string"`

	// Specifies the status of the endpoint. Because the endpoint updates and creation
	// are asynchronous, so customers will need to wait for the endpoint to be Ready
	// status before making inference requests.
	Status *string `type:"string" enum:"EndpointStatus"`
}

// String returns the string representation
func (s EndpointProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EndpointProperties) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *EndpointProperties) SetCreationTime(v time.Time) *EndpointProperties {
	s.CreationTime = &v
	return s
}

// SetCurrentInferenceUnits sets the CurrentInferenceUnits field's value.
func (s *EndpointProperties) SetCurrentInferenceUnits(v int64) *EndpointProperties {
	s.CurrentInferenceUnits = &v
	return s
}

// SetDesiredInferenceUnits sets the DesiredInferenceUnits field's value.
func (s *EndpointProperties) SetDesiredInferenceUnits(v int64) *EndpointProperties {
	s.DesiredInferenceUnits = &v
	return s
}

// SetEndpointArn sets the EndpointArn field's value.
func (s *EndpointProperties) SetEndpointArn(v string) *EndpointProperties {
	s.EndpointArn = &v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *EndpointProperties) SetLastModifiedTime(v time.Time) *EndpointProperties {
	s.LastModifiedTime = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *EndpointProperties) SetMessage(v string) *EndpointProperties {
	s.Message = &v
	return s
}

// SetModelArn sets the ModelArn field's value.
func (s *EndpointProperties) SetModelArn(v string) *EndpointProperties {
	s.ModelArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *EndpointProperties) SetStatus(v string) *EndpointProperties {
	s.Status = &v
	return s
}

// Provides information for filtering a list of dominant language detection
// jobs. For more information, see the operation.
type EntitiesDetectionJobFilter struct {
	_ struct{} `type:"structure"`

	// Filters on the name of the job.
	JobName *string `min:"1" type:"string"`

	// Filters the list of jobs based on job status. Returns only jobs with the
	// specified status.
	JobStatus *string `type:"string" enum:"JobStatus"`

	// Filters the list of jobs based on the time that the job was submitted for
	// processing. Returns only jobs submitted after the specified time. Jobs are
	// returned in descending order, newest to oldest.
	SubmitTimeAfter *time.Time `type:"timestamp"`

	// Filters the list of jobs based on the time that the job was submitted for
	// processing. Returns only jobs submitted before the specified time. Jobs are
	// returned in ascending order, oldest to newest.
	SubmitTimeBefore *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s EntitiesDetectionJobFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EntitiesDetectionJobFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EntitiesDetectionJobFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EntitiesDetectionJobFilter"}
	if s.JobName != nil && len(*s.JobName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobName sets the JobName field's value.
func (s *EntitiesDetectionJobFilter) SetJobName(v string) *EntitiesDetectionJobFilter {
	s.JobName = &v
	return s
}

// SetJobStatus sets the JobStatus field's value.
func (s *EntitiesDetectionJobFilter) SetJobStatus(v string) *EntitiesDetectionJobFilter {
	s.JobStatus = &v
	return s
}

// SetSubmitTimeAfter sets the SubmitTimeAfter field's value.
func (s *EntitiesDetectionJobFilter) SetSubmitTimeAfter(v time.Time) *EntitiesDetectionJobFilter {
	s.SubmitTimeAfter = &v
	return s
}

// SetSubmitTimeBefore sets the SubmitTimeBefore field's value.
func (s *EntitiesDetectionJobFilter) SetSubmitTimeBefore(v time.Time) *EntitiesDetectionJobFilter {
	s.SubmitTimeBefore = &v
	return s
}

// Provides information about an entities detection job.
type EntitiesDetectionJobProperties struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) that gives Amazon Comprehend read access to
	// your input data.
	DataAccessRoleArn *string `min:"20" type:"string"`

	// The time that the entities detection job completed
	EndTime *time.Time `type:"timestamp"`

	// The Amazon Resource Name (ARN) that identifies the entity recognizer.
	EntityRecognizerArn *string `type:"string"`

	// The input data configuration that you supplied when you created the entities
	// detection job.
	InputDataConfig *InputDataConfig `type:"structure"`

	// The identifier assigned to the entities detection job.
	JobId *string `min:"1" type:"string"`

	// The name that you assigned the entities detection job.
	JobName *string `min:"1" type:"string"`

	// The current status of the entities detection job. If the status is FAILED,
	// the Message field shows the reason for the failure.
	JobStatus *string `type:"string" enum:"JobStatus"`

	// The language code of the input documents.
	LanguageCode *string `type:"string" enum:"LanguageCode"`

	// A description of the status of a job.
	Message *string `type:"string"`

	// The output data configuration that you supplied when you created the entities
	// detection job.
	OutputDataConfig *OutputDataConfig `type:"structure"`

	// The time that the entities detection job was submitted for processing.
	SubmitTime *time.Time `type:"timestamp"`

	// ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses
	// to encrypt data on the storage volume attached to the ML compute instance(s)
	// that process the analysis job. The VolumeKmsKeyId can be either of the following
	// formats:
	//
	//    * KMS Key ID: "1234abcd-12ab-34cd-56ef-1234567890ab"
	//
	//    * Amazon Resource Name (ARN) of a KMS Key: "arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"
	VolumeKmsKeyId *string `type:"string"`

	// Configuration parameters for a private Virtual Private Cloud (VPC) containing
	// the resources you are using for your entity detection job. For more information,
	// see Amazon VPC (https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html).
	VpcConfig *VpcConfig `type:"structure"`
}

// String returns the string representation
func (s EntitiesDetectionJobProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EntitiesDetectionJobProperties) GoString() string {
	return s.String()
}

// SetDataAccessRoleArn sets the DataAccessRoleArn field's value.
func (s *EntitiesDetectionJobProperties) SetDataAccessRoleArn(v string) *EntitiesDetectionJobProperties {
	s.DataAccessRoleArn = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *EntitiesDetectionJobProperties) SetEndTime(v time.Time) *EntitiesDetectionJobProperties {
	s.EndTime = &v
	return s
}

// SetEntityRecognizerArn sets the EntityRecognizerArn field's value.
func (s *EntitiesDetectionJobProperties) SetEntityRecognizerArn(v string) *EntitiesDetectionJobProperties {
	s.EntityRecognizerArn = &v
	return s
}

// SetInputDataConfig sets the InputDataConfig field's value.
func (s *EntitiesDetectionJobProperties) SetInputDataConfig(v *InputDataConfig) *EntitiesDetectionJobProperties {
	s.InputDataConfig = v
	return s
}

// SetJobId sets the JobId field's value.
func (s *EntitiesDetectionJobProperties) SetJobId(v string) *EntitiesDetectionJobProperties {
	s.JobId = &v
	return s
}

// SetJobName sets the JobName field's value.
func (s *EntitiesDetectionJobProperties) SetJobName(v string) *EntitiesDetectionJobProperties {
	s.JobName = &v
	return s
}

// SetJobStatus sets the JobStatus field's value.
func (s *EntitiesDetectionJobProperties) SetJobStatus(v string) *EntitiesDetectionJobProperties {
	s.JobStatus = &v
	return s
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *EntitiesDetectionJobProperties) SetLanguageCode(v string) *EntitiesDetectionJobProperties {
	s.LanguageCode = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *EntitiesDetectionJobProperties) SetMessage(v string) *EntitiesDetectionJobProperties {
	s.Message = &v
	return s
}

// SetOutputDataConfig sets the OutputDataConfig field's value.
func (s *EntitiesDetectionJobProperties) SetOutputDataConfig(v *OutputDataConfig) *EntitiesDetectionJobProperties {
	s.OutputDataConfig = v
	return s
}

// SetSubmitTime sets the SubmitTime field's value.
func (s *EntitiesDetectionJobProperties) SetSubmitTime(v time.Time) *EntitiesDetectionJobProperties {
	s.SubmitTime = &v
	return s
}

// SetVolumeKmsKeyId sets the VolumeKmsKeyId field's value.
func (s *EntitiesDetectionJobProperties) SetVolumeKmsKeyId(v string) *EntitiesDetectionJobProperties {
	s.VolumeKmsKeyId = &v
	return s
}

// SetVpcConfig sets the VpcConfig field's value.
func (s *EntitiesDetectionJobProperties) SetVpcConfig(v *VpcConfig) *EntitiesDetectionJobProperties {
	s.VpcConfig = v
	return s
}

// Provides information about an entity.
type Entity struct {
	_ struct{} `type:"structure"`

	// A character offset in the input text that shows where the entity begins (the
	// first character is at position 0). The offset returns the position of each
	// UTF-8 code point in the string. A code point is the abstract character from
	// a particular graphical representation. For example, a multi-byte UTF-8 character
	// maps to a single code point.
	BeginOffset *int64 `type:"integer"`

	// A character offset in the input text that shows where the entity ends. The
	// offset returns the position of each UTF-8 code point in the string. A code
	// point is the abstract character from a particular graphical representation.
	// For example, a multi-byte UTF-8 character maps to a single code point.
	EndOffset *int64 `type:"integer"`

	// The level of confidence that Amazon Comprehend has in the accuracy of the
	// detection.
	Score *float64 `type:"float"`

	// The text of the entity.
	Text *string `min:"1" type:"string"`

	// The entity's type.
	Type *string `type:"string" enum:"EntityType"`
}

// String returns the string representation
func (s Entity) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Entity) GoString() string {
	return s.String()
}

// SetBeginOffset sets the BeginOffset field's value.
func (s *Entity) SetBeginOffset(v int64) *Entity {
	s.BeginOffset = &v
	return s
}

// SetEndOffset sets the EndOffset field's value.
func (s *Entity) SetEndOffset(v int64) *Entity {
	s.EndOffset = &v
	return s
}

// SetScore sets the Score field's value.
func (s *Entity) SetScore(v float64) *Entity {
	s.Score = &v
	return s
}

// SetText sets the Text field's value.
func (s *Entity) SetText(v string) *Entity {
	s.Text = &v
	return s
}

// SetType sets the Type field's value.
func (s *Entity) SetType(v string) *Entity {
	s.Type = &v
	return s
}

// Describes the annotations associated with a entity recognizer.
type EntityRecognizerAnnotations struct {
	_ struct{} `type:"structure"`

	// Specifies the Amazon S3 location where the annotations for an entity recognizer
	// are located. The URI must be in the same region as the API endpoint that
	// you are calling.
	//
	// S3Uri is a required field
	S3Uri *string `type:"string" required:"true"`
}

// String returns the string representation
func (s EntityRecognizerAnnotations) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EntityRecognizerAnnotations) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EntityRecognizerAnnotations) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EntityRecognizerAnnotations"}
	if s.S3Uri == nil {
		invalidParams.Add(request.NewErrParamRequired("S3Uri"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetS3Uri sets the S3Uri field's value.
func (s *EntityRecognizerAnnotations) SetS3Uri(v string) *EntityRecognizerAnnotations {
	s.S3Uri = &v
	return s
}

// Describes the training documents submitted with an entity recognizer.
type EntityRecognizerDocuments struct {
	_ struct{} `type:"structure"`

	// Specifies the Amazon S3 location where the training documents for an entity
	// recognizer are located. The URI must be in the same region as the API endpoint
	// that you are calling.
	//
	// S3Uri is a required field
	S3Uri *string `type:"string" required:"true"`
}

// String returns the string representation
func (s EntityRecognizerDocuments) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EntityRecognizerDocuments) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EntityRecognizerDocuments) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EntityRecognizerDocuments"}
	if s.S3Uri == nil {
		invalidParams.Add(request.NewErrParamRequired("S3Uri"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetS3Uri sets the S3Uri field's value.
func (s *EntityRecognizerDocuments) SetS3Uri(v string) *EntityRecognizerDocuments {
	s.S3Uri = &v
	return s
}

// Describes the entity recognizer submitted with an entity recognizer.
type EntityRecognizerEntityList struct {
	_ struct{} `type:"structure"`

	// Specifies the Amazon S3 location where the entity list is located. The URI
	// must be in the same region as the API endpoint that you are calling.
	//
	// S3Uri is a required field
	S3Uri *string `type:"string" required:"true"`
}

// String returns the string representation
func (s EntityRecognizerEntityList) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EntityRecognizerEntityList) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EntityRecognizerEntityList) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EntityRecognizerEntityList"}
	if s.S3Uri == nil {
		invalidParams.Add(request.NewErrParamRequired("S3Uri"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetS3Uri sets the S3Uri field's value.
func (s *EntityRecognizerEntityList) SetS3Uri(v string) *EntityRecognizerEntityList {
	s.S3Uri = &v
	return s
}

// Detailed information about the accuracy of an entity recognizer.
type EntityRecognizerEvaluationMetrics struct {
	_ struct{} `type:"structure"`

	// A measure of how accurate the recognizer results are for the test data. It
	// is derived from the Precision and Recall values. The F1Score is the harmonic
	// average of the two scores. The highest score is 1, and the worst score is
	// 0.
	F1Score *float64 `type:"double"`

	// A measure of the usefulness of the recognizer results in the test data. High
	// precision means that the recognizer returned substantially more relevant
	// results than irrelevant ones.
	Precision *float64 `type:"double"`

	// A measure of how complete the recognizer results are for the test data. High
	// recall means that the recognizer returned most of the relevant results.
	Recall *float64 `type:"double"`
}

// String returns the string representation
func (s EntityRecognizerEvaluationMetrics) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EntityRecognizerEvaluationMetrics) GoString() string {
	return s.String()
}

// SetF1Score sets the F1Score field's value.
func (s *EntityRecognizerEvaluationMetrics) SetF1Score(v float64) *EntityRecognizerEvaluationMetrics {
	s.F1Score = &v
	return s
}

// SetPrecision sets the Precision field's value.
func (s *EntityRecognizerEvaluationMetrics) SetPrecision(v float64) *EntityRecognizerEvaluationMetrics {
	s.Precision = &v
	return s
}

// SetRecall sets the Recall field's value.
func (s *EntityRecognizerEvaluationMetrics) SetRecall(v float64) *EntityRecognizerEvaluationMetrics {
	s.Recall = &v
	return s
}

// Provides information for filtering a list of entity recognizers. You can
// only specify one filtering parameter in a request. For more information,
// see the operation./>
type EntityRecognizerFilter struct {
	_ struct{} `type:"structure"`

	// The status of an entity recognizer.
	Status *string `type:"string" enum:"ModelStatus"`

	// Filters the list of entities based on the time that the list was submitted
	// for processing. Returns only jobs submitted after the specified time. Jobs
	// are returned in ascending order, oldest to newest.
	SubmitTimeAfter *time.Time `type:"timestamp"`

	// Filters the list of entities based on the time that the list was submitted
	// for processing. Returns only jobs submitted before the specified time. Jobs
	// are returned in descending order, newest to oldest.
	SubmitTimeBefore *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s EntityRecognizerFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EntityRecognizerFilter) GoString() string {
	return s.String()
}

// SetStatus sets the Status field's value.
func (s *EntityRecognizerFilter) SetStatus(v string) *EntityRecognizerFilter {
	s.Status = &v
	return s
}

// SetSubmitTimeAfter sets the SubmitTimeAfter field's value.
func (s *EntityRecognizerFilter) SetSubmitTimeAfter(v time.Time) *EntityRecognizerFilter {
	s.SubmitTimeAfter = &v
	return s
}

// SetSubmitTimeBefore sets the SubmitTimeBefore field's value.
func (s *EntityRecognizerFilter) SetSubmitTimeBefore(v time.Time) *EntityRecognizerFilter {
	s.SubmitTimeBefore = &v
	return s
}

// Specifies the format and location of the input data.
type EntityRecognizerInputDataConfig struct {
	_ struct{} `type:"structure"`

	// The S3 location of the CSV file that annotates your training documents.
	Annotations *EntityRecognizerAnnotations `type:"structure"`

	// A list of augmented manifest files that provide training data for your custom
	// model. An augmented manifest file is a labeled dataset that is produced by
	// Amazon SageMaker Ground Truth.
	//
	// This parameter is required if you set DataFormat to AUGMENTED_MANIFEST.
	AugmentedManifests []*AugmentedManifestsListItem `type:"list"`

	// The format of your training data:
	//
	//    * COMPREHEND_CSV: A CSV file that supplements your training documents.
	//    The CSV file contains information about the custom entities that your
	//    trained model will detect. The required format of the file depends on
	//    whether you are providing annotations or an entity list. If you use this
	//    value, you must provide your CSV file by using either the Annotations
	//    or EntityList parameters. You must provide your training documents by
	//    using the Documents parameter.
	//
	//    * AUGMENTED_MANIFEST: A labeled dataset that is produced by Amazon SageMaker
	//    Ground Truth. This file is in JSON lines format. Each line is a complete
	//    JSON object that contains a training document and its labels. Each label
	//    annotates a named entity in the training document. If you use this value,
	//    you must provide the AugmentedManifests parameter in your request.
	//
	// If you don't specify a value, Amazon Comprehend uses COMPREHEND_CSV as the
	// default.
	DataFormat *string `type:"string" enum:"EntityRecognizerDataFormat"`

	// The S3 location of the folder that contains the training documents for your
	// custom entity recognizer.
	//
	// This parameter is required if you set DataFormat to COMPREHEND_CSV.
	Documents *EntityRecognizerDocuments `type:"structure"`

	// The S3 location of the CSV file that has the entity list for your custom
	// entity recognizer.
	EntityList *EntityRecognizerEntityList `type:"structure"`

	// The entity types in the labeled training data that Amazon Comprehend uses
	// to train the custom entity recognizer. Any entity types that you don't specify
	// are ignored.
	//
	// A maximum of 25 entity types can be used at one time to train an entity recognizer.
	// Entity types must not contain the following invalid characters: \n (line
	// break), \\n (escaped line break), \r (carriage return), \\r (escaped carriage
	// return), \t (tab), \\t (escaped tab), space, and , (comma).
	//
	// EntityTypes is a required field
	EntityTypes []*EntityTypesListItem `type:"list" required:"true"`
}

// String returns the string representation
func (s EntityRecognizerInputDataConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EntityRecognizerInputDataConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EntityRecognizerInputDataConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EntityRecognizerInputDataConfig"}
	if s.EntityTypes == nil {
		invalidParams.Add(request.NewErrParamRequired("EntityTypes"))
	}
	if s.Annotations != nil {
		if err := s.Annotations.Validate(); err != nil {
			invalidParams.AddNested("Annotations", err.(request.ErrInvalidParams))
		}
	}
	if s.AugmentedManifests != nil {
		for i, v := range s.AugmentedManifests {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AugmentedManifests", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Documents != nil {
		if err := s.Documents.Validate(); err != nil {
			invalidParams.AddNested("Documents", err.(request.ErrInvalidParams))
		}
	}
	if s.EntityList != nil {
		if err := s.EntityList.Validate(); err != nil {
			invalidParams.AddNested("EntityList", err.(request.ErrInvalidParams))
		}
	}
	if s.EntityTypes != nil {
		for i, v := range s.EntityTypes {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "EntityTypes", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAnnotations sets the Annotations field's value.
func (s *EntityRecognizerInputDataConfig) SetAnnotations(v *EntityRecognizerAnnotations) *EntityRecognizerInputDataConfig {
	s.Annotations = v
	return s
}

// SetAugmentedManifests sets the AugmentedManifests field's value.
func (s *EntityRecognizerInputDataConfig) SetAugmentedManifests(v []*AugmentedManifestsListItem) *EntityRecognizerInputDataConfig {
	s.AugmentedManifests = v
	return s
}

// SetDataFormat sets the DataFormat field's value.
func (s *EntityRecognizerInputDataConfig) SetDataFormat(v string) *EntityRecognizerInputDataConfig {
	s.DataFormat = &v
	return s
}

// SetDocuments sets the Documents field's value.
func (s *EntityRecognizerInputDataConfig) SetDocuments(v *EntityRecognizerDocuments) *EntityRecognizerInputDataConfig {
	s.Documents = v
	return s
}

// SetEntityList sets the EntityList field's value.
func (s *EntityRecognizerInputDataConfig) SetEntityList(v *EntityRecognizerEntityList) *EntityRecognizerInputDataConfig {
	s.EntityList = v
	return s
}

// SetEntityTypes sets the EntityTypes field's value.
func (s *EntityRecognizerInputDataConfig) SetEntityTypes(v []*EntityTypesListItem) *EntityRecognizerInputDataConfig {
	s.EntityTypes = v
	return s
}

// Detailed information about an entity recognizer.
type EntityRecognizerMetadata struct {
	_ struct{} `type:"structure" sensitive:"true"`

	// Entity types from the metadata of an entity recognizer.
	EntityTypes []*EntityRecognizerMetadataEntityTypesListItem `type:"list"`

	// Detailed information about the accuracy of an entity recognizer.
	EvaluationMetrics *EntityRecognizerEvaluationMetrics `type:"structure"`

	// The number of documents in the input data that were used to test the entity
	// recognizer. Typically this is 10 to 20 percent of the input documents.
	NumberOfTestDocuments *int64 `type:"integer"`

	// The number of documents in the input data that were used to train the entity
	// recognizer. Typically this is 80 to 90 percent of the input documents.
	NumberOfTrainedDocuments *int64 `type:"integer"`
}

// String returns the string representation
func (s EntityRecognizerMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EntityRecognizerMetadata) GoString() string {
	return s.String()
}

// SetEntityTypes sets the EntityTypes field's value.
func (s *EntityRecognizerMetadata) SetEntityTypes(v []*EntityRecognizerMetadataEntityTypesListItem) *EntityRecognizerMetadata {
	s.EntityTypes = v
	return s
}

// SetEvaluationMetrics sets the EvaluationMetrics field's value.
func (s *EntityRecognizerMetadata) SetEvaluationMetrics(v *EntityRecognizerEvaluationMetrics) *EntityRecognizerMetadata {
	s.EvaluationMetrics = v
	return s
}

// SetNumberOfTestDocuments sets the NumberOfTestDocuments field's value.
func (s *EntityRecognizerMetadata) SetNumberOfTestDocuments(v int64) *EntityRecognizerMetadata {
	s.NumberOfTestDocuments = &v
	return s
}

// SetNumberOfTrainedDocuments sets the NumberOfTrainedDocuments field's value.
func (s *EntityRecognizerMetadata) SetNumberOfTrainedDocuments(v int64) *EntityRecognizerMetadata {
	s.NumberOfTrainedDocuments = &v
	return s
}

// Individual item from the list of entity types in the metadata of an entity
// recognizer.
type EntityRecognizerMetadataEntityTypesListItem struct {
	_ struct{} `type:"structure"`

	// Detailed information about the accuracy of the entity recognizer for a specific
	// item on the list of entity types.
	EvaluationMetrics *EntityTypesEvaluationMetrics `type:"structure"`

	// Indicates the number of times the given entity type was seen in the training
	// data.
	NumberOfTrainMentions *int64 `type:"integer"`

	// Type of entity from the list of entity types in the metadata of an entity
	// recognizer.
	Type *string `type:"string"`
}

// String returns the string representation
func (s EntityRecognizerMetadataEntityTypesListItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EntityRecognizerMetadataEntityTypesListItem) GoString() string {
	return s.String()
}

// SetEvaluationMetrics sets the EvaluationMetrics field's value.
func (s *EntityRecognizerMetadataEntityTypesListItem) SetEvaluationMetrics(v *EntityTypesEvaluationMetrics) *EntityRecognizerMetadataEntityTypesListItem {
	s.EvaluationMetrics = v
	return s
}

// SetNumberOfTrainMentions sets the NumberOfTrainMentions field's value.
func (s *EntityRecognizerMetadataEntityTypesListItem) SetNumberOfTrainMentions(v int64) *EntityRecognizerMetadataEntityTypesListItem {
	s.NumberOfTrainMentions = &v
	return s
}

// SetType sets the Type field's value.
func (s *EntityRecognizerMetadataEntityTypesListItem) SetType(v string) *EntityRecognizerMetadataEntityTypesListItem {
	s.Type = &v
	return s
}

// Describes information about an entity recognizer.
type EntityRecognizerProperties struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the AWS Identity and Management (IAM) role
	// that grants Amazon Comprehend read access to your input data.
	DataAccessRoleArn *string `min:"20" type:"string"`

	// The time that the recognizer creation completed.
	EndTime *time.Time `type:"timestamp"`

	// The Amazon Resource Name (ARN) that identifies the entity recognizer.
	EntityRecognizerArn *string `type:"string"`

	// The input data properties of an entity recognizer.
	InputDataConfig *EntityRecognizerInputDataConfig `type:"structure"`

	// The language of the input documents. All documents must be in the same language.
	// Only English ("en") is currently supported.
	LanguageCode *string `type:"string" enum:"LanguageCode"`

	// A description of the status of the recognizer.
	Message *string `type:"string"`

	// Provides information about an entity recognizer.
	RecognizerMetadata *EntityRecognizerMetadata `type:"structure" sensitive:"true"`

	// Provides the status of the entity recognizer.
	Status *string `type:"string" enum:"ModelStatus"`

	// The time that the recognizer was submitted for processing.
	SubmitTime *time.Time `type:"timestamp"`

	// The time that training of the entity recognizer was completed.
	TrainingEndTime *time.Time `type:"timestamp"`

	// The time that training of the entity recognizer started.
	TrainingStartTime *time.Time `type:"timestamp"`

	// ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses
	// to encrypt data on the storage volume attached to the ML compute instance(s)
	// that process the analysis job. The VolumeKmsKeyId can be either of the following
	// formats:
	//
	//    * KMS Key ID: "1234abcd-12ab-34cd-56ef-1234567890ab"
	//
	//    * Amazon Resource Name (ARN) of a KMS Key: "arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"
	VolumeKmsKeyId *string `type:"string"`

	// Configuration parameters for a private Virtual Private Cloud (VPC) containing
	// the resources you are using for your custom entity recognizer. For more information,
	// see Amazon VPC (https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html).
	VpcConfig *VpcConfig `type:"structure"`
}

// String returns the string representation
func (s EntityRecognizerProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EntityRecognizerProperties) GoString() string {
	return s.String()
}

// SetDataAccessRoleArn sets the DataAccessRoleArn field's value.
func (s *EntityRecognizerProperties) SetDataAccessRoleArn(v string) *EntityRecognizerProperties {
	s.DataAccessRoleArn = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *EntityRecognizerProperties) SetEndTime(v time.Time) *EntityRecognizerProperties {
	s.EndTime = &v
	return s
}

// SetEntityRecognizerArn sets the EntityRecognizerArn field's value.
func (s *EntityRecognizerProperties) SetEntityRecognizerArn(v string) *EntityRecognizerProperties {
	s.EntityRecognizerArn = &v
	return s
}

// SetInputDataConfig sets the InputDataConfig field's value.
func (s *EntityRecognizerProperties) SetInputDataConfig(v *EntityRecognizerInputDataConfig) *EntityRecognizerProperties {
	s.InputDataConfig = v
	return s
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *EntityRecognizerProperties) SetLanguageCode(v string) *EntityRecognizerProperties {
	s.LanguageCode = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *EntityRecognizerProperties) SetMessage(v string) *EntityRecognizerProperties {
	s.Message = &v
	return s
}

// SetRecognizerMetadata sets the RecognizerMetadata field's value.
func (s *EntityRecognizerProperties) SetRecognizerMetadata(v *EntityRecognizerMetadata) *EntityRecognizerProperties {
	s.RecognizerMetadata = v
	return s
}

// SetStatus sets the Status field's value.
func (s *EntityRecognizerProperties) SetStatus(v string) *EntityRecognizerProperties {
	s.Status = &v
	return s
}

// SetSubmitTime sets the SubmitTime field's value.
func (s *EntityRecognizerProperties) SetSubmitTime(v time.Time) *EntityRecognizerProperties {
	s.SubmitTime = &v
	return s
}

// SetTrainingEndTime sets the TrainingEndTime field's value.
func (s *EntityRecognizerProperties) SetTrainingEndTime(v time.Time) *EntityRecognizerProperties {
	s.TrainingEndTime = &v
	return s
}

// SetTrainingStartTime sets the TrainingStartTime field's value.
func (s *EntityRecognizerProperties) SetTrainingStartTime(v time.Time) *EntityRecognizerProperties {
	s.TrainingStartTime = &v
	return s
}

// SetVolumeKmsKeyId sets the VolumeKmsKeyId field's value.
func (s *EntityRecognizerProperties) SetVolumeKmsKeyId(v string) *EntityRecognizerProperties {
	s.VolumeKmsKeyId = &v
	return s
}

// SetVpcConfig sets the VpcConfig field's value.
func (s *EntityRecognizerProperties) SetVpcConfig(v *VpcConfig) *EntityRecognizerProperties {
	s.VpcConfig = v
	return s
}

// Detailed information about the accuracy of an entity recognizer for a specific
// entity type.
type EntityTypesEvaluationMetrics struct {
	_ struct{} `type:"structure"`

	// A measure of how accurate the recognizer results are for for a specific entity
	// type in the test data. It is derived from the Precision and Recall values.
	// The F1Score is the harmonic average of the two scores. The highest score
	// is 1, and the worst score is 0.
	F1Score *float64 `type:"double"`

	// A measure of the usefulness of the recognizer results for a specific entity
	// type in the test data. High precision means that the recognizer returned
	// substantially more relevant results than irrelevant ones.
	Precision *float64 `type:"double"`

	// A measure of how complete the recognizer results are for a specific entity
	// type in the test data. High recall means that the recognizer returned most
	// of the relevant results.
	Recall *float64 `type:"double"`
}

// String returns the string representation
func (s EntityTypesEvaluationMetrics) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EntityTypesEvaluationMetrics) GoString() string {
	return s.String()
}

// SetF1Score sets the F1Score field's value.
func (s *EntityTypesEvaluationMetrics) SetF1Score(v float64) *EntityTypesEvaluationMetrics {
	s.F1Score = &v
	return s
}

// SetPrecision sets the Precision field's value.
func (s *EntityTypesEvaluationMetrics) SetPrecision(v float64) *EntityTypesEvaluationMetrics {
	s.Precision = &v
	return s
}

// SetRecall sets the Recall field's value.
func (s *EntityTypesEvaluationMetrics) SetRecall(v float64) *EntityTypesEvaluationMetrics {
	s.Recall = &v
	return s
}

// An entity type within a labeled training dataset that Amazon Comprehend uses
// to train a custom entity recognizer.
type EntityTypesListItem struct {
	_ struct{} `type:"structure"`

	// An entity type within a labeled training dataset that Amazon Comprehend uses
	// to train a custom entity recognizer.
	//
	// Entity types must not contain the following invalid characters: \n (line
	// break), \\n (escaped line break, \r (carriage return), \\r (escaped carriage
	// return), \t (tab), \\t (escaped tab), space, and , (comma).
	//
	// Type is a required field
	Type *string `type:"string" required:"true"`
}

// String returns the string representation
func (s EntityTypesListItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EntityTypesListItem) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EntityTypesListItem) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EntityTypesListItem"}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetType sets the Type field's value.
func (s *EntityTypesListItem) SetType(v string) *EntityTypesListItem {
	s.Type = &v
	return s
}

// The input properties for a topic detection job.
type InputDataConfig struct {
	_ struct{} `type:"structure"`

	// Specifies how the text in an input file should be processed:
	//
	//    * ONE_DOC_PER_FILE - Each file is considered a separate document. Use
	//    this option when you are processing large documents, such as newspaper
	//    articles or scientific papers.
	//
	//    * ONE_DOC_PER_LINE - Each line in a file is considered a separate document.
	//    Use this option when you are processing many short documents, such as
	//    text messages.
	InputFormat *string `type:"string" enum:"InputFormat"`

	// The Amazon S3 URI for the input data. The URI must be in same region as the
	// API endpoint that you are calling. The URI can point to a single input file
	// or it can provide the prefix for a collection of data files.
	//
	// For example, if you use the URI S3://bucketName/prefix, if the prefix is
	// a single file, Amazon Comprehend uses that file as input. If more than one
	// file begins with the prefix, Amazon Comprehend uses all of them as input.
	//
	// S3Uri is a required field
	S3Uri *string `type:"string" required:"true"`
}

// String returns the string representation
func (s InputDataConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InputDataConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InputDataConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InputDataConfig"}
	if s.S3Uri == nil {
		invalidParams.Add(request.NewErrParamRequired("S3Uri"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInputFormat sets the InputFormat field's value.
func (s *InputDataConfig) SetInputFormat(v string) *InputDataConfig {
	s.InputFormat = &v
	return s
}

// SetS3Uri sets the S3Uri field's value.
func (s *InputDataConfig) SetS3Uri(v string) *InputDataConfig {
	s.S3Uri = &v
	return s
}

// An internal server error occurred. Retry your request.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The filter specified for the operation is invalid. Specify a different filter.
type InvalidFilterException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation
func (s InvalidFilterException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidFilterException) GoString() string {
	return s.String()
}

func newErrorInvalidFilterException(v protocol.ResponseMetadata) error {
	return &InvalidFilterException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidFilterException) Code() string {
	return "InvalidFilterException"
}

// Message returns the exception's message.
func (s *InvalidFilterException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidFilterException) OrigErr() error {
	return nil
}

func (s *InvalidFilterException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidFilterException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidFilterException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The request is invalid.
type InvalidRequestException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation
func (s InvalidRequestException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidRequestException) GoString() string {
	return s.String()
}

func newErrorInvalidRequestException(v protocol.ResponseMetadata) error {
	return &InvalidRequestException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidRequestException) Code() string {
	return "InvalidRequestException"
}

// Message returns the exception's message.
func (s *InvalidRequestException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidRequestException) OrigErr() error {
	return nil
}

func (s *InvalidRequestException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidRequestException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidRequestException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The specified job was not found. Check the job ID and try again.
type JobNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation
func (s JobNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s JobNotFoundException) GoString() string {
	return s.String()
}

func newErrorJobNotFoundException(v protocol.ResponseMetadata) error {
	return &JobNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *JobNotFoundException) Code() string {
	return "JobNotFoundException"
}

// Message returns the exception's message.
func (s *JobNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *JobNotFoundException) OrigErr() error {
	return nil
}

func (s *JobNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *JobNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *JobNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Describes a key noun phrase.
type KeyPhrase struct {
	_ struct{} `type:"structure"`

	// A character offset in the input text that shows where the key phrase begins
	// (the first character is at position 0). The offset returns the position of
	// each UTF-8 code point in the string. A code point is the abstract character
	// from a particular graphical representation. For example, a multi-byte UTF-8
	// character maps to a single code point.
	BeginOffset *int64 `type:"integer"`

	// A character offset in the input text where the key phrase ends. The offset
	// returns the position of each UTF-8 code point in the string. A code point
	// is the abstract character from a particular graphical representation. For
	// example, a multi-byte UTF-8 character maps to a single code point.
	EndOffset *int64 `type:"integer"`

	// The level of confidence that Amazon Comprehend has in the accuracy of the
	// detection.
	Score *float64 `type:"float"`

	// The text of a key noun phrase.
	Text *string `min:"1" type:"string"`
}

// String returns the string representation
func (s KeyPhrase) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s KeyPhrase) GoString() string {
	return s.String()
}

// SetBeginOffset sets the BeginOffset field's value.
func (s *KeyPhrase) SetBeginOffset(v int64) *KeyPhrase {
	s.BeginOffset = &v
	return s
}

// SetEndOffset sets the EndOffset field's value.
func (s *KeyPhrase) SetEndOffset(v int64) *KeyPhrase {
	s.EndOffset = &v
	return s
}

// SetScore sets the Score field's value.
func (s *KeyPhrase) SetScore(v float64) *KeyPhrase {
	s.Score = &v
	return s
}

// SetText sets the Text field's value.
func (s *KeyPhrase) SetText(v string) *KeyPhrase {
	s.Text = &v
	return s
}

// Provides information for filtering a list of dominant language detection
// jobs. For more information, see the operation.
type KeyPhrasesDetectionJobFilter struct {
	_ struct{} `type:"structure"`

	// Filters on the name of the job.
	JobName *string `min:"1" type:"string"`

	// Filters the list of jobs based on job status. Returns only jobs with the
	// specified status.
	JobStatus *string `type:"string" enum:"JobStatus"`

	// Filters the list of jobs based on the time that the job was submitted for
	// processing. Returns only jobs submitted after the specified time. Jobs are
	// returned in descending order, newest to oldest.
	SubmitTimeAfter *time.Time `type:"timestamp"`

	// Filters the list of jobs based on the time that the job was submitted for
	// processing. Returns only jobs submitted before the specified time. Jobs are
	// returned in ascending order, oldest to newest.
	SubmitTimeBefore *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s KeyPhrasesDetectionJobFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s KeyPhrasesDetectionJobFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *KeyPhrasesDetectionJobFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "KeyPhrasesDetectionJobFilter"}
	if s.JobName != nil && len(*s.JobName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobName sets the JobName field's value.
func (s *KeyPhrasesDetectionJobFilter) SetJobName(v string) *KeyPhrasesDetectionJobFilter {
	s.JobName = &v
	return s
}

// SetJobStatus sets the JobStatus field's value.
func (s *KeyPhrasesDetectionJobFilter) SetJobStatus(v string) *KeyPhrasesDetectionJobFilter {
	s.JobStatus = &v
	return s
}

// SetSubmitTimeAfter sets the SubmitTimeAfter field's value.
func (s *KeyPhrasesDetectionJobFilter) SetSubmitTimeAfter(v time.Time) *KeyPhrasesDetectionJobFilter {
	s.SubmitTimeAfter = &v
	return s
}

// SetSubmitTimeBefore sets the SubmitTimeBefore field's value.
func (s *KeyPhrasesDetectionJobFilter) SetSubmitTimeBefore(v time.Time) *KeyPhrasesDetectionJobFilter {
	s.SubmitTimeBefore = &v
	return s
}

// Provides information about a key phrases detection job.
type KeyPhrasesDetectionJobProperties struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) that gives Amazon Comprehend read access to
	// your input data.
	DataAccessRoleArn *string `min:"20" type:"string"`

	// The time that the key phrases detection job completed.
	EndTime *time.Time `type:"timestamp"`

	// The input data configuration that you supplied when you created the key phrases
	// detection job.
	InputDataConfig *InputDataConfig `type:"structure"`

	// The identifier assigned to the key phrases detection job.
	JobId *string `min:"1" type:"string"`

	// The name that you assigned the key phrases detection job.
	JobName *string `min:"1" type:"string"`

	// The current status of the key phrases detection job. If the status is FAILED,
	// the Message field shows the reason for the failure.
	JobStatus *string `type:"string" enum:"JobStatus"`

	// The language code of the input documents.
	LanguageCode *string `type:"string" enum:"LanguageCode"`

	// A description of the status of a job.
	Message *string `type:"string"`

	// The output data configuration that you supplied when you created the key
	// phrases detection job.
	OutputDataConfig *OutputDataConfig `type:"structure"`

	// The time that the key phrases detection job was submitted for processing.
	SubmitTime *time.Time `type:"timestamp"`

	// ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses
	// to encrypt data on the storage volume attached to the ML compute instance(s)
	// that process the analysis job. The VolumeKmsKeyId can be either of the following
	// formats:
	//
	//    * KMS Key ID: "1234abcd-12ab-34cd-56ef-1234567890ab"
	//
	//    * Amazon Resource Name (ARN) of a KMS Key: "arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"
	VolumeKmsKeyId *string `type:"string"`

	// Configuration parameters for a private Virtual Private Cloud (VPC) containing
	// the resources you are using for your key phrases detection job. For more
	// information, see Amazon VPC (https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html).
	VpcConfig *VpcConfig `type:"structure"`
}

// String returns the string representation
func (s KeyPhrasesDetectionJobProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s KeyPhrasesDetectionJobProperties) GoString() string {
	return s.String()
}

// SetDataAccessRoleArn sets the DataAccessRoleArn field's value.
func (s *KeyPhrasesDetectionJobProperties) SetDataAccessRoleArn(v string) *KeyPhrasesDetectionJobProperties {
	s.DataAccessRoleArn = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *KeyPhrasesDetectionJobProperties) SetEndTime(v time.Time) *KeyPhrasesDetectionJobProperties {
	s.EndTime = &v
	return s
}

// SetInputDataConfig sets the InputDataConfig field's value.
func (s *KeyPhrasesDetectionJobProperties) SetInputDataConfig(v *InputDataConfig) *KeyPhrasesDetectionJobProperties {
	s.InputDataConfig = v
	return s
}

// SetJobId sets the JobId field's value.
func (s *KeyPhrasesDetectionJobProperties) SetJobId(v string) *KeyPhrasesDetectionJobProperties {
	s.JobId = &v
	return s
}

// SetJobName sets the JobName field's value.
func (s *KeyPhrasesDetectionJobProperties) SetJobName(v string) *KeyPhrasesDetectionJobProperties {
	s.JobName = &v
	return s
}

// SetJobStatus sets the JobStatus field's value.
func (s *KeyPhrasesDetectionJobProperties) SetJobStatus(v string) *KeyPhrasesDetectionJobProperties {
	s.JobStatus = &v
	return s
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *KeyPhrasesDetectionJobProperties) SetLanguageCode(v string) *KeyPhrasesDetectionJobProperties {
	s.LanguageCode = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *KeyPhrasesDetectionJobProperties) SetMessage(v string) *KeyPhrasesDetectionJobProperties {
	s.Message = &v
	return s
}

// SetOutputDataConfig sets the OutputDataConfig field's value.
func (s *KeyPhrasesDetectionJobProperties) SetOutputDataConfig(v *OutputDataConfig) *KeyPhrasesDetectionJobProperties {
	s.OutputDataConfig = v
	return s
}

// SetSubmitTime sets the SubmitTime field's value.
func (s *KeyPhrasesDetectionJobProperties) SetSubmitTime(v time.Time) *KeyPhrasesDetectionJobProperties {
	s.SubmitTime = &v
	return s
}

// SetVolumeKmsKeyId sets the VolumeKmsKeyId field's value.
func (s *KeyPhrasesDetectionJobProperties) SetVolumeKmsKeyId(v string) *KeyPhrasesDetectionJobProperties {
	s.VolumeKmsKeyId = &v
	return s
}

// SetVpcConfig sets the VpcConfig field's value.
func (s *KeyPhrasesDetectionJobProperties) SetVpcConfig(v *VpcConfig) *KeyPhrasesDetectionJobProperties {
	s.VpcConfig = v
	return s
}

// The KMS customer managed key (CMK) entered cannot be validated. Verify the
// key and re-enter it.
type KmsKeyValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation
func (s KmsKeyValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s KmsKeyValidationException) GoString() string {
	return s.String()
}

func newErrorKmsKeyValidationException(v protocol.ResponseMetadata) error {
	return &KmsKeyValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *KmsKeyValidationException) Code() string {
	return "KmsKeyValidationException"
}

// Message returns the exception's message.
func (s *KmsKeyValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *KmsKeyValidationException) OrigErr() error {
	return nil
}

func (s *KmsKeyValidationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *KmsKeyValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *KmsKeyValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListDocumentClassificationJobsInput struct {
	_ struct{} `type:"structure"`

	// Filters the jobs that are returned. You can filter jobs on their names, status,
	// or the date and time that they were submitted. You can only set one filter
	// at a time.
	Filter *DocumentClassificationJobFilter `type:"structure"`

	// The maximum number of results to return in each page. The default is 100.
	MaxResults *int64 `min:"1" type:"integer"`

	// Identifies the next page of results to return.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListDocumentClassificationJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDocumentClassificationJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDocumentClassificationJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDocumentClassificationJobsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.Filter != nil {
		if err := s.Filter.Validate(); err != nil {
			invalidParams.AddNested("Filter", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilter sets the Filter field's value.
func (s *ListDocumentClassificationJobsInput) SetFilter(v *DocumentClassificationJobFilter) *ListDocumentClassificationJobsInput {
	s.Filter = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListDocumentClassificationJobsInput) SetMaxResults(v int64) *ListDocumentClassificationJobsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDocumentClassificationJobsInput) SetNextToken(v string) *ListDocumentClassificationJobsInput {
	s.NextToken = &v
	return s
}

type ListDocumentClassificationJobsOutput struct {
	_ struct{} `type:"structure"`

	// A list containing the properties of each job returned.
	DocumentClassificationJobPropertiesList []*DocumentClassificationJobProperties `type:"list"`

	// Identifies the next page of results to return.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListDocumentClassificationJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDocumentClassificationJobsOutput) GoString() string {
	return s.String()
}

// SetDocumentClassificationJobPropertiesList sets the DocumentClassificationJobPropertiesList field's value.
func (s *ListDocumentClassificationJobsOutput) SetDocumentClassificationJobPropertiesList(v []*DocumentClassificationJobProperties) *ListDocumentClassificationJobsOutput {
	s.DocumentClassificationJobPropertiesList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDocumentClassificationJobsOutput) SetNextToken(v string) *ListDocumentClassificationJobsOutput {
	s.NextToken = &v
	return s
}

type ListDocumentClassifiersInput struct {
	_ struct{} `type:"structure"`

	// Filters the jobs that are returned. You can filter jobs on their name, status,
	// or the date and time that they were submitted. You can only set one filter
	// at a time.
	Filter *DocumentClassifierFilter `type:"structure"`

	// The maximum number of results to return in each page. The default is 100.
	MaxResults *int64 `min:"1" type:"integer"`

	// Identifies the next page of results to return.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListDocumentClassifiersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDocumentClassifiersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDocumentClassifiersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDocumentClassifiersInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilter sets the Filter field's value.
func (s *ListDocumentClassifiersInput) SetFilter(v *DocumentClassifierFilter) *ListDocumentClassifiersInput {
	s.Filter = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListDocumentClassifiersInput) SetMaxResults(v int64) *ListDocumentClassifiersInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDocumentClassifiersInput) SetNextToken(v string) *ListDocumentClassifiersInput {
	s.NextToken = &v
	return s
}

type ListDocumentClassifiersOutput struct {
	_ struct{} `type:"structure"`

	// A list containing the properties of each job returned.
	DocumentClassifierPropertiesList []*DocumentClassifierProperties `type:"list"`

	// Identifies the next page of results to return.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListDocumentClassifiersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDocumentClassifiersOutput) GoString() string {
	return s.String()
}

// SetDocumentClassifierPropertiesList sets the DocumentClassifierPropertiesList field's value.
func (s *ListDocumentClassifiersOutput) SetDocumentClassifierPropertiesList(v []*DocumentClassifierProperties) *ListDocumentClassifiersOutput {
	s.DocumentClassifierPropertiesList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDocumentClassifiersOutput) SetNextToken(v string) *ListDocumentClassifiersOutput {
	s.NextToken = &v
	return s
}

type ListDominantLanguageDetectionJobsInput struct {
	_ struct{} `type:"structure"`

	// Filters that jobs that are returned. You can filter jobs on their name, status,
	// or the date and time that they were submitted. You can only set one filter
	// at a time.
	Filter *DominantLanguageDetectionJobFilter `type:"structure"`

	// The maximum number of results to return in each page. The default is 100.
	MaxResults *int64 `min:"1" type:"integer"`

	// Identifies the next page of results to return.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListDominantLanguageDetectionJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDominantLanguageDetectionJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDominantLanguageDetectionJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDominantLanguageDetectionJobsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.Filter != nil {
		if err := s.Filter.Validate(); err != nil {
			invalidParams.AddNested("Filter", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilter sets the Filter field's value.
func (s *ListDominantLanguageDetectionJobsInput) SetFilter(v *DominantLanguageDetectionJobFilter) *ListDominantLanguageDetectionJobsInput {
	s.Filter = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListDominantLanguageDetectionJobsInput) SetMaxResults(v int64) *ListDominantLanguageDetectionJobsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDominantLanguageDetectionJobsInput) SetNextToken(v string) *ListDominantLanguageDetectionJobsInput {
	s.NextToken = &v
	return s
}

type ListDominantLanguageDetectionJobsOutput struct {
	_ struct{} `type:"structure"`

	// A list containing the properties of each job that is returned.
	DominantLanguageDetectionJobPropertiesList []*DominantLanguageDetectionJobProperties `type:"list"`

	// Identifies the next page of results to return.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListDominantLanguageDetectionJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDominantLanguageDetectionJobsOutput) GoString() string {
	return s.String()
}

// SetDominantLanguageDetectionJobPropertiesList sets the DominantLanguageDetectionJobPropertiesList field's value.
func (s *ListDominantLanguageDetectionJobsOutput) SetDominantLanguageDetectionJobPropertiesList(v []*DominantLanguageDetectionJobProperties) *ListDominantLanguageDetectionJobsOutput {
	s.DominantLanguageDetectionJobPropertiesList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDominantLanguageDetectionJobsOutput) SetNextToken(v string) *ListDominantLanguageDetectionJobsOutput {
	s.NextToken = &v
	return s
}

type ListEndpointsInput struct {
	_ struct{} `type:"structure"`

	// Filters the endpoints that are returned. You can filter endpoints on their
	// name, model, status, or the date and time that they were created. You can
	// only set one filter at a time.
	Filter *EndpointFilter `type:"structure"`

	// The maximum number of results to return in each page. The default is 100.
	MaxResults *int64 `min:"1" type:"integer"`

	// Identifies the next page of results to return.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListEndpointsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListEndpointsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListEndpointsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListEndpointsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilter sets the Filter field's value.
func (s *ListEndpointsInput) SetFilter(v *EndpointFilter) *ListEndpointsInput {
	s.Filter = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListEndpointsInput) SetMaxResults(v int64) *ListEndpointsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListEndpointsInput) SetNextToken(v string) *ListEndpointsInput {
	s.NextToken = &v
	return s
}

type ListEndpointsOutput struct {
	_ struct{} `type:"structure"`

	// Displays a list of endpoint properties being retrieved by the service in
	// response to the request.
	EndpointPropertiesList []*EndpointProperties `type:"list"`

	// Identifies the next page of results to return.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListEndpointsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListEndpointsOutput) GoString() string {
	return s.String()
}

// SetEndpointPropertiesList sets the EndpointPropertiesList field's value.
func (s *ListEndpointsOutput) SetEndpointPropertiesList(v []*EndpointProperties) *ListEndpointsOutput {
	s.EndpointPropertiesList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListEndpointsOutput) SetNextToken(v string) *ListEndpointsOutput {
	s.NextToken = &v
	return s
}

type ListEntitiesDetectionJobsInput struct {
	_ struct{} `type:"structure"`

	// Filters the jobs that are returned. You can filter jobs on their name, status,
	// or the date and time that they were submitted. You can only set one filter
	// at a time.
	Filter *EntitiesDetectionJobFilter `type:"structure"`

	// The maximum number of results to return in each page. The default is 100.
	MaxResults *int64 `min:"1" type:"integer"`

	// Identifies the next page of results to return.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListEntitiesDetectionJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListEntitiesDetectionJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListEntitiesDetectionJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListEntitiesDetectionJobsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.Filter != nil {
		if err := s.Filter.Validate(); err != nil {
			invalidParams.AddNested("Filter", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilter sets the Filter field's value.
func (s *ListEntitiesDetectionJobsInput) SetFilter(v *EntitiesDetectionJobFilter) *ListEntitiesDetectionJobsInput {
	s.Filter = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListEntitiesDetectionJobsInput) SetMaxResults(v int64) *ListEntitiesDetectionJobsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListEntitiesDetectionJobsInput) SetNextToken(v string) *ListEntitiesDetectionJobsInput {
	s.NextToken = &v
	return s
}

type ListEntitiesDetectionJobsOutput struct {
	_ struct{} `type:"structure"`

	// A list containing the properties of each job that is returned.
	EntitiesDetectionJobPropertiesList []*EntitiesDetectionJobProperties `type:"list"`

	// Identifies the next page of results to return.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListEntitiesDetectionJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListEntitiesDetectionJobsOutput) GoString() string {
	return s.String()
}

// SetEntitiesDetectionJobPropertiesList sets the EntitiesDetectionJobPropertiesList field's value.
func (s *ListEntitiesDetectionJobsOutput) SetEntitiesDetectionJobPropertiesList(v []*EntitiesDetectionJobProperties) *ListEntitiesDetectionJobsOutput {
	s.EntitiesDetectionJobPropertiesList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListEntitiesDetectionJobsOutput) SetNextToken(v string) *ListEntitiesDetectionJobsOutput {
	s.NextToken = &v
	return s
}

type ListEntityRecognizersInput struct {
	_ struct{} `type:"structure"`

	// Filters the list of entities returned. You can filter on Status, SubmitTimeBefore,
	// or SubmitTimeAfter. You can only set one filter at a time.
	Filter *EntityRecognizerFilter `type:"structure"`

	// The maximum number of results to return on each page. The default is 100.
	MaxResults *int64 `min:"1" type:"integer"`

	// Identifies the next page of results to return.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListEntityRecognizersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListEntityRecognizersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListEntityRecognizersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListEntityRecognizersInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilter sets the Filter field's value.
func (s *ListEntityRecognizersInput) SetFilter(v *EntityRecognizerFilter) *ListEntityRecognizersInput {
	s.Filter = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListEntityRecognizersInput) SetMaxResults(v int64) *ListEntityRecognizersInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListEntityRecognizersInput) SetNextToken(v string) *ListEntityRecognizersInput {
	s.NextToken = &v
	return s
}

type ListEntityRecognizersOutput struct {
	_ struct{} `type:"structure"`

	// The list of properties of an entity recognizer.
	EntityRecognizerPropertiesList []*EntityRecognizerProperties `type:"list"`

	// Identifies the next page of results to return.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListEntityRecognizersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListEntityRecognizersOutput) GoString() string {
	return s.String()
}

// SetEntityRecognizerPropertiesList sets the EntityRecognizerPropertiesList field's value.
func (s *ListEntityRecognizersOutput) SetEntityRecognizerPropertiesList(v []*EntityRecognizerProperties) *ListEntityRecognizersOutput {
	s.EntityRecognizerPropertiesList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListEntityRecognizersOutput) SetNextToken(v string) *ListEntityRecognizersOutput {
	s.NextToken = &v
	return s
}

type ListKeyPhrasesDetectionJobsInput struct {
	_ struct{} `type:"structure"`

	// Filters the jobs that are returned. You can filter jobs on their name, status,
	// or the date and time that they were submitted. You can only set one filter
	// at a time.
	Filter *KeyPhrasesDetectionJobFilter `type:"structure"`

	// The maximum number of results to return in each page. The default is 100.
	MaxResults *int64 `min:"1" type:"integer"`

	// Identifies the next page of results to return.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListKeyPhrasesDetectionJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListKeyPhrasesDetectionJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListKeyPhrasesDetectionJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListKeyPhrasesDetectionJobsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.Filter != nil {
		if err := s.Filter.Validate(); err != nil {
			invalidParams.AddNested("Filter", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilter sets the Filter field's value.
func (s *ListKeyPhrasesDetectionJobsInput) SetFilter(v *KeyPhrasesDetectionJobFilter) *ListKeyPhrasesDetectionJobsInput {
	s.Filter = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListKeyPhrasesDetectionJobsInput) SetMaxResults(v int64) *ListKeyPhrasesDetectionJobsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListKeyPhrasesDetectionJobsInput) SetNextToken(v string) *ListKeyPhrasesDetectionJobsInput {
	s.NextToken = &v
	return s
}

type ListKeyPhrasesDetectionJobsOutput struct {
	_ struct{} `type:"structure"`

	// A list containing the properties of each job that is returned.
	KeyPhrasesDetectionJobPropertiesList []*KeyPhrasesDetectionJobProperties `type:"list"`

	// Identifies the next page of results to return.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListKeyPhrasesDetectionJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListKeyPhrasesDetectionJobsOutput) GoString() string {
	return s.String()
}

// SetKeyPhrasesDetectionJobPropertiesList sets the KeyPhrasesDetectionJobPropertiesList field's value.
func (s *ListKeyPhrasesDetectionJobsOutput) SetKeyPhrasesDetectionJobPropertiesList(v []*KeyPhrasesDetectionJobProperties) *ListKeyPhrasesDetectionJobsOutput {
	s.KeyPhrasesDetectionJobPropertiesList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListKeyPhrasesDetectionJobsOutput) SetNextToken(v string) *ListKeyPhrasesDetectionJobsOutput {
	s.NextToken = &v
	return s
}

type ListPiiEntitiesDetectionJobsInput struct {
	_ struct{} `type:"structure"`

	// Filters the jobs that are returned. You can filter jobs on their name, status,
	// or the date and time that they were submitted. You can only set one filter
	// at a time.
	Filter *PiiEntitiesDetectionJobFilter `type:"structure"`

	// The maximum number of results to return in each page.
	MaxResults *int64 `min:"1" type:"integer"`

	// Identifies the next page of results to return.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListPiiEntitiesDetectionJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPiiEntitiesDetectionJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPiiEntitiesDetectionJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListPiiEntitiesDetectionJobsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.Filter != nil {
		if err := s.Filter.Validate(); err != nil {
			invalidParams.AddNested("Filter", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilter sets the Filter field's value.
func (s *ListPiiEntitiesDetectionJobsInput) SetFilter(v *PiiEntitiesDetectionJobFilter) *ListPiiEntitiesDetectionJobsInput {
	s.Filter = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListPiiEntitiesDetectionJobsInput) SetMaxResults(v int64) *ListPiiEntitiesDetectionJobsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListPiiEntitiesDetectionJobsInput) SetNextToken(v string) *ListPiiEntitiesDetectionJobsInput {
	s.NextToken = &v
	return s
}

type ListPiiEntitiesDetectionJobsOutput struct {
	_ struct{} `type:"structure"`

	// Identifies the next page of results to return.
	NextToken *string `min:"1" type:"string"`

	// A list containing the properties of each job that is returned.
	PiiEntitiesDetectionJobPropertiesList []*PiiEntitiesDetectionJobProperties `type:"list"`
}

// String returns the string representation
func (s ListPiiEntitiesDetectionJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPiiEntitiesDetectionJobsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListPiiEntitiesDetectionJobsOutput) SetNextToken(v string) *ListPiiEntitiesDetectionJobsOutput {
	s.NextToken = &v
	return s
}

// SetPiiEntitiesDetectionJobPropertiesList sets the PiiEntitiesDetectionJobPropertiesList field's value.
func (s *ListPiiEntitiesDetectionJobsOutput) SetPiiEntitiesDetectionJobPropertiesList(v []*PiiEntitiesDetectionJobProperties) *ListPiiEntitiesDetectionJobsOutput {
	s.PiiEntitiesDetectionJobPropertiesList = v
	return s
}

type ListSentimentDetectionJobsInput struct {
	_ struct{} `type:"structure"`

	// Filters the jobs that are returned. You can filter jobs on their name, status,
	// or the date and time that they were submitted. You can only set one filter
	// at a time.
	Filter *SentimentDetectionJobFilter `type:"structure"`

	// The maximum number of results to return in each page. The default is 100.
	MaxResults *int64 `min:"1" type:"integer"`

	// Identifies the next page of results to return.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListSentimentDetectionJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListSentimentDetectionJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListSentimentDetectionJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListSentimentDetectionJobsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.Filter != nil {
		if err := s.Filter.Validate(); err != nil {
			invalidParams.AddNested("Filter", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilter sets the Filter field's value.
func (s *ListSentimentDetectionJobsInput) SetFilter(v *SentimentDetectionJobFilter) *ListSentimentDetectionJobsInput {
	s.Filter = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListSentimentDetectionJobsInput) SetMaxResults(v int64) *ListSentimentDetectionJobsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListSentimentDetectionJobsInput) SetNextToken(v string) *ListSentimentDetectionJobsInput {
	s.NextToken = &v
	return s
}

type ListSentimentDetectionJobsOutput struct {
	_ struct{} `type:"structure"`

	// Identifies the next page of results to return.
	NextToken *string `min:"1" type:"string"`

	// A list containing the properties of each job that is returned.
	SentimentDetectionJobPropertiesList []*SentimentDetectionJobProperties `type:"list"`
}

// String returns the string representation
func (s ListSentimentDetectionJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListSentimentDetectionJobsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListSentimentDetectionJobsOutput) SetNextToken(v string) *ListSentimentDetectionJobsOutput {
	s.NextToken = &v
	return s
}

// SetSentimentDetectionJobPropertiesList sets the SentimentDetectionJobPropertiesList field's value.
func (s *ListSentimentDetectionJobsOutput) SetSentimentDetectionJobPropertiesList(v []*SentimentDetectionJobProperties) *ListSentimentDetectionJobsOutput {
	s.SentimentDetectionJobPropertiesList = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the given Amazon Comprehend resource you
	// are querying.
	//
	// ResourceArn is a required field
	ResourceArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the given Amazon Comprehend resource you
	// are querying.
	ResourceArn *string `type:"string"`

	// Tags associated with the Amazon Comprehend resource being queried. A tag
	// is a key-value pair that adds as a metadata to a resource used by Amazon
	// Comprehend. For example, a tag with "Sales" as the key might be added to
	// a resource to indicate its use by the sales department.
	Tags []*Tag `type:"list"`
}

// String returns the string representation
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceOutput) SetResourceArn(v string) *ListTagsForResourceOutput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v []*Tag) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

type ListTopicsDetectionJobsInput struct {
	_ struct{} `type:"structure"`

	// Filters the jobs that are returned. Jobs can be filtered on their name, status,
	// or the date and time that they were submitted. You can set only one filter
	// at a time.
	Filter *TopicsDetectionJobFilter `type:"structure"`

	// The maximum number of results to return in each page. The default is 100.
	MaxResults *int64 `min:"1" type:"integer"`

	// Identifies the next page of results to return.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListTopicsDetectionJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTopicsDetectionJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTopicsDetectionJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTopicsDetectionJobsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.Filter != nil {
		if err := s.Filter.Validate(); err != nil {
			invalidParams.AddNested("Filter", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilter sets the Filter field's value.
func (s *ListTopicsDetectionJobsInput) SetFilter(v *TopicsDetectionJobFilter) *ListTopicsDetectionJobsInput {
	s.Filter = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListTopicsDetectionJobsInput) SetMaxResults(v int64) *ListTopicsDetectionJobsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTopicsDetectionJobsInput) SetNextToken(v string) *ListTopicsDetectionJobsInput {
	s.NextToken = &v
	return s
}

type ListTopicsDetectionJobsOutput struct {
	_ struct{} `type:"structure"`

	// Identifies the next page of results to return.
	NextToken *string `min:"1" type:"string"`

	// A list containing the properties of each job that is returned.
	TopicsDetectionJobPropertiesList []*TopicsDetectionJobProperties `type:"list"`
}

// String returns the string representation
func (s ListTopicsDetectionJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTopicsDetectionJobsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListTopicsDetectionJobsOutput) SetNextToken(v string) *ListTopicsDetectionJobsOutput {
	s.NextToken = &v
	return s
}

// SetTopicsDetectionJobPropertiesList sets the TopicsDetectionJobPropertiesList field's value.
func (s *ListTopicsDetectionJobsOutput) SetTopicsDetectionJobPropertiesList(v []*TopicsDetectionJobProperties) *ListTopicsDetectionJobsOutput {
	s.TopicsDetectionJobPropertiesList = v
	return s
}

// Provides configuration parameters for the output of topic detection jobs.
type OutputDataConfig struct {
	_ struct{} `type:"structure"`

	// ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses
	// to encrypt the output results from an analysis job. The KmsKeyId can be one
	// of the following formats:
	//
	//    * KMS Key ID: "1234abcd-12ab-34cd-56ef-1234567890ab"
	//
	//    * Amazon Resource Name (ARN) of a KMS Key: "arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"
	//
	//    * KMS Key Alias: "alias/ExampleAlias"
	//
	//    * ARN of a KMS Key Alias: "arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias"
	KmsKeyId *string `type:"string"`

	// When you use the OutputDataConfig object with asynchronous operations, you
	// specify the Amazon S3 location where you want to write the output data. The
	// URI must be in the same region as the API endpoint that you are calling.
	// The location is used as the prefix for the actual location of the output
	// file.
	//
	// When the topic detection job is finished, the service creates an output file
	// in a directory specific to the job. The S3Uri field contains the location
	// of the output file, called output.tar.gz. It is a compressed archive that
	// contains the ouput of the operation.
	//
	// S3Uri is a required field
	S3Uri *string `type:"string" required:"true"`
}

// String returns the string representation
func (s OutputDataConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OutputDataConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OutputDataConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "OutputDataConfig"}
	if s.S3Uri == nil {
		invalidParams.Add(request.NewErrParamRequired("S3Uri"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *OutputDataConfig) SetKmsKeyId(v string) *OutputDataConfig {
	s.KmsKeyId = &v
	return s
}

// SetS3Uri sets the S3Uri field's value.
func (s *OutputDataConfig) SetS3Uri(v string) *OutputDataConfig {
	s.S3Uri = &v
	return s
}

// Identifies the part of speech represented by the token and gives the confidence
// that Amazon Comprehend has that the part of speech was correctly identified.
// For more information about the parts of speech that Amazon Comprehend can
// identify, see how-syntax.
type PartOfSpeechTag struct {
	_ struct{} `type:"structure"`

	// The confidence that Amazon Comprehend has that the part of speech was correctly
	// identified.
	Score *float64 `type:"float"`

	// Identifies the part of speech that the token represents.
	Tag *string `type:"string" enum:"PartOfSpeechTagType"`
}

// String returns the string representation
func (s PartOfSpeechTag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PartOfSpeechTag) GoString() string {
	return s.String()
}

// SetScore sets the Score field's value.
func (s *PartOfSpeechTag) SetScore(v float64) *PartOfSpeechTag {
	s.Score = &v
	return s
}

// SetTag sets the Tag field's value.
func (s *PartOfSpeechTag) SetTag(v string) *PartOfSpeechTag {
	s.Tag = &v
	return s
}

// Provides information for filtering a list of PII entity detection jobs.
type PiiEntitiesDetectionJobFilter struct {
	_ struct{} `type:"structure"`

	// Filters on the name of the job.
	JobName *string `min:"1" type:"string"`

	// Filters the list of jobs based on job status. Returns only jobs with the
	// specified status.
	JobStatus *string `type:"string" enum:"JobStatus"`

	// Filters the list of jobs based on the time that the job was submitted for
	// processing. Returns only jobs submitted after the specified time. Jobs are
	// returned in descending order, newest to oldest.
	SubmitTimeAfter *time.Time `type:"timestamp"`

	// Filters the list of jobs based on the time that the job was submitted for
	// processing. Returns only jobs submitted before the specified time. Jobs are
	// returned in ascending order, oldest to newest.
	SubmitTimeBefore *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s PiiEntitiesDetectionJobFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PiiEntitiesDetectionJobFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PiiEntitiesDetectionJobFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PiiEntitiesDetectionJobFilter"}
	if s.JobName != nil && len(*s.JobName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobName sets the JobName field's value.
func (s *PiiEntitiesDetectionJobFilter) SetJobName(v string) *PiiEntitiesDetectionJobFilter {
	s.JobName = &v
	return s
}

// SetJobStatus sets the JobStatus field's value.
func (s *PiiEntitiesDetectionJobFilter) SetJobStatus(v string) *PiiEntitiesDetectionJobFilter {
	s.JobStatus = &v
	return s
}

// SetSubmitTimeAfter sets the SubmitTimeAfter field's value.
func (s *PiiEntitiesDetectionJobFilter) SetSubmitTimeAfter(v time.Time) *PiiEntitiesDetectionJobFilter {
	s.SubmitTimeAfter = &v
	return s
}

// SetSubmitTimeBefore sets the SubmitTimeBefore field's value.
func (s *PiiEntitiesDetectionJobFilter) SetSubmitTimeBefore(v time.Time) *PiiEntitiesDetectionJobFilter {
	s.SubmitTimeBefore = &v
	return s
}

// Provides information about a PII entities detection job.
type PiiEntitiesDetectionJobProperties struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) that gives Amazon Comprehend read access to
	// your input data.
	DataAccessRoleArn *string `min:"20" type:"string"`

	// The time that the PII entities detection job completed.
	EndTime *time.Time `type:"timestamp"`

	// The input properties for a PII entities detection job.
	InputDataConfig *InputDataConfig `type:"structure"`

	// The identifier assigned to the PII entities detection job.
	JobId *string `min:"1" type:"string"`

	// The name that you assigned the PII entities detection job.
	JobName *string `min:"1" type:"string"`

	// The current status of the PII entities detection job. If the status is FAILED,
	// the Message field shows the reason for the failure.
	JobStatus *string `type:"string" enum:"JobStatus"`

	// The language code of the input documents
	LanguageCode *string `type:"string" enum:"LanguageCode"`

	// A description of the status of a job.
	Message *string `type:"string"`

	// Specifies whether the output provides the locations (offsets) of PII entities
	// or a file in which PII entities are redacted.
	Mode *string `type:"string" enum:"PiiEntitiesDetectionMode"`

	// The output data configuration that you supplied when you created the PII
	// entities detection job.
	OutputDataConfig *PiiOutputDataConfig `type:"structure"`

	// Provides configuration parameters for PII entity redaction.
	//
	// This parameter is required if you set the Mode parameter to ONLY_REDACTION.
	// In that case, you must provide a RedactionConfig definition that includes
	// the PiiEntityTypes parameter.
	RedactionConfig *RedactionConfig `type:"structure"`

	// The time that the PII entities detection job was submitted for processing.
	SubmitTime *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s PiiEntitiesDetectionJobProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PiiEntitiesDetectionJobProperties) GoString() string {
	return s.String()
}

// SetDataAccessRoleArn sets the DataAccessRoleArn field's value.
func (s *PiiEntitiesDetectionJobProperties) SetDataAccessRoleArn(v string) *PiiEntitiesDetectionJobProperties {
	s.DataAccessRoleArn = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *PiiEntitiesDetectionJobProperties) SetEndTime(v time.Time) *PiiEntitiesDetectionJobProperties {
	s.EndTime = &v
	return s
}

// SetInputDataConfig sets the InputDataConfig field's value.
func (s *PiiEntitiesDetectionJobProperties) SetInputDataConfig(v *InputDataConfig) *PiiEntitiesDetectionJobProperties {
	s.InputDataConfig = v
	return s
}

// SetJobId sets the JobId field's value.
func (s *PiiEntitiesDetectionJobProperties) SetJobId(v string) *PiiEntitiesDetectionJobProperties {
	s.JobId = &v
	return s
}

// SetJobName sets the JobName field's value.
func (s *PiiEntitiesDetectionJobProperties) SetJobName(v string) *PiiEntitiesDetectionJobProperties {
	s.JobName = &v
	return s
}

// SetJobStatus sets the JobStatus field's value.
func (s *PiiEntitiesDetectionJobProperties) SetJobStatus(v string) *PiiEntitiesDetectionJobProperties {
	s.JobStatus = &v
	return s
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *PiiEntitiesDetectionJobProperties) SetLanguageCode(v string) *PiiEntitiesDetectionJobProperties {
	s.LanguageCode = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *PiiEntitiesDetectionJobProperties) SetMessage(v string) *PiiEntitiesDetectionJobProperties {
	s.Message = &v
	return s
}

// SetMode sets the Mode field's value.
func (s *PiiEntitiesDetectionJobProperties) SetMode(v string) *PiiEntitiesDetectionJobProperties {
	s.Mode = &v
	return s
}

// SetOutputDataConfig sets the OutputDataConfig field's value.
func (s *PiiEntitiesDetectionJobProperties) SetOutputDataConfig(v *PiiOutputDataConfig) *PiiEntitiesDetectionJobProperties {
	s.OutputDataConfig = v
	return s
}

// SetRedactionConfig sets the RedactionConfig field's value.
func (s *PiiEntitiesDetectionJobProperties) SetRedactionConfig(v *RedactionConfig) *PiiEntitiesDetectionJobProperties {
	s.RedactionConfig = v
	return s
}

// SetSubmitTime sets the SubmitTime field's value.
func (s *PiiEntitiesDetectionJobProperties) SetSubmitTime(v time.Time) *PiiEntitiesDetectionJobProperties {
	s.SubmitTime = &v
	return s
}

// Provides information about a PII entity.
type PiiEntity struct {
	_ struct{} `type:"structure"`

	// A character offset in the input text that shows where the PII entity begins
	// (the first character is at position 0). The offset returns the position of
	// each UTF-8 code point in the string. A code point is the abstract character
	// from a particular graphical representation. For example, a multi-byte UTF-8
	// character maps to a single code point.
	BeginOffset *int64 `type:"integer"`

	// A character offset in the input text that shows where the PII entity ends.
	// The offset returns the position of each UTF-8 code point in the string. A
	// code point is the abstract character from a particular graphical representation.
	// For example, a multi-byte UTF-8 character maps to a single code point.
	EndOffset *int64 `type:"integer"`

	// The level of confidence that Amazon Comprehend has in the accuracy of the
	// detection.
	Score *float64 `type:"float"`

	// The entity's type.
	Type *string `type:"string" enum:"PiiEntityType"`
}

// String returns the string representation
func (s PiiEntity) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PiiEntity) GoString() string {
	return s.String()
}

// SetBeginOffset sets the BeginOffset field's value.
func (s *PiiEntity) SetBeginOffset(v int64) *PiiEntity {
	s.BeginOffset = &v
	return s
}

// SetEndOffset sets the EndOffset field's value.
func (s *PiiEntity) SetEndOffset(v int64) *PiiEntity {
	s.EndOffset = &v
	return s
}

// SetScore sets the Score field's value.
func (s *PiiEntity) SetScore(v float64) *PiiEntity {
	s.Score = &v
	return s
}

// SetType sets the Type field's value.
func (s *PiiEntity) SetType(v string) *PiiEntity {
	s.Type = &v
	return s
}

// Provides configuration parameters for the output of PII entity detection
// jobs.
type PiiOutputDataConfig struct {
	_ struct{} `type:"structure"`

	// ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses
	// to encrypt the output results from an analysis job.
	KmsKeyId *string `type:"string"`

	// When you use the PiiOutputDataConfig object with asynchronous operations,
	// you specify the Amazon S3 location where you want to write the output data.
	//
	// S3Uri is a required field
	S3Uri *string `type:"string" required:"true"`
}

// String returns the string representation
func (s PiiOutputDataConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PiiOutputDataConfig) GoString() string {
	return s.String()
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *PiiOutputDataConfig) SetKmsKeyId(v string) *PiiOutputDataConfig {
	s.KmsKeyId = &v
	return s
}

// SetS3Uri sets the S3Uri field's value.
func (s *PiiOutputDataConfig) SetS3Uri(v string) *PiiOutputDataConfig {
	s.S3Uri = &v
	return s
}

// Provides configuration parameters for PII entity redaction.
type RedactionConfig struct {
	_ struct{} `type:"structure"`

	// A character that replaces each character in the redacted PII entity.
	MaskCharacter *string `min:"1" type:"string"`

	// Specifies whether the PII entity is redacted with the mask character or the
	// entity type.
	MaskMode *string `type:"string" enum:"PiiEntitiesDetectionMaskMode"`

	// An array of the types of PII entities that Amazon Comprehend detects in the
	// input text for your request.
	PiiEntityTypes []*string `type:"list"`
}

// String returns the string representation
func (s RedactionConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RedactionConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RedactionConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RedactionConfig"}
	if s.MaskCharacter != nil && len(*s.MaskCharacter) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MaskCharacter", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaskCharacter sets the MaskCharacter field's value.
func (s *RedactionConfig) SetMaskCharacter(v string) *RedactionConfig {
	s.MaskCharacter = &v
	return s
}

// SetMaskMode sets the MaskMode field's value.
func (s *RedactionConfig) SetMaskMode(v string) *RedactionConfig {
	s.MaskMode = &v
	return s
}

// SetPiiEntityTypes sets the PiiEntityTypes field's value.
func (s *RedactionConfig) SetPiiEntityTypes(v []*string) *RedactionConfig {
	s.PiiEntityTypes = v
	return s
}

// The specified resource name is already in use. Use a different name and try
// your request again.
type ResourceInUseException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation
func (s ResourceInUseException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceInUseException) GoString() string {
	return s.String()
}

func newErrorResourceInUseException(v protocol.ResponseMetadata) error {
	return &ResourceInUseException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceInUseException) Code() string {
	return "ResourceInUseException"
}

// Message returns the exception's message.
func (s *ResourceInUseException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceInUseException) OrigErr() error {
	return nil
}

func (s *ResourceInUseException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceInUseException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceInUseException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The maximum number of resources per account has been exceeded. Review the
// resources, and then try your request again.
type ResourceLimitExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation
func (s ResourceLimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceLimitExceededException) GoString() string {
	return s.String()
}

func newErrorResourceLimitExceededException(v protocol.ResponseMetadata) error {
	return &ResourceLimitExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceLimitExceededException) Code() string {
	return "ResourceLimitExceededException"
}

// Message returns the exception's message.
func (s *ResourceLimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceLimitExceededException) OrigErr() error {
	return nil
}

func (s *ResourceLimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceLimitExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceLimitExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The specified resource ARN was not found. Check the ARN and try your request
// again.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The specified resource is not available. Check the resource and try your
// request again.
type ResourceUnavailableException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation
func (s ResourceUnavailableException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceUnavailableException) GoString() string {
	return s.String()
}

func newErrorResourceUnavailableException(v protocol.ResponseMetadata) error {
	return &ResourceUnavailableException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceUnavailableException) Code() string {
	return "ResourceUnavailableException"
}

// Message returns the exception's message.
func (s *ResourceUnavailableException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceUnavailableException) OrigErr() error {
	return nil
}

func (s *ResourceUnavailableException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceUnavailableException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceUnavailableException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Provides information for filtering a list of dominant language detection
// jobs. For more information, see the operation.
type SentimentDetectionJobFilter struct {
	_ struct{} `type:"structure"`

	// Filters on the name of the job.
	JobName *string `min:"1" type:"string"`

	// Filters the list of jobs based on job status. Returns only jobs with the
	// specified status.
	JobStatus *string `type:"string" enum:"JobStatus"`

	// Filters the list of jobs based on the time that the job was submitted for
	// processing. Returns only jobs submitted after the specified time. Jobs are
	// returned in descending order, newest to oldest.
	SubmitTimeAfter *time.Time `type:"timestamp"`

	// Filters the list of jobs based on the time that the job was submitted for
	// processing. Returns only jobs submitted before the specified time. Jobs are
	// returned in ascending order, oldest to newest.
	SubmitTimeBefore *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s SentimentDetectionJobFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SentimentDetectionJobFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SentimentDetectionJobFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SentimentDetectionJobFilter"}
	if s.JobName != nil && len(*s.JobName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobName sets the JobName field's value.
func (s *SentimentDetectionJobFilter) SetJobName(v string) *SentimentDetectionJobFilter {
	s.JobName = &v
	return s
}

// SetJobStatus sets the JobStatus field's value.
func (s *SentimentDetectionJobFilter) SetJobStatus(v string) *SentimentDetectionJobFilter {
	s.JobStatus = &v
	return s
}

// SetSubmitTimeAfter sets the SubmitTimeAfter field's value.
func (s *SentimentDetectionJobFilter) SetSubmitTimeAfter(v time.Time) *SentimentDetectionJobFilter {
	s.SubmitTimeAfter = &v
	return s
}

// SetSubmitTimeBefore sets the SubmitTimeBefore field's value.
func (s *SentimentDetectionJobFilter) SetSubmitTimeBefore(v time.Time) *SentimentDetectionJobFilter {
	s.SubmitTimeBefore = &v
	return s
}

// Provides information about a sentiment detection job.
type SentimentDetectionJobProperties struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) that gives Amazon Comprehend read access to
	// your input data.
	DataAccessRoleArn *string `min:"20" type:"string"`

	// The time that the sentiment detection job ended.
	EndTime *time.Time `type:"timestamp"`

	// The input data configuration that you supplied when you created the sentiment
	// detection job.
	InputDataConfig *InputDataConfig `type:"structure"`

	// The identifier assigned to the sentiment detection job.
	JobId *string `min:"1" type:"string"`

	// The name that you assigned to the sentiment detection job
	JobName *string `min:"1" type:"string"`

	// The current status of the sentiment detection job. If the status is FAILED,
	// the Messages field shows the reason for the failure.
	JobStatus *string `type:"string" enum:"JobStatus"`

	// The language code of the input documents.
	LanguageCode *string `type:"string" enum:"LanguageCode"`

	// A description of the status of a job.
	Message *string `type:"string"`

	// The output data configuration that you supplied when you created the sentiment
	// detection job.
	OutputDataConfig *OutputDataConfig `type:"structure"`

	// The time that the sentiment detection job was submitted for processing.
	SubmitTime *time.Time `type:"timestamp"`

	// ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses
	// to encrypt data on the storage volume attached to the ML compute instance(s)
	// that process the analysis job. The VolumeKmsKeyId can be either of the following
	// formats:
	//
	//    * KMS Key ID: "1234abcd-12ab-34cd-56ef-1234567890ab"
	//
	//    * Amazon Resource Name (ARN) of a KMS Key: "arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"
	VolumeKmsKeyId *string `type:"string"`

	// Configuration parameters for a private Virtual Private Cloud (VPC) containing
	// the resources you are using for your sentiment detection job. For more information,
	// see Amazon VPC (https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html).
	VpcConfig *VpcConfig `type:"structure"`
}

// String returns the string representation
func (s SentimentDetectionJobProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SentimentDetectionJobProperties) GoString() string {
	return s.String()
}

// SetDataAccessRoleArn sets the DataAccessRoleArn field's value.
func (s *SentimentDetectionJobProperties) SetDataAccessRoleArn(v string) *SentimentDetectionJobProperties {
	s.DataAccessRoleArn = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *SentimentDetectionJobProperties) SetEndTime(v time.Time) *SentimentDetectionJobProperties {
	s.EndTime = &v
	return s
}

// SetInputDataConfig sets the InputDataConfig field's value.
func (s *SentimentDetectionJobProperties) SetInputDataConfig(v *InputDataConfig) *SentimentDetectionJobProperties {
	s.InputDataConfig = v
	return s
}

// SetJobId sets the JobId field's value.
func (s *SentimentDetectionJobProperties) SetJobId(v string) *SentimentDetectionJobProperties {
	s.JobId = &v
	return s
}

// SetJobName sets the JobName field's value.
func (s *SentimentDetectionJobProperties) SetJobName(v string) *SentimentDetectionJobProperties {
	s.JobName = &v
	return s
}

// SetJobStatus sets the JobStatus field's value.
func (s *SentimentDetectionJobProperties) SetJobStatus(v string) *SentimentDetectionJobProperties {
	s.JobStatus = &v
	return s
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *SentimentDetectionJobProperties) SetLanguageCode(v string) *SentimentDetectionJobProperties {
	s.LanguageCode = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *SentimentDetectionJobProperties) SetMessage(v string) *SentimentDetectionJobProperties {
	s.Message = &v
	return s
}

// SetOutputDataConfig sets the OutputDataConfig field's value.
func (s *SentimentDetectionJobProperties) SetOutputDataConfig(v *OutputDataConfig) *SentimentDetectionJobProperties {
	s.OutputDataConfig = v
	return s
}

// SetSubmitTime sets the SubmitTime field's value.
func (s *SentimentDetectionJobProperties) SetSubmitTime(v time.Time) *SentimentDetectionJobProperties {
	s.SubmitTime = &v
	return s
}

// SetVolumeKmsKeyId sets the VolumeKmsKeyId field's value.
func (s *SentimentDetectionJobProperties) SetVolumeKmsKeyId(v string) *SentimentDetectionJobProperties {
	s.VolumeKmsKeyId = &v
	return s
}

// SetVpcConfig sets the VpcConfig field's value.
func (s *SentimentDetectionJobProperties) SetVpcConfig(v *VpcConfig) *SentimentDetectionJobProperties {
	s.VpcConfig = v
	return s
}

// Describes the level of confidence that Amazon Comprehend has in the accuracy
// of its detection of sentiments.
type SentimentScore struct {
	_ struct{} `type:"structure"`

	// The level of confidence that Amazon Comprehend has in the accuracy of its
	// detection of the MIXED sentiment.
	Mixed *float64 `type:"float"`

	// The level of confidence that Amazon Comprehend has in the accuracy of its
	// detection of the NEGATIVE sentiment.
	Negative *float64 `type:"float"`

	// The level of confidence that Amazon Comprehend has in the accuracy of its
	// detection of the NEUTRAL sentiment.
	Neutral *float64 `type:"float"`

	// The level of confidence that Amazon Comprehend has in the accuracy of its
	// detection of the POSITIVE sentiment.
	Positive *float64 `type:"float"`
}

// String returns the string representation
func (s SentimentScore) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SentimentScore) GoString() string {
	return s.String()
}

// SetMixed sets the Mixed field's value.
func (s *SentimentScore) SetMixed(v float64) *SentimentScore {
	s.Mixed = &v
	return s
}

// SetNegative sets the Negative field's value.
func (s *SentimentScore) SetNegative(v float64) *SentimentScore {
	s.Negative = &v
	return s
}

// SetNeutral sets the Neutral field's value.
func (s *SentimentScore) SetNeutral(v float64) *SentimentScore {
	s.Neutral = &v
	return s
}

// SetPositive sets the Positive field's value.
func (s *SentimentScore) SetPositive(v float64) *SentimentScore {
	s.Positive = &v
	return s
}

type StartDocumentClassificationJobInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the request. If you do not set the client request
	// token, Amazon Comprehend generates one.
	ClientRequestToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// The Amazon Resource Name (ARN) of the AWS Identity and Access Management
	// (IAM) role that grants Amazon Comprehend read access to your input data.
	//
	// DataAccessRoleArn is a required field
	DataAccessRoleArn *string `min:"20" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the document classifier to use to process
	// the job.
	//
	// DocumentClassifierArn is a required field
	DocumentClassifierArn *string `type:"string" required:"true"`

	// Specifies the format and location of the input data for the job.
	//
	// InputDataConfig is a required field
	InputDataConfig *InputDataConfig `type:"structure" required:"true"`

	// The identifier of the job.
	JobName *string `min:"1" type:"string"`

	// Specifies where to send the output files.
	//
	// OutputDataConfig is a required field
	OutputDataConfig *OutputDataConfig `type:"structure" required:"true"`

	// ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses
	// to encrypt data on the storage volume attached to the ML compute instance(s)
	// that process the analysis job. The VolumeKmsKeyId can be either of the following
	// formats:
	//
	//    * KMS Key ID: "1234abcd-12ab-34cd-56ef-1234567890ab"
	//
	//    * Amazon Resource Name (ARN) of a KMS Key: "arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"
	VolumeKmsKeyId *string `type:"string"`

	// Configuration parameters for an optional private Virtual Private Cloud (VPC)
	// containing the resources you are using for your document classification job.
	// For more information, see Amazon VPC (https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html).
	VpcConfig *VpcConfig `type:"structure"`
}

// String returns the string representation
func (s StartDocumentClassificationJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartDocumentClassificationJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartDocumentClassificationJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartDocumentClassificationJobInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.DataAccessRoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DataAccessRoleArn"))
	}
	if s.DataAccessRoleArn != nil && len(*s.DataAccessRoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("DataAccessRoleArn", 20))
	}
	if s.DocumentClassifierArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DocumentClassifierArn"))
	}
	if s.InputDataConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("InputDataConfig"))
	}
	if s.JobName != nil && len(*s.JobName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobName", 1))
	}
	if s.OutputDataConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("OutputDataConfig"))
	}
	if s.InputDataConfig != nil {
		if err := s.InputDataConfig.Validate(); err != nil {
			invalidParams.AddNested("InputDataConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.OutputDataConfig != nil {
		if err := s.OutputDataConfig.Validate(); err != nil {
			invalidParams.AddNested("OutputDataConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.VpcConfig != nil {
		if err := s.VpcConfig.Validate(); err != nil {
			invalidParams.AddNested("VpcConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *StartDocumentClassificationJobInput) SetClientRequestToken(v string) *StartDocumentClassificationJobInput {
	s.ClientRequestToken = &v
	return s
}

// SetDataAccessRoleArn sets the DataAccessRoleArn field's value.
func (s *StartDocumentClassificationJobInput) SetDataAccessRoleArn(v string) *StartDocumentClassificationJobInput {
	s.DataAccessRoleArn = &v
	return s
}

// SetDocumentClassifierArn sets the DocumentClassifierArn field's value.
func (s *StartDocumentClassificationJobInput) SetDocumentClassifierArn(v string) *StartDocumentClassificationJobInput {
	s.DocumentClassifierArn = &v
	return s
}

// SetInputDataConfig sets the InputDataConfig field's value.
func (s *StartDocumentClassificationJobInput) SetInputDataConfig(v *InputDataConfig) *StartDocumentClassificationJobInput {
	s.InputDataConfig = v
	return s
}

// SetJobName sets the JobName field's value.
func (s *StartDocumentClassificationJobInput) SetJobName(v string) *StartDocumentClassificationJobInput {
	s.JobName = &v
	return s
}

// SetOutputDataConfig sets the OutputDataConfig field's value.
func (s *StartDocumentClassificationJobInput) SetOutputDataConfig(v *OutputDataConfig) *StartDocumentClassificationJobInput {
	s.OutputDataConfig = v
	return s
}

// SetVolumeKmsKeyId sets the VolumeKmsKeyId field's value.
func (s *StartDocumentClassificationJobInput) SetVolumeKmsKeyId(v string) *StartDocumentClassificationJobInput {
	s.VolumeKmsKeyId = &v
	return s
}

// SetVpcConfig sets the VpcConfig field's value.
func (s *StartDocumentClassificationJobInput) SetVpcConfig(v *VpcConfig) *StartDocumentClassificationJobInput {
	s.VpcConfig = v
	return s
}

type StartDocumentClassificationJobOutput struct {
	_ struct{} `type:"structure"`

	// The identifier generated for the job. To get the status of the job, use this
	// identifier with the operation.
	JobId *string `min:"1" type:"string"`

	// The status of the job:
	//
	//    * SUBMITTED - The job has been received and queued for processing.
	//
	//    * IN_PROGRESS - Amazon Comprehend is processing the job.
	//
	//    * COMPLETED - The job was successfully completed and the output is available.
	//
	//    * FAILED - The job did not complete. For details, use the operation.
	//
	//    * STOP_REQUESTED - Amazon Comprehend has received a stop request for the
	//    job and is processing the request.
	//
	//    * STOPPED - The job was successfully stopped without completing.
	JobStatus *string `type:"string" enum:"JobStatus"`
}

// String returns the string representation
func (s StartDocumentClassificationJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartDocumentClassificationJobOutput) GoString() string {
	return s.String()
}

// SetJobId sets the JobId field's value.
func (s *StartDocumentClassificationJobOutput) SetJobId(v string) *StartDocumentClassificationJobOutput {
	s.JobId = &v
	return s
}

// SetJobStatus sets the JobStatus field's value.
func (s *StartDocumentClassificationJobOutput) SetJobStatus(v string) *StartDocumentClassificationJobOutput {
	s.JobStatus = &v
	return s
}

type StartDominantLanguageDetectionJobInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the request. If you do not set the client request
	// token, Amazon Comprehend generates one.
	ClientRequestToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// The Amazon Resource Name (ARN) of the AWS Identity and Access Management
	// (IAM) role that grants Amazon Comprehend read access to your input data.
	// For more information, see https://docs.aws.amazon.com/comprehend/latest/dg/access-control-managing-permissions.html#auth-role-permissions
	// (https://docs.aws.amazon.com/comprehend/latest/dg/access-control-managing-permissions.html#auth-role-permissions).
	//
	// DataAccessRoleArn is a required field
	DataAccessRoleArn *string `min:"20" type:"string" required:"true"`

	// Specifies the format and location of the input data for the job.
	//
	// InputDataConfig is a required field
	InputDataConfig *InputDataConfig `type:"structure" required:"true"`

	// An identifier for the job.
	JobName *string `min:"1" type:"string"`

	// Specifies where to send the output files.
	//
	// OutputDataConfig is a required field
	OutputDataConfig *OutputDataConfig `type:"structure" required:"true"`

	// ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses
	// to encrypt data on the storage volume attached to the ML compute instance(s)
	// that process the analysis job. The VolumeKmsKeyId can be either of the following
	// formats:
	//
	//    * KMS Key ID: "1234abcd-12ab-34cd-56ef-1234567890ab"
	//
	//    * Amazon Resource Name (ARN) of a KMS Key: "arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"
	VolumeKmsKeyId *string `type:"string"`

	// Configuration parameters for an optional private Virtual Private Cloud (VPC)
	// containing the resources you are using for your dominant language detection
	// job. For more information, see Amazon VPC (https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html).
	VpcConfig *VpcConfig `type:"structure"`
}

// String returns the string representation
func (s StartDominantLanguageDetectionJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartDominantLanguageDetectionJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartDominantLanguageDetectionJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartDominantLanguageDetectionJobInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.DataAccessRoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DataAccessRoleArn"))
	}
	if s.DataAccessRoleArn != nil && len(*s.DataAccessRoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("DataAccessRoleArn", 20))
	}
	if s.InputDataConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("InputDataConfig"))
	}
	if s.JobName != nil && len(*s.JobName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobName", 1))
	}
	if s.OutputDataConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("OutputDataConfig"))
	}
	if s.InputDataConfig != nil {
		if err := s.InputDataConfig.Validate(); err != nil {
			invalidParams.AddNested("InputDataConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.OutputDataConfig != nil {
		if err := s.OutputDataConfig.Validate(); err != nil {
			invalidParams.AddNested("OutputDataConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.VpcConfig != nil {
		if err := s.VpcConfig.Validate(); err != nil {
			invalidParams.AddNested("VpcConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *StartDominantLanguageDetectionJobInput) SetClientRequestToken(v string) *StartDominantLanguageDetectionJobInput {
	s.ClientRequestToken = &v
	return s
}

// SetDataAccessRoleArn sets the DataAccessRoleArn field's value.
func (s *StartDominantLanguageDetectionJobInput) SetDataAccessRoleArn(v string) *StartDominantLanguageDetectionJobInput {
	s.DataAccessRoleArn = &v
	return s
}

// SetInputDataConfig sets the InputDataConfig field's value.
func (s *StartDominantLanguageDetectionJobInput) SetInputDataConfig(v *InputDataConfig) *StartDominantLanguageDetectionJobInput {
	s.InputDataConfig = v
	return s
}

// SetJobName sets the JobName field's value.
func (s *StartDominantLanguageDetectionJobInput) SetJobName(v string) *StartDominantLanguageDetectionJobInput {
	s.JobName = &v
	return s
}

// SetOutputDataConfig sets the OutputDataConfig field's value.
func (s *StartDominantLanguageDetectionJobInput) SetOutputDataConfig(v *OutputDataConfig) *StartDominantLanguageDetectionJobInput {
	s.OutputDataConfig = v
	return s
}

// SetVolumeKmsKeyId sets the VolumeKmsKeyId field's value.
func (s *StartDominantLanguageDetectionJobInput) SetVolumeKmsKeyId(v string) *StartDominantLanguageDetectionJobInput {
	s.VolumeKmsKeyId = &v
	return s
}

// SetVpcConfig sets the VpcConfig field's value.
func (s *StartDominantLanguageDetectionJobInput) SetVpcConfig(v *VpcConfig) *StartDominantLanguageDetectionJobInput {
	s.VpcConfig = v
	return s
}

type StartDominantLanguageDetectionJobOutput struct {
	_ struct{} `type:"structure"`

	// The identifier generated for the job. To get the status of a job, use this
	// identifier with the operation.
	JobId *string `min:"1" type:"string"`

	// The status of the job.
	//
	//    * SUBMITTED - The job has been received and is queued for processing.
	//
	//    * IN_PROGRESS - Amazon Comprehend is processing the job.
	//
	//    * COMPLETED - The job was successfully completed and the output is available.
	//
	//    * FAILED - The job did not complete. To get details, use the operation.
	JobStatus *string `type:"string" enum:"JobStatus"`
}

// String returns the string representation
func (s StartDominantLanguageDetectionJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartDominantLanguageDetectionJobOutput) GoString() string {
	return s.String()
}

// SetJobId sets the JobId field's value.
func (s *StartDominantLanguageDetectionJobOutput) SetJobId(v string) *StartDominantLanguageDetectionJobOutput {
	s.JobId = &v
	return s
}

// SetJobStatus sets the JobStatus field's value.
func (s *StartDominantLanguageDetectionJobOutput) SetJobStatus(v string) *StartDominantLanguageDetectionJobOutput {
	s.JobStatus = &v
	return s
}

type StartEntitiesDetectionJobInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the request. If you don't set the client request
	// token, Amazon Comprehend generates one.
	ClientRequestToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// The Amazon Resource Name (ARN) of the AWS Identity and Access Management
	// (IAM) role that grants Amazon Comprehend read access to your input data.
	// For more information, see https://docs.aws.amazon.com/comprehend/latest/dg/access-control-managing-permissions.html#auth-role-permissions
	// (https://docs.aws.amazon.com/comprehend/latest/dg/access-control-managing-permissions.html#auth-role-permissions).
	//
	// DataAccessRoleArn is a required field
	DataAccessRoleArn *string `min:"20" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) that identifies the specific entity recognizer
	// to be used by the StartEntitiesDetectionJob. This ARN is optional and is
	// only used for a custom entity recognition job.
	EntityRecognizerArn *string `type:"string"`

	// Specifies the format and location of the input data for the job.
	//
	// InputDataConfig is a required field
	InputDataConfig *InputDataConfig `type:"structure" required:"true"`

	// The identifier of the job.
	JobName *string `min:"1" type:"string"`

	// The language of the input documents. All documents must be in the same language.
	// You can specify any of the languages supported by Amazon Comprehend. If custom
	// entities recognition is used, this parameter is ignored and the language
	// used for training the model is used instead.
	//
	// LanguageCode is a required field
	LanguageCode *string `type:"string" required:"true" enum:"LanguageCode"`

	// Specifies where to send the output files.
	//
	// OutputDataConfig is a required field
	OutputDataConfig *OutputDataConfig `type:"structure" required:"true"`

	// ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses
	// to encrypt data on the storage volume attached to the ML compute instance(s)
	// that process the analysis job. The VolumeKmsKeyId can be either of the following
	// formats:
	//
	//    * KMS Key ID: "1234abcd-12ab-34cd-56ef-1234567890ab"
	//
	//    * Amazon Resource Name (ARN) of a KMS Key: "arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"
	VolumeKmsKeyId *string `type:"string"`

	// Configuration parameters for an optional private Virtual Private Cloud (VPC)
	// containing the resources you are using for your entity detection job. For
	// more information, see Amazon VPC (https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html).
	VpcConfig *VpcConfig `type:"structure"`
}

// String returns the string representation
func (s StartEntitiesDetectionJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartEntitiesDetectionJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartEntitiesDetectionJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartEntitiesDetectionJobInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.DataAccessRoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DataAccessRoleArn"))
	}
	if s.DataAccessRoleArn != nil && len(*s.DataAccessRoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("DataAccessRoleArn", 20))
	}
	if s.InputDataConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("InputDataConfig"))
	}
	if s.JobName != nil && len(*s.JobName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobName", 1))
	}
	if s.LanguageCode == nil {
		invalidParams.Add(request.NewErrParamRequired("LanguageCode"))
	}
	if s.OutputDataConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("OutputDataConfig"))
	}
	if s.InputDataConfig != nil {
		if err := s.InputDataConfig.Validate(); err != nil {
			invalidParams.AddNested("InputDataConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.OutputDataConfig != nil {
		if err := s.OutputDataConfig.Validate(); err != nil {
			invalidParams.AddNested("OutputDataConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.VpcConfig != nil {
		if err := s.VpcConfig.Validate(); err != nil {
			invalidParams.AddNested("VpcConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *StartEntitiesDetectionJobInput) SetClientRequestToken(v string) *StartEntitiesDetectionJobInput {
	s.ClientRequestToken = &v
	return s
}

// SetDataAccessRoleArn sets the DataAccessRoleArn field's value.
func (s *StartEntitiesDetectionJobInput) SetDataAccessRoleArn(v string) *StartEntitiesDetectionJobInput {
	s.DataAccessRoleArn = &v
	return s
}

// SetEntityRecognizerArn sets the EntityRecognizerArn field's value.
func (s *StartEntitiesDetectionJobInput) SetEntityRecognizerArn(v string) *StartEntitiesDetectionJobInput {
	s.EntityRecognizerArn = &v
	return s
}

// SetInputDataConfig sets the InputDataConfig field's value.
func (s *StartEntitiesDetectionJobInput) SetInputDataConfig(v *InputDataConfig) *StartEntitiesDetectionJobInput {
	s.InputDataConfig = v
	return s
}

// SetJobName sets the JobName field's value.
func (s *StartEntitiesDetectionJobInput) SetJobName(v string) *StartEntitiesDetectionJobInput {
	s.JobName = &v
	return s
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *StartEntitiesDetectionJobInput) SetLanguageCode(v string) *StartEntitiesDetectionJobInput {
	s.LanguageCode = &v
	return s
}

// SetOutputDataConfig sets the OutputDataConfig field's value.
func (s *StartEntitiesDetectionJobInput) SetOutputDataConfig(v *OutputDataConfig) *StartEntitiesDetectionJobInput {
	s.OutputDataConfig = v
	return s
}

// SetVolumeKmsKeyId sets the VolumeKmsKeyId field's value.
func (s *StartEntitiesDetectionJobInput) SetVolumeKmsKeyId(v string) *StartEntitiesDetectionJobInput {
	s.VolumeKmsKeyId = &v
	return s
}

// SetVpcConfig sets the VpcConfig field's value.
func (s *StartEntitiesDetectionJobInput) SetVpcConfig(v *VpcConfig) *StartEntitiesDetectionJobInput {
	s.VpcConfig = v
	return s
}

type StartEntitiesDetectionJobOutput struct {
	_ struct{} `type:"structure"`

	// The identifier generated for the job. To get the status of job, use this
	// identifier with the operation.
	JobId *string `min:"1" type:"string"`

	// The status of the job.
	//
	//    * SUBMITTED - The job has been received and is queued for processing.
	//
	//    * IN_PROGRESS - Amazon Comprehend is processing the job.
	//
	//    * COMPLETED - The job was successfully completed and the output is available.
	//
	//    * FAILED - The job did not complete. To get details, use the operation.
	//
	//    * STOP_REQUESTED - Amazon Comprehend has received a stop request for the
	//    job and is processing the request.
	//
	//    * STOPPED - The job was successfully stopped without completing.
	JobStatus *string `type:"string" enum:"JobStatus"`
}

// String returns the string representation
func (s StartEntitiesDetectionJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartEntitiesDetectionJobOutput) GoString() string {
	return s.String()
}

// SetJobId sets the JobId field's value.
func (s *StartEntitiesDetectionJobOutput) SetJobId(v string) *StartEntitiesDetectionJobOutput {
	s.JobId = &v
	return s
}

// SetJobStatus sets the JobStatus field's value.
func (s *StartEntitiesDetectionJobOutput) SetJobStatus(v string) *StartEntitiesDetectionJobOutput {
	s.JobStatus = &v
	return s
}

type StartKeyPhrasesDetectionJobInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the request. If you don't set the client request
	// token, Amazon Comprehend generates one.
	ClientRequestToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// The Amazon Resource Name (ARN) of the AWS Identity and Access Management
	// (IAM) role that grants Amazon Comprehend read access to your input data.
	// For more information, see https://docs.aws.amazon.com/comprehend/latest/dg/access-control-managing-permissions.html#auth-role-permissions
	// (https://docs.aws.amazon.com/comprehend/latest/dg/access-control-managing-permissions.html#auth-role-permissions).
	//
	// DataAccessRoleArn is a required field
	DataAccessRoleArn *string `min:"20" type:"string" required:"true"`

	// Specifies the format and location of the input data for the job.
	//
	// InputDataConfig is a required field
	InputDataConfig *InputDataConfig `type:"structure" required:"true"`

	// The identifier of the job.
	JobName *string `min:"1" type:"string"`

	// The language of the input documents. You can specify any of the primary languages
	// supported by Amazon Comprehend. All documents must be in the same language.
	//
	// LanguageCode is a required field
	LanguageCode *string `type:"string" required:"true" enum:"LanguageCode"`

	// Specifies where to send the output files.
	//
	// OutputDataConfig is a required field
	OutputDataConfig *OutputDataConfig `type:"structure" required:"true"`

	// ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses
	// to encrypt data on the storage volume attached to the ML compute instance(s)
	// that process the analysis job. The VolumeKmsKeyId can be either of the following
	// formats:
	//
	//    * KMS Key ID: "1234abcd-12ab-34cd-56ef-1234567890ab"
	//
	//    * Amazon Resource Name (ARN) of a KMS Key: "arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"
	VolumeKmsKeyId *string `type:"string"`

	// Configuration parameters for an optional private Virtual Private Cloud (VPC)
	// containing the resources you are using for your key phrases detection job.
	// For more information, see Amazon VPC (https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html).
	VpcConfig *VpcConfig `type:"structure"`
}

// String returns the string representation
func (s StartKeyPhrasesDetectionJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartKeyPhrasesDetectionJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartKeyPhrasesDetectionJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartKeyPhrasesDetectionJobInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.DataAccessRoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DataAccessRoleArn"))
	}
	if s.DataAccessRoleArn != nil && len(*s.DataAccessRoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("DataAccessRoleArn", 20))
	}
	if s.InputDataConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("InputDataConfig"))
	}
	if s.JobName != nil && len(*s.JobName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobName", 1))
	}
	if s.LanguageCode == nil {
		invalidParams.Add(request.NewErrParamRequired("LanguageCode"))
	}
	if s.OutputDataConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("OutputDataConfig"))
	}
	if s.InputDataConfig != nil {
		if err := s.InputDataConfig.Validate(); err != nil {
			invalidParams.AddNested("InputDataConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.OutputDataConfig != nil {
		if err := s.OutputDataConfig.Validate(); err != nil {
			invalidParams.AddNested("OutputDataConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.VpcConfig != nil {
		if err := s.VpcConfig.Validate(); err != nil {
			invalidParams.AddNested("VpcConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *StartKeyPhrasesDetectionJobInput) SetClientRequestToken(v string) *StartKeyPhrasesDetectionJobInput {
	s.ClientRequestToken = &v
	return s
}

// SetDataAccessRoleArn sets the DataAccessRoleArn field's value.
func (s *StartKeyPhrasesDetectionJobInput) SetDataAccessRoleArn(v string) *StartKeyPhrasesDetectionJobInput {
	s.DataAccessRoleArn = &v
	return s
}

// SetInputDataConfig sets the InputDataConfig field's value.
func (s *StartKeyPhrasesDetectionJobInput) SetInputDataConfig(v *InputDataConfig) *StartKeyPhrasesDetectionJobInput {
	s.InputDataConfig = v
	return s
}

// SetJobName sets the JobName field's value.
func (s *StartKeyPhrasesDetectionJobInput) SetJobName(v string) *StartKeyPhrasesDetectionJobInput {
	s.JobName = &v
	return s
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *StartKeyPhrasesDetectionJobInput) SetLanguageCode(v string) *StartKeyPhrasesDetectionJobInput {
	s.LanguageCode = &v
	return s
}

// SetOutputDataConfig sets the OutputDataConfig field's value.
func (s *StartKeyPhrasesDetectionJobInput) SetOutputDataConfig(v *OutputDataConfig) *StartKeyPhrasesDetectionJobInput {
	s.OutputDataConfig = v
	return s
}

// SetVolumeKmsKeyId sets the VolumeKmsKeyId field's value.
func (s *StartKeyPhrasesDetectionJobInput) SetVolumeKmsKeyId(v string) *StartKeyPhrasesDetectionJobInput {
	s.VolumeKmsKeyId = &v
	return s
}

// SetVpcConfig sets the VpcConfig field's value.
func (s *StartKeyPhrasesDetectionJobInput) SetVpcConfig(v *VpcConfig) *StartKeyPhrasesDetectionJobInput {
	s.VpcConfig = v
	return s
}

type StartKeyPhrasesDetectionJobOutput struct {
	_ struct{} `type:"structure"`

	// The identifier generated for the job. To get the status of a job, use this
	// identifier with the operation.
	JobId *string `min:"1" type:"string"`

	// The status of the job.
	//
	//    * SUBMITTED - The job has been received and is queued for processing.
	//
	//    * IN_PROGRESS - Amazon Comprehend is processing the job.
	//
	//    * COMPLETED - The job was successfully completed and the output is available.
	//
	//    * FAILED - The job did not complete. To get details, use the operation.
	JobStatus *string `type:"string" enum:"JobStatus"`
}

// String returns the string representation
func (s StartKeyPhrasesDetectionJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartKeyPhrasesDetectionJobOutput) GoString() string {
	return s.String()
}

// SetJobId sets the JobId field's value.
func (s *StartKeyPhrasesDetectionJobOutput) SetJobId(v string) *StartKeyPhrasesDetectionJobOutput {
	s.JobId = &v
	return s
}

// SetJobStatus sets the JobStatus field's value.
func (s *StartKeyPhrasesDetectionJobOutput) SetJobStatus(v string) *StartKeyPhrasesDetectionJobOutput {
	s.JobStatus = &v
	return s
}

type StartPiiEntitiesDetectionJobInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the request. If you don't set the client request
	// token, Amazon Comprehend generates one.
	ClientRequestToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// The Amazon Resource Name (ARN) of the AWS Identity and Access Management
	// (IAM) role that grants Amazon Comprehend read access to your input data.
	//
	// DataAccessRoleArn is a required field
	DataAccessRoleArn *string `min:"20" type:"string" required:"true"`

	// The input properties for a PII entities detection job.
	//
	// InputDataConfig is a required field
	InputDataConfig *InputDataConfig `type:"structure" required:"true"`

	// The identifier of the job.
	JobName *string `min:"1" type:"string"`

	// The language of the input documents.
	//
	// LanguageCode is a required field
	LanguageCode *string `type:"string" required:"true" enum:"LanguageCode"`

	// Specifies whether the output provides the locations (offsets) of PII entities
	// or a file in which PII entities are redacted.
	//
	// Mode is a required field
	Mode *string `type:"string" required:"true" enum:"PiiEntitiesDetectionMode"`

	// Provides conﬁguration parameters for the output of PII entity detection
	// jobs.
	//
	// OutputDataConfig is a required field
	OutputDataConfig *OutputDataConfig `type:"structure" required:"true"`

	// Provides configuration parameters for PII entity redaction.
	//
	// This parameter is required if you set the Mode parameter to ONLY_REDACTION.
	// In that case, you must provide a RedactionConfig definition that includes
	// the PiiEntityTypes parameter.
	RedactionConfig *RedactionConfig `type:"structure"`
}

// String returns the string representation
func (s StartPiiEntitiesDetectionJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartPiiEntitiesDetectionJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartPiiEntitiesDetectionJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartPiiEntitiesDetectionJobInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.DataAccessRoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DataAccessRoleArn"))
	}
	if s.DataAccessRoleArn != nil && len(*s.DataAccessRoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("DataAccessRoleArn", 20))
	}
	if s.InputDataConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("InputDataConfig"))
	}
	if s.JobName != nil && len(*s.JobName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobName", 1))
	}
	if s.LanguageCode == nil {
		invalidParams.Add(request.NewErrParamRequired("LanguageCode"))
	}
	if s.Mode == nil {
		invalidParams.Add(request.NewErrParamRequired("Mode"))
	}
	if s.OutputDataConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("OutputDataConfig"))
	}
	if s.InputDataConfig != nil {
		if err := s.InputDataConfig.Validate(); err != nil {
			invalidParams.AddNested("InputDataConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.OutputDataConfig != nil {
		if err := s.OutputDataConfig.Validate(); err != nil {
			invalidParams.AddNested("OutputDataConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.RedactionConfig != nil {
		if err := s.RedactionConfig.Validate(); err != nil {
			invalidParams.AddNested("RedactionConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *StartPiiEntitiesDetectionJobInput) SetClientRequestToken(v string) *StartPiiEntitiesDetectionJobInput {
	s.ClientRequestToken = &v
	return s
}

// SetDataAccessRoleArn sets the DataAccessRoleArn field's value.
func (s *StartPiiEntitiesDetectionJobInput) SetDataAccessRoleArn(v string) *StartPiiEntitiesDetectionJobInput {
	s.DataAccessRoleArn = &v
	return s
}

// SetInputDataConfig sets the InputDataConfig field's value.
func (s *StartPiiEntitiesDetectionJobInput) SetInputDataConfig(v *InputDataConfig) *StartPiiEntitiesDetectionJobInput {
	s.InputDataConfig = v
	return s
}

// SetJobName sets the JobName field's value.
func (s *StartPiiEntitiesDetectionJobInput) SetJobName(v string) *StartPiiEntitiesDetectionJobInput {
	s.JobName = &v
	return s
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *StartPiiEntitiesDetectionJobInput) SetLanguageCode(v string) *StartPiiEntitiesDetectionJobInput {
	s.LanguageCode = &v
	return s
}

// SetMode sets the Mode field's value.
func (s *StartPiiEntitiesDetectionJobInput) SetMode(v string) *StartPiiEntitiesDetectionJobInput {
	s.Mode = &v
	return s
}

// SetOutputDataConfig sets the OutputDataConfig field's value.
func (s *StartPiiEntitiesDetectionJobInput) SetOutputDataConfig(v *OutputDataConfig) *StartPiiEntitiesDetectionJobInput {
	s.OutputDataConfig = v
	return s
}

// SetRedactionConfig sets the RedactionConfig field's value.
func (s *StartPiiEntitiesDetectionJobInput) SetRedactionConfig(v *RedactionConfig) *StartPiiEntitiesDetectionJobInput {
	s.RedactionConfig = v
	return s
}

type StartPiiEntitiesDetectionJobOutput struct {
	_ struct{} `type:"structure"`

	// The identifier generated for the job.
	JobId *string `min:"1" type:"string"`

	// The status of the job.
	JobStatus *string `type:"string" enum:"JobStatus"`
}

// String returns the string representation
func (s StartPiiEntitiesDetectionJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartPiiEntitiesDetectionJobOutput) GoString() string {
	return s.String()
}

// SetJobId sets the JobId field's value.
func (s *StartPiiEntitiesDetectionJobOutput) SetJobId(v string) *StartPiiEntitiesDetectionJobOutput {
	s.JobId = &v
	return s
}

// SetJobStatus sets the JobStatus field's value.
func (s *StartPiiEntitiesDetectionJobOutput) SetJobStatus(v string) *StartPiiEntitiesDetectionJobOutput {
	s.JobStatus = &v
	return s
}

type StartSentimentDetectionJobInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the request. If you don't set the client request
	// token, Amazon Comprehend generates one.
	ClientRequestToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// The Amazon Resource Name (ARN) of the AWS Identity and Access Management
	// (IAM) role that grants Amazon Comprehend read access to your input data.
	// For more information, see https://docs.aws.amazon.com/comprehend/latest/dg/access-control-managing-permissions.html#auth-role-permissions
	// (https://docs.aws.amazon.com/comprehend/latest/dg/access-control-managing-permissions.html#auth-role-permissions).
	//
	// DataAccessRoleArn is a required field
	DataAccessRoleArn *string `min:"20" type:"string" required:"true"`

	// Specifies the format and location of the input data for the job.
	//
	// InputDataConfig is a required field
	InputDataConfig *InputDataConfig `type:"structure" required:"true"`

	// The identifier of the job.
	JobName *string `min:"1" type:"string"`

	// The language of the input documents. You can specify any of the primary languages
	// supported by Amazon Comprehend. All documents must be in the same language.
	//
	// LanguageCode is a required field
	LanguageCode *string `type:"string" required:"true" enum:"LanguageCode"`

	// Specifies where to send the output files.
	//
	// OutputDataConfig is a required field
	OutputDataConfig *OutputDataConfig `type:"structure" required:"true"`

	// ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses
	// to encrypt data on the storage volume attached to the ML compute instance(s)
	// that process the analysis job. The VolumeKmsKeyId can be either of the following
	// formats:
	//
	//    * KMS Key ID: "1234abcd-12ab-34cd-56ef-1234567890ab"
	//
	//    * Amazon Resource Name (ARN) of a KMS Key: "arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"
	VolumeKmsKeyId *string `type:"string"`

	// Configuration parameters for an optional private Virtual Private Cloud (VPC)
	// containing the resources you are using for your sentiment detection job.
	// For more information, see Amazon VPC (https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html).
	VpcConfig *VpcConfig `type:"structure"`
}

// String returns the string representation
func (s StartSentimentDetectionJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartSentimentDetectionJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartSentimentDetectionJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartSentimentDetectionJobInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.DataAccessRoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DataAccessRoleArn"))
	}
	if s.DataAccessRoleArn != nil && len(*s.DataAccessRoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("DataAccessRoleArn", 20))
	}
	if s.InputDataConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("InputDataConfig"))
	}
	if s.JobName != nil && len(*s.JobName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobName", 1))
	}
	if s.LanguageCode == nil {
		invalidParams.Add(request.NewErrParamRequired("LanguageCode"))
	}
	if s.OutputDataConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("OutputDataConfig"))
	}
	if s.InputDataConfig != nil {
		if err := s.InputDataConfig.Validate(); err != nil {
			invalidParams.AddNested("InputDataConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.OutputDataConfig != nil {
		if err := s.OutputDataConfig.Validate(); err != nil {
			invalidParams.AddNested("OutputDataConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.VpcConfig != nil {
		if err := s.VpcConfig.Validate(); err != nil {
			invalidParams.AddNested("VpcConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *StartSentimentDetectionJobInput) SetClientRequestToken(v string) *StartSentimentDetectionJobInput {
	s.ClientRequestToken = &v
	return s
}

// SetDataAccessRoleArn sets the DataAccessRoleArn field's value.
func (s *StartSentimentDetectionJobInput) SetDataAccessRoleArn(v string) *StartSentimentDetectionJobInput {
	s.DataAccessRoleArn = &v
	return s
}

// SetInputDataConfig sets the InputDataConfig field's value.
func (s *StartSentimentDetectionJobInput) SetInputDataConfig(v *InputDataConfig) *StartSentimentDetectionJobInput {
	s.InputDataConfig = v
	return s
}

// SetJobName sets the JobName field's value.
func (s *StartSentimentDetectionJobInput) SetJobName(v string) *StartSentimentDetectionJobInput {
	s.JobName = &v
	return s
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *StartSentimentDetectionJobInput) SetLanguageCode(v string) *StartSentimentDetectionJobInput {
	s.LanguageCode = &v
	return s
}

// SetOutputDataConfig sets the OutputDataConfig field's value.
func (s *StartSentimentDetectionJobInput) SetOutputDataConfig(v *OutputDataConfig) *StartSentimentDetectionJobInput {
	s.OutputDataConfig = v
	return s
}

// SetVolumeKmsKeyId sets the VolumeKmsKeyId field's value.
func (s *StartSentimentDetectionJobInput) SetVolumeKmsKeyId(v string) *StartSentimentDetectionJobInput {
	s.VolumeKmsKeyId = &v
	return s
}

// SetVpcConfig sets the VpcConfig field's value.
func (s *StartSentimentDetectionJobInput) SetVpcConfig(v *VpcConfig) *StartSentimentDetectionJobInput {
	s.VpcConfig = v
	return s
}

type StartSentimentDetectionJobOutput struct {
	_ struct{} `type:"structure"`

	// The identifier generated for the job. To get the status of a job, use this
	// identifier with the operation.
	JobId *string `min:"1" type:"string"`

	// The status of the job.
	//
	//    * SUBMITTED - The job has been received and is queued for processing.
	//
	//    * IN_PROGRESS - Amazon Comprehend is processing the job.
	//
	//    * COMPLETED - The job was successfully completed and the output is available.
	//
	//    * FAILED - The job did not complete. To get details, use the operation.
	JobStatus *string `type:"string" enum:"JobStatus"`
}

// String returns the string representation
func (s StartSentimentDetectionJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartSentimentDetectionJobOutput) GoString() string {
	return s.String()
}

// SetJobId sets the JobId field's value.
func (s *StartSentimentDetectionJobOutput) SetJobId(v string) *StartSentimentDetectionJobOutput {
	s.JobId = &v
	return s
}

// SetJobStatus sets the JobStatus field's value.
func (s *StartSentimentDetectionJobOutput) SetJobStatus(v string) *StartSentimentDetectionJobOutput {
	s.JobStatus = &v
	return s
}

type StartTopicsDetectionJobInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the request. If you do not set the client request
	// token, Amazon Comprehend generates one.
	ClientRequestToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// The Amazon Resource Name (ARN) of the AWS Identity and Access Management
	// (IAM) role that grants Amazon Comprehend read access to your input data.
	// For more information, see https://docs.aws.amazon.com/comprehend/latest/dg/access-control-managing-permissions.html#auth-role-permissions
	// (https://docs.aws.amazon.com/comprehend/latest/dg/access-control-managing-permissions.html#auth-role-permissions).
	//
	// DataAccessRoleArn is a required field
	DataAccessRoleArn *string `min:"20" type:"string" required:"true"`

	// Specifies the format and location of the input data for the job.
	//
	// InputDataConfig is a required field
	InputDataConfig *InputDataConfig `type:"structure" required:"true"`

	// The identifier of the job.
	JobName *string `min:"1" type:"string"`

	// The number of topics to detect.
	NumberOfTopics *int64 `min:"1" type:"integer"`

	// Specifies where to send the output files. The output is a compressed archive
	// with two files, topic-terms.csv that lists the terms associated with each
	// topic, and doc-topics.csv that lists the documents associated with each topic
	//
	// OutputDataConfig is a required field
	OutputDataConfig *OutputDataConfig `type:"structure" required:"true"`

	// ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses
	// to encrypt data on the storage volume attached to the ML compute instance(s)
	// that process the analysis job. The VolumeKmsKeyId can be either of the following
	// formats:
	//
	//    * KMS Key ID: "1234abcd-12ab-34cd-56ef-1234567890ab"
	//
	//    * Amazon Resource Name (ARN) of a KMS Key: "arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"
	VolumeKmsKeyId *string `type:"string"`

	// Configuration parameters for an optional private Virtual Private Cloud (VPC)
	// containing the resources you are using for your topic detection job. For
	// more information, see Amazon VPC (https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html).
	VpcConfig *VpcConfig `type:"structure"`
}

// String returns the string representation
func (s StartTopicsDetectionJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartTopicsDetectionJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartTopicsDetectionJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartTopicsDetectionJobInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.DataAccessRoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DataAccessRoleArn"))
	}
	if s.DataAccessRoleArn != nil && len(*s.DataAccessRoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("DataAccessRoleArn", 20))
	}
	if s.InputDataConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("InputDataConfig"))
	}
	if s.JobName != nil && len(*s.JobName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobName", 1))
	}
	if s.NumberOfTopics != nil && *s.NumberOfTopics < 1 {
		invalidParams.Add(request.NewErrParamMinValue("NumberOfTopics", 1))
	}
	if s.OutputDataConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("OutputDataConfig"))
	}
	if s.InputDataConfig != nil {
		if err := s.InputDataConfig.Validate(); err != nil {
			invalidParams.AddNested("InputDataConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.OutputDataConfig != nil {
		if err := s.OutputDataConfig.Validate(); err != nil {
			invalidParams.AddNested("OutputDataConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.VpcConfig != nil {
		if err := s.VpcConfig.Validate(); err != nil {
			invalidParams.AddNested("VpcConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *StartTopicsDetectionJobInput) SetClientRequestToken(v string) *StartTopicsDetectionJobInput {
	s.ClientRequestToken = &v
	return s
}

// SetDataAccessRoleArn sets the DataAccessRoleArn field's value.
func (s *StartTopicsDetectionJobInput) SetDataAccessRoleArn(v string) *StartTopicsDetectionJobInput {
	s.DataAccessRoleArn = &v
	return s
}

// SetInputDataConfig sets the InputDataConfig field's value.
func (s *StartTopicsDetectionJobInput) SetInputDataConfig(v *InputDataConfig) *StartTopicsDetectionJobInput {
	s.InputDataConfig = v
	return s
}

// SetJobName sets the JobName field's value.
func (s *StartTopicsDetectionJobInput) SetJobName(v string) *StartTopicsDetectionJobInput {
	s.JobName = &v
	return s
}

// SetNumberOfTopics sets the NumberOfTopics field's value.
func (s *StartTopicsDetectionJobInput) SetNumberOfTopics(v int64) *StartTopicsDetectionJobInput {
	s.NumberOfTopics = &v
	return s
}

// SetOutputDataConfig sets the OutputDataConfig field's value.
func (s *StartTopicsDetectionJobInput) SetOutputDataConfig(v *OutputDataConfig) *StartTopicsDetectionJobInput {
	s.OutputDataConfig = v
	return s
}

// SetVolumeKmsKeyId sets the VolumeKmsKeyId field's value.
func (s *StartTopicsDetectionJobInput) SetVolumeKmsKeyId(v string) *StartTopicsDetectionJobInput {
	s.VolumeKmsKeyId = &v
	return s
}

// SetVpcConfig sets the VpcConfig field's value.
func (s *StartTopicsDetectionJobInput) SetVpcConfig(v *VpcConfig) *StartTopicsDetectionJobInput {
	s.VpcConfig = v
	return s
}

type StartTopicsDetectionJobOutput struct {
	_ struct{} `type:"structure"`

	// The identifier generated for the job. To get the status of the job, use this
	// identifier with the DescribeTopicDetectionJob operation.
	JobId *string `min:"1" type:"string"`

	// The status of the job:
	//
	//    * SUBMITTED - The job has been received and is queued for processing.
	//
	//    * IN_PROGRESS - Amazon Comprehend is processing the job.
	//
	//    * COMPLETED - The job was successfully completed and the output is available.
	//
	//    * FAILED - The job did not complete. To get details, use the DescribeTopicDetectionJob
	//    operation.
	JobStatus *string `type:"string" enum:"JobStatus"`
}

// String returns the string representation
func (s StartTopicsDetectionJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartTopicsDetectionJobOutput) GoString() string {
	return s.String()
}

// SetJobId sets the JobId field's value.
func (s *StartTopicsDetectionJobOutput) SetJobId(v string) *StartTopicsDetectionJobOutput {
	s.JobId = &v
	return s
}

// SetJobStatus sets the JobStatus field's value.
func (s *StartTopicsDetectionJobOutput) SetJobStatus(v string) *StartTopicsDetectionJobOutput {
	s.JobStatus = &v
	return s
}

type StopDominantLanguageDetectionJobInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the dominant language detection job to stop.
	//
	// JobId is a required field
	JobId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s StopDominantLanguageDetectionJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopDominantLanguageDetectionJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopDominantLanguageDetectionJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopDominantLanguageDetectionJobInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobId sets the JobId field's value.
func (s *StopDominantLanguageDetectionJobInput) SetJobId(v string) *StopDominantLanguageDetectionJobInput {
	s.JobId = &v
	return s
}

type StopDominantLanguageDetectionJobOutput struct {
	_ struct{} `type:"structure"`

	// The identifier of the dominant language detection job to stop.
	JobId *string `min:"1" type:"string"`

	// Either STOP_REQUESTED if the job is currently running, or STOPPED if the
	// job was previously stopped with the StopDominantLanguageDetectionJob operation.
	JobStatus *string `type:"string" enum:"JobStatus"`
}

// String returns the string representation
func (s StopDominantLanguageDetectionJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopDominantLanguageDetectionJobOutput) GoString() string {
	return s.String()
}

// SetJobId sets the JobId field's value.
func (s *StopDominantLanguageDetectionJobOutput) SetJobId(v string) *StopDominantLanguageDetectionJobOutput {
	s.JobId = &v
	return s
}

// SetJobStatus sets the JobStatus field's value.
func (s *StopDominantLanguageDetectionJobOutput) SetJobStatus(v string) *StopDominantLanguageDetectionJobOutput {
	s.JobStatus = &v
	return s
}

type StopEntitiesDetectionJobInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the entities detection job to stop.
	//
	// JobId is a required field
	JobId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s StopEntitiesDetectionJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopEntitiesDetectionJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopEntitiesDetectionJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopEntitiesDetectionJobInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobId sets the JobId field's value.
func (s *StopEntitiesDetectionJobInput) SetJobId(v string) *StopEntitiesDetectionJobInput {
	s.JobId = &v
	return s
}

type StopEntitiesDetectionJobOutput struct {
	_ struct{} `type:"structure"`

	// The identifier of the entities detection job to stop.
	JobId *string `min:"1" type:"string"`

	// Either STOP_REQUESTED if the job is currently running, or STOPPED if the
	// job was previously stopped with the StopEntitiesDetectionJob operation.
	JobStatus *string `type:"string" enum:"JobStatus"`
}

// String returns the string representation
func (s StopEntitiesDetectionJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopEntitiesDetectionJobOutput) GoString() string {
	return s.String()
}

// SetJobId sets the JobId field's value.
func (s *StopEntitiesDetectionJobOutput) SetJobId(v string) *StopEntitiesDetectionJobOutput {
	s.JobId = &v
	return s
}

// SetJobStatus sets the JobStatus field's value.
func (s *StopEntitiesDetectionJobOutput) SetJobStatus(v string) *StopEntitiesDetectionJobOutput {
	s.JobStatus = &v
	return s
}

type StopKeyPhrasesDetectionJobInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the key phrases detection job to stop.
	//
	// JobId is a required field
	JobId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s StopKeyPhrasesDetectionJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopKeyPhrasesDetectionJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopKeyPhrasesDetectionJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopKeyPhrasesDetectionJobInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobId sets the JobId field's value.
func (s *StopKeyPhrasesDetectionJobInput) SetJobId(v string) *StopKeyPhrasesDetectionJobInput {
	s.JobId = &v
	return s
}

type StopKeyPhrasesDetectionJobOutput struct {
	_ struct{} `type:"structure"`

	// The identifier of the key phrases detection job to stop.
	JobId *string `min:"1" type:"string"`

	// Either STOP_REQUESTED if the job is currently running, or STOPPED if the
	// job was previously stopped with the StopKeyPhrasesDetectionJob operation.
	JobStatus *string `type:"string" enum:"JobStatus"`
}

// String returns the string representation
func (s StopKeyPhrasesDetectionJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopKeyPhrasesDetectionJobOutput) GoString() string {
	return s.String()
}

// SetJobId sets the JobId field's value.
func (s *StopKeyPhrasesDetectionJobOutput) SetJobId(v string) *StopKeyPhrasesDetectionJobOutput {
	s.JobId = &v
	return s
}

// SetJobStatus sets the JobStatus field's value.
func (s *StopKeyPhrasesDetectionJobOutput) SetJobStatus(v string) *StopKeyPhrasesDetectionJobOutput {
	s.JobStatus = &v
	return s
}

type StopPiiEntitiesDetectionJobInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the PII entities detection job to stop.
	//
	// JobId is a required field
	JobId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s StopPiiEntitiesDetectionJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopPiiEntitiesDetectionJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopPiiEntitiesDetectionJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopPiiEntitiesDetectionJobInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobId sets the JobId field's value.
func (s *StopPiiEntitiesDetectionJobInput) SetJobId(v string) *StopPiiEntitiesDetectionJobInput {
	s.JobId = &v
	return s
}

type StopPiiEntitiesDetectionJobOutput struct {
	_ struct{} `type:"structure"`

	// The identifier of the PII entities detection job to stop.
	JobId *string `min:"1" type:"string"`

	// The status of the PII entities detection job.
	JobStatus *string `type:"string" enum:"JobStatus"`
}

// String returns the string representation
func (s StopPiiEntitiesDetectionJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopPiiEntitiesDetectionJobOutput) GoString() string {
	return s.String()
}

// SetJobId sets the JobId field's value.
func (s *StopPiiEntitiesDetectionJobOutput) SetJobId(v string) *StopPiiEntitiesDetectionJobOutput {
	s.JobId = &v
	return s
}

// SetJobStatus sets the JobStatus field's value.
func (s *StopPiiEntitiesDetectionJobOutput) SetJobStatus(v string) *StopPiiEntitiesDetectionJobOutput {
	s.JobStatus = &v
	return s
}

type StopSentimentDetectionJobInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the sentiment detection job to stop.
	//
	// JobId is a required field
	JobId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s StopSentimentDetectionJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopSentimentDetectionJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopSentimentDetectionJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopSentimentDetectionJobInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobId sets the JobId field's value.
func (s *StopSentimentDetectionJobInput) SetJobId(v string) *StopSentimentDetectionJobInput {
	s.JobId = &v
	return s
}

type StopSentimentDetectionJobOutput struct {
	_ struct{} `type:"structure"`

	// The identifier of the sentiment detection job to stop.
	JobId *string `min:"1" type:"string"`

	// Either STOP_REQUESTED if the job is currently running, or STOPPED if the
	// job was previously stopped with the StopSentimentDetectionJob operation.
	JobStatus *string `type:"string" enum:"JobStatus"`
}

// String returns the string representation
func (s StopSentimentDetectionJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopSentimentDetectionJobOutput) GoString() string {
	return s.String()
}

// SetJobId sets the JobId field's value.
func (s *StopSentimentDetectionJobOutput) SetJobId(v string) *StopSentimentDetectionJobOutput {
	s.JobId = &v
	return s
}

// SetJobStatus sets the JobStatus field's value.
func (s *StopSentimentDetectionJobOutput) SetJobStatus(v string) *StopSentimentDetectionJobOutput {
	s.JobStatus = &v
	return s
}

type StopTrainingDocumentClassifierInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) that identifies the document classifier currently
	// being trained.
	//
	// DocumentClassifierArn is a required field
	DocumentClassifierArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s StopTrainingDocumentClassifierInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopTrainingDocumentClassifierInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopTrainingDocumentClassifierInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopTrainingDocumentClassifierInput"}
	if s.DocumentClassifierArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DocumentClassifierArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDocumentClassifierArn sets the DocumentClassifierArn field's value.
func (s *StopTrainingDocumentClassifierInput) SetDocumentClassifierArn(v string) *StopTrainingDocumentClassifierInput {
	s.DocumentClassifierArn = &v
	return s
}

type StopTrainingDocumentClassifierOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s StopTrainingDocumentClassifierOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopTrainingDocumentClassifierOutput) GoString() string {
	return s.String()
}

type StopTrainingEntityRecognizerInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) that identifies the entity recognizer currently
	// being trained.
	//
	// EntityRecognizerArn is a required field
	EntityRecognizerArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s StopTrainingEntityRecognizerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopTrainingEntityRecognizerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopTrainingEntityRecognizerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopTrainingEntityRecognizerInput"}
	if s.EntityRecognizerArn == nil {
		invalidParams.Add(request.NewErrParamRequired("EntityRecognizerArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEntityRecognizerArn sets the EntityRecognizerArn field's value.
func (s *StopTrainingEntityRecognizerInput) SetEntityRecognizerArn(v string) *StopTrainingEntityRecognizerInput {
	s.EntityRecognizerArn = &v
	return s
}

type StopTrainingEntityRecognizerOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s StopTrainingEntityRecognizerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopTrainingEntityRecognizerOutput) GoString() string {
	return s.String()
}

// Represents a work in the input text that was recognized and assigned a part
// of speech. There is one syntax token record for each word in the source text.
type SyntaxToken struct {
	_ struct{} `type:"structure"`

	// The zero-based offset from the beginning of the source text to the first
	// character in the word.
	BeginOffset *int64 `type:"integer"`

	// The zero-based offset from the beginning of the source text to the last character
	// in the word.
	EndOffset *int64 `type:"integer"`

	// Provides the part of speech label and the confidence level that Amazon Comprehend
	// has that the part of speech was correctly identified. For more information,
	// see how-syntax.
	PartOfSpeech *PartOfSpeechTag `type:"structure"`

	// The word that was recognized in the source text.
	Text *string `min:"1" type:"string"`

	// A unique identifier for a token.
	TokenId *int64 `type:"integer"`
}

// String returns the string representation
func (s SyntaxToken) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SyntaxToken) GoString() string {
	return s.String()
}

// SetBeginOffset sets the BeginOffset field's value.
func (s *SyntaxToken) SetBeginOffset(v int64) *SyntaxToken {
	s.BeginOffset = &v
	return s
}

// SetEndOffset sets the EndOffset field's value.
func (s *SyntaxToken) SetEndOffset(v int64) *SyntaxToken {
	s.EndOffset = &v
	return s
}

// SetPartOfSpeech sets the PartOfSpeech field's value.
func (s *SyntaxToken) SetPartOfSpeech(v *PartOfSpeechTag) *SyntaxToken {
	s.PartOfSpeech = v
	return s
}

// SetText sets the Text field's value.
func (s *SyntaxToken) SetText(v string) *SyntaxToken {
	s.Text = &v
	return s
}

// SetTokenId sets the TokenId field's value.
func (s *SyntaxToken) SetTokenId(v int64) *SyntaxToken {
	s.TokenId = &v
	return s
}

// A key-value pair that adds as a metadata to a resource used by Amazon Comprehend.
// For example, a tag with the key-value pair ‘Department’:’Sales’ might
// be added to a resource to indicate its use by a particular department.
type Tag struct {
	_ struct{} `type:"structure"`

	// The initial part of a key-value pair that forms a tag associated with a given
	// resource. For instance, if you want to show which resources are used by which
	// departments, you might use “Department” as the key portion of the pair,
	// with multiple possible values such as “sales,” “legal,” and “administration.”
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// The second part of a key-value pair that forms a tag associated with a given
	// resource. For instance, if you want to show which resources are used by which
	// departments, you might use “Department” as the initial (key) portion
	// of the pair, with a value of “sales” to indicate the sales department.
	Value *string `type:"string"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the given Amazon Comprehend resource to
	// which you want to associate the tags.
	//
	// ResourceArn is a required field
	ResourceArn *string `type:"string" required:"true"`

	// Tags being associated with a specific Amazon Comprehend resource. There can
	// be a maximum of 50 tags (both existing and pending) associated with a specific
	// resource.
	//
	// Tags is a required field
	Tags []*Tag `type:"list" required:"true"`
}

// String returns the string representation
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v []*Tag) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// The size of the input text exceeds the limit. Use a smaller document.
type TextSizeLimitExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation
func (s TextSizeLimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TextSizeLimitExceededException) GoString() string {
	return s.String()
}

func newErrorTextSizeLimitExceededException(v protocol.ResponseMetadata) error {
	return &TextSizeLimitExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *TextSizeLimitExceededException) Code() string {
	return "TextSizeLimitExceededException"
}

// Message returns the exception's message.
func (s *TextSizeLimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *TextSizeLimitExceededException) OrigErr() error {
	return nil
}

func (s *TextSizeLimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *TextSizeLimitExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *TextSizeLimitExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The number of requests exceeds the limit. Resubmit your request later.
type TooManyRequestsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation
func (s TooManyRequestsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TooManyRequestsException) GoString() string {
	return s.String()
}

func newErrorTooManyRequestsException(v protocol.ResponseMetadata) error {
	return &TooManyRequestsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *TooManyRequestsException) Code() string {
	return "TooManyRequestsException"
}

// Message returns the exception's message.
func (s *TooManyRequestsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *TooManyRequestsException) OrigErr() error {
	return nil
}

func (s *TooManyRequestsException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *TooManyRequestsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *TooManyRequestsException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The request contains more tag keys than can be associated with a resource
// (50 tag keys per resource).
type TooManyTagKeysException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation
func (s TooManyTagKeysException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TooManyTagKeysException) GoString() string {
	return s.String()
}

func newErrorTooManyTagKeysException(v protocol.ResponseMetadata) error {
	return &TooManyTagKeysException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *TooManyTagKeysException) Code() string {
	return "TooManyTagKeysException"
}

// Message returns the exception's message.
func (s *TooManyTagKeysException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *TooManyTagKeysException) OrigErr() error {
	return nil
}

func (s *TooManyTagKeysException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *TooManyTagKeysException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *TooManyTagKeysException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The request contains more tags than can be associated with a resource (50
// tags per resource). The maximum number of tags includes both existing tags
// and those included in your current request.
type TooManyTagsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation
func (s TooManyTagsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TooManyTagsException) GoString() string {
	return s.String()
}

func newErrorTooManyTagsException(v protocol.ResponseMetadata) error {
	return &TooManyTagsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *TooManyTagsException) Code() string {
	return "TooManyTagsException"
}

// Message returns the exception's message.
func (s *TooManyTagsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *TooManyTagsException) OrigErr() error {
	return nil
}

func (s *TooManyTagsException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *TooManyTagsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *TooManyTagsException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Provides information for filtering topic detection jobs. For more information,
// see .
type TopicsDetectionJobFilter struct {
	_ struct{} `type:"structure"`

	JobName *string `min:"1" type:"string"`

	// Filters the list of topic detection jobs based on job status. Returns only
	// jobs with the specified status.
	JobStatus *string `type:"string" enum:"JobStatus"`

	// Filters the list of jobs based on the time that the job was submitted for
	// processing. Only returns jobs submitted after the specified time. Jobs are
	// returned in ascending order, oldest to newest.
	SubmitTimeAfter *time.Time `type:"timestamp"`

	// Filters the list of jobs based on the time that the job was submitted for
	// processing. Only returns jobs submitted before the specified time. Jobs are
	// returned in descending order, newest to oldest.
	SubmitTimeBefore *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s TopicsDetectionJobFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TopicsDetectionJobFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TopicsDetectionJobFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TopicsDetectionJobFilter"}
	if s.JobName != nil && len(*s.JobName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobName sets the JobName field's value.
func (s *TopicsDetectionJobFilter) SetJobName(v string) *TopicsDetectionJobFilter {
	s.JobName = &v
	return s
}

// SetJobStatus sets the JobStatus field's value.
func (s *TopicsDetectionJobFilter) SetJobStatus(v string) *TopicsDetectionJobFilter {
	s.JobStatus = &v
	return s
}

// SetSubmitTimeAfter sets the SubmitTimeAfter field's value.
func (s *TopicsDetectionJobFilter) SetSubmitTimeAfter(v time.Time) *TopicsDetectionJobFilter {
	s.SubmitTimeAfter = &v
	return s
}

// SetSubmitTimeBefore sets the SubmitTimeBefore field's value.
func (s *TopicsDetectionJobFilter) SetSubmitTimeBefore(v time.Time) *TopicsDetectionJobFilter {
	s.SubmitTimeBefore = &v
	return s
}

// Provides information about a topic detection job.
type TopicsDetectionJobProperties struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the AWS Identity and Management (IAM) role
	// that grants Amazon Comprehend read access to your job data.
	DataAccessRoleArn *string `min:"20" type:"string"`

	// The time that the topic detection job was completed.
	EndTime *time.Time `type:"timestamp"`

	// The input data configuration supplied when you created the topic detection
	// job.
	InputDataConfig *InputDataConfig `type:"structure"`

	// The identifier assigned to the topic detection job.
	JobId *string `min:"1" type:"string"`

	// The name of the topic detection job.
	JobName *string `min:"1" type:"string"`

	// The current status of the topic detection job. If the status is Failed, the
	// reason for the failure is shown in the Message field.
	JobStatus *string `type:"string" enum:"JobStatus"`

	// A description for the status of a job.
	Message *string `type:"string"`

	// The number of topics to detect supplied when you created the topic detection
	// job. The default is 10.
	NumberOfTopics *int64 `type:"integer"`

	// The output data configuration supplied when you created the topic detection
	// job.
	OutputDataConfig *OutputDataConfig `type:"structure"`

	// The time that the topic detection job was submitted for processing.
	SubmitTime *time.Time `type:"timestamp"`

	// ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses
	// to encrypt data on the storage volume attached to the ML compute instance(s)
	// that process the analysis job. The VolumeKmsKeyId can be either of the following
	// formats:
	//
	//    * KMS Key ID: "1234abcd-12ab-34cd-56ef-1234567890ab"
	//
	//    * Amazon Resource Name (ARN) of a KMS Key: "arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"
	VolumeKmsKeyId *string `type:"string"`

	// Configuration parameters for a private Virtual Private Cloud (VPC) containing
	// the resources you are using for your topic detection job. For more information,
	// see Amazon VPC (https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html).
	VpcConfig *VpcConfig `type:"structure"`
}

// String returns the string representation
func (s TopicsDetectionJobProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TopicsDetectionJobProperties) GoString() string {
	return s.String()
}

// SetDataAccessRoleArn sets the DataAccessRoleArn field's value.
func (s *TopicsDetectionJobProperties) SetDataAccessRoleArn(v string) *TopicsDetectionJobProperties {
	s.DataAccessRoleArn = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *TopicsDetectionJobProperties) SetEndTime(v time.Time) *TopicsDetectionJobProperties {
	s.EndTime = &v
	return s
}

// SetInputDataConfig sets the InputDataConfig field's value.
func (s *TopicsDetectionJobProperties) SetInputDataConfig(v *InputDataConfig) *TopicsDetectionJobProperties {
	s.InputDataConfig = v
	return s
}

// SetJobId sets the JobId field's value.
func (s *TopicsDetectionJobProperties) SetJobId(v string) *TopicsDetectionJobProperties {
	s.JobId = &v
	return s
}

// SetJobName sets the JobName field's value.
func (s *TopicsDetectionJobProperties) SetJobName(v string) *TopicsDetectionJobProperties {
	s.JobName = &v
	return s
}

// SetJobStatus sets the JobStatus field's value.
func (s *TopicsDetectionJobProperties) SetJobStatus(v string) *TopicsDetectionJobProperties {
	s.JobStatus = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *TopicsDetectionJobProperties) SetMessage(v string) *TopicsDetectionJobProperties {
	s.Message = &v
	return s
}

// SetNumberOfTopics sets the NumberOfTopics field's value.
func (s *TopicsDetectionJobProperties) SetNumberOfTopics(v int64) *TopicsDetectionJobProperties {
	s.NumberOfTopics = &v
	return s
}

// SetOutputDataConfig sets the OutputDataConfig field's value.
func (s *TopicsDetectionJobProperties) SetOutputDataConfig(v *OutputDataConfig) *TopicsDetectionJobProperties {
	s.OutputDataConfig = v
	return s
}

// SetSubmitTime sets the SubmitTime field's value.
func (s *TopicsDetectionJobProperties) SetSubmitTime(v time.Time) *TopicsDetectionJobProperties {
	s.SubmitTime = &v
	return s
}

// SetVolumeKmsKeyId sets the VolumeKmsKeyId field's value.
func (s *TopicsDetectionJobProperties) SetVolumeKmsKeyId(v string) *TopicsDetectionJobProperties {
	s.VolumeKmsKeyId = &v
	return s
}

// SetVpcConfig sets the VpcConfig field's value.
func (s *TopicsDetectionJobProperties) SetVpcConfig(v *VpcConfig) *TopicsDetectionJobProperties {
	s.VpcConfig = v
	return s
}

// Amazon Comprehend can't process the language of the input text. For all custom
// entity recognition APIs (such as CreateEntityRecognizer), only English, Spanish,
// French, Italian, German, or Portuguese are accepted. For most other APIs,
// such as those for Custom Classification, Amazon Comprehend accepts text in
// all supported languages. For a list of supported languages, see supported-languages.
type UnsupportedLanguageException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation
func (s UnsupportedLanguageException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UnsupportedLanguageException) GoString() string {
	return s.String()
}

func newErrorUnsupportedLanguageException(v protocol.ResponseMetadata) error {
	return &UnsupportedLanguageException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *UnsupportedLanguageException) Code() string {
	return "UnsupportedLanguageException"
}

// Message returns the exception's message.
func (s *UnsupportedLanguageException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *UnsupportedLanguageException) OrigErr() error {
	return nil
}

func (s *UnsupportedLanguageException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *UnsupportedLanguageException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *UnsupportedLanguageException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the given Amazon Comprehend resource from
	// which you want to remove the tags.
	//
	// ResourceArn is a required field
	ResourceArn *string `type:"string" required:"true"`

	// The initial part of a key-value pair that forms a tag being removed from
	// a given resource. For example, a tag with "Sales" as the key might be added
	// to a resource to indicate its use by the sales department. Keys must be unique
	// and cannot be duplicated for a particular resource.
	//
	// TagKeys is a required field
	TagKeys []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateEndpointInput struct {
	_ struct{} `type:"structure"`

	// The desired number of inference units to be used by the model using this
	// endpoint. Each inference unit represents of a throughput of 100 characters
	// per second.
	//
	// DesiredInferenceUnits is a required field
	DesiredInferenceUnits *int64 `min:"1" type:"integer" required:"true"`

	// The Amazon Resource Number (ARN) of the endpoint being updated.
	//
	// EndpointArn is a required field
	EndpointArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateEndpointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateEndpointInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateEndpointInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateEndpointInput"}
	if s.DesiredInferenceUnits == nil {
		invalidParams.Add(request.NewErrParamRequired("DesiredInferenceUnits"))
	}
	if s.DesiredInferenceUnits != nil && *s.DesiredInferenceUnits < 1 {
		invalidParams.Add(request.NewErrParamMinValue("DesiredInferenceUnits", 1))
	}
	if s.EndpointArn == nil {
		invalidParams.Add(request.NewErrParamRequired("EndpointArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDesiredInferenceUnits sets the DesiredInferenceUnits field's value.
func (s *UpdateEndpointInput) SetDesiredInferenceUnits(v int64) *UpdateEndpointInput {
	s.DesiredInferenceUnits = &v
	return s
}

// SetEndpointArn sets the EndpointArn field's value.
func (s *UpdateEndpointInput) SetEndpointArn(v string) *UpdateEndpointInput {
	s.EndpointArn = &v
	return s
}

type UpdateEndpointOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateEndpointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateEndpointOutput) GoString() string {
	return s.String()
}

// Configuration parameters for an optional private Virtual Private Cloud (VPC)
// containing the resources you are using for the job. For For more information,
// see Amazon VPC (https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html).
type VpcConfig struct {
	_ struct{} `type:"structure"`

	// The ID number for a security group on an instance of your private VPC. Security
	// groups on your VPC function serve as a virtual firewall to control inbound
	// and outbound traffic and provides security for the resources that you’ll
	// be accessing on the VPC. This ID number is preceded by "sg-", for instance:
	// "sg-03b388029b0a285ea". For more information, see Security Groups for your
	// VPC (https://docs.aws.amazon.com/vpc/latest/userguide/VPC_SecurityGroups.html).
	//
	// SecurityGroupIds is a required field
	SecurityGroupIds []*string `min:"1" type:"list" required:"true"`

	// The ID for each subnet being used in your private VPC. This subnet is a subset
	// of the a range of IPv4 addresses used by the VPC and is specific to a given
	// availability zone in the VPC’s region. This ID number is preceded by "subnet-",
	// for instance: "subnet-04ccf456919e69055". For more information, see VPCs
	// and Subnets (https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html).
	//
	// Subnets is a required field
	Subnets []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s VpcConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VpcConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VpcConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VpcConfig"}
	if s.SecurityGroupIds == nil {
		invalidParams.Add(request.NewErrParamRequired("SecurityGroupIds"))
	}
	if s.SecurityGroupIds != nil && len(s.SecurityGroupIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecurityGroupIds", 1))
	}
	if s.Subnets == nil {
		invalidParams.Add(request.NewErrParamRequired("Subnets"))
	}
	if s.Subnets != nil && len(s.Subnets) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Subnets", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *VpcConfig) SetSecurityGroupIds(v []*string) *VpcConfig {
	s.SecurityGroupIds = v
	return s
}

// SetSubnets sets the Subnets field's value.
func (s *VpcConfig) SetSubnets(v []*string) *VpcConfig {
	s.Subnets = v
	return s
}

const (
	// DocumentClassifierDataFormatComprehendCsv is a DocumentClassifierDataFormat enum value
	DocumentClassifierDataFormatComprehendCsv = "COMPREHEND_CSV"

	// DocumentClassifierDataFormatAugmentedManifest is a DocumentClassifierDataFormat enum value
	DocumentClassifierDataFormatAugmentedManifest = "AUGMENTED_MANIFEST"
)

// DocumentClassifierDataFormat_Values returns all elements of the DocumentClassifierDataFormat enum
func DocumentClassifierDataFormat_Values() []string {
	return []string{
		DocumentClassifierDataFormatComprehendCsv,
		DocumentClassifierDataFormatAugmentedManifest,
	}
}

const (
	// DocumentClassifierModeMultiClass is a DocumentClassifierMode enum value
	DocumentClassifierModeMultiClass = "MULTI_CLASS"

	// DocumentClassifierModeMultiLabel is a DocumentClassifierMode enum value
	DocumentClassifierModeMultiLabel = "MULTI_LABEL"
)

// DocumentClassifierMode_Values returns all elements of the DocumentClassifierMode enum
func DocumentClassifierMode_Values() []string {
	return []string{
		DocumentClassifierModeMultiClass,
		DocumentClassifierModeMultiLabel,
	}
}

const (
	// EndpointStatusCreating is a EndpointStatus enum value
	EndpointStatusCreating = "CREATING"

	// EndpointStatusDeleting is a EndpointStatus enum value
	EndpointStatusDeleting = "DELETING"

	// EndpointStatusFailed is a EndpointStatus enum value
	EndpointStatusFailed = "FAILED"

	// EndpointStatusInService is a EndpointStatus enum value
	EndpointStatusInService = "IN_SERVICE"

	// EndpointStatusUpdating is a EndpointStatus enum value
	EndpointStatusUpdating = "UPDATING"
)

// EndpointStatus_Values returns all elements of the EndpointStatus enum
func EndpointStatus_Values() []string {
	return []string{
		EndpointStatusCreating,
		EndpointStatusDeleting,
		EndpointStatusFailed,
		EndpointStatusInService,
		EndpointStatusUpdating,
	}
}

const (
	// EntityRecognizerDataFormatComprehendCsv is a EntityRecognizerDataFormat enum value
	EntityRecognizerDataFormatComprehendCsv = "COMPREHEND_CSV"

	// EntityRecognizerDataFormatAugmentedManifest is a EntityRecognizerDataFormat enum value
	EntityRecognizerDataFormatAugmentedManifest = "AUGMENTED_MANIFEST"
)

// EntityRecognizerDataFormat_Values returns all elements of the EntityRecognizerDataFormat enum
func EntityRecognizerDataFormat_Values() []string {
	return []string{
		EntityRecognizerDataFormatComprehendCsv,
		EntityRecognizerDataFormatAugmentedManifest,
	}
}

const (
	// EntityTypePerson is a EntityType enum value
	EntityTypePerson = "PERSON"

	// EntityTypeLocation is a EntityType enum value
	EntityTypeLocation = "LOCATION"

	// EntityTypeOrganization is a EntityType enum value
	EntityTypeOrganization = "ORGANIZATION"

	// EntityTypeCommercialItem is a EntityType enum value
	EntityTypeCommercialItem = "COMMERCIAL_ITEM"

	// EntityTypeEvent is a EntityType enum value
	EntityTypeEvent = "EVENT"

	// EntityTypeDate is a EntityType enum value
	EntityTypeDate = "DATE"

	// EntityTypeQuantity is a EntityType enum value
	EntityTypeQuantity = "QUANTITY"

	// EntityTypeTitle is a EntityType enum value
	EntityTypeTitle = "TITLE"

	// EntityTypeOther is a EntityType enum value
	EntityTypeOther = "OTHER"
)

// EntityType_Values returns all elements of the EntityType enum
func EntityType_Values() []string {
	return []string{
		EntityTypePerson,
		EntityTypeLocation,
		EntityTypeOrganization,
		EntityTypeCommercialItem,
		EntityTypeEvent,
		EntityTypeDate,
		EntityTypeQuantity,
		EntityTypeTitle,
		EntityTypeOther,
	}
}

const (
	// InputFormatOneDocPerFile is a InputFormat enum value
	InputFormatOneDocPerFile = "ONE_DOC_PER_FILE"

	// InputFormatOneDocPerLine is a InputFormat enum value
	InputFormatOneDocPerLine = "ONE_DOC_PER_LINE"
)

// InputFormat_Values returns all elements of the InputFormat enum
func InputFormat_Values() []string {
	return []string{
		InputFormatOneDocPerFile,
		InputFormatOneDocPerLine,
	}
}

const (
	// JobStatusSubmitted is a JobStatus enum value
	JobStatusSubmitted = "SUBMITTED"

	// JobStatusInProgress is a JobStatus enum value
	JobStatusInProgress = "IN_PROGRESS"

	// JobStatusCompleted is a JobStatus enum value
	JobStatusCompleted = "COMPLETED"

	// JobStatusFailed is a JobStatus enum value
	JobStatusFailed = "FAILED"

	// JobStatusStopRequested is a JobStatus enum value
	JobStatusStopRequested = "STOP_REQUESTED"

	// JobStatusStopped is a JobStatus enum value
	JobStatusStopped = "STOPPED"
)

// JobStatus_Values returns all elements of the JobStatus enum
func JobStatus_Values() []string {
	return []string{
		JobStatusSubmitted,
		JobStatusInProgress,
		JobStatusCompleted,
		JobStatusFailed,
		JobStatusStopRequested,
		JobStatusStopped,
	}
}

const (
	// LanguageCodeEn is a LanguageCode enum value
	LanguageCodeEn = "en"

	// LanguageCodeEs is a LanguageCode enum value
	LanguageCodeEs = "es"

	// LanguageCodeFr is a LanguageCode enum value
	LanguageCodeFr = "fr"

	// LanguageCodeDe is a LanguageCode enum value
	LanguageCodeDe = "de"

	// LanguageCodeIt is a LanguageCode enum value
	LanguageCodeIt = "it"

	// LanguageCodePt is a LanguageCode enum value
	LanguageCodePt = "pt"

	// LanguageCodeAr is a LanguageCode enum value
	LanguageCodeAr = "ar"

	// LanguageCodeHi is a LanguageCode enum value
	LanguageCodeHi = "hi"

	// LanguageCodeJa is a LanguageCode enum value
	LanguageCodeJa = "ja"

	// LanguageCodeKo is a LanguageCode enum value
	LanguageCodeKo = "ko"

	// LanguageCodeZh is a LanguageCode enum value
	LanguageCodeZh = "zh"

	// LanguageCodeZhTw is a LanguageCode enum value
	LanguageCodeZhTw = "zh-TW"
)

// LanguageCode_Values returns all elements of the LanguageCode enum
func LanguageCode_Values() []string {
	return []string{
		LanguageCodeEn,
		LanguageCodeEs,
		LanguageCodeFr,
		LanguageCodeDe,
		LanguageCodeIt,
		LanguageCodePt,
		LanguageCodeAr,
		LanguageCodeHi,
		LanguageCodeJa,
		LanguageCodeKo,
		LanguageCodeZh,
		LanguageCodeZhTw,
	}
}

const (
	// ModelStatusSubmitted is a ModelStatus enum value
	ModelStatusSubmitted = "SUBMITTED"

	// ModelStatusTraining is a ModelStatus enum value
	ModelStatusTraining = "TRAINING"

	// ModelStatusDeleting is a ModelStatus enum value
	ModelStatusDeleting = "DELETING"

	// ModelStatusStopRequested is a ModelStatus enum value
	ModelStatusStopRequested = "STOP_REQUESTED"

	// ModelStatusStopped is a ModelStatus enum value
	ModelStatusStopped = "STOPPED"

	// ModelStatusInError is a ModelStatus enum value
	ModelStatusInError = "IN_ERROR"

	// ModelStatusTrained is a ModelStatus enum value
	ModelStatusTrained = "TRAINED"
)

// ModelStatus_Values returns all elements of the ModelStatus enum
func ModelStatus_Values() []string {
	return []string{
		ModelStatusSubmitted,
		ModelStatusTraining,
		ModelStatusDeleting,
		ModelStatusStopRequested,
		ModelStatusStopped,
		ModelStatusInError,
		ModelStatusTrained,
	}
}

const (
	// PartOfSpeechTagTypeAdj is a PartOfSpeechTagType enum value
	PartOfSpeechTagTypeAdj = "ADJ"

	// PartOfSpeechTagTypeAdp is a PartOfSpeechTagType enum value
	PartOfSpeechTagTypeAdp = "ADP"

	// PartOfSpeechTagTypeAdv is a PartOfSpeechTagType enum value
	PartOfSpeechTagTypeAdv = "ADV"

	// PartOfSpeechTagTypeAux is a PartOfSpeechTagType enum value
	PartOfSpeechTagTypeAux = "AUX"

	// PartOfSpeechTagTypeConj is a PartOfSpeechTagType enum value
	PartOfSpeechTagTypeConj = "CONJ"

	// PartOfSpeechTagTypeCconj is a PartOfSpeechTagType enum value
	PartOfSpeechTagTypeCconj = "CCONJ"

	// PartOfSpeechTagTypeDet is a PartOfSpeechTagType enum value
	PartOfSpeechTagTypeDet = "DET"

	// PartOfSpeechTagTypeIntj is a PartOfSpeechTagType enum value
	PartOfSpeechTagTypeIntj = "INTJ"

	// PartOfSpeechTagTypeNoun is a PartOfSpeechTagType enum value
	PartOfSpeechTagTypeNoun = "NOUN"

	// PartOfSpeechTagTypeNum is a PartOfSpeechTagType enum value
	PartOfSpeechTagTypeNum = "NUM"

	// PartOfSpeechTagTypeO is a PartOfSpeechTagType enum value
	PartOfSpeechTagTypeO = "O"

	// PartOfSpeechTagTypePart is a PartOfSpeechTagType enum value
	PartOfSpeechTagTypePart = "PART"

	// PartOfSpeechTagTypePron is a PartOfSpeechTagType enum value
	PartOfSpeechTagTypePron = "PRON"

	// PartOfSpeechTagTypePropn is a PartOfSpeechTagType enum value
	PartOfSpeechTagTypePropn = "PROPN"

	// PartOfSpeechTagTypePunct is a PartOfSpeechTagType enum value
	PartOfSpeechTagTypePunct = "PUNCT"

	// PartOfSpeechTagTypeSconj is a PartOfSpeechTagType enum value
	PartOfSpeechTagTypeSconj = "SCONJ"

	// PartOfSpeechTagTypeSym is a PartOfSpeechTagType enum value
	PartOfSpeechTagTypeSym = "SYM"

	// PartOfSpeechTagTypeVerb is a PartOfSpeechTagType enum value
	PartOfSpeechTagTypeVerb = "VERB"
)

// PartOfSpeechTagType_Values returns all elements of the PartOfSpeechTagType enum
func PartOfSpeechTagType_Values() []string {
	return []string{
		PartOfSpeechTagTypeAdj,
		PartOfSpeechTagTypeAdp,
		PartOfSpeechTagTypeAdv,
		PartOfSpeechTagTypeAux,
		PartOfSpeechTagTypeConj,
		PartOfSpeechTagTypeCconj,
		PartOfSpeechTagTypeDet,
		PartOfSpeechTagTypeIntj,
		PartOfSpeechTagTypeNoun,
		PartOfSpeechTagTypeNum,
		PartOfSpeechTagTypeO,
		PartOfSpeechTagTypePart,
		PartOfSpeechTagTypePron,
		PartOfSpeechTagTypePropn,
		PartOfSpeechTagTypePunct,
		PartOfSpeechTagTypeSconj,
		PartOfSpeechTagTypeSym,
		PartOfSpeechTagTypeVerb,
	}
}

const (
	// PiiEntitiesDetectionMaskModeMask is a PiiEntitiesDetectionMaskMode enum value
	PiiEntitiesDetectionMaskModeMask = "MASK"

	// PiiEntitiesDetectionMaskModeReplaceWithPiiEntityType is a PiiEntitiesDetectionMaskMode enum value
	PiiEntitiesDetectionMaskModeReplaceWithPiiEntityType = "REPLACE_WITH_PII_ENTITY_TYPE"
)

// PiiEntitiesDetectionMaskMode_Values returns all elements of the PiiEntitiesDetectionMaskMode enum
func PiiEntitiesDetectionMaskMode_Values() []string {
	return []string{
		PiiEntitiesDetectionMaskModeMask,
		PiiEntitiesDetectionMaskModeReplaceWithPiiEntityType,
	}
}

const (
	// PiiEntitiesDetectionModeOnlyRedaction is a PiiEntitiesDetectionMode enum value
	PiiEntitiesDetectionModeOnlyRedaction = "ONLY_REDACTION"

	// PiiEntitiesDetectionModeOnlyOffsets is a PiiEntitiesDetectionMode enum value
	PiiEntitiesDetectionModeOnlyOffsets = "ONLY_OFFSETS"
)

// PiiEntitiesDetectionMode_Values returns all elements of the PiiEntitiesDetectionMode enum
func PiiEntitiesDetectionMode_Values() []string {
	return []string{
		PiiEntitiesDetectionModeOnlyRedaction,
		PiiEntitiesDetectionModeOnlyOffsets,
	}
}

const (
	// PiiEntityTypeBankAccountNumber is a PiiEntityType enum value
	PiiEntityTypeBankAccountNumber = "BANK_ACCOUNT_NUMBER"

	// PiiEntityTypeBankRouting is a PiiEntityType enum value
	PiiEntityTypeBankRouting = "BANK_ROUTING"

	// PiiEntityTypeCreditDebitNumber is a PiiEntityType enum value
	PiiEntityTypeCreditDebitNumber = "CREDIT_DEBIT_NUMBER"

	// PiiEntityTypeCreditDebitCvv is a PiiEntityType enum value
	PiiEntityTypeCreditDebitCvv = "CREDIT_DEBIT_CVV"

	// PiiEntityTypeCreditDebitExpiry is a PiiEntityType enum value
	PiiEntityTypeCreditDebitExpiry = "CREDIT_DEBIT_EXPIRY"

	// PiiEntityTypePin is a PiiEntityType enum value
	PiiEntityTypePin = "PIN"

	// PiiEntityTypeEmail is a PiiEntityType enum value
	PiiEntityTypeEmail = "EMAIL"

	// PiiEntityTypeAddress is a PiiEntityType enum value
	PiiEntityTypeAddress = "ADDRESS"

	// PiiEntityTypeName is a PiiEntityType enum value
	PiiEntityTypeName = "NAME"

	// PiiEntityTypePhone is a PiiEntityType enum value
	PiiEntityTypePhone = "PHONE"

	// PiiEntityTypeSsn is a PiiEntityType enum value
	PiiEntityTypeSsn = "SSN"

	// PiiEntityTypeDateTime is a PiiEntityType enum value
	PiiEntityTypeDateTime = "DATE_TIME"

	// PiiEntityTypePassportNumber is a PiiEntityType enum value
	PiiEntityTypePassportNumber = "PASSPORT_NUMBER"

	// PiiEntityTypeDriverId is a PiiEntityType enum value
	PiiEntityTypeDriverId = "DRIVER_ID"

	// PiiEntityTypeUrl is a PiiEntityType enum value
	PiiEntityTypeUrl = "URL"

	// PiiEntityTypeAge is a PiiEntityType enum value
	PiiEntityTypeAge = "AGE"

	// PiiEntityTypeUsername is a PiiEntityType enum value
	PiiEntityTypeUsername = "USERNAME"

	// PiiEntityTypePassword is a PiiEntityType enum value
	PiiEntityTypePassword = "PASSWORD"

	// PiiEntityTypeAwsAccessKey is a PiiEntityType enum value
	PiiEntityTypeAwsAccessKey = "AWS_ACCESS_KEY"

	// PiiEntityTypeAwsSecretKey is a PiiEntityType enum value
	PiiEntityTypeAwsSecretKey = "AWS_SECRET_KEY"

	// PiiEntityTypeIpAddress is a PiiEntityType enum value
	PiiEntityTypeIpAddress = "IP_ADDRESS"

	// PiiEntityTypeMacAddress is a PiiEntityType enum value
	PiiEntityTypeMacAddress = "MAC_ADDRESS"

	// PiiEntityTypeAll is a PiiEntityType enum value
	PiiEntityTypeAll = "ALL"
)

// PiiEntityType_Values returns all elements of the PiiEntityType enum
func PiiEntityType_Values() []string {
	return []string{
		PiiEntityTypeBankAccountNumber,
		PiiEntityTypeBankRouting,
		PiiEntityTypeCreditDebitNumber,
		PiiEntityTypeCreditDebitCvv,
		PiiEntityTypeCreditDebitExpiry,
		PiiEntityTypePin,
		PiiEntityTypeEmail,
		PiiEntityTypeAddress,
		PiiEntityTypeName,
		PiiEntityTypePhone,
		PiiEntityTypeSsn,
		PiiEntityTypeDateTime,
		PiiEntityTypePassportNumber,
		PiiEntityTypeDriverId,
		PiiEntityTypeUrl,
		PiiEntityTypeAge,
		PiiEntityTypeUsername,
		PiiEntityTypePassword,
		PiiEntityTypeAwsAccessKey,
		PiiEntityTypeAwsSecretKey,
		PiiEntityTypeIpAddress,
		PiiEntityTypeMacAddress,
		PiiEntityTypeAll,
	}
}

const (
	// SentimentTypePositive is a SentimentType enum value
	SentimentTypePositive = "POSITIVE"

	// SentimentTypeNegative is a SentimentType enum value
	SentimentTypeNegative = "NEGATIVE"

	// SentimentTypeNeutral is a SentimentType enum value
	SentimentTypeNeutral = "NEUTRAL"

	// SentimentTypeMixed is a SentimentType enum value
	SentimentTypeMixed = "MIXED"
)

// SentimentType_Values returns all elements of the SentimentType enum
func SentimentType_Values() []string {
	return []string{
		SentimentTypePositive,
		SentimentTypeNegative,
		SentimentTypeNeutral,
		SentimentTypeMixed,
	}
}

const (
	// SyntaxLanguageCodeEn is a SyntaxLanguageCode enum value
	SyntaxLanguageCodeEn = "en"

	// SyntaxLanguageCodeEs is a SyntaxLanguageCode enum value
	SyntaxLanguageCodeEs = "es"

	// SyntaxLanguageCodeFr is a SyntaxLanguageCode enum value
	SyntaxLanguageCodeFr = "fr"

	// SyntaxLanguageCodeDe is a SyntaxLanguageCode enum value
	SyntaxLanguageCodeDe = "de"

	// SyntaxLanguageCodeIt is a SyntaxLanguageCode enum value
	SyntaxLanguageCodeIt = "it"

	// SyntaxLanguageCodePt is a SyntaxLanguageCode enum value
	SyntaxLanguageCodePt = "pt"
)

// SyntaxLanguageCode_Values returns all elements of the SyntaxLanguageCode enum
func SyntaxLanguageCode_Values() []string {
	return []string{
		SyntaxLanguageCodeEn,
		SyntaxLanguageCodeEs,
		SyntaxLanguageCodeFr,
		SyntaxLanguageCodeDe,
		SyntaxLanguageCodeIt,
		SyntaxLanguageCodePt,
	}
}
