// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package eks

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opCreateCluster = "CreateCluster"

// CreateClusterRequest generates a "aws/request.Request" representing the
// client's request for the CreateCluster operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateCluster for more information on using the CreateCluster
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateClusterRequest method.
//    req, resp := client.CreateClusterRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/CreateCluster
func (c *EKS) CreateClusterRequest(input *CreateClusterInput) (req *request.Request, output *CreateClusterOutput) {
	op := &request.Operation{
		Name:       opCreateCluster,
		HTTPMethod: "POST",
		HTTPPath:   "/clusters",
	}

	if input == nil {
		input = &CreateClusterInput{}
	}

	output = &CreateClusterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateCluster API operation for Amazon Elastic Kubernetes Service.
//
// Creates an Amazon EKS control plane.
//
// The Amazon EKS control plane consists of control plane instances that run
// the Kubernetes software, such as etcd and the API server. The control plane
// runs in an account managed by AWS, and the Kubernetes API is exposed via
// the Amazon EKS API server endpoint. Each Amazon EKS cluster control plane
// is single-tenant and unique and runs on its own set of Amazon EC2 instances.
//
// The cluster control plane is provisioned across multiple Availability Zones
// and fronted by an Elastic Load Balancing Network Load Balancer. Amazon EKS
// also provisions elastic network interfaces in your VPC subnets to provide
// connectivity from the control plane instances to the worker nodes (for example,
// to support kubectl exec, logs, and proxy data flows).
//
// Amazon EKS worker nodes run in your AWS account and connect to your cluster's
// control plane via the Kubernetes API server endpoint and a certificate file
// that is created for your cluster.
//
// You can use the endpointPublicAccess and endpointPrivateAccess parameters
// to enable or disable public and private access to your cluster's Kubernetes
// API server endpoint. By default, public access is enabled, and private access
// is disabled. For more information, see Amazon EKS Cluster Endpoint Access
// Control (https://docs.aws.amazon.com/eks/latest/userguide/cluster-endpoint.html)
// in the Amazon EKS User Guide .
//
// You can use the logging parameter to enable or disable exporting the Kubernetes
// control plane logs for your cluster to CloudWatch Logs. By default, cluster
// control plane logs aren't exported to CloudWatch Logs. For more information,
// see Amazon EKS Cluster Control Plane Logs (https://docs.aws.amazon.com/eks/latest/userguide/control-plane-logs.html)
// in the Amazon EKS User Guide .
//
// CloudWatch Logs ingestion, archive storage, and data scanning rates apply
// to exported control plane logs. For more information, see Amazon CloudWatch
// Pricing (http://aws.amazon.com/cloudwatch/pricing/).
//
// Cluster creation typically takes between 10 and 15 minutes. After you create
// an Amazon EKS cluster, you must configure your Kubernetes tooling to communicate
// with the API server and launch worker nodes into your cluster. For more information,
// see Managing Cluster Authentication (https://docs.aws.amazon.com/eks/latest/userguide/managing-auth.html)
// and Launching Amazon EKS Worker Nodes (https://docs.aws.amazon.com/eks/latest/userguide/launch-workers.html)
// in the Amazon EKS User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Kubernetes Service's
// API operation CreateCluster for usage and error information.
//
// Returned Error Types:
//   * ResourceInUseException
//   The specified resource is in use.
//
//   * ResourceLimitExceededException
//   You have encountered a service limit on the specified resource.
//
//   * InvalidParameterException
//   The specified parameter is invalid. Review the available parameters for the
//   API request.
//
//   * ClientException
//   These errors are usually caused by a client action. Actions can include using
//   an action or resource on behalf of a user that doesn't have permissions to
//   use the action or resource or specifying an identifier that is not valid.
//
//   * ServerException
//   These errors are usually caused by a server-side issue.
//
//   * ServiceUnavailableException
//   The service is unavailable. Back off and retry the operation.
//
//   * UnsupportedAvailabilityZoneException
//   At least one of your specified cluster subnets is in an Availability Zone
//   that does not support Amazon EKS. The exception output specifies the supported
//   Availability Zones for your account, from which you can choose subnets for
//   your cluster.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/CreateCluster
func (c *EKS) CreateCluster(input *CreateClusterInput) (*CreateClusterOutput, error) {
	req, out := c.CreateClusterRequest(input)
	return out, req.Send()
}

// CreateClusterWithContext is the same as CreateCluster with the addition of
// the ability to pass a context and additional request options.
//
// See CreateCluster for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EKS) CreateClusterWithContext(ctx aws.Context, input *CreateClusterInput, opts ...request.Option) (*CreateClusterOutput, error) {
	req, out := c.CreateClusterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateFargateProfile = "CreateFargateProfile"

// CreateFargateProfileRequest generates a "aws/request.Request" representing the
// client's request for the CreateFargateProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateFargateProfile for more information on using the CreateFargateProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateFargateProfileRequest method.
//    req, resp := client.CreateFargateProfileRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/CreateFargateProfile
func (c *EKS) CreateFargateProfileRequest(input *CreateFargateProfileInput) (req *request.Request, output *CreateFargateProfileOutput) {
	op := &request.Operation{
		Name:       opCreateFargateProfile,
		HTTPMethod: "POST",
		HTTPPath:   "/clusters/{name}/fargate-profiles",
	}

	if input == nil {
		input = &CreateFargateProfileInput{}
	}

	output = &CreateFargateProfileOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateFargateProfile API operation for Amazon Elastic Kubernetes Service.
//
// Creates an AWS Fargate profile for your Amazon EKS cluster. You must have
// at least one Fargate profile in a cluster to be able to run pods on Fargate.
//
// The Fargate profile allows an administrator to declare which pods run on
// Fargate and specify which pods run on which Fargate profile. This declaration
// is done through the profile’s selectors. Each profile can have up to five
// selectors that contain a namespace and labels. A namespace is required for
// every selector. The label field consists of multiple optional key-value pairs.
// Pods that match the selectors are scheduled on Fargate. If a to-be-scheduled
// pod matches any of the selectors in the Fargate profile, then that pod is
// run on Fargate.
//
// When you create a Fargate profile, you must specify a pod execution role
// to use with the pods that are scheduled with the profile. This role is added
// to the cluster's Kubernetes Role Based Access Control (https://kubernetes.io/docs/admin/authorization/rbac/)
// (RBAC) for authorization so that the kubelet that is running on the Fargate
// infrastructure can register with your Amazon EKS cluster so that it can appear
// in your cluster as a node. The pod execution role also provides IAM permissions
// to the Fargate infrastructure to allow read access to Amazon ECR image repositories.
// For more information, see Pod Execution Role (https://docs.aws.amazon.com/eks/latest/userguide/pod-execution-role.html)
// in the Amazon EKS User Guide.
//
// Fargate profiles are immutable. However, you can create a new updated profile
// to replace an existing profile and then delete the original after the updated
// profile has finished creating.
//
// If any Fargate profiles in a cluster are in the DELETING status, you must
// wait for that Fargate profile to finish deleting before you can create any
// other profiles in that cluster.
//
// For more information, see AWS Fargate Profile (https://docs.aws.amazon.com/eks/latest/userguide/fargate-profile.html)
// in the Amazon EKS User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Kubernetes Service's
// API operation CreateFargateProfile for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   The specified parameter is invalid. Review the available parameters for the
//   API request.
//
//   * InvalidRequestException
//   The request is invalid given the state of the cluster. Check the state of
//   the cluster and the associated operations.
//
//   * ClientException
//   These errors are usually caused by a client action. Actions can include using
//   an action or resource on behalf of a user that doesn't have permissions to
//   use the action or resource or specifying an identifier that is not valid.
//
//   * ServerException
//   These errors are usually caused by a server-side issue.
//
//   * ResourceLimitExceededException
//   You have encountered a service limit on the specified resource.
//
//   * UnsupportedAvailabilityZoneException
//   At least one of your specified cluster subnets is in an Availability Zone
//   that does not support Amazon EKS. The exception output specifies the supported
//   Availability Zones for your account, from which you can choose subnets for
//   your cluster.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/CreateFargateProfile
func (c *EKS) CreateFargateProfile(input *CreateFargateProfileInput) (*CreateFargateProfileOutput, error) {
	req, out := c.CreateFargateProfileRequest(input)
	return out, req.Send()
}

// CreateFargateProfileWithContext is the same as CreateFargateProfile with the addition of
// the ability to pass a context and additional request options.
//
// See CreateFargateProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EKS) CreateFargateProfileWithContext(ctx aws.Context, input *CreateFargateProfileInput, opts ...request.Option) (*CreateFargateProfileOutput, error) {
	req, out := c.CreateFargateProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateNodegroup = "CreateNodegroup"

// CreateNodegroupRequest generates a "aws/request.Request" representing the
// client's request for the CreateNodegroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateNodegroup for more information on using the CreateNodegroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateNodegroupRequest method.
//    req, resp := client.CreateNodegroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/CreateNodegroup
func (c *EKS) CreateNodegroupRequest(input *CreateNodegroupInput) (req *request.Request, output *CreateNodegroupOutput) {
	op := &request.Operation{
		Name:       opCreateNodegroup,
		HTTPMethod: "POST",
		HTTPPath:   "/clusters/{name}/node-groups",
	}

	if input == nil {
		input = &CreateNodegroupInput{}
	}

	output = &CreateNodegroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateNodegroup API operation for Amazon Elastic Kubernetes Service.
//
// Creates a managed worker node group for an Amazon EKS cluster. You can only
// create a node group for your cluster that is equal to the current Kubernetes
// version for the cluster. All node groups are created with the latest AMI
// release version for the respective minor Kubernetes version of the cluster,
// unless you deploy a custom AMI using a launch template. For more information
// about using launch templates, see Launch template support (https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html).
//
// An Amazon EKS managed node group is an Amazon EC2 Auto Scaling group and
// associated Amazon EC2 instances that are managed by AWS for an Amazon EKS
// cluster. Each node group uses a version of the Amazon EKS-optimized Amazon
// Linux 2 AMI. For more information, see Managed Node Groups (https://docs.aws.amazon.com/eks/latest/userguide/managed-node-groups.html)
// in the Amazon EKS User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Kubernetes Service's
// API operation CreateNodegroup for usage and error information.
//
// Returned Error Types:
//   * ResourceInUseException
//   The specified resource is in use.
//
//   * ResourceLimitExceededException
//   You have encountered a service limit on the specified resource.
//
//   * InvalidRequestException
//   The request is invalid given the state of the cluster. Check the state of
//   the cluster and the associated operations.
//
//   * InvalidParameterException
//   The specified parameter is invalid. Review the available parameters for the
//   API request.
//
//   * ClientException
//   These errors are usually caused by a client action. Actions can include using
//   an action or resource on behalf of a user that doesn't have permissions to
//   use the action or resource or specifying an identifier that is not valid.
//
//   * ServerException
//   These errors are usually caused by a server-side issue.
//
//   * ServiceUnavailableException
//   The service is unavailable. Back off and retry the operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/CreateNodegroup
func (c *EKS) CreateNodegroup(input *CreateNodegroupInput) (*CreateNodegroupOutput, error) {
	req, out := c.CreateNodegroupRequest(input)
	return out, req.Send()
}

// CreateNodegroupWithContext is the same as CreateNodegroup with the addition of
// the ability to pass a context and additional request options.
//
// See CreateNodegroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EKS) CreateNodegroupWithContext(ctx aws.Context, input *CreateNodegroupInput, opts ...request.Option) (*CreateNodegroupOutput, error) {
	req, out := c.CreateNodegroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteCluster = "DeleteCluster"

// DeleteClusterRequest generates a "aws/request.Request" representing the
// client's request for the DeleteCluster operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteCluster for more information on using the DeleteCluster
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteClusterRequest method.
//    req, resp := client.DeleteClusterRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/DeleteCluster
func (c *EKS) DeleteClusterRequest(input *DeleteClusterInput) (req *request.Request, output *DeleteClusterOutput) {
	op := &request.Operation{
		Name:       opDeleteCluster,
		HTTPMethod: "DELETE",
		HTTPPath:   "/clusters/{name}",
	}

	if input == nil {
		input = &DeleteClusterInput{}
	}

	output = &DeleteClusterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteCluster API operation for Amazon Elastic Kubernetes Service.
//
// Deletes the Amazon EKS cluster control plane.
//
// If you have active services in your cluster that are associated with a load
// balancer, you must delete those services before deleting the cluster so that
// the load balancers are deleted properly. Otherwise, you can have orphaned
// resources in your VPC that prevent you from being able to delete the VPC.
// For more information, see Deleting a Cluster (https://docs.aws.amazon.com/eks/latest/userguide/delete-cluster.html)
// in the Amazon EKS User Guide.
//
// If you have managed node groups or Fargate profiles attached to the cluster,
// you must delete them first. For more information, see DeleteNodegroup and
// DeleteFargateProfile.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Kubernetes Service's
// API operation DeleteCluster for usage and error information.
//
// Returned Error Types:
//   * ResourceInUseException
//   The specified resource is in use.
//
//   * ResourceNotFoundException
//   The specified resource could not be found. You can view your available clusters
//   with ListClusters. You can view your available managed node groups with ListNodegroups.
//   Amazon EKS clusters and node groups are Region-specific.
//
//   * ClientException
//   These errors are usually caused by a client action. Actions can include using
//   an action or resource on behalf of a user that doesn't have permissions to
//   use the action or resource or specifying an identifier that is not valid.
//
//   * ServerException
//   These errors are usually caused by a server-side issue.
//
//   * ServiceUnavailableException
//   The service is unavailable. Back off and retry the operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/DeleteCluster
func (c *EKS) DeleteCluster(input *DeleteClusterInput) (*DeleteClusterOutput, error) {
	req, out := c.DeleteClusterRequest(input)
	return out, req.Send()
}

// DeleteClusterWithContext is the same as DeleteCluster with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteCluster for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EKS) DeleteClusterWithContext(ctx aws.Context, input *DeleteClusterInput, opts ...request.Option) (*DeleteClusterOutput, error) {
	req, out := c.DeleteClusterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteFargateProfile = "DeleteFargateProfile"

// DeleteFargateProfileRequest generates a "aws/request.Request" representing the
// client's request for the DeleteFargateProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteFargateProfile for more information on using the DeleteFargateProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteFargateProfileRequest method.
//    req, resp := client.DeleteFargateProfileRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/DeleteFargateProfile
func (c *EKS) DeleteFargateProfileRequest(input *DeleteFargateProfileInput) (req *request.Request, output *DeleteFargateProfileOutput) {
	op := &request.Operation{
		Name:       opDeleteFargateProfile,
		HTTPMethod: "DELETE",
		HTTPPath:   "/clusters/{name}/fargate-profiles/{fargateProfileName}",
	}

	if input == nil {
		input = &DeleteFargateProfileInput{}
	}

	output = &DeleteFargateProfileOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteFargateProfile API operation for Amazon Elastic Kubernetes Service.
//
// Deletes an AWS Fargate profile.
//
// When you delete a Fargate profile, any pods running on Fargate that were
// created with the profile are deleted. If those pods match another Fargate
// profile, then they are scheduled on Fargate with that profile. If they no
// longer match any Fargate profiles, then they are not scheduled on Fargate
// and they may remain in a pending state.
//
// Only one Fargate profile in a cluster can be in the DELETING status at a
// time. You must wait for a Fargate profile to finish deleting before you can
// delete any other profiles in that cluster.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Kubernetes Service's
// API operation DeleteFargateProfile for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   The specified parameter is invalid. Review the available parameters for the
//   API request.
//
//   * ClientException
//   These errors are usually caused by a client action. Actions can include using
//   an action or resource on behalf of a user that doesn't have permissions to
//   use the action or resource or specifying an identifier that is not valid.
//
//   * ServerException
//   These errors are usually caused by a server-side issue.
//
//   * ResourceNotFoundException
//   The specified resource could not be found. You can view your available clusters
//   with ListClusters. You can view your available managed node groups with ListNodegroups.
//   Amazon EKS clusters and node groups are Region-specific.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/DeleteFargateProfile
func (c *EKS) DeleteFargateProfile(input *DeleteFargateProfileInput) (*DeleteFargateProfileOutput, error) {
	req, out := c.DeleteFargateProfileRequest(input)
	return out, req.Send()
}

// DeleteFargateProfileWithContext is the same as DeleteFargateProfile with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteFargateProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EKS) DeleteFargateProfileWithContext(ctx aws.Context, input *DeleteFargateProfileInput, opts ...request.Option) (*DeleteFargateProfileOutput, error) {
	req, out := c.DeleteFargateProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteNodegroup = "DeleteNodegroup"

// DeleteNodegroupRequest generates a "aws/request.Request" representing the
// client's request for the DeleteNodegroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteNodegroup for more information on using the DeleteNodegroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteNodegroupRequest method.
//    req, resp := client.DeleteNodegroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/DeleteNodegroup
func (c *EKS) DeleteNodegroupRequest(input *DeleteNodegroupInput) (req *request.Request, output *DeleteNodegroupOutput) {
	op := &request.Operation{
		Name:       opDeleteNodegroup,
		HTTPMethod: "DELETE",
		HTTPPath:   "/clusters/{name}/node-groups/{nodegroupName}",
	}

	if input == nil {
		input = &DeleteNodegroupInput{}
	}

	output = &DeleteNodegroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteNodegroup API operation for Amazon Elastic Kubernetes Service.
//
// Deletes an Amazon EKS node group for a cluster.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Kubernetes Service's
// API operation DeleteNodegroup for usage and error information.
//
// Returned Error Types:
//   * ResourceInUseException
//   The specified resource is in use.
//
//   * ResourceNotFoundException
//   The specified resource could not be found. You can view your available clusters
//   with ListClusters. You can view your available managed node groups with ListNodegroups.
//   Amazon EKS clusters and node groups are Region-specific.
//
//   * InvalidParameterException
//   The specified parameter is invalid. Review the available parameters for the
//   API request.
//
//   * ClientException
//   These errors are usually caused by a client action. Actions can include using
//   an action or resource on behalf of a user that doesn't have permissions to
//   use the action or resource or specifying an identifier that is not valid.
//
//   * ServerException
//   These errors are usually caused by a server-side issue.
//
//   * ServiceUnavailableException
//   The service is unavailable. Back off and retry the operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/DeleteNodegroup
func (c *EKS) DeleteNodegroup(input *DeleteNodegroupInput) (*DeleteNodegroupOutput, error) {
	req, out := c.DeleteNodegroupRequest(input)
	return out, req.Send()
}

// DeleteNodegroupWithContext is the same as DeleteNodegroup with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteNodegroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EKS) DeleteNodegroupWithContext(ctx aws.Context, input *DeleteNodegroupInput, opts ...request.Option) (*DeleteNodegroupOutput, error) {
	req, out := c.DeleteNodegroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeCluster = "DescribeCluster"

// DescribeClusterRequest generates a "aws/request.Request" representing the
// client's request for the DescribeCluster operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeCluster for more information on using the DescribeCluster
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeClusterRequest method.
//    req, resp := client.DescribeClusterRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/DescribeCluster
func (c *EKS) DescribeClusterRequest(input *DescribeClusterInput) (req *request.Request, output *DescribeClusterOutput) {
	op := &request.Operation{
		Name:       opDescribeCluster,
		HTTPMethod: "GET",
		HTTPPath:   "/clusters/{name}",
	}

	if input == nil {
		input = &DescribeClusterInput{}
	}

	output = &DescribeClusterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeCluster API operation for Amazon Elastic Kubernetes Service.
//
// Returns descriptive information about an Amazon EKS cluster.
//
// The API server endpoint and certificate authority data returned by this operation
// are required for kubelet and kubectl to communicate with your Kubernetes
// API server. For more information, see Create a kubeconfig for Amazon EKS
// (https://docs.aws.amazon.com/eks/latest/userguide/create-kubeconfig.html).
//
// The API server endpoint and certificate authority data aren't available until
// the cluster reaches the ACTIVE state.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Kubernetes Service's
// API operation DescribeCluster for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource could not be found. You can view your available clusters
//   with ListClusters. You can view your available managed node groups with ListNodegroups.
//   Amazon EKS clusters and node groups are Region-specific.
//
//   * ClientException
//   These errors are usually caused by a client action. Actions can include using
//   an action or resource on behalf of a user that doesn't have permissions to
//   use the action or resource or specifying an identifier that is not valid.
//
//   * ServerException
//   These errors are usually caused by a server-side issue.
//
//   * ServiceUnavailableException
//   The service is unavailable. Back off and retry the operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/DescribeCluster
func (c *EKS) DescribeCluster(input *DescribeClusterInput) (*DescribeClusterOutput, error) {
	req, out := c.DescribeClusterRequest(input)
	return out, req.Send()
}

// DescribeClusterWithContext is the same as DescribeCluster with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeCluster for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EKS) DescribeClusterWithContext(ctx aws.Context, input *DescribeClusterInput, opts ...request.Option) (*DescribeClusterOutput, error) {
	req, out := c.DescribeClusterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeFargateProfile = "DescribeFargateProfile"

// DescribeFargateProfileRequest generates a "aws/request.Request" representing the
// client's request for the DescribeFargateProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeFargateProfile for more information on using the DescribeFargateProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeFargateProfileRequest method.
//    req, resp := client.DescribeFargateProfileRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/DescribeFargateProfile
func (c *EKS) DescribeFargateProfileRequest(input *DescribeFargateProfileInput) (req *request.Request, output *DescribeFargateProfileOutput) {
	op := &request.Operation{
		Name:       opDescribeFargateProfile,
		HTTPMethod: "GET",
		HTTPPath:   "/clusters/{name}/fargate-profiles/{fargateProfileName}",
	}

	if input == nil {
		input = &DescribeFargateProfileInput{}
	}

	output = &DescribeFargateProfileOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeFargateProfile API operation for Amazon Elastic Kubernetes Service.
//
// Returns descriptive information about an AWS Fargate profile.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Kubernetes Service's
// API operation DescribeFargateProfile for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   The specified parameter is invalid. Review the available parameters for the
//   API request.
//
//   * ClientException
//   These errors are usually caused by a client action. Actions can include using
//   an action or resource on behalf of a user that doesn't have permissions to
//   use the action or resource or specifying an identifier that is not valid.
//
//   * ServerException
//   These errors are usually caused by a server-side issue.
//
//   * ResourceNotFoundException
//   The specified resource could not be found. You can view your available clusters
//   with ListClusters. You can view your available managed node groups with ListNodegroups.
//   Amazon EKS clusters and node groups are Region-specific.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/DescribeFargateProfile
func (c *EKS) DescribeFargateProfile(input *DescribeFargateProfileInput) (*DescribeFargateProfileOutput, error) {
	req, out := c.DescribeFargateProfileRequest(input)
	return out, req.Send()
}

// DescribeFargateProfileWithContext is the same as DescribeFargateProfile with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeFargateProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EKS) DescribeFargateProfileWithContext(ctx aws.Context, input *DescribeFargateProfileInput, opts ...request.Option) (*DescribeFargateProfileOutput, error) {
	req, out := c.DescribeFargateProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeNodegroup = "DescribeNodegroup"

// DescribeNodegroupRequest generates a "aws/request.Request" representing the
// client's request for the DescribeNodegroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeNodegroup for more information on using the DescribeNodegroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeNodegroupRequest method.
//    req, resp := client.DescribeNodegroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/DescribeNodegroup
func (c *EKS) DescribeNodegroupRequest(input *DescribeNodegroupInput) (req *request.Request, output *DescribeNodegroupOutput) {
	op := &request.Operation{
		Name:       opDescribeNodegroup,
		HTTPMethod: "GET",
		HTTPPath:   "/clusters/{name}/node-groups/{nodegroupName}",
	}

	if input == nil {
		input = &DescribeNodegroupInput{}
	}

	output = &DescribeNodegroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeNodegroup API operation for Amazon Elastic Kubernetes Service.
//
// Returns descriptive information about an Amazon EKS node group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Kubernetes Service's
// API operation DescribeNodegroup for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   The specified parameter is invalid. Review the available parameters for the
//   API request.
//
//   * ResourceNotFoundException
//   The specified resource could not be found. You can view your available clusters
//   with ListClusters. You can view your available managed node groups with ListNodegroups.
//   Amazon EKS clusters and node groups are Region-specific.
//
//   * ClientException
//   These errors are usually caused by a client action. Actions can include using
//   an action or resource on behalf of a user that doesn't have permissions to
//   use the action or resource or specifying an identifier that is not valid.
//
//   * ServerException
//   These errors are usually caused by a server-side issue.
//
//   * ServiceUnavailableException
//   The service is unavailable. Back off and retry the operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/DescribeNodegroup
func (c *EKS) DescribeNodegroup(input *DescribeNodegroupInput) (*DescribeNodegroupOutput, error) {
	req, out := c.DescribeNodegroupRequest(input)
	return out, req.Send()
}

// DescribeNodegroupWithContext is the same as DescribeNodegroup with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeNodegroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EKS) DescribeNodegroupWithContext(ctx aws.Context, input *DescribeNodegroupInput, opts ...request.Option) (*DescribeNodegroupOutput, error) {
	req, out := c.DescribeNodegroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeUpdate = "DescribeUpdate"

// DescribeUpdateRequest generates a "aws/request.Request" representing the
// client's request for the DescribeUpdate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeUpdate for more information on using the DescribeUpdate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeUpdateRequest method.
//    req, resp := client.DescribeUpdateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/DescribeUpdate
func (c *EKS) DescribeUpdateRequest(input *DescribeUpdateInput) (req *request.Request, output *DescribeUpdateOutput) {
	op := &request.Operation{
		Name:       opDescribeUpdate,
		HTTPMethod: "GET",
		HTTPPath:   "/clusters/{name}/updates/{updateId}",
	}

	if input == nil {
		input = &DescribeUpdateInput{}
	}

	output = &DescribeUpdateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeUpdate API operation for Amazon Elastic Kubernetes Service.
//
// Returns descriptive information about an update against your Amazon EKS cluster
// or associated managed node group.
//
// When the status of the update is Succeeded, the update is complete. If an
// update fails, the status is Failed, and an error detail explains the reason
// for the failure.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Kubernetes Service's
// API operation DescribeUpdate for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   The specified parameter is invalid. Review the available parameters for the
//   API request.
//
//   * ClientException
//   These errors are usually caused by a client action. Actions can include using
//   an action or resource on behalf of a user that doesn't have permissions to
//   use the action or resource or specifying an identifier that is not valid.
//
//   * ServerException
//   These errors are usually caused by a server-side issue.
//
//   * ResourceNotFoundException
//   The specified resource could not be found. You can view your available clusters
//   with ListClusters. You can view your available managed node groups with ListNodegroups.
//   Amazon EKS clusters and node groups are Region-specific.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/DescribeUpdate
func (c *EKS) DescribeUpdate(input *DescribeUpdateInput) (*DescribeUpdateOutput, error) {
	req, out := c.DescribeUpdateRequest(input)
	return out, req.Send()
}

// DescribeUpdateWithContext is the same as DescribeUpdate with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeUpdate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EKS) DescribeUpdateWithContext(ctx aws.Context, input *DescribeUpdateInput, opts ...request.Option) (*DescribeUpdateOutput, error) {
	req, out := c.DescribeUpdateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListClusters = "ListClusters"

// ListClustersRequest generates a "aws/request.Request" representing the
// client's request for the ListClusters operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListClusters for more information on using the ListClusters
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListClustersRequest method.
//    req, resp := client.ListClustersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/ListClusters
func (c *EKS) ListClustersRequest(input *ListClustersInput) (req *request.Request, output *ListClustersOutput) {
	op := &request.Operation{
		Name:       opListClusters,
		HTTPMethod: "GET",
		HTTPPath:   "/clusters",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListClustersInput{}
	}

	output = &ListClustersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListClusters API operation for Amazon Elastic Kubernetes Service.
//
// Lists the Amazon EKS clusters in your AWS account in the specified Region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Kubernetes Service's
// API operation ListClusters for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   The specified parameter is invalid. Review the available parameters for the
//   API request.
//
//   * ClientException
//   These errors are usually caused by a client action. Actions can include using
//   an action or resource on behalf of a user that doesn't have permissions to
//   use the action or resource or specifying an identifier that is not valid.
//
//   * ServerException
//   These errors are usually caused by a server-side issue.
//
//   * ServiceUnavailableException
//   The service is unavailable. Back off and retry the operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/ListClusters
func (c *EKS) ListClusters(input *ListClustersInput) (*ListClustersOutput, error) {
	req, out := c.ListClustersRequest(input)
	return out, req.Send()
}

// ListClustersWithContext is the same as ListClusters with the addition of
// the ability to pass a context and additional request options.
//
// See ListClusters for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EKS) ListClustersWithContext(ctx aws.Context, input *ListClustersInput, opts ...request.Option) (*ListClustersOutput, error) {
	req, out := c.ListClustersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListClustersPages iterates over the pages of a ListClusters operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListClusters method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListClusters operation.
//    pageNum := 0
//    err := client.ListClustersPages(params,
//        func(page *eks.ListClustersOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *EKS) ListClustersPages(input *ListClustersInput, fn func(*ListClustersOutput, bool) bool) error {
	return c.ListClustersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListClustersPagesWithContext same as ListClustersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EKS) ListClustersPagesWithContext(ctx aws.Context, input *ListClustersInput, fn func(*ListClustersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListClustersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListClustersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListClustersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListFargateProfiles = "ListFargateProfiles"

// ListFargateProfilesRequest generates a "aws/request.Request" representing the
// client's request for the ListFargateProfiles operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListFargateProfiles for more information on using the ListFargateProfiles
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListFargateProfilesRequest method.
//    req, resp := client.ListFargateProfilesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/ListFargateProfiles
func (c *EKS) ListFargateProfilesRequest(input *ListFargateProfilesInput) (req *request.Request, output *ListFargateProfilesOutput) {
	op := &request.Operation{
		Name:       opListFargateProfiles,
		HTTPMethod: "GET",
		HTTPPath:   "/clusters/{name}/fargate-profiles",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListFargateProfilesInput{}
	}

	output = &ListFargateProfilesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListFargateProfiles API operation for Amazon Elastic Kubernetes Service.
//
// Lists the AWS Fargate profiles associated with the specified cluster in your
// AWS account in the specified Region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Kubernetes Service's
// API operation ListFargateProfiles for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   The specified parameter is invalid. Review the available parameters for the
//   API request.
//
//   * ResourceNotFoundException
//   The specified resource could not be found. You can view your available clusters
//   with ListClusters. You can view your available managed node groups with ListNodegroups.
//   Amazon EKS clusters and node groups are Region-specific.
//
//   * ClientException
//   These errors are usually caused by a client action. Actions can include using
//   an action or resource on behalf of a user that doesn't have permissions to
//   use the action or resource or specifying an identifier that is not valid.
//
//   * ServerException
//   These errors are usually caused by a server-side issue.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/ListFargateProfiles
func (c *EKS) ListFargateProfiles(input *ListFargateProfilesInput) (*ListFargateProfilesOutput, error) {
	req, out := c.ListFargateProfilesRequest(input)
	return out, req.Send()
}

// ListFargateProfilesWithContext is the same as ListFargateProfiles with the addition of
// the ability to pass a context and additional request options.
//
// See ListFargateProfiles for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EKS) ListFargateProfilesWithContext(ctx aws.Context, input *ListFargateProfilesInput, opts ...request.Option) (*ListFargateProfilesOutput, error) {
	req, out := c.ListFargateProfilesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListFargateProfilesPages iterates over the pages of a ListFargateProfiles operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListFargateProfiles method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListFargateProfiles operation.
//    pageNum := 0
//    err := client.ListFargateProfilesPages(params,
//        func(page *eks.ListFargateProfilesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *EKS) ListFargateProfilesPages(input *ListFargateProfilesInput, fn func(*ListFargateProfilesOutput, bool) bool) error {
	return c.ListFargateProfilesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListFargateProfilesPagesWithContext same as ListFargateProfilesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EKS) ListFargateProfilesPagesWithContext(ctx aws.Context, input *ListFargateProfilesInput, fn func(*ListFargateProfilesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListFargateProfilesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListFargateProfilesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListFargateProfilesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListNodegroups = "ListNodegroups"

// ListNodegroupsRequest generates a "aws/request.Request" representing the
// client's request for the ListNodegroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListNodegroups for more information on using the ListNodegroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListNodegroupsRequest method.
//    req, resp := client.ListNodegroupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/ListNodegroups
func (c *EKS) ListNodegroupsRequest(input *ListNodegroupsInput) (req *request.Request, output *ListNodegroupsOutput) {
	op := &request.Operation{
		Name:       opListNodegroups,
		HTTPMethod: "GET",
		HTTPPath:   "/clusters/{name}/node-groups",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListNodegroupsInput{}
	}

	output = &ListNodegroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListNodegroups API operation for Amazon Elastic Kubernetes Service.
//
// Lists the Amazon EKS managed node groups associated with the specified cluster
// in your AWS account in the specified Region. Self-managed node groups are
// not listed.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Kubernetes Service's
// API operation ListNodegroups for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   The specified parameter is invalid. Review the available parameters for the
//   API request.
//
//   * ClientException
//   These errors are usually caused by a client action. Actions can include using
//   an action or resource on behalf of a user that doesn't have permissions to
//   use the action or resource or specifying an identifier that is not valid.
//
//   * ServerException
//   These errors are usually caused by a server-side issue.
//
//   * ServiceUnavailableException
//   The service is unavailable. Back off and retry the operation.
//
//   * ResourceNotFoundException
//   The specified resource could not be found. You can view your available clusters
//   with ListClusters. You can view your available managed node groups with ListNodegroups.
//   Amazon EKS clusters and node groups are Region-specific.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/ListNodegroups
func (c *EKS) ListNodegroups(input *ListNodegroupsInput) (*ListNodegroupsOutput, error) {
	req, out := c.ListNodegroupsRequest(input)
	return out, req.Send()
}

// ListNodegroupsWithContext is the same as ListNodegroups with the addition of
// the ability to pass a context and additional request options.
//
// See ListNodegroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EKS) ListNodegroupsWithContext(ctx aws.Context, input *ListNodegroupsInput, opts ...request.Option) (*ListNodegroupsOutput, error) {
	req, out := c.ListNodegroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListNodegroupsPages iterates over the pages of a ListNodegroups operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListNodegroups method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListNodegroups operation.
//    pageNum := 0
//    err := client.ListNodegroupsPages(params,
//        func(page *eks.ListNodegroupsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *EKS) ListNodegroupsPages(input *ListNodegroupsInput, fn func(*ListNodegroupsOutput, bool) bool) error {
	return c.ListNodegroupsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListNodegroupsPagesWithContext same as ListNodegroupsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EKS) ListNodegroupsPagesWithContext(ctx aws.Context, input *ListNodegroupsInput, fn func(*ListNodegroupsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListNodegroupsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListNodegroupsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListNodegroupsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsForResourceRequest method.
//    req, resp := client.ListTagsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/ListTagsForResource
func (c *EKS) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for Amazon Elastic Kubernetes Service.
//
// List the tags for an Amazon EKS resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Kubernetes Service's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   This exception is thrown if the request contains a semantic error. The precise
//   meaning will depend on the API, and will be documented in the error message.
//
//   * NotFoundException
//   A service resource associated with the request could not be found. Clients
//   should not retry such requests.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/ListTagsForResource
func (c *EKS) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EKS) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListUpdates = "ListUpdates"

// ListUpdatesRequest generates a "aws/request.Request" representing the
// client's request for the ListUpdates operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListUpdates for more information on using the ListUpdates
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListUpdatesRequest method.
//    req, resp := client.ListUpdatesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/ListUpdates
func (c *EKS) ListUpdatesRequest(input *ListUpdatesInput) (req *request.Request, output *ListUpdatesOutput) {
	op := &request.Operation{
		Name:       opListUpdates,
		HTTPMethod: "GET",
		HTTPPath:   "/clusters/{name}/updates",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListUpdatesInput{}
	}

	output = &ListUpdatesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListUpdates API operation for Amazon Elastic Kubernetes Service.
//
// Lists the updates associated with an Amazon EKS cluster or managed node group
// in your AWS account, in the specified Region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Kubernetes Service's
// API operation ListUpdates for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   The specified parameter is invalid. Review the available parameters for the
//   API request.
//
//   * ClientException
//   These errors are usually caused by a client action. Actions can include using
//   an action or resource on behalf of a user that doesn't have permissions to
//   use the action or resource or specifying an identifier that is not valid.
//
//   * ServerException
//   These errors are usually caused by a server-side issue.
//
//   * ResourceNotFoundException
//   The specified resource could not be found. You can view your available clusters
//   with ListClusters. You can view your available managed node groups with ListNodegroups.
//   Amazon EKS clusters and node groups are Region-specific.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/ListUpdates
func (c *EKS) ListUpdates(input *ListUpdatesInput) (*ListUpdatesOutput, error) {
	req, out := c.ListUpdatesRequest(input)
	return out, req.Send()
}

// ListUpdatesWithContext is the same as ListUpdates with the addition of
// the ability to pass a context and additional request options.
//
// See ListUpdates for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EKS) ListUpdatesWithContext(ctx aws.Context, input *ListUpdatesInput, opts ...request.Option) (*ListUpdatesOutput, error) {
	req, out := c.ListUpdatesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListUpdatesPages iterates over the pages of a ListUpdates operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListUpdates method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListUpdates operation.
//    pageNum := 0
//    err := client.ListUpdatesPages(params,
//        func(page *eks.ListUpdatesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *EKS) ListUpdatesPages(input *ListUpdatesInput, fn func(*ListUpdatesOutput, bool) bool) error {
	return c.ListUpdatesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListUpdatesPagesWithContext same as ListUpdatesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EKS) ListUpdatesPagesWithContext(ctx aws.Context, input *ListUpdatesInput, fn func(*ListUpdatesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListUpdatesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListUpdatesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListUpdatesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TagResourceRequest method.
//    req, resp := client.TagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/TagResource
func (c *EKS) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for Amazon Elastic Kubernetes Service.
//
// Associates the specified tags to a resource with the specified resourceArn.
// If existing tags on a resource are not specified in the request parameters,
// they are not changed. When a resource is deleted, the tags associated with
// that resource are deleted as well. Tags that you create for Amazon EKS resources
// do not propagate to any other resources associated with the cluster. For
// example, if you tag a cluster with this operation, that tag does not automatically
// propagate to the subnets and worker nodes associated with the cluster.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Kubernetes Service's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   This exception is thrown if the request contains a semantic error. The precise
//   meaning will depend on the API, and will be documented in the error message.
//
//   * NotFoundException
//   A service resource associated with the request could not be found. Clients
//   should not retry such requests.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/TagResource
func (c *EKS) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EKS) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UntagResourceRequest method.
//    req, resp := client.UntagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/UntagResource
func (c *EKS) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for Amazon Elastic Kubernetes Service.
//
// Deletes specified tags from a resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Kubernetes Service's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   This exception is thrown if the request contains a semantic error. The precise
//   meaning will depend on the API, and will be documented in the error message.
//
//   * NotFoundException
//   A service resource associated with the request could not be found. Clients
//   should not retry such requests.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/UntagResource
func (c *EKS) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EKS) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateClusterConfig = "UpdateClusterConfig"

// UpdateClusterConfigRequest generates a "aws/request.Request" representing the
// client's request for the UpdateClusterConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateClusterConfig for more information on using the UpdateClusterConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateClusterConfigRequest method.
//    req, resp := client.UpdateClusterConfigRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/UpdateClusterConfig
func (c *EKS) UpdateClusterConfigRequest(input *UpdateClusterConfigInput) (req *request.Request, output *UpdateClusterConfigOutput) {
	op := &request.Operation{
		Name:       opUpdateClusterConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/clusters/{name}/update-config",
	}

	if input == nil {
		input = &UpdateClusterConfigInput{}
	}

	output = &UpdateClusterConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateClusterConfig API operation for Amazon Elastic Kubernetes Service.
//
// Updates an Amazon EKS cluster configuration. Your cluster continues to function
// during the update. The response output includes an update ID that you can
// use to track the status of your cluster update with the DescribeUpdate API
// operation.
//
// You can use this API operation to enable or disable exporting the Kubernetes
// control plane logs for your cluster to CloudWatch Logs. By default, cluster
// control plane logs aren't exported to CloudWatch Logs. For more information,
// see Amazon EKS Cluster Control Plane Logs (https://docs.aws.amazon.com/eks/latest/userguide/control-plane-logs.html)
// in the Amazon EKS User Guide .
//
// CloudWatch Logs ingestion, archive storage, and data scanning rates apply
// to exported control plane logs. For more information, see Amazon CloudWatch
// Pricing (http://aws.amazon.com/cloudwatch/pricing/).
//
// You can also use this API operation to enable or disable public and private
// access to your cluster's Kubernetes API server endpoint. By default, public
// access is enabled, and private access is disabled. For more information,
// see Amazon EKS Cluster Endpoint Access Control (https://docs.aws.amazon.com/eks/latest/userguide/cluster-endpoint.html)
// in the Amazon EKS User Guide .
//
// At this time, you can not update the subnets or security group IDs for an
// existing cluster.
//
// Cluster updates are asynchronous, and they should finish within a few minutes.
// During an update, the cluster status moves to UPDATING (this status transition
// is eventually consistent). When the update is complete (either Failed or
// Successful), the cluster status moves to Active.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Kubernetes Service's
// API operation UpdateClusterConfig for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   The specified parameter is invalid. Review the available parameters for the
//   API request.
//
//   * ClientException
//   These errors are usually caused by a client action. Actions can include using
//   an action or resource on behalf of a user that doesn't have permissions to
//   use the action or resource or specifying an identifier that is not valid.
//
//   * ServerException
//   These errors are usually caused by a server-side issue.
//
//   * ResourceInUseException
//   The specified resource is in use.
//
//   * ResourceNotFoundException
//   The specified resource could not be found. You can view your available clusters
//   with ListClusters. You can view your available managed node groups with ListNodegroups.
//   Amazon EKS clusters and node groups are Region-specific.
//
//   * InvalidRequestException
//   The request is invalid given the state of the cluster. Check the state of
//   the cluster and the associated operations.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/UpdateClusterConfig
func (c *EKS) UpdateClusterConfig(input *UpdateClusterConfigInput) (*UpdateClusterConfigOutput, error) {
	req, out := c.UpdateClusterConfigRequest(input)
	return out, req.Send()
}

// UpdateClusterConfigWithContext is the same as UpdateClusterConfig with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateClusterConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EKS) UpdateClusterConfigWithContext(ctx aws.Context, input *UpdateClusterConfigInput, opts ...request.Option) (*UpdateClusterConfigOutput, error) {
	req, out := c.UpdateClusterConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateClusterVersion = "UpdateClusterVersion"

// UpdateClusterVersionRequest generates a "aws/request.Request" representing the
// client's request for the UpdateClusterVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateClusterVersion for more information on using the UpdateClusterVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateClusterVersionRequest method.
//    req, resp := client.UpdateClusterVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/UpdateClusterVersion
func (c *EKS) UpdateClusterVersionRequest(input *UpdateClusterVersionInput) (req *request.Request, output *UpdateClusterVersionOutput) {
	op := &request.Operation{
		Name:       opUpdateClusterVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/clusters/{name}/updates",
	}

	if input == nil {
		input = &UpdateClusterVersionInput{}
	}

	output = &UpdateClusterVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateClusterVersion API operation for Amazon Elastic Kubernetes Service.
//
// Updates an Amazon EKS cluster to the specified Kubernetes version. Your cluster
// continues to function during the update. The response output includes an
// update ID that you can use to track the status of your cluster update with
// the DescribeUpdate API operation.
//
// Cluster updates are asynchronous, and they should finish within a few minutes.
// During an update, the cluster status moves to UPDATING (this status transition
// is eventually consistent). When the update is complete (either Failed or
// Successful), the cluster status moves to Active.
//
// If your cluster has managed node groups attached to it, all of your node
// groups’ Kubernetes versions must match the cluster’s Kubernetes version
// in order to update the cluster to a new Kubernetes version.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Kubernetes Service's
// API operation UpdateClusterVersion for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   The specified parameter is invalid. Review the available parameters for the
//   API request.
//
//   * ClientException
//   These errors are usually caused by a client action. Actions can include using
//   an action or resource on behalf of a user that doesn't have permissions to
//   use the action or resource or specifying an identifier that is not valid.
//
//   * ServerException
//   These errors are usually caused by a server-side issue.
//
//   * ResourceInUseException
//   The specified resource is in use.
//
//   * ResourceNotFoundException
//   The specified resource could not be found. You can view your available clusters
//   with ListClusters. You can view your available managed node groups with ListNodegroups.
//   Amazon EKS clusters and node groups are Region-specific.
//
//   * InvalidRequestException
//   The request is invalid given the state of the cluster. Check the state of
//   the cluster and the associated operations.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/UpdateClusterVersion
func (c *EKS) UpdateClusterVersion(input *UpdateClusterVersionInput) (*UpdateClusterVersionOutput, error) {
	req, out := c.UpdateClusterVersionRequest(input)
	return out, req.Send()
}

// UpdateClusterVersionWithContext is the same as UpdateClusterVersion with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateClusterVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EKS) UpdateClusterVersionWithContext(ctx aws.Context, input *UpdateClusterVersionInput, opts ...request.Option) (*UpdateClusterVersionOutput, error) {
	req, out := c.UpdateClusterVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateNodegroupConfig = "UpdateNodegroupConfig"

// UpdateNodegroupConfigRequest generates a "aws/request.Request" representing the
// client's request for the UpdateNodegroupConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateNodegroupConfig for more information on using the UpdateNodegroupConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateNodegroupConfigRequest method.
//    req, resp := client.UpdateNodegroupConfigRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/UpdateNodegroupConfig
func (c *EKS) UpdateNodegroupConfigRequest(input *UpdateNodegroupConfigInput) (req *request.Request, output *UpdateNodegroupConfigOutput) {
	op := &request.Operation{
		Name:       opUpdateNodegroupConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/clusters/{name}/node-groups/{nodegroupName}/update-config",
	}

	if input == nil {
		input = &UpdateNodegroupConfigInput{}
	}

	output = &UpdateNodegroupConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateNodegroupConfig API operation for Amazon Elastic Kubernetes Service.
//
// Updates an Amazon EKS managed node group configuration. Your node group continues
// to function during the update. The response output includes an update ID
// that you can use to track the status of your node group update with the DescribeUpdate
// API operation. Currently you can update the Kubernetes labels for a node
// group or the scaling configuration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Kubernetes Service's
// API operation UpdateNodegroupConfig for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   The specified parameter is invalid. Review the available parameters for the
//   API request.
//
//   * ClientException
//   These errors are usually caused by a client action. Actions can include using
//   an action or resource on behalf of a user that doesn't have permissions to
//   use the action or resource or specifying an identifier that is not valid.
//
//   * ServerException
//   These errors are usually caused by a server-side issue.
//
//   * ResourceInUseException
//   The specified resource is in use.
//
//   * ResourceNotFoundException
//   The specified resource could not be found. You can view your available clusters
//   with ListClusters. You can view your available managed node groups with ListNodegroups.
//   Amazon EKS clusters and node groups are Region-specific.
//
//   * InvalidRequestException
//   The request is invalid given the state of the cluster. Check the state of
//   the cluster and the associated operations.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/UpdateNodegroupConfig
func (c *EKS) UpdateNodegroupConfig(input *UpdateNodegroupConfigInput) (*UpdateNodegroupConfigOutput, error) {
	req, out := c.UpdateNodegroupConfigRequest(input)
	return out, req.Send()
}

// UpdateNodegroupConfigWithContext is the same as UpdateNodegroupConfig with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateNodegroupConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EKS) UpdateNodegroupConfigWithContext(ctx aws.Context, input *UpdateNodegroupConfigInput, opts ...request.Option) (*UpdateNodegroupConfigOutput, error) {
	req, out := c.UpdateNodegroupConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateNodegroupVersion = "UpdateNodegroupVersion"

// UpdateNodegroupVersionRequest generates a "aws/request.Request" representing the
// client's request for the UpdateNodegroupVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateNodegroupVersion for more information on using the UpdateNodegroupVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateNodegroupVersionRequest method.
//    req, resp := client.UpdateNodegroupVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/UpdateNodegroupVersion
func (c *EKS) UpdateNodegroupVersionRequest(input *UpdateNodegroupVersionInput) (req *request.Request, output *UpdateNodegroupVersionOutput) {
	op := &request.Operation{
		Name:       opUpdateNodegroupVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/clusters/{name}/node-groups/{nodegroupName}/update-version",
	}

	if input == nil {
		input = &UpdateNodegroupVersionInput{}
	}

	output = &UpdateNodegroupVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateNodegroupVersion API operation for Amazon Elastic Kubernetes Service.
//
// Updates the Kubernetes version or AMI version of an Amazon EKS managed node
// group.
//
// You can update a node group using a launch template only if the node group
// was originally deployed with a launch template. If you need to update a custom
// AMI in a node group that was deployed with a launch template, then update
// your custom AMI, specify the new ID in a new version of the launch template,
// and then update the node group to the new version of the launch template.
//
// If you update without a launch template, then you can update to the latest
// available AMI version of a node group's current Kubernetes version by not
// specifying a Kubernetes version in the request. You can update to the latest
// AMI version of your cluster's current Kubernetes version by specifying your
// cluster's Kubernetes version in the request. For more information, see Amazon
// EKS-Optimized Linux AMI Versions (https://docs.aws.amazon.com/eks/latest/userguide/eks-linux-ami-versions.html)
// in the Amazon EKS User Guide.
//
// You cannot roll back a node group to an earlier Kubernetes version or AMI
// version.
//
// When a node in a managed node group is terminated due to a scaling action
// or update, the pods in that node are drained first. Amazon EKS attempts to
// drain the nodes gracefully and will fail if it is unable to do so. You can
// force the update if Amazon EKS is unable to drain the nodes as a result of
// a pod disruption budget issue.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Kubernetes Service's
// API operation UpdateNodegroupVersion for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   The specified parameter is invalid. Review the available parameters for the
//   API request.
//
//   * ClientException
//   These errors are usually caused by a client action. Actions can include using
//   an action or resource on behalf of a user that doesn't have permissions to
//   use the action or resource or specifying an identifier that is not valid.
//
//   * ServerException
//   These errors are usually caused by a server-side issue.
//
//   * ResourceInUseException
//   The specified resource is in use.
//
//   * ResourceNotFoundException
//   The specified resource could not be found. You can view your available clusters
//   with ListClusters. You can view your available managed node groups with ListNodegroups.
//   Amazon EKS clusters and node groups are Region-specific.
//
//   * InvalidRequestException
//   The request is invalid given the state of the cluster. Check the state of
//   the cluster and the associated operations.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/UpdateNodegroupVersion
func (c *EKS) UpdateNodegroupVersion(input *UpdateNodegroupVersionInput) (*UpdateNodegroupVersionOutput, error) {
	req, out := c.UpdateNodegroupVersionRequest(input)
	return out, req.Send()
}

// UpdateNodegroupVersionWithContext is the same as UpdateNodegroupVersion with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateNodegroupVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EKS) UpdateNodegroupVersionWithContext(ctx aws.Context, input *UpdateNodegroupVersionInput, opts ...request.Option) (*UpdateNodegroupVersionOutput, error) {
	req, out := c.UpdateNodegroupVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// An Auto Scaling group that is associated with an Amazon EKS managed node
// group.
type AutoScalingGroup struct {
	_ struct{} `type:"structure"`

	// The name of the Auto Scaling group associated with an Amazon EKS managed
	// node group.
	Name *string `locationName:"name" type:"string"`
}

// String returns the string representation
func (s AutoScalingGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AutoScalingGroup) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *AutoScalingGroup) SetName(v string) *AutoScalingGroup {
	s.Name = &v
	return s
}

// This exception is thrown if the request contains a semantic error. The precise
// meaning will depend on the API, and will be documented in the error message.
type BadRequestException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s BadRequestException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BadRequestException) GoString() string {
	return s.String()
}

func newErrorBadRequestException(v protocol.ResponseMetadata) error {
	return &BadRequestException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *BadRequestException) Code() string {
	return "BadRequestException"
}

// Message returns the exception's message.
func (s *BadRequestException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *BadRequestException) OrigErr() error {
	return nil
}

func (s *BadRequestException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *BadRequestException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *BadRequestException) RequestID() string {
	return s.RespMetadata.RequestID
}

// An object representing the certificate-authority-data for your cluster.
type Certificate struct {
	_ struct{} `type:"structure"`

	// The Base64-encoded certificate data required to communicate with your cluster.
	// Add this to the certificate-authority-data section of the kubeconfig file
	// for your cluster.
	Data *string `locationName:"data" type:"string"`
}

// String returns the string representation
func (s Certificate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Certificate) GoString() string {
	return s.String()
}

// SetData sets the Data field's value.
func (s *Certificate) SetData(v string) *Certificate {
	s.Data = &v
	return s
}

// These errors are usually caused by a client action. Actions can include using
// an action or resource on behalf of a user that doesn't have permissions to
// use the action or resource or specifying an identifier that is not valid.
type ClientException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The Amazon EKS cluster associated with the exception.
	ClusterName *string `locationName:"clusterName" type:"string"`

	Message_ *string `locationName:"message" type:"string"`

	// The Amazon EKS managed node group associated with the exception.
	NodegroupName *string `locationName:"nodegroupName" type:"string"`
}

// String returns the string representation
func (s ClientException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ClientException) GoString() string {
	return s.String()
}

func newErrorClientException(v protocol.ResponseMetadata) error {
	return &ClientException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ClientException) Code() string {
	return "ClientException"
}

// Message returns the exception's message.
func (s *ClientException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ClientException) OrigErr() error {
	return nil
}

func (s *ClientException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ClientException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ClientException) RequestID() string {
	return s.RespMetadata.RequestID
}

// An object representing an Amazon EKS cluster.
type Cluster struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the cluster.
	Arn *string `locationName:"arn" type:"string"`

	// The certificate-authority-data for your cluster.
	CertificateAuthority *Certificate `locationName:"certificateAuthority" type:"structure"`

	// Unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request.
	ClientRequestToken *string `locationName:"clientRequestToken" type:"string"`

	// The Unix epoch timestamp in seconds for when the cluster was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// The encryption configuration for the cluster.
	EncryptionConfig []*EncryptionConfig `locationName:"encryptionConfig" type:"list"`

	// The endpoint for your Kubernetes API server.
	Endpoint *string `locationName:"endpoint" type:"string"`

	// The identity provider information for the cluster.
	Identity *Identity `locationName:"identity" type:"structure"`

	// Network configuration settings for your cluster.
	KubernetesNetworkConfig *KubernetesNetworkConfigResponse `locationName:"kubernetesNetworkConfig" type:"structure"`

	// The logging configuration for your cluster.
	Logging *Logging `locationName:"logging" type:"structure"`

	// The name of the cluster.
	Name *string `locationName:"name" type:"string"`

	// The platform version of your Amazon EKS cluster. For more information, see
	// Platform Versions (https://docs.aws.amazon.com/eks/latest/userguide/platform-versions.html)
	// in the Amazon EKS User Guide .
	PlatformVersion *string `locationName:"platformVersion" type:"string"`

	// The VPC configuration used by the cluster control plane. Amazon EKS VPC resources
	// have specific requirements to work properly with Kubernetes. For more information,
	// see Cluster VPC Considerations (https://docs.aws.amazon.com/eks/latest/userguide/network_reqs.html)
	// and Cluster Security Group Considerations (https://docs.aws.amazon.com/eks/latest/userguide/sec-group-reqs.html)
	// in the Amazon EKS User Guide.
	ResourcesVpcConfig *VpcConfigResponse `locationName:"resourcesVpcConfig" type:"structure"`

	// The Amazon Resource Name (ARN) of the IAM role that provides permissions
	// for the Kubernetes control plane to make calls to AWS API operations on your
	// behalf.
	RoleArn *string `locationName:"roleArn" type:"string"`

	// The current status of the cluster.
	Status *string `locationName:"status" type:"string" enum:"ClusterStatus"`

	// The metadata that you apply to the cluster to assist with categorization
	// and organization. Each tag consists of a key and an optional value, both
	// of which you define. Cluster tags do not propagate to any other resources
	// associated with the cluster.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map"`

	// The Kubernetes server version for the cluster.
	Version *string `locationName:"version" type:"string"`
}

// String returns the string representation
func (s Cluster) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Cluster) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Cluster) SetArn(v string) *Cluster {
	s.Arn = &v
	return s
}

// SetCertificateAuthority sets the CertificateAuthority field's value.
func (s *Cluster) SetCertificateAuthority(v *Certificate) *Cluster {
	s.CertificateAuthority = v
	return s
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *Cluster) SetClientRequestToken(v string) *Cluster {
	s.ClientRequestToken = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *Cluster) SetCreatedAt(v time.Time) *Cluster {
	s.CreatedAt = &v
	return s
}

// SetEncryptionConfig sets the EncryptionConfig field's value.
func (s *Cluster) SetEncryptionConfig(v []*EncryptionConfig) *Cluster {
	s.EncryptionConfig = v
	return s
}

// SetEndpoint sets the Endpoint field's value.
func (s *Cluster) SetEndpoint(v string) *Cluster {
	s.Endpoint = &v
	return s
}

// SetIdentity sets the Identity field's value.
func (s *Cluster) SetIdentity(v *Identity) *Cluster {
	s.Identity = v
	return s
}

// SetKubernetesNetworkConfig sets the KubernetesNetworkConfig field's value.
func (s *Cluster) SetKubernetesNetworkConfig(v *KubernetesNetworkConfigResponse) *Cluster {
	s.KubernetesNetworkConfig = v
	return s
}

// SetLogging sets the Logging field's value.
func (s *Cluster) SetLogging(v *Logging) *Cluster {
	s.Logging = v
	return s
}

// SetName sets the Name field's value.
func (s *Cluster) SetName(v string) *Cluster {
	s.Name = &v
	return s
}

// SetPlatformVersion sets the PlatformVersion field's value.
func (s *Cluster) SetPlatformVersion(v string) *Cluster {
	s.PlatformVersion = &v
	return s
}

// SetResourcesVpcConfig sets the ResourcesVpcConfig field's value.
func (s *Cluster) SetResourcesVpcConfig(v *VpcConfigResponse) *Cluster {
	s.ResourcesVpcConfig = v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *Cluster) SetRoleArn(v string) *Cluster {
	s.RoleArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *Cluster) SetStatus(v string) *Cluster {
	s.Status = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *Cluster) SetTags(v map[string]*string) *Cluster {
	s.Tags = v
	return s
}

// SetVersion sets the Version field's value.
func (s *Cluster) SetVersion(v string) *Cluster {
	s.Version = &v
	return s
}

type CreateClusterInput struct {
	_ struct{} `type:"structure"`

	// Unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request.
	ClientRequestToken *string `locationName:"clientRequestToken" type:"string" idempotencyToken:"true"`

	// The encryption configuration for the cluster.
	EncryptionConfig []*EncryptionConfig `locationName:"encryptionConfig" type:"list"`

	// The Kubernetes network configuration for the cluster.
	KubernetesNetworkConfig *KubernetesNetworkConfigRequest `locationName:"kubernetesNetworkConfig" type:"structure"`

	// Enable or disable exporting the Kubernetes control plane logs for your cluster
	// to CloudWatch Logs. By default, cluster control plane logs aren't exported
	// to CloudWatch Logs. For more information, see Amazon EKS Cluster Control
	// Plane Logs (https://docs.aws.amazon.com/eks/latest/userguide/control-plane-logs.html)
	// in the Amazon EKS User Guide .
	//
	// CloudWatch Logs ingestion, archive storage, and data scanning rates apply
	// to exported control plane logs. For more information, see Amazon CloudWatch
	// Pricing (http://aws.amazon.com/cloudwatch/pricing/).
	Logging *Logging `locationName:"logging" type:"structure"`

	// The unique name to give to your cluster.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The VPC configuration used by the cluster control plane. Amazon EKS VPC resources
	// have specific requirements to work properly with Kubernetes. For more information,
	// see Cluster VPC Considerations (https://docs.aws.amazon.com/eks/latest/userguide/network_reqs.html)
	// and Cluster Security Group Considerations (https://docs.aws.amazon.com/eks/latest/userguide/sec-group-reqs.html)
	// in the Amazon EKS User Guide. You must specify at least two subnets. You
	// can specify up to five security groups, but we recommend that you use a dedicated
	// security group for your cluster control plane.
	//
	// ResourcesVpcConfig is a required field
	ResourcesVpcConfig *VpcConfigRequest `locationName:"resourcesVpcConfig" type:"structure" required:"true"`

	// The Amazon Resource Name (ARN) of the IAM role that provides permissions
	// for the Kubernetes control plane to make calls to AWS API operations on your
	// behalf. For more information, see Amazon EKS Service IAM Role (https://docs.aws.amazon.com/eks/latest/userguide/service_IAM_role.html)
	// in the Amazon EKS User Guide .
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" type:"string" required:"true"`

	// The metadata to apply to the cluster to assist with categorization and organization.
	// Each tag consists of a key and an optional value, both of which you define.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map"`

	// The desired Kubernetes version for your cluster. If you don't specify a value
	// here, the latest version available in Amazon EKS is used.
	Version *string `locationName:"version" type:"string"`
}

// String returns the string representation
func (s CreateClusterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateClusterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateClusterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateClusterInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.ResourcesVpcConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourcesVpcConfig"))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *CreateClusterInput) SetClientRequestToken(v string) *CreateClusterInput {
	s.ClientRequestToken = &v
	return s
}

// SetEncryptionConfig sets the EncryptionConfig field's value.
func (s *CreateClusterInput) SetEncryptionConfig(v []*EncryptionConfig) *CreateClusterInput {
	s.EncryptionConfig = v
	return s
}

// SetKubernetesNetworkConfig sets the KubernetesNetworkConfig field's value.
func (s *CreateClusterInput) SetKubernetesNetworkConfig(v *KubernetesNetworkConfigRequest) *CreateClusterInput {
	s.KubernetesNetworkConfig = v
	return s
}

// SetLogging sets the Logging field's value.
func (s *CreateClusterInput) SetLogging(v *Logging) *CreateClusterInput {
	s.Logging = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateClusterInput) SetName(v string) *CreateClusterInput {
	s.Name = &v
	return s
}

// SetResourcesVpcConfig sets the ResourcesVpcConfig field's value.
func (s *CreateClusterInput) SetResourcesVpcConfig(v *VpcConfigRequest) *CreateClusterInput {
	s.ResourcesVpcConfig = v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *CreateClusterInput) SetRoleArn(v string) *CreateClusterInput {
	s.RoleArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateClusterInput) SetTags(v map[string]*string) *CreateClusterInput {
	s.Tags = v
	return s
}

// SetVersion sets the Version field's value.
func (s *CreateClusterInput) SetVersion(v string) *CreateClusterInput {
	s.Version = &v
	return s
}

type CreateClusterOutput struct {
	_ struct{} `type:"structure"`

	// The full description of your new cluster.
	Cluster *Cluster `locationName:"cluster" type:"structure"`
}

// String returns the string representation
func (s CreateClusterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateClusterOutput) GoString() string {
	return s.String()
}

// SetCluster sets the Cluster field's value.
func (s *CreateClusterOutput) SetCluster(v *Cluster) *CreateClusterOutput {
	s.Cluster = v
	return s
}

type CreateFargateProfileInput struct {
	_ struct{} `type:"structure"`

	// Unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request.
	ClientRequestToken *string `locationName:"clientRequestToken" type:"string" idempotencyToken:"true"`

	// The name of the Amazon EKS cluster to apply the Fargate profile to.
	//
	// ClusterName is a required field
	ClusterName *string `location:"uri" locationName:"name" type:"string" required:"true"`

	// The name of the Fargate profile.
	//
	// FargateProfileName is a required field
	FargateProfileName *string `locationName:"fargateProfileName" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the pod execution role to use for pods
	// that match the selectors in the Fargate profile. The pod execution role allows
	// Fargate infrastructure to register with your cluster as a node, and it provides
	// read access to Amazon ECR image repositories. For more information, see Pod
	// Execution Role (https://docs.aws.amazon.com/eks/latest/userguide/pod-execution-role.html)
	// in the Amazon EKS User Guide.
	//
	// PodExecutionRoleArn is a required field
	PodExecutionRoleArn *string `locationName:"podExecutionRoleArn" type:"string" required:"true"`

	// The selectors to match for pods to use this Fargate profile. Each selector
	// must have an associated namespace. Optionally, you can also specify labels
	// for a namespace. You may specify up to five selectors in a Fargate profile.
	Selectors []*FargateProfileSelector `locationName:"selectors" type:"list"`

	// The IDs of subnets to launch your pods into. At this time, pods running on
	// Fargate are not assigned public IP addresses, so only private subnets (with
	// no direct route to an Internet Gateway) are accepted for this parameter.
	Subnets []*string `locationName:"subnets" type:"list"`

	// The metadata to apply to the Fargate profile to assist with categorization
	// and organization. Each tag consists of a key and an optional value, both
	// of which you define. Fargate profile tags do not propagate to any other resources
	// associated with the Fargate profile, such as the pods that are scheduled
	// with it.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map"`
}

// String returns the string representation
func (s CreateFargateProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateFargateProfileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateFargateProfileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateFargateProfileInput"}
	if s.ClusterName == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterName"))
	}
	if s.ClusterName != nil && len(*s.ClusterName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterName", 1))
	}
	if s.FargateProfileName == nil {
		invalidParams.Add(request.NewErrParamRequired("FargateProfileName"))
	}
	if s.PodExecutionRoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("PodExecutionRoleArn"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *CreateFargateProfileInput) SetClientRequestToken(v string) *CreateFargateProfileInput {
	s.ClientRequestToken = &v
	return s
}

// SetClusterName sets the ClusterName field's value.
func (s *CreateFargateProfileInput) SetClusterName(v string) *CreateFargateProfileInput {
	s.ClusterName = &v
	return s
}

// SetFargateProfileName sets the FargateProfileName field's value.
func (s *CreateFargateProfileInput) SetFargateProfileName(v string) *CreateFargateProfileInput {
	s.FargateProfileName = &v
	return s
}

// SetPodExecutionRoleArn sets the PodExecutionRoleArn field's value.
func (s *CreateFargateProfileInput) SetPodExecutionRoleArn(v string) *CreateFargateProfileInput {
	s.PodExecutionRoleArn = &v
	return s
}

// SetSelectors sets the Selectors field's value.
func (s *CreateFargateProfileInput) SetSelectors(v []*FargateProfileSelector) *CreateFargateProfileInput {
	s.Selectors = v
	return s
}

// SetSubnets sets the Subnets field's value.
func (s *CreateFargateProfileInput) SetSubnets(v []*string) *CreateFargateProfileInput {
	s.Subnets = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateFargateProfileInput) SetTags(v map[string]*string) *CreateFargateProfileInput {
	s.Tags = v
	return s
}

type CreateFargateProfileOutput struct {
	_ struct{} `type:"structure"`

	// The full description of your new Fargate profile.
	FargateProfile *FargateProfile `locationName:"fargateProfile" type:"structure"`
}

// String returns the string representation
func (s CreateFargateProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateFargateProfileOutput) GoString() string {
	return s.String()
}

// SetFargateProfile sets the FargateProfile field's value.
func (s *CreateFargateProfileOutput) SetFargateProfile(v *FargateProfile) *CreateFargateProfileOutput {
	s.FargateProfile = v
	return s
}

type CreateNodegroupInput struct {
	_ struct{} `type:"structure"`

	// The AMI type for your node group. GPU instance types should use the AL2_x86_64_GPU
	// AMI type. Non-GPU instances should use the AL2_x86_64 AMI type. Arm instances
	// should use the AL2_ARM_64 AMI type. All types use the Amazon EKS-optimized
	// Amazon Linux 2 AMI. If you specify launchTemplate, and your launch template
	// uses a custom AMI, then don't specify amiType, or the node group deployment
	// will fail. For more information about using launch templates with Amazon
	// EKS, see Launch template support (https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html)
	// in the Amazon EKS User Guide.
	AmiType *string `locationName:"amiType" type:"string" enum:"AMITypes"`

	// Unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request.
	ClientRequestToken *string `locationName:"clientRequestToken" type:"string" idempotencyToken:"true"`

	// The name of the cluster to create the node group in.
	//
	// ClusterName is a required field
	ClusterName *string `location:"uri" locationName:"name" type:"string" required:"true"`

	// The root device disk size (in GiB) for your node group instances. The default
	// disk size is 20 GiB. If you specify launchTemplate, then don't specify diskSize,
	// or the node group deployment will fail. For more information about using
	// launch templates with Amazon EKS, see Launch template support (https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html)
	// in the Amazon EKS User Guide.
	DiskSize *int64 `locationName:"diskSize" type:"integer"`

	// The instance type to use for your node group. You can specify a single instance
	// type for a node group. The default value for instanceTypes is t3.medium.
	// If you choose a GPU instance type, be sure to specify AL2_x86_64_GPU with
	// the amiType parameter. If you specify launchTemplate, then don't specify
	// instanceTypes, or the node group deployment will fail. For more information
	// about using launch templates with Amazon EKS, see Launch template support
	// (https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html)
	// in the Amazon EKS User Guide.
	InstanceTypes []*string `locationName:"instanceTypes" type:"list"`

	// The Kubernetes labels to be applied to the nodes in the node group when they
	// are created.
	Labels map[string]*string `locationName:"labels" type:"map"`

	// An object representing a node group's launch template specification. If specified,
	// then do not specify instanceTypes, diskSize, or remoteAccess and make sure
	// that the launch template meets the requirements in launchTemplateSpecification.
	LaunchTemplate *LaunchTemplateSpecification `locationName:"launchTemplate" type:"structure"`

	// The Amazon Resource Name (ARN) of the IAM role to associate with your node
	// group. The Amazon EKS worker node kubelet daemon makes calls to AWS APIs
	// on your behalf. Worker nodes receive permissions for these API calls through
	// an IAM instance profile and associated policies. Before you can launch worker
	// nodes and register them into a cluster, you must create an IAM role for those
	// worker nodes to use when they are launched. For more information, see Amazon
	// EKS Worker Node IAM Role (https://docs.aws.amazon.com/eks/latest/userguide/worker_node_IAM_role.html)
	// in the Amazon EKS User Guide . If you specify launchTemplate, then don't
	// specify IamInstanceProfile (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_IamInstanceProfile.html)
	// in your launch template, or the node group deployment will fail. For more
	// information about using launch templates with Amazon EKS, see Launch template
	// support (https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html)
	// in the Amazon EKS User Guide.
	//
	// NodeRole is a required field
	NodeRole *string `locationName:"nodeRole" type:"string" required:"true"`

	// The unique name to give your node group.
	//
	// NodegroupName is a required field
	NodegroupName *string `locationName:"nodegroupName" type:"string" required:"true"`

	// The AMI version of the Amazon EKS-optimized AMI to use with your node group.
	// By default, the latest available AMI version for the node group's current
	// Kubernetes version is used. For more information, see Amazon EKS-Optimized
	// Linux AMI Versions (https://docs.aws.amazon.com/eks/latest/userguide/eks-linux-ami-versions.html)
	// in the Amazon EKS User Guide. If you specify launchTemplate, and your launch
	// template uses a custom AMI, then don't specify releaseVersion, or the node
	// group deployment will fail. For more information about using launch templates
	// with Amazon EKS, see Launch template support (https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html)
	// in the Amazon EKS User Guide.
	ReleaseVersion *string `locationName:"releaseVersion" type:"string"`

	// The remote access (SSH) configuration to use with your node group. If you
	// specify launchTemplate, then don't specify remoteAccess, or the node group
	// deployment will fail. For more information about using launch templates with
	// Amazon EKS, see Launch template support (https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html)
	// in the Amazon EKS User Guide.
	RemoteAccess *RemoteAccessConfig `locationName:"remoteAccess" type:"structure"`

	// The scaling configuration details for the Auto Scaling group that is created
	// for your node group.
	ScalingConfig *NodegroupScalingConfig `locationName:"scalingConfig" type:"structure"`

	// The subnets to use for the Auto Scaling group that is created for your node
	// group. These subnets must have the tag key kubernetes.io/cluster/CLUSTER_NAME
	// with a value of shared, where CLUSTER_NAME is replaced with the name of your
	// cluster. If you specify launchTemplate, then don't specify SubnetId (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateNetworkInterface.html)
	// in your launch template, or the node group deployment will fail. For more
	// information about using launch templates with Amazon EKS, see Launch template
	// support (https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html)
	// in the Amazon EKS User Guide.
	//
	// Subnets is a required field
	Subnets []*string `locationName:"subnets" type:"list" required:"true"`

	// The metadata to apply to the node group to assist with categorization and
	// organization. Each tag consists of a key and an optional value, both of which
	// you define. Node group tags do not propagate to any other resources associated
	// with the node group, such as the Amazon EC2 instances or subnets.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map"`

	// The Kubernetes version to use for your managed nodes. By default, the Kubernetes
	// version of the cluster is used, and this is the only accepted specified value.
	// If you specify launchTemplate, and your launch template uses a custom AMI,
	// then don't specify version, or the node group deployment will fail. For more
	// information about using launch templates with Amazon EKS, see Launch template
	// support (https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html)
	// in the Amazon EKS User Guide.
	Version *string `locationName:"version" type:"string"`
}

// String returns the string representation
func (s CreateNodegroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateNodegroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateNodegroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateNodegroupInput"}
	if s.ClusterName == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterName"))
	}
	if s.ClusterName != nil && len(*s.ClusterName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterName", 1))
	}
	if s.NodeRole == nil {
		invalidParams.Add(request.NewErrParamRequired("NodeRole"))
	}
	if s.NodegroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("NodegroupName"))
	}
	if s.Subnets == nil {
		invalidParams.Add(request.NewErrParamRequired("Subnets"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.ScalingConfig != nil {
		if err := s.ScalingConfig.Validate(); err != nil {
			invalidParams.AddNested("ScalingConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAmiType sets the AmiType field's value.
func (s *CreateNodegroupInput) SetAmiType(v string) *CreateNodegroupInput {
	s.AmiType = &v
	return s
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *CreateNodegroupInput) SetClientRequestToken(v string) *CreateNodegroupInput {
	s.ClientRequestToken = &v
	return s
}

// SetClusterName sets the ClusterName field's value.
func (s *CreateNodegroupInput) SetClusterName(v string) *CreateNodegroupInput {
	s.ClusterName = &v
	return s
}

// SetDiskSize sets the DiskSize field's value.
func (s *CreateNodegroupInput) SetDiskSize(v int64) *CreateNodegroupInput {
	s.DiskSize = &v
	return s
}

// SetInstanceTypes sets the InstanceTypes field's value.
func (s *CreateNodegroupInput) SetInstanceTypes(v []*string) *CreateNodegroupInput {
	s.InstanceTypes = v
	return s
}

// SetLabels sets the Labels field's value.
func (s *CreateNodegroupInput) SetLabels(v map[string]*string) *CreateNodegroupInput {
	s.Labels = v
	return s
}

// SetLaunchTemplate sets the LaunchTemplate field's value.
func (s *CreateNodegroupInput) SetLaunchTemplate(v *LaunchTemplateSpecification) *CreateNodegroupInput {
	s.LaunchTemplate = v
	return s
}

// SetNodeRole sets the NodeRole field's value.
func (s *CreateNodegroupInput) SetNodeRole(v string) *CreateNodegroupInput {
	s.NodeRole = &v
	return s
}

// SetNodegroupName sets the NodegroupName field's value.
func (s *CreateNodegroupInput) SetNodegroupName(v string) *CreateNodegroupInput {
	s.NodegroupName = &v
	return s
}

// SetReleaseVersion sets the ReleaseVersion field's value.
func (s *CreateNodegroupInput) SetReleaseVersion(v string) *CreateNodegroupInput {
	s.ReleaseVersion = &v
	return s
}

// SetRemoteAccess sets the RemoteAccess field's value.
func (s *CreateNodegroupInput) SetRemoteAccess(v *RemoteAccessConfig) *CreateNodegroupInput {
	s.RemoteAccess = v
	return s
}

// SetScalingConfig sets the ScalingConfig field's value.
func (s *CreateNodegroupInput) SetScalingConfig(v *NodegroupScalingConfig) *CreateNodegroupInput {
	s.ScalingConfig = v
	return s
}

// SetSubnets sets the Subnets field's value.
func (s *CreateNodegroupInput) SetSubnets(v []*string) *CreateNodegroupInput {
	s.Subnets = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateNodegroupInput) SetTags(v map[string]*string) *CreateNodegroupInput {
	s.Tags = v
	return s
}

// SetVersion sets the Version field's value.
func (s *CreateNodegroupInput) SetVersion(v string) *CreateNodegroupInput {
	s.Version = &v
	return s
}

type CreateNodegroupOutput struct {
	_ struct{} `type:"structure"`

	// The full description of your new node group.
	Nodegroup *Nodegroup `locationName:"nodegroup" type:"structure"`
}

// String returns the string representation
func (s CreateNodegroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateNodegroupOutput) GoString() string {
	return s.String()
}

// SetNodegroup sets the Nodegroup field's value.
func (s *CreateNodegroupOutput) SetNodegroup(v *Nodegroup) *CreateNodegroupOutput {
	s.Nodegroup = v
	return s
}

type DeleteClusterInput struct {
	_ struct{} `type:"structure"`

	// The name of the cluster to delete.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteClusterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteClusterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteClusterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteClusterInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DeleteClusterInput) SetName(v string) *DeleteClusterInput {
	s.Name = &v
	return s
}

type DeleteClusterOutput struct {
	_ struct{} `type:"structure"`

	// The full description of the cluster to delete.
	Cluster *Cluster `locationName:"cluster" type:"structure"`
}

// String returns the string representation
func (s DeleteClusterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteClusterOutput) GoString() string {
	return s.String()
}

// SetCluster sets the Cluster field's value.
func (s *DeleteClusterOutput) SetCluster(v *Cluster) *DeleteClusterOutput {
	s.Cluster = v
	return s
}

type DeleteFargateProfileInput struct {
	_ struct{} `type:"structure"`

	// The name of the Amazon EKS cluster associated with the Fargate profile to
	// delete.
	//
	// ClusterName is a required field
	ClusterName *string `location:"uri" locationName:"name" type:"string" required:"true"`

	// The name of the Fargate profile to delete.
	//
	// FargateProfileName is a required field
	FargateProfileName *string `location:"uri" locationName:"fargateProfileName" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteFargateProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteFargateProfileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteFargateProfileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteFargateProfileInput"}
	if s.ClusterName == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterName"))
	}
	if s.ClusterName != nil && len(*s.ClusterName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterName", 1))
	}
	if s.FargateProfileName == nil {
		invalidParams.Add(request.NewErrParamRequired("FargateProfileName"))
	}
	if s.FargateProfileName != nil && len(*s.FargateProfileName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FargateProfileName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterName sets the ClusterName field's value.
func (s *DeleteFargateProfileInput) SetClusterName(v string) *DeleteFargateProfileInput {
	s.ClusterName = &v
	return s
}

// SetFargateProfileName sets the FargateProfileName field's value.
func (s *DeleteFargateProfileInput) SetFargateProfileName(v string) *DeleteFargateProfileInput {
	s.FargateProfileName = &v
	return s
}

type DeleteFargateProfileOutput struct {
	_ struct{} `type:"structure"`

	// The deleted Fargate profile.
	FargateProfile *FargateProfile `locationName:"fargateProfile" type:"structure"`
}

// String returns the string representation
func (s DeleteFargateProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteFargateProfileOutput) GoString() string {
	return s.String()
}

// SetFargateProfile sets the FargateProfile field's value.
func (s *DeleteFargateProfileOutput) SetFargateProfile(v *FargateProfile) *DeleteFargateProfileOutput {
	s.FargateProfile = v
	return s
}

type DeleteNodegroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the Amazon EKS cluster that is associated with your node group.
	//
	// ClusterName is a required field
	ClusterName *string `location:"uri" locationName:"name" type:"string" required:"true"`

	// The name of the node group to delete.
	//
	// NodegroupName is a required field
	NodegroupName *string `location:"uri" locationName:"nodegroupName" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteNodegroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteNodegroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteNodegroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteNodegroupInput"}
	if s.ClusterName == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterName"))
	}
	if s.ClusterName != nil && len(*s.ClusterName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterName", 1))
	}
	if s.NodegroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("NodegroupName"))
	}
	if s.NodegroupName != nil && len(*s.NodegroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NodegroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterName sets the ClusterName field's value.
func (s *DeleteNodegroupInput) SetClusterName(v string) *DeleteNodegroupInput {
	s.ClusterName = &v
	return s
}

// SetNodegroupName sets the NodegroupName field's value.
func (s *DeleteNodegroupInput) SetNodegroupName(v string) *DeleteNodegroupInput {
	s.NodegroupName = &v
	return s
}

type DeleteNodegroupOutput struct {
	_ struct{} `type:"structure"`

	// The full description of your deleted node group.
	Nodegroup *Nodegroup `locationName:"nodegroup" type:"structure"`
}

// String returns the string representation
func (s DeleteNodegroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteNodegroupOutput) GoString() string {
	return s.String()
}

// SetNodegroup sets the Nodegroup field's value.
func (s *DeleteNodegroupOutput) SetNodegroup(v *Nodegroup) *DeleteNodegroupOutput {
	s.Nodegroup = v
	return s
}

type DescribeClusterInput struct {
	_ struct{} `type:"structure"`

	// The name of the cluster to describe.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeClusterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeClusterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeClusterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeClusterInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DescribeClusterInput) SetName(v string) *DescribeClusterInput {
	s.Name = &v
	return s
}

type DescribeClusterOutput struct {
	_ struct{} `type:"structure"`

	// The full description of your specified cluster.
	Cluster *Cluster `locationName:"cluster" type:"structure"`
}

// String returns the string representation
func (s DescribeClusterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeClusterOutput) GoString() string {
	return s.String()
}

// SetCluster sets the Cluster field's value.
func (s *DescribeClusterOutput) SetCluster(v *Cluster) *DescribeClusterOutput {
	s.Cluster = v
	return s
}

type DescribeFargateProfileInput struct {
	_ struct{} `type:"structure"`

	// The name of the Amazon EKS cluster associated with the Fargate profile.
	//
	// ClusterName is a required field
	ClusterName *string `location:"uri" locationName:"name" type:"string" required:"true"`

	// The name of the Fargate profile to describe.
	//
	// FargateProfileName is a required field
	FargateProfileName *string `location:"uri" locationName:"fargateProfileName" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeFargateProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeFargateProfileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeFargateProfileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeFargateProfileInput"}
	if s.ClusterName == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterName"))
	}
	if s.ClusterName != nil && len(*s.ClusterName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterName", 1))
	}
	if s.FargateProfileName == nil {
		invalidParams.Add(request.NewErrParamRequired("FargateProfileName"))
	}
	if s.FargateProfileName != nil && len(*s.FargateProfileName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FargateProfileName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterName sets the ClusterName field's value.
func (s *DescribeFargateProfileInput) SetClusterName(v string) *DescribeFargateProfileInput {
	s.ClusterName = &v
	return s
}

// SetFargateProfileName sets the FargateProfileName field's value.
func (s *DescribeFargateProfileInput) SetFargateProfileName(v string) *DescribeFargateProfileInput {
	s.FargateProfileName = &v
	return s
}

type DescribeFargateProfileOutput struct {
	_ struct{} `type:"structure"`

	// The full description of your Fargate profile.
	FargateProfile *FargateProfile `locationName:"fargateProfile" type:"structure"`
}

// String returns the string representation
func (s DescribeFargateProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeFargateProfileOutput) GoString() string {
	return s.String()
}

// SetFargateProfile sets the FargateProfile field's value.
func (s *DescribeFargateProfileOutput) SetFargateProfile(v *FargateProfile) *DescribeFargateProfileOutput {
	s.FargateProfile = v
	return s
}

type DescribeNodegroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the Amazon EKS cluster associated with the node group.
	//
	// ClusterName is a required field
	ClusterName *string `location:"uri" locationName:"name" type:"string" required:"true"`

	// The name of the node group to describe.
	//
	// NodegroupName is a required field
	NodegroupName *string `location:"uri" locationName:"nodegroupName" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeNodegroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeNodegroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeNodegroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeNodegroupInput"}
	if s.ClusterName == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterName"))
	}
	if s.ClusterName != nil && len(*s.ClusterName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterName", 1))
	}
	if s.NodegroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("NodegroupName"))
	}
	if s.NodegroupName != nil && len(*s.NodegroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NodegroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterName sets the ClusterName field's value.
func (s *DescribeNodegroupInput) SetClusterName(v string) *DescribeNodegroupInput {
	s.ClusterName = &v
	return s
}

// SetNodegroupName sets the NodegroupName field's value.
func (s *DescribeNodegroupInput) SetNodegroupName(v string) *DescribeNodegroupInput {
	s.NodegroupName = &v
	return s
}

type DescribeNodegroupOutput struct {
	_ struct{} `type:"structure"`

	// The full description of your node group.
	Nodegroup *Nodegroup `locationName:"nodegroup" type:"structure"`
}

// String returns the string representation
func (s DescribeNodegroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeNodegroupOutput) GoString() string {
	return s.String()
}

// SetNodegroup sets the Nodegroup field's value.
func (s *DescribeNodegroupOutput) SetNodegroup(v *Nodegroup) *DescribeNodegroupOutput {
	s.Nodegroup = v
	return s
}

type DescribeUpdateInput struct {
	_ struct{} `type:"structure"`

	// The name of the Amazon EKS cluster associated with the update.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" type:"string" required:"true"`

	// The name of the Amazon EKS node group associated with the update.
	NodegroupName *string `location:"querystring" locationName:"nodegroupName" type:"string"`

	// The ID of the update to describe.
	//
	// UpdateId is a required field
	UpdateId *string `location:"uri" locationName:"updateId" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeUpdateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeUpdateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeUpdateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeUpdateInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.UpdateId == nil {
		invalidParams.Add(request.NewErrParamRequired("UpdateId"))
	}
	if s.UpdateId != nil && len(*s.UpdateId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UpdateId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DescribeUpdateInput) SetName(v string) *DescribeUpdateInput {
	s.Name = &v
	return s
}

// SetNodegroupName sets the NodegroupName field's value.
func (s *DescribeUpdateInput) SetNodegroupName(v string) *DescribeUpdateInput {
	s.NodegroupName = &v
	return s
}

// SetUpdateId sets the UpdateId field's value.
func (s *DescribeUpdateInput) SetUpdateId(v string) *DescribeUpdateInput {
	s.UpdateId = &v
	return s
}

type DescribeUpdateOutput struct {
	_ struct{} `type:"structure"`

	// The full description of the specified update.
	Update *Update `locationName:"update" type:"structure"`
}

// String returns the string representation
func (s DescribeUpdateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeUpdateOutput) GoString() string {
	return s.String()
}

// SetUpdate sets the Update field's value.
func (s *DescribeUpdateOutput) SetUpdate(v *Update) *DescribeUpdateOutput {
	s.Update = v
	return s
}

// The encryption configuration for the cluster.
type EncryptionConfig struct {
	_ struct{} `type:"structure"`

	// AWS Key Management Service (AWS KMS) customer master key (CMK). Either the
	// ARN or the alias can be used.
	Provider *Provider `locationName:"provider" type:"structure"`

	// Specifies the resources to be encrypted. The only supported value is "secrets".
	Resources []*string `locationName:"resources" type:"list"`
}

// String returns the string representation
func (s EncryptionConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EncryptionConfig) GoString() string {
	return s.String()
}

// SetProvider sets the Provider field's value.
func (s *EncryptionConfig) SetProvider(v *Provider) *EncryptionConfig {
	s.Provider = v
	return s
}

// SetResources sets the Resources field's value.
func (s *EncryptionConfig) SetResources(v []*string) *EncryptionConfig {
	s.Resources = v
	return s
}

// An object representing an error when an asynchronous operation fails.
type ErrorDetail struct {
	_ struct{} `type:"structure"`

	// A brief description of the error.
	//
	//    * SubnetNotFound: We couldn't find one of the subnets associated with
	//    the cluster.
	//
	//    * SecurityGroupNotFound: We couldn't find one of the security groups associated
	//    with the cluster.
	//
	//    * EniLimitReached: You have reached the elastic network interface limit
	//    for your account.
	//
	//    * IpNotAvailable: A subnet associated with the cluster doesn't have any
	//    free IP addresses.
	//
	//    * AccessDenied: You don't have permissions to perform the specified operation.
	//
	//    * OperationNotPermitted: The service role associated with the cluster
	//    doesn't have the required access permissions for Amazon EKS.
	//
	//    * VpcIdNotFound: We couldn't find the VPC associated with the cluster.
	ErrorCode *string `locationName:"errorCode" type:"string" enum:"ErrorCode"`

	// A more complete description of the error.
	ErrorMessage *string `locationName:"errorMessage" type:"string"`

	// An optional field that contains the resource IDs associated with the error.
	ResourceIds []*string `locationName:"resourceIds" type:"list"`
}

// String returns the string representation
func (s ErrorDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ErrorDetail) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *ErrorDetail) SetErrorCode(v string) *ErrorDetail {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *ErrorDetail) SetErrorMessage(v string) *ErrorDetail {
	s.ErrorMessage = &v
	return s
}

// SetResourceIds sets the ResourceIds field's value.
func (s *ErrorDetail) SetResourceIds(v []*string) *ErrorDetail {
	s.ResourceIds = v
	return s
}

// An object representing an AWS Fargate profile.
type FargateProfile struct {
	_ struct{} `type:"structure"`

	// The name of the Amazon EKS cluster that the Fargate profile belongs to.
	ClusterName *string `locationName:"clusterName" type:"string"`

	// The Unix epoch timestamp in seconds for when the Fargate profile was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// The full Amazon Resource Name (ARN) of the Fargate profile.
	FargateProfileArn *string `locationName:"fargateProfileArn" type:"string"`

	// The name of the Fargate profile.
	FargateProfileName *string `locationName:"fargateProfileName" type:"string"`

	// The Amazon Resource Name (ARN) of the pod execution role to use for pods
	// that match the selectors in the Fargate profile. For more information, see
	// Pod Execution Role (https://docs.aws.amazon.com/eks/latest/userguide/pod-execution-role.html)
	// in the Amazon EKS User Guide.
	PodExecutionRoleArn *string `locationName:"podExecutionRoleArn" type:"string"`

	// The selectors to match for pods to use this Fargate profile.
	Selectors []*FargateProfileSelector `locationName:"selectors" type:"list"`

	// The current status of the Fargate profile.
	Status *string `locationName:"status" type:"string" enum:"FargateProfileStatus"`

	// The IDs of subnets to launch pods into.
	Subnets []*string `locationName:"subnets" type:"list"`

	// The metadata applied to the Fargate profile to assist with categorization
	// and organization. Each tag consists of a key and an optional value, both
	// of which you define. Fargate profile tags do not propagate to any other resources
	// associated with the Fargate profile, such as the pods that are scheduled
	// with it.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map"`
}

// String returns the string representation
func (s FargateProfile) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FargateProfile) GoString() string {
	return s.String()
}

// SetClusterName sets the ClusterName field's value.
func (s *FargateProfile) SetClusterName(v string) *FargateProfile {
	s.ClusterName = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *FargateProfile) SetCreatedAt(v time.Time) *FargateProfile {
	s.CreatedAt = &v
	return s
}

// SetFargateProfileArn sets the FargateProfileArn field's value.
func (s *FargateProfile) SetFargateProfileArn(v string) *FargateProfile {
	s.FargateProfileArn = &v
	return s
}

// SetFargateProfileName sets the FargateProfileName field's value.
func (s *FargateProfile) SetFargateProfileName(v string) *FargateProfile {
	s.FargateProfileName = &v
	return s
}

// SetPodExecutionRoleArn sets the PodExecutionRoleArn field's value.
func (s *FargateProfile) SetPodExecutionRoleArn(v string) *FargateProfile {
	s.PodExecutionRoleArn = &v
	return s
}

// SetSelectors sets the Selectors field's value.
func (s *FargateProfile) SetSelectors(v []*FargateProfileSelector) *FargateProfile {
	s.Selectors = v
	return s
}

// SetStatus sets the Status field's value.
func (s *FargateProfile) SetStatus(v string) *FargateProfile {
	s.Status = &v
	return s
}

// SetSubnets sets the Subnets field's value.
func (s *FargateProfile) SetSubnets(v []*string) *FargateProfile {
	s.Subnets = v
	return s
}

// SetTags sets the Tags field's value.
func (s *FargateProfile) SetTags(v map[string]*string) *FargateProfile {
	s.Tags = v
	return s
}

// An object representing an AWS Fargate profile selector.
type FargateProfileSelector struct {
	_ struct{} `type:"structure"`

	// The Kubernetes labels that the selector should match. A pod must contain
	// all of the labels that are specified in the selector for it to be considered
	// a match.
	Labels map[string]*string `locationName:"labels" type:"map"`

	// The Kubernetes namespace that the selector should match.
	Namespace *string `locationName:"namespace" type:"string"`
}

// String returns the string representation
func (s FargateProfileSelector) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FargateProfileSelector) GoString() string {
	return s.String()
}

// SetLabels sets the Labels field's value.
func (s *FargateProfileSelector) SetLabels(v map[string]*string) *FargateProfileSelector {
	s.Labels = v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *FargateProfileSelector) SetNamespace(v string) *FargateProfileSelector {
	s.Namespace = &v
	return s
}

// An object representing an identity provider for authentication credentials.
type Identity struct {
	_ struct{} `type:"structure"`

	// The OpenID Connect (https://openid.net/connect/) identity provider information
	// for the cluster.
	Oidc *OIDC `locationName:"oidc" type:"structure"`
}

// String returns the string representation
func (s Identity) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Identity) GoString() string {
	return s.String()
}

// SetOidc sets the Oidc field's value.
func (s *Identity) SetOidc(v *OIDC) *Identity {
	s.Oidc = v
	return s
}

// The specified parameter is invalid. Review the available parameters for the
// API request.
type InvalidParameterException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The Amazon EKS cluster associated with the exception.
	ClusterName *string `locationName:"clusterName" type:"string"`

	// The Fargate profile associated with the exception.
	FargateProfileName *string `locationName:"fargateProfileName" type:"string"`

	Message_ *string `locationName:"message" type:"string"`

	// The Amazon EKS managed node group associated with the exception.
	NodegroupName *string `locationName:"nodegroupName" type:"string"`
}

// String returns the string representation
func (s InvalidParameterException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidParameterException) GoString() string {
	return s.String()
}

func newErrorInvalidParameterException(v protocol.ResponseMetadata) error {
	return &InvalidParameterException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidParameterException) Code() string {
	return "InvalidParameterException"
}

// Message returns the exception's message.
func (s *InvalidParameterException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidParameterException) OrigErr() error {
	return nil
}

func (s *InvalidParameterException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidParameterException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidParameterException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The request is invalid given the state of the cluster. Check the state of
// the cluster and the associated operations.
type InvalidRequestException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The Amazon EKS cluster associated with the exception.
	ClusterName *string `locationName:"clusterName" type:"string"`

	Message_ *string `locationName:"message" type:"string"`

	// The Amazon EKS managed node group associated with the exception.
	NodegroupName *string `locationName:"nodegroupName" type:"string"`
}

// String returns the string representation
func (s InvalidRequestException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidRequestException) GoString() string {
	return s.String()
}

func newErrorInvalidRequestException(v protocol.ResponseMetadata) error {
	return &InvalidRequestException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidRequestException) Code() string {
	return "InvalidRequestException"
}

// Message returns the exception's message.
func (s *InvalidRequestException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidRequestException) OrigErr() error {
	return nil
}

func (s *InvalidRequestException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidRequestException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidRequestException) RequestID() string {
	return s.RespMetadata.RequestID
}

// An object representing an issue with an Amazon EKS resource.
type Issue struct {
	_ struct{} `type:"structure"`

	// A brief description of the error.
	//
	//    * AutoScalingGroupNotFound: We couldn't find the Auto Scaling group associated
	//    with the managed node group. You may be able to recreate an Auto Scaling
	//    group with the same settings to recover.
	//
	//    * Ec2SecurityGroupNotFound: We couldn't find the cluster security group
	//    for the cluster. You must recreate your cluster.
	//
	//    * Ec2SecurityGroupDeletionFailure: We could not delete the remote access
	//    security group for your managed node group. Remove any dependencies from
	//    the security group.
	//
	//    * Ec2LaunchTemplateNotFound: We couldn't find the Amazon EC2 launch template
	//    for your managed node group. You may be able to recreate a launch template
	//    with the same settings to recover.
	//
	//    * Ec2LaunchTemplateVersionMismatch: The Amazon EC2 launch template version
	//    for your managed node group does not match the version that Amazon EKS
	//    created. You may be able to revert to the version that Amazon EKS created
	//    to recover.
	//
	//    * Ec2SubnetInvalidConfiguration: One or more Amazon EC2 subnets specified
	//    for a node group do not automatically assign public IP addresses to instances
	//    launched into it. If you want your instances to be assigned a public IP
	//    address, then you need to enable the auto-assign public IP address setting
	//    for the subnet. See Modifying the public IPv4 addressing attribute for
	//    your subnet (https://docs.aws.amazon.com/vpc/latest/userguide/vpc-ip-addressing.html#subnet-public-ip)
	//    in the Amazon VPC User Guide.
	//
	//    * IamInstanceProfileNotFound: We couldn't find the IAM instance profile
	//    for your managed node group. You may be able to recreate an instance profile
	//    with the same settings to recover.
	//
	//    * IamNodeRoleNotFound: We couldn't find the IAM role for your managed
	//    node group. You may be able to recreate an IAM role with the same settings
	//    to recover.
	//
	//    * AsgInstanceLaunchFailures: Your Auto Scaling group is experiencing failures
	//    while attempting to launch instances.
	//
	//    * NodeCreationFailure: Your launched instances are unable to register
	//    with your Amazon EKS cluster. Common causes of this failure are insufficient
	//    worker node IAM role (https://docs.aws.amazon.com/eks/latest/userguide/worker_node_IAM_role.html)
	//    permissions or lack of outbound internet access for the nodes.
	//
	//    * InstanceLimitExceeded: Your AWS account is unable to launch any more
	//    instances of the specified instance type. You may be able to request an
	//    Amazon EC2 instance limit increase to recover.
	//
	//    * InsufficientFreeAddresses: One or more of the subnets associated with
	//    your managed node group does not have enough available IP addresses for
	//    new nodes.
	//
	//    * AccessDenied: Amazon EKS or one or more of your managed nodes is unable
	//    to communicate with your cluster API server.
	//
	//    * InternalFailure: These errors are usually caused by an Amazon EKS server-side
	//    issue.
	Code *string `locationName:"code" type:"string" enum:"NodegroupIssueCode"`

	// The error message associated with the issue.
	Message *string `locationName:"message" type:"string"`

	// The AWS resources that are afflicted by this issue.
	ResourceIds []*string `locationName:"resourceIds" type:"list"`
}

// String returns the string representation
func (s Issue) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Issue) GoString() string {
	return s.String()
}

// SetCode sets the Code field's value.
func (s *Issue) SetCode(v string) *Issue {
	s.Code = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *Issue) SetMessage(v string) *Issue {
	s.Message = &v
	return s
}

// SetResourceIds sets the ResourceIds field's value.
func (s *Issue) SetResourceIds(v []*string) *Issue {
	s.ResourceIds = v
	return s
}

// The Kubernetes network configuration for the cluster.
type KubernetesNetworkConfigRequest struct {
	_ struct{} `type:"structure"`

	// The CIDR block to assign Kubernetes service IP addresses from. If you don't
	// specify a block, Kubernetes assigns addresses from either the 10.100.0.0/16
	// or 172.20.0.0/16 CIDR blocks. We recommend that you specify a block that
	// does not overlap with resources in other networks that are peered or connected
	// to your VPC. The block must meet the following requirements:
	//
	//    * Within one of the following private IP address blocks: 10.0.0.0/8, 172.16.0.0.0/12,
	//    or 192.168.0.0/16.
	//
	//    * Doesn't overlap with any CIDR block assigned to the VPC that you selected
	//    for VPC.
	//
	//    * Between /24 and /12.
	//
	// You can only specify a custom CIDR block when you create a cluster and can't
	// change this value once the cluster is created.
	ServiceIpv4Cidr *string `locationName:"serviceIpv4Cidr" type:"string"`
}

// String returns the string representation
func (s KubernetesNetworkConfigRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s KubernetesNetworkConfigRequest) GoString() string {
	return s.String()
}

// SetServiceIpv4Cidr sets the ServiceIpv4Cidr field's value.
func (s *KubernetesNetworkConfigRequest) SetServiceIpv4Cidr(v string) *KubernetesNetworkConfigRequest {
	s.ServiceIpv4Cidr = &v
	return s
}

// The Kubernetes network configuration for the cluster.
type KubernetesNetworkConfigResponse struct {
	_ struct{} `type:"structure"`

	// The CIDR block that Kubernetes service IP addresses are assigned from. If
	// you didn't specify a CIDR block, then Kubernetes assigns addresses from either
	// the 10.100.0.0/16 or 172.20.0.0/16 CIDR blocks. If this was specified, then
	// it was specified when the cluster was created and it cannot be changed.
	ServiceIpv4Cidr *string `locationName:"serviceIpv4Cidr" type:"string"`
}

// String returns the string representation
func (s KubernetesNetworkConfigResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s KubernetesNetworkConfigResponse) GoString() string {
	return s.String()
}

// SetServiceIpv4Cidr sets the ServiceIpv4Cidr field's value.
func (s *KubernetesNetworkConfigResponse) SetServiceIpv4Cidr(v string) *KubernetesNetworkConfigResponse {
	s.ServiceIpv4Cidr = &v
	return s
}

// An object representing a node group launch template specification. The launch
// template cannot include SubnetId (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateNetworkInterface.html),
// IamInstanceProfile (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_IamInstanceProfile.html),
// RequestSpotInstances (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RequestSpotInstances.html),
// HibernationOptions (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_HibernationOptionsRequest.html),
// or TerminateInstances (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_TerminateInstances.html),
// or the node group deployment or update will fail. For more information about
// launch templates, see CreateLaunchTemplate (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateLaunchTemplate.html)
// in the Amazon EC2 API Reference. For more information about using launch
// templates with Amazon EKS, see Launch template support (https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html)
// in the Amazon EKS User Guide.
//
// Specify either name or id, but not both.
type LaunchTemplateSpecification struct {
	_ struct{} `type:"structure"`

	// The ID of the launch template.
	Id *string `locationName:"id" type:"string"`

	// The name of the launch template.
	Name *string `locationName:"name" type:"string"`

	// The version of the launch template to use. If no version is specified, then
	// the template's default version is used.
	Version *string `locationName:"version" type:"string"`
}

// String returns the string representation
func (s LaunchTemplateSpecification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LaunchTemplateSpecification) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *LaunchTemplateSpecification) SetId(v string) *LaunchTemplateSpecification {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *LaunchTemplateSpecification) SetName(v string) *LaunchTemplateSpecification {
	s.Name = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *LaunchTemplateSpecification) SetVersion(v string) *LaunchTemplateSpecification {
	s.Version = &v
	return s
}

type ListClustersInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of cluster results returned by ListClusters in paginated
	// output. When you use this parameter, ListClusters returns only maxResults
	// results in a single page along with a nextToken response element. You can
	// see the remaining results of the initial request by sending another ListClusters
	// request with the returned nextToken value. This value can be between 1 and
	// 100. If you don't use this parameter, ListClusters returns up to 100 results
	// and a nextToken value if applicable.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The nextToken value returned from a previous paginated ListClusters request
	// where maxResults was used and the results exceeded the value of that parameter.
	// Pagination continues from the end of the previous results that returned the
	// nextToken value.
	//
	// This token should be treated as an opaque identifier that is used only to
	// retrieve the next items in a list and not for other programmatic purposes.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListClustersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListClustersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListClustersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListClustersInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListClustersInput) SetMaxResults(v int64) *ListClustersInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListClustersInput) SetNextToken(v string) *ListClustersInput {
	s.NextToken = &v
	return s
}

type ListClustersOutput struct {
	_ struct{} `type:"structure"`

	// A list of all of the clusters for your account in the specified Region.
	Clusters []*string `locationName:"clusters" type:"list"`

	// The nextToken value to include in a future ListClusters request. When the
	// results of a ListClusters request exceed maxResults, you can use this value
	// to retrieve the next page of results. This value is null when there are no
	// more results to return.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListClustersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListClustersOutput) GoString() string {
	return s.String()
}

// SetClusters sets the Clusters field's value.
func (s *ListClustersOutput) SetClusters(v []*string) *ListClustersOutput {
	s.Clusters = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListClustersOutput) SetNextToken(v string) *ListClustersOutput {
	s.NextToken = &v
	return s
}

type ListFargateProfilesInput struct {
	_ struct{} `type:"structure"`

	// The name of the Amazon EKS cluster that you would like to listFargate profiles
	// in.
	//
	// ClusterName is a required field
	ClusterName *string `location:"uri" locationName:"name" type:"string" required:"true"`

	// The maximum number of Fargate profile results returned by ListFargateProfiles
	// in paginated output. When you use this parameter, ListFargateProfiles returns
	// only maxResults results in a single page along with a nextToken response
	// element. You can see the remaining results of the initial request by sending
	// another ListFargateProfiles request with the returned nextToken value. This
	// value can be between 1 and 100. If you don't use this parameter, ListFargateProfiles
	// returns up to 100 results and a nextToken value if applicable.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The nextToken value returned from a previous paginated ListFargateProfiles
	// request where maxResults was used and the results exceeded the value of that
	// parameter. Pagination continues from the end of the previous results that
	// returned the nextToken value.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListFargateProfilesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListFargateProfilesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListFargateProfilesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListFargateProfilesInput"}
	if s.ClusterName == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterName"))
	}
	if s.ClusterName != nil && len(*s.ClusterName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterName", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterName sets the ClusterName field's value.
func (s *ListFargateProfilesInput) SetClusterName(v string) *ListFargateProfilesInput {
	s.ClusterName = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListFargateProfilesInput) SetMaxResults(v int64) *ListFargateProfilesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListFargateProfilesInput) SetNextToken(v string) *ListFargateProfilesInput {
	s.NextToken = &v
	return s
}

type ListFargateProfilesOutput struct {
	_ struct{} `type:"structure"`

	// A list of all of the Fargate profiles associated with the specified cluster.
	FargateProfileNames []*string `locationName:"fargateProfileNames" type:"list"`

	// The nextToken value to include in a future ListFargateProfiles request. When
	// the results of a ListFargateProfiles request exceed maxResults, you can use
	// this value to retrieve the next page of results. This value is null when
	// there are no more results to return.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListFargateProfilesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListFargateProfilesOutput) GoString() string {
	return s.String()
}

// SetFargateProfileNames sets the FargateProfileNames field's value.
func (s *ListFargateProfilesOutput) SetFargateProfileNames(v []*string) *ListFargateProfilesOutput {
	s.FargateProfileNames = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListFargateProfilesOutput) SetNextToken(v string) *ListFargateProfilesOutput {
	s.NextToken = &v
	return s
}

type ListNodegroupsInput struct {
	_ struct{} `type:"structure"`

	// The name of the Amazon EKS cluster that you would like to list node groups
	// in.
	//
	// ClusterName is a required field
	ClusterName *string `location:"uri" locationName:"name" type:"string" required:"true"`

	// The maximum number of node group results returned by ListNodegroups in paginated
	// output. When you use this parameter, ListNodegroups returns only maxResults
	// results in a single page along with a nextToken response element. You can
	// see the remaining results of the initial request by sending another ListNodegroups
	// request with the returned nextToken value. This value can be between 1 and
	// 100. If you don't use this parameter, ListNodegroups returns up to 100 results
	// and a nextToken value if applicable.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The nextToken value returned from a previous paginated ListNodegroups request
	// where maxResults was used and the results exceeded the value of that parameter.
	// Pagination continues from the end of the previous results that returned the
	// nextToken value.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListNodegroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListNodegroupsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListNodegroupsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListNodegroupsInput"}
	if s.ClusterName == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterName"))
	}
	if s.ClusterName != nil && len(*s.ClusterName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterName", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterName sets the ClusterName field's value.
func (s *ListNodegroupsInput) SetClusterName(v string) *ListNodegroupsInput {
	s.ClusterName = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListNodegroupsInput) SetMaxResults(v int64) *ListNodegroupsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListNodegroupsInput) SetNextToken(v string) *ListNodegroupsInput {
	s.NextToken = &v
	return s
}

type ListNodegroupsOutput struct {
	_ struct{} `type:"structure"`

	// The nextToken value to include in a future ListNodegroups request. When the
	// results of a ListNodegroups request exceed maxResults, you can use this value
	// to retrieve the next page of results. This value is null when there are no
	// more results to return.
	NextToken *string `locationName:"nextToken" type:"string"`

	// A list of all of the node groups associated with the specified cluster.
	Nodegroups []*string `locationName:"nodegroups" type:"list"`
}

// String returns the string representation
func (s ListNodegroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListNodegroupsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListNodegroupsOutput) SetNextToken(v string) *ListNodegroupsOutput {
	s.NextToken = &v
	return s
}

// SetNodegroups sets the Nodegroups field's value.
func (s *ListNodegroupsOutput) SetNodegroups(v []*string) *ListNodegroupsOutput {
	s.Nodegroups = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) that identifies the resource for which to
	// list the tags. Currently, the supported resources are Amazon EKS clusters
	// and managed node groups.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`
}

// String returns the string representation
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// The tags for the resource.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map"`
}

// String returns the string representation
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v map[string]*string) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

type ListUpdatesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of update results returned by ListUpdates in paginated
	// output. When you use this parameter, ListUpdates returns only maxResults
	// results in a single page along with a nextToken response element. You can
	// see the remaining results of the initial request by sending another ListUpdates
	// request with the returned nextToken value. This value can be between 1 and
	// 100. If you don't use this parameter, ListUpdates returns up to 100 results
	// and a nextToken value if applicable.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The name of the Amazon EKS cluster to list updates for.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" type:"string" required:"true"`

	// The nextToken value returned from a previous paginated ListUpdates request
	// where maxResults was used and the results exceeded the value of that parameter.
	// Pagination continues from the end of the previous results that returned the
	// nextToken value.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// The name of the Amazon EKS managed node group to list updates for.
	NodegroupName *string `location:"querystring" locationName:"nodegroupName" type:"string"`
}

// String returns the string representation
func (s ListUpdatesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListUpdatesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListUpdatesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListUpdatesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListUpdatesInput) SetMaxResults(v int64) *ListUpdatesInput {
	s.MaxResults = &v
	return s
}

// SetName sets the Name field's value.
func (s *ListUpdatesInput) SetName(v string) *ListUpdatesInput {
	s.Name = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListUpdatesInput) SetNextToken(v string) *ListUpdatesInput {
	s.NextToken = &v
	return s
}

// SetNodegroupName sets the NodegroupName field's value.
func (s *ListUpdatesInput) SetNodegroupName(v string) *ListUpdatesInput {
	s.NodegroupName = &v
	return s
}

type ListUpdatesOutput struct {
	_ struct{} `type:"structure"`

	// The nextToken value to include in a future ListUpdates request. When the
	// results of a ListUpdates request exceed maxResults, you can use this value
	// to retrieve the next page of results. This value is null when there are no
	// more results to return.
	NextToken *string `locationName:"nextToken" type:"string"`

	// A list of all the updates for the specified cluster and Region.
	UpdateIds []*string `locationName:"updateIds" type:"list"`
}

// String returns the string representation
func (s ListUpdatesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListUpdatesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListUpdatesOutput) SetNextToken(v string) *ListUpdatesOutput {
	s.NextToken = &v
	return s
}

// SetUpdateIds sets the UpdateIds field's value.
func (s *ListUpdatesOutput) SetUpdateIds(v []*string) *ListUpdatesOutput {
	s.UpdateIds = v
	return s
}

// An object representing the enabled or disabled Kubernetes control plane logs
// for your cluster.
type LogSetup struct {
	_ struct{} `type:"structure"`

	// If a log type is enabled, that log type exports its control plane logs to
	// CloudWatch Logs. If a log type isn't enabled, that log type doesn't export
	// its control plane logs. Each individual log type can be enabled or disabled
	// independently.
	Enabled *bool `locationName:"enabled" type:"boolean"`

	// The available cluster control plane log types.
	Types []*string `locationName:"types" type:"list"`
}

// String returns the string representation
func (s LogSetup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LogSetup) GoString() string {
	return s.String()
}

// SetEnabled sets the Enabled field's value.
func (s *LogSetup) SetEnabled(v bool) *LogSetup {
	s.Enabled = &v
	return s
}

// SetTypes sets the Types field's value.
func (s *LogSetup) SetTypes(v []*string) *LogSetup {
	s.Types = v
	return s
}

// An object representing the logging configuration for resources in your cluster.
type Logging struct {
	_ struct{} `type:"structure"`

	// The cluster control plane logging configuration for your cluster.
	ClusterLogging []*LogSetup `locationName:"clusterLogging" type:"list"`
}

// String returns the string representation
func (s Logging) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Logging) GoString() string {
	return s.String()
}

// SetClusterLogging sets the ClusterLogging field's value.
func (s *Logging) SetClusterLogging(v []*LogSetup) *Logging {
	s.ClusterLogging = v
	return s
}

// An object representing an Amazon EKS managed node group.
type Nodegroup struct {
	_ struct{} `type:"structure"`

	// If the node group was deployed using a launch template with a custom AMI,
	// then this is CUSTOM. For node groups that weren't deployed using a launch
	// template, this is the AMI type that was specified in the node group configuration.
	AmiType *string `locationName:"amiType" type:"string" enum:"AMITypes"`

	// The name of the cluster that the managed node group resides in.
	ClusterName *string `locationName:"clusterName" type:"string"`

	// The Unix epoch timestamp in seconds for when the managed node group was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// If the node group wasn't deployed with a launch template, then this is the
	// disk size in the node group configuration. If the node group was deployed
	// with a launch template, then this is null.
	DiskSize *int64 `locationName:"diskSize" type:"integer"`

	// The health status of the node group. If there are issues with your node group's
	// health, they are listed here.
	Health *NodegroupHealth `locationName:"health" type:"structure"`

	// If the node group wasn't deployed with a launch template, then this is the
	// instance type that is associated with the node group. If the node group was
	// deployed with a launch template, then this is null.
	InstanceTypes []*string `locationName:"instanceTypes" type:"list"`

	// The Kubernetes labels applied to the nodes in the node group.
	//
	// Only labels that are applied with the Amazon EKS API are shown here. There
	// may be other Kubernetes labels applied to the nodes in this group.
	Labels map[string]*string `locationName:"labels" type:"map"`

	// If a launch template was used to create the node group, then this is the
	// launch template that was used.
	LaunchTemplate *LaunchTemplateSpecification `locationName:"launchTemplate" type:"structure"`

	// The Unix epoch timestamp in seconds for when the managed node group was last
	// modified.
	ModifiedAt *time.Time `locationName:"modifiedAt" type:"timestamp"`

	// The IAM role associated with your node group. The Amazon EKS worker node
	// kubelet daemon makes calls to AWS APIs on your behalf. Worker nodes receive
	// permissions for these API calls through an IAM instance profile and associated
	// policies.
	NodeRole *string `locationName:"nodeRole" type:"string"`

	// The Amazon Resource Name (ARN) associated with the managed node group.
	NodegroupArn *string `locationName:"nodegroupArn" type:"string"`

	// The name associated with an Amazon EKS managed node group.
	NodegroupName *string `locationName:"nodegroupName" type:"string"`

	// If the node group was deployed using a launch template with a custom AMI,
	// then this is the AMI ID that was specified in the launch template. For node
	// groups that weren't deployed using a launch template, this is the version
	// of the Amazon EKS-optimized AMI that the node group was deployed with.
	ReleaseVersion *string `locationName:"releaseVersion" type:"string"`

	// If the node group wasn't deployed with a launch template, then this is the
	// remote access configuration that is associated with the node group. If the
	// node group was deployed with a launch template, then this is null.
	RemoteAccess *RemoteAccessConfig `locationName:"remoteAccess" type:"structure"`

	// The resources associated with the node group, such as Auto Scaling groups
	// and security groups for remote access.
	Resources *NodegroupResources `locationName:"resources" type:"structure"`

	// The scaling configuration details for the Auto Scaling group that is associated
	// with your node group.
	ScalingConfig *NodegroupScalingConfig `locationName:"scalingConfig" type:"structure"`

	// The current status of the managed node group.
	Status *string `locationName:"status" type:"string" enum:"NodegroupStatus"`

	// The subnets that were specified for the Auto Scaling group that is associated
	// with your node group.
	Subnets []*string `locationName:"subnets" type:"list"`

	// The metadata applied to the node group to assist with categorization and
	// organization. Each tag consists of a key and an optional value, both of which
	// you define. Node group tags do not propagate to any other resources associated
	// with the node group, such as the Amazon EC2 instances or subnets.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map"`

	// The Kubernetes version of the managed node group.
	Version *string `locationName:"version" type:"string"`
}

// String returns the string representation
func (s Nodegroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Nodegroup) GoString() string {
	return s.String()
}

// SetAmiType sets the AmiType field's value.
func (s *Nodegroup) SetAmiType(v string) *Nodegroup {
	s.AmiType = &v
	return s
}

// SetClusterName sets the ClusterName field's value.
func (s *Nodegroup) SetClusterName(v string) *Nodegroup {
	s.ClusterName = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *Nodegroup) SetCreatedAt(v time.Time) *Nodegroup {
	s.CreatedAt = &v
	return s
}

// SetDiskSize sets the DiskSize field's value.
func (s *Nodegroup) SetDiskSize(v int64) *Nodegroup {
	s.DiskSize = &v
	return s
}

// SetHealth sets the Health field's value.
func (s *Nodegroup) SetHealth(v *NodegroupHealth) *Nodegroup {
	s.Health = v
	return s
}

// SetInstanceTypes sets the InstanceTypes field's value.
func (s *Nodegroup) SetInstanceTypes(v []*string) *Nodegroup {
	s.InstanceTypes = v
	return s
}

// SetLabels sets the Labels field's value.
func (s *Nodegroup) SetLabels(v map[string]*string) *Nodegroup {
	s.Labels = v
	return s
}

// SetLaunchTemplate sets the LaunchTemplate field's value.
func (s *Nodegroup) SetLaunchTemplate(v *LaunchTemplateSpecification) *Nodegroup {
	s.LaunchTemplate = v
	return s
}

// SetModifiedAt sets the ModifiedAt field's value.
func (s *Nodegroup) SetModifiedAt(v time.Time) *Nodegroup {
	s.ModifiedAt = &v
	return s
}

// SetNodeRole sets the NodeRole field's value.
func (s *Nodegroup) SetNodeRole(v string) *Nodegroup {
	s.NodeRole = &v
	return s
}

// SetNodegroupArn sets the NodegroupArn field's value.
func (s *Nodegroup) SetNodegroupArn(v string) *Nodegroup {
	s.NodegroupArn = &v
	return s
}

// SetNodegroupName sets the NodegroupName field's value.
func (s *Nodegroup) SetNodegroupName(v string) *Nodegroup {
	s.NodegroupName = &v
	return s
}

// SetReleaseVersion sets the ReleaseVersion field's value.
func (s *Nodegroup) SetReleaseVersion(v string) *Nodegroup {
	s.ReleaseVersion = &v
	return s
}

// SetRemoteAccess sets the RemoteAccess field's value.
func (s *Nodegroup) SetRemoteAccess(v *RemoteAccessConfig) *Nodegroup {
	s.RemoteAccess = v
	return s
}

// SetResources sets the Resources field's value.
func (s *Nodegroup) SetResources(v *NodegroupResources) *Nodegroup {
	s.Resources = v
	return s
}

// SetScalingConfig sets the ScalingConfig field's value.
func (s *Nodegroup) SetScalingConfig(v *NodegroupScalingConfig) *Nodegroup {
	s.ScalingConfig = v
	return s
}

// SetStatus sets the Status field's value.
func (s *Nodegroup) SetStatus(v string) *Nodegroup {
	s.Status = &v
	return s
}

// SetSubnets sets the Subnets field's value.
func (s *Nodegroup) SetSubnets(v []*string) *Nodegroup {
	s.Subnets = v
	return s
}

// SetTags sets the Tags field's value.
func (s *Nodegroup) SetTags(v map[string]*string) *Nodegroup {
	s.Tags = v
	return s
}

// SetVersion sets the Version field's value.
func (s *Nodegroup) SetVersion(v string) *Nodegroup {
	s.Version = &v
	return s
}

// An object representing the health status of the node group.
type NodegroupHealth struct {
	_ struct{} `type:"structure"`

	// Any issues that are associated with the node group.
	Issues []*Issue `locationName:"issues" type:"list"`
}

// String returns the string representation
func (s NodegroupHealth) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NodegroupHealth) GoString() string {
	return s.String()
}

// SetIssues sets the Issues field's value.
func (s *NodegroupHealth) SetIssues(v []*Issue) *NodegroupHealth {
	s.Issues = v
	return s
}

// An object representing the resources associated with the node group, such
// as Auto Scaling groups and security groups for remote access.
type NodegroupResources struct {
	_ struct{} `type:"structure"`

	// The Auto Scaling groups associated with the node group.
	AutoScalingGroups []*AutoScalingGroup `locationName:"autoScalingGroups" type:"list"`

	// The remote access security group associated with the node group. This security
	// group controls SSH access to the worker nodes.
	RemoteAccessSecurityGroup *string `locationName:"remoteAccessSecurityGroup" type:"string"`
}

// String returns the string representation
func (s NodegroupResources) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NodegroupResources) GoString() string {
	return s.String()
}

// SetAutoScalingGroups sets the AutoScalingGroups field's value.
func (s *NodegroupResources) SetAutoScalingGroups(v []*AutoScalingGroup) *NodegroupResources {
	s.AutoScalingGroups = v
	return s
}

// SetRemoteAccessSecurityGroup sets the RemoteAccessSecurityGroup field's value.
func (s *NodegroupResources) SetRemoteAccessSecurityGroup(v string) *NodegroupResources {
	s.RemoteAccessSecurityGroup = &v
	return s
}

// An object representing the scaling configuration details for the Auto Scaling
// group that is associated with your node group. If you specify a value for
// any property, then you must specify values for all of the properties.
type NodegroupScalingConfig struct {
	_ struct{} `type:"structure"`

	// The current number of worker nodes that the managed node group should maintain.
	DesiredSize *int64 `locationName:"desiredSize" min:"1" type:"integer"`

	// The maximum number of worker nodes that the managed node group can scale
	// out to. Managed node groups can support up to 100 nodes by default.
	MaxSize *int64 `locationName:"maxSize" min:"1" type:"integer"`

	// The minimum number of worker nodes that the managed node group can scale
	// in to. This number must be greater than zero.
	MinSize *int64 `locationName:"minSize" min:"1" type:"integer"`
}

// String returns the string representation
func (s NodegroupScalingConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NodegroupScalingConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *NodegroupScalingConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "NodegroupScalingConfig"}
	if s.DesiredSize != nil && *s.DesiredSize < 1 {
		invalidParams.Add(request.NewErrParamMinValue("DesiredSize", 1))
	}
	if s.MaxSize != nil && *s.MaxSize < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxSize", 1))
	}
	if s.MinSize != nil && *s.MinSize < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MinSize", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDesiredSize sets the DesiredSize field's value.
func (s *NodegroupScalingConfig) SetDesiredSize(v int64) *NodegroupScalingConfig {
	s.DesiredSize = &v
	return s
}

// SetMaxSize sets the MaxSize field's value.
func (s *NodegroupScalingConfig) SetMaxSize(v int64) *NodegroupScalingConfig {
	s.MaxSize = &v
	return s
}

// SetMinSize sets the MinSize field's value.
func (s *NodegroupScalingConfig) SetMinSize(v int64) *NodegroupScalingConfig {
	s.MinSize = &v
	return s
}

// A service resource associated with the request could not be found. Clients
// should not retry such requests.
type NotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s NotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NotFoundException) GoString() string {
	return s.String()
}

func newErrorNotFoundException(v protocol.ResponseMetadata) error {
	return &NotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *NotFoundException) Code() string {
	return "NotFoundException"
}

// Message returns the exception's message.
func (s *NotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *NotFoundException) OrigErr() error {
	return nil
}

func (s *NotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *NotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *NotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// An object representing the OpenID Connect (https://openid.net/connect/) identity
// provider information for the cluster.
type OIDC struct {
	_ struct{} `type:"structure"`

	// The issuer URL for the OpenID Connect identity provider.
	Issuer *string `locationName:"issuer" type:"string"`
}

// String returns the string representation
func (s OIDC) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OIDC) GoString() string {
	return s.String()
}

// SetIssuer sets the Issuer field's value.
func (s *OIDC) SetIssuer(v string) *OIDC {
	s.Issuer = &v
	return s
}

// Identifies the AWS Key Management Service (AWS KMS) customer master key (CMK)
// used to encrypt the secrets.
type Provider struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) or alias of the customer master key (CMK). The
	// CMK must be symmetric, created in the same region as the cluster, and if
	// the CMK was created in a different account, the user must have access to
	// the CMK. For more information, see Allowing Users in Other Accounts to Use
	// a CMK (https://docs.aws.amazon.com/kms/latest/developerguide/key-policy-modifying-external-accounts.html)
	// in the AWS Key Management Service Developer Guide.
	KeyArn *string `locationName:"keyArn" type:"string"`
}

// String returns the string representation
func (s Provider) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Provider) GoString() string {
	return s.String()
}

// SetKeyArn sets the KeyArn field's value.
func (s *Provider) SetKeyArn(v string) *Provider {
	s.KeyArn = &v
	return s
}

// An object representing the remote access configuration for the managed node
// group.
type RemoteAccessConfig struct {
	_ struct{} `type:"structure"`

	// The Amazon EC2 SSH key that provides access for SSH communication with the
	// worker nodes in the managed node group. For more information, see Amazon
	// EC2 Key Pairs (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html)
	// in the Amazon Elastic Compute Cloud User Guide for Linux Instances.
	Ec2SshKey *string `locationName:"ec2SshKey" type:"string"`

	// The security groups that are allowed SSH access (port 22) to the worker nodes.
	// If you specify an Amazon EC2 SSH key but do not specify a source security
	// group when you create a managed node group, then port 22 on the worker nodes
	// is opened to the internet (0.0.0.0/0). For more information, see Security
	// Groups for Your VPC (https://docs.aws.amazon.com/vpc/latest/userguide/VPC_SecurityGroups.html)
	// in the Amazon Virtual Private Cloud User Guide.
	SourceSecurityGroups []*string `locationName:"sourceSecurityGroups" type:"list"`
}

// String returns the string representation
func (s RemoteAccessConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoteAccessConfig) GoString() string {
	return s.String()
}

// SetEc2SshKey sets the Ec2SshKey field's value.
func (s *RemoteAccessConfig) SetEc2SshKey(v string) *RemoteAccessConfig {
	s.Ec2SshKey = &v
	return s
}

// SetSourceSecurityGroups sets the SourceSecurityGroups field's value.
func (s *RemoteAccessConfig) SetSourceSecurityGroups(v []*string) *RemoteAccessConfig {
	s.SourceSecurityGroups = v
	return s
}

// The specified resource is in use.
type ResourceInUseException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The Amazon EKS cluster associated with the exception.
	ClusterName *string `locationName:"clusterName" type:"string"`

	Message_ *string `locationName:"message" type:"string"`

	// The Amazon EKS managed node group associated with the exception.
	NodegroupName *string `locationName:"nodegroupName" type:"string"`
}

// String returns the string representation
func (s ResourceInUseException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceInUseException) GoString() string {
	return s.String()
}

func newErrorResourceInUseException(v protocol.ResponseMetadata) error {
	return &ResourceInUseException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceInUseException) Code() string {
	return "ResourceInUseException"
}

// Message returns the exception's message.
func (s *ResourceInUseException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceInUseException) OrigErr() error {
	return nil
}

func (s *ResourceInUseException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceInUseException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceInUseException) RequestID() string {
	return s.RespMetadata.RequestID
}

// You have encountered a service limit on the specified resource.
type ResourceLimitExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The Amazon EKS cluster associated with the exception.
	ClusterName *string `locationName:"clusterName" type:"string"`

	Message_ *string `locationName:"message" type:"string"`

	// The Amazon EKS managed node group associated with the exception.
	NodegroupName *string `locationName:"nodegroupName" type:"string"`
}

// String returns the string representation
func (s ResourceLimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceLimitExceededException) GoString() string {
	return s.String()
}

func newErrorResourceLimitExceededException(v protocol.ResponseMetadata) error {
	return &ResourceLimitExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceLimitExceededException) Code() string {
	return "ResourceLimitExceededException"
}

// Message returns the exception's message.
func (s *ResourceLimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceLimitExceededException) OrigErr() error {
	return nil
}

func (s *ResourceLimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceLimitExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceLimitExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The specified resource could not be found. You can view your available clusters
// with ListClusters. You can view your available managed node groups with ListNodegroups.
// Amazon EKS clusters and node groups are Region-specific.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The Amazon EKS cluster associated with the exception.
	ClusterName *string `locationName:"clusterName" type:"string"`

	// The Fargate profile associated with the exception.
	FargateProfileName *string `locationName:"fargateProfileName" type:"string"`

	Message_ *string `locationName:"message" type:"string"`

	// The Amazon EKS managed node group associated with the exception.
	NodegroupName *string `locationName:"nodegroupName" type:"string"`
}

// String returns the string representation
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// These errors are usually caused by a server-side issue.
type ServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The Amazon EKS cluster associated with the exception.
	ClusterName *string `locationName:"clusterName" type:"string"`

	Message_ *string `locationName:"message" type:"string"`

	// The Amazon EKS managed node group associated with the exception.
	NodegroupName *string `locationName:"nodegroupName" type:"string"`
}

// String returns the string representation
func (s ServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ServerException) GoString() string {
	return s.String()
}

func newErrorServerException(v protocol.ResponseMetadata) error {
	return &ServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServerException) Code() string {
	return "ServerException"
}

// Message returns the exception's message.
func (s *ServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServerException) OrigErr() error {
	return nil
}

func (s *ServerException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The service is unavailable. Back off and retry the operation.
type ServiceUnavailableException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s ServiceUnavailableException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ServiceUnavailableException) GoString() string {
	return s.String()
}

func newErrorServiceUnavailableException(v protocol.ResponseMetadata) error {
	return &ServiceUnavailableException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceUnavailableException) Code() string {
	return "ServiceUnavailableException"
}

// Message returns the exception's message.
func (s *ServiceUnavailableException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceUnavailableException) OrigErr() error {
	return nil
}

func (s *ServiceUnavailableException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceUnavailableException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceUnavailableException) RequestID() string {
	return s.RespMetadata.RequestID
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource to which to add tags. Currently,
	// the supported resources are Amazon EKS clusters and managed node groups.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`

	// The tags to add to the resource. A tag is an array of key-value pairs.
	//
	// Tags is a required field
	Tags map[string]*string `locationName:"tags" min:"1" type:"map" required:"true"`
}

// String returns the string representation
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v map[string]*string) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// At least one of your specified cluster subnets is in an Availability Zone
// that does not support Amazon EKS. The exception output specifies the supported
// Availability Zones for your account, from which you can choose subnets for
// your cluster.
type UnsupportedAvailabilityZoneException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The Amazon EKS cluster associated with the exception.
	ClusterName *string `locationName:"clusterName" type:"string"`

	Message_ *string `locationName:"message" type:"string"`

	// The Amazon EKS managed node group associated with the exception.
	NodegroupName *string `locationName:"nodegroupName" type:"string"`

	// The supported Availability Zones for your account. Choose subnets in these
	// Availability Zones for your cluster.
	ValidZones []*string `locationName:"validZones" type:"list"`
}

// String returns the string representation
func (s UnsupportedAvailabilityZoneException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UnsupportedAvailabilityZoneException) GoString() string {
	return s.String()
}

func newErrorUnsupportedAvailabilityZoneException(v protocol.ResponseMetadata) error {
	return &UnsupportedAvailabilityZoneException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *UnsupportedAvailabilityZoneException) Code() string {
	return "UnsupportedAvailabilityZoneException"
}

// Message returns the exception's message.
func (s *UnsupportedAvailabilityZoneException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *UnsupportedAvailabilityZoneException) OrigErr() error {
	return nil
}

func (s *UnsupportedAvailabilityZoneException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *UnsupportedAvailabilityZoneException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *UnsupportedAvailabilityZoneException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource from which to delete tags.
	// Currently, the supported resources are Amazon EKS clusters and managed node
	// groups.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`

	// The keys of the tags to be removed.
	//
	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"tagKeys" min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}
	if s.TagKeys != nil && len(s.TagKeys) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TagKeys", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

// An object representing an asynchronous update.
type Update struct {
	_ struct{} `type:"structure"`

	// The Unix epoch timestamp in seconds for when the update was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// Any errors associated with a Failed update.
	Errors []*ErrorDetail `locationName:"errors" type:"list"`

	// A UUID that is used to track the update.
	Id *string `locationName:"id" type:"string"`

	// A key-value map that contains the parameters associated with the update.
	Params []*UpdateParam `locationName:"params" type:"list"`

	// The current status of the update.
	Status *string `locationName:"status" type:"string" enum:"UpdateStatus"`

	// The type of the update.
	Type *string `locationName:"type" type:"string" enum:"UpdateType"`
}

// String returns the string representation
func (s Update) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Update) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *Update) SetCreatedAt(v time.Time) *Update {
	s.CreatedAt = &v
	return s
}

// SetErrors sets the Errors field's value.
func (s *Update) SetErrors(v []*ErrorDetail) *Update {
	s.Errors = v
	return s
}

// SetId sets the Id field's value.
func (s *Update) SetId(v string) *Update {
	s.Id = &v
	return s
}

// SetParams sets the Params field's value.
func (s *Update) SetParams(v []*UpdateParam) *Update {
	s.Params = v
	return s
}

// SetStatus sets the Status field's value.
func (s *Update) SetStatus(v string) *Update {
	s.Status = &v
	return s
}

// SetType sets the Type field's value.
func (s *Update) SetType(v string) *Update {
	s.Type = &v
	return s
}

type UpdateClusterConfigInput struct {
	_ struct{} `type:"structure"`

	// Unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request.
	ClientRequestToken *string `locationName:"clientRequestToken" type:"string" idempotencyToken:"true"`

	// Enable or disable exporting the Kubernetes control plane logs for your cluster
	// to CloudWatch Logs. By default, cluster control plane logs aren't exported
	// to CloudWatch Logs. For more information, see Amazon EKS Cluster Control
	// Plane Logs (https://docs.aws.amazon.com/eks/latest/userguide/control-plane-logs.html)
	// in the Amazon EKS User Guide .
	//
	// CloudWatch Logs ingestion, archive storage, and data scanning rates apply
	// to exported control plane logs. For more information, see Amazon CloudWatch
	// Pricing (http://aws.amazon.com/cloudwatch/pricing/).
	Logging *Logging `locationName:"logging" type:"structure"`

	// The name of the Amazon EKS cluster to update.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" type:"string" required:"true"`

	// An object representing the VPC configuration to use for an Amazon EKS cluster.
	ResourcesVpcConfig *VpcConfigRequest `locationName:"resourcesVpcConfig" type:"structure"`
}

// String returns the string representation
func (s UpdateClusterConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateClusterConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateClusterConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateClusterConfigInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *UpdateClusterConfigInput) SetClientRequestToken(v string) *UpdateClusterConfigInput {
	s.ClientRequestToken = &v
	return s
}

// SetLogging sets the Logging field's value.
func (s *UpdateClusterConfigInput) SetLogging(v *Logging) *UpdateClusterConfigInput {
	s.Logging = v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateClusterConfigInput) SetName(v string) *UpdateClusterConfigInput {
	s.Name = &v
	return s
}

// SetResourcesVpcConfig sets the ResourcesVpcConfig field's value.
func (s *UpdateClusterConfigInput) SetResourcesVpcConfig(v *VpcConfigRequest) *UpdateClusterConfigInput {
	s.ResourcesVpcConfig = v
	return s
}

type UpdateClusterConfigOutput struct {
	_ struct{} `type:"structure"`

	// An object representing an asynchronous update.
	Update *Update `locationName:"update" type:"structure"`
}

// String returns the string representation
func (s UpdateClusterConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateClusterConfigOutput) GoString() string {
	return s.String()
}

// SetUpdate sets the Update field's value.
func (s *UpdateClusterConfigOutput) SetUpdate(v *Update) *UpdateClusterConfigOutput {
	s.Update = v
	return s
}

type UpdateClusterVersionInput struct {
	_ struct{} `type:"structure"`

	// Unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request.
	ClientRequestToken *string `locationName:"clientRequestToken" type:"string" idempotencyToken:"true"`

	// The name of the Amazon EKS cluster to update.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" type:"string" required:"true"`

	// The desired Kubernetes version following a successful update.
	//
	// Version is a required field
	Version *string `locationName:"version" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateClusterVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateClusterVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateClusterVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateClusterVersionInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Version == nil {
		invalidParams.Add(request.NewErrParamRequired("Version"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *UpdateClusterVersionInput) SetClientRequestToken(v string) *UpdateClusterVersionInput {
	s.ClientRequestToken = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateClusterVersionInput) SetName(v string) *UpdateClusterVersionInput {
	s.Name = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *UpdateClusterVersionInput) SetVersion(v string) *UpdateClusterVersionInput {
	s.Version = &v
	return s
}

type UpdateClusterVersionOutput struct {
	_ struct{} `type:"structure"`

	// The full description of the specified update
	Update *Update `locationName:"update" type:"structure"`
}

// String returns the string representation
func (s UpdateClusterVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateClusterVersionOutput) GoString() string {
	return s.String()
}

// SetUpdate sets the Update field's value.
func (s *UpdateClusterVersionOutput) SetUpdate(v *Update) *UpdateClusterVersionOutput {
	s.Update = v
	return s
}

// An object representing a Kubernetes label change for a managed node group.
type UpdateLabelsPayload struct {
	_ struct{} `type:"structure"`

	// Kubernetes labels to be added or updated.
	AddOrUpdateLabels map[string]*string `locationName:"addOrUpdateLabels" type:"map"`

	// Kubernetes labels to be removed.
	RemoveLabels []*string `locationName:"removeLabels" type:"list"`
}

// String returns the string representation
func (s UpdateLabelsPayload) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateLabelsPayload) GoString() string {
	return s.String()
}

// SetAddOrUpdateLabels sets the AddOrUpdateLabels field's value.
func (s *UpdateLabelsPayload) SetAddOrUpdateLabels(v map[string]*string) *UpdateLabelsPayload {
	s.AddOrUpdateLabels = v
	return s
}

// SetRemoveLabels sets the RemoveLabels field's value.
func (s *UpdateLabelsPayload) SetRemoveLabels(v []*string) *UpdateLabelsPayload {
	s.RemoveLabels = v
	return s
}

type UpdateNodegroupConfigInput struct {
	_ struct{} `type:"structure"`

	// Unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request.
	ClientRequestToken *string `locationName:"clientRequestToken" type:"string" idempotencyToken:"true"`

	// The name of the Amazon EKS cluster that the managed node group resides in.
	//
	// ClusterName is a required field
	ClusterName *string `location:"uri" locationName:"name" type:"string" required:"true"`

	// The Kubernetes labels to be applied to the nodes in the node group after
	// the update.
	Labels *UpdateLabelsPayload `locationName:"labels" type:"structure"`

	// The name of the managed node group to update.
	//
	// NodegroupName is a required field
	NodegroupName *string `location:"uri" locationName:"nodegroupName" type:"string" required:"true"`

	// The scaling configuration details for the Auto Scaling group after the update.
	ScalingConfig *NodegroupScalingConfig `locationName:"scalingConfig" type:"structure"`
}

// String returns the string representation
func (s UpdateNodegroupConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateNodegroupConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateNodegroupConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateNodegroupConfigInput"}
	if s.ClusterName == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterName"))
	}
	if s.ClusterName != nil && len(*s.ClusterName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterName", 1))
	}
	if s.NodegroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("NodegroupName"))
	}
	if s.NodegroupName != nil && len(*s.NodegroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NodegroupName", 1))
	}
	if s.ScalingConfig != nil {
		if err := s.ScalingConfig.Validate(); err != nil {
			invalidParams.AddNested("ScalingConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *UpdateNodegroupConfigInput) SetClientRequestToken(v string) *UpdateNodegroupConfigInput {
	s.ClientRequestToken = &v
	return s
}

// SetClusterName sets the ClusterName field's value.
func (s *UpdateNodegroupConfigInput) SetClusterName(v string) *UpdateNodegroupConfigInput {
	s.ClusterName = &v
	return s
}

// SetLabels sets the Labels field's value.
func (s *UpdateNodegroupConfigInput) SetLabels(v *UpdateLabelsPayload) *UpdateNodegroupConfigInput {
	s.Labels = v
	return s
}

// SetNodegroupName sets the NodegroupName field's value.
func (s *UpdateNodegroupConfigInput) SetNodegroupName(v string) *UpdateNodegroupConfigInput {
	s.NodegroupName = &v
	return s
}

// SetScalingConfig sets the ScalingConfig field's value.
func (s *UpdateNodegroupConfigInput) SetScalingConfig(v *NodegroupScalingConfig) *UpdateNodegroupConfigInput {
	s.ScalingConfig = v
	return s
}

type UpdateNodegroupConfigOutput struct {
	_ struct{} `type:"structure"`

	// An object representing an asynchronous update.
	Update *Update `locationName:"update" type:"structure"`
}

// String returns the string representation
func (s UpdateNodegroupConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateNodegroupConfigOutput) GoString() string {
	return s.String()
}

// SetUpdate sets the Update field's value.
func (s *UpdateNodegroupConfigOutput) SetUpdate(v *Update) *UpdateNodegroupConfigOutput {
	s.Update = v
	return s
}

type UpdateNodegroupVersionInput struct {
	_ struct{} `type:"structure"`

	// Unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request.
	ClientRequestToken *string `locationName:"clientRequestToken" type:"string" idempotencyToken:"true"`

	// The name of the Amazon EKS cluster that is associated with the managed node
	// group to update.
	//
	// ClusterName is a required field
	ClusterName *string `location:"uri" locationName:"name" type:"string" required:"true"`

	// Force the update if the existing node group's pods are unable to be drained
	// due to a pod disruption budget issue. If an update fails because pods could
	// not be drained, you can force the update after it fails to terminate the
	// old node whether or not any pods are running on the node.
	Force *bool `locationName:"force" type:"boolean"`

	// An object representing a node group's launch template specification. You
	// can only update a node group using a launch template if the node group was
	// originally deployed with a launch template.
	LaunchTemplate *LaunchTemplateSpecification `locationName:"launchTemplate" type:"structure"`

	// The name of the managed node group to update.
	//
	// NodegroupName is a required field
	NodegroupName *string `location:"uri" locationName:"nodegroupName" type:"string" required:"true"`

	// The AMI version of the Amazon EKS-optimized AMI to use for the update. By
	// default, the latest available AMI version for the node group's Kubernetes
	// version is used. For more information, see Amazon EKS-Optimized Linux AMI
	// Versions (https://docs.aws.amazon.com/eks/latest/userguide/eks-linux-ami-versions.html)
	// in the Amazon EKS User Guide. If you specify launchTemplate, and your launch
	// template uses a custom AMI, then don't specify releaseVersion, or the node
	// group update will fail. For more information about using launch templates
	// with Amazon EKS, see Launch template support (https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html)
	// in the Amazon EKS User Guide.
	ReleaseVersion *string `locationName:"releaseVersion" type:"string"`

	// The Kubernetes version to update to. If no version is specified, then the
	// Kubernetes version of the node group does not change. You can specify the
	// Kubernetes version of the cluster to update the node group to the latest
	// AMI version of the cluster's Kubernetes version. If you specify launchTemplate,
	// and your launch template uses a custom AMI, then don't specify version, or
	// the node group update will fail. For more information about using launch
	// templates with Amazon EKS, see Launch template support (https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html)
	// in the Amazon EKS User Guide.
	Version *string `locationName:"version" type:"string"`
}

// String returns the string representation
func (s UpdateNodegroupVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateNodegroupVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateNodegroupVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateNodegroupVersionInput"}
	if s.ClusterName == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterName"))
	}
	if s.ClusterName != nil && len(*s.ClusterName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterName", 1))
	}
	if s.NodegroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("NodegroupName"))
	}
	if s.NodegroupName != nil && len(*s.NodegroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NodegroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *UpdateNodegroupVersionInput) SetClientRequestToken(v string) *UpdateNodegroupVersionInput {
	s.ClientRequestToken = &v
	return s
}

// SetClusterName sets the ClusterName field's value.
func (s *UpdateNodegroupVersionInput) SetClusterName(v string) *UpdateNodegroupVersionInput {
	s.ClusterName = &v
	return s
}

// SetForce sets the Force field's value.
func (s *UpdateNodegroupVersionInput) SetForce(v bool) *UpdateNodegroupVersionInput {
	s.Force = &v
	return s
}

// SetLaunchTemplate sets the LaunchTemplate field's value.
func (s *UpdateNodegroupVersionInput) SetLaunchTemplate(v *LaunchTemplateSpecification) *UpdateNodegroupVersionInput {
	s.LaunchTemplate = v
	return s
}

// SetNodegroupName sets the NodegroupName field's value.
func (s *UpdateNodegroupVersionInput) SetNodegroupName(v string) *UpdateNodegroupVersionInput {
	s.NodegroupName = &v
	return s
}

// SetReleaseVersion sets the ReleaseVersion field's value.
func (s *UpdateNodegroupVersionInput) SetReleaseVersion(v string) *UpdateNodegroupVersionInput {
	s.ReleaseVersion = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *UpdateNodegroupVersionInput) SetVersion(v string) *UpdateNodegroupVersionInput {
	s.Version = &v
	return s
}

type UpdateNodegroupVersionOutput struct {
	_ struct{} `type:"structure"`

	// An object representing an asynchronous update.
	Update *Update `locationName:"update" type:"structure"`
}

// String returns the string representation
func (s UpdateNodegroupVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateNodegroupVersionOutput) GoString() string {
	return s.String()
}

// SetUpdate sets the Update field's value.
func (s *UpdateNodegroupVersionOutput) SetUpdate(v *Update) *UpdateNodegroupVersionOutput {
	s.Update = v
	return s
}

// An object representing the details of an update request.
type UpdateParam struct {
	_ struct{} `type:"structure"`

	// The keys associated with an update request.
	Type *string `locationName:"type" type:"string" enum:"UpdateParamType"`

	// The value of the keys submitted as part of an update request.
	Value *string `locationName:"value" type:"string"`
}

// String returns the string representation
func (s UpdateParam) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateParam) GoString() string {
	return s.String()
}

// SetType sets the Type field's value.
func (s *UpdateParam) SetType(v string) *UpdateParam {
	s.Type = &v
	return s
}

// SetValue sets the Value field's value.
func (s *UpdateParam) SetValue(v string) *UpdateParam {
	s.Value = &v
	return s
}

// An object representing the VPC configuration to use for an Amazon EKS cluster.
type VpcConfigRequest struct {
	_ struct{} `type:"structure"`

	// Set this value to true to enable private access for your cluster's Kubernetes
	// API server endpoint. If you enable private access, Kubernetes API requests
	// from within your cluster's VPC use the private VPC endpoint. The default
	// value for this parameter is false, which disables private access for your
	// Kubernetes API server. If you disable private access and you have worker
	// nodes or AWS Fargate pods in the cluster, then ensure that publicAccessCidrs
	// includes the necessary CIDR blocks for communication with the worker nodes
	// or Fargate pods. For more information, see Amazon EKS Cluster Endpoint Access
	// Control (https://docs.aws.amazon.com/eks/latest/userguide/cluster-endpoint.html)
	// in the Amazon EKS User Guide .
	EndpointPrivateAccess *bool `locationName:"endpointPrivateAccess" type:"boolean"`

	// Set this value to false to disable public access to your cluster's Kubernetes
	// API server endpoint. If you disable public access, your cluster's Kubernetes
	// API server can only receive requests from within the cluster VPC. The default
	// value for this parameter is true, which enables public access for your Kubernetes
	// API server. For more information, see Amazon EKS Cluster Endpoint Access
	// Control (https://docs.aws.amazon.com/eks/latest/userguide/cluster-endpoint.html)
	// in the Amazon EKS User Guide .
	EndpointPublicAccess *bool `locationName:"endpointPublicAccess" type:"boolean"`

	// The CIDR blocks that are allowed access to your cluster's public Kubernetes
	// API server endpoint. Communication to the endpoint from addresses outside
	// of the CIDR blocks that you specify is denied. The default value is 0.0.0.0/0.
	// If you've disabled private endpoint access and you have worker nodes or AWS
	// Fargate pods in the cluster, then ensure that you specify the necessary CIDR
	// blocks. For more information, see Amazon EKS Cluster Endpoint Access Control
	// (https://docs.aws.amazon.com/eks/latest/userguide/cluster-endpoint.html)
	// in the Amazon EKS User Guide .
	PublicAccessCidrs []*string `locationName:"publicAccessCidrs" type:"list"`

	// Specify one or more security groups for the cross-account elastic network
	// interfaces that Amazon EKS creates to use to allow communication between
	// your worker nodes and the Kubernetes control plane. If you don't specify
	// a security group, the default security group for your VPC is used.
	SecurityGroupIds []*string `locationName:"securityGroupIds" type:"list"`

	// Specify subnets for your Amazon EKS worker nodes. Amazon EKS creates cross-account
	// elastic network interfaces in these subnets to allow communication between
	// your worker nodes and the Kubernetes control plane.
	SubnetIds []*string `locationName:"subnetIds" type:"list"`
}

// String returns the string representation
func (s VpcConfigRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VpcConfigRequest) GoString() string {
	return s.String()
}

// SetEndpointPrivateAccess sets the EndpointPrivateAccess field's value.
func (s *VpcConfigRequest) SetEndpointPrivateAccess(v bool) *VpcConfigRequest {
	s.EndpointPrivateAccess = &v
	return s
}

// SetEndpointPublicAccess sets the EndpointPublicAccess field's value.
func (s *VpcConfigRequest) SetEndpointPublicAccess(v bool) *VpcConfigRequest {
	s.EndpointPublicAccess = &v
	return s
}

// SetPublicAccessCidrs sets the PublicAccessCidrs field's value.
func (s *VpcConfigRequest) SetPublicAccessCidrs(v []*string) *VpcConfigRequest {
	s.PublicAccessCidrs = v
	return s
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *VpcConfigRequest) SetSecurityGroupIds(v []*string) *VpcConfigRequest {
	s.SecurityGroupIds = v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *VpcConfigRequest) SetSubnetIds(v []*string) *VpcConfigRequest {
	s.SubnetIds = v
	return s
}

// An object representing an Amazon EKS cluster VPC configuration response.
type VpcConfigResponse struct {
	_ struct{} `type:"structure"`

	// The cluster security group that was created by Amazon EKS for the cluster.
	// Managed node groups use this security group for control-plane-to-data-plane
	// communication.
	ClusterSecurityGroupId *string `locationName:"clusterSecurityGroupId" type:"string"`

	// This parameter indicates whether the Amazon EKS private API server endpoint
	// is enabled. If the Amazon EKS private API server endpoint is enabled, Kubernetes
	// API requests that originate from within your cluster's VPC use the private
	// VPC endpoint instead of traversing the internet. If this value is disabled
	// and you have worker nodes or AWS Fargate pods in the cluster, then ensure
	// that publicAccessCidrs includes the necessary CIDR blocks for communication
	// with the worker nodes or Fargate pods. For more information, see Amazon EKS
	// Cluster Endpoint Access Control (https://docs.aws.amazon.com/eks/latest/userguide/cluster-endpoint.html)
	// in the Amazon EKS User Guide .
	EndpointPrivateAccess *bool `locationName:"endpointPrivateAccess" type:"boolean"`

	// This parameter indicates whether the Amazon EKS public API server endpoint
	// is enabled. If the Amazon EKS public API server endpoint is disabled, your
	// cluster's Kubernetes API server can only receive requests that originate
	// from within the cluster VPC.
	EndpointPublicAccess *bool `locationName:"endpointPublicAccess" type:"boolean"`

	// The CIDR blocks that are allowed access to your cluster's public Kubernetes
	// API server endpoint. Communication to the endpoint from addresses outside
	// of the listed CIDR blocks is denied. The default value is 0.0.0.0/0. If you've
	// disabled private endpoint access and you have worker nodes or AWS Fargate
	// pods in the cluster, then ensure that the necessary CIDR blocks are listed.
	// For more information, see Amazon EKS Cluster Endpoint Access Control (https://docs.aws.amazon.com/eks/latest/userguide/cluster-endpoint.html)
	// in the Amazon EKS User Guide .
	PublicAccessCidrs []*string `locationName:"publicAccessCidrs" type:"list"`

	// The security groups associated with the cross-account elastic network interfaces
	// that are used to allow communication between your worker nodes and the Kubernetes
	// control plane.
	SecurityGroupIds []*string `locationName:"securityGroupIds" type:"list"`

	// The subnets associated with your cluster.
	SubnetIds []*string `locationName:"subnetIds" type:"list"`

	// The VPC associated with your cluster.
	VpcId *string `locationName:"vpcId" type:"string"`
}

// String returns the string representation
func (s VpcConfigResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VpcConfigResponse) GoString() string {
	return s.String()
}

// SetClusterSecurityGroupId sets the ClusterSecurityGroupId field's value.
func (s *VpcConfigResponse) SetClusterSecurityGroupId(v string) *VpcConfigResponse {
	s.ClusterSecurityGroupId = &v
	return s
}

// SetEndpointPrivateAccess sets the EndpointPrivateAccess field's value.
func (s *VpcConfigResponse) SetEndpointPrivateAccess(v bool) *VpcConfigResponse {
	s.EndpointPrivateAccess = &v
	return s
}

// SetEndpointPublicAccess sets the EndpointPublicAccess field's value.
func (s *VpcConfigResponse) SetEndpointPublicAccess(v bool) *VpcConfigResponse {
	s.EndpointPublicAccess = &v
	return s
}

// SetPublicAccessCidrs sets the PublicAccessCidrs field's value.
func (s *VpcConfigResponse) SetPublicAccessCidrs(v []*string) *VpcConfigResponse {
	s.PublicAccessCidrs = v
	return s
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *VpcConfigResponse) SetSecurityGroupIds(v []*string) *VpcConfigResponse {
	s.SecurityGroupIds = v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *VpcConfigResponse) SetSubnetIds(v []*string) *VpcConfigResponse {
	s.SubnetIds = v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *VpcConfigResponse) SetVpcId(v string) *VpcConfigResponse {
	s.VpcId = &v
	return s
}

const (
	// AMITypesAl2X8664 is a AMITypes enum value
	AMITypesAl2X8664 = "AL2_x86_64"

	// AMITypesAl2X8664Gpu is a AMITypes enum value
	AMITypesAl2X8664Gpu = "AL2_x86_64_GPU"

	// AMITypesAl2Arm64 is a AMITypes enum value
	AMITypesAl2Arm64 = "AL2_ARM_64"
)

// AMITypes_Values returns all elements of the AMITypes enum
func AMITypes_Values() []string {
	return []string{
		AMITypesAl2X8664,
		AMITypesAl2X8664Gpu,
		AMITypesAl2Arm64,
	}
}

const (
	// ClusterStatusCreating is a ClusterStatus enum value
	ClusterStatusCreating = "CREATING"

	// ClusterStatusActive is a ClusterStatus enum value
	ClusterStatusActive = "ACTIVE"

	// ClusterStatusDeleting is a ClusterStatus enum value
	ClusterStatusDeleting = "DELETING"

	// ClusterStatusFailed is a ClusterStatus enum value
	ClusterStatusFailed = "FAILED"

	// ClusterStatusUpdating is a ClusterStatus enum value
	ClusterStatusUpdating = "UPDATING"
)

// ClusterStatus_Values returns all elements of the ClusterStatus enum
func ClusterStatus_Values() []string {
	return []string{
		ClusterStatusCreating,
		ClusterStatusActive,
		ClusterStatusDeleting,
		ClusterStatusFailed,
		ClusterStatusUpdating,
	}
}

const (
	// ErrorCodeSubnetNotFound is a ErrorCode enum value
	ErrorCodeSubnetNotFound = "SubnetNotFound"

	// ErrorCodeSecurityGroupNotFound is a ErrorCode enum value
	ErrorCodeSecurityGroupNotFound = "SecurityGroupNotFound"

	// ErrorCodeEniLimitReached is a ErrorCode enum value
	ErrorCodeEniLimitReached = "EniLimitReached"

	// ErrorCodeIpNotAvailable is a ErrorCode enum value
	ErrorCodeIpNotAvailable = "IpNotAvailable"

	// ErrorCodeAccessDenied is a ErrorCode enum value
	ErrorCodeAccessDenied = "AccessDenied"

	// ErrorCodeOperationNotPermitted is a ErrorCode enum value
	ErrorCodeOperationNotPermitted = "OperationNotPermitted"

	// ErrorCodeVpcIdNotFound is a ErrorCode enum value
	ErrorCodeVpcIdNotFound = "VpcIdNotFound"

	// ErrorCodeUnknown is a ErrorCode enum value
	ErrorCodeUnknown = "Unknown"

	// ErrorCodeNodeCreationFailure is a ErrorCode enum value
	ErrorCodeNodeCreationFailure = "NodeCreationFailure"

	// ErrorCodePodEvictionFailure is a ErrorCode enum value
	ErrorCodePodEvictionFailure = "PodEvictionFailure"

	// ErrorCodeInsufficientFreeAddresses is a ErrorCode enum value
	ErrorCodeInsufficientFreeAddresses = "InsufficientFreeAddresses"

	// ErrorCodeClusterUnreachable is a ErrorCode enum value
	ErrorCodeClusterUnreachable = "ClusterUnreachable"
)

// ErrorCode_Values returns all elements of the ErrorCode enum
func ErrorCode_Values() []string {
	return []string{
		ErrorCodeSubnetNotFound,
		ErrorCodeSecurityGroupNotFound,
		ErrorCodeEniLimitReached,
		ErrorCodeIpNotAvailable,
		ErrorCodeAccessDenied,
		ErrorCodeOperationNotPermitted,
		ErrorCodeVpcIdNotFound,
		ErrorCodeUnknown,
		ErrorCodeNodeCreationFailure,
		ErrorCodePodEvictionFailure,
		ErrorCodeInsufficientFreeAddresses,
		ErrorCodeClusterUnreachable,
	}
}

const (
	// FargateProfileStatusCreating is a FargateProfileStatus enum value
	FargateProfileStatusCreating = "CREATING"

	// FargateProfileStatusActive is a FargateProfileStatus enum value
	FargateProfileStatusActive = "ACTIVE"

	// FargateProfileStatusDeleting is a FargateProfileStatus enum value
	FargateProfileStatusDeleting = "DELETING"

	// FargateProfileStatusCreateFailed is a FargateProfileStatus enum value
	FargateProfileStatusCreateFailed = "CREATE_FAILED"

	// FargateProfileStatusDeleteFailed is a FargateProfileStatus enum value
	FargateProfileStatusDeleteFailed = "DELETE_FAILED"
)

// FargateProfileStatus_Values returns all elements of the FargateProfileStatus enum
func FargateProfileStatus_Values() []string {
	return []string{
		FargateProfileStatusCreating,
		FargateProfileStatusActive,
		FargateProfileStatusDeleting,
		FargateProfileStatusCreateFailed,
		FargateProfileStatusDeleteFailed,
	}
}

const (
	// LogTypeApi is a LogType enum value
	LogTypeApi = "api"

	// LogTypeAudit is a LogType enum value
	LogTypeAudit = "audit"

	// LogTypeAuthenticator is a LogType enum value
	LogTypeAuthenticator = "authenticator"

	// LogTypeControllerManager is a LogType enum value
	LogTypeControllerManager = "controllerManager"

	// LogTypeScheduler is a LogType enum value
	LogTypeScheduler = "scheduler"
)

// LogType_Values returns all elements of the LogType enum
func LogType_Values() []string {
	return []string{
		LogTypeApi,
		LogTypeAudit,
		LogTypeAuthenticator,
		LogTypeControllerManager,
		LogTypeScheduler,
	}
}

const (
	// NodegroupIssueCodeAutoScalingGroupNotFound is a NodegroupIssueCode enum value
	NodegroupIssueCodeAutoScalingGroupNotFound = "AutoScalingGroupNotFound"

	// NodegroupIssueCodeAutoScalingGroupInvalidConfiguration is a NodegroupIssueCode enum value
	NodegroupIssueCodeAutoScalingGroupInvalidConfiguration = "AutoScalingGroupInvalidConfiguration"

	// NodegroupIssueCodeEc2securityGroupNotFound is a NodegroupIssueCode enum value
	NodegroupIssueCodeEc2securityGroupNotFound = "Ec2SecurityGroupNotFound"

	// NodegroupIssueCodeEc2securityGroupDeletionFailure is a NodegroupIssueCode enum value
	NodegroupIssueCodeEc2securityGroupDeletionFailure = "Ec2SecurityGroupDeletionFailure"

	// NodegroupIssueCodeEc2launchTemplateNotFound is a NodegroupIssueCode enum value
	NodegroupIssueCodeEc2launchTemplateNotFound = "Ec2LaunchTemplateNotFound"

	// NodegroupIssueCodeEc2launchTemplateVersionMismatch is a NodegroupIssueCode enum value
	NodegroupIssueCodeEc2launchTemplateVersionMismatch = "Ec2LaunchTemplateVersionMismatch"

	// NodegroupIssueCodeEc2subnetNotFound is a NodegroupIssueCode enum value
	NodegroupIssueCodeEc2subnetNotFound = "Ec2SubnetNotFound"

	// NodegroupIssueCodeEc2subnetInvalidConfiguration is a NodegroupIssueCode enum value
	NodegroupIssueCodeEc2subnetInvalidConfiguration = "Ec2SubnetInvalidConfiguration"

	// NodegroupIssueCodeIamInstanceProfileNotFound is a NodegroupIssueCode enum value
	NodegroupIssueCodeIamInstanceProfileNotFound = "IamInstanceProfileNotFound"

	// NodegroupIssueCodeIamLimitExceeded is a NodegroupIssueCode enum value
	NodegroupIssueCodeIamLimitExceeded = "IamLimitExceeded"

	// NodegroupIssueCodeIamNodeRoleNotFound is a NodegroupIssueCode enum value
	NodegroupIssueCodeIamNodeRoleNotFound = "IamNodeRoleNotFound"

	// NodegroupIssueCodeNodeCreationFailure is a NodegroupIssueCode enum value
	NodegroupIssueCodeNodeCreationFailure = "NodeCreationFailure"

	// NodegroupIssueCodeAsgInstanceLaunchFailures is a NodegroupIssueCode enum value
	NodegroupIssueCodeAsgInstanceLaunchFailures = "AsgInstanceLaunchFailures"

	// NodegroupIssueCodeInstanceLimitExceeded is a NodegroupIssueCode enum value
	NodegroupIssueCodeInstanceLimitExceeded = "InstanceLimitExceeded"

	// NodegroupIssueCodeInsufficientFreeAddresses is a NodegroupIssueCode enum value
	NodegroupIssueCodeInsufficientFreeAddresses = "InsufficientFreeAddresses"

	// NodegroupIssueCodeAccessDenied is a NodegroupIssueCode enum value
	NodegroupIssueCodeAccessDenied = "AccessDenied"

	// NodegroupIssueCodeInternalFailure is a NodegroupIssueCode enum value
	NodegroupIssueCodeInternalFailure = "InternalFailure"

	// NodegroupIssueCodeClusterUnreachable is a NodegroupIssueCode enum value
	NodegroupIssueCodeClusterUnreachable = "ClusterUnreachable"
)

// NodegroupIssueCode_Values returns all elements of the NodegroupIssueCode enum
func NodegroupIssueCode_Values() []string {
	return []string{
		NodegroupIssueCodeAutoScalingGroupNotFound,
		NodegroupIssueCodeAutoScalingGroupInvalidConfiguration,
		NodegroupIssueCodeEc2securityGroupNotFound,
		NodegroupIssueCodeEc2securityGroupDeletionFailure,
		NodegroupIssueCodeEc2launchTemplateNotFound,
		NodegroupIssueCodeEc2launchTemplateVersionMismatch,
		NodegroupIssueCodeEc2subnetNotFound,
		NodegroupIssueCodeEc2subnetInvalidConfiguration,
		NodegroupIssueCodeIamInstanceProfileNotFound,
		NodegroupIssueCodeIamLimitExceeded,
		NodegroupIssueCodeIamNodeRoleNotFound,
		NodegroupIssueCodeNodeCreationFailure,
		NodegroupIssueCodeAsgInstanceLaunchFailures,
		NodegroupIssueCodeInstanceLimitExceeded,
		NodegroupIssueCodeInsufficientFreeAddresses,
		NodegroupIssueCodeAccessDenied,
		NodegroupIssueCodeInternalFailure,
		NodegroupIssueCodeClusterUnreachable,
	}
}

const (
	// NodegroupStatusCreating is a NodegroupStatus enum value
	NodegroupStatusCreating = "CREATING"

	// NodegroupStatusActive is a NodegroupStatus enum value
	NodegroupStatusActive = "ACTIVE"

	// NodegroupStatusUpdating is a NodegroupStatus enum value
	NodegroupStatusUpdating = "UPDATING"

	// NodegroupStatusDeleting is a NodegroupStatus enum value
	NodegroupStatusDeleting = "DELETING"

	// NodegroupStatusCreateFailed is a NodegroupStatus enum value
	NodegroupStatusCreateFailed = "CREATE_FAILED"

	// NodegroupStatusDeleteFailed is a NodegroupStatus enum value
	NodegroupStatusDeleteFailed = "DELETE_FAILED"

	// NodegroupStatusDegraded is a NodegroupStatus enum value
	NodegroupStatusDegraded = "DEGRADED"
)

// NodegroupStatus_Values returns all elements of the NodegroupStatus enum
func NodegroupStatus_Values() []string {
	return []string{
		NodegroupStatusCreating,
		NodegroupStatusActive,
		NodegroupStatusUpdating,
		NodegroupStatusDeleting,
		NodegroupStatusCreateFailed,
		NodegroupStatusDeleteFailed,
		NodegroupStatusDegraded,
	}
}

const (
	// UpdateParamTypeVersion is a UpdateParamType enum value
	UpdateParamTypeVersion = "Version"

	// UpdateParamTypePlatformVersion is a UpdateParamType enum value
	UpdateParamTypePlatformVersion = "PlatformVersion"

	// UpdateParamTypeEndpointPrivateAccess is a UpdateParamType enum value
	UpdateParamTypeEndpointPrivateAccess = "EndpointPrivateAccess"

	// UpdateParamTypeEndpointPublicAccess is a UpdateParamType enum value
	UpdateParamTypeEndpointPublicAccess = "EndpointPublicAccess"

	// UpdateParamTypeClusterLogging is a UpdateParamType enum value
	UpdateParamTypeClusterLogging = "ClusterLogging"

	// UpdateParamTypeDesiredSize is a UpdateParamType enum value
	UpdateParamTypeDesiredSize = "DesiredSize"

	// UpdateParamTypeLabelsToAdd is a UpdateParamType enum value
	UpdateParamTypeLabelsToAdd = "LabelsToAdd"

	// UpdateParamTypeLabelsToRemove is a UpdateParamType enum value
	UpdateParamTypeLabelsToRemove = "LabelsToRemove"

	// UpdateParamTypeMaxSize is a UpdateParamType enum value
	UpdateParamTypeMaxSize = "MaxSize"

	// UpdateParamTypeMinSize is a UpdateParamType enum value
	UpdateParamTypeMinSize = "MinSize"

	// UpdateParamTypeReleaseVersion is a UpdateParamType enum value
	UpdateParamTypeReleaseVersion = "ReleaseVersion"

	// UpdateParamTypePublicAccessCidrs is a UpdateParamType enum value
	UpdateParamTypePublicAccessCidrs = "PublicAccessCidrs"
)

// UpdateParamType_Values returns all elements of the UpdateParamType enum
func UpdateParamType_Values() []string {
	return []string{
		UpdateParamTypeVersion,
		UpdateParamTypePlatformVersion,
		UpdateParamTypeEndpointPrivateAccess,
		UpdateParamTypeEndpointPublicAccess,
		UpdateParamTypeClusterLogging,
		UpdateParamTypeDesiredSize,
		UpdateParamTypeLabelsToAdd,
		UpdateParamTypeLabelsToRemove,
		UpdateParamTypeMaxSize,
		UpdateParamTypeMinSize,
		UpdateParamTypeReleaseVersion,
		UpdateParamTypePublicAccessCidrs,
	}
}

const (
	// UpdateStatusInProgress is a UpdateStatus enum value
	UpdateStatusInProgress = "InProgress"

	// UpdateStatusFailed is a UpdateStatus enum value
	UpdateStatusFailed = "Failed"

	// UpdateStatusCancelled is a UpdateStatus enum value
	UpdateStatusCancelled = "Cancelled"

	// UpdateStatusSuccessful is a UpdateStatus enum value
	UpdateStatusSuccessful = "Successful"
)

// UpdateStatus_Values returns all elements of the UpdateStatus enum
func UpdateStatus_Values() []string {
	return []string{
		UpdateStatusInProgress,
		UpdateStatusFailed,
		UpdateStatusCancelled,
		UpdateStatusSuccessful,
	}
}

const (
	// UpdateTypeVersionUpdate is a UpdateType enum value
	UpdateTypeVersionUpdate = "VersionUpdate"

	// UpdateTypeEndpointAccessUpdate is a UpdateType enum value
	UpdateTypeEndpointAccessUpdate = "EndpointAccessUpdate"

	// UpdateTypeLoggingUpdate is a UpdateType enum value
	UpdateTypeLoggingUpdate = "LoggingUpdate"

	// UpdateTypeConfigUpdate is a UpdateType enum value
	UpdateTypeConfigUpdate = "ConfigUpdate"
)

// UpdateType_Values returns all elements of the UpdateType enum
func UpdateType_Values() []string {
	return []string{
		UpdateTypeVersionUpdate,
		UpdateTypeEndpointAccessUpdate,
		UpdateTypeLoggingUpdate,
		UpdateTypeConfigUpdate,
	}
}
