// Code generated by optgen; DO NOT EDIT.

package norm

import (
	"github.com/cockroachdb/cockroach/pkg/sql/coltypes"
	"github.com/cockroachdb/cockroach/pkg/sql/opt"
	"github.com/cockroachdb/cockroach/pkg/sql/opt/memo"
	"github.com/cockroachdb/cockroach/pkg/sql/opt/props"
	"github.com/cockroachdb/cockroach/pkg/sql/sem/tree"
	"github.com/cockroachdb/cockroach/pkg/sql/sem/types"
)

// InternScanOpDef adds the given value to the memo and returns an ID that
// can be used for later lookup. If the same value was added previously,
// this method is a no-op and returns the ID of the previous value.
func (_f *Factory) InternScanOpDef(val *memo.ScanOpDef) memo.PrivateID {
	return _f.mem.InternScanOpDef(val)
}

// InternVirtualScanOpDef adds the given value to the memo and returns an ID that
// can be used for later lookup. If the same value was added previously,
// this method is a no-op and returns the ID of the previous value.
func (_f *Factory) InternVirtualScanOpDef(val *memo.VirtualScanOpDef) memo.PrivateID {
	return _f.mem.InternVirtualScanOpDef(val)
}

// InternColList adds the given value to the memo and returns an ID that
// can be used for later lookup. If the same value was added previously,
// this method is a no-op and returns the ID of the previous value.
func (_f *Factory) InternColList(val opt.ColList) memo.PrivateID {
	return _f.mem.InternColList(val)
}

// InternIndexJoinDef adds the given value to the memo and returns an ID that
// can be used for later lookup. If the same value was added previously,
// this method is a no-op and returns the ID of the previous value.
func (_f *Factory) InternIndexJoinDef(val *memo.IndexJoinDef) memo.PrivateID {
	return _f.mem.InternIndexJoinDef(val)
}

// InternLookupJoinDef adds the given value to the memo and returns an ID that
// can be used for later lookup. If the same value was added previously,
// this method is a no-op and returns the ID of the previous value.
func (_f *Factory) InternLookupJoinDef(val *memo.LookupJoinDef) memo.PrivateID {
	return _f.mem.InternLookupJoinDef(val)
}

// InternGroupByDef adds the given value to the memo and returns an ID that
// can be used for later lookup. If the same value was added previously,
// this method is a no-op and returns the ID of the previous value.
func (_f *Factory) InternGroupByDef(val *memo.GroupByDef) memo.PrivateID {
	return _f.mem.InternGroupByDef(val)
}

// InternSetOpColMap adds the given value to the memo and returns an ID that
// can be used for later lookup. If the same value was added previously,
// this method is a no-op and returns the ID of the previous value.
func (_f *Factory) InternSetOpColMap(val *memo.SetOpColMap) memo.PrivateID {
	return _f.mem.InternSetOpColMap(val)
}

// InternOrderingChoice adds the given value to the memo and returns an ID that
// can be used for later lookup. If the same value was added previously,
// this method is a no-op and returns the ID of the previous value.
func (_f *Factory) InternOrderingChoice(val *props.OrderingChoice) memo.PrivateID {
	return _f.mem.InternOrderingChoice(val)
}

// InternExplainOpDef adds the given value to the memo and returns an ID that
// can be used for later lookup. If the same value was added previously,
// this method is a no-op and returns the ID of the previous value.
func (_f *Factory) InternExplainOpDef(val *memo.ExplainOpDef) memo.PrivateID {
	return _f.mem.InternExplainOpDef(val)
}

// InternShowTraceOpDef adds the given value to the memo and returns an ID that
// can be used for later lookup. If the same value was added previously,
// this method is a no-op and returns the ID of the previous value.
func (_f *Factory) InternShowTraceOpDef(val *memo.ShowTraceOpDef) memo.PrivateID {
	return _f.mem.InternShowTraceOpDef(val)
}

// InternRowNumberDef adds the given value to the memo and returns an ID that
// can be used for later lookup. If the same value was added previously,
// this method is a no-op and returns the ID of the previous value.
func (_f *Factory) InternRowNumberDef(val *memo.RowNumberDef) memo.PrivateID {
	return _f.mem.InternRowNumberDef(val)
}

// InternSubqueryDef adds the given value to the memo and returns an ID that
// can be used for later lookup. If the same value was added previously,
// this method is a no-op and returns the ID of the previous value.
func (_f *Factory) InternSubqueryDef(val *memo.SubqueryDef) memo.PrivateID {
	return _f.mem.InternSubqueryDef(val)
}

// InternColumnID adds the given value to the memo and returns an ID that
// can be used for later lookup. If the same value was added previously,
// this method is a no-op and returns the ID of the previous value.
func (_f *Factory) InternColumnID(val opt.ColumnID) memo.PrivateID {
	return _f.mem.InternColumnID(val)
}

// InternDatum adds the given value to the memo and returns an ID that
// can be used for later lookup. If the same value was added previously,
// this method is a no-op and returns the ID of the previous value.
func (_f *Factory) InternDatum(val tree.Datum) memo.PrivateID {
	return _f.mem.InternDatum(val)
}

// InternType adds the given value to the memo and returns an ID that
// can be used for later lookup. If the same value was added previously,
// this method is a no-op and returns the ID of the previous value.
func (_f *Factory) InternType(val types.T) memo.PrivateID {
	return _f.mem.InternType(val)
}

// InternTypedExpr adds the given value to the memo and returns an ID that
// can be used for later lookup. If the same value was added previously,
// this method is a no-op and returns the ID of the previous value.
func (_f *Factory) InternTypedExpr(val tree.TypedExpr) memo.PrivateID {
	return _f.mem.InternTypedExpr(val)
}

// InternProjectionsOpDef adds the given value to the memo and returns an ID that
// can be used for later lookup. If the same value was added previously,
// this method is a no-op and returns the ID of the previous value.
func (_f *Factory) InternProjectionsOpDef(val *memo.ProjectionsOpDef) memo.PrivateID {
	return _f.mem.InternProjectionsOpDef(val)
}

// InternMergeOnDef adds the given value to the memo and returns an ID that
// can be used for later lookup. If the same value was added previously,
// this method is a no-op and returns the ID of the previous value.
func (_f *Factory) InternMergeOnDef(val *memo.MergeOnDef) memo.PrivateID {
	return _f.mem.InternMergeOnDef(val)
}

// InternOperator adds the given value to the memo and returns an ID that
// can be used for later lookup. If the same value was added previously,
// this method is a no-op and returns the ID of the previous value.
func (_f *Factory) InternOperator(val opt.Operator) memo.PrivateID {
	return _f.mem.InternOperator(val)
}

// InternColType adds the given value to the memo and returns an ID that
// can be used for later lookup. If the same value was added previously,
// this method is a no-op and returns the ID of the previous value.
func (_f *Factory) InternColType(val coltypes.T) memo.PrivateID {
	return _f.mem.InternColType(val)
}

// InternFuncOpDef adds the given value to the memo and returns an ID that
// can be used for later lookup. If the same value was added previously,
// this method is a no-op and returns the ID of the previous value.
func (_f *Factory) InternFuncOpDef(val *memo.FuncOpDef) memo.PrivateID {
	return _f.mem.InternFuncOpDef(val)
}

// InternTupleOrdinal adds the given value to the memo and returns an ID that
// can be used for later lookup. If the same value was added previously,
// this method is a no-op and returns the ID of the previous value.
func (_f *Factory) InternTupleOrdinal(val memo.TupleOrdinal) memo.PrivateID {
	return _f.mem.InternTupleOrdinal(val)
}

// ConstructScan constructs an expression for the Scan operator.
// Scan returns a result set containing every row in a table by scanning one of
// the table's indexes according to its ordering. The private Def field is an
// *opt.ScanOpDef that identifies the table and index to scan, as well as the
// subset of columns to project from it.
//
// The scan can be constrained and/or have an internal row limit. A scan can be
// executed either as a forward or as a reverse scan (except when it has a limit,
// in which case the direction is fixed).
func (_f *Factory) ConstructScan(
	def memo.PrivateID,
) memo.GroupID {
	_scanExpr := memo.MakeScanExpr(def)
	_group := _f.mem.GroupByFingerprint(_scanExpr.Fingerprint())
	if _group != 0 {
		return _group
	}

	return _f.onConstruct(memo.Expr(_scanExpr))
}

// ConstructVirtualScan constructs an expression for the VirtualScan operator.
// VirtualScan returns a result set containing every row in a virtual table.
// Virtual tables are system tables that are populated "on the fly" with rows
// synthesized from system metadata and other state. An example is the
// "information_schema.tables" virtual table which returns one row for each
// accessible system or user table.
//
// VirtualScan has many of the same characteristics as the Scan operator.
// However, virtual tables do not have indexes or keys, and the physical operator
// used to scan virtual tables does not support limits or constraints. Therefore,
// nearly all the rules that apply to Scan do not apply to VirtualScan, so it
// makes sense to have a separate operator.
func (_f *Factory) ConstructVirtualScan(
	def memo.PrivateID,
) memo.GroupID {
	_virtualScanExpr := memo.MakeVirtualScanExpr(def)
	_group := _f.mem.GroupByFingerprint(_virtualScanExpr.Fingerprint())
	if _group != 0 {
		return _group
	}

	return _f.onConstruct(memo.Expr(_virtualScanExpr))
}

// ConstructValues constructs an expression for the Values operator.
// Values returns a manufactured result set containing a constant number of rows.
// specified by the Rows list field. Each row must contain the same set of
// columns in the same order.
//
// The Rows field contains a list of Tuples, one for each row. Each tuple has
// the same length (same with that of Cols).
//
// The Cols field contains the set of column indices returned by each row
// as an opt.ColList. It is legal for Cols to be empty.
func (_f *Factory) ConstructValues(
	rows memo.ListID,
	cols memo.PrivateID,
) memo.GroupID {
	_valuesExpr := memo.MakeValuesExpr(rows, cols)
	_group := _f.mem.GroupByFingerprint(_valuesExpr.Fingerprint())
	if _group != 0 {
		return _group
	}

	// [HoistValuesSubquery]
	{
		for _, _item := range _f.mem.LookupList(rows) {
			item := _item
			if _f.funcs.HasHoistableSubquery(item) {
				if _f.matchedRule == nil || _f.matchedRule(opt.HoistValuesSubquery) {
					_group = _f.funcs.HoistValuesSubquery(rows, cols)
					_f.mem.AddAltFingerprint(_valuesExpr.Fingerprint(), _group)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.HoistValuesSubquery, _group, 0, 0)
					}
					return _group
				}
			}
		}
	}

	return _f.onConstruct(memo.Expr(_valuesExpr))
}

// ConstructSelect constructs an expression for the Select operator.
// Select filters rows from its input result set, based on the boolean filter
// predicate expression. Rows which do not match the filter are discarded. While
// the Filter operand can be any boolean expression, normalization rules will
// typically convert it to a Filters operator in order to make conjunction list
// matching easier.
func (_f *Factory) ConstructSelect(
	input memo.GroupID,
	filter memo.GroupID,
) memo.GroupID {
	_selectExpr := memo.MakeSelectExpr(input, filter)
	_group := _f.mem.GroupByFingerprint(_selectExpr.Fingerprint())
	if _group != 0 {
		return _group
	}

	// [RejectNullsLeftJoin]
	{
		_expr := _f.mem.NormExpr(input)
		if _expr.Operator() == opt.LeftJoinOp || _expr.Operator() == opt.LeftJoinApplyOp || _expr.Operator() == opt.FullJoinOp || _expr.Operator() == opt.FullJoinApplyOp {
			left := _expr.ChildGroup(_f.Memo(), 0)
			right := _expr.ChildGroup(_f.Memo(), 1)
			on := _expr.ChildGroup(_f.Memo(), 2)
			_filtersExpr := _f.mem.NormExpr(filter).AsFilters()
			if _filtersExpr != nil {
				if _f.funcs.HasNullRejectingFilter(filter, _f.funcs.OutputCols(right)) {
					if _f.matchedRule == nil || _f.matchedRule(opt.RejectNullsLeftJoin) {
						_group = _f.ConstructSelect(
							_f.funcs.ConstructNonLeftJoin(_f.mem.NormExpr(input).Operator(), left, right, on),
							filter,
						)
						_f.mem.AddAltFingerprint(_selectExpr.Fingerprint(), _group)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.RejectNullsLeftJoin, _group, 0, 0)
						}
						return _group
					}
				}
			}
		}
	}

	// [RejectNullsRightJoin]
	{
		_expr := _f.mem.NormExpr(input)
		if _expr.Operator() == opt.RightJoinOp || _expr.Operator() == opt.RightJoinApplyOp || _expr.Operator() == opt.FullJoinOp || _expr.Operator() == opt.FullJoinApplyOp {
			left := _expr.ChildGroup(_f.Memo(), 0)
			right := _expr.ChildGroup(_f.Memo(), 1)
			on := _expr.ChildGroup(_f.Memo(), 2)
			_filtersExpr := _f.mem.NormExpr(filter).AsFilters()
			if _filtersExpr != nil {
				if _f.funcs.HasNullRejectingFilter(filter, _f.funcs.OutputCols(left)) {
					if _f.matchedRule == nil || _f.matchedRule(opt.RejectNullsRightJoin) {
						_group = _f.ConstructSelect(
							_f.funcs.ConstructNonRightJoin(_f.mem.NormExpr(input).Operator(), left, right, on),
							filter,
						)
						_f.mem.AddAltFingerprint(_selectExpr.Fingerprint(), _group)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.RejectNullsRightJoin, _group, 0, 0)
						}
						return _group
					}
				}
			}
		}
	}

	// [EliminateSelect]
	{
		_trueExpr := _f.mem.NormExpr(filter).AsTrue()
		if _trueExpr != nil {
			if _f.matchedRule == nil || _f.matchedRule(opt.EliminateSelect) {
				_group = input
				_f.mem.AddAltFingerprint(_selectExpr.Fingerprint(), _group)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.EliminateSelect, _group, 0, 0)
				}
				return _group
			}
		}
	}

	// [MergeSelects]
	{
		_selectExpr2 := _f.mem.NormExpr(input).AsSelect()
		if _selectExpr2 != nil {
			input := _selectExpr2.Input()
			innerFilter := _selectExpr2.Filter()
			if _f.matchedRule == nil || _f.matchedRule(opt.MergeSelects) {
				_group = _f.ConstructSelect(
					input,
					_f.funcs.ConcatFilters(innerFilter, filter),
				)
				_f.mem.AddAltFingerprint(_selectExpr.Fingerprint(), _group)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.MergeSelects, _group, 0, 0)
				}
				return _group
			}
		}
	}

	// [PushSelectIntoProject]
	{
		_projectExpr := _f.mem.NormExpr(input).AsProject()
		if _projectExpr != nil {
			input := _projectExpr.Input()
			projections := _projectExpr.Projections()
			_filtersExpr := _f.mem.NormExpr(filter).AsFilters()
			if _filtersExpr != nil {
				list := _filtersExpr.Conditions()
				for _, _item := range _f.mem.LookupList(_filtersExpr.Conditions()) {
					condition := _item
					inputCols := _f.funcs.OutputCols(input)
					if _f.funcs.IsBoundBy(condition, inputCols) {
						if _f.matchedRule == nil || _f.matchedRule(opt.PushSelectIntoProject) {
							_group = _f.ConstructSelect(
								_f.ConstructProject(
									_f.ConstructSelect(
										input,
										_f.ConstructFilters(
											_f.funcs.ExtractBoundConditions(list, inputCols),
										),
									),
									projections,
								),
								_f.ConstructFilters(
									_f.funcs.ExtractUnboundConditions(list, inputCols),
								),
							)
							_f.mem.AddAltFingerprint(_selectExpr.Fingerprint(), _group)
							if _f.appliedRule != nil {
								_f.appliedRule(opt.PushSelectIntoProject, _group, 0, 0)
							}
							return _group
						}
					}
				}
			}
		}
	}

	// [MergeSelectInnerJoin]
	{
		_expr := _f.mem.NormExpr(input)
		if _expr.Operator() == opt.InnerJoinOp || _expr.Operator() == opt.InnerJoinApplyOp {
			left := _expr.ChildGroup(_f.Memo(), 0)
			right := _expr.ChildGroup(_f.Memo(), 1)
			on := _expr.ChildGroup(_f.Memo(), 2)
			if _f.matchedRule == nil || _f.matchedRule(opt.MergeSelectInnerJoin) {
				_group = _f.DynamicConstruct(
					_f.mem.NormOp(input),
					memo.DynamicOperands{
						memo.DynamicID(left),
						memo.DynamicID(right),
						memo.DynamicID(_f.funcs.ConcatFilters(on, filter)),
					},
				)
				_f.mem.AddAltFingerprint(_selectExpr.Fingerprint(), _group)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.MergeSelectInnerJoin, _group, 0, 0)
				}
				return _group
			}
		}
	}

	// [PushSelectCondLeftIntoJoinLeftAndRight]
	{
		_expr := _f.mem.NormExpr(input)
		if _expr.Operator() == opt.InnerJoinOp || _expr.Operator() == opt.InnerJoinApplyOp || _expr.Operator() == opt.LeftJoinOp || _expr.Operator() == opt.LeftJoinApplyOp || _expr.Operator() == opt.SemiJoinOp || _expr.Operator() == opt.SemiJoinApplyOp || _expr.Operator() == opt.AntiJoinOp || _expr.Operator() == opt.AntiJoinApplyOp {
			left := _expr.ChildGroup(_f.Memo(), 0)
			right := _expr.ChildGroup(_f.Memo(), 1)
			_zipExpr := _f.mem.NormExpr(_expr.ChildGroup(_f.Memo(), 1)).AsZip()
			if _zipExpr == nil {
				on := _expr.ChildGroup(_f.Memo(), 2)
				_filtersExpr := _f.mem.NormExpr(filter).AsFilters()
				if _filtersExpr != nil {
					list := _filtersExpr.Conditions()
					for _, _item := range _f.mem.LookupList(_filtersExpr.Conditions()) {
						condition := _item
						if _f.funcs.IsBoundBy(condition, _f.funcs.OutputCols(left)) {
							if _f.funcs.CanMap(on, condition, right) {
								if _f.matchedRule == nil || _f.matchedRule(opt.PushSelectCondLeftIntoJoinLeftAndRight) {
									_group = _f.ConstructSelect(
										_f.DynamicConstruct(
											_f.mem.NormOp(input),
											memo.DynamicOperands{
												memo.DynamicID(_f.ConstructSelect(
													left,
													_f.ConstructFilters(
														_f.mem.InternList([]memo.GroupID{condition}),
													),
												)),
												memo.DynamicID(_f.ConstructSelect(
													right,
													_f.ConstructFilters(
														_f.mem.InternList([]memo.GroupID{_f.funcs.Map(on, condition, right)}),
													),
												)),
												memo.DynamicID(on),
											},
										),
										_f.ConstructFilters(
											_f.funcs.RemoveListItem(list, condition),
										),
									)
									_f.mem.AddAltFingerprint(_selectExpr.Fingerprint(), _group)
									if _f.appliedRule != nil {
										_f.appliedRule(opt.PushSelectCondLeftIntoJoinLeftAndRight, _group, 0, 0)
									}
									return _group
								}
							}
						}
					}
				}
			}
		}
	}

	// [PushSelectCondRightIntoJoinLeftAndRight]
	{
		_expr := _f.mem.NormExpr(input)
		if _expr.Operator() == opt.InnerJoinOp || _expr.Operator() == opt.InnerJoinApplyOp || _expr.Operator() == opt.RightJoinOp || _expr.Operator() == opt.RightJoinApplyOp {
			left := _expr.ChildGroup(_f.Memo(), 0)
			right := _expr.ChildGroup(_f.Memo(), 1)
			_zipExpr := _f.mem.NormExpr(_expr.ChildGroup(_f.Memo(), 1)).AsZip()
			if _zipExpr == nil {
				on := _expr.ChildGroup(_f.Memo(), 2)
				_filtersExpr := _f.mem.NormExpr(filter).AsFilters()
				if _filtersExpr != nil {
					list := _filtersExpr.Conditions()
					for _, _item := range _f.mem.LookupList(_filtersExpr.Conditions()) {
						condition := _item
						if _f.funcs.IsBoundBy(condition, _f.funcs.OutputCols(right)) {
							if _f.funcs.CanMap(on, condition, left) {
								if _f.matchedRule == nil || _f.matchedRule(opt.PushSelectCondRightIntoJoinLeftAndRight) {
									_group = _f.ConstructSelect(
										_f.DynamicConstruct(
											_f.mem.NormOp(input),
											memo.DynamicOperands{
												memo.DynamicID(_f.ConstructSelect(
													left,
													_f.ConstructFilters(
														_f.mem.InternList([]memo.GroupID{_f.funcs.Map(on, condition, left)}),
													),
												)),
												memo.DynamicID(_f.ConstructSelect(
													right,
													_f.ConstructFilters(
														_f.mem.InternList([]memo.GroupID{condition}),
													),
												)),
												memo.DynamicID(on),
											},
										),
										_f.ConstructFilters(
											_f.funcs.RemoveListItem(list, condition),
										),
									)
									_f.mem.AddAltFingerprint(_selectExpr.Fingerprint(), _group)
									if _f.appliedRule != nil {
										_f.appliedRule(opt.PushSelectCondRightIntoJoinLeftAndRight, _group, 0, 0)
									}
									return _group
								}
							}
						}
					}
				}
			}
		}
	}

	// [PushSelectIntoJoinLeft]
	{
		_expr := _f.mem.NormExpr(input)
		if _expr.Operator() == opt.InnerJoinOp || _expr.Operator() == opt.InnerJoinApplyOp || _expr.Operator() == opt.LeftJoinOp || _expr.Operator() == opt.LeftJoinApplyOp || _expr.Operator() == opt.SemiJoinOp || _expr.Operator() == opt.SemiJoinApplyOp || _expr.Operator() == opt.AntiJoinOp || _expr.Operator() == opt.AntiJoinApplyOp {
			left := _expr.ChildGroup(_f.Memo(), 0)
			right := _expr.ChildGroup(_f.Memo(), 1)
			on := _expr.ChildGroup(_f.Memo(), 2)
			_filtersExpr := _f.mem.NormExpr(filter).AsFilters()
			if _filtersExpr != nil {
				list := _filtersExpr.Conditions()
				for _, _item := range _f.mem.LookupList(_filtersExpr.Conditions()) {
					condition := _item
					leftCols := _f.funcs.OutputCols(left)
					if _f.funcs.IsBoundBy(condition, leftCols) {
						if _f.matchedRule == nil || _f.matchedRule(opt.PushSelectIntoJoinLeft) {
							_group = _f.ConstructSelect(
								_f.DynamicConstruct(
									_f.mem.NormOp(input),
									memo.DynamicOperands{
										memo.DynamicID(_f.ConstructSelect(
											left,
											_f.ConstructFilters(
												_f.funcs.ExtractBoundConditions(list, leftCols),
											),
										)),
										memo.DynamicID(right),
										memo.DynamicID(on),
									},
								),
								_f.ConstructFilters(
									_f.funcs.ExtractUnboundConditions(list, leftCols),
								),
							)
							_f.mem.AddAltFingerprint(_selectExpr.Fingerprint(), _group)
							if _f.appliedRule != nil {
								_f.appliedRule(opt.PushSelectIntoJoinLeft, _group, 0, 0)
							}
							return _group
						}
					}
				}
			}
		}
	}

	// [PushSelectIntoJoinRight]
	{
		_expr := _f.mem.NormExpr(input)
		if _expr.Operator() == opt.InnerJoinOp || _expr.Operator() == opt.InnerJoinApplyOp || _expr.Operator() == opt.RightJoinOp || _expr.Operator() == opt.RightJoinApplyOp {
			left := _expr.ChildGroup(_f.Memo(), 0)
			right := _expr.ChildGroup(_f.Memo(), 1)
			_zipExpr := _f.mem.NormExpr(_expr.ChildGroup(_f.Memo(), 1)).AsZip()
			if _zipExpr == nil {
				on := _expr.ChildGroup(_f.Memo(), 2)
				_filtersExpr := _f.mem.NormExpr(filter).AsFilters()
				if _filtersExpr != nil {
					list := _filtersExpr.Conditions()
					for _, _item := range _f.mem.LookupList(_filtersExpr.Conditions()) {
						condition := _item
						rightCols := _f.funcs.OutputCols(right)
						if _f.funcs.IsBoundBy(condition, rightCols) {
							if _f.matchedRule == nil || _f.matchedRule(opt.PushSelectIntoJoinRight) {
								_group = _f.ConstructSelect(
									_f.DynamicConstruct(
										_f.mem.NormOp(input),
										memo.DynamicOperands{
											memo.DynamicID(left),
											memo.DynamicID(_f.ConstructSelect(
												right,
												_f.ConstructFilters(
													_f.funcs.ExtractBoundConditions(list, rightCols),
												),
											)),
											memo.DynamicID(on),
										},
									),
									_f.ConstructFilters(
										_f.funcs.ExtractUnboundConditions(list, rightCols),
									),
								)
								_f.mem.AddAltFingerprint(_selectExpr.Fingerprint(), _group)
								if _f.appliedRule != nil {
									_f.appliedRule(opt.PushSelectIntoJoinRight, _group, 0, 0)
								}
								return _group
							}
						}
					}
				}
			}
		}
	}

	// [PushSelectIntoGroupBy]
	{
		groupOp := input
		_expr := _f.mem.NormExpr(input)
		if _expr.Operator() == opt.GroupByOp || _expr.Operator() == opt.DistinctOnOp {
			input := _expr.ChildGroup(_f.Memo(), 0)
			aggregations := _expr.ChildGroup(_f.Memo(), 1)
			def := _expr.PrivateID()
			_filtersExpr := _f.mem.NormExpr(filter).AsFilters()
			if _filtersExpr != nil {
				list := _filtersExpr.Conditions()
				for _, _item := range _f.mem.LookupList(_filtersExpr.Conditions()) {
					condition := _item
					passthroughCols := _f.funcs.GroupingAndConstCols(def, aggregations)
					if _f.funcs.IsBoundBy(condition, passthroughCols) {
						if _f.matchedRule == nil || _f.matchedRule(opt.PushSelectIntoGroupBy) {
							_group = _f.ConstructSelect(
								_f.DynamicConstruct(
									_f.mem.NormOp(groupOp),
									memo.DynamicOperands{
										memo.DynamicID(_f.ConstructSelect(
											input,
											_f.ConstructFilters(
												_f.funcs.ExtractBoundConditions(list, passthroughCols),
											),
										)),
										memo.DynamicID(aggregations),
										memo.DynamicID(def),
									},
								),
								_f.ConstructFilters(
									_f.funcs.ExtractUnboundConditions(list, passthroughCols),
								),
							)
							_f.mem.AddAltFingerprint(_selectExpr.Fingerprint(), _group)
							if _f.appliedRule != nil {
								_f.appliedRule(opt.PushSelectIntoGroupBy, _group, 0, 0)
							}
							return _group
						}
					}
				}
			}
		}
	}

	// [RemoveNotNullCondition]
	{
		_filtersExpr := _f.mem.NormExpr(filter).AsFilters()
		if _filtersExpr != nil {
			list := _filtersExpr.Conditions()
			for _, _item := range _f.mem.LookupList(_filtersExpr.Conditions()) {
				condition := _item
				_isNotExpr := _f.mem.NormExpr(_item).AsIsNot()
				if _isNotExpr != nil {
					_variableExpr := _f.mem.NormExpr(_isNotExpr.Left()).AsVariable()
					if _variableExpr != nil {
						col := _variableExpr.Col()
						if _f.funcs.IsColNotNull(col, input) {
							_nullExpr := _f.mem.NormExpr(_isNotExpr.Right()).AsNull()
							if _nullExpr != nil {
								if _f.matchedRule == nil || _f.matchedRule(opt.RemoveNotNullCondition) {
									_group = _f.ConstructSelect(
										input,
										_f.ConstructFilters(
											_f.funcs.RemoveListItem(list, condition),
										),
									)
									_f.mem.AddAltFingerprint(_selectExpr.Fingerprint(), _group)
									if _f.appliedRule != nil {
										_f.appliedRule(opt.RemoveNotNullCondition, _group, 0, 0)
									}
									return _group
								}
							}
						}
					}
				}
			}
		}
	}

	// [HoistSelectExists]
	{
		if _f.funcs.HasHoistableSubquery(filter) {
			_filtersExpr := _f.mem.NormExpr(filter).AsFilters()
			if _filtersExpr != nil {
				list := _filtersExpr.Conditions()
				for _, _item := range _f.mem.LookupList(_filtersExpr.Conditions()) {
					exists := _item
					_existsExpr := _f.mem.NormExpr(_item).AsExists()
					if _existsExpr != nil {
						subquery := _existsExpr.Input()
						if _f.funcs.HasOuterCols(subquery) {
							if _f.matchedRule == nil || _f.matchedRule(opt.HoistSelectExists) {
								_group = _f.ConstructSelect(
									_f.ConstructSemiJoinApply(
										input,
										subquery,
										_f.ConstructTrue(),
									),
									_f.ConstructFilters(
										_f.funcs.RemoveListItem(list, exists),
									),
								)
								_f.mem.AddAltFingerprint(_selectExpr.Fingerprint(), _group)
								if _f.appliedRule != nil {
									_f.appliedRule(opt.HoistSelectExists, _group, 0, 0)
								}
								return _group
							}
						}
					}
				}
			}
		}
	}

	// [HoistSelectNotExists]
	{
		if _f.funcs.HasHoistableSubquery(filter) {
			_filtersExpr := _f.mem.NormExpr(filter).AsFilters()
			if _filtersExpr != nil {
				list := _filtersExpr.Conditions()
				for _, _item := range _f.mem.LookupList(_filtersExpr.Conditions()) {
					exists := _item
					_notExpr := _f.mem.NormExpr(_item).AsNot()
					if _notExpr != nil {
						_existsExpr := _f.mem.NormExpr(_notExpr.Input()).AsExists()
						if _existsExpr != nil {
							subquery := _existsExpr.Input()
							if _f.funcs.HasOuterCols(subquery) {
								if _f.matchedRule == nil || _f.matchedRule(opt.HoistSelectNotExists) {
									_group = _f.ConstructSelect(
										_f.ConstructAntiJoinApply(
											input,
											subquery,
											_f.ConstructTrue(),
										),
										_f.ConstructFilters(
											_f.funcs.RemoveListItem(list, exists),
										),
									)
									_f.mem.AddAltFingerprint(_selectExpr.Fingerprint(), _group)
									if _f.appliedRule != nil {
										_f.appliedRule(opt.HoistSelectNotExists, _group, 0, 0)
									}
									return _group
								}
							}
						}
					}
				}
			}
		}
	}

	// [HoistSelectSubquery]
	{
		if _f.funcs.HasHoistableSubquery(filter) {
			_filtersExpr := _f.mem.NormExpr(filter).AsFilters()
			if _filtersExpr != nil {
				if _f.matchedRule == nil || _f.matchedRule(opt.HoistSelectSubquery) {
					_group = _f.funcs.HoistSelectSubquery(input, filter)
					_f.mem.AddAltFingerprint(_selectExpr.Fingerprint(), _group)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.HoistSelectSubquery, _group, 0, 0)
					}
					return _group
				}
			}
		}
	}

	// [PushSelectIntoInlinableProject]
	{
		_projectExpr := _f.mem.NormExpr(input).AsProject()
		if _projectExpr != nil {
			input := _projectExpr.Input()
			projections := _projectExpr.Projections()
			if _f.funcs.CanInline(projections) {
				if !_f.funcs.HasCorrelatedSubquery(filter) {
					if _f.matchedRule == nil || _f.matchedRule(opt.PushSelectIntoInlinableProject) {
						_group = _f.ConstructProject(
							_f.ConstructSelect(
								input,
								_f.funcs.InlineProjections(filter, projections),
							),
							projections,
						)
						_f.mem.AddAltFingerprint(_selectExpr.Fingerprint(), _group)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.PushSelectIntoInlinableProject, _group, 0, 0)
						}
						return _group
					}
				}
			}
		}
	}

	// [RejectNullsGroupBy]
	{
		_expr := _f.mem.NormExpr(input)
		if _expr.Operator() == opt.GroupByOp || _expr.Operator() == opt.ScalarGroupByOp {
			innerInput := _expr.ChildGroup(_f.Memo(), 0)
			aggregations := _expr.ChildGroup(_f.Memo(), 1)
			def := _expr.PrivateID()
			_filtersExpr := _f.mem.NormExpr(filter).AsFilters()
			if _filtersExpr != nil {
				rejectCols := _f.funcs.RejectNullCols(input)
				if _f.funcs.HasNullRejectingFilter(filter, rejectCols) {
					if _f.matchedRule == nil || _f.matchedRule(opt.RejectNullsGroupBy) {
						_group = _f.ConstructSelect(
							_f.DynamicConstruct(
								_f.mem.NormOp(input),
								memo.DynamicOperands{
									memo.DynamicID(_f.ConstructSelect(
										innerInput,
										_f.ConstructFilters(
											_f.mem.InternList([]memo.GroupID{_f.ConstructIsNot(
												_f.funcs.NullRejectAggVar(aggregations, rejectCols),
												_f.ConstructNull(
													_f.funcs.AnyType(),
												),
											)}),
										),
									)),
									memo.DynamicID(aggregations),
									memo.DynamicID(def),
								},
							),
							filter,
						)
						_f.mem.AddAltFingerprint(_selectExpr.Fingerprint(), _group)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.RejectNullsGroupBy, _group, 0, 0)
						}
						return _group
					}
				}
			}
		}
	}

	return _f.onConstruct(memo.Expr(_selectExpr))
}

// ConstructProject constructs an expression for the Project operator.
// Project modifies the set of columns returned by the input result set. Columns
// can be removed, reordered, or renamed. In addition, new columns can be
// synthesized.
// Projections is a scalar Projections list operator that contains information
// about the projected columns and any expressions that describe newly
// synthesized output columns.
func (_f *Factory) ConstructProject(
	input memo.GroupID,
	projections memo.GroupID,
) memo.GroupID {
	_projectExpr := memo.MakeProjectExpr(input, projections)
	_group := _f.mem.GroupByFingerprint(_projectExpr.Fingerprint())
	if _group != 0 {
		return _group
	}

	// [EliminateProject]
	{
		_projectionsExpr := _f.mem.NormExpr(projections).AsProjections()
		if _projectionsExpr != nil {
			if _projectionsExpr.Elems().Length == 0 {
				if _f.funcs.HasSameCols(input, projections) {
					if _f.matchedRule == nil || _f.matchedRule(opt.EliminateProject) {
						_group = input
						_f.mem.AddAltFingerprint(_projectExpr.Fingerprint(), _group)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.EliminateProject, _group, 0, 0)
						}
						return _group
					}
				}
			}
		}
	}

	// [EliminateProjectProject]
	{
		_projectExpr2 := _f.mem.NormExpr(input).AsProject()
		if _projectExpr2 != nil {
			innerInput := _projectExpr2.Input()
			_projectionsExpr := _f.mem.NormExpr(_projectExpr2.Projections()).AsProjections()
			if _projectionsExpr != nil {
				if _projectionsExpr.Elems().Length == 0 {
					if _f.matchedRule == nil || _f.matchedRule(opt.EliminateProjectProject) {
						_group = _f.ConstructProject(
							innerInput,
							projections,
						)
						_f.mem.AddAltFingerprint(_projectExpr.Fingerprint(), _group)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.EliminateProjectProject, _group, 0, 0)
						}
						return _group
					}
				}
			}
		}
	}

	// [PruneProjectCols]
	{
		_projectExpr2 := _f.mem.NormExpr(input).AsProject()
		if _projectExpr2 != nil {
			innerInput := _projectExpr2.Input()
			innerProjections := _projectExpr2.Projections()
			if _f.funcs.CanPruneCols(innerProjections, _f.funcs.NeededCols(projections)) {
				if _f.matchedRule == nil || _f.matchedRule(opt.PruneProjectCols) {
					_group = _f.ConstructProject(
						_f.ConstructProject(
							innerInput,
							_f.funcs.PruneCols(innerProjections, _f.funcs.NeededCols(projections)),
						),
						projections,
					)
					_f.mem.AddAltFingerprint(_projectExpr.Fingerprint(), _group)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.PruneProjectCols, _group, 0, 0)
					}
					return _group
				}
			}
		}
	}

	// [PruneScanCols]
	{
		_scanExpr := _f.mem.NormExpr(input).AsScan()
		if _scanExpr != nil {
			if _f.funcs.CanPruneCols(input, _f.funcs.NeededCols(projections)) {
				if _f.matchedRule == nil || _f.matchedRule(opt.PruneScanCols) {
					_group = _f.ConstructProject(
						_f.funcs.PruneCols(input, _f.funcs.NeededCols(projections)),
						projections,
					)
					_f.mem.AddAltFingerprint(_projectExpr.Fingerprint(), _group)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.PruneScanCols, _group, 0, 0)
					}
					return _group
				}
			}
		}
	}

	// [PruneSelectCols]
	{
		_selectExpr := _f.mem.NormExpr(input).AsSelect()
		if _selectExpr != nil {
			input := _selectExpr.Input()
			filter := _selectExpr.Filter()
			if _f.funcs.CanPruneCols(input, _f.funcs.NeededCols2(projections, filter)) {
				if !_f.ruleCycles.detectCycle(_projectExpr.Fingerprint()) {
					if _f.matchedRule == nil || _f.matchedRule(opt.PruneSelectCols) {
						_f.ruleCycles.push(_projectExpr.Fingerprint())
						_group = _f.ConstructProject(
							_f.ConstructSelect(
								_f.funcs.PruneCols(input, _f.funcs.NeededCols2(projections, filter)),
								filter,
							),
							projections,
						)
						_f.ruleCycles.pop()
						if _f.mem.GroupByFingerprint(_projectExpr.Fingerprint()) == 0 {
							_f.mem.AddAltFingerprint(_projectExpr.Fingerprint(), _group)
						}
						if _f.appliedRule != nil {
							_f.appliedRule(opt.PruneSelectCols, _group, 0, 0)
						}
						return _group
					}
				}
			}
		}
	}

	// [PruneLimitCols]
	{
		_limitExpr := _f.mem.NormExpr(input).AsLimit()
		if _limitExpr != nil {
			input := _limitExpr.Input()
			limit := _limitExpr.Limit()
			ordering := _limitExpr.Ordering()
			if _f.funcs.CanPruneCols(input, _f.funcs.NeededColsLimit(projections, ordering)) {
				if !_f.ruleCycles.detectCycle(_projectExpr.Fingerprint()) {
					if _f.matchedRule == nil || _f.matchedRule(opt.PruneLimitCols) {
						_f.ruleCycles.push(_projectExpr.Fingerprint())
						newInput := _f.funcs.PruneCols(input, _f.funcs.NeededColsLimit(projections, ordering))
						_group = _f.ConstructProject(
							_f.ConstructLimit(
								newInput,
								limit,
								_f.funcs.PruneOrdering(newInput, ordering),
							),
							projections,
						)
						_f.ruleCycles.pop()
						if _f.mem.GroupByFingerprint(_projectExpr.Fingerprint()) == 0 {
							_f.mem.AddAltFingerprint(_projectExpr.Fingerprint(), _group)
						}
						if _f.appliedRule != nil {
							_f.appliedRule(opt.PruneLimitCols, _group, 0, 0)
						}
						return _group
					}
				}
			}
		}
	}

	// [PruneOffsetCols]
	{
		_offsetExpr := _f.mem.NormExpr(input).AsOffset()
		if _offsetExpr != nil {
			input := _offsetExpr.Input()
			offset := _offsetExpr.Offset()
			ordering := _offsetExpr.Ordering()
			if _f.funcs.CanPruneCols(input, _f.funcs.NeededColsLimit(projections, ordering)) {
				if !_f.ruleCycles.detectCycle(_projectExpr.Fingerprint()) {
					if _f.matchedRule == nil || _f.matchedRule(opt.PruneOffsetCols) {
						_f.ruleCycles.push(_projectExpr.Fingerprint())
						newInput := _f.funcs.PruneCols(input, _f.funcs.NeededColsLimit(projections, ordering))
						_group = _f.ConstructProject(
							_f.ConstructOffset(
								newInput,
								offset,
								_f.funcs.PruneOrdering(newInput, ordering),
							),
							projections,
						)
						_f.ruleCycles.pop()
						if _f.mem.GroupByFingerprint(_projectExpr.Fingerprint()) == 0 {
							_f.mem.AddAltFingerprint(_projectExpr.Fingerprint(), _group)
						}
						if _f.appliedRule != nil {
							_f.appliedRule(opt.PruneOffsetCols, _group, 0, 0)
						}
						return _group
					}
				}
			}
		}
	}

	// [PruneJoinLeftCols]
	{
		_expr := _f.mem.NormExpr(input)
		if _expr.IsJoin() {
			left := _expr.ChildGroup(_f.Memo(), 0)
			right := _expr.ChildGroup(_f.Memo(), 1)
			on := _expr.ChildGroup(_f.Memo(), 2)
			if _f.funcs.CanPruneCols(left, _f.funcs.NeededCols3(projections, right, on)) {
				if _f.matchedRule == nil || _f.matchedRule(opt.PruneJoinLeftCols) {
					_group = _f.ConstructProject(
						_f.DynamicConstruct(
							_f.mem.NormOp(input),
							memo.DynamicOperands{
								memo.DynamicID(_f.funcs.PruneCols(left, _f.funcs.NeededCols3(projections, right, on))),
								memo.DynamicID(right),
								memo.DynamicID(on),
							},
						),
						projections,
					)
					_f.mem.AddAltFingerprint(_projectExpr.Fingerprint(), _group)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.PruneJoinLeftCols, _group, 0, 0)
					}
					return _group
				}
			}
		}
	}

	// [PruneJoinRightCols]
	{
		_expr := _f.mem.NormExpr(input)
		if _expr.IsJoin() {
			left := _expr.ChildGroup(_f.Memo(), 0)
			right := _expr.ChildGroup(_f.Memo(), 1)
			on := _expr.ChildGroup(_f.Memo(), 2)
			if _f.funcs.CanPruneCols(right, _f.funcs.NeededCols2(projections, on)) {
				if !_f.ruleCycles.detectCycle(_projectExpr.Fingerprint()) {
					if _f.matchedRule == nil || _f.matchedRule(opt.PruneJoinRightCols) {
						_f.ruleCycles.push(_projectExpr.Fingerprint())
						_group = _f.ConstructProject(
							_f.DynamicConstruct(
								_f.mem.NormOp(input),
								memo.DynamicOperands{
									memo.DynamicID(left),
									memo.DynamicID(_f.funcs.PruneCols(right, _f.funcs.NeededCols2(projections, on))),
									memo.DynamicID(on),
								},
							),
							projections,
						)
						_f.ruleCycles.pop()
						if _f.mem.GroupByFingerprint(_projectExpr.Fingerprint()) == 0 {
							_f.mem.AddAltFingerprint(_projectExpr.Fingerprint(), _group)
						}
						if _f.appliedRule != nil {
							_f.appliedRule(opt.PruneJoinRightCols, _group, 0, 0)
						}
						return _group
					}
				}
			}
		}
	}

	// [PruneAggCols]
	{
		_expr := _f.mem.NormExpr(input)
		if _expr.Operator() == opt.GroupByOp || _expr.Operator() == opt.ScalarGroupByOp || _expr.Operator() == opt.DistinctOnOp {
			innerInput := _expr.ChildGroup(_f.Memo(), 0)
			aggregations := _expr.ChildGroup(_f.Memo(), 1)
			def := _expr.PrivateID()
			if _f.funcs.CanPruneCols(aggregations, _f.funcs.NeededCols(projections)) {
				if _f.matchedRule == nil || _f.matchedRule(opt.PruneAggCols) {
					_group = _f.ConstructProject(
						_f.DynamicConstruct(
							_f.mem.NormOp(input),
							memo.DynamicOperands{
								memo.DynamicID(innerInput),
								memo.DynamicID(_f.funcs.PruneCols(aggregations, _f.funcs.NeededCols(projections))),
								memo.DynamicID(def),
							},
						),
						projections,
					)
					_f.mem.AddAltFingerprint(_projectExpr.Fingerprint(), _group)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.PruneAggCols, _group, 0, 0)
					}
					return _group
				}
			}
		}
	}

	// [PruneValuesCols]
	{
		_valuesExpr := _f.mem.NormExpr(input).AsValues()
		if _valuesExpr != nil {
			if _f.funcs.CanPruneCols(input, _f.funcs.NeededCols(projections)) {
				if _f.matchedRule == nil || _f.matchedRule(opt.PruneValuesCols) {
					_group = _f.ConstructProject(
						_f.funcs.PruneCols(input, _f.funcs.NeededCols(projections)),
						projections,
					)
					_f.mem.AddAltFingerprint(_projectExpr.Fingerprint(), _group)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.PruneValuesCols, _group, 0, 0)
					}
					return _group
				}
			}
		}
	}

	// [PruneRowNumberCols]
	{
		_rowNumberExpr := _f.mem.NormExpr(input).AsRowNumber()
		if _rowNumberExpr != nil {
			input := _rowNumberExpr.Input()
			def := _rowNumberExpr.Def()
			if _f.funcs.CanPruneCols(input, _f.funcs.NeededColsRowNumber(projections, def)) {
				if _f.matchedRule == nil || _f.matchedRule(opt.PruneRowNumberCols) {
					newInput := _f.funcs.PruneCols(input, _f.funcs.NeededColsRowNumber(projections, def))
					_group = _f.ConstructProject(
						_f.ConstructRowNumber(
							newInput,
							_f.funcs.PruneOrderingRowNumber(newInput, def),
						),
						projections,
					)
					_f.mem.AddAltFingerprint(_projectExpr.Fingerprint(), _group)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.PruneRowNumberCols, _group, 0, 0)
					}
					return _group
				}
			}
		}
	}

	// [HoistProjectSubquery]
	{
		if _f.funcs.HasHoistableSubquery(projections) {
			if _f.matchedRule == nil || _f.matchedRule(opt.HoistProjectSubquery) {
				_group = _f.funcs.HoistProjectSubquery(input, projections)
				_f.mem.AddAltFingerprint(_projectExpr.Fingerprint(), _group)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.HoistProjectSubquery, _group, 0, 0)
				}
				return _group
			}
		}
	}

	// [InlineProjectInProject]
	{
		_projectExpr2 := _f.mem.NormExpr(input).AsProject()
		if _projectExpr2 != nil {
			innerInput := _projectExpr2.Input()
			innerProjections := _projectExpr2.Projections()
			if !_f.funcs.HasDuplicateRefs(projections) {
				if _f.matchedRule == nil || _f.matchedRule(opt.InlineProjectInProject) {
					_group = _f.ConstructProject(
						innerInput,
						_f.funcs.InlineProjections(projections, innerProjections),
					)
					_f.mem.AddAltFingerprint(_projectExpr.Fingerprint(), _group)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.InlineProjectInProject, _group, 0, 0)
					}
					return _group
				}
			}
		}
	}

	return _f.onConstruct(memo.Expr(_projectExpr))
}

// ConstructInnerJoin constructs an expression for the InnerJoin operator.
// InnerJoin creates a result set that combines columns from its left and right
// inputs, based upon its "on" join predicate. Rows which do not match the
// predicate are filtered. While expressions in the predicate can refer to
// columns projected by either the left or right inputs, the inputs are not
// allowed to refer to the other's projected columns.
func (_f *Factory) ConstructInnerJoin(
	left memo.GroupID,
	right memo.GroupID,
	on memo.GroupID,
) memo.GroupID {
	_innerJoinExpr := memo.MakeInnerJoinExpr(left, right, on)
	_group := _f.mem.GroupByFingerprint(_innerJoinExpr.Fingerprint())
	if _group != 0 {
		return _group
	}

	// [TryDecorrelateSelect]
	{
		if _f.funcs.HasOuterCols(right) {
			_selectExpr := _f.mem.NormExpr(right).AsSelect()
			if _selectExpr != nil {
				input := _selectExpr.Input()
				filter := _selectExpr.Filter()
				if !_f.ruleCycles.detectCycle(_innerJoinExpr.Fingerprint()) {
					if _f.matchedRule == nil || _f.matchedRule(opt.TryDecorrelateSelect) {
						_f.ruleCycles.push(_innerJoinExpr.Fingerprint())
						_group = _f.ConstructInnerJoin(
							left,
							input,
							_f.funcs.ConcatFilters(on, filter),
						)
						_f.ruleCycles.pop()
						if _f.mem.GroupByFingerprint(_innerJoinExpr.Fingerprint()) == 0 {
							_f.mem.AddAltFingerprint(_innerJoinExpr.Fingerprint(), _group)
						}
						if _f.appliedRule != nil {
							_f.appliedRule(opt.TryDecorrelateSelect, _group, 0, 0)
						}
						return _group
					}
				}
			}
		}
	}

	// [TryDecorrelateInnerJoin]
	{
		if _f.funcs.HasOuterCols(right) {
			_expr := _f.mem.NormExpr(right)
			if _expr.Operator() == opt.InnerJoinOp || _expr.Operator() == opt.InnerJoinApplyOp {
				innerLeft := _expr.ChildGroup(_f.Memo(), 0)
				innerRight := _expr.ChildGroup(_f.Memo(), 1)
				innerOn := _expr.ChildGroup(_f.Memo(), 2)
				if !_f.ruleCycles.detectCycle(_innerJoinExpr.Fingerprint()) {
					if _f.matchedRule == nil || _f.matchedRule(opt.TryDecorrelateInnerJoin) {
						_f.ruleCycles.push(_innerJoinExpr.Fingerprint())
						_group = _f.ConstructInnerJoin(
							left,
							_f.DynamicConstruct(
								_f.mem.NormOp(right),
								memo.DynamicOperands{
									memo.DynamicID(innerLeft),
									memo.DynamicID(innerRight),
									memo.DynamicID(_f.ConstructTrue()),
								},
							),
							_f.funcs.ConcatFilters(on, innerOn),
						)
						_f.ruleCycles.pop()
						if _f.mem.GroupByFingerprint(_innerJoinExpr.Fingerprint()) == 0 {
							_f.mem.AddAltFingerprint(_innerJoinExpr.Fingerprint(), _group)
						}
						if _f.appliedRule != nil {
							_f.appliedRule(opt.TryDecorrelateInnerJoin, _group, 0, 0)
						}
						return _group
					}
				}
			}
		}
	}

	// [TryDecorrelateProject]
	{
		if _f.funcs.HasOuterCols(right) {
			_projectExpr := _f.mem.NormExpr(right).AsProject()
			if _projectExpr != nil {
				input := _projectExpr.Input()
				projections := _projectExpr.Projections()
				if _f.matchedRule == nil || _f.matchedRule(opt.TryDecorrelateProject) {
					_group = _f.ConstructSelect(
						_f.ConstructProject(
							_f.ConstructInnerJoin(
								left,
								input,
								_f.ConstructTrue(),
							),
							_f.funcs.ProjectColsFromBoth(projections, left),
						),
						on,
					)
					_f.mem.AddAltFingerprint(_innerJoinExpr.Fingerprint(), _group)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.TryDecorrelateProject, _group, 0, 0)
					}
					return _group
				}
			}
		}
	}

	// [TryDecorrelateInnerLeftJoin]
	{
		if _f.funcs.HasOuterCols(right) {
			_leftJoinExpr := _f.mem.NormExpr(right).AsLeftJoin()
			if _leftJoinExpr != nil {
				innerLeft := _leftJoinExpr.Left()
				innerRight := _leftJoinExpr.Right()
				innerOn := _leftJoinExpr.On()
				if _f.funcs.IsBoundBy(on, _f.funcs.OutputCols2(left, innerLeft)) {
					if _f.matchedRule == nil || _f.matchedRule(opt.TryDecorrelateInnerLeftJoin) {
						_group = _f.ConstructLeftJoinApply(
							_f.ConstructInnerJoin(
								left,
								innerLeft,
								on,
							),
							innerRight,
							innerOn,
						)
						_f.mem.AddAltFingerprint(_innerJoinExpr.Fingerprint(), _group)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.TryDecorrelateInnerLeftJoin, _group, 0, 0)
						}
						return _group
					}
				}
			}
		}
	}

	// [TryDecorrelateGroupBy]
	{
		if _f.funcs.HasOuterCols(right) {
			_expr := _f.mem.NormExpr(right)
			if _expr.Operator() == opt.GroupByOp || _expr.Operator() == opt.DistinctOnOp {
				input := _expr.ChildGroup(_f.Memo(), 0)
				aggregations := _expr.ChildGroup(_f.Memo(), 1)
				def := _expr.PrivateID()
				if _f.funcs.IsUnorderedGroupBy(def) {
					if _f.matchedRule == nil || _f.matchedRule(opt.TryDecorrelateGroupBy) {
						newLeft := _f.funcs.EnsureKey(left)
						_group = _f.ConstructSelect(
							_f.DynamicConstruct(
								_f.mem.NormOp(right),
								memo.DynamicOperands{
									memo.DynamicID(_f.ConstructInnerJoinApply(
										newLeft,
										input,
										_f.ConstructTrue(),
									)),
									memo.DynamicID(_f.funcs.AppendAggCols(aggregations, opt.ConstAggOp, _f.funcs.NonKeyCols(newLeft))),
									memo.DynamicID(_f.funcs.AddColsToGroupByDef(def, _f.funcs.KeyCols(newLeft))),
								},
							),
							on,
						)
						_f.mem.AddAltFingerprint(_innerJoinExpr.Fingerprint(), _group)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.TryDecorrelateGroupBy, _group, 0, 0)
						}
						return _group
					}
				}
			}
		}
	}

	// [TryDecorrelateScalarGroupBy]
	{
		if _f.funcs.HasOuterCols(right) {
			_scalarGroupByExpr := _f.mem.NormExpr(right).AsScalarGroupBy()
			if _scalarGroupByExpr != nil {
				input := _scalarGroupByExpr.Input()
				aggregations := _scalarGroupByExpr.Aggregations()
				def := _scalarGroupByExpr.Def()
				if _f.funcs.AggsCanBeDecorrelated(aggregations) {
					if _f.matchedRule == nil || _f.matchedRule(opt.TryDecorrelateScalarGroupBy) {
						leftWithKey := _f.funcs.EnsureKey(left)
						canaryCol := _f.funcs.EnsureCanaryCol(input, aggregations)
						rightWithCanary := _f.funcs.EnsureCanary(input, canaryCol)
						translatedAggs := _f.funcs.EnsureAggsCanIgnoreNulls(rightWithCanary, aggregations)
						_group = _f.ConstructSelect(
							_f.funcs.TranslateNonIgnoreAggs(_f.ConstructGroupBy(
								_f.ConstructLeftJoinApply(
									leftWithKey,
									rightWithCanary,
									_f.ConstructTrue(),
								),
								_f.funcs.AppendAggCols2(translatedAggs, opt.ConstAggOp, _f.funcs.NonKeyCols(leftWithKey), opt.AnyNotNullAggOp, _f.funcs.CanaryColSet(canaryCol)),
								_f.funcs.MakeOrderedGroupByDef(_f.funcs.KeyCols(leftWithKey), _f.funcs.ExtractGroupByOrdering(def)),
							), translatedAggs, rightWithCanary, aggregations, canaryCol),
							on,
						)
						_f.mem.AddAltFingerprint(_innerJoinExpr.Fingerprint(), _group)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.TryDecorrelateScalarGroupBy, _group, 0, 0)
						}
						return _group
					}
				}
			}
		}
	}

	// [TryDecorrelateLimitOne]
	{
		if _f.funcs.HasOuterCols(right) {
			_limitExpr := _f.mem.NormExpr(right).AsLimit()
			if _limitExpr != nil {
				input := _limitExpr.Input()
				_constExpr := _f.mem.NormExpr(_limitExpr.Limit()).AsConst()
				if _constExpr != nil {
					if _f.funcs.EqualsNumber(_constExpr.Value(), 1) {
						ordering := _limitExpr.Ordering()
						if _f.matchedRule == nil || _f.matchedRule(opt.TryDecorrelateLimitOne) {
							newLeft := _f.funcs.EnsureKey(left)
							_group = _f.ConstructDistinctOn(
								_f.ConstructInnerJoin(
									newLeft,
									input,
									on,
								),
								_f.funcs.MakeAggCols2(opt.ConstAggOp, _f.funcs.NonKeyCols(newLeft), opt.FirstAggOp, _f.funcs.OutputCols(input)),
								_f.funcs.MakeOrderedGroupByDef(_f.funcs.KeyCols(newLeft), _f.funcs.ExtractOrdering(ordering)),
							)
							_f.mem.AddAltFingerprint(_innerJoinExpr.Fingerprint(), _group)
							if _f.appliedRule != nil {
								_f.appliedRule(opt.TryDecorrelateLimitOne, _group, 0, 0)
							}
							return _group
						}
					}
				}
			}
		}
	}

	// [PushFilterIntoJoinLeftAndRight]
	{
		if !_f.funcs.HasOuterCols(left) {
			_zipExpr := _f.mem.NormExpr(right).AsZip()
			if _zipExpr == nil {
				if !_f.funcs.HasOuterCols(right) {
					filters := on
					_filtersExpr := _f.mem.NormExpr(on).AsFilters()
					if _filtersExpr != nil {
						list := _filtersExpr.Conditions()
						for _, _item := range _f.mem.LookupList(_filtersExpr.Conditions()) {
							condition := _item
							_match := false
							_eqExpr := _f.mem.NormExpr(_item).AsEq()
							if _eqExpr != nil {
								_variableExpr := _f.mem.NormExpr(_eqExpr.Left()).AsVariable()
								if _variableExpr != nil {
									_variableExpr2 := _f.mem.NormExpr(_eqExpr.Right()).AsVariable()
									if _variableExpr2 != nil {
										_match = true
									}
								}
							}

							if !_match {
								if _f.funcs.CanMap(filters, condition, left) {
									if _f.funcs.CanMap(filters, condition, right) {
										if _f.matchedRule == nil || _f.matchedRule(opt.PushFilterIntoJoinLeftAndRight) {
											_group = _f.ConstructInnerJoin(
												_f.ConstructSelect(
													left,
													_f.ConstructFilters(
														_f.mem.InternList([]memo.GroupID{_f.funcs.Map(filters, condition, left)}),
													),
												),
												_f.ConstructSelect(
													right,
													_f.ConstructFilters(
														_f.mem.InternList([]memo.GroupID{_f.funcs.Map(filters, condition, right)}),
													),
												),
												_f.ConstructFilters(
													_f.funcs.RemoveListItem(list, condition),
												),
											)
											_f.mem.AddAltFingerprint(_innerJoinExpr.Fingerprint(), _group)
											if _f.appliedRule != nil {
												_f.appliedRule(opt.PushFilterIntoJoinLeftAndRight, _group, 0, 0)
											}
											return _group
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}

	// [MapFilterIntoJoinLeft]
	{
		filters := on
		_filtersExpr := _f.mem.NormExpr(on).AsFilters()
		if _filtersExpr != nil {
			list := _filtersExpr.Conditions()
			for _, _item := range _f.mem.LookupList(_filtersExpr.Conditions()) {
				condition := _item
				_match := false
				_eqExpr := _f.mem.NormExpr(_item).AsEq()
				if _eqExpr != nil {
					_variableExpr := _f.mem.NormExpr(_eqExpr.Left()).AsVariable()
					if _variableExpr != nil {
						_variableExpr2 := _f.mem.NormExpr(_eqExpr.Right()).AsVariable()
						if _variableExpr2 != nil {
							_match = true
						}
					}
				}

				if !_match {
					if !_f.funcs.IsBoundBy(condition, _f.funcs.OutputCols(left)) {
						if _f.funcs.CanMap(filters, condition, left) {
							if _f.matchedRule == nil || _f.matchedRule(opt.MapFilterIntoJoinLeft) {
								_group = _f.ConstructInnerJoin(
									left,
									right,
									_f.ConstructFilters(
										_f.funcs.ReplaceListItem(list, condition, _f.funcs.Map(filters, condition, left)),
									),
								)
								_f.mem.AddAltFingerprint(_innerJoinExpr.Fingerprint(), _group)
								if _f.appliedRule != nil {
									_f.appliedRule(opt.MapFilterIntoJoinLeft, _group, 0, 0)
								}
								return _group
							}
						}
					}
				}
			}
		}
	}

	// [MapFilterIntoJoinRight]
	{
		_zipExpr := _f.mem.NormExpr(right).AsZip()
		if _zipExpr == nil {
			filters := on
			_filtersExpr := _f.mem.NormExpr(on).AsFilters()
			if _filtersExpr != nil {
				list := _filtersExpr.Conditions()
				for _, _item := range _f.mem.LookupList(_filtersExpr.Conditions()) {
					condition := _item
					_match := false
					_eqExpr := _f.mem.NormExpr(_item).AsEq()
					if _eqExpr != nil {
						_variableExpr := _f.mem.NormExpr(_eqExpr.Left()).AsVariable()
						if _variableExpr != nil {
							_variableExpr2 := _f.mem.NormExpr(_eqExpr.Right()).AsVariable()
							if _variableExpr2 != nil {
								_match = true
							}
						}
					}

					if !_match {
						if !_f.funcs.IsBoundBy(condition, _f.funcs.OutputCols(right)) {
							if _f.funcs.CanMap(filters, condition, right) {
								if _f.matchedRule == nil || _f.matchedRule(opt.MapFilterIntoJoinRight) {
									_group = _f.ConstructInnerJoin(
										left,
										right,
										_f.ConstructFilters(
											_f.funcs.ReplaceListItem(list, condition, _f.funcs.Map(filters, condition, right)),
										),
									)
									_f.mem.AddAltFingerprint(_innerJoinExpr.Fingerprint(), _group)
									if _f.appliedRule != nil {
										_f.appliedRule(opt.MapFilterIntoJoinRight, _group, 0, 0)
									}
									return _group
								}
							}
						}
					}
				}
			}
		}
	}

	// [PushFilterIntoJoinLeft]
	{
		_filtersExpr := _f.mem.NormExpr(on).AsFilters()
		if _filtersExpr != nil {
			list := _filtersExpr.Conditions()
			for _, _item := range _f.mem.LookupList(_filtersExpr.Conditions()) {
				condition := _item
				leftCols := _f.funcs.OutputCols(left)
				if _f.funcs.IsBoundBy(condition, leftCols) {
					if _f.matchedRule == nil || _f.matchedRule(opt.PushFilterIntoJoinLeft) {
						_group = _f.ConstructInnerJoin(
							_f.ConstructSelect(
								left,
								_f.ConstructFilters(
									_f.funcs.ExtractBoundConditions(list, leftCols),
								),
							),
							right,
							_f.ConstructFilters(
								_f.funcs.ExtractUnboundConditions(list, leftCols),
							),
						)
						_f.mem.AddAltFingerprint(_innerJoinExpr.Fingerprint(), _group)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.PushFilterIntoJoinLeft, _group, 0, 0)
						}
						return _group
					}
				}
			}
		}
	}

	// [PushFilterIntoJoinRight]
	{
		_zipExpr := _f.mem.NormExpr(right).AsZip()
		if _zipExpr == nil {
			_filtersExpr := _f.mem.NormExpr(on).AsFilters()
			if _filtersExpr != nil {
				list := _filtersExpr.Conditions()
				for _, _item := range _f.mem.LookupList(_filtersExpr.Conditions()) {
					condition := _item
					rightCols := _f.funcs.OutputCols(right)
					if _f.funcs.IsBoundBy(condition, rightCols) {
						if _f.matchedRule == nil || _f.matchedRule(opt.PushFilterIntoJoinRight) {
							_group = _f.ConstructInnerJoin(
								left,
								_f.ConstructSelect(
									right,
									_f.ConstructFilters(
										_f.funcs.ExtractBoundConditions(list, rightCols),
									),
								),
								_f.ConstructFilters(
									_f.funcs.ExtractUnboundConditions(list, rightCols),
								),
							)
							_f.mem.AddAltFingerprint(_innerJoinExpr.Fingerprint(), _group)
							if _f.appliedRule != nil {
								_f.appliedRule(opt.PushFilterIntoJoinRight, _group, 0, 0)
							}
							return _group
						}
					}
				}
			}
		}
	}

	// [EliminateJoinNoColsLeft]
	{
		if _f.funcs.HasNoCols(left) {
			if _f.funcs.HasOneRow(left) {
				if _f.matchedRule == nil || _f.matchedRule(opt.EliminateJoinNoColsLeft) {
					_group = _f.ConstructSelect(
						right,
						on,
					)
					_f.mem.AddAltFingerprint(_innerJoinExpr.Fingerprint(), _group)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.EliminateJoinNoColsLeft, _group, 0, 0)
					}
					return _group
				}
			}
		}
	}

	// [EliminateJoinNoColsRight]
	{
		if _f.funcs.HasNoCols(right) {
			if _f.funcs.HasOneRow(right) {
				if _f.matchedRule == nil || _f.matchedRule(opt.EliminateJoinNoColsRight) {
					_group = _f.ConstructSelect(
						left,
						on,
					)
					_f.mem.AddAltFingerprint(_innerJoinExpr.Fingerprint(), _group)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.EliminateJoinNoColsRight, _group, 0, 0)
					}
					return _group
				}
			}
		}
	}

	// [HoistJoinProject]
	{
		_projectExpr := _f.mem.NormExpr(right).AsProject()
		if _projectExpr != nil {
			input := _projectExpr.Input()
			_projectionsExpr := _f.mem.NormExpr(_projectExpr.Projections()).AsProjections()
			if _projectionsExpr != nil {
				if _projectionsExpr.Elems().Length == 0 {
					if _f.matchedRule == nil || _f.matchedRule(opt.HoistJoinProject) {
						_group = _f.ConstructProject(
							_f.ConstructInnerJoin(
								left,
								input,
								on,
							),
							_f.funcs.ProjectColsFromBoth(left, right),
						)
						_f.mem.AddAltFingerprint(_innerJoinExpr.Fingerprint(), _group)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.HoistJoinProject, _group, 0, 0)
						}
						return _group
					}
				}
			}
		}
	}

	// [SimplifyJoinNotNullEquality]
	{
		_filtersExpr := _f.mem.NormExpr(on).AsFilters()
		if _filtersExpr != nil {
			list := _filtersExpr.Conditions()
			for _, _item := range _f.mem.LookupList(_filtersExpr.Conditions()) {
				condition := _item
				_expr := _f.mem.NormExpr(_item)
				if _expr.Operator() == opt.IsOp || _expr.Operator() == opt.IsNotOp {
					eq := _expr.ChildGroup(_f.Memo(), 0)
					_eqExpr := _f.mem.NormExpr(_expr.ChildGroup(_f.Memo(), 0)).AsEq()
					if _eqExpr != nil {
						_variableExpr := _f.mem.NormExpr(_eqExpr.Left()).AsVariable()
						if _variableExpr != nil {
							col1 := _variableExpr.Col()
							if _f.funcs.IsColNotNull2(col1, left, right) {
								_variableExpr2 := _f.mem.NormExpr(_eqExpr.Right()).AsVariable()
								if _variableExpr2 != nil {
									col2 := _variableExpr2.Col()
									if _f.funcs.IsColNotNull2(col2, left, right) {
										cnst := _expr.ChildGroup(_f.Memo(), 1)
										_expr2 := _f.mem.NormExpr(_expr.ChildGroup(_f.Memo(), 1))
										if _expr2.Operator() == opt.TrueOp || _expr2.Operator() == opt.FalseOp || _expr2.Operator() == opt.NullOp {
											if _f.matchedRule == nil || _f.matchedRule(opt.SimplifyJoinNotNullEquality) {
												_group = _f.ConstructInnerJoin(
													left,
													right,
													_f.ConstructFilters(
														_f.funcs.ReplaceListItem(list, condition, _f.funcs.SimplifyNotNullEquality(eq, _f.mem.NormExpr(condition).Operator(), _f.mem.NormExpr(cnst).Operator())),
													),
												)
												_f.mem.AddAltFingerprint(_innerJoinExpr.Fingerprint(), _group)
												if _f.appliedRule != nil {
													_f.appliedRule(opt.SimplifyJoinNotNullEquality, _group, 0, 0)
												}
												return _group
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}

	// [ExtractJoinEqualities]
	{
		if !_f.funcs.HasOuterCols(left) {
			if !_f.funcs.HasOuterCols(right) {
				_filtersExpr := _f.mem.NormExpr(on).AsFilters()
				if _filtersExpr != nil {
					list := _filtersExpr.Conditions()
					for _, _item := range _f.mem.LookupList(_filtersExpr.Conditions()) {
						_eqExpr := _f.mem.NormExpr(_item).AsEq()
						if _eqExpr != nil {
							a := _eqExpr.Left()
							b := _eqExpr.Right()
							if _f.funcs.CanExtractJoinEquality(a, b, _f.funcs.OutputCols(left), _f.funcs.OutputCols(right)) {
								if _f.matchedRule == nil || _f.matchedRule(opt.ExtractJoinEqualities) {
									_group = _f.funcs.ExtractJoinEqualities(opt.InnerJoinOp, left, right, list)
									_f.mem.AddAltFingerprint(_innerJoinExpr.Fingerprint(), _group)
									if _f.appliedRule != nil {
										_f.appliedRule(opt.ExtractJoinEqualities, _group, 0, 0)
									}
									return _group
								}
							}
						}
					}
				}
			}
		}
	}

	// [HoistJoinSubquery]
	{
		if _f.funcs.HasHoistableSubquery(on) {
			_filtersExpr := _f.mem.NormExpr(on).AsFilters()
			if _filtersExpr != nil {
				if _f.matchedRule == nil || _f.matchedRule(opt.HoistJoinSubquery) {
					_group = _f.funcs.HoistJoinSubquery(opt.InnerJoinOp, left, right, on)
					_f.mem.AddAltFingerprint(_innerJoinExpr.Fingerprint(), _group)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.HoistJoinSubquery, _group, 0, 0)
					}
					return _group
				}
			}
		}
	}

	return _f.onConstruct(memo.Expr(_innerJoinExpr))
}

// ConstructLeftJoin constructs an expression for the LeftJoin operator.
func (_f *Factory) ConstructLeftJoin(
	left memo.GroupID,
	right memo.GroupID,
	on memo.GroupID,
) memo.GroupID {
	_leftJoinExpr := memo.MakeLeftJoinExpr(left, right, on)
	_group := _f.mem.GroupByFingerprint(_leftJoinExpr.Fingerprint())
	if _group != 0 {
		return _group
	}

	// [TryDecorrelateSelect]
	{
		if _f.funcs.HasOuterCols(right) {
			_selectExpr := _f.mem.NormExpr(right).AsSelect()
			if _selectExpr != nil {
				input := _selectExpr.Input()
				filter := _selectExpr.Filter()
				if !_f.ruleCycles.detectCycle(_leftJoinExpr.Fingerprint()) {
					if _f.matchedRule == nil || _f.matchedRule(opt.TryDecorrelateSelect) {
						_f.ruleCycles.push(_leftJoinExpr.Fingerprint())
						_group = _f.ConstructLeftJoin(
							left,
							input,
							_f.funcs.ConcatFilters(on, filter),
						)
						_f.ruleCycles.pop()
						if _f.mem.GroupByFingerprint(_leftJoinExpr.Fingerprint()) == 0 {
							_f.mem.AddAltFingerprint(_leftJoinExpr.Fingerprint(), _group)
						}
						if _f.appliedRule != nil {
							_f.appliedRule(opt.TryDecorrelateSelect, _group, 0, 0)
						}
						return _group
					}
				}
			}
		}
	}

	// [TryDecorrelateInnerJoin]
	{
		if _f.funcs.HasOuterCols(right) {
			_expr := _f.mem.NormExpr(right)
			if _expr.Operator() == opt.InnerJoinOp || _expr.Operator() == opt.InnerJoinApplyOp {
				innerLeft := _expr.ChildGroup(_f.Memo(), 0)
				innerRight := _expr.ChildGroup(_f.Memo(), 1)
				innerOn := _expr.ChildGroup(_f.Memo(), 2)
				if !_f.ruleCycles.detectCycle(_leftJoinExpr.Fingerprint()) {
					if _f.matchedRule == nil || _f.matchedRule(opt.TryDecorrelateInnerJoin) {
						_f.ruleCycles.push(_leftJoinExpr.Fingerprint())
						_group = _f.ConstructLeftJoin(
							left,
							_f.DynamicConstruct(
								_f.mem.NormOp(right),
								memo.DynamicOperands{
									memo.DynamicID(innerLeft),
									memo.DynamicID(innerRight),
									memo.DynamicID(_f.ConstructTrue()),
								},
							),
							_f.funcs.ConcatFilters(on, innerOn),
						)
						_f.ruleCycles.pop()
						if _f.mem.GroupByFingerprint(_leftJoinExpr.Fingerprint()) == 0 {
							_f.mem.AddAltFingerprint(_leftJoinExpr.Fingerprint(), _group)
						}
						if _f.appliedRule != nil {
							_f.appliedRule(opt.TryDecorrelateInnerJoin, _group, 0, 0)
						}
						return _group
					}
				}
			}
		}
	}

	// [TryDecorrelateLimitOne]
	{
		if _f.funcs.HasOuterCols(right) {
			_limitExpr := _f.mem.NormExpr(right).AsLimit()
			if _limitExpr != nil {
				input := _limitExpr.Input()
				_constExpr := _f.mem.NormExpr(_limitExpr.Limit()).AsConst()
				if _constExpr != nil {
					if _f.funcs.EqualsNumber(_constExpr.Value(), 1) {
						ordering := _limitExpr.Ordering()
						if _f.matchedRule == nil || _f.matchedRule(opt.TryDecorrelateLimitOne) {
							newLeft := _f.funcs.EnsureKey(left)
							_group = _f.ConstructDistinctOn(
								_f.ConstructLeftJoin(
									newLeft,
									input,
									on,
								),
								_f.funcs.MakeAggCols2(opt.ConstAggOp, _f.funcs.NonKeyCols(newLeft), opt.FirstAggOp, _f.funcs.OutputCols(input)),
								_f.funcs.MakeOrderedGroupByDef(_f.funcs.KeyCols(newLeft), _f.funcs.ExtractOrdering(ordering)),
							)
							_f.mem.AddAltFingerprint(_leftJoinExpr.Fingerprint(), _group)
							if _f.appliedRule != nil {
								_f.appliedRule(opt.TryDecorrelateLimitOne, _group, 0, 0)
							}
							return _group
						}
					}
				}
			}
		}
	}

	// [MapFilterIntoJoinRight]
	{
		_zipExpr := _f.mem.NormExpr(right).AsZip()
		if _zipExpr == nil {
			filters := on
			_filtersExpr := _f.mem.NormExpr(on).AsFilters()
			if _filtersExpr != nil {
				list := _filtersExpr.Conditions()
				for _, _item := range _f.mem.LookupList(_filtersExpr.Conditions()) {
					condition := _item
					_match := false
					_eqExpr := _f.mem.NormExpr(_item).AsEq()
					if _eqExpr != nil {
						_variableExpr := _f.mem.NormExpr(_eqExpr.Left()).AsVariable()
						if _variableExpr != nil {
							_variableExpr2 := _f.mem.NormExpr(_eqExpr.Right()).AsVariable()
							if _variableExpr2 != nil {
								_match = true
							}
						}
					}

					if !_match {
						if !_f.funcs.IsBoundBy(condition, _f.funcs.OutputCols(right)) {
							if _f.funcs.CanMap(filters, condition, right) {
								if _f.matchedRule == nil || _f.matchedRule(opt.MapFilterIntoJoinRight) {
									_group = _f.ConstructLeftJoin(
										left,
										right,
										_f.ConstructFilters(
											_f.funcs.ReplaceListItem(list, condition, _f.funcs.Map(filters, condition, right)),
										),
									)
									_f.mem.AddAltFingerprint(_leftJoinExpr.Fingerprint(), _group)
									if _f.appliedRule != nil {
										_f.appliedRule(opt.MapFilterIntoJoinRight, _group, 0, 0)
									}
									return _group
								}
							}
						}
					}
				}
			}
		}
	}

	// [PushFilterIntoJoinRight]
	{
		_zipExpr := _f.mem.NormExpr(right).AsZip()
		if _zipExpr == nil {
			_filtersExpr := _f.mem.NormExpr(on).AsFilters()
			if _filtersExpr != nil {
				list := _filtersExpr.Conditions()
				for _, _item := range _f.mem.LookupList(_filtersExpr.Conditions()) {
					condition := _item
					rightCols := _f.funcs.OutputCols(right)
					if _f.funcs.IsBoundBy(condition, rightCols) {
						if _f.matchedRule == nil || _f.matchedRule(opt.PushFilterIntoJoinRight) {
							_group = _f.ConstructLeftJoin(
								left,
								_f.ConstructSelect(
									right,
									_f.ConstructFilters(
										_f.funcs.ExtractBoundConditions(list, rightCols),
									),
								),
								_f.ConstructFilters(
									_f.funcs.ExtractUnboundConditions(list, rightCols),
								),
							)
							_f.mem.AddAltFingerprint(_leftJoinExpr.Fingerprint(), _group)
							if _f.appliedRule != nil {
								_f.appliedRule(opt.PushFilterIntoJoinRight, _group, 0, 0)
							}
							return _group
						}
					}
				}
			}
		}
	}

	// [SimplifyLeftJoinWithoutFilters]
	{
		if !_f.funcs.CanHaveZeroRows(right) {
			_trueExpr := _f.mem.NormExpr(on).AsTrue()
			if _trueExpr != nil {
				if _f.matchedRule == nil || _f.matchedRule(opt.SimplifyLeftJoinWithoutFilters) {
					_group = _f.funcs.ConstructNonLeftJoin(opt.LeftJoinOp, left, right, on)
					_f.mem.AddAltFingerprint(_leftJoinExpr.Fingerprint(), _group)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.SimplifyLeftJoinWithoutFilters, _group, 0, 0)
					}
					return _group
				}
			}
		}
	}

	// [SimplifyLeftJoinWithFilters]
	{
		_filtersExpr := _f.mem.NormExpr(on).AsFilters()
		if _filtersExpr != nil {
			if _f.funcs.JoinFiltersMatchAllLeftRows(left, right, on) {
				if _f.matchedRule == nil || _f.matchedRule(opt.SimplifyLeftJoinWithFilters) {
					_group = _f.funcs.ConstructNonLeftJoin(opt.LeftJoinOp, left, right, on)
					_f.mem.AddAltFingerprint(_leftJoinExpr.Fingerprint(), _group)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.SimplifyLeftJoinWithFilters, _group, 0, 0)
					}
					return _group
				}
			}
		}
	}

	// [HoistJoinProject]
	{
		_projectExpr := _f.mem.NormExpr(right).AsProject()
		if _projectExpr != nil {
			input := _projectExpr.Input()
			_projectionsExpr := _f.mem.NormExpr(_projectExpr.Projections()).AsProjections()
			if _projectionsExpr != nil {
				if _projectionsExpr.Elems().Length == 0 {
					if _f.matchedRule == nil || _f.matchedRule(opt.HoistJoinProject) {
						_group = _f.ConstructProject(
							_f.ConstructLeftJoin(
								left,
								input,
								on,
							),
							_f.funcs.ProjectColsFromBoth(left, right),
						)
						_f.mem.AddAltFingerprint(_leftJoinExpr.Fingerprint(), _group)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.HoistJoinProject, _group, 0, 0)
						}
						return _group
					}
				}
			}
		}
	}

	// [SimplifyJoinNotNullEquality]
	{
		_filtersExpr := _f.mem.NormExpr(on).AsFilters()
		if _filtersExpr != nil {
			list := _filtersExpr.Conditions()
			for _, _item := range _f.mem.LookupList(_filtersExpr.Conditions()) {
				condition := _item
				_expr := _f.mem.NormExpr(_item)
				if _expr.Operator() == opt.IsOp || _expr.Operator() == opt.IsNotOp {
					eq := _expr.ChildGroup(_f.Memo(), 0)
					_eqExpr := _f.mem.NormExpr(_expr.ChildGroup(_f.Memo(), 0)).AsEq()
					if _eqExpr != nil {
						_variableExpr := _f.mem.NormExpr(_eqExpr.Left()).AsVariable()
						if _variableExpr != nil {
							col1 := _variableExpr.Col()
							if _f.funcs.IsColNotNull2(col1, left, right) {
								_variableExpr2 := _f.mem.NormExpr(_eqExpr.Right()).AsVariable()
								if _variableExpr2 != nil {
									col2 := _variableExpr2.Col()
									if _f.funcs.IsColNotNull2(col2, left, right) {
										cnst := _expr.ChildGroup(_f.Memo(), 1)
										_expr2 := _f.mem.NormExpr(_expr.ChildGroup(_f.Memo(), 1))
										if _expr2.Operator() == opt.TrueOp || _expr2.Operator() == opt.FalseOp || _expr2.Operator() == opt.NullOp {
											if _f.matchedRule == nil || _f.matchedRule(opt.SimplifyJoinNotNullEquality) {
												_group = _f.ConstructLeftJoin(
													left,
													right,
													_f.ConstructFilters(
														_f.funcs.ReplaceListItem(list, condition, _f.funcs.SimplifyNotNullEquality(eq, _f.mem.NormExpr(condition).Operator(), _f.mem.NormExpr(cnst).Operator())),
													),
												)
												_f.mem.AddAltFingerprint(_leftJoinExpr.Fingerprint(), _group)
												if _f.appliedRule != nil {
													_f.appliedRule(opt.SimplifyJoinNotNullEquality, _group, 0, 0)
												}
												return _group
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}

	// [ExtractJoinEqualities]
	{
		if !_f.funcs.HasOuterCols(left) {
			if !_f.funcs.HasOuterCols(right) {
				_filtersExpr := _f.mem.NormExpr(on).AsFilters()
				if _filtersExpr != nil {
					list := _filtersExpr.Conditions()
					for _, _item := range _f.mem.LookupList(_filtersExpr.Conditions()) {
						_eqExpr := _f.mem.NormExpr(_item).AsEq()
						if _eqExpr != nil {
							a := _eqExpr.Left()
							b := _eqExpr.Right()
							if _f.funcs.CanExtractJoinEquality(a, b, _f.funcs.OutputCols(left), _f.funcs.OutputCols(right)) {
								if _f.matchedRule == nil || _f.matchedRule(opt.ExtractJoinEqualities) {
									_group = _f.funcs.ExtractJoinEqualities(opt.LeftJoinOp, left, right, list)
									_f.mem.AddAltFingerprint(_leftJoinExpr.Fingerprint(), _group)
									if _f.appliedRule != nil {
										_f.appliedRule(opt.ExtractJoinEqualities, _group, 0, 0)
									}
									return _group
								}
							}
						}
					}
				}
			}
		}
	}

	// [HoistJoinSubquery]
	{
		if _f.funcs.HasHoistableSubquery(on) {
			_filtersExpr := _f.mem.NormExpr(on).AsFilters()
			if _filtersExpr != nil {
				if _f.matchedRule == nil || _f.matchedRule(opt.HoistJoinSubquery) {
					_group = _f.funcs.HoistJoinSubquery(opt.LeftJoinOp, left, right, on)
					_f.mem.AddAltFingerprint(_leftJoinExpr.Fingerprint(), _group)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.HoistJoinSubquery, _group, 0, 0)
					}
					return _group
				}
			}
		}
	}

	return _f.onConstruct(memo.Expr(_leftJoinExpr))
}

// ConstructRightJoin constructs an expression for the RightJoin operator.
func (_f *Factory) ConstructRightJoin(
	left memo.GroupID,
	right memo.GroupID,
	on memo.GroupID,
) memo.GroupID {
	_rightJoinExpr := memo.MakeRightJoinExpr(left, right, on)
	_group := _f.mem.GroupByFingerprint(_rightJoinExpr.Fingerprint())
	if _group != 0 {
		return _group
	}

	// [MapFilterIntoJoinLeft]
	{
		filters := on
		_filtersExpr := _f.mem.NormExpr(on).AsFilters()
		if _filtersExpr != nil {
			list := _filtersExpr.Conditions()
			for _, _item := range _f.mem.LookupList(_filtersExpr.Conditions()) {
				condition := _item
				_match := false
				_eqExpr := _f.mem.NormExpr(_item).AsEq()
				if _eqExpr != nil {
					_variableExpr := _f.mem.NormExpr(_eqExpr.Left()).AsVariable()
					if _variableExpr != nil {
						_variableExpr2 := _f.mem.NormExpr(_eqExpr.Right()).AsVariable()
						if _variableExpr2 != nil {
							_match = true
						}
					}
				}

				if !_match {
					if !_f.funcs.IsBoundBy(condition, _f.funcs.OutputCols(left)) {
						if _f.funcs.CanMap(filters, condition, left) {
							if _f.matchedRule == nil || _f.matchedRule(opt.MapFilterIntoJoinLeft) {
								_group = _f.ConstructRightJoin(
									left,
									right,
									_f.ConstructFilters(
										_f.funcs.ReplaceListItem(list, condition, _f.funcs.Map(filters, condition, left)),
									),
								)
								_f.mem.AddAltFingerprint(_rightJoinExpr.Fingerprint(), _group)
								if _f.appliedRule != nil {
									_f.appliedRule(opt.MapFilterIntoJoinLeft, _group, 0, 0)
								}
								return _group
							}
						}
					}
				}
			}
		}
	}

	// [PushFilterIntoJoinLeft]
	{
		_filtersExpr := _f.mem.NormExpr(on).AsFilters()
		if _filtersExpr != nil {
			list := _filtersExpr.Conditions()
			for _, _item := range _f.mem.LookupList(_filtersExpr.Conditions()) {
				condition := _item
				leftCols := _f.funcs.OutputCols(left)
				if _f.funcs.IsBoundBy(condition, leftCols) {
					if _f.matchedRule == nil || _f.matchedRule(opt.PushFilterIntoJoinLeft) {
						_group = _f.ConstructRightJoin(
							_f.ConstructSelect(
								left,
								_f.ConstructFilters(
									_f.funcs.ExtractBoundConditions(list, leftCols),
								),
							),
							right,
							_f.ConstructFilters(
								_f.funcs.ExtractUnboundConditions(list, leftCols),
							),
						)
						_f.mem.AddAltFingerprint(_rightJoinExpr.Fingerprint(), _group)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.PushFilterIntoJoinLeft, _group, 0, 0)
						}
						return _group
					}
				}
			}
		}
	}

	// [SimplifyRightJoinWithoutFilters]
	{
		if !_f.funcs.CanHaveZeroRows(left) {
			_trueExpr := _f.mem.NormExpr(on).AsTrue()
			if _trueExpr != nil {
				if _f.matchedRule == nil || _f.matchedRule(opt.SimplifyRightJoinWithoutFilters) {
					_group = _f.funcs.ConstructNonRightJoin(opt.RightJoinOp, left, right, on)
					_f.mem.AddAltFingerprint(_rightJoinExpr.Fingerprint(), _group)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.SimplifyRightJoinWithoutFilters, _group, 0, 0)
					}
					return _group
				}
			}
		}
	}

	// [SimplifyRightJoinWithFilters]
	{
		_filtersExpr := _f.mem.NormExpr(on).AsFilters()
		if _filtersExpr != nil {
			if _f.funcs.JoinFiltersMatchAllLeftRows(right, left, on) {
				if _f.matchedRule == nil || _f.matchedRule(opt.SimplifyRightJoinWithFilters) {
					_group = _f.funcs.ConstructNonRightJoin(opt.RightJoinOp, left, right, on)
					_f.mem.AddAltFingerprint(_rightJoinExpr.Fingerprint(), _group)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.SimplifyRightJoinWithFilters, _group, 0, 0)
					}
					return _group
				}
			}
		}
	}

	// [SimplifyJoinNotNullEquality]
	{
		_filtersExpr := _f.mem.NormExpr(on).AsFilters()
		if _filtersExpr != nil {
			list := _filtersExpr.Conditions()
			for _, _item := range _f.mem.LookupList(_filtersExpr.Conditions()) {
				condition := _item
				_expr := _f.mem.NormExpr(_item)
				if _expr.Operator() == opt.IsOp || _expr.Operator() == opt.IsNotOp {
					eq := _expr.ChildGroup(_f.Memo(), 0)
					_eqExpr := _f.mem.NormExpr(_expr.ChildGroup(_f.Memo(), 0)).AsEq()
					if _eqExpr != nil {
						_variableExpr := _f.mem.NormExpr(_eqExpr.Left()).AsVariable()
						if _variableExpr != nil {
							col1 := _variableExpr.Col()
							if _f.funcs.IsColNotNull2(col1, left, right) {
								_variableExpr2 := _f.mem.NormExpr(_eqExpr.Right()).AsVariable()
								if _variableExpr2 != nil {
									col2 := _variableExpr2.Col()
									if _f.funcs.IsColNotNull2(col2, left, right) {
										cnst := _expr.ChildGroup(_f.Memo(), 1)
										_expr2 := _f.mem.NormExpr(_expr.ChildGroup(_f.Memo(), 1))
										if _expr2.Operator() == opt.TrueOp || _expr2.Operator() == opt.FalseOp || _expr2.Operator() == opt.NullOp {
											if _f.matchedRule == nil || _f.matchedRule(opt.SimplifyJoinNotNullEquality) {
												_group = _f.ConstructRightJoin(
													left,
													right,
													_f.ConstructFilters(
														_f.funcs.ReplaceListItem(list, condition, _f.funcs.SimplifyNotNullEquality(eq, _f.mem.NormExpr(condition).Operator(), _f.mem.NormExpr(cnst).Operator())),
													),
												)
												_f.mem.AddAltFingerprint(_rightJoinExpr.Fingerprint(), _group)
												if _f.appliedRule != nil {
													_f.appliedRule(opt.SimplifyJoinNotNullEquality, _group, 0, 0)
												}
												return _group
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}

	// [ExtractJoinEqualities]
	{
		if !_f.funcs.HasOuterCols(left) {
			if !_f.funcs.HasOuterCols(right) {
				_filtersExpr := _f.mem.NormExpr(on).AsFilters()
				if _filtersExpr != nil {
					list := _filtersExpr.Conditions()
					for _, _item := range _f.mem.LookupList(_filtersExpr.Conditions()) {
						_eqExpr := _f.mem.NormExpr(_item).AsEq()
						if _eqExpr != nil {
							a := _eqExpr.Left()
							b := _eqExpr.Right()
							if _f.funcs.CanExtractJoinEquality(a, b, _f.funcs.OutputCols(left), _f.funcs.OutputCols(right)) {
								if _f.matchedRule == nil || _f.matchedRule(opt.ExtractJoinEqualities) {
									_group = _f.funcs.ExtractJoinEqualities(opt.RightJoinOp, left, right, list)
									_f.mem.AddAltFingerprint(_rightJoinExpr.Fingerprint(), _group)
									if _f.appliedRule != nil {
										_f.appliedRule(opt.ExtractJoinEqualities, _group, 0, 0)
									}
									return _group
								}
							}
						}
					}
				}
			}
		}
	}

	// [HoistJoinSubquery]
	{
		if _f.funcs.HasHoistableSubquery(on) {
			_filtersExpr := _f.mem.NormExpr(on).AsFilters()
			if _filtersExpr != nil {
				if _f.matchedRule == nil || _f.matchedRule(opt.HoistJoinSubquery) {
					_group = _f.funcs.HoistJoinSubquery(opt.RightJoinOp, left, right, on)
					_f.mem.AddAltFingerprint(_rightJoinExpr.Fingerprint(), _group)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.HoistJoinSubquery, _group, 0, 0)
					}
					return _group
				}
			}
		}
	}

	return _f.onConstruct(memo.Expr(_rightJoinExpr))
}

// ConstructFullJoin constructs an expression for the FullJoin operator.
func (_f *Factory) ConstructFullJoin(
	left memo.GroupID,
	right memo.GroupID,
	on memo.GroupID,
) memo.GroupID {
	_fullJoinExpr := memo.MakeFullJoinExpr(left, right, on)
	_group := _f.mem.GroupByFingerprint(_fullJoinExpr.Fingerprint())
	if _group != 0 {
		return _group
	}

	// [SimplifyLeftJoinWithoutFilters]
	{
		if !_f.funcs.CanHaveZeroRows(right) {
			_trueExpr := _f.mem.NormExpr(on).AsTrue()
			if _trueExpr != nil {
				if _f.matchedRule == nil || _f.matchedRule(opt.SimplifyLeftJoinWithoutFilters) {
					_group = _f.funcs.ConstructNonLeftJoin(opt.FullJoinOp, left, right, on)
					_f.mem.AddAltFingerprint(_fullJoinExpr.Fingerprint(), _group)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.SimplifyLeftJoinWithoutFilters, _group, 0, 0)
					}
					return _group
				}
			}
		}
	}

	// [SimplifyRightJoinWithoutFilters]
	{
		if !_f.funcs.CanHaveZeroRows(left) {
			_trueExpr := _f.mem.NormExpr(on).AsTrue()
			if _trueExpr != nil {
				if _f.matchedRule == nil || _f.matchedRule(opt.SimplifyRightJoinWithoutFilters) {
					_group = _f.funcs.ConstructNonRightJoin(opt.FullJoinOp, left, right, on)
					_f.mem.AddAltFingerprint(_fullJoinExpr.Fingerprint(), _group)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.SimplifyRightJoinWithoutFilters, _group, 0, 0)
					}
					return _group
				}
			}
		}
	}

	// [SimplifyLeftJoinWithFilters]
	{
		_filtersExpr := _f.mem.NormExpr(on).AsFilters()
		if _filtersExpr != nil {
			if _f.funcs.JoinFiltersMatchAllLeftRows(left, right, on) {
				if _f.matchedRule == nil || _f.matchedRule(opt.SimplifyLeftJoinWithFilters) {
					_group = _f.funcs.ConstructNonLeftJoin(opt.FullJoinOp, left, right, on)
					_f.mem.AddAltFingerprint(_fullJoinExpr.Fingerprint(), _group)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.SimplifyLeftJoinWithFilters, _group, 0, 0)
					}
					return _group
				}
			}
		}
	}

	// [SimplifyRightJoinWithFilters]
	{
		_filtersExpr := _f.mem.NormExpr(on).AsFilters()
		if _filtersExpr != nil {
			if _f.funcs.JoinFiltersMatchAllLeftRows(right, left, on) {
				if _f.matchedRule == nil || _f.matchedRule(opt.SimplifyRightJoinWithFilters) {
					_group = _f.funcs.ConstructNonRightJoin(opt.FullJoinOp, left, right, on)
					_f.mem.AddAltFingerprint(_fullJoinExpr.Fingerprint(), _group)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.SimplifyRightJoinWithFilters, _group, 0, 0)
					}
					return _group
				}
			}
		}
	}

	// [SimplifyJoinNotNullEquality]
	{
		_filtersExpr := _f.mem.NormExpr(on).AsFilters()
		if _filtersExpr != nil {
			list := _filtersExpr.Conditions()
			for _, _item := range _f.mem.LookupList(_filtersExpr.Conditions()) {
				condition := _item
				_expr := _f.mem.NormExpr(_item)
				if _expr.Operator() == opt.IsOp || _expr.Operator() == opt.IsNotOp {
					eq := _expr.ChildGroup(_f.Memo(), 0)
					_eqExpr := _f.mem.NormExpr(_expr.ChildGroup(_f.Memo(), 0)).AsEq()
					if _eqExpr != nil {
						_variableExpr := _f.mem.NormExpr(_eqExpr.Left()).AsVariable()
						if _variableExpr != nil {
							col1 := _variableExpr.Col()
							if _f.funcs.IsColNotNull2(col1, left, right) {
								_variableExpr2 := _f.mem.NormExpr(_eqExpr.Right()).AsVariable()
								if _variableExpr2 != nil {
									col2 := _variableExpr2.Col()
									if _f.funcs.IsColNotNull2(col2, left, right) {
										cnst := _expr.ChildGroup(_f.Memo(), 1)
										_expr2 := _f.mem.NormExpr(_expr.ChildGroup(_f.Memo(), 1))
										if _expr2.Operator() == opt.TrueOp || _expr2.Operator() == opt.FalseOp || _expr2.Operator() == opt.NullOp {
											if _f.matchedRule == nil || _f.matchedRule(opt.SimplifyJoinNotNullEquality) {
												_group = _f.ConstructFullJoin(
													left,
													right,
													_f.ConstructFilters(
														_f.funcs.ReplaceListItem(list, condition, _f.funcs.SimplifyNotNullEquality(eq, _f.mem.NormExpr(condition).Operator(), _f.mem.NormExpr(cnst).Operator())),
													),
												)
												_f.mem.AddAltFingerprint(_fullJoinExpr.Fingerprint(), _group)
												if _f.appliedRule != nil {
													_f.appliedRule(opt.SimplifyJoinNotNullEquality, _group, 0, 0)
												}
												return _group
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}

	// [ExtractJoinEqualities]
	{
		if !_f.funcs.HasOuterCols(left) {
			if !_f.funcs.HasOuterCols(right) {
				_filtersExpr := _f.mem.NormExpr(on).AsFilters()
				if _filtersExpr != nil {
					list := _filtersExpr.Conditions()
					for _, _item := range _f.mem.LookupList(_filtersExpr.Conditions()) {
						_eqExpr := _f.mem.NormExpr(_item).AsEq()
						if _eqExpr != nil {
							a := _eqExpr.Left()
							b := _eqExpr.Right()
							if _f.funcs.CanExtractJoinEquality(a, b, _f.funcs.OutputCols(left), _f.funcs.OutputCols(right)) {
								if _f.matchedRule == nil || _f.matchedRule(opt.ExtractJoinEqualities) {
									_group = _f.funcs.ExtractJoinEqualities(opt.FullJoinOp, left, right, list)
									_f.mem.AddAltFingerprint(_fullJoinExpr.Fingerprint(), _group)
									if _f.appliedRule != nil {
										_f.appliedRule(opt.ExtractJoinEqualities, _group, 0, 0)
									}
									return _group
								}
							}
						}
					}
				}
			}
		}
	}

	// [HoistJoinSubquery]
	{
		if _f.funcs.HasHoistableSubquery(on) {
			_filtersExpr := _f.mem.NormExpr(on).AsFilters()
			if _filtersExpr != nil {
				if _f.matchedRule == nil || _f.matchedRule(opt.HoistJoinSubquery) {
					_group = _f.funcs.HoistJoinSubquery(opt.FullJoinOp, left, right, on)
					_f.mem.AddAltFingerprint(_fullJoinExpr.Fingerprint(), _group)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.HoistJoinSubquery, _group, 0, 0)
					}
					return _group
				}
			}
		}
	}

	return _f.onConstruct(memo.Expr(_fullJoinExpr))
}

// ConstructSemiJoin constructs an expression for the SemiJoin operator.
func (_f *Factory) ConstructSemiJoin(
	left memo.GroupID,
	right memo.GroupID,
	on memo.GroupID,
) memo.GroupID {
	_semiJoinExpr := memo.MakeSemiJoinExpr(left, right, on)
	_group := _f.mem.GroupByFingerprint(_semiJoinExpr.Fingerprint())
	if _group != 0 {
		return _group
	}

	// [TryDecorrelateSelect]
	{
		if _f.funcs.HasOuterCols(right) {
			_selectExpr := _f.mem.NormExpr(right).AsSelect()
			if _selectExpr != nil {
				input := _selectExpr.Input()
				filter := _selectExpr.Filter()
				if !_f.ruleCycles.detectCycle(_semiJoinExpr.Fingerprint()) {
					if _f.matchedRule == nil || _f.matchedRule(opt.TryDecorrelateSelect) {
						_f.ruleCycles.push(_semiJoinExpr.Fingerprint())
						_group = _f.ConstructSemiJoin(
							left,
							input,
							_f.funcs.ConcatFilters(on, filter),
						)
						_f.ruleCycles.pop()
						if _f.mem.GroupByFingerprint(_semiJoinExpr.Fingerprint()) == 0 {
							_f.mem.AddAltFingerprint(_semiJoinExpr.Fingerprint(), _group)
						}
						if _f.appliedRule != nil {
							_f.appliedRule(opt.TryDecorrelateSelect, _group, 0, 0)
						}
						return _group
					}
				}
			}
		}
	}

	// [TryDecorrelateInnerJoin]
	{
		if _f.funcs.HasOuterCols(right) {
			_expr := _f.mem.NormExpr(right)
			if _expr.Operator() == opt.InnerJoinOp || _expr.Operator() == opt.InnerJoinApplyOp {
				innerLeft := _expr.ChildGroup(_f.Memo(), 0)
				innerRight := _expr.ChildGroup(_f.Memo(), 1)
				innerOn := _expr.ChildGroup(_f.Memo(), 2)
				if !_f.ruleCycles.detectCycle(_semiJoinExpr.Fingerprint()) {
					if _f.matchedRule == nil || _f.matchedRule(opt.TryDecorrelateInnerJoin) {
						_f.ruleCycles.push(_semiJoinExpr.Fingerprint())
						_group = _f.ConstructSemiJoin(
							left,
							_f.DynamicConstruct(
								_f.mem.NormOp(right),
								memo.DynamicOperands{
									memo.DynamicID(innerLeft),
									memo.DynamicID(innerRight),
									memo.DynamicID(_f.ConstructTrue()),
								},
							),
							_f.funcs.ConcatFilters(on, innerOn),
						)
						_f.ruleCycles.pop()
						if _f.mem.GroupByFingerprint(_semiJoinExpr.Fingerprint()) == 0 {
							_f.mem.AddAltFingerprint(_semiJoinExpr.Fingerprint(), _group)
						}
						if _f.appliedRule != nil {
							_f.appliedRule(opt.TryDecorrelateInnerJoin, _group, 0, 0)
						}
						return _group
					}
				}
			}
		}
	}

	// [TryDecorrelateSemiJoin]
	{
		if _f.funcs.HasOuterCols(right) {
			if _f.funcs.CanHaveZeroRows(right) {
				_expr := _f.mem.NormExpr(right)
				if _expr.Operator() == opt.GroupByOp || _expr.Operator() == opt.DistinctOnOp || _expr.Operator() == opt.ProjectOp || _expr.Operator() == opt.ZipOp {
					if _f.matchedRule == nil || _f.matchedRule(opt.TryDecorrelateSemiJoin) {
						newLeft := _f.funcs.EnsureKey(left)
						_group = _f.ConstructGroupBy(
							_f.ConstructInnerJoinApply(
								newLeft,
								right,
								on,
							),
							_f.funcs.MakeAggCols(opt.ConstAggOp, _f.funcs.NonKeyCols(newLeft)),
							_f.funcs.MakeGroupByDef(_f.funcs.KeyCols(newLeft)),
						)
						_f.mem.AddAltFingerprint(_semiJoinExpr.Fingerprint(), _group)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.TryDecorrelateSemiJoin, _group, 0, 0)
						}
						return _group
					}
				}
			}
		}
	}

	// [TryDecorrelateSemiJoinZip]
	{
		if _f.funcs.HasOuterCols(right) {
			_expr := _f.mem.NormExpr(right)
			if _expr.Operator() == opt.InnerJoinOp || _expr.Operator() == opt.InnerJoinApplyOp {
				_zipExpr := _f.mem.NormExpr(_expr.ChildGroup(_f.Memo(), 1)).AsZip()
				if _zipExpr != nil {
					if _f.matchedRule == nil || _f.matchedRule(opt.TryDecorrelateSemiJoinZip) {
						newLeft := _f.funcs.EnsureKey(left)
						_group = _f.ConstructGroupBy(
							_f.ConstructInnerJoinApply(
								newLeft,
								right,
								on,
							),
							_f.funcs.MakeAggCols(opt.ConstAggOp, _f.funcs.NonKeyCols(newLeft)),
							_f.funcs.MakeGroupByDef(_f.funcs.KeyCols(newLeft)),
						)
						_f.mem.AddAltFingerprint(_semiJoinExpr.Fingerprint(), _group)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.TryDecorrelateSemiJoinZip, _group, 0, 0)
						}
						return _group
					}
				}
			}
		}
	}

	// [PushFilterIntoJoinLeftAndRight]
	{
		if !_f.funcs.HasOuterCols(left) {
			_zipExpr := _f.mem.NormExpr(right).AsZip()
			if _zipExpr == nil {
				if !_f.funcs.HasOuterCols(right) {
					filters := on
					_filtersExpr := _f.mem.NormExpr(on).AsFilters()
					if _filtersExpr != nil {
						list := _filtersExpr.Conditions()
						for _, _item := range _f.mem.LookupList(_filtersExpr.Conditions()) {
							condition := _item
							_match := false
							_eqExpr := _f.mem.NormExpr(_item).AsEq()
							if _eqExpr != nil {
								_variableExpr := _f.mem.NormExpr(_eqExpr.Left()).AsVariable()
								if _variableExpr != nil {
									_variableExpr2 := _f.mem.NormExpr(_eqExpr.Right()).AsVariable()
									if _variableExpr2 != nil {
										_match = true
									}
								}
							}

							if !_match {
								if _f.funcs.CanMap(filters, condition, left) {
									if _f.funcs.CanMap(filters, condition, right) {
										if _f.matchedRule == nil || _f.matchedRule(opt.PushFilterIntoJoinLeftAndRight) {
											_group = _f.ConstructSemiJoin(
												_f.ConstructSelect(
													left,
													_f.ConstructFilters(
														_f.mem.InternList([]memo.GroupID{_f.funcs.Map(filters, condition, left)}),
													),
												),
												_f.ConstructSelect(
													right,
													_f.ConstructFilters(
														_f.mem.InternList([]memo.GroupID{_f.funcs.Map(filters, condition, right)}),
													),
												),
												_f.ConstructFilters(
													_f.funcs.RemoveListItem(list, condition),
												),
											)
											_f.mem.AddAltFingerprint(_semiJoinExpr.Fingerprint(), _group)
											if _f.appliedRule != nil {
												_f.appliedRule(opt.PushFilterIntoJoinLeftAndRight, _group, 0, 0)
											}
											return _group
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}

	// [MapFilterIntoJoinLeft]
	{
		filters := on
		_filtersExpr := _f.mem.NormExpr(on).AsFilters()
		if _filtersExpr != nil {
			list := _filtersExpr.Conditions()
			for _, _item := range _f.mem.LookupList(_filtersExpr.Conditions()) {
				condition := _item
				_match := false
				_eqExpr := _f.mem.NormExpr(_item).AsEq()
				if _eqExpr != nil {
					_variableExpr := _f.mem.NormExpr(_eqExpr.Left()).AsVariable()
					if _variableExpr != nil {
						_variableExpr2 := _f.mem.NormExpr(_eqExpr.Right()).AsVariable()
						if _variableExpr2 != nil {
							_match = true
						}
					}
				}

				if !_match {
					if !_f.funcs.IsBoundBy(condition, _f.funcs.OutputCols(left)) {
						if _f.funcs.CanMap(filters, condition, left) {
							if _f.matchedRule == nil || _f.matchedRule(opt.MapFilterIntoJoinLeft) {
								_group = _f.ConstructSemiJoin(
									left,
									right,
									_f.ConstructFilters(
										_f.funcs.ReplaceListItem(list, condition, _f.funcs.Map(filters, condition, left)),
									),
								)
								_f.mem.AddAltFingerprint(_semiJoinExpr.Fingerprint(), _group)
								if _f.appliedRule != nil {
									_f.appliedRule(opt.MapFilterIntoJoinLeft, _group, 0, 0)
								}
								return _group
							}
						}
					}
				}
			}
		}
	}

	// [MapFilterIntoJoinRight]
	{
		_zipExpr := _f.mem.NormExpr(right).AsZip()
		if _zipExpr == nil {
			filters := on
			_filtersExpr := _f.mem.NormExpr(on).AsFilters()
			if _filtersExpr != nil {
				list := _filtersExpr.Conditions()
				for _, _item := range _f.mem.LookupList(_filtersExpr.Conditions()) {
					condition := _item
					_match := false
					_eqExpr := _f.mem.NormExpr(_item).AsEq()
					if _eqExpr != nil {
						_variableExpr := _f.mem.NormExpr(_eqExpr.Left()).AsVariable()
						if _variableExpr != nil {
							_variableExpr2 := _f.mem.NormExpr(_eqExpr.Right()).AsVariable()
							if _variableExpr2 != nil {
								_match = true
							}
						}
					}

					if !_match {
						if !_f.funcs.IsBoundBy(condition, _f.funcs.OutputCols(right)) {
							if _f.funcs.CanMap(filters, condition, right) {
								if _f.matchedRule == nil || _f.matchedRule(opt.MapFilterIntoJoinRight) {
									_group = _f.ConstructSemiJoin(
										left,
										right,
										_f.ConstructFilters(
											_f.funcs.ReplaceListItem(list, condition, _f.funcs.Map(filters, condition, right)),
										),
									)
									_f.mem.AddAltFingerprint(_semiJoinExpr.Fingerprint(), _group)
									if _f.appliedRule != nil {
										_f.appliedRule(opt.MapFilterIntoJoinRight, _group, 0, 0)
									}
									return _group
								}
							}
						}
					}
				}
			}
		}
	}

	// [PushFilterIntoJoinLeft]
	{
		_filtersExpr := _f.mem.NormExpr(on).AsFilters()
		if _filtersExpr != nil {
			list := _filtersExpr.Conditions()
			for _, _item := range _f.mem.LookupList(_filtersExpr.Conditions()) {
				condition := _item
				leftCols := _f.funcs.OutputCols(left)
				if _f.funcs.IsBoundBy(condition, leftCols) {
					if _f.matchedRule == nil || _f.matchedRule(opt.PushFilterIntoJoinLeft) {
						_group = _f.ConstructSemiJoin(
							_f.ConstructSelect(
								left,
								_f.ConstructFilters(
									_f.funcs.ExtractBoundConditions(list, leftCols),
								),
							),
							right,
							_f.ConstructFilters(
								_f.funcs.ExtractUnboundConditions(list, leftCols),
							),
						)
						_f.mem.AddAltFingerprint(_semiJoinExpr.Fingerprint(), _group)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.PushFilterIntoJoinLeft, _group, 0, 0)
						}
						return _group
					}
				}
			}
		}
	}

	// [PushFilterIntoJoinRight]
	{
		_zipExpr := _f.mem.NormExpr(right).AsZip()
		if _zipExpr == nil {
			_filtersExpr := _f.mem.NormExpr(on).AsFilters()
			if _filtersExpr != nil {
				list := _filtersExpr.Conditions()
				for _, _item := range _f.mem.LookupList(_filtersExpr.Conditions()) {
					condition := _item
					rightCols := _f.funcs.OutputCols(right)
					if _f.funcs.IsBoundBy(condition, rightCols) {
						if _f.matchedRule == nil || _f.matchedRule(opt.PushFilterIntoJoinRight) {
							_group = _f.ConstructSemiJoin(
								left,
								_f.ConstructSelect(
									right,
									_f.ConstructFilters(
										_f.funcs.ExtractBoundConditions(list, rightCols),
									),
								),
								_f.ConstructFilters(
									_f.funcs.ExtractUnboundConditions(list, rightCols),
								),
							)
							_f.mem.AddAltFingerprint(_semiJoinExpr.Fingerprint(), _group)
							if _f.appliedRule != nil {
								_f.appliedRule(opt.PushFilterIntoJoinRight, _group, 0, 0)
							}
							return _group
						}
					}
				}
			}
		}
	}

	// [EliminateSemiJoin]
	{
		if !_f.funcs.CanHaveZeroRows(right) {
			_trueExpr := _f.mem.NormExpr(on).AsTrue()
			if _trueExpr != nil {
				if _f.matchedRule == nil || _f.matchedRule(opt.EliminateSemiJoin) {
					_group = left
					_f.mem.AddAltFingerprint(_semiJoinExpr.Fingerprint(), _group)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.EliminateSemiJoin, _group, 0, 0)
					}
					return _group
				}
			}
		}
	}

	// [SimplifyJoinNotNullEquality]
	{
		_filtersExpr := _f.mem.NormExpr(on).AsFilters()
		if _filtersExpr != nil {
			list := _filtersExpr.Conditions()
			for _, _item := range _f.mem.LookupList(_filtersExpr.Conditions()) {
				condition := _item
				_expr := _f.mem.NormExpr(_item)
				if _expr.Operator() == opt.IsOp || _expr.Operator() == opt.IsNotOp {
					eq := _expr.ChildGroup(_f.Memo(), 0)
					_eqExpr := _f.mem.NormExpr(_expr.ChildGroup(_f.Memo(), 0)).AsEq()
					if _eqExpr != nil {
						_variableExpr := _f.mem.NormExpr(_eqExpr.Left()).AsVariable()
						if _variableExpr != nil {
							col1 := _variableExpr.Col()
							if _f.funcs.IsColNotNull2(col1, left, right) {
								_variableExpr2 := _f.mem.NormExpr(_eqExpr.Right()).AsVariable()
								if _variableExpr2 != nil {
									col2 := _variableExpr2.Col()
									if _f.funcs.IsColNotNull2(col2, left, right) {
										cnst := _expr.ChildGroup(_f.Memo(), 1)
										_expr2 := _f.mem.NormExpr(_expr.ChildGroup(_f.Memo(), 1))
										if _expr2.Operator() == opt.TrueOp || _expr2.Operator() == opt.FalseOp || _expr2.Operator() == opt.NullOp {
											if _f.matchedRule == nil || _f.matchedRule(opt.SimplifyJoinNotNullEquality) {
												_group = _f.ConstructSemiJoin(
													left,
													right,
													_f.ConstructFilters(
														_f.funcs.ReplaceListItem(list, condition, _f.funcs.SimplifyNotNullEquality(eq, _f.mem.NormExpr(condition).Operator(), _f.mem.NormExpr(cnst).Operator())),
													),
												)
												_f.mem.AddAltFingerprint(_semiJoinExpr.Fingerprint(), _group)
												if _f.appliedRule != nil {
													_f.appliedRule(opt.SimplifyJoinNotNullEquality, _group, 0, 0)
												}
												return _group
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}

	// [ExtractJoinEqualities]
	{
		if !_f.funcs.HasOuterCols(left) {
			if !_f.funcs.HasOuterCols(right) {
				_filtersExpr := _f.mem.NormExpr(on).AsFilters()
				if _filtersExpr != nil {
					list := _filtersExpr.Conditions()
					for _, _item := range _f.mem.LookupList(_filtersExpr.Conditions()) {
						_eqExpr := _f.mem.NormExpr(_item).AsEq()
						if _eqExpr != nil {
							a := _eqExpr.Left()
							b := _eqExpr.Right()
							if _f.funcs.CanExtractJoinEquality(a, b, _f.funcs.OutputCols(left), _f.funcs.OutputCols(right)) {
								if _f.matchedRule == nil || _f.matchedRule(opt.ExtractJoinEqualities) {
									_group = _f.funcs.ExtractJoinEqualities(opt.SemiJoinOp, left, right, list)
									_f.mem.AddAltFingerprint(_semiJoinExpr.Fingerprint(), _group)
									if _f.appliedRule != nil {
										_f.appliedRule(opt.ExtractJoinEqualities, _group, 0, 0)
									}
									return _group
								}
							}
						}
					}
				}
			}
		}
	}

	// [HoistJoinSubquery]
	{
		if _f.funcs.HasHoistableSubquery(on) {
			_filtersExpr := _f.mem.NormExpr(on).AsFilters()
			if _filtersExpr != nil {
				if _f.matchedRule == nil || _f.matchedRule(opt.HoistJoinSubquery) {
					_group = _f.funcs.HoistJoinSubquery(opt.SemiJoinOp, left, right, on)
					_f.mem.AddAltFingerprint(_semiJoinExpr.Fingerprint(), _group)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.HoistJoinSubquery, _group, 0, 0)
					}
					return _group
				}
			}
		}
	}

	return _f.onConstruct(memo.Expr(_semiJoinExpr))
}

// ConstructAntiJoin constructs an expression for the AntiJoin operator.
func (_f *Factory) ConstructAntiJoin(
	left memo.GroupID,
	right memo.GroupID,
	on memo.GroupID,
) memo.GroupID {
	_antiJoinExpr := memo.MakeAntiJoinExpr(left, right, on)
	_group := _f.mem.GroupByFingerprint(_antiJoinExpr.Fingerprint())
	if _group != 0 {
		return _group
	}

	// [TryDecorrelateSelect]
	{
		if _f.funcs.HasOuterCols(right) {
			_selectExpr := _f.mem.NormExpr(right).AsSelect()
			if _selectExpr != nil {
				input := _selectExpr.Input()
				filter := _selectExpr.Filter()
				if !_f.ruleCycles.detectCycle(_antiJoinExpr.Fingerprint()) {
					if _f.matchedRule == nil || _f.matchedRule(opt.TryDecorrelateSelect) {
						_f.ruleCycles.push(_antiJoinExpr.Fingerprint())
						_group = _f.ConstructAntiJoin(
							left,
							input,
							_f.funcs.ConcatFilters(on, filter),
						)
						_f.ruleCycles.pop()
						if _f.mem.GroupByFingerprint(_antiJoinExpr.Fingerprint()) == 0 {
							_f.mem.AddAltFingerprint(_antiJoinExpr.Fingerprint(), _group)
						}
						if _f.appliedRule != nil {
							_f.appliedRule(opt.TryDecorrelateSelect, _group, 0, 0)
						}
						return _group
					}
				}
			}
		}
	}

	// [TryDecorrelateInnerJoin]
	{
		if _f.funcs.HasOuterCols(right) {
			_expr := _f.mem.NormExpr(right)
			if _expr.Operator() == opt.InnerJoinOp || _expr.Operator() == opt.InnerJoinApplyOp {
				innerLeft := _expr.ChildGroup(_f.Memo(), 0)
				innerRight := _expr.ChildGroup(_f.Memo(), 1)
				innerOn := _expr.ChildGroup(_f.Memo(), 2)
				if !_f.ruleCycles.detectCycle(_antiJoinExpr.Fingerprint()) {
					if _f.matchedRule == nil || _f.matchedRule(opt.TryDecorrelateInnerJoin) {
						_f.ruleCycles.push(_antiJoinExpr.Fingerprint())
						_group = _f.ConstructAntiJoin(
							left,
							_f.DynamicConstruct(
								_f.mem.NormOp(right),
								memo.DynamicOperands{
									memo.DynamicID(innerLeft),
									memo.DynamicID(innerRight),
									memo.DynamicID(_f.ConstructTrue()),
								},
							),
							_f.funcs.ConcatFilters(on, innerOn),
						)
						_f.ruleCycles.pop()
						if _f.mem.GroupByFingerprint(_antiJoinExpr.Fingerprint()) == 0 {
							_f.mem.AddAltFingerprint(_antiJoinExpr.Fingerprint(), _group)
						}
						if _f.appliedRule != nil {
							_f.appliedRule(opt.TryDecorrelateInnerJoin, _group, 0, 0)
						}
						return _group
					}
				}
			}
		}
	}

	// [MapFilterIntoJoinRight]
	{
		_zipExpr := _f.mem.NormExpr(right).AsZip()
		if _zipExpr == nil {
			filters := on
			_filtersExpr := _f.mem.NormExpr(on).AsFilters()
			if _filtersExpr != nil {
				list := _filtersExpr.Conditions()
				for _, _item := range _f.mem.LookupList(_filtersExpr.Conditions()) {
					condition := _item
					_match := false
					_eqExpr := _f.mem.NormExpr(_item).AsEq()
					if _eqExpr != nil {
						_variableExpr := _f.mem.NormExpr(_eqExpr.Left()).AsVariable()
						if _variableExpr != nil {
							_variableExpr2 := _f.mem.NormExpr(_eqExpr.Right()).AsVariable()
							if _variableExpr2 != nil {
								_match = true
							}
						}
					}

					if !_match {
						if !_f.funcs.IsBoundBy(condition, _f.funcs.OutputCols(right)) {
							if _f.funcs.CanMap(filters, condition, right) {
								if _f.matchedRule == nil || _f.matchedRule(opt.MapFilterIntoJoinRight) {
									_group = _f.ConstructAntiJoin(
										left,
										right,
										_f.ConstructFilters(
											_f.funcs.ReplaceListItem(list, condition, _f.funcs.Map(filters, condition, right)),
										),
									)
									_f.mem.AddAltFingerprint(_antiJoinExpr.Fingerprint(), _group)
									if _f.appliedRule != nil {
										_f.appliedRule(opt.MapFilterIntoJoinRight, _group, 0, 0)
									}
									return _group
								}
							}
						}
					}
				}
			}
		}
	}

	// [PushFilterIntoJoinRight]
	{
		_zipExpr := _f.mem.NormExpr(right).AsZip()
		if _zipExpr == nil {
			_filtersExpr := _f.mem.NormExpr(on).AsFilters()
			if _filtersExpr != nil {
				list := _filtersExpr.Conditions()
				for _, _item := range _f.mem.LookupList(_filtersExpr.Conditions()) {
					condition := _item
					rightCols := _f.funcs.OutputCols(right)
					if _f.funcs.IsBoundBy(condition, rightCols) {
						if _f.matchedRule == nil || _f.matchedRule(opt.PushFilterIntoJoinRight) {
							_group = _f.ConstructAntiJoin(
								left,
								_f.ConstructSelect(
									right,
									_f.ConstructFilters(
										_f.funcs.ExtractBoundConditions(list, rightCols),
									),
								),
								_f.ConstructFilters(
									_f.funcs.ExtractUnboundConditions(list, rightCols),
								),
							)
							_f.mem.AddAltFingerprint(_antiJoinExpr.Fingerprint(), _group)
							if _f.appliedRule != nil {
								_f.appliedRule(opt.PushFilterIntoJoinRight, _group, 0, 0)
							}
							return _group
						}
					}
				}
			}
		}
	}

	// [EliminateAntiJoin]
	{
		if _f.funcs.HasZeroRows(right) {
			if _f.matchedRule == nil || _f.matchedRule(opt.EliminateAntiJoin) {
				_group = left
				_f.mem.AddAltFingerprint(_antiJoinExpr.Fingerprint(), _group)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.EliminateAntiJoin, _group, 0, 0)
				}
				return _group
			}
		}
	}

	// [SimplifyJoinNotNullEquality]
	{
		_filtersExpr := _f.mem.NormExpr(on).AsFilters()
		if _filtersExpr != nil {
			list := _filtersExpr.Conditions()
			for _, _item := range _f.mem.LookupList(_filtersExpr.Conditions()) {
				condition := _item
				_expr := _f.mem.NormExpr(_item)
				if _expr.Operator() == opt.IsOp || _expr.Operator() == opt.IsNotOp {
					eq := _expr.ChildGroup(_f.Memo(), 0)
					_eqExpr := _f.mem.NormExpr(_expr.ChildGroup(_f.Memo(), 0)).AsEq()
					if _eqExpr != nil {
						_variableExpr := _f.mem.NormExpr(_eqExpr.Left()).AsVariable()
						if _variableExpr != nil {
							col1 := _variableExpr.Col()
							if _f.funcs.IsColNotNull2(col1, left, right) {
								_variableExpr2 := _f.mem.NormExpr(_eqExpr.Right()).AsVariable()
								if _variableExpr2 != nil {
									col2 := _variableExpr2.Col()
									if _f.funcs.IsColNotNull2(col2, left, right) {
										cnst := _expr.ChildGroup(_f.Memo(), 1)
										_expr2 := _f.mem.NormExpr(_expr.ChildGroup(_f.Memo(), 1))
										if _expr2.Operator() == opt.TrueOp || _expr2.Operator() == opt.FalseOp || _expr2.Operator() == opt.NullOp {
											if _f.matchedRule == nil || _f.matchedRule(opt.SimplifyJoinNotNullEquality) {
												_group = _f.ConstructAntiJoin(
													left,
													right,
													_f.ConstructFilters(
														_f.funcs.ReplaceListItem(list, condition, _f.funcs.SimplifyNotNullEquality(eq, _f.mem.NormExpr(condition).Operator(), _f.mem.NormExpr(cnst).Operator())),
													),
												)
												_f.mem.AddAltFingerprint(_antiJoinExpr.Fingerprint(), _group)
												if _f.appliedRule != nil {
													_f.appliedRule(opt.SimplifyJoinNotNullEquality, _group, 0, 0)
												}
												return _group
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}

	// [ExtractJoinEqualities]
	{
		if !_f.funcs.HasOuterCols(left) {
			if !_f.funcs.HasOuterCols(right) {
				_filtersExpr := _f.mem.NormExpr(on).AsFilters()
				if _filtersExpr != nil {
					list := _filtersExpr.Conditions()
					for _, _item := range _f.mem.LookupList(_filtersExpr.Conditions()) {
						_eqExpr := _f.mem.NormExpr(_item).AsEq()
						if _eqExpr != nil {
							a := _eqExpr.Left()
							b := _eqExpr.Right()
							if _f.funcs.CanExtractJoinEquality(a, b, _f.funcs.OutputCols(left), _f.funcs.OutputCols(right)) {
								if _f.matchedRule == nil || _f.matchedRule(opt.ExtractJoinEqualities) {
									_group = _f.funcs.ExtractJoinEqualities(opt.AntiJoinOp, left, right, list)
									_f.mem.AddAltFingerprint(_antiJoinExpr.Fingerprint(), _group)
									if _f.appliedRule != nil {
										_f.appliedRule(opt.ExtractJoinEqualities, _group, 0, 0)
									}
									return _group
								}
							}
						}
					}
				}
			}
		}
	}

	// [HoistJoinSubquery]
	{
		if _f.funcs.HasHoistableSubquery(on) {
			_filtersExpr := _f.mem.NormExpr(on).AsFilters()
			if _filtersExpr != nil {
				if _f.matchedRule == nil || _f.matchedRule(opt.HoistJoinSubquery) {
					_group = _f.funcs.HoistJoinSubquery(opt.AntiJoinOp, left, right, on)
					_f.mem.AddAltFingerprint(_antiJoinExpr.Fingerprint(), _group)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.HoistJoinSubquery, _group, 0, 0)
					}
					return _group
				}
			}
		}
	}

	return _f.onConstruct(memo.Expr(_antiJoinExpr))
}

// ConstructIndexJoin constructs an expression for the IndexJoin operator.
// IndexJoin represents an inner join between an input expression and a primary
// index. It is a special case of LookupJoin where the input columns are the PK
// columns of the table we are looking up into, and every input row results in
// exactly one output row.
//
// IndexJoin operators are created from Scan operators (unlike lookup joins which
// are created from Join operators).
func (_f *Factory) ConstructIndexJoin(
	input memo.GroupID,
	def memo.PrivateID,
) memo.GroupID {
	_indexJoinExpr := memo.MakeIndexJoinExpr(input, def)
	_group := _f.mem.GroupByFingerprint(_indexJoinExpr.Fingerprint())
	if _group != 0 {
		return _group
	}

	return _f.onConstruct(memo.Expr(_indexJoinExpr))
}

// ConstructLookupJoin constructs an expression for the LookupJoin operator.
// LookupJoin represents a join between an input expression and an index.
// The type of join is in the Def private.
func (_f *Factory) ConstructLookupJoin(
	input memo.GroupID,
	on memo.GroupID,
	def memo.PrivateID,
) memo.GroupID {
	_lookupJoinExpr := memo.MakeLookupJoinExpr(input, on, def)
	_group := _f.mem.GroupByFingerprint(_lookupJoinExpr.Fingerprint())
	if _group != 0 {
		return _group
	}

	return _f.onConstruct(memo.Expr(_lookupJoinExpr))
}

// ConstructMergeJoin constructs an expression for the MergeJoin operator.
// MergeJoin represents a join that is executed using merge-join.
// MergeOn is a scalar which contains the ON condition and merge-join ordering
// information; see the MergeOn scalar operator.
// It can be any type of join (identified in the private of MergeOn).
func (_f *Factory) ConstructMergeJoin(
	left memo.GroupID,
	right memo.GroupID,
	mergeOn memo.GroupID,
) memo.GroupID {
	_mergeJoinExpr := memo.MakeMergeJoinExpr(left, right, mergeOn)
	_group := _f.mem.GroupByFingerprint(_mergeJoinExpr.Fingerprint())
	if _group != 0 {
		return _group
	}

	return _f.onConstruct(memo.Expr(_mergeJoinExpr))
}

// ConstructInnerJoinApply constructs an expression for the InnerJoinApply operator.
// InnerJoinApply has the same join semantics as InnerJoin. However, unlike
// InnerJoin, it allows the right input to refer to columns projected by the
// left input.
func (_f *Factory) ConstructInnerJoinApply(
	left memo.GroupID,
	right memo.GroupID,
	on memo.GroupID,
) memo.GroupID {
	_innerJoinApplyExpr := memo.MakeInnerJoinApplyExpr(left, right, on)
	_group := _f.mem.GroupByFingerprint(_innerJoinApplyExpr.Fingerprint())
	if _group != 0 {
		return _group
	}

	// [TryDecorrelateSelect]
	{
		if _f.funcs.HasOuterCols(right) {
			_selectExpr := _f.mem.NormExpr(right).AsSelect()
			if _selectExpr != nil {
				input := _selectExpr.Input()
				filter := _selectExpr.Filter()
				if !_f.ruleCycles.detectCycle(_innerJoinApplyExpr.Fingerprint()) {
					if _f.matchedRule == nil || _f.matchedRule(opt.TryDecorrelateSelect) {
						_f.ruleCycles.push(_innerJoinApplyExpr.Fingerprint())
						_group = _f.ConstructInnerJoinApply(
							left,
							input,
							_f.funcs.ConcatFilters(on, filter),
						)
						_f.ruleCycles.pop()
						if _f.mem.GroupByFingerprint(_innerJoinApplyExpr.Fingerprint()) == 0 {
							_f.mem.AddAltFingerprint(_innerJoinApplyExpr.Fingerprint(), _group)
						}
						if _f.appliedRule != nil {
							_f.appliedRule(opt.TryDecorrelateSelect, _group, 0, 0)
						}
						return _group
					}
				}
			}
		}
	}

	// [TryDecorrelateInnerJoin]
	{
		if _f.funcs.HasOuterCols(right) {
			_expr := _f.mem.NormExpr(right)
			if _expr.Operator() == opt.InnerJoinOp || _expr.Operator() == opt.InnerJoinApplyOp {
				innerLeft := _expr.ChildGroup(_f.Memo(), 0)
				innerRight := _expr.ChildGroup(_f.Memo(), 1)
				innerOn := _expr.ChildGroup(_f.Memo(), 2)
				if !_f.ruleCycles.detectCycle(_innerJoinApplyExpr.Fingerprint()) {
					if _f.matchedRule == nil || _f.matchedRule(opt.TryDecorrelateInnerJoin) {
						_f.ruleCycles.push(_innerJoinApplyExpr.Fingerprint())
						_group = _f.ConstructInnerJoinApply(
							left,
							_f.DynamicConstruct(
								_f.mem.NormOp(right),
								memo.DynamicOperands{
									memo.DynamicID(innerLeft),
									memo.DynamicID(innerRight),
									memo.DynamicID(_f.ConstructTrue()),
								},
							),
							_f.funcs.ConcatFilters(on, innerOn),
						)
						_f.ruleCycles.pop()
						if _f.mem.GroupByFingerprint(_innerJoinApplyExpr.Fingerprint()) == 0 {
							_f.mem.AddAltFingerprint(_innerJoinApplyExpr.Fingerprint(), _group)
						}
						if _f.appliedRule != nil {
							_f.appliedRule(opt.TryDecorrelateInnerJoin, _group, 0, 0)
						}
						return _group
					}
				}
			}
		}
	}

	// [DecorrelateJoin]
	{
		if !_f.funcs.IsCorrelated(right, left) {
			if _f.matchedRule == nil || _f.matchedRule(opt.DecorrelateJoin) {
				_group = _f.funcs.ConstructNonApplyJoin(opt.InnerJoinApplyOp, left, right, on)
				_f.mem.AddAltFingerprint(_innerJoinApplyExpr.Fingerprint(), _group)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.DecorrelateJoin, _group, 0, 0)
				}
				return _group
			}
		}
	}

	// [TryDecorrelateProject]
	{
		if _f.funcs.HasOuterCols(right) {
			_projectExpr := _f.mem.NormExpr(right).AsProject()
			if _projectExpr != nil {
				input := _projectExpr.Input()
				projections := _projectExpr.Projections()
				if _f.matchedRule == nil || _f.matchedRule(opt.TryDecorrelateProject) {
					_group = _f.ConstructSelect(
						_f.ConstructProject(
							_f.ConstructInnerJoinApply(
								left,
								input,
								_f.ConstructTrue(),
							),
							_f.funcs.ProjectColsFromBoth(projections, left),
						),
						on,
					)
					_f.mem.AddAltFingerprint(_innerJoinApplyExpr.Fingerprint(), _group)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.TryDecorrelateProject, _group, 0, 0)
					}
					return _group
				}
			}
		}
	}

	// [TryDecorrelateInnerLeftJoin]
	{
		if _f.funcs.HasOuterCols(right) {
			_leftJoinExpr := _f.mem.NormExpr(right).AsLeftJoin()
			if _leftJoinExpr != nil {
				innerLeft := _leftJoinExpr.Left()
				innerRight := _leftJoinExpr.Right()
				innerOn := _leftJoinExpr.On()
				if _f.funcs.IsBoundBy(on, _f.funcs.OutputCols2(left, innerLeft)) {
					if _f.matchedRule == nil || _f.matchedRule(opt.TryDecorrelateInnerLeftJoin) {
						_group = _f.ConstructLeftJoinApply(
							_f.ConstructInnerJoinApply(
								left,
								innerLeft,
								on,
							),
							innerRight,
							innerOn,
						)
						_f.mem.AddAltFingerprint(_innerJoinApplyExpr.Fingerprint(), _group)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.TryDecorrelateInnerLeftJoin, _group, 0, 0)
						}
						return _group
					}
				}
			}
		}
	}

	// [TryDecorrelateGroupBy]
	{
		if _f.funcs.HasOuterCols(right) {
			_expr := _f.mem.NormExpr(right)
			if _expr.Operator() == opt.GroupByOp || _expr.Operator() == opt.DistinctOnOp {
				input := _expr.ChildGroup(_f.Memo(), 0)
				aggregations := _expr.ChildGroup(_f.Memo(), 1)
				def := _expr.PrivateID()
				if _f.funcs.IsUnorderedGroupBy(def) {
					if _f.matchedRule == nil || _f.matchedRule(opt.TryDecorrelateGroupBy) {
						newLeft := _f.funcs.EnsureKey(left)
						_group = _f.ConstructSelect(
							_f.DynamicConstruct(
								_f.mem.NormOp(right),
								memo.DynamicOperands{
									memo.DynamicID(_f.ConstructInnerJoinApply(
										newLeft,
										input,
										_f.ConstructTrue(),
									)),
									memo.DynamicID(_f.funcs.AppendAggCols(aggregations, opt.ConstAggOp, _f.funcs.NonKeyCols(newLeft))),
									memo.DynamicID(_f.funcs.AddColsToGroupByDef(def, _f.funcs.KeyCols(newLeft))),
								},
							),
							on,
						)
						_f.mem.AddAltFingerprint(_innerJoinApplyExpr.Fingerprint(), _group)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.TryDecorrelateGroupBy, _group, 0, 0)
						}
						return _group
					}
				}
			}
		}
	}

	// [TryDecorrelateScalarGroupBy]
	{
		if _f.funcs.HasOuterCols(right) {
			_scalarGroupByExpr := _f.mem.NormExpr(right).AsScalarGroupBy()
			if _scalarGroupByExpr != nil {
				input := _scalarGroupByExpr.Input()
				aggregations := _scalarGroupByExpr.Aggregations()
				def := _scalarGroupByExpr.Def()
				if _f.funcs.AggsCanBeDecorrelated(aggregations) {
					if _f.matchedRule == nil || _f.matchedRule(opt.TryDecorrelateScalarGroupBy) {
						leftWithKey := _f.funcs.EnsureKey(left)
						canaryCol := _f.funcs.EnsureCanaryCol(input, aggregations)
						rightWithCanary := _f.funcs.EnsureCanary(input, canaryCol)
						translatedAggs := _f.funcs.EnsureAggsCanIgnoreNulls(rightWithCanary, aggregations)
						_group = _f.ConstructSelect(
							_f.funcs.TranslateNonIgnoreAggs(_f.ConstructGroupBy(
								_f.ConstructLeftJoinApply(
									leftWithKey,
									rightWithCanary,
									_f.ConstructTrue(),
								),
								_f.funcs.AppendAggCols2(translatedAggs, opt.ConstAggOp, _f.funcs.NonKeyCols(leftWithKey), opt.AnyNotNullAggOp, _f.funcs.CanaryColSet(canaryCol)),
								_f.funcs.MakeOrderedGroupByDef(_f.funcs.KeyCols(leftWithKey), _f.funcs.ExtractGroupByOrdering(def)),
							), translatedAggs, rightWithCanary, aggregations, canaryCol),
							on,
						)
						_f.mem.AddAltFingerprint(_innerJoinApplyExpr.Fingerprint(), _group)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.TryDecorrelateScalarGroupBy, _group, 0, 0)
						}
						return _group
					}
				}
			}
		}
	}

	// [TryDecorrelateLimitOne]
	{
		if _f.funcs.HasOuterCols(right) {
			_limitExpr := _f.mem.NormExpr(right).AsLimit()
			if _limitExpr != nil {
				input := _limitExpr.Input()
				_constExpr := _f.mem.NormExpr(_limitExpr.Limit()).AsConst()
				if _constExpr != nil {
					if _f.funcs.EqualsNumber(_constExpr.Value(), 1) {
						ordering := _limitExpr.Ordering()
						if _f.matchedRule == nil || _f.matchedRule(opt.TryDecorrelateLimitOne) {
							newLeft := _f.funcs.EnsureKey(left)
							_group = _f.ConstructDistinctOn(
								_f.ConstructInnerJoinApply(
									newLeft,
									input,
									on,
								),
								_f.funcs.MakeAggCols2(opt.ConstAggOp, _f.funcs.NonKeyCols(newLeft), opt.FirstAggOp, _f.funcs.OutputCols(input)),
								_f.funcs.MakeOrderedGroupByDef(_f.funcs.KeyCols(newLeft), _f.funcs.ExtractOrdering(ordering)),
							)
							_f.mem.AddAltFingerprint(_innerJoinApplyExpr.Fingerprint(), _group)
							if _f.appliedRule != nil {
								_f.appliedRule(opt.TryDecorrelateLimitOne, _group, 0, 0)
							}
							return _group
						}
					}
				}
			}
		}
	}

	// [TryDecorrelateZip]
	{
		_innerJoinApplyExpr2 := _f.mem.NormExpr(right).AsInnerJoinApply()
		if _innerJoinApplyExpr2 != nil {
			innerLeft := _innerJoinApplyExpr2.Left()
			innerRight := _innerJoinApplyExpr2.Right()
			_zipExpr := _f.mem.NormExpr(_innerJoinApplyExpr2.Right()).AsZip()
			if _zipExpr != nil {
				innerOn := _innerJoinApplyExpr2.On()
				if _f.matchedRule == nil || _f.matchedRule(opt.TryDecorrelateZip) {
					_group = _f.ConstructInnerJoinApply(
						_f.ConstructInnerJoinApply(
							left,
							innerLeft,
							_f.ConstructTrue(),
						),
						innerRight,
						_f.funcs.ConcatFilters(on, innerOn),
					)
					_f.mem.AddAltFingerprint(_innerJoinApplyExpr.Fingerprint(), _group)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.TryDecorrelateZip, _group, 0, 0)
					}
					return _group
				}
			}
		}
	}

	// [MapFilterIntoJoinLeft]
	{
		filters := on
		_filtersExpr := _f.mem.NormExpr(on).AsFilters()
		if _filtersExpr != nil {
			list := _filtersExpr.Conditions()
			for _, _item := range _f.mem.LookupList(_filtersExpr.Conditions()) {
				condition := _item
				_match := false
				_eqExpr := _f.mem.NormExpr(_item).AsEq()
				if _eqExpr != nil {
					_variableExpr := _f.mem.NormExpr(_eqExpr.Left()).AsVariable()
					if _variableExpr != nil {
						_variableExpr2 := _f.mem.NormExpr(_eqExpr.Right()).AsVariable()
						if _variableExpr2 != nil {
							_match = true
						}
					}
				}

				if !_match {
					if !_f.funcs.IsBoundBy(condition, _f.funcs.OutputCols(left)) {
						if _f.funcs.CanMap(filters, condition, left) {
							if _f.matchedRule == nil || _f.matchedRule(opt.MapFilterIntoJoinLeft) {
								_group = _f.ConstructInnerJoinApply(
									left,
									right,
									_f.ConstructFilters(
										_f.funcs.ReplaceListItem(list, condition, _f.funcs.Map(filters, condition, left)),
									),
								)
								_f.mem.AddAltFingerprint(_innerJoinApplyExpr.Fingerprint(), _group)
								if _f.appliedRule != nil {
									_f.appliedRule(opt.MapFilterIntoJoinLeft, _group, 0, 0)
								}
								return _group
							}
						}
					}
				}
			}
		}
	}

	// [MapFilterIntoJoinRight]
	{
		_zipExpr := _f.mem.NormExpr(right).AsZip()
		if _zipExpr == nil {
			filters := on
			_filtersExpr := _f.mem.NormExpr(on).AsFilters()
			if _filtersExpr != nil {
				list := _filtersExpr.Conditions()
				for _, _item := range _f.mem.LookupList(_filtersExpr.Conditions()) {
					condition := _item
					_match := false
					_eqExpr := _f.mem.NormExpr(_item).AsEq()
					if _eqExpr != nil {
						_variableExpr := _f.mem.NormExpr(_eqExpr.Left()).AsVariable()
						if _variableExpr != nil {
							_variableExpr2 := _f.mem.NormExpr(_eqExpr.Right()).AsVariable()
							if _variableExpr2 != nil {
								_match = true
							}
						}
					}

					if !_match {
						if !_f.funcs.IsBoundBy(condition, _f.funcs.OutputCols(right)) {
							if _f.funcs.CanMap(filters, condition, right) {
								if _f.matchedRule == nil || _f.matchedRule(opt.MapFilterIntoJoinRight) {
									_group = _f.ConstructInnerJoinApply(
										left,
										right,
										_f.ConstructFilters(
											_f.funcs.ReplaceListItem(list, condition, _f.funcs.Map(filters, condition, right)),
										),
									)
									_f.mem.AddAltFingerprint(_innerJoinApplyExpr.Fingerprint(), _group)
									if _f.appliedRule != nil {
										_f.appliedRule(opt.MapFilterIntoJoinRight, _group, 0, 0)
									}
									return _group
								}
							}
						}
					}
				}
			}
		}
	}

	// [PushFilterIntoJoinLeft]
	{
		_filtersExpr := _f.mem.NormExpr(on).AsFilters()
		if _filtersExpr != nil {
			list := _filtersExpr.Conditions()
			for _, _item := range _f.mem.LookupList(_filtersExpr.Conditions()) {
				condition := _item
				leftCols := _f.funcs.OutputCols(left)
				if _f.funcs.IsBoundBy(condition, leftCols) {
					if _f.matchedRule == nil || _f.matchedRule(opt.PushFilterIntoJoinLeft) {
						_group = _f.ConstructInnerJoinApply(
							_f.ConstructSelect(
								left,
								_f.ConstructFilters(
									_f.funcs.ExtractBoundConditions(list, leftCols),
								),
							),
							right,
							_f.ConstructFilters(
								_f.funcs.ExtractUnboundConditions(list, leftCols),
							),
						)
						_f.mem.AddAltFingerprint(_innerJoinApplyExpr.Fingerprint(), _group)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.PushFilterIntoJoinLeft, _group, 0, 0)
						}
						return _group
					}
				}
			}
		}
	}

	// [PushFilterIntoJoinRight]
	{
		_zipExpr := _f.mem.NormExpr(right).AsZip()
		if _zipExpr == nil {
			_filtersExpr := _f.mem.NormExpr(on).AsFilters()
			if _filtersExpr != nil {
				list := _filtersExpr.Conditions()
				for _, _item := range _f.mem.LookupList(_filtersExpr.Conditions()) {
					condition := _item
					rightCols := _f.funcs.OutputCols(right)
					if _f.funcs.IsBoundBy(condition, rightCols) {
						if _f.matchedRule == nil || _f.matchedRule(opt.PushFilterIntoJoinRight) {
							_group = _f.ConstructInnerJoinApply(
								left,
								_f.ConstructSelect(
									right,
									_f.ConstructFilters(
										_f.funcs.ExtractBoundConditions(list, rightCols),
									),
								),
								_f.ConstructFilters(
									_f.funcs.ExtractUnboundConditions(list, rightCols),
								),
							)
							_f.mem.AddAltFingerprint(_innerJoinApplyExpr.Fingerprint(), _group)
							if _f.appliedRule != nil {
								_f.appliedRule(opt.PushFilterIntoJoinRight, _group, 0, 0)
							}
							return _group
						}
					}
				}
			}
		}
	}

	// [EliminateJoinNoColsLeft]
	{
		if _f.funcs.HasNoCols(left) {
			if _f.funcs.HasOneRow(left) {
				if _f.matchedRule == nil || _f.matchedRule(opt.EliminateJoinNoColsLeft) {
					_group = _f.ConstructSelect(
						right,
						on,
					)
					_f.mem.AddAltFingerprint(_innerJoinApplyExpr.Fingerprint(), _group)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.EliminateJoinNoColsLeft, _group, 0, 0)
					}
					return _group
				}
			}
		}
	}

	// [EliminateJoinNoColsRight]
	{
		if _f.funcs.HasNoCols(right) {
			if _f.funcs.HasOneRow(right) {
				if _f.matchedRule == nil || _f.matchedRule(opt.EliminateJoinNoColsRight) {
					_group = _f.ConstructSelect(
						left,
						on,
					)
					_f.mem.AddAltFingerprint(_innerJoinApplyExpr.Fingerprint(), _group)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.EliminateJoinNoColsRight, _group, 0, 0)
					}
					return _group
				}
			}
		}
	}

	// [HoistJoinProject]
	{
		_projectExpr := _f.mem.NormExpr(right).AsProject()
		if _projectExpr != nil {
			input := _projectExpr.Input()
			_projectionsExpr := _f.mem.NormExpr(_projectExpr.Projections()).AsProjections()
			if _projectionsExpr != nil {
				if _projectionsExpr.Elems().Length == 0 {
					if _f.matchedRule == nil || _f.matchedRule(opt.HoistJoinProject) {
						_group = _f.ConstructProject(
							_f.ConstructInnerJoinApply(
								left,
								input,
								on,
							),
							_f.funcs.ProjectColsFromBoth(left, right),
						)
						_f.mem.AddAltFingerprint(_innerJoinApplyExpr.Fingerprint(), _group)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.HoistJoinProject, _group, 0, 0)
						}
						return _group
					}
				}
			}
		}
	}

	// [SimplifyJoinNotNullEquality]
	{
		_filtersExpr := _f.mem.NormExpr(on).AsFilters()
		if _filtersExpr != nil {
			list := _filtersExpr.Conditions()
			for _, _item := range _f.mem.LookupList(_filtersExpr.Conditions()) {
				condition := _item
				_expr := _f.mem.NormExpr(_item)
				if _expr.Operator() == opt.IsOp || _expr.Operator() == opt.IsNotOp {
					eq := _expr.ChildGroup(_f.Memo(), 0)
					_eqExpr := _f.mem.NormExpr(_expr.ChildGroup(_f.Memo(), 0)).AsEq()
					if _eqExpr != nil {
						_variableExpr := _f.mem.NormExpr(_eqExpr.Left()).AsVariable()
						if _variableExpr != nil {
							col1 := _variableExpr.Col()
							if _f.funcs.IsColNotNull2(col1, left, right) {
								_variableExpr2 := _f.mem.NormExpr(_eqExpr.Right()).AsVariable()
								if _variableExpr2 != nil {
									col2 := _variableExpr2.Col()
									if _f.funcs.IsColNotNull2(col2, left, right) {
										cnst := _expr.ChildGroup(_f.Memo(), 1)
										_expr2 := _f.mem.NormExpr(_expr.ChildGroup(_f.Memo(), 1))
										if _expr2.Operator() == opt.TrueOp || _expr2.Operator() == opt.FalseOp || _expr2.Operator() == opt.NullOp {
											if _f.matchedRule == nil || _f.matchedRule(opt.SimplifyJoinNotNullEquality) {
												_group = _f.ConstructInnerJoinApply(
													left,
													right,
													_f.ConstructFilters(
														_f.funcs.ReplaceListItem(list, condition, _f.funcs.SimplifyNotNullEquality(eq, _f.mem.NormExpr(condition).Operator(), _f.mem.NormExpr(cnst).Operator())),
													),
												)
												_f.mem.AddAltFingerprint(_innerJoinApplyExpr.Fingerprint(), _group)
												if _f.appliedRule != nil {
													_f.appliedRule(opt.SimplifyJoinNotNullEquality, _group, 0, 0)
												}
												return _group
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}

	// [HoistJoinSubquery]
	{
		if _f.funcs.HasHoistableSubquery(on) {
			_filtersExpr := _f.mem.NormExpr(on).AsFilters()
			if _filtersExpr != nil {
				if _f.matchedRule == nil || _f.matchedRule(opt.HoistJoinSubquery) {
					_group = _f.funcs.HoistJoinSubquery(opt.InnerJoinApplyOp, left, right, on)
					_f.mem.AddAltFingerprint(_innerJoinApplyExpr.Fingerprint(), _group)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.HoistJoinSubquery, _group, 0, 0)
					}
					return _group
				}
			}
		}
	}

	return _f.onConstruct(memo.Expr(_innerJoinApplyExpr))
}

// ConstructLeftJoinApply constructs an expression for the LeftJoinApply operator.
func (_f *Factory) ConstructLeftJoinApply(
	left memo.GroupID,
	right memo.GroupID,
	on memo.GroupID,
) memo.GroupID {
	_leftJoinApplyExpr := memo.MakeLeftJoinApplyExpr(left, right, on)
	_group := _f.mem.GroupByFingerprint(_leftJoinApplyExpr.Fingerprint())
	if _group != 0 {
		return _group
	}

	// [TryDecorrelateSelect]
	{
		if _f.funcs.HasOuterCols(right) {
			_selectExpr := _f.mem.NormExpr(right).AsSelect()
			if _selectExpr != nil {
				input := _selectExpr.Input()
				filter := _selectExpr.Filter()
				if !_f.ruleCycles.detectCycle(_leftJoinApplyExpr.Fingerprint()) {
					if _f.matchedRule == nil || _f.matchedRule(opt.TryDecorrelateSelect) {
						_f.ruleCycles.push(_leftJoinApplyExpr.Fingerprint())
						_group = _f.ConstructLeftJoinApply(
							left,
							input,
							_f.funcs.ConcatFilters(on, filter),
						)
						_f.ruleCycles.pop()
						if _f.mem.GroupByFingerprint(_leftJoinApplyExpr.Fingerprint()) == 0 {
							_f.mem.AddAltFingerprint(_leftJoinApplyExpr.Fingerprint(), _group)
						}
						if _f.appliedRule != nil {
							_f.appliedRule(opt.TryDecorrelateSelect, _group, 0, 0)
						}
						return _group
					}
				}
			}
		}
	}

	// [TryDecorrelateProjectSelect]
	{
		_projectExpr := _f.mem.NormExpr(right).AsProject()
		if _projectExpr != nil {
			_selectExpr := _f.mem.NormExpr(_projectExpr.Input()).AsSelect()
			if _selectExpr != nil {
				selectInput := _selectExpr.Input()
				filters := _selectExpr.Filter()
				if !_f.funcs.IsBoundBy(filters, _f.funcs.OutputCols(selectInput)) {
					projections := _projectExpr.Projections()
					if !_f.ruleCycles.detectCycle(_leftJoinApplyExpr.Fingerprint()) {
						if _f.matchedRule == nil || _f.matchedRule(opt.TryDecorrelateProjectSelect) {
							_f.ruleCycles.push(_leftJoinApplyExpr.Fingerprint())
							_group = _f.ConstructProject(
								_f.ConstructLeftJoinApply(
									left,
									_f.ConstructProject(
										selectInput,
										_f.funcs.ProjectColsFromBoth(projections, selectInput),
									),
									_f.funcs.ConcatFilters(on, filters),
								),
								_f.funcs.ProjectColsFromBoth(left, right),
							)
							_f.ruleCycles.pop()
							if _f.mem.GroupByFingerprint(_leftJoinApplyExpr.Fingerprint()) == 0 {
								_f.mem.AddAltFingerprint(_leftJoinApplyExpr.Fingerprint(), _group)
							}
							if _f.appliedRule != nil {
								_f.appliedRule(opt.TryDecorrelateProjectSelect, _group, 0, 0)
							}
							return _group
						}
					}
				}
			}
		}
	}

	// [TryDecorrelateProjectInnerJoin]
	{
		_projectExpr := _f.mem.NormExpr(right).AsProject()
		if _projectExpr != nil {
			join := _projectExpr.Input()
			_expr := _f.mem.NormExpr(_projectExpr.Input())
			if _expr.Operator() == opt.InnerJoinOp || _expr.Operator() == opt.InnerJoinApplyOp {
				innerLeft := _expr.ChildGroup(_f.Memo(), 0)
				innerRight := _expr.ChildGroup(_f.Memo(), 1)
				innerOn := _expr.ChildGroup(_f.Memo(), 2)
				if !_f.funcs.IsBoundBy(innerOn, _f.funcs.OutputCols2(innerLeft, innerRight)) {
					projections := _projectExpr.Projections()
					if !_f.ruleCycles.detectCycle(_leftJoinApplyExpr.Fingerprint()) {
						if _f.matchedRule == nil || _f.matchedRule(opt.TryDecorrelateProjectInnerJoin) {
							_f.ruleCycles.push(_leftJoinApplyExpr.Fingerprint())
							_group = _f.ConstructProject(
								_f.ConstructLeftJoinApply(
									left,
									_f.ConstructProject(
										_f.DynamicConstruct(
											_f.mem.NormOp(join),
											memo.DynamicOperands{
												memo.DynamicID(innerLeft),
												memo.DynamicID(innerRight),
												memo.DynamicID(_f.ConstructTrue()),
											},
										),
										_f.funcs.ProjectColsFromBoth(projections, join),
									),
									_f.funcs.ConcatFilters(on, innerOn),
								),
								_f.funcs.ProjectColsFromBoth(left, right),
							)
							_f.ruleCycles.pop()
							if _f.mem.GroupByFingerprint(_leftJoinApplyExpr.Fingerprint()) == 0 {
								_f.mem.AddAltFingerprint(_leftJoinApplyExpr.Fingerprint(), _group)
							}
							if _f.appliedRule != nil {
								_f.appliedRule(opt.TryDecorrelateProjectInnerJoin, _group, 0, 0)
							}
							return _group
						}
					}
				}
			}
		}
	}

	// [TryDecorrelateInnerJoin]
	{
		if _f.funcs.HasOuterCols(right) {
			_expr := _f.mem.NormExpr(right)
			if _expr.Operator() == opt.InnerJoinOp || _expr.Operator() == opt.InnerJoinApplyOp {
				innerLeft := _expr.ChildGroup(_f.Memo(), 0)
				innerRight := _expr.ChildGroup(_f.Memo(), 1)
				innerOn := _expr.ChildGroup(_f.Memo(), 2)
				if !_f.ruleCycles.detectCycle(_leftJoinApplyExpr.Fingerprint()) {
					if _f.matchedRule == nil || _f.matchedRule(opt.TryDecorrelateInnerJoin) {
						_f.ruleCycles.push(_leftJoinApplyExpr.Fingerprint())
						_group = _f.ConstructLeftJoinApply(
							left,
							_f.DynamicConstruct(
								_f.mem.NormOp(right),
								memo.DynamicOperands{
									memo.DynamicID(innerLeft),
									memo.DynamicID(innerRight),
									memo.DynamicID(_f.ConstructTrue()),
								},
							),
							_f.funcs.ConcatFilters(on, innerOn),
						)
						_f.ruleCycles.pop()
						if _f.mem.GroupByFingerprint(_leftJoinApplyExpr.Fingerprint()) == 0 {
							_f.mem.AddAltFingerprint(_leftJoinApplyExpr.Fingerprint(), _group)
						}
						if _f.appliedRule != nil {
							_f.appliedRule(opt.TryDecorrelateInnerJoin, _group, 0, 0)
						}
						return _group
					}
				}
			}
		}
	}

	// [DecorrelateJoin]
	{
		if !_f.funcs.IsCorrelated(right, left) {
			if _f.matchedRule == nil || _f.matchedRule(opt.DecorrelateJoin) {
				_group = _f.funcs.ConstructNonApplyJoin(opt.LeftJoinApplyOp, left, right, on)
				_f.mem.AddAltFingerprint(_leftJoinApplyExpr.Fingerprint(), _group)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.DecorrelateJoin, _group, 0, 0)
				}
				return _group
			}
		}
	}

	// [TryDecorrelateLimitOne]
	{
		if _f.funcs.HasOuterCols(right) {
			_limitExpr := _f.mem.NormExpr(right).AsLimit()
			if _limitExpr != nil {
				input := _limitExpr.Input()
				_constExpr := _f.mem.NormExpr(_limitExpr.Limit()).AsConst()
				if _constExpr != nil {
					if _f.funcs.EqualsNumber(_constExpr.Value(), 1) {
						ordering := _limitExpr.Ordering()
						if _f.matchedRule == nil || _f.matchedRule(opt.TryDecorrelateLimitOne) {
							newLeft := _f.funcs.EnsureKey(left)
							_group = _f.ConstructDistinctOn(
								_f.ConstructLeftJoinApply(
									newLeft,
									input,
									on,
								),
								_f.funcs.MakeAggCols2(opt.ConstAggOp, _f.funcs.NonKeyCols(newLeft), opt.FirstAggOp, _f.funcs.OutputCols(input)),
								_f.funcs.MakeOrderedGroupByDef(_f.funcs.KeyCols(newLeft), _f.funcs.ExtractOrdering(ordering)),
							)
							_f.mem.AddAltFingerprint(_leftJoinApplyExpr.Fingerprint(), _group)
							if _f.appliedRule != nil {
								_f.appliedRule(opt.TryDecorrelateLimitOne, _group, 0, 0)
							}
							return _group
						}
					}
				}
			}
		}
	}

	// [MapFilterIntoJoinRight]
	{
		_zipExpr := _f.mem.NormExpr(right).AsZip()
		if _zipExpr == nil {
			filters := on
			_filtersExpr := _f.mem.NormExpr(on).AsFilters()
			if _filtersExpr != nil {
				list := _filtersExpr.Conditions()
				for _, _item := range _f.mem.LookupList(_filtersExpr.Conditions()) {
					condition := _item
					_match := false
					_eqExpr := _f.mem.NormExpr(_item).AsEq()
					if _eqExpr != nil {
						_variableExpr := _f.mem.NormExpr(_eqExpr.Left()).AsVariable()
						if _variableExpr != nil {
							_variableExpr2 := _f.mem.NormExpr(_eqExpr.Right()).AsVariable()
							if _variableExpr2 != nil {
								_match = true
							}
						}
					}

					if !_match {
						if !_f.funcs.IsBoundBy(condition, _f.funcs.OutputCols(right)) {
							if _f.funcs.CanMap(filters, condition, right) {
								if _f.matchedRule == nil || _f.matchedRule(opt.MapFilterIntoJoinRight) {
									_group = _f.ConstructLeftJoinApply(
										left,
										right,
										_f.ConstructFilters(
											_f.funcs.ReplaceListItem(list, condition, _f.funcs.Map(filters, condition, right)),
										),
									)
									_f.mem.AddAltFingerprint(_leftJoinApplyExpr.Fingerprint(), _group)
									if _f.appliedRule != nil {
										_f.appliedRule(opt.MapFilterIntoJoinRight, _group, 0, 0)
									}
									return _group
								}
							}
						}
					}
				}
			}
		}
	}

	// [PushFilterIntoJoinRight]
	{
		_zipExpr := _f.mem.NormExpr(right).AsZip()
		if _zipExpr == nil {
			_filtersExpr := _f.mem.NormExpr(on).AsFilters()
			if _filtersExpr != nil {
				list := _filtersExpr.Conditions()
				for _, _item := range _f.mem.LookupList(_filtersExpr.Conditions()) {
					condition := _item
					rightCols := _f.funcs.OutputCols(right)
					if _f.funcs.IsBoundBy(condition, rightCols) {
						if _f.matchedRule == nil || _f.matchedRule(opt.PushFilterIntoJoinRight) {
							_group = _f.ConstructLeftJoinApply(
								left,
								_f.ConstructSelect(
									right,
									_f.ConstructFilters(
										_f.funcs.ExtractBoundConditions(list, rightCols),
									),
								),
								_f.ConstructFilters(
									_f.funcs.ExtractUnboundConditions(list, rightCols),
								),
							)
							_f.mem.AddAltFingerprint(_leftJoinApplyExpr.Fingerprint(), _group)
							if _f.appliedRule != nil {
								_f.appliedRule(opt.PushFilterIntoJoinRight, _group, 0, 0)
							}
							return _group
						}
					}
				}
			}
		}
	}

	// [SimplifyLeftJoinWithoutFilters]
	{
		if !_f.funcs.CanHaveZeroRows(right) {
			_trueExpr := _f.mem.NormExpr(on).AsTrue()
			if _trueExpr != nil {
				if _f.matchedRule == nil || _f.matchedRule(opt.SimplifyLeftJoinWithoutFilters) {
					_group = _f.funcs.ConstructNonLeftJoin(opt.LeftJoinApplyOp, left, right, on)
					_f.mem.AddAltFingerprint(_leftJoinApplyExpr.Fingerprint(), _group)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.SimplifyLeftJoinWithoutFilters, _group, 0, 0)
					}
					return _group
				}
			}
		}
	}

	// [SimplifyLeftJoinWithFilters]
	{
		_filtersExpr := _f.mem.NormExpr(on).AsFilters()
		if _filtersExpr != nil {
			if _f.funcs.JoinFiltersMatchAllLeftRows(left, right, on) {
				if _f.matchedRule == nil || _f.matchedRule(opt.SimplifyLeftJoinWithFilters) {
					_group = _f.funcs.ConstructNonLeftJoin(opt.LeftJoinApplyOp, left, right, on)
					_f.mem.AddAltFingerprint(_leftJoinApplyExpr.Fingerprint(), _group)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.SimplifyLeftJoinWithFilters, _group, 0, 0)
					}
					return _group
				}
			}
		}
	}

	// [HoistJoinProject]
	{
		_projectExpr := _f.mem.NormExpr(right).AsProject()
		if _projectExpr != nil {
			input := _projectExpr.Input()
			_projectionsExpr := _f.mem.NormExpr(_projectExpr.Projections()).AsProjections()
			if _projectionsExpr != nil {
				if _projectionsExpr.Elems().Length == 0 {
					if _f.matchedRule == nil || _f.matchedRule(opt.HoistJoinProject) {
						_group = _f.ConstructProject(
							_f.ConstructLeftJoinApply(
								left,
								input,
								on,
							),
							_f.funcs.ProjectColsFromBoth(left, right),
						)
						_f.mem.AddAltFingerprint(_leftJoinApplyExpr.Fingerprint(), _group)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.HoistJoinProject, _group, 0, 0)
						}
						return _group
					}
				}
			}
		}
	}

	// [SimplifyJoinNotNullEquality]
	{
		_filtersExpr := _f.mem.NormExpr(on).AsFilters()
		if _filtersExpr != nil {
			list := _filtersExpr.Conditions()
			for _, _item := range _f.mem.LookupList(_filtersExpr.Conditions()) {
				condition := _item
				_expr := _f.mem.NormExpr(_item)
				if _expr.Operator() == opt.IsOp || _expr.Operator() == opt.IsNotOp {
					eq := _expr.ChildGroup(_f.Memo(), 0)
					_eqExpr := _f.mem.NormExpr(_expr.ChildGroup(_f.Memo(), 0)).AsEq()
					if _eqExpr != nil {
						_variableExpr := _f.mem.NormExpr(_eqExpr.Left()).AsVariable()
						if _variableExpr != nil {
							col1 := _variableExpr.Col()
							if _f.funcs.IsColNotNull2(col1, left, right) {
								_variableExpr2 := _f.mem.NormExpr(_eqExpr.Right()).AsVariable()
								if _variableExpr2 != nil {
									col2 := _variableExpr2.Col()
									if _f.funcs.IsColNotNull2(col2, left, right) {
										cnst := _expr.ChildGroup(_f.Memo(), 1)
										_expr2 := _f.mem.NormExpr(_expr.ChildGroup(_f.Memo(), 1))
										if _expr2.Operator() == opt.TrueOp || _expr2.Operator() == opt.FalseOp || _expr2.Operator() == opt.NullOp {
											if _f.matchedRule == nil || _f.matchedRule(opt.SimplifyJoinNotNullEquality) {
												_group = _f.ConstructLeftJoinApply(
													left,
													right,
													_f.ConstructFilters(
														_f.funcs.ReplaceListItem(list, condition, _f.funcs.SimplifyNotNullEquality(eq, _f.mem.NormExpr(condition).Operator(), _f.mem.NormExpr(cnst).Operator())),
													),
												)
												_f.mem.AddAltFingerprint(_leftJoinApplyExpr.Fingerprint(), _group)
												if _f.appliedRule != nil {
													_f.appliedRule(opt.SimplifyJoinNotNullEquality, _group, 0, 0)
												}
												return _group
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}

	// [HoistJoinSubquery]
	{
		if _f.funcs.HasHoistableSubquery(on) {
			_filtersExpr := _f.mem.NormExpr(on).AsFilters()
			if _filtersExpr != nil {
				if _f.matchedRule == nil || _f.matchedRule(opt.HoistJoinSubquery) {
					_group = _f.funcs.HoistJoinSubquery(opt.LeftJoinApplyOp, left, right, on)
					_f.mem.AddAltFingerprint(_leftJoinApplyExpr.Fingerprint(), _group)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.HoistJoinSubquery, _group, 0, 0)
					}
					return _group
				}
			}
		}
	}

	return _f.onConstruct(memo.Expr(_leftJoinApplyExpr))
}

// ConstructRightJoinApply constructs an expression for the RightJoinApply operator.
func (_f *Factory) ConstructRightJoinApply(
	left memo.GroupID,
	right memo.GroupID,
	on memo.GroupID,
) memo.GroupID {
	_rightJoinApplyExpr := memo.MakeRightJoinApplyExpr(left, right, on)
	_group := _f.mem.GroupByFingerprint(_rightJoinApplyExpr.Fingerprint())
	if _group != 0 {
		return _group
	}

	// [DecorrelateJoin]
	{
		if !_f.funcs.IsCorrelated(right, left) {
			if _f.matchedRule == nil || _f.matchedRule(opt.DecorrelateJoin) {
				_group = _f.funcs.ConstructNonApplyJoin(opt.RightJoinApplyOp, left, right, on)
				_f.mem.AddAltFingerprint(_rightJoinApplyExpr.Fingerprint(), _group)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.DecorrelateJoin, _group, 0, 0)
				}
				return _group
			}
		}
	}

	// [MapFilterIntoJoinLeft]
	{
		filters := on
		_filtersExpr := _f.mem.NormExpr(on).AsFilters()
		if _filtersExpr != nil {
			list := _filtersExpr.Conditions()
			for _, _item := range _f.mem.LookupList(_filtersExpr.Conditions()) {
				condition := _item
				_match := false
				_eqExpr := _f.mem.NormExpr(_item).AsEq()
				if _eqExpr != nil {
					_variableExpr := _f.mem.NormExpr(_eqExpr.Left()).AsVariable()
					if _variableExpr != nil {
						_variableExpr2 := _f.mem.NormExpr(_eqExpr.Right()).AsVariable()
						if _variableExpr2 != nil {
							_match = true
						}
					}
				}

				if !_match {
					if !_f.funcs.IsBoundBy(condition, _f.funcs.OutputCols(left)) {
						if _f.funcs.CanMap(filters, condition, left) {
							if _f.matchedRule == nil || _f.matchedRule(opt.MapFilterIntoJoinLeft) {
								_group = _f.ConstructRightJoinApply(
									left,
									right,
									_f.ConstructFilters(
										_f.funcs.ReplaceListItem(list, condition, _f.funcs.Map(filters, condition, left)),
									),
								)
								_f.mem.AddAltFingerprint(_rightJoinApplyExpr.Fingerprint(), _group)
								if _f.appliedRule != nil {
									_f.appliedRule(opt.MapFilterIntoJoinLeft, _group, 0, 0)
								}
								return _group
							}
						}
					}
				}
			}
		}
	}

	// [PushFilterIntoJoinLeft]
	{
		_filtersExpr := _f.mem.NormExpr(on).AsFilters()
		if _filtersExpr != nil {
			list := _filtersExpr.Conditions()
			for _, _item := range _f.mem.LookupList(_filtersExpr.Conditions()) {
				condition := _item
				leftCols := _f.funcs.OutputCols(left)
				if _f.funcs.IsBoundBy(condition, leftCols) {
					if _f.matchedRule == nil || _f.matchedRule(opt.PushFilterIntoJoinLeft) {
						_group = _f.ConstructRightJoinApply(
							_f.ConstructSelect(
								left,
								_f.ConstructFilters(
									_f.funcs.ExtractBoundConditions(list, leftCols),
								),
							),
							right,
							_f.ConstructFilters(
								_f.funcs.ExtractUnboundConditions(list, leftCols),
							),
						)
						_f.mem.AddAltFingerprint(_rightJoinApplyExpr.Fingerprint(), _group)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.PushFilterIntoJoinLeft, _group, 0, 0)
						}
						return _group
					}
				}
			}
		}
	}

	// [SimplifyRightJoinWithoutFilters]
	{
		if !_f.funcs.CanHaveZeroRows(left) {
			_trueExpr := _f.mem.NormExpr(on).AsTrue()
			if _trueExpr != nil {
				if _f.matchedRule == nil || _f.matchedRule(opt.SimplifyRightJoinWithoutFilters) {
					_group = _f.funcs.ConstructNonRightJoin(opt.RightJoinApplyOp, left, right, on)
					_f.mem.AddAltFingerprint(_rightJoinApplyExpr.Fingerprint(), _group)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.SimplifyRightJoinWithoutFilters, _group, 0, 0)
					}
					return _group
				}
			}
		}
	}

	// [SimplifyRightJoinWithFilters]
	{
		_filtersExpr := _f.mem.NormExpr(on).AsFilters()
		if _filtersExpr != nil {
			if _f.funcs.JoinFiltersMatchAllLeftRows(right, left, on) {
				if _f.matchedRule == nil || _f.matchedRule(opt.SimplifyRightJoinWithFilters) {
					_group = _f.funcs.ConstructNonRightJoin(opt.RightJoinApplyOp, left, right, on)
					_f.mem.AddAltFingerprint(_rightJoinApplyExpr.Fingerprint(), _group)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.SimplifyRightJoinWithFilters, _group, 0, 0)
					}
					return _group
				}
			}
		}
	}

	// [SimplifyJoinNotNullEquality]
	{
		_filtersExpr := _f.mem.NormExpr(on).AsFilters()
		if _filtersExpr != nil {
			list := _filtersExpr.Conditions()
			for _, _item := range _f.mem.LookupList(_filtersExpr.Conditions()) {
				condition := _item
				_expr := _f.mem.NormExpr(_item)
				if _expr.Operator() == opt.IsOp || _expr.Operator() == opt.IsNotOp {
					eq := _expr.ChildGroup(_f.Memo(), 0)
					_eqExpr := _f.mem.NormExpr(_expr.ChildGroup(_f.Memo(), 0)).AsEq()
					if _eqExpr != nil {
						_variableExpr := _f.mem.NormExpr(_eqExpr.Left()).AsVariable()
						if _variableExpr != nil {
							col1 := _variableExpr.Col()
							if _f.funcs.IsColNotNull2(col1, left, right) {
								_variableExpr2 := _f.mem.NormExpr(_eqExpr.Right()).AsVariable()
								if _variableExpr2 != nil {
									col2 := _variableExpr2.Col()
									if _f.funcs.IsColNotNull2(col2, left, right) {
										cnst := _expr.ChildGroup(_f.Memo(), 1)
										_expr2 := _f.mem.NormExpr(_expr.ChildGroup(_f.Memo(), 1))
										if _expr2.Operator() == opt.TrueOp || _expr2.Operator() == opt.FalseOp || _expr2.Operator() == opt.NullOp {
											if _f.matchedRule == nil || _f.matchedRule(opt.SimplifyJoinNotNullEquality) {
												_group = _f.ConstructRightJoinApply(
													left,
													right,
													_f.ConstructFilters(
														_f.funcs.ReplaceListItem(list, condition, _f.funcs.SimplifyNotNullEquality(eq, _f.mem.NormExpr(condition).Operator(), _f.mem.NormExpr(cnst).Operator())),
													),
												)
												_f.mem.AddAltFingerprint(_rightJoinApplyExpr.Fingerprint(), _group)
												if _f.appliedRule != nil {
													_f.appliedRule(opt.SimplifyJoinNotNullEquality, _group, 0, 0)
												}
												return _group
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}

	// [HoistJoinSubquery]
	{
		if _f.funcs.HasHoistableSubquery(on) {
			_filtersExpr := _f.mem.NormExpr(on).AsFilters()
			if _filtersExpr != nil {
				if _f.matchedRule == nil || _f.matchedRule(opt.HoistJoinSubquery) {
					_group = _f.funcs.HoistJoinSubquery(opt.RightJoinApplyOp, left, right, on)
					_f.mem.AddAltFingerprint(_rightJoinApplyExpr.Fingerprint(), _group)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.HoistJoinSubquery, _group, 0, 0)
					}
					return _group
				}
			}
		}
	}

	return _f.onConstruct(memo.Expr(_rightJoinApplyExpr))
}

// ConstructFullJoinApply constructs an expression for the FullJoinApply operator.
func (_f *Factory) ConstructFullJoinApply(
	left memo.GroupID,
	right memo.GroupID,
	on memo.GroupID,
) memo.GroupID {
	_fullJoinApplyExpr := memo.MakeFullJoinApplyExpr(left, right, on)
	_group := _f.mem.GroupByFingerprint(_fullJoinApplyExpr.Fingerprint())
	if _group != 0 {
		return _group
	}

	// [DecorrelateJoin]
	{
		if !_f.funcs.IsCorrelated(right, left) {
			if _f.matchedRule == nil || _f.matchedRule(opt.DecorrelateJoin) {
				_group = _f.funcs.ConstructNonApplyJoin(opt.FullJoinApplyOp, left, right, on)
				_f.mem.AddAltFingerprint(_fullJoinApplyExpr.Fingerprint(), _group)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.DecorrelateJoin, _group, 0, 0)
				}
				return _group
			}
		}
	}

	// [SimplifyLeftJoinWithoutFilters]
	{
		if !_f.funcs.CanHaveZeroRows(right) {
			_trueExpr := _f.mem.NormExpr(on).AsTrue()
			if _trueExpr != nil {
				if _f.matchedRule == nil || _f.matchedRule(opt.SimplifyLeftJoinWithoutFilters) {
					_group = _f.funcs.ConstructNonLeftJoin(opt.FullJoinApplyOp, left, right, on)
					_f.mem.AddAltFingerprint(_fullJoinApplyExpr.Fingerprint(), _group)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.SimplifyLeftJoinWithoutFilters, _group, 0, 0)
					}
					return _group
				}
			}
		}
	}

	// [SimplifyRightJoinWithoutFilters]
	{
		if !_f.funcs.CanHaveZeroRows(left) {
			_trueExpr := _f.mem.NormExpr(on).AsTrue()
			if _trueExpr != nil {
				if _f.matchedRule == nil || _f.matchedRule(opt.SimplifyRightJoinWithoutFilters) {
					_group = _f.funcs.ConstructNonRightJoin(opt.FullJoinApplyOp, left, right, on)
					_f.mem.AddAltFingerprint(_fullJoinApplyExpr.Fingerprint(), _group)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.SimplifyRightJoinWithoutFilters, _group, 0, 0)
					}
					return _group
				}
			}
		}
	}

	// [SimplifyLeftJoinWithFilters]
	{
		_filtersExpr := _f.mem.NormExpr(on).AsFilters()
		if _filtersExpr != nil {
			if _f.funcs.JoinFiltersMatchAllLeftRows(left, right, on) {
				if _f.matchedRule == nil || _f.matchedRule(opt.SimplifyLeftJoinWithFilters) {
					_group = _f.funcs.ConstructNonLeftJoin(opt.FullJoinApplyOp, left, right, on)
					_f.mem.AddAltFingerprint(_fullJoinApplyExpr.Fingerprint(), _group)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.SimplifyLeftJoinWithFilters, _group, 0, 0)
					}
					return _group
				}
			}
		}
	}

	// [SimplifyRightJoinWithFilters]
	{
		_filtersExpr := _f.mem.NormExpr(on).AsFilters()
		if _filtersExpr != nil {
			if _f.funcs.JoinFiltersMatchAllLeftRows(right, left, on) {
				if _f.matchedRule == nil || _f.matchedRule(opt.SimplifyRightJoinWithFilters) {
					_group = _f.funcs.ConstructNonRightJoin(opt.FullJoinApplyOp, left, right, on)
					_f.mem.AddAltFingerprint(_fullJoinApplyExpr.Fingerprint(), _group)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.SimplifyRightJoinWithFilters, _group, 0, 0)
					}
					return _group
				}
			}
		}
	}

	// [SimplifyJoinNotNullEquality]
	{
		_filtersExpr := _f.mem.NormExpr(on).AsFilters()
		if _filtersExpr != nil {
			list := _filtersExpr.Conditions()
			for _, _item := range _f.mem.LookupList(_filtersExpr.Conditions()) {
				condition := _item
				_expr := _f.mem.NormExpr(_item)
				if _expr.Operator() == opt.IsOp || _expr.Operator() == opt.IsNotOp {
					eq := _expr.ChildGroup(_f.Memo(), 0)
					_eqExpr := _f.mem.NormExpr(_expr.ChildGroup(_f.Memo(), 0)).AsEq()
					if _eqExpr != nil {
						_variableExpr := _f.mem.NormExpr(_eqExpr.Left()).AsVariable()
						if _variableExpr != nil {
							col1 := _variableExpr.Col()
							if _f.funcs.IsColNotNull2(col1, left, right) {
								_variableExpr2 := _f.mem.NormExpr(_eqExpr.Right()).AsVariable()
								if _variableExpr2 != nil {
									col2 := _variableExpr2.Col()
									if _f.funcs.IsColNotNull2(col2, left, right) {
										cnst := _expr.ChildGroup(_f.Memo(), 1)
										_expr2 := _f.mem.NormExpr(_expr.ChildGroup(_f.Memo(), 1))
										if _expr2.Operator() == opt.TrueOp || _expr2.Operator() == opt.FalseOp || _expr2.Operator() == opt.NullOp {
											if _f.matchedRule == nil || _f.matchedRule(opt.SimplifyJoinNotNullEquality) {
												_group = _f.ConstructFullJoinApply(
													left,
													right,
													_f.ConstructFilters(
														_f.funcs.ReplaceListItem(list, condition, _f.funcs.SimplifyNotNullEquality(eq, _f.mem.NormExpr(condition).Operator(), _f.mem.NormExpr(cnst).Operator())),
													),
												)
												_f.mem.AddAltFingerprint(_fullJoinApplyExpr.Fingerprint(), _group)
												if _f.appliedRule != nil {
													_f.appliedRule(opt.SimplifyJoinNotNullEquality, _group, 0, 0)
												}
												return _group
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}

	// [HoistJoinSubquery]
	{
		if _f.funcs.HasHoistableSubquery(on) {
			_filtersExpr := _f.mem.NormExpr(on).AsFilters()
			if _filtersExpr != nil {
				if _f.matchedRule == nil || _f.matchedRule(opt.HoistJoinSubquery) {
					_group = _f.funcs.HoistJoinSubquery(opt.FullJoinApplyOp, left, right, on)
					_f.mem.AddAltFingerprint(_fullJoinApplyExpr.Fingerprint(), _group)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.HoistJoinSubquery, _group, 0, 0)
					}
					return _group
				}
			}
		}
	}

	return _f.onConstruct(memo.Expr(_fullJoinApplyExpr))
}

// ConstructSemiJoinApply constructs an expression for the SemiJoinApply operator.
func (_f *Factory) ConstructSemiJoinApply(
	left memo.GroupID,
	right memo.GroupID,
	on memo.GroupID,
) memo.GroupID {
	_semiJoinApplyExpr := memo.MakeSemiJoinApplyExpr(left, right, on)
	_group := _f.mem.GroupByFingerprint(_semiJoinApplyExpr.Fingerprint())
	if _group != 0 {
		return _group
	}

	// [TryDecorrelateSelect]
	{
		if _f.funcs.HasOuterCols(right) {
			_selectExpr := _f.mem.NormExpr(right).AsSelect()
			if _selectExpr != nil {
				input := _selectExpr.Input()
				filter := _selectExpr.Filter()
				if !_f.ruleCycles.detectCycle(_semiJoinApplyExpr.Fingerprint()) {
					if _f.matchedRule == nil || _f.matchedRule(opt.TryDecorrelateSelect) {
						_f.ruleCycles.push(_semiJoinApplyExpr.Fingerprint())
						_group = _f.ConstructSemiJoinApply(
							left,
							input,
							_f.funcs.ConcatFilters(on, filter),
						)
						_f.ruleCycles.pop()
						if _f.mem.GroupByFingerprint(_semiJoinApplyExpr.Fingerprint()) == 0 {
							_f.mem.AddAltFingerprint(_semiJoinApplyExpr.Fingerprint(), _group)
						}
						if _f.appliedRule != nil {
							_f.appliedRule(opt.TryDecorrelateSelect, _group, 0, 0)
						}
						return _group
					}
				}
			}
		}
	}

	// [TryDecorrelateInnerJoin]
	{
		if _f.funcs.HasOuterCols(right) {
			_expr := _f.mem.NormExpr(right)
			if _expr.Operator() == opt.InnerJoinOp || _expr.Operator() == opt.InnerJoinApplyOp {
				innerLeft := _expr.ChildGroup(_f.Memo(), 0)
				innerRight := _expr.ChildGroup(_f.Memo(), 1)
				innerOn := _expr.ChildGroup(_f.Memo(), 2)
				if !_f.ruleCycles.detectCycle(_semiJoinApplyExpr.Fingerprint()) {
					if _f.matchedRule == nil || _f.matchedRule(opt.TryDecorrelateInnerJoin) {
						_f.ruleCycles.push(_semiJoinApplyExpr.Fingerprint())
						_group = _f.ConstructSemiJoinApply(
							left,
							_f.DynamicConstruct(
								_f.mem.NormOp(right),
								memo.DynamicOperands{
									memo.DynamicID(innerLeft),
									memo.DynamicID(innerRight),
									memo.DynamicID(_f.ConstructTrue()),
								},
							),
							_f.funcs.ConcatFilters(on, innerOn),
						)
						_f.ruleCycles.pop()
						if _f.mem.GroupByFingerprint(_semiJoinApplyExpr.Fingerprint()) == 0 {
							_f.mem.AddAltFingerprint(_semiJoinApplyExpr.Fingerprint(), _group)
						}
						if _f.appliedRule != nil {
							_f.appliedRule(opt.TryDecorrelateInnerJoin, _group, 0, 0)
						}
						return _group
					}
				}
			}
		}
	}

	// [DecorrelateJoin]
	{
		if !_f.funcs.IsCorrelated(right, left) {
			if _f.matchedRule == nil || _f.matchedRule(opt.DecorrelateJoin) {
				_group = _f.funcs.ConstructNonApplyJoin(opt.SemiJoinApplyOp, left, right, on)
				_f.mem.AddAltFingerprint(_semiJoinApplyExpr.Fingerprint(), _group)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.DecorrelateJoin, _group, 0, 0)
				}
				return _group
			}
		}
	}

	// [TryDecorrelateSemiJoin]
	{
		if _f.funcs.HasOuterCols(right) {
			if _f.funcs.CanHaveZeroRows(right) {
				_expr := _f.mem.NormExpr(right)
				if _expr.Operator() == opt.GroupByOp || _expr.Operator() == opt.DistinctOnOp || _expr.Operator() == opt.ProjectOp || _expr.Operator() == opt.ZipOp {
					if _f.matchedRule == nil || _f.matchedRule(opt.TryDecorrelateSemiJoin) {
						newLeft := _f.funcs.EnsureKey(left)
						_group = _f.ConstructGroupBy(
							_f.ConstructInnerJoinApply(
								newLeft,
								right,
								on,
							),
							_f.funcs.MakeAggCols(opt.ConstAggOp, _f.funcs.NonKeyCols(newLeft)),
							_f.funcs.MakeGroupByDef(_f.funcs.KeyCols(newLeft)),
						)
						_f.mem.AddAltFingerprint(_semiJoinApplyExpr.Fingerprint(), _group)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.TryDecorrelateSemiJoin, _group, 0, 0)
						}
						return _group
					}
				}
			}
		}
	}

	// [TryDecorrelateSemiJoinZip]
	{
		if _f.funcs.HasOuterCols(right) {
			_expr := _f.mem.NormExpr(right)
			if _expr.Operator() == opt.InnerJoinOp || _expr.Operator() == opt.InnerJoinApplyOp {
				_zipExpr := _f.mem.NormExpr(_expr.ChildGroup(_f.Memo(), 1)).AsZip()
				if _zipExpr != nil {
					if _f.matchedRule == nil || _f.matchedRule(opt.TryDecorrelateSemiJoinZip) {
						newLeft := _f.funcs.EnsureKey(left)
						_group = _f.ConstructGroupBy(
							_f.ConstructInnerJoinApply(
								newLeft,
								right,
								on,
							),
							_f.funcs.MakeAggCols(opt.ConstAggOp, _f.funcs.NonKeyCols(newLeft)),
							_f.funcs.MakeGroupByDef(_f.funcs.KeyCols(newLeft)),
						)
						_f.mem.AddAltFingerprint(_semiJoinApplyExpr.Fingerprint(), _group)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.TryDecorrelateSemiJoinZip, _group, 0, 0)
						}
						return _group
					}
				}
			}
		}
	}

	// [MapFilterIntoJoinLeft]
	{
		filters := on
		_filtersExpr := _f.mem.NormExpr(on).AsFilters()
		if _filtersExpr != nil {
			list := _filtersExpr.Conditions()
			for _, _item := range _f.mem.LookupList(_filtersExpr.Conditions()) {
				condition := _item
				_match := false
				_eqExpr := _f.mem.NormExpr(_item).AsEq()
				if _eqExpr != nil {
					_variableExpr := _f.mem.NormExpr(_eqExpr.Left()).AsVariable()
					if _variableExpr != nil {
						_variableExpr2 := _f.mem.NormExpr(_eqExpr.Right()).AsVariable()
						if _variableExpr2 != nil {
							_match = true
						}
					}
				}

				if !_match {
					if !_f.funcs.IsBoundBy(condition, _f.funcs.OutputCols(left)) {
						if _f.funcs.CanMap(filters, condition, left) {
							if _f.matchedRule == nil || _f.matchedRule(opt.MapFilterIntoJoinLeft) {
								_group = _f.ConstructSemiJoinApply(
									left,
									right,
									_f.ConstructFilters(
										_f.funcs.ReplaceListItem(list, condition, _f.funcs.Map(filters, condition, left)),
									),
								)
								_f.mem.AddAltFingerprint(_semiJoinApplyExpr.Fingerprint(), _group)
								if _f.appliedRule != nil {
									_f.appliedRule(opt.MapFilterIntoJoinLeft, _group, 0, 0)
								}
								return _group
							}
						}
					}
				}
			}
		}
	}

	// [MapFilterIntoJoinRight]
	{
		_zipExpr := _f.mem.NormExpr(right).AsZip()
		if _zipExpr == nil {
			filters := on
			_filtersExpr := _f.mem.NormExpr(on).AsFilters()
			if _filtersExpr != nil {
				list := _filtersExpr.Conditions()
				for _, _item := range _f.mem.LookupList(_filtersExpr.Conditions()) {
					condition := _item
					_match := false
					_eqExpr := _f.mem.NormExpr(_item).AsEq()
					if _eqExpr != nil {
						_variableExpr := _f.mem.NormExpr(_eqExpr.Left()).AsVariable()
						if _variableExpr != nil {
							_variableExpr2 := _f.mem.NormExpr(_eqExpr.Right()).AsVariable()
							if _variableExpr2 != nil {
								_match = true
							}
						}
					}

					if !_match {
						if !_f.funcs.IsBoundBy(condition, _f.funcs.OutputCols(right)) {
							if _f.funcs.CanMap(filters, condition, right) {
								if _f.matchedRule == nil || _f.matchedRule(opt.MapFilterIntoJoinRight) {
									_group = _f.ConstructSemiJoinApply(
										left,
										right,
										_f.ConstructFilters(
											_f.funcs.ReplaceListItem(list, condition, _f.funcs.Map(filters, condition, right)),
										),
									)
									_f.mem.AddAltFingerprint(_semiJoinApplyExpr.Fingerprint(), _group)
									if _f.appliedRule != nil {
										_f.appliedRule(opt.MapFilterIntoJoinRight, _group, 0, 0)
									}
									return _group
								}
							}
						}
					}
				}
			}
		}
	}

	// [PushFilterIntoJoinLeft]
	{
		_filtersExpr := _f.mem.NormExpr(on).AsFilters()
		if _filtersExpr != nil {
			list := _filtersExpr.Conditions()
			for _, _item := range _f.mem.LookupList(_filtersExpr.Conditions()) {
				condition := _item
				leftCols := _f.funcs.OutputCols(left)
				if _f.funcs.IsBoundBy(condition, leftCols) {
					if _f.matchedRule == nil || _f.matchedRule(opt.PushFilterIntoJoinLeft) {
						_group = _f.ConstructSemiJoinApply(
							_f.ConstructSelect(
								left,
								_f.ConstructFilters(
									_f.funcs.ExtractBoundConditions(list, leftCols),
								),
							),
							right,
							_f.ConstructFilters(
								_f.funcs.ExtractUnboundConditions(list, leftCols),
							),
						)
						_f.mem.AddAltFingerprint(_semiJoinApplyExpr.Fingerprint(), _group)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.PushFilterIntoJoinLeft, _group, 0, 0)
						}
						return _group
					}
				}
			}
		}
	}

	// [PushFilterIntoJoinRight]
	{
		_zipExpr := _f.mem.NormExpr(right).AsZip()
		if _zipExpr == nil {
			_filtersExpr := _f.mem.NormExpr(on).AsFilters()
			if _filtersExpr != nil {
				list := _filtersExpr.Conditions()
				for _, _item := range _f.mem.LookupList(_filtersExpr.Conditions()) {
					condition := _item
					rightCols := _f.funcs.OutputCols(right)
					if _f.funcs.IsBoundBy(condition, rightCols) {
						if _f.matchedRule == nil || _f.matchedRule(opt.PushFilterIntoJoinRight) {
							_group = _f.ConstructSemiJoinApply(
								left,
								_f.ConstructSelect(
									right,
									_f.ConstructFilters(
										_f.funcs.ExtractBoundConditions(list, rightCols),
									),
								),
								_f.ConstructFilters(
									_f.funcs.ExtractUnboundConditions(list, rightCols),
								),
							)
							_f.mem.AddAltFingerprint(_semiJoinApplyExpr.Fingerprint(), _group)
							if _f.appliedRule != nil {
								_f.appliedRule(opt.PushFilterIntoJoinRight, _group, 0, 0)
							}
							return _group
						}
					}
				}
			}
		}
	}

	// [EliminateSemiJoin]
	{
		if !_f.funcs.CanHaveZeroRows(right) {
			_trueExpr := _f.mem.NormExpr(on).AsTrue()
			if _trueExpr != nil {
				if _f.matchedRule == nil || _f.matchedRule(opt.EliminateSemiJoin) {
					_group = left
					_f.mem.AddAltFingerprint(_semiJoinApplyExpr.Fingerprint(), _group)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.EliminateSemiJoin, _group, 0, 0)
					}
					return _group
				}
			}
		}
	}

	// [SimplifyJoinNotNullEquality]
	{
		_filtersExpr := _f.mem.NormExpr(on).AsFilters()
		if _filtersExpr != nil {
			list := _filtersExpr.Conditions()
			for _, _item := range _f.mem.LookupList(_filtersExpr.Conditions()) {
				condition := _item
				_expr := _f.mem.NormExpr(_item)
				if _expr.Operator() == opt.IsOp || _expr.Operator() == opt.IsNotOp {
					eq := _expr.ChildGroup(_f.Memo(), 0)
					_eqExpr := _f.mem.NormExpr(_expr.ChildGroup(_f.Memo(), 0)).AsEq()
					if _eqExpr != nil {
						_variableExpr := _f.mem.NormExpr(_eqExpr.Left()).AsVariable()
						if _variableExpr != nil {
							col1 := _variableExpr.Col()
							if _f.funcs.IsColNotNull2(col1, left, right) {
								_variableExpr2 := _f.mem.NormExpr(_eqExpr.Right()).AsVariable()
								if _variableExpr2 != nil {
									col2 := _variableExpr2.Col()
									if _f.funcs.IsColNotNull2(col2, left, right) {
										cnst := _expr.ChildGroup(_f.Memo(), 1)
										_expr2 := _f.mem.NormExpr(_expr.ChildGroup(_f.Memo(), 1))
										if _expr2.Operator() == opt.TrueOp || _expr2.Operator() == opt.FalseOp || _expr2.Operator() == opt.NullOp {
											if _f.matchedRule == nil || _f.matchedRule(opt.SimplifyJoinNotNullEquality) {
												_group = _f.ConstructSemiJoinApply(
													left,
													right,
													_f.ConstructFilters(
														_f.funcs.ReplaceListItem(list, condition, _f.funcs.SimplifyNotNullEquality(eq, _f.mem.NormExpr(condition).Operator(), _f.mem.NormExpr(cnst).Operator())),
													),
												)
												_f.mem.AddAltFingerprint(_semiJoinApplyExpr.Fingerprint(), _group)
												if _f.appliedRule != nil {
													_f.appliedRule(opt.SimplifyJoinNotNullEquality, _group, 0, 0)
												}
												return _group
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}

	// [HoistJoinSubquery]
	{
		if _f.funcs.HasHoistableSubquery(on) {
			_filtersExpr := _f.mem.NormExpr(on).AsFilters()
			if _filtersExpr != nil {
				if _f.matchedRule == nil || _f.matchedRule(opt.HoistJoinSubquery) {
					_group = _f.funcs.HoistJoinSubquery(opt.SemiJoinApplyOp, left, right, on)
					_f.mem.AddAltFingerprint(_semiJoinApplyExpr.Fingerprint(), _group)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.HoistJoinSubquery, _group, 0, 0)
					}
					return _group
				}
			}
		}
	}

	return _f.onConstruct(memo.Expr(_semiJoinApplyExpr))
}

// ConstructAntiJoinApply constructs an expression for the AntiJoinApply operator.
func (_f *Factory) ConstructAntiJoinApply(
	left memo.GroupID,
	right memo.GroupID,
	on memo.GroupID,
) memo.GroupID {
	_antiJoinApplyExpr := memo.MakeAntiJoinApplyExpr(left, right, on)
	_group := _f.mem.GroupByFingerprint(_antiJoinApplyExpr.Fingerprint())
	if _group != 0 {
		return _group
	}

	// [TryDecorrelateSelect]
	{
		if _f.funcs.HasOuterCols(right) {
			_selectExpr := _f.mem.NormExpr(right).AsSelect()
			if _selectExpr != nil {
				input := _selectExpr.Input()
				filter := _selectExpr.Filter()
				if !_f.ruleCycles.detectCycle(_antiJoinApplyExpr.Fingerprint()) {
					if _f.matchedRule == nil || _f.matchedRule(opt.TryDecorrelateSelect) {
						_f.ruleCycles.push(_antiJoinApplyExpr.Fingerprint())
						_group = _f.ConstructAntiJoinApply(
							left,
							input,
							_f.funcs.ConcatFilters(on, filter),
						)
						_f.ruleCycles.pop()
						if _f.mem.GroupByFingerprint(_antiJoinApplyExpr.Fingerprint()) == 0 {
							_f.mem.AddAltFingerprint(_antiJoinApplyExpr.Fingerprint(), _group)
						}
						if _f.appliedRule != nil {
							_f.appliedRule(opt.TryDecorrelateSelect, _group, 0, 0)
						}
						return _group
					}
				}
			}
		}
	}

	// [TryDecorrelateInnerJoin]
	{
		if _f.funcs.HasOuterCols(right) {
			_expr := _f.mem.NormExpr(right)
			if _expr.Operator() == opt.InnerJoinOp || _expr.Operator() == opt.InnerJoinApplyOp {
				innerLeft := _expr.ChildGroup(_f.Memo(), 0)
				innerRight := _expr.ChildGroup(_f.Memo(), 1)
				innerOn := _expr.ChildGroup(_f.Memo(), 2)
				if !_f.ruleCycles.detectCycle(_antiJoinApplyExpr.Fingerprint()) {
					if _f.matchedRule == nil || _f.matchedRule(opt.TryDecorrelateInnerJoin) {
						_f.ruleCycles.push(_antiJoinApplyExpr.Fingerprint())
						_group = _f.ConstructAntiJoinApply(
							left,
							_f.DynamicConstruct(
								_f.mem.NormOp(right),
								memo.DynamicOperands{
									memo.DynamicID(innerLeft),
									memo.DynamicID(innerRight),
									memo.DynamicID(_f.ConstructTrue()),
								},
							),
							_f.funcs.ConcatFilters(on, innerOn),
						)
						_f.ruleCycles.pop()
						if _f.mem.GroupByFingerprint(_antiJoinApplyExpr.Fingerprint()) == 0 {
							_f.mem.AddAltFingerprint(_antiJoinApplyExpr.Fingerprint(), _group)
						}
						if _f.appliedRule != nil {
							_f.appliedRule(opt.TryDecorrelateInnerJoin, _group, 0, 0)
						}
						return _group
					}
				}
			}
		}
	}

	// [DecorrelateJoin]
	{
		if !_f.funcs.IsCorrelated(right, left) {
			if _f.matchedRule == nil || _f.matchedRule(opt.DecorrelateJoin) {
				_group = _f.funcs.ConstructNonApplyJoin(opt.AntiJoinApplyOp, left, right, on)
				_f.mem.AddAltFingerprint(_antiJoinApplyExpr.Fingerprint(), _group)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.DecorrelateJoin, _group, 0, 0)
				}
				return _group
			}
		}
	}

	// [MapFilterIntoJoinRight]
	{
		_zipExpr := _f.mem.NormExpr(right).AsZip()
		if _zipExpr == nil {
			filters := on
			_filtersExpr := _f.mem.NormExpr(on).AsFilters()
			if _filtersExpr != nil {
				list := _filtersExpr.Conditions()
				for _, _item := range _f.mem.LookupList(_filtersExpr.Conditions()) {
					condition := _item
					_match := false
					_eqExpr := _f.mem.NormExpr(_item).AsEq()
					if _eqExpr != nil {
						_variableExpr := _f.mem.NormExpr(_eqExpr.Left()).AsVariable()
						if _variableExpr != nil {
							_variableExpr2 := _f.mem.NormExpr(_eqExpr.Right()).AsVariable()
							if _variableExpr2 != nil {
								_match = true
							}
						}
					}

					if !_match {
						if !_f.funcs.IsBoundBy(condition, _f.funcs.OutputCols(right)) {
							if _f.funcs.CanMap(filters, condition, right) {
								if _f.matchedRule == nil || _f.matchedRule(opt.MapFilterIntoJoinRight) {
									_group = _f.ConstructAntiJoinApply(
										left,
										right,
										_f.ConstructFilters(
											_f.funcs.ReplaceListItem(list, condition, _f.funcs.Map(filters, condition, right)),
										),
									)
									_f.mem.AddAltFingerprint(_antiJoinApplyExpr.Fingerprint(), _group)
									if _f.appliedRule != nil {
										_f.appliedRule(opt.MapFilterIntoJoinRight, _group, 0, 0)
									}
									return _group
								}
							}
						}
					}
				}
			}
		}
	}

	// [PushFilterIntoJoinRight]
	{
		_zipExpr := _f.mem.NormExpr(right).AsZip()
		if _zipExpr == nil {
			_filtersExpr := _f.mem.NormExpr(on).AsFilters()
			if _filtersExpr != nil {
				list := _filtersExpr.Conditions()
				for _, _item := range _f.mem.LookupList(_filtersExpr.Conditions()) {
					condition := _item
					rightCols := _f.funcs.OutputCols(right)
					if _f.funcs.IsBoundBy(condition, rightCols) {
						if _f.matchedRule == nil || _f.matchedRule(opt.PushFilterIntoJoinRight) {
							_group = _f.ConstructAntiJoinApply(
								left,
								_f.ConstructSelect(
									right,
									_f.ConstructFilters(
										_f.funcs.ExtractBoundConditions(list, rightCols),
									),
								),
								_f.ConstructFilters(
									_f.funcs.ExtractUnboundConditions(list, rightCols),
								),
							)
							_f.mem.AddAltFingerprint(_antiJoinApplyExpr.Fingerprint(), _group)
							if _f.appliedRule != nil {
								_f.appliedRule(opt.PushFilterIntoJoinRight, _group, 0, 0)
							}
							return _group
						}
					}
				}
			}
		}
	}

	// [EliminateAntiJoin]
	{
		if _f.funcs.HasZeroRows(right) {
			if _f.matchedRule == nil || _f.matchedRule(opt.EliminateAntiJoin) {
				_group = left
				_f.mem.AddAltFingerprint(_antiJoinApplyExpr.Fingerprint(), _group)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.EliminateAntiJoin, _group, 0, 0)
				}
				return _group
			}
		}
	}

	// [SimplifyJoinNotNullEquality]
	{
		_filtersExpr := _f.mem.NormExpr(on).AsFilters()
		if _filtersExpr != nil {
			list := _filtersExpr.Conditions()
			for _, _item := range _f.mem.LookupList(_filtersExpr.Conditions()) {
				condition := _item
				_expr := _f.mem.NormExpr(_item)
				if _expr.Operator() == opt.IsOp || _expr.Operator() == opt.IsNotOp {
					eq := _expr.ChildGroup(_f.Memo(), 0)
					_eqExpr := _f.mem.NormExpr(_expr.ChildGroup(_f.Memo(), 0)).AsEq()
					if _eqExpr != nil {
						_variableExpr := _f.mem.NormExpr(_eqExpr.Left()).AsVariable()
						if _variableExpr != nil {
							col1 := _variableExpr.Col()
							if _f.funcs.IsColNotNull2(col1, left, right) {
								_variableExpr2 := _f.mem.NormExpr(_eqExpr.Right()).AsVariable()
								if _variableExpr2 != nil {
									col2 := _variableExpr2.Col()
									if _f.funcs.IsColNotNull2(col2, left, right) {
										cnst := _expr.ChildGroup(_f.Memo(), 1)
										_expr2 := _f.mem.NormExpr(_expr.ChildGroup(_f.Memo(), 1))
										if _expr2.Operator() == opt.TrueOp || _expr2.Operator() == opt.FalseOp || _expr2.Operator() == opt.NullOp {
											if _f.matchedRule == nil || _f.matchedRule(opt.SimplifyJoinNotNullEquality) {
												_group = _f.ConstructAntiJoinApply(
													left,
													right,
													_f.ConstructFilters(
														_f.funcs.ReplaceListItem(list, condition, _f.funcs.SimplifyNotNullEquality(eq, _f.mem.NormExpr(condition).Operator(), _f.mem.NormExpr(cnst).Operator())),
													),
												)
												_f.mem.AddAltFingerprint(_antiJoinApplyExpr.Fingerprint(), _group)
												if _f.appliedRule != nil {
													_f.appliedRule(opt.SimplifyJoinNotNullEquality, _group, 0, 0)
												}
												return _group
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}

	// [HoistJoinSubquery]
	{
		if _f.funcs.HasHoistableSubquery(on) {
			_filtersExpr := _f.mem.NormExpr(on).AsFilters()
			if _filtersExpr != nil {
				if _f.matchedRule == nil || _f.matchedRule(opt.HoistJoinSubquery) {
					_group = _f.funcs.HoistJoinSubquery(opt.AntiJoinApplyOp, left, right, on)
					_f.mem.AddAltFingerprint(_antiJoinApplyExpr.Fingerprint(), _group)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.HoistJoinSubquery, _group, 0, 0)
					}
					return _group
				}
			}
		}
	}

	return _f.onConstruct(memo.Expr(_antiJoinApplyExpr))
}

// ConstructGroupBy constructs an expression for the GroupBy operator.
// GroupBy computes aggregate functions over groups of input rows. Input rows
// that are equal on the grouping columns are grouped together. The set of
// computed aggregate functions is described by the Aggregations field (which is
// always an Aggregations operator).
//
// The arguments of the aggregate functions are columns from the input
// (i.e. Variables), possibly wrapped in aggregate modifiers like AggDistinct.
//
// If the set of input rows is empty, then the output of the GroupBy operator
// will also be empty. If the grouping columns are empty, then all input rows
// form a single group. GroupBy is used for queries with aggregate functions,
// HAVING clauses and/or GROUP BY expressions.
//
// The Def private contains an ordering; this ordering is used to determine
// intra-group ordering and is only useful if there is an order-dependent
// aggregation (like ARRAY_AGG). Grouping columns are inconsequential in this
// ordering; we currently set all grouping columns as optional in this ordering
// (but note that this is not required by the operator).
func (_f *Factory) ConstructGroupBy(
	input memo.GroupID,
	aggregations memo.GroupID,
	def memo.PrivateID,
) memo.GroupID {
	_groupByExpr := memo.MakeGroupByExpr(input, aggregations, def)
	_group := _f.mem.GroupByFingerprint(_groupByExpr.Fingerprint())
	if _group != 0 {
		return _group
	}

	// [ConvertGroupByToDistinct]
	{
		if _f.funcs.HasNoCols(aggregations) {
			if _f.matchedRule == nil || _f.matchedRule(opt.ConvertGroupByToDistinct) {
				_group = _f.ConstructDistinctOn(
					input,
					aggregations,
					def,
				)
				_f.mem.AddAltFingerprint(_groupByExpr.Fingerprint(), _group)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.ConvertGroupByToDistinct, _group, 0, 0)
				}
				return _group
			}
		}
	}

	// [EliminateGroupByProject]
	{
		_projectExpr := _f.mem.NormExpr(input).AsProject()
		if _projectExpr != nil {
			innerInput := _projectExpr.Input()
			if _f.funcs.HasSubsetCols(input, innerInput) {
				if _f.matchedRule == nil || _f.matchedRule(opt.EliminateGroupByProject) {
					_group = _f.ConstructGroupBy(
						innerInput,
						aggregations,
						def,
					)
					_f.mem.AddAltFingerprint(_groupByExpr.Fingerprint(), _group)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.EliminateGroupByProject, _group, 0, 0)
					}
					return _group
				}
			}
		}
	}

	// [ReduceGroupingCols]
	{
		if _f.funcs.CanReduceGroupingCols(input, def) {
			if _f.matchedRule == nil || _f.matchedRule(opt.ReduceGroupingCols) {
				_group = _f.ConstructGroupBy(
					input,
					_f.funcs.AppendReducedGroupingCols(input, aggregations, def),
					_f.funcs.ReduceGroupingCols(input, def),
				)
				_f.mem.AddAltFingerprint(_groupByExpr.Fingerprint(), _group)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.ReduceGroupingCols, _group, 0, 0)
				}
				return _group
			}
		}
	}

	// [EliminateAggDistinctForKeys]
	{
		if _f.funcs.CanRemoveAggDistinctForKeys(aggregations, def, input) {
			if _f.matchedRule == nil || _f.matchedRule(opt.EliminateAggDistinctForKeys) {
				_group = _f.ConstructGroupBy(
					input,
					_f.funcs.RemoveAggDistinctForKeys(aggregations, def, input),
					def,
				)
				_f.mem.AddAltFingerprint(_groupByExpr.Fingerprint(), _group)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.EliminateAggDistinctForKeys, _group, 0, 0)
				}
				return _group
			}
		}
	}

	// [SimplifyGroupByOrdering]
	{
		if _f.funcs.CanSimplifyGroupByOrdering(input, def) {
			if _f.matchedRule == nil || _f.matchedRule(opt.SimplifyGroupByOrdering) {
				_group = _f.ConstructGroupBy(
					input,
					aggregations,
					_f.funcs.SimplifyGroupByOrdering(input, def),
				)
				_f.mem.AddAltFingerprint(_groupByExpr.Fingerprint(), _group)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.SimplifyGroupByOrdering, _group, 0, 0)
				}
				return _group
			}
		}
	}

	// [PruneGroupByCols]
	{
		if _f.funcs.CanPruneCols(input, _f.funcs.NeededColsGroupBy(aggregations, def)) {
			if _f.matchedRule == nil || _f.matchedRule(opt.PruneGroupByCols) {
				newInput := _f.funcs.PruneCols(input, _f.funcs.NeededColsGroupBy(aggregations, def))
				_group = _f.ConstructGroupBy(
					newInput,
					aggregations,
					_f.funcs.PruneOrderingGroupBy(newInput, def),
				)
				_f.mem.AddAltFingerprint(_groupByExpr.Fingerprint(), _group)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.PruneGroupByCols, _group, 0, 0)
				}
				return _group
			}
		}
	}

	return _f.onConstruct(memo.Expr(_groupByExpr))
}

// ConstructScalarGroupBy constructs an expression for the ScalarGroupBy operator.
// ScalarGroupBy computes aggregate functions over the complete set of input
// rows. This is similar to GroupBy with empty grouping columns, where all input
// rows form a single group. However, there is an important difference. If the
// input set is empty, then the output of the ScalarGroupBy operator will have a
// single row containing default values for each aggregate function (typically
// null or zero, depending on the function). ScalarGroupBy always returns exactly
// one row - either the single-group aggregates or the default aggregate values.
//
// ScalarGroupBy uses the same GroupByDef private so that it's polymorphic with
// GroupBy and can be used in the same rules (when appropriate). In the
// ScalarGroupBy case, the grouping column field in GroupByDef is always empty.
func (_f *Factory) ConstructScalarGroupBy(
	input memo.GroupID,
	aggregations memo.GroupID,
	def memo.PrivateID,
) memo.GroupID {
	_scalarGroupByExpr := memo.MakeScalarGroupByExpr(input, aggregations, def)
	_group := _f.mem.GroupByFingerprint(_scalarGroupByExpr.Fingerprint())
	if _group != 0 {
		return _group
	}

	// [EliminateGroupByProject]
	{
		_projectExpr := _f.mem.NormExpr(input).AsProject()
		if _projectExpr != nil {
			innerInput := _projectExpr.Input()
			if _f.funcs.HasSubsetCols(input, innerInput) {
				if _f.matchedRule == nil || _f.matchedRule(opt.EliminateGroupByProject) {
					_group = _f.ConstructScalarGroupBy(
						innerInput,
						aggregations,
						def,
					)
					_f.mem.AddAltFingerprint(_scalarGroupByExpr.Fingerprint(), _group)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.EliminateGroupByProject, _group, 0, 0)
					}
					return _group
				}
			}
		}
	}

	// [EliminateAggDistinctForKeys]
	{
		if _f.funcs.CanRemoveAggDistinctForKeys(aggregations, def, input) {
			if _f.matchedRule == nil || _f.matchedRule(opt.EliminateAggDistinctForKeys) {
				_group = _f.ConstructScalarGroupBy(
					input,
					_f.funcs.RemoveAggDistinctForKeys(aggregations, def, input),
					def,
				)
				_f.mem.AddAltFingerprint(_scalarGroupByExpr.Fingerprint(), _group)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.EliminateAggDistinctForKeys, _group, 0, 0)
				}
				return _group
			}
		}
	}

	// [SimplifyGroupByOrdering]
	{
		if _f.funcs.CanSimplifyGroupByOrdering(input, def) {
			if _f.matchedRule == nil || _f.matchedRule(opt.SimplifyGroupByOrdering) {
				_group = _f.ConstructScalarGroupBy(
					input,
					aggregations,
					_f.funcs.SimplifyGroupByOrdering(input, def),
				)
				_f.mem.AddAltFingerprint(_scalarGroupByExpr.Fingerprint(), _group)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.SimplifyGroupByOrdering, _group, 0, 0)
				}
				return _group
			}
		}
	}

	return _f.onConstruct(memo.Expr(_scalarGroupByExpr))
}

// ConstructDistinctOn constructs an expression for the DistinctOn operator.
// DistinctOn filters out rows that are identical on the set of grouping columns;
// only the first row (according to an ordering) is kept for each set of possible
// values. It is roughly equivalent with a GroupBy on the same grouping columns
// except that it uses FirstAgg functions that ensure the value on the first row
// is chosen (across all aggregations).
//
// In addition, the value on that first row must be chosen for all the grouping
// columns as well; this is relevant in the case of equal but non-identical
// values, like decimals. For example, if we have rows (1, 2.0) and (1.0, 2) and
// we are grouping on these two columns, the values output can be either (1, 2.0)
// or (1.0, 2), but not (1.0, 2.0).
//
// The execution of DistinctOn resembles that of Select more than that of
// GroupBy: each row is tested against a map of what groups we have seen already,
// and is either passed through or discarded. In particular, note that this
// preserves the input ordering.
//
// The ordering in the private will be required of the input; it determines which
// row can get "chosen" for each group of values on the grouping columns.
// There is no restriction on the ordering; but note that grouping columns are
// inconsequential - they can appear anywhere in the ordering and they won't
// change the results (other than the result ordering).
//
// Currently when we build DistinctOn, we set all grouping columns as optional
// cols in Ordering (but this is not required by the operator).
//
// TODO(radu): in the future we may want an exploration transform to try out more
// specific interesting orderings because execution is more efficient when we can
// rely on an ordering on the grouping columns (or a subset of them).
//
// DistinctOn uses an Aggregations child and the GroupByDef private so that it's
// polymorphic with GroupBy and can be used in the same rules (when appropriate).
// In the DistinctOn case, the aggregations can be only FirstAgg or ConstAgg.
func (_f *Factory) ConstructDistinctOn(
	input memo.GroupID,
	aggregations memo.GroupID,
	def memo.PrivateID,
) memo.GroupID {
	_distinctOnExpr := memo.MakeDistinctOnExpr(input, aggregations, def)
	_group := _f.mem.GroupByFingerprint(_distinctOnExpr.Fingerprint())
	if _group != 0 {
		return _group
	}

	// [EliminateDistinct]
	{
		if _f.funcs.GroupingColsAreKey(def, input) {
			if _f.matchedRule == nil || _f.matchedRule(opt.EliminateDistinct) {
				_group = input
				_f.mem.AddAltFingerprint(_distinctOnExpr.Fingerprint(), _group)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.EliminateDistinct, _group, 0, 0)
				}
				return _group
			}
		}
	}

	// [EliminateGroupByProject]
	{
		_projectExpr := _f.mem.NormExpr(input).AsProject()
		if _projectExpr != nil {
			innerInput := _projectExpr.Input()
			if _f.funcs.HasSubsetCols(input, innerInput) {
				if _f.matchedRule == nil || _f.matchedRule(opt.EliminateGroupByProject) {
					_group = _f.ConstructDistinctOn(
						innerInput,
						aggregations,
						def,
					)
					_f.mem.AddAltFingerprint(_distinctOnExpr.Fingerprint(), _group)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.EliminateGroupByProject, _group, 0, 0)
					}
					return _group
				}
			}
		}
	}

	// [ReduceGroupingCols]
	{
		if _f.funcs.CanReduceGroupingCols(input, def) {
			if _f.matchedRule == nil || _f.matchedRule(opt.ReduceGroupingCols) {
				_group = _f.ConstructDistinctOn(
					input,
					_f.funcs.AppendReducedGroupingCols(input, aggregations, def),
					_f.funcs.ReduceGroupingCols(input, def),
				)
				_f.mem.AddAltFingerprint(_distinctOnExpr.Fingerprint(), _group)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.ReduceGroupingCols, _group, 0, 0)
				}
				return _group
			}
		}
	}

	// [EliminateDistinctOnNoColumns]
	{
		groupingPrivate := def
		if _f.funcs.HasNoGroupingCols(groupingPrivate) {
			if _f.matchedRule == nil || _f.matchedRule(opt.EliminateDistinctOnNoColumns) {
				_group = _f.funcs.ConstructProjectionFromDistinctOn(_f.ConstructLimit(
					input,
					_f.ConstructConst(
						_f.mem.InternDatum(tree.NewDInt(1)),
					),
					_f.funcs.GroupingInputOrdering(groupingPrivate),
				), aggregations)
				_f.mem.AddAltFingerprint(_distinctOnExpr.Fingerprint(), _group)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.EliminateDistinctOnNoColumns, _group, 0, 0)
				}
				return _group
			}
		}
	}

	// [SimplifyGroupByOrdering]
	{
		if _f.funcs.CanSimplifyGroupByOrdering(input, def) {
			if _f.matchedRule == nil || _f.matchedRule(opt.SimplifyGroupByOrdering) {
				_group = _f.ConstructDistinctOn(
					input,
					aggregations,
					_f.funcs.SimplifyGroupByOrdering(input, def),
				)
				_f.mem.AddAltFingerprint(_distinctOnExpr.Fingerprint(), _group)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.SimplifyGroupByOrdering, _group, 0, 0)
				}
				return _group
			}
		}
	}

	// [PruneGroupByCols]
	{
		if _f.funcs.CanPruneCols(input, _f.funcs.NeededColsGroupBy(aggregations, def)) {
			if _f.matchedRule == nil || _f.matchedRule(opt.PruneGroupByCols) {
				newInput := _f.funcs.PruneCols(input, _f.funcs.NeededColsGroupBy(aggregations, def))
				_group = _f.ConstructDistinctOn(
					newInput,
					aggregations,
					_f.funcs.PruneOrderingGroupBy(newInput, def),
				)
				_f.mem.AddAltFingerprint(_distinctOnExpr.Fingerprint(), _group)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.PruneGroupByCols, _group, 0, 0)
				}
				return _group
			}
		}
	}

	return _f.onConstruct(memo.Expr(_distinctOnExpr))
}

// ConstructUnion constructs an expression for the Union operator.
// Union is an operator used to combine the Left and Right input relations into
// a single set containing rows from both inputs. Duplicate rows are discarded.
// The private field, ColMap, matches columns from the Left and Right inputs
// of the Union with the output columns. See the comment above opt.SetOpColMap
// for more details.
func (_f *Factory) ConstructUnion(
	left memo.GroupID,
	right memo.GroupID,
	colMap memo.PrivateID,
) memo.GroupID {
	_unionExpr := memo.MakeUnionExpr(left, right, colMap)
	_group := _f.mem.GroupByFingerprint(_unionExpr.Fingerprint())
	if _group != 0 {
		return _group
	}

	return _f.onConstruct(memo.Expr(_unionExpr))
}

// ConstructIntersect constructs an expression for the Intersect operator.
// Intersect is an operator used to perform an intersection between the Left
// and Right input relations. The result consists only of rows in the Left
// relation that are also present in the Right relation. Duplicate rows are
// discarded.
// The private field, ColMap, matches columns from the Left and Right inputs
// of the Intersect with the output columns. See the comment above
// opt.SetOpColMap for more details.
func (_f *Factory) ConstructIntersect(
	left memo.GroupID,
	right memo.GroupID,
	colMap memo.PrivateID,
) memo.GroupID {
	_intersectExpr := memo.MakeIntersectExpr(left, right, colMap)
	_group := _f.mem.GroupByFingerprint(_intersectExpr.Fingerprint())
	if _group != 0 {
		return _group
	}

	return _f.onConstruct(memo.Expr(_intersectExpr))
}

// ConstructExcept constructs an expression for the Except operator.
// Except is an operator used to perform a set difference between the Left and
// Right input relations. The result consists only of rows in the Left relation
// that are not present in the Right relation. Duplicate rows are discarded.
// The private field, ColMap, matches columns from the Left and Right inputs
// of the Except with the output columns. See the comment above opt.SetOpColMap
// for more details.
func (_f *Factory) ConstructExcept(
	left memo.GroupID,
	right memo.GroupID,
	colMap memo.PrivateID,
) memo.GroupID {
	_exceptExpr := memo.MakeExceptExpr(left, right, colMap)
	_group := _f.mem.GroupByFingerprint(_exceptExpr.Fingerprint())
	if _group != 0 {
		return _group
	}

	return _f.onConstruct(memo.Expr(_exceptExpr))
}

// ConstructUnionAll constructs an expression for the UnionAll operator.
// UnionAll is an operator used to combine the Left and Right input relations
// into a single set containing rows from both inputs. Duplicate rows are
// not discarded. For example:
//   SELECT x FROM xx UNION ALL SELECT y FROM yy
//     x       y         out
//   -----   -----      -----
//     1       1          1
//     1       2    ->    1
//     2       3          1
//                        2
//                        2
//                        3
//
// The private field, ColMap, matches columns from the Left and Right inputs
// of the UnionAll with the output columns. See the comment above
// opt.SetOpColMap for more details.
func (_f *Factory) ConstructUnionAll(
	left memo.GroupID,
	right memo.GroupID,
	colMap memo.PrivateID,
) memo.GroupID {
	_unionAllExpr := memo.MakeUnionAllExpr(left, right, colMap)
	_group := _f.mem.GroupByFingerprint(_unionAllExpr.Fingerprint())
	if _group != 0 {
		return _group
	}

	// [EliminateUnionAllLeft]
	{
		if _f.funcs.HasZeroRows(right) {
			colmap := colMap
			if _f.matchedRule == nil || _f.matchedRule(opt.EliminateUnionAllLeft) {
				_group = _f.ConstructProject(
					left,
					_f.funcs.ProjectColMapLeft(colmap),
				)
				_f.mem.AddAltFingerprint(_unionAllExpr.Fingerprint(), _group)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.EliminateUnionAllLeft, _group, 0, 0)
				}
				return _group
			}
		}
	}

	// [EliminateUnionAllRight]
	{
		if _f.funcs.HasZeroRows(left) {
			colmap := colMap
			if _f.matchedRule == nil || _f.matchedRule(opt.EliminateUnionAllRight) {
				_group = _f.ConstructProject(
					right,
					_f.funcs.ProjectColMapRight(colmap),
				)
				_f.mem.AddAltFingerprint(_unionAllExpr.Fingerprint(), _group)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.EliminateUnionAllRight, _group, 0, 0)
				}
				return _group
			}
		}
	}

	return _f.onConstruct(memo.Expr(_unionAllExpr))
}

// ConstructIntersectAll constructs an expression for the IntersectAll operator.
// IntersectAll is an operator used to perform an intersection between the Left
// and Right input relations. The result consists only of rows in the Left
// relation that have a corresponding row in the Right relation. Duplicate rows
// are not discarded. This effectively creates a one-to-one mapping between the
// Left and Right rows. For example:
//   SELECT x FROM xx INTERSECT ALL SELECT y FROM yy
//     x       y         out
//   -----   -----      -----
//     1       1          1
//     1       1    ->    1
//     1       2          2
//     2       2          2
//     2       3
//     4
//
// The private field, ColMap, matches columns from the Left and Right inputs
// of the IntersectAll with the output columns. See the comment above
// opt.SetOpColMap for more details.
func (_f *Factory) ConstructIntersectAll(
	left memo.GroupID,
	right memo.GroupID,
	colMap memo.PrivateID,
) memo.GroupID {
	_intersectAllExpr := memo.MakeIntersectAllExpr(left, right, colMap)
	_group := _f.mem.GroupByFingerprint(_intersectAllExpr.Fingerprint())
	if _group != 0 {
		return _group
	}

	return _f.onConstruct(memo.Expr(_intersectAllExpr))
}

// ConstructExceptAll constructs an expression for the ExceptAll operator.
// ExceptAll is an operator used to perform a set difference between the Left
// and Right input relations. The result consists only of rows in the Left
// relation that do not have a corresponding row in the Right relation.
// Duplicate rows are not discarded. This effectively creates a one-to-one
// mapping between the Left and Right rows. For example:
//   SELECT x FROM xx EXCEPT ALL SELECT y FROM yy
//     x       y         out
//   -----   -----      -----
//     1       1    ->    1
//     1       1          4
//     1       2
//     2       2
//     2       3
//     4
//
// The private field, ColMap, matches columns from the Left and Right inputs
// of the ExceptAll with the output columns. See the comment above
// opt.SetOpColMap for more details.
func (_f *Factory) ConstructExceptAll(
	left memo.GroupID,
	right memo.GroupID,
	colMap memo.PrivateID,
) memo.GroupID {
	_exceptAllExpr := memo.MakeExceptAllExpr(left, right, colMap)
	_group := _f.mem.GroupByFingerprint(_exceptAllExpr.Fingerprint())
	if _group != 0 {
		return _group
	}

	return _f.onConstruct(memo.Expr(_exceptAllExpr))
}

// ConstructLimit constructs an expression for the Limit operator.
// Limit returns a limited subset of the results in the input relation.
// The limit expression is a scalar value; the operator returns at most this many
// rows. The private field is a props.OrderingChoice which indicates the row
// ordering required from the input (the first rows with respect to this ordering
// are returned).
func (_f *Factory) ConstructLimit(
	input memo.GroupID,
	limit memo.GroupID,
	ordering memo.PrivateID,
) memo.GroupID {
	_limitExpr := memo.MakeLimitExpr(input, limit, ordering)
	_group := _f.mem.GroupByFingerprint(_limitExpr.Fingerprint())
	if _group != 0 {
		return _group
	}

	// [EliminateLimit]
	{
		_constExpr := _f.mem.NormExpr(limit).AsConst()
		if _constExpr != nil {
			limit := _constExpr.Value()
			if _f.funcs.LimitGeMaxRows(limit, input) {
				if _f.matchedRule == nil || _f.matchedRule(opt.EliminateLimit) {
					_group = input
					_f.mem.AddAltFingerprint(_limitExpr.Fingerprint(), _group)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.EliminateLimit, _group, 0, 0)
					}
					return _group
				}
			}
		}
	}

	// [PushLimitIntoProject]
	{
		_projectExpr := _f.mem.NormExpr(input).AsProject()
		if _projectExpr != nil {
			input := _projectExpr.Input()
			projections := _projectExpr.Projections()
			if _f.funcs.HasColsInOrdering(input, ordering) {
				if _f.matchedRule == nil || _f.matchedRule(opt.PushLimitIntoProject) {
					_group = _f.ConstructProject(
						_f.ConstructLimit(
							input,
							limit,
							_f.funcs.PruneOrdering(input, ordering),
						),
						projections,
					)
					_f.mem.AddAltFingerprint(_limitExpr.Fingerprint(), _group)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.PushLimitIntoProject, _group, 0, 0)
					}
					return _group
				}
			}
		}
	}

	// [SimplifyLimitOrdering]
	{
		if _f.funcs.CanSimplifyLimitOffsetOrdering(input, ordering) {
			if _f.matchedRule == nil || _f.matchedRule(opt.SimplifyLimitOrdering) {
				_group = _f.ConstructLimit(
					input,
					limit,
					_f.funcs.SimplifyLimitOffsetOrdering(input, ordering),
				)
				_f.mem.AddAltFingerprint(_limitExpr.Fingerprint(), _group)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.SimplifyLimitOrdering, _group, 0, 0)
				}
				return _group
			}
		}
	}

	return _f.onConstruct(memo.Expr(_limitExpr))
}

// ConstructOffset constructs an expression for the Offset operator.
// Offset filters out the first Offset rows of the input relation; used in
// conjunction with Limit.
func (_f *Factory) ConstructOffset(
	input memo.GroupID,
	offset memo.GroupID,
	ordering memo.PrivateID,
) memo.GroupID {
	_offsetExpr := memo.MakeOffsetExpr(input, offset, ordering)
	_group := _f.mem.GroupByFingerprint(_offsetExpr.Fingerprint())
	if _group != 0 {
		return _group
	}

	// [PushOffsetIntoProject]
	{
		_projectExpr := _f.mem.NormExpr(input).AsProject()
		if _projectExpr != nil {
			input := _projectExpr.Input()
			projections := _projectExpr.Projections()
			if _f.funcs.HasColsInOrdering(input, ordering) {
				if _f.matchedRule == nil || _f.matchedRule(opt.PushOffsetIntoProject) {
					_group = _f.ConstructProject(
						_f.ConstructOffset(
							input,
							offset,
							_f.funcs.PruneOrdering(input, ordering),
						),
						projections,
					)
					_f.mem.AddAltFingerprint(_offsetExpr.Fingerprint(), _group)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.PushOffsetIntoProject, _group, 0, 0)
					}
					return _group
				}
			}
		}
	}

	// [SimplifyOffsetOrdering]
	{
		if _f.funcs.CanSimplifyLimitOffsetOrdering(input, ordering) {
			if _f.matchedRule == nil || _f.matchedRule(opt.SimplifyOffsetOrdering) {
				_group = _f.ConstructOffset(
					input,
					offset,
					_f.funcs.SimplifyLimitOffsetOrdering(input, ordering),
				)
				_f.mem.AddAltFingerprint(_offsetExpr.Fingerprint(), _group)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.SimplifyOffsetOrdering, _group, 0, 0)
				}
				return _group
			}
		}
	}

	return _f.onConstruct(memo.Expr(_offsetExpr))
}

// ConstructMax1Row constructs an expression for the Max1Row operator.
// Max1Row enforces that its input must return at most one row. It is used as
// input to the Subquery operator. See the comment above Subquery for more
// details.
func (_f *Factory) ConstructMax1Row(
	input memo.GroupID,
) memo.GroupID {
	_max1RowExpr := memo.MakeMax1RowExpr(input)
	_group := _f.mem.GroupByFingerprint(_max1RowExpr.Fingerprint())
	if _group != 0 {
		return _group
	}

	// [EliminateMax1Row]
	{
		if _f.funcs.HasZeroOrOneRow(input) {
			if _f.matchedRule == nil || _f.matchedRule(opt.EliminateMax1Row) {
				_group = input
				_f.mem.AddAltFingerprint(_max1RowExpr.Fingerprint(), _group)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.EliminateMax1Row, _group, 0, 0)
				}
				return _group
			}
		}
	}

	return _f.onConstruct(memo.Expr(_max1RowExpr))
}

// ConstructExplain constructs an expression for the Explain operator.
// Explain returns information about the execution plan of the "input"
// expression.
func (_f *Factory) ConstructExplain(
	input memo.GroupID,
	def memo.PrivateID,
) memo.GroupID {
	_explainExpr := memo.MakeExplainExpr(input, def)
	_group := _f.mem.GroupByFingerprint(_explainExpr.Fingerprint())
	if _group != 0 {
		return _group
	}

	// [SimplifyExplainOrdering]
	{
		if _f.funcs.CanSimplifyExplainOrdering(input, def) {
			if _f.matchedRule == nil || _f.matchedRule(opt.SimplifyExplainOrdering) {
				_group = _f.ConstructExplain(
					input,
					_f.funcs.SimplifyExplainOrdering(input, def),
				)
				_f.mem.AddAltFingerprint(_explainExpr.Fingerprint(), _group)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.SimplifyExplainOrdering, _group, 0, 0)
				}
				return _group
			}
		}
	}

	// [PruneExplainCols]
	{
		if _f.funcs.CanPruneCols(input, _f.funcs.NeededColsExplain(def)) {
			if _f.matchedRule == nil || _f.matchedRule(opt.PruneExplainCols) {
				_group = _f.ConstructExplain(
					_f.funcs.PruneCols(input, _f.funcs.NeededColsExplain(def)),
					def,
				)
				_f.mem.AddAltFingerprint(_explainExpr.Fingerprint(), _group)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.PruneExplainCols, _group, 0, 0)
				}
				return _group
			}
		}
	}

	return _f.onConstruct(memo.Expr(_explainExpr))
}

// ConstructShowTraceForSession constructs an expression for the ShowTraceForSession operator.
// ShowTraceForSession returns the current session traces.
func (_f *Factory) ConstructShowTraceForSession(
	def memo.PrivateID,
) memo.GroupID {
	_showTraceForSessionExpr := memo.MakeShowTraceForSessionExpr(def)
	_group := _f.mem.GroupByFingerprint(_showTraceForSessionExpr.Fingerprint())
	if _group != 0 {
		return _group
	}

	return _f.onConstruct(memo.Expr(_showTraceForSessionExpr))
}

// ConstructRowNumber constructs an expression for the RowNumber operator.
// RowNumber adds a column to each row in its input containing a unique,
// increasing number.
func (_f *Factory) ConstructRowNumber(
	input memo.GroupID,
	def memo.PrivateID,
) memo.GroupID {
	_rowNumberExpr := memo.MakeRowNumberExpr(input, def)
	_group := _f.mem.GroupByFingerprint(_rowNumberExpr.Fingerprint())
	if _group != 0 {
		return _group
	}

	// [SimplifyRowNumberOrdering]
	{
		if _f.funcs.CanSimplifyRowNumberOrdering(input, def) {
			if _f.matchedRule == nil || _f.matchedRule(opt.SimplifyRowNumberOrdering) {
				_group = _f.ConstructRowNumber(
					input,
					_f.funcs.SimplifyRowNumberOrdering(input, def),
				)
				_f.mem.AddAltFingerprint(_rowNumberExpr.Fingerprint(), _group)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.SimplifyRowNumberOrdering, _group, 0, 0)
				}
				return _group
			}
		}
	}

	return _f.onConstruct(memo.Expr(_rowNumberExpr))
}

// ConstructZip constructs an expression for the Zip operator.
// Zip represents a functional zip over generators a,b,c, which returns tuples of
// values from a,b,c picked "simultaneously". NULLs are used when a generator is
// "shorter" than another. In SQL, these generators can be either a generator
// function such as generate_series(), or a scalar function such as
// upper(). For example, consider this query:
//
//    SELECT * FROM ROWS FROM (generate_series(0, 1), upper('abc'));
//
// It is equivalent to (Zip [(Function generate_series), (Function upper)]).
// It produces:
//
//     generate_series | upper
//    -----------------+-------
//                   0 | ABC
//                   1 | NULL
//
// In the Zip operation, Funcs represents the list of functions, and Cols
// represents the columns output by the functions. Funcs and Cols might not be
// the same length since a single function may output multiple columns
// (e.g., pg_get_keywords() outputs three columns).
func (_f *Factory) ConstructZip(
	funcs memo.ListID,
	cols memo.PrivateID,
) memo.GroupID {
	_zipExpr := memo.MakeZipExpr(funcs, cols)
	_group := _f.mem.GroupByFingerprint(_zipExpr.Fingerprint())
	if _group != 0 {
		return _group
	}

	// [HoistZipSubquery]
	{
		for _, _item := range _f.mem.LookupList(funcs) {
			item := _item
			if _f.funcs.HasHoistableSubquery(item) {
				if _f.matchedRule == nil || _f.matchedRule(opt.HoistZipSubquery) {
					_group = _f.funcs.HoistZipSubquery(funcs, cols)
					_f.mem.AddAltFingerprint(_zipExpr.Fingerprint(), _group)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.HoistZipSubquery, _group, 0, 0)
					}
					return _group
				}
			}
		}
	}

	return _f.onConstruct(memo.Expr(_zipExpr))
}

// ConstructSubquery constructs an expression for the Subquery operator.
// Subquery is a subquery in a single-row context. Here are some examples:
//
//   SELECT 1 = (SELECT 1)
//   SELECT (1, 'a') = (SELECT 1, 'a')`
//
// In a single-row context, the outer query is only valid if the subquery returns
// at most one row. Subqueries in a multi-row context can be transformed to a
// single row context using the Any operator. See the comment above the Any
// operator for more details.
//
// The Input field contains the subquery itself, which should be wrapped in a
// Max1Row operator to enforce that the subquery can return at most one row
// (Max1Row may be removed by the optimizer later if it can determine statically
// that the subquery will always return at most one row). In addition, the
// subquery must project exactly one output column. If the subquery returns one
// row, then that column is bound to the single column value in that row. If the
// subquery returns zero rows, then that column is bound to NULL.
func (_f *Factory) ConstructSubquery(
	input memo.GroupID,
	def memo.PrivateID,
) memo.GroupID {
	_subqueryExpr := memo.MakeSubqueryExpr(input, def)
	_group := _f.mem.GroupByFingerprint(_subqueryExpr.Fingerprint())
	if _group != 0 {
		return _group
	}

	return _f.onConstruct(memo.Expr(_subqueryExpr))
}

// ConstructAny constructs an expression for the Any operator.
// Any is a SQL operator that applies a comparison to every row of an input
// subquery and returns true if any of the comparisons are true, else returns
// null if any of the comparisons are null, else returns false. The following
// transformations map from various SQL operators into the Any operator:
//
//   <scalar> IN (<subquery>)
//   ==> (Any <subquery> <scalar> EqOp)
//
//   <scalar> NOT IN (<subquery>)
//   ==> (Not (Any <subquery> <scalar> EqOp))
//
//   <scalar> <comp> {SOME|ANY}(<subquery>)
//   ==> (Any <subquery> <scalar> <comp>)
//
//   <scalar> <comp> ALL(<subquery>)
//   ==> (Not (Any <subquery> <scalar> <negated-comp>))
//
// Any expects the input subquery to return a single column of any data type. The
// scalar value is compared with that column using the specified comparison
// operator.
func (_f *Factory) ConstructAny(
	input memo.GroupID,
	scalar memo.GroupID,
	def memo.PrivateID,
) memo.GroupID {
	_anyExpr := memo.MakeAnyExpr(input, scalar, def)
	_group := _f.mem.GroupByFingerprint(_anyExpr.Fingerprint())
	if _group != 0 {
		return _group
	}

	return _f.onConstruct(memo.Expr(_anyExpr))
}

// ConstructVariable constructs an expression for the Variable operator.
// Variable is the typed scalar value of a column in the query. The private
// field is a Metadata.ColumnID that references the column by index.
func (_f *Factory) ConstructVariable(
	col memo.PrivateID,
) memo.GroupID {
	_variableExpr := memo.MakeVariableExpr(col)
	_group := _f.mem.GroupByFingerprint(_variableExpr.Fingerprint())
	if _group != 0 {
		return _group
	}

	return _f.onConstruct(memo.Expr(_variableExpr))
}

// ConstructConst constructs an expression for the Const operator.
// Const is a typed scalar constant value. The private field is a tree.Datum
// value having any datum type that's legal in the expression's context.
func (_f *Factory) ConstructConst(
	value memo.PrivateID,
) memo.GroupID {
	_constExpr := memo.MakeConstExpr(value)
	_group := _f.mem.GroupByFingerprint(_constExpr.Fingerprint())
	if _group != 0 {
		return _group
	}

	return _f.onConstruct(memo.Expr(_constExpr))
}

// ConstructNull constructs an expression for the Null operator.
// Null is the constant SQL null value that has "unknown value" semantics. If
// the Typ field is not types.Unknown, then the value is known to be in the
// domain of that type. This is important for preserving correct types in
// replacement patterns. For example:
//   (Plus (Function ...) (Const 1))
//
// If the function in that expression has a static type of Int, but then it gets
// constant folded to (Null), then its type must remain as Int. Any other type
// violates logical equivalence of the expression, breaking type inference and
// possibly changing the results of execution. The solution is to tag the null
// with the correct type:
//   (Plus (Null (Int)) (Const 1))
//
// Null is its own operator rather than a Const datum in order to make matching
// and replacement easier and more efficient, as patterns can contain (Null)
// expressions.
func (_f *Factory) ConstructNull(
	typ memo.PrivateID,
) memo.GroupID {
	_nullExpr := memo.MakeNullExpr(typ)
	_group := _f.mem.GroupByFingerprint(_nullExpr.Fingerprint())
	if _group != 0 {
		return _group
	}

	return _f.onConstruct(memo.Expr(_nullExpr))
}

// ConstructTrue constructs an expression for the True operator.
// True is the boolean true value that is equivalent to the tree.DBoolTrue datum
// value. It is a separate operator to make matching and replacement simpler and
// more efficient, as patterns can contain (True) expressions.
func (_f *Factory) ConstructTrue() memo.GroupID {
	_trueExpr := memo.MakeTrueExpr()
	_group := _f.mem.GroupByFingerprint(_trueExpr.Fingerprint())
	if _group != 0 {
		return _group
	}

	return _f.onConstruct(memo.Expr(_trueExpr))
}

// ConstructFalse constructs an expression for the False operator.
// False is the boolean false value that is equivalent to the tree.DBoolFalse
// datum value. It is a separate operator to make matching and replacement
// simpler and more efficient, as patterns can contain (False) expressions.
func (_f *Factory) ConstructFalse() memo.GroupID {
	_falseExpr := memo.MakeFalseExpr()
	_group := _f.mem.GroupByFingerprint(_falseExpr.Fingerprint())
	if _group != 0 {
		return _group
	}

	return _f.onConstruct(memo.Expr(_falseExpr))
}

// ConstructPlaceholder constructs an expression for the Placeholder operator.
func (_f *Factory) ConstructPlaceholder(
	value memo.PrivateID,
) memo.GroupID {
	_placeholderExpr := memo.MakePlaceholderExpr(value)
	_group := _f.mem.GroupByFingerprint(_placeholderExpr.Fingerprint())
	if _group != 0 {
		return _group
	}

	return _f.onConstruct(memo.Expr(_placeholderExpr))
}

// ConstructTuple constructs an expression for the Tuple operator.
func (_f *Factory) ConstructTuple(
	elems memo.ListID,
	typ memo.PrivateID,
) memo.GroupID {
	_tupleExpr := memo.MakeTupleExpr(elems, typ)
	_group := _f.mem.GroupByFingerprint(_tupleExpr.Fingerprint())
	if _group != 0 {
		return _group
	}

	return _f.onConstruct(memo.Expr(_tupleExpr))
}

// ConstructProjections constructs an expression for the Projections operator.
// Projections is a set of typed scalar expressions that will become output
// columns for a containing Project operator.
//
// The private Defs field contains the list of column indexes returned by each
// expression, and a list of pass-through columns.
//
// Elems cannot contain a simple VariableOp with the same ColumnID as the
// synthesized column (in Def.SynthesizedCols); that is a pass-through column.
// Elems can contain a VariableOp when a new ColumnID is being assigned, such as
// in the case of an outer column reference.
func (_f *Factory) ConstructProjections(
	elems memo.ListID,
	def memo.PrivateID,
) memo.GroupID {
	_projectionsExpr := memo.MakeProjectionsExpr(elems, def)
	_group := _f.mem.GroupByFingerprint(_projectionsExpr.Fingerprint())
	if _group != 0 {
		return _group
	}

	return _f.onConstruct(memo.Expr(_projectionsExpr))
}

// ConstructAggregations constructs an expression for the Aggregations operator.
// Aggregations is a set of aggregate expressions that will become output columns
// for a containing GroupBy operator. The expressions can only consist of
// aggregate functions, variable references, and modifiers like AggDistinct.
// Examples of valid expressions:
//   (Min (Variable 1))
//   (Count (AggDistinct (Variable 1)))
//
// More complex arguments must be formulated using a Project operator as input to
// the GroupBy operator.
//
// The private Cols field contains the list of column indexes returned by the
// expression, as an opt.ColList. It is legal for Cols to be empty.
func (_f *Factory) ConstructAggregations(
	aggs memo.ListID,
	cols memo.PrivateID,
) memo.GroupID {
	_aggregationsExpr := memo.MakeAggregationsExpr(aggs, cols)
	_group := _f.mem.GroupByFingerprint(_aggregationsExpr.Fingerprint())
	if _group != 0 {
		return _group
	}

	return _f.onConstruct(memo.Expr(_aggregationsExpr))
}

// ConstructMergeOn constructs an expression for the MergeOn operator.
// MergeOn contains the ON condition and the metadata for a merge join; it is
// always a child of MergeJoin.
func (_f *Factory) ConstructMergeOn(
	on memo.GroupID,
	def memo.PrivateID,
) memo.GroupID {
	_mergeOnExpr := memo.MakeMergeOnExpr(on, def)
	_group := _f.mem.GroupByFingerprint(_mergeOnExpr.Fingerprint())
	if _group != 0 {
		return _group
	}

	return _f.onConstruct(memo.Expr(_mergeOnExpr))
}

// ConstructExists constructs an expression for the Exists operator.
// Exists takes a relational query as its input, and evaluates to true if the
// query returns at least one row.
func (_f *Factory) ConstructExists(
	input memo.GroupID,
	def memo.PrivateID,
) memo.GroupID {
	_existsExpr := memo.MakeExistsExpr(input, def)
	_group := _f.mem.GroupByFingerprint(_existsExpr.Fingerprint())
	if _group != 0 {
		return _group
	}

	// [EliminateExistsProject]
	{
		_projectExpr := _f.mem.NormExpr(input).AsProject()
		if _projectExpr != nil {
			input := _projectExpr.Input()
			if _f.matchedRule == nil || _f.matchedRule(opt.EliminateExistsProject) {
				_group = _f.ConstructExists(
					input,
					def,
				)
				_f.mem.AddAltFingerprint(_existsExpr.Fingerprint(), _group)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.EliminateExistsProject, _group, 0, 0)
				}
				return _group
			}
		}
	}

	// [EliminateExistsGroupBy]
	{
		_expr := _f.mem.NormExpr(input)
		if _expr.Operator() == opt.GroupByOp || _expr.Operator() == opt.DistinctOnOp {
			input := _expr.ChildGroup(_f.Memo(), 0)
			if _f.matchedRule == nil || _f.matchedRule(opt.EliminateExistsGroupBy) {
				_group = _f.ConstructExists(
					input,
					def,
				)
				_f.mem.AddAltFingerprint(_existsExpr.Fingerprint(), _group)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.EliminateExistsGroupBy, _group, 0, 0)
				}
				return _group
			}
		}
	}

	return _f.onConstruct(memo.Expr(_existsExpr))
}

// ConstructFilters constructs an expression for the Filters operator.
// Filters is a boolean And operator that only appears as the Filters child of
// a Select operator, or the On child of a Join operator. For example:
//   (Select
//     (Scan a)
//     (Filters (Gt (Variable a) 1) (Lt (Variable a) 5))
//   )
//
// Normalization rules ensure that a Filters expression is always created if
// there is at least one condition, so that other rules can rely on its presence
// when matching, even in the case where there is only one condition. The
// semantics of the Filters operator are identical to those of the And operator.
func (_f *Factory) ConstructFilters(
	conditions memo.ListID,
) memo.GroupID {
	_filtersExpr := memo.MakeFiltersExpr(conditions)
	_group := _f.mem.GroupByFingerprint(_filtersExpr.Fingerprint())
	if _group != 0 {
		return _group
	}

	// [EliminateEmptyFilters]
	{
		if conditions.Length == 0 {
			if _f.matchedRule == nil || _f.matchedRule(opt.EliminateEmptyFilters) {
				_group = _f.ConstructTrue()
				_f.mem.AddAltFingerprint(_filtersExpr.Fingerprint(), _group)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.EliminateEmptyFilters, _group, 0, 0)
				}
				return _group
			}
		}
	}

	// [SimplifyFilters]
	{
		for _, _item := range _f.mem.LookupList(conditions) {
			_expr := _f.mem.NormExpr(_item)
			if _expr.Operator() == opt.AndOp || _expr.Operator() == opt.TrueOp || _expr.Operator() == opt.FalseOp || _expr.Operator() == opt.NullOp {
				if _f.matchedRule == nil || _f.matchedRule(opt.SimplifyFilters) {
					_group = _f.funcs.SimplifyFilters(conditions)
					_f.mem.AddAltFingerprint(_filtersExpr.Fingerprint(), _group)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.SimplifyFilters, _group, 0, 0)
					}
					return _group
				}
			}
		}
	}

	// [NormalizeAnyFilter]
	{
		list := conditions
		for _, _item := range _f.mem.LookupList(conditions) {
			any := _item
			_anyExpr := _f.mem.NormExpr(_item).AsAny()
			if _anyExpr != nil {
				input := _anyExpr.Input()
				scalar := _anyExpr.Scalar()
				subqueryDef := _anyExpr.Def()
				if _f.matchedRule == nil || _f.matchedRule(opt.NormalizeAnyFilter) {
					_group = _f.ConstructFilters(
						_f.funcs.ReplaceListItem(list, any, _f.ConstructExists(
							_f.ConstructSelect(
								input,
								_f.ConstructFilters(
									_f.mem.InternList([]memo.GroupID{_f.funcs.ConstructAnyCondition(input, scalar, subqueryDef)}),
								),
							),
							subqueryDef,
						)),
					)
					_f.mem.AddAltFingerprint(_filtersExpr.Fingerprint(), _group)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.NormalizeAnyFilter, _group, 0, 0)
					}
					return _group
				}
			}
		}
	}

	// [NormalizeNotAnyFilter]
	{
		list := conditions
		for _, _item := range _f.mem.LookupList(conditions) {
			notany := _item
			_notExpr := _f.mem.NormExpr(_item).AsNot()
			if _notExpr != nil {
				_anyExpr := _f.mem.NormExpr(_notExpr.Input()).AsAny()
				if _anyExpr != nil {
					input := _anyExpr.Input()
					scalar := _anyExpr.Scalar()
					subqueryDef := _anyExpr.Def()
					if _f.matchedRule == nil || _f.matchedRule(opt.NormalizeNotAnyFilter) {
						_group = _f.ConstructFilters(
							_f.funcs.ReplaceListItem(list, notany, _f.ConstructNot(
								_f.ConstructExists(
									_f.ConstructSelect(
										input,
										_f.ConstructFilters(
											_f.mem.InternList([]memo.GroupID{_f.ConstructIsNot(
												_f.funcs.ConstructAnyCondition(input, scalar, subqueryDef),
												_f.ConstructFalse(),
											)}),
										),
									),
									subqueryDef,
								),
							)),
						)
						_f.mem.AddAltFingerprint(_filtersExpr.Fingerprint(), _group)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.NormalizeNotAnyFilter, _group, 0, 0)
						}
						return _group
					}
				}
			}
		}
	}

	return _f.onConstruct(memo.Expr(_filtersExpr))
}

// ConstructAnd constructs an expression for the And operator.
// And is the boolean conjunction operator that evalutes to true if all of its
// conditions evaluate to true. If the conditions list is empty, it evalutes to
// true.
func (_f *Factory) ConstructAnd(
	conditions memo.ListID,
) memo.GroupID {
	_andExpr := memo.MakeAndExpr(conditions)
	_group := _f.mem.GroupByFingerprint(_andExpr.Fingerprint())
	if _group != 0 {
		return _group
	}

	// [EliminateSingletonAndOr]
	{
		if conditions.Length == 1 {
			_item := _f.mem.LookupList(conditions)[0]
			item := _item
			if _f.matchedRule == nil || _f.matchedRule(opt.EliminateSingletonAndOr) {
				_group = item
				_f.mem.AddAltFingerprint(_andExpr.Fingerprint(), _group)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.EliminateSingletonAndOr, _group, 0, 0)
				}
				return _group
			}
		}
	}

	// [SimplifyAnd]
	{
		for _, _item := range _f.mem.LookupList(conditions) {
			_expr := _f.mem.NormExpr(_item)
			if _expr.Operator() == opt.AndOp || _expr.Operator() == opt.TrueOp || _expr.Operator() == opt.FalseOp {
				if _f.matchedRule == nil || _f.matchedRule(opt.SimplifyAnd) {
					_group = _f.funcs.SimplifyAnd(conditions)
					_f.mem.AddAltFingerprint(_andExpr.Fingerprint(), _group)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.SimplifyAnd, _group, 0, 0)
					}
					return _group
				}
			}
		}
	}

	// [FoldNullAndOr]
	{
		if conditions.Length > 0 {
			_item := _f.mem.LookupList(conditions)[0]
			_nullExpr := _f.mem.NormExpr(_item).AsNull()
			if _nullExpr != nil {
				if _f.funcs.ListOnlyHasNulls(conditions) {
					if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullAndOr) {
						_group = _f.ConstructNull(
							_f.funcs.BoolType(),
						)
						_f.mem.AddAltFingerprint(_andExpr.Fingerprint(), _group)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.FoldNullAndOr, _group, 0, 0)
						}
						return _group
					}
				}
			}
		}
	}

	return _f.onConstruct(memo.Expr(_andExpr))
}

// ConstructOr constructs an expression for the Or operator.
// Or is the boolean disjunction operator that evalutes to true if any of its
// conditions evaluate to true. If the conditions list is empty, it evaluates to
// false.
func (_f *Factory) ConstructOr(
	conditions memo.ListID,
) memo.GroupID {
	_orExpr := memo.MakeOrExpr(conditions)
	_group := _f.mem.GroupByFingerprint(_orExpr.Fingerprint())
	if _group != 0 {
		return _group
	}

	// [EliminateSingletonAndOr]
	{
		if conditions.Length == 1 {
			_item := _f.mem.LookupList(conditions)[0]
			item := _item
			if _f.matchedRule == nil || _f.matchedRule(opt.EliminateSingletonAndOr) {
				_group = item
				_f.mem.AddAltFingerprint(_orExpr.Fingerprint(), _group)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.EliminateSingletonAndOr, _group, 0, 0)
				}
				return _group
			}
		}
	}

	// [SimplifyOr]
	{
		for _, _item := range _f.mem.LookupList(conditions) {
			_expr := _f.mem.NormExpr(_item)
			if _expr.Operator() == opt.OrOp || _expr.Operator() == opt.TrueOp || _expr.Operator() == opt.FalseOp {
				if _f.matchedRule == nil || _f.matchedRule(opt.SimplifyOr) {
					_group = _f.funcs.SimplifyOr(conditions)
					_f.mem.AddAltFingerprint(_orExpr.Fingerprint(), _group)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.SimplifyOr, _group, 0, 0)
					}
					return _group
				}
			}
		}
	}

	// [FoldNullAndOr]
	{
		if conditions.Length > 0 {
			_item := _f.mem.LookupList(conditions)[0]
			_nullExpr := _f.mem.NormExpr(_item).AsNull()
			if _nullExpr != nil {
				if _f.funcs.ListOnlyHasNulls(conditions) {
					if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullAndOr) {
						_group = _f.ConstructNull(
							_f.funcs.BoolType(),
						)
						_f.mem.AddAltFingerprint(_orExpr.Fingerprint(), _group)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.FoldNullAndOr, _group, 0, 0)
						}
						return _group
					}
				}
			}
		}
	}

	// [ExtractRedundantClause]
	{
		if conditions.Length > 0 {
			_item := _f.mem.LookupList(conditions)[0]
			item := _item
			if _f.funcs.IsRedundantSubclause(conditions, item) {
				if _f.matchedRule == nil || _f.matchedRule(opt.ExtractRedundantClause) {
					_group = item
					_f.mem.AddAltFingerprint(_orExpr.Fingerprint(), _group)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.ExtractRedundantClause, _group, 0, 0)
					}
					return _group
				}
			}
		}
	}

	// [ExtractRedundantSubclause]
	{
		if conditions.Length > 0 {
			_item := _f.mem.LookupList(conditions)[0]
			_andExpr := _f.mem.NormExpr(_item).AsAnd()
			if _andExpr != nil {
				for _, _item := range _f.mem.LookupList(_andExpr.Conditions()) {
					item := _item
					if _f.funcs.IsRedundantSubclause(conditions, item) {
						if _f.matchedRule == nil || _f.matchedRule(opt.ExtractRedundantSubclause) {
							_group = _f.funcs.ExtractRedundantSubclause(conditions, item)
							_f.mem.AddAltFingerprint(_orExpr.Fingerprint(), _group)
							if _f.appliedRule != nil {
								_f.appliedRule(opt.ExtractRedundantSubclause, _group, 0, 0)
							}
							return _group
						}
					}
				}
			}
		}
	}

	return _f.onConstruct(memo.Expr(_orExpr))
}

// ConstructNot constructs an expression for the Not operator.
// Not is the boolean negation operator that evaluates to true if its input
// evalutes to false.
func (_f *Factory) ConstructNot(
	input memo.GroupID,
) memo.GroupID {
	_notExpr := memo.MakeNotExpr(input)
	_group := _f.mem.GroupByFingerprint(_notExpr.Fingerprint())
	if _group != 0 {
		return _group
	}

	// [FoldNotTrue]
	{
		_trueExpr := _f.mem.NormExpr(input).AsTrue()
		if _trueExpr != nil {
			if _f.matchedRule == nil || _f.matchedRule(opt.FoldNotTrue) {
				_group = _f.ConstructFalse()
				_f.mem.AddAltFingerprint(_notExpr.Fingerprint(), _group)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.FoldNotTrue, _group, 0, 0)
				}
				return _group
			}
		}
	}

	// [FoldNotFalse]
	{
		_falseExpr := _f.mem.NormExpr(input).AsFalse()
		if _falseExpr != nil {
			if _f.matchedRule == nil || _f.matchedRule(opt.FoldNotFalse) {
				_group = _f.ConstructTrue()
				_f.mem.AddAltFingerprint(_notExpr.Fingerprint(), _group)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.FoldNotFalse, _group, 0, 0)
				}
				return _group
			}
		}
	}

	// [NegateComparison]
	{
		_expr := _f.mem.NormExpr(input)
		if _expr.IsComparison() {
			left := _expr.ChildGroup(_f.Memo(), 0)
			right := _expr.ChildGroup(_f.Memo(), 1)
			_expr2 := _f.mem.NormExpr(input)
			if !(_expr2.Operator() == opt.ContainsOp || _expr2.Operator() == opt.JsonExistsOp || _expr2.Operator() == opt.JsonSomeExistsOp || _expr2.Operator() == opt.JsonAllExistsOp) {
				if _f.matchedRule == nil || _f.matchedRule(opt.NegateComparison) {
					_group = _f.funcs.NegateComparison(_f.mem.NormExpr(input).Operator(), left, right)
					_f.mem.AddAltFingerprint(_notExpr.Fingerprint(), _group)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.NegateComparison, _group, 0, 0)
					}
					return _group
				}
			}
		}
	}

	// [EliminateNot]
	{
		_notExpr2 := _f.mem.NormExpr(input).AsNot()
		if _notExpr2 != nil {
			input := _notExpr2.Input()
			if _f.matchedRule == nil || _f.matchedRule(opt.EliminateNot) {
				_group = input
				_f.mem.AddAltFingerprint(_notExpr.Fingerprint(), _group)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.EliminateNot, _group, 0, 0)
				}
				return _group
			}
		}
	}

	// [NegateAnd]
	{
		_andExpr := _f.mem.NormExpr(input).AsAnd()
		if _andExpr != nil {
			conditions := _andExpr.Conditions()
			if _f.matchedRule == nil || _f.matchedRule(opt.NegateAnd) {
				_group = _f.ConstructOr(
					_f.funcs.NegateConditions(conditions),
				)
				_f.mem.AddAltFingerprint(_notExpr.Fingerprint(), _group)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.NegateAnd, _group, 0, 0)
				}
				return _group
			}
		}
	}

	// [NegateOr]
	{
		_orExpr := _f.mem.NormExpr(input).AsOr()
		if _orExpr != nil {
			conditions := _orExpr.Conditions()
			if _f.matchedRule == nil || _f.matchedRule(opt.NegateOr) {
				_group = _f.ConstructAnd(
					_f.funcs.NegateConditions(conditions),
				)
				_f.mem.AddAltFingerprint(_notExpr.Fingerprint(), _group)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.NegateOr, _group, 0, 0)
				}
				return _group
			}
		}
	}

	return _f.onConstruct(memo.Expr(_notExpr))
}

// ConstructEq constructs an expression for the Eq operator.
func (_f *Factory) ConstructEq(
	left memo.GroupID,
	right memo.GroupID,
) memo.GroupID {
	_eqExpr := memo.MakeEqExpr(left, right)
	_group := _f.mem.GroupByFingerprint(_eqExpr.Fingerprint())
	if _group != 0 {
		return _group
	}

	// [NormalizeCmpPlusConst]
	{
		_plusExpr := _f.mem.NormExpr(left).AsPlus()
		if _plusExpr != nil {
			leftLeft := _plusExpr.Left()
			if !_f.funcs.OnlyConstants(leftLeft) {
				leftRight := _plusExpr.Right()
				if _f.funcs.OnlyConstants(leftRight) {
					if _f.funcs.OnlyConstants(right) {
						if _f.funcs.CanConstructBinary(opt.MinusOp, right, leftRight) {
							if _f.matchedRule == nil || _f.matchedRule(opt.NormalizeCmpPlusConst) {
								_group = _f.ConstructEq(
									leftLeft,
									_f.ConstructMinus(
										right,
										leftRight,
									),
								)
								_f.mem.AddAltFingerprint(_eqExpr.Fingerprint(), _group)
								if _f.appliedRule != nil {
									_f.appliedRule(opt.NormalizeCmpPlusConst, _group, 0, 0)
								}
								return _group
							}
						}
					}
				}
			}
		}
	}

	// [NormalizeCmpMinusConst]
	{
		_minusExpr := _f.mem.NormExpr(left).AsMinus()
		if _minusExpr != nil {
			leftLeft := _minusExpr.Left()
			if !_f.funcs.OnlyConstants(leftLeft) {
				leftRight := _minusExpr.Right()
				if _f.funcs.OnlyConstants(leftRight) {
					if _f.funcs.OnlyConstants(right) {
						if _f.funcs.CanConstructBinary(opt.PlusOp, right, leftRight) {
							if _f.matchedRule == nil || _f.matchedRule(opt.NormalizeCmpMinusConst) {
								_group = _f.ConstructEq(
									leftLeft,
									_f.ConstructPlus(
										right,
										leftRight,
									),
								)
								_f.mem.AddAltFingerprint(_eqExpr.Fingerprint(), _group)
								if _f.appliedRule != nil {
									_f.appliedRule(opt.NormalizeCmpMinusConst, _group, 0, 0)
								}
								return _group
							}
						}
					}
				}
			}
		}
	}

	// [NormalizeCmpConstMinus]
	{
		_minusExpr := _f.mem.NormExpr(left).AsMinus()
		if _minusExpr != nil {
			leftLeft := _minusExpr.Left()
			if _f.funcs.OnlyConstants(leftLeft) {
				leftRight := _minusExpr.Right()
				if !_f.funcs.OnlyConstants(leftRight) {
					if _f.funcs.OnlyConstants(right) {
						if _f.funcs.CanConstructBinary(opt.MinusOp, leftLeft, right) {
							if _f.matchedRule == nil || _f.matchedRule(opt.NormalizeCmpConstMinus) {
								_group = _f.ConstructEq(
									_f.ConstructMinus(
										leftLeft,
										right,
									),
									leftRight,
								)
								_f.mem.AddAltFingerprint(_eqExpr.Fingerprint(), _group)
								if _f.appliedRule != nil {
									_f.appliedRule(opt.NormalizeCmpConstMinus, _group, 0, 0)
								}
								return _group
							}
						}
					}
				}
			}
		}
	}

	// [NormalizeTupleEquality]
	{
		_tupleExpr := _f.mem.NormExpr(left).AsTuple()
		if _tupleExpr != nil {
			left := _tupleExpr.Elems()
			_tupleExpr2 := _f.mem.NormExpr(right).AsTuple()
			if _tupleExpr2 != nil {
				right := _tupleExpr2.Elems()
				if _f.matchedRule == nil || _f.matchedRule(opt.NormalizeTupleEquality) {
					_group = _f.funcs.NormalizeTupleEquality(left, right)
					_f.mem.AddAltFingerprint(_eqExpr.Fingerprint(), _group)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.NormalizeTupleEquality, _group, 0, 0)
					}
					return _group
				}
			}
		}
	}

	// [FoldNullComparisonLeft]
	{
		_nullExpr := _f.mem.NormExpr(left).AsNull()
		if _nullExpr != nil {
			if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullComparisonLeft) {
				_group = _f.ConstructNull(
					_f.funcs.BoolType(),
				)
				_f.mem.AddAltFingerprint(_eqExpr.Fingerprint(), _group)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.FoldNullComparisonLeft, _group, 0, 0)
				}
				return _group
			}
		}
	}

	// [FoldNullComparisonRight]
	{
		_nullExpr := _f.mem.NormExpr(right).AsNull()
		if _nullExpr != nil {
			if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullComparisonRight) {
				_group = _f.ConstructNull(
					_f.funcs.BoolType(),
				)
				_f.mem.AddAltFingerprint(_eqExpr.Fingerprint(), _group)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.FoldNullComparisonRight, _group, 0, 0)
				}
				return _group
			}
		}
	}

	// [CommuteVar]
	{
		_variableExpr := _f.mem.NormExpr(left).AsVariable()
		if _variableExpr == nil {
			_variableExpr2 := _f.mem.NormExpr(right).AsVariable()
			if _variableExpr2 != nil {
				if _f.matchedRule == nil || _f.matchedRule(opt.CommuteVar) {
					_group = _f.ConstructEq(
						right,
						left,
					)
					_f.mem.AddAltFingerprint(_eqExpr.Fingerprint(), _group)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.CommuteVar, _group, 0, 0)
					}
					return _group
				}
			}
		}
	}

	// [CommuteConst]
	{
		if _f.funcs.OnlyConstants(left) {
			if !_f.funcs.OnlyConstants(right) {
				if _f.matchedRule == nil || _f.matchedRule(opt.CommuteConst) {
					_group = _f.ConstructEq(
						right,
						left,
					)
					_f.mem.AddAltFingerprint(_eqExpr.Fingerprint(), _group)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.CommuteConst, _group, 0, 0)
					}
					return _group
				}
			}
		}
	}

	// [UnifyComparisonTypes]
	{
		_variableExpr := _f.mem.NormExpr(left).AsVariable()
		if _variableExpr != nil {
			_constExpr := _f.mem.NormExpr(right).AsConst()
			if _constExpr != nil {
				result := _f.funcs.UnifyComparison(left, right)
				if _f.funcs.Succeeded(result) {
					if _f.matchedRule == nil || _f.matchedRule(opt.UnifyComparisonTypes) {
						_group = _f.ConstructEq(
							left,
							result,
						)
						_f.mem.AddAltFingerprint(_eqExpr.Fingerprint(), _group)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.UnifyComparisonTypes, _group, 0, 0)
						}
						return _group
					}
				}
			}
		}
	}

	// [NormalizeJSONFieldAccess]
	{
		_fetchValExpr := _f.mem.NormExpr(left).AsFetchVal()
		if _fetchValExpr != nil {
			val := _fetchValExpr.Json()
			key := _fetchValExpr.Index()
			_constExpr := _f.mem.NormExpr(_fetchValExpr.Index()).AsConst()
			if _constExpr != nil {
				if _f.funcs.IsString(key) {
					_constExpr2 := _f.mem.NormExpr(right).AsConst()
					if _constExpr2 != nil {
						if _f.funcs.IsJSONScalar(right) {
							if _f.matchedRule == nil || _f.matchedRule(opt.NormalizeJSONFieldAccess) {
								_group = _f.ConstructContains(
									val,
									_f.funcs.MakeSingleKeyJSONObject(key, right),
								)
								_f.mem.AddAltFingerprint(_eqExpr.Fingerprint(), _group)
								if _f.appliedRule != nil {
									_f.appliedRule(opt.NormalizeJSONFieldAccess, _group, 0, 0)
								}
								return _group
							}
						}
					}
				}
			}
		}
	}

	// [FoldComparison]
	{
		if _f.funcs.IsConstValueOrTuple(left) {
			if _f.funcs.IsConstValueOrTuple(right) {
				result := _f.funcs.FoldComparison(opt.EqOp, left, right)
				if _f.funcs.Succeeded(result) {
					if _f.matchedRule == nil || _f.matchedRule(opt.FoldComparison) {
						_group = result
						_f.mem.AddAltFingerprint(_eqExpr.Fingerprint(), _group)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.FoldComparison, _group, 0, 0)
						}
						return _group
					}
				}
			}
		}
	}

	return _f.onConstruct(memo.Expr(_eqExpr))
}

// ConstructLt constructs an expression for the Lt operator.
func (_f *Factory) ConstructLt(
	left memo.GroupID,
	right memo.GroupID,
) memo.GroupID {
	_ltExpr := memo.MakeLtExpr(left, right)
	_group := _f.mem.GroupByFingerprint(_ltExpr.Fingerprint())
	if _group != 0 {
		return _group
	}

	// [CommuteVarInequality]
	{
		_variableExpr := _f.mem.NormExpr(left).AsVariable()
		if _variableExpr == nil {
			_variableExpr2 := _f.mem.NormExpr(right).AsVariable()
			if _variableExpr2 != nil {
				if _f.matchedRule == nil || _f.matchedRule(opt.CommuteVarInequality) {
					_group = _f.funcs.CommuteInequality(opt.LtOp, left, right)
					_f.mem.AddAltFingerprint(_ltExpr.Fingerprint(), _group)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.CommuteVarInequality, _group, 0, 0)
					}
					return _group
				}
			}
		}
	}

	// [CommuteConstInequality]
	{
		if _f.funcs.OnlyConstants(left) {
			if !_f.funcs.OnlyConstants(right) {
				if _f.matchedRule == nil || _f.matchedRule(opt.CommuteConstInequality) {
					_group = _f.funcs.CommuteInequality(opt.LtOp, left, right)
					_f.mem.AddAltFingerprint(_ltExpr.Fingerprint(), _group)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.CommuteConstInequality, _group, 0, 0)
					}
					return _group
				}
			}
		}
	}

	// [NormalizeCmpPlusConst]
	{
		_plusExpr := _f.mem.NormExpr(left).AsPlus()
		if _plusExpr != nil {
			leftLeft := _plusExpr.Left()
			if !_f.funcs.OnlyConstants(leftLeft) {
				leftRight := _plusExpr.Right()
				if _f.funcs.OnlyConstants(leftRight) {
					if _f.funcs.OnlyConstants(right) {
						if _f.funcs.CanConstructBinary(opt.MinusOp, right, leftRight) {
							if _f.matchedRule == nil || _f.matchedRule(opt.NormalizeCmpPlusConst) {
								_group = _f.ConstructLt(
									leftLeft,
									_f.ConstructMinus(
										right,
										leftRight,
									),
								)
								_f.mem.AddAltFingerprint(_ltExpr.Fingerprint(), _group)
								if _f.appliedRule != nil {
									_f.appliedRule(opt.NormalizeCmpPlusConst, _group, 0, 0)
								}
								return _group
							}
						}
					}
				}
			}
		}
	}

	// [NormalizeCmpMinusConst]
	{
		_minusExpr := _f.mem.NormExpr(left).AsMinus()
		if _minusExpr != nil {
			leftLeft := _minusExpr.Left()
			if !_f.funcs.OnlyConstants(leftLeft) {
				leftRight := _minusExpr.Right()
				if _f.funcs.OnlyConstants(leftRight) {
					if _f.funcs.OnlyConstants(right) {
						if _f.funcs.CanConstructBinary(opt.PlusOp, right, leftRight) {
							if _f.matchedRule == nil || _f.matchedRule(opt.NormalizeCmpMinusConst) {
								_group = _f.ConstructLt(
									leftLeft,
									_f.ConstructPlus(
										right,
										leftRight,
									),
								)
								_f.mem.AddAltFingerprint(_ltExpr.Fingerprint(), _group)
								if _f.appliedRule != nil {
									_f.appliedRule(opt.NormalizeCmpMinusConst, _group, 0, 0)
								}
								return _group
							}
						}
					}
				}
			}
		}
	}

	// [NormalizeCmpConstMinus]
	{
		_minusExpr := _f.mem.NormExpr(left).AsMinus()
		if _minusExpr != nil {
			leftLeft := _minusExpr.Left()
			if _f.funcs.OnlyConstants(leftLeft) {
				leftRight := _minusExpr.Right()
				if !_f.funcs.OnlyConstants(leftRight) {
					if _f.funcs.OnlyConstants(right) {
						if _f.funcs.CanConstructBinary(opt.MinusOp, leftLeft, right) {
							if _f.matchedRule == nil || _f.matchedRule(opt.NormalizeCmpConstMinus) {
								_group = _f.ConstructLt(
									_f.ConstructMinus(
										leftLeft,
										right,
									),
									leftRight,
								)
								_f.mem.AddAltFingerprint(_ltExpr.Fingerprint(), _group)
								if _f.appliedRule != nil {
									_f.appliedRule(opt.NormalizeCmpConstMinus, _group, 0, 0)
								}
								return _group
							}
						}
					}
				}
			}
		}
	}

	// [FoldNullComparisonLeft]
	{
		_nullExpr := _f.mem.NormExpr(left).AsNull()
		if _nullExpr != nil {
			if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullComparisonLeft) {
				_group = _f.ConstructNull(
					_f.funcs.BoolType(),
				)
				_f.mem.AddAltFingerprint(_ltExpr.Fingerprint(), _group)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.FoldNullComparisonLeft, _group, 0, 0)
				}
				return _group
			}
		}
	}

	// [FoldNullComparisonRight]
	{
		_nullExpr := _f.mem.NormExpr(right).AsNull()
		if _nullExpr != nil {
			if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullComparisonRight) {
				_group = _f.ConstructNull(
					_f.funcs.BoolType(),
				)
				_f.mem.AddAltFingerprint(_ltExpr.Fingerprint(), _group)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.FoldNullComparisonRight, _group, 0, 0)
				}
				return _group
			}
		}
	}

	// [UnifyComparisonTypes]
	{
		_variableExpr := _f.mem.NormExpr(left).AsVariable()
		if _variableExpr != nil {
			_constExpr := _f.mem.NormExpr(right).AsConst()
			if _constExpr != nil {
				result := _f.funcs.UnifyComparison(left, right)
				if _f.funcs.Succeeded(result) {
					if _f.matchedRule == nil || _f.matchedRule(opt.UnifyComparisonTypes) {
						_group = _f.ConstructLt(
							left,
							result,
						)
						_f.mem.AddAltFingerprint(_ltExpr.Fingerprint(), _group)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.UnifyComparisonTypes, _group, 0, 0)
						}
						return _group
					}
				}
			}
		}
	}

	// [FoldComparison]
	{
		if _f.funcs.IsConstValueOrTuple(left) {
			if _f.funcs.IsConstValueOrTuple(right) {
				result := _f.funcs.FoldComparison(opt.LtOp, left, right)
				if _f.funcs.Succeeded(result) {
					if _f.matchedRule == nil || _f.matchedRule(opt.FoldComparison) {
						_group = result
						_f.mem.AddAltFingerprint(_ltExpr.Fingerprint(), _group)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.FoldComparison, _group, 0, 0)
						}
						return _group
					}
				}
			}
		}
	}

	return _f.onConstruct(memo.Expr(_ltExpr))
}

// ConstructGt constructs an expression for the Gt operator.
func (_f *Factory) ConstructGt(
	left memo.GroupID,
	right memo.GroupID,
) memo.GroupID {
	_gtExpr := memo.MakeGtExpr(left, right)
	_group := _f.mem.GroupByFingerprint(_gtExpr.Fingerprint())
	if _group != 0 {
		return _group
	}

	// [CommuteVarInequality]
	{
		_variableExpr := _f.mem.NormExpr(left).AsVariable()
		if _variableExpr == nil {
			_variableExpr2 := _f.mem.NormExpr(right).AsVariable()
			if _variableExpr2 != nil {
				if _f.matchedRule == nil || _f.matchedRule(opt.CommuteVarInequality) {
					_group = _f.funcs.CommuteInequality(opt.GtOp, left, right)
					_f.mem.AddAltFingerprint(_gtExpr.Fingerprint(), _group)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.CommuteVarInequality, _group, 0, 0)
					}
					return _group
				}
			}
		}
	}

	// [CommuteConstInequality]
	{
		if _f.funcs.OnlyConstants(left) {
			if !_f.funcs.OnlyConstants(right) {
				if _f.matchedRule == nil || _f.matchedRule(opt.CommuteConstInequality) {
					_group = _f.funcs.CommuteInequality(opt.GtOp, left, right)
					_f.mem.AddAltFingerprint(_gtExpr.Fingerprint(), _group)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.CommuteConstInequality, _group, 0, 0)
					}
					return _group
				}
			}
		}
	}

	// [NormalizeCmpPlusConst]
	{
		_plusExpr := _f.mem.NormExpr(left).AsPlus()
		if _plusExpr != nil {
			leftLeft := _plusExpr.Left()
			if !_f.funcs.OnlyConstants(leftLeft) {
				leftRight := _plusExpr.Right()
				if _f.funcs.OnlyConstants(leftRight) {
					if _f.funcs.OnlyConstants(right) {
						if _f.funcs.CanConstructBinary(opt.MinusOp, right, leftRight) {
							if _f.matchedRule == nil || _f.matchedRule(opt.NormalizeCmpPlusConst) {
								_group = _f.ConstructGt(
									leftLeft,
									_f.ConstructMinus(
										right,
										leftRight,
									),
								)
								_f.mem.AddAltFingerprint(_gtExpr.Fingerprint(), _group)
								if _f.appliedRule != nil {
									_f.appliedRule(opt.NormalizeCmpPlusConst, _group, 0, 0)
								}
								return _group
							}
						}
					}
				}
			}
		}
	}

	// [NormalizeCmpMinusConst]
	{
		_minusExpr := _f.mem.NormExpr(left).AsMinus()
		if _minusExpr != nil {
			leftLeft := _minusExpr.Left()
			if !_f.funcs.OnlyConstants(leftLeft) {
				leftRight := _minusExpr.Right()
				if _f.funcs.OnlyConstants(leftRight) {
					if _f.funcs.OnlyConstants(right) {
						if _f.funcs.CanConstructBinary(opt.PlusOp, right, leftRight) {
							if _f.matchedRule == nil || _f.matchedRule(opt.NormalizeCmpMinusConst) {
								_group = _f.ConstructGt(
									leftLeft,
									_f.ConstructPlus(
										right,
										leftRight,
									),
								)
								_f.mem.AddAltFingerprint(_gtExpr.Fingerprint(), _group)
								if _f.appliedRule != nil {
									_f.appliedRule(opt.NormalizeCmpMinusConst, _group, 0, 0)
								}
								return _group
							}
						}
					}
				}
			}
		}
	}

	// [NormalizeCmpConstMinus]
	{
		_minusExpr := _f.mem.NormExpr(left).AsMinus()
		if _minusExpr != nil {
			leftLeft := _minusExpr.Left()
			if _f.funcs.OnlyConstants(leftLeft) {
				leftRight := _minusExpr.Right()
				if !_f.funcs.OnlyConstants(leftRight) {
					if _f.funcs.OnlyConstants(right) {
						if _f.funcs.CanConstructBinary(opt.MinusOp, leftLeft, right) {
							if _f.matchedRule == nil || _f.matchedRule(opt.NormalizeCmpConstMinus) {
								_group = _f.ConstructGt(
									_f.ConstructMinus(
										leftLeft,
										right,
									),
									leftRight,
								)
								_f.mem.AddAltFingerprint(_gtExpr.Fingerprint(), _group)
								if _f.appliedRule != nil {
									_f.appliedRule(opt.NormalizeCmpConstMinus, _group, 0, 0)
								}
								return _group
							}
						}
					}
				}
			}
		}
	}

	// [FoldNullComparisonLeft]
	{
		_nullExpr := _f.mem.NormExpr(left).AsNull()
		if _nullExpr != nil {
			if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullComparisonLeft) {
				_group = _f.ConstructNull(
					_f.funcs.BoolType(),
				)
				_f.mem.AddAltFingerprint(_gtExpr.Fingerprint(), _group)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.FoldNullComparisonLeft, _group, 0, 0)
				}
				return _group
			}
		}
	}

	// [FoldNullComparisonRight]
	{
		_nullExpr := _f.mem.NormExpr(right).AsNull()
		if _nullExpr != nil {
			if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullComparisonRight) {
				_group = _f.ConstructNull(
					_f.funcs.BoolType(),
				)
				_f.mem.AddAltFingerprint(_gtExpr.Fingerprint(), _group)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.FoldNullComparisonRight, _group, 0, 0)
				}
				return _group
			}
		}
	}

	// [UnifyComparisonTypes]
	{
		_variableExpr := _f.mem.NormExpr(left).AsVariable()
		if _variableExpr != nil {
			_constExpr := _f.mem.NormExpr(right).AsConst()
			if _constExpr != nil {
				result := _f.funcs.UnifyComparison(left, right)
				if _f.funcs.Succeeded(result) {
					if _f.matchedRule == nil || _f.matchedRule(opt.UnifyComparisonTypes) {
						_group = _f.ConstructGt(
							left,
							result,
						)
						_f.mem.AddAltFingerprint(_gtExpr.Fingerprint(), _group)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.UnifyComparisonTypes, _group, 0, 0)
						}
						return _group
					}
				}
			}
		}
	}

	// [FoldComparison]
	{
		if _f.funcs.IsConstValueOrTuple(left) {
			if _f.funcs.IsConstValueOrTuple(right) {
				result := _f.funcs.FoldComparison(opt.GtOp, left, right)
				if _f.funcs.Succeeded(result) {
					if _f.matchedRule == nil || _f.matchedRule(opt.FoldComparison) {
						_group = result
						_f.mem.AddAltFingerprint(_gtExpr.Fingerprint(), _group)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.FoldComparison, _group, 0, 0)
						}
						return _group
					}
				}
			}
		}
	}

	return _f.onConstruct(memo.Expr(_gtExpr))
}

// ConstructLe constructs an expression for the Le operator.
func (_f *Factory) ConstructLe(
	left memo.GroupID,
	right memo.GroupID,
) memo.GroupID {
	_leExpr := memo.MakeLeExpr(left, right)
	_group := _f.mem.GroupByFingerprint(_leExpr.Fingerprint())
	if _group != 0 {
		return _group
	}

	// [CommuteVarInequality]
	{
		_variableExpr := _f.mem.NormExpr(left).AsVariable()
		if _variableExpr == nil {
			_variableExpr2 := _f.mem.NormExpr(right).AsVariable()
			if _variableExpr2 != nil {
				if _f.matchedRule == nil || _f.matchedRule(opt.CommuteVarInequality) {
					_group = _f.funcs.CommuteInequality(opt.LeOp, left, right)
					_f.mem.AddAltFingerprint(_leExpr.Fingerprint(), _group)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.CommuteVarInequality, _group, 0, 0)
					}
					return _group
				}
			}
		}
	}

	// [CommuteConstInequality]
	{
		if _f.funcs.OnlyConstants(left) {
			if !_f.funcs.OnlyConstants(right) {
				if _f.matchedRule == nil || _f.matchedRule(opt.CommuteConstInequality) {
					_group = _f.funcs.CommuteInequality(opt.LeOp, left, right)
					_f.mem.AddAltFingerprint(_leExpr.Fingerprint(), _group)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.CommuteConstInequality, _group, 0, 0)
					}
					return _group
				}
			}
		}
	}

	// [NormalizeCmpPlusConst]
	{
		_plusExpr := _f.mem.NormExpr(left).AsPlus()
		if _plusExpr != nil {
			leftLeft := _plusExpr.Left()
			if !_f.funcs.OnlyConstants(leftLeft) {
				leftRight := _plusExpr.Right()
				if _f.funcs.OnlyConstants(leftRight) {
					if _f.funcs.OnlyConstants(right) {
						if _f.funcs.CanConstructBinary(opt.MinusOp, right, leftRight) {
							if _f.matchedRule == nil || _f.matchedRule(opt.NormalizeCmpPlusConst) {
								_group = _f.ConstructLe(
									leftLeft,
									_f.ConstructMinus(
										right,
										leftRight,
									),
								)
								_f.mem.AddAltFingerprint(_leExpr.Fingerprint(), _group)
								if _f.appliedRule != nil {
									_f.appliedRule(opt.NormalizeCmpPlusConst, _group, 0, 0)
								}
								return _group
							}
						}
					}
				}
			}
		}
	}

	// [NormalizeCmpMinusConst]
	{
		_minusExpr := _f.mem.NormExpr(left).AsMinus()
		if _minusExpr != nil {
			leftLeft := _minusExpr.Left()
			if !_f.funcs.OnlyConstants(leftLeft) {
				leftRight := _minusExpr.Right()
				if _f.funcs.OnlyConstants(leftRight) {
					if _f.funcs.OnlyConstants(right) {
						if _f.funcs.CanConstructBinary(opt.PlusOp, right, leftRight) {
							if _f.matchedRule == nil || _f.matchedRule(opt.NormalizeCmpMinusConst) {
								_group = _f.ConstructLe(
									leftLeft,
									_f.ConstructPlus(
										right,
										leftRight,
									),
								)
								_f.mem.AddAltFingerprint(_leExpr.Fingerprint(), _group)
								if _f.appliedRule != nil {
									_f.appliedRule(opt.NormalizeCmpMinusConst, _group, 0, 0)
								}
								return _group
							}
						}
					}
				}
			}
		}
	}

	// [NormalizeCmpConstMinus]
	{
		_minusExpr := _f.mem.NormExpr(left).AsMinus()
		if _minusExpr != nil {
			leftLeft := _minusExpr.Left()
			if _f.funcs.OnlyConstants(leftLeft) {
				leftRight := _minusExpr.Right()
				if !_f.funcs.OnlyConstants(leftRight) {
					if _f.funcs.OnlyConstants(right) {
						if _f.funcs.CanConstructBinary(opt.MinusOp, leftLeft, right) {
							if _f.matchedRule == nil || _f.matchedRule(opt.NormalizeCmpConstMinus) {
								_group = _f.ConstructLe(
									_f.ConstructMinus(
										leftLeft,
										right,
									),
									leftRight,
								)
								_f.mem.AddAltFingerprint(_leExpr.Fingerprint(), _group)
								if _f.appliedRule != nil {
									_f.appliedRule(opt.NormalizeCmpConstMinus, _group, 0, 0)
								}
								return _group
							}
						}
					}
				}
			}
		}
	}

	// [FoldNullComparisonLeft]
	{
		_nullExpr := _f.mem.NormExpr(left).AsNull()
		if _nullExpr != nil {
			if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullComparisonLeft) {
				_group = _f.ConstructNull(
					_f.funcs.BoolType(),
				)
				_f.mem.AddAltFingerprint(_leExpr.Fingerprint(), _group)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.FoldNullComparisonLeft, _group, 0, 0)
				}
				return _group
			}
		}
	}

	// [FoldNullComparisonRight]
	{
		_nullExpr := _f.mem.NormExpr(right).AsNull()
		if _nullExpr != nil {
			if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullComparisonRight) {
				_group = _f.ConstructNull(
					_f.funcs.BoolType(),
				)
				_f.mem.AddAltFingerprint(_leExpr.Fingerprint(), _group)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.FoldNullComparisonRight, _group, 0, 0)
				}
				return _group
			}
		}
	}

	// [UnifyComparisonTypes]
	{
		_variableExpr := _f.mem.NormExpr(left).AsVariable()
		if _variableExpr != nil {
			_constExpr := _f.mem.NormExpr(right).AsConst()
			if _constExpr != nil {
				result := _f.funcs.UnifyComparison(left, right)
				if _f.funcs.Succeeded(result) {
					if _f.matchedRule == nil || _f.matchedRule(opt.UnifyComparisonTypes) {
						_group = _f.ConstructLe(
							left,
							result,
						)
						_f.mem.AddAltFingerprint(_leExpr.Fingerprint(), _group)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.UnifyComparisonTypes, _group, 0, 0)
						}
						return _group
					}
				}
			}
		}
	}

	// [FoldComparison]
	{
		if _f.funcs.IsConstValueOrTuple(left) {
			if _f.funcs.IsConstValueOrTuple(right) {
				result := _f.funcs.FoldComparison(opt.LeOp, left, right)
				if _f.funcs.Succeeded(result) {
					if _f.matchedRule == nil || _f.matchedRule(opt.FoldComparison) {
						_group = result
						_f.mem.AddAltFingerprint(_leExpr.Fingerprint(), _group)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.FoldComparison, _group, 0, 0)
						}
						return _group
					}
				}
			}
		}
	}

	return _f.onConstruct(memo.Expr(_leExpr))
}

// ConstructGe constructs an expression for the Ge operator.
func (_f *Factory) ConstructGe(
	left memo.GroupID,
	right memo.GroupID,
) memo.GroupID {
	_geExpr := memo.MakeGeExpr(left, right)
	_group := _f.mem.GroupByFingerprint(_geExpr.Fingerprint())
	if _group != 0 {
		return _group
	}

	// [CommuteVarInequality]
	{
		_variableExpr := _f.mem.NormExpr(left).AsVariable()
		if _variableExpr == nil {
			_variableExpr2 := _f.mem.NormExpr(right).AsVariable()
			if _variableExpr2 != nil {
				if _f.matchedRule == nil || _f.matchedRule(opt.CommuteVarInequality) {
					_group = _f.funcs.CommuteInequality(opt.GeOp, left, right)
					_f.mem.AddAltFingerprint(_geExpr.Fingerprint(), _group)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.CommuteVarInequality, _group, 0, 0)
					}
					return _group
				}
			}
		}
	}

	// [CommuteConstInequality]
	{
		if _f.funcs.OnlyConstants(left) {
			if !_f.funcs.OnlyConstants(right) {
				if _f.matchedRule == nil || _f.matchedRule(opt.CommuteConstInequality) {
					_group = _f.funcs.CommuteInequality(opt.GeOp, left, right)
					_f.mem.AddAltFingerprint(_geExpr.Fingerprint(), _group)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.CommuteConstInequality, _group, 0, 0)
					}
					return _group
				}
			}
		}
	}

	// [NormalizeCmpPlusConst]
	{
		_plusExpr := _f.mem.NormExpr(left).AsPlus()
		if _plusExpr != nil {
			leftLeft := _plusExpr.Left()
			if !_f.funcs.OnlyConstants(leftLeft) {
				leftRight := _plusExpr.Right()
				if _f.funcs.OnlyConstants(leftRight) {
					if _f.funcs.OnlyConstants(right) {
						if _f.funcs.CanConstructBinary(opt.MinusOp, right, leftRight) {
							if _f.matchedRule == nil || _f.matchedRule(opt.NormalizeCmpPlusConst) {
								_group = _f.ConstructGe(
									leftLeft,
									_f.ConstructMinus(
										right,
										leftRight,
									),
								)
								_f.mem.AddAltFingerprint(_geExpr.Fingerprint(), _group)
								if _f.appliedRule != nil {
									_f.appliedRule(opt.NormalizeCmpPlusConst, _group, 0, 0)
								}
								return _group
							}
						}
					}
				}
			}
		}
	}

	// [NormalizeCmpMinusConst]
	{
		_minusExpr := _f.mem.NormExpr(left).AsMinus()
		if _minusExpr != nil {
			leftLeft := _minusExpr.Left()
			if !_f.funcs.OnlyConstants(leftLeft) {
				leftRight := _minusExpr.Right()
				if _f.funcs.OnlyConstants(leftRight) {
					if _f.funcs.OnlyConstants(right) {
						if _f.funcs.CanConstructBinary(opt.PlusOp, right, leftRight) {
							if _f.matchedRule == nil || _f.matchedRule(opt.NormalizeCmpMinusConst) {
								_group = _f.ConstructGe(
									leftLeft,
									_f.ConstructPlus(
										right,
										leftRight,
									),
								)
								_f.mem.AddAltFingerprint(_geExpr.Fingerprint(), _group)
								if _f.appliedRule != nil {
									_f.appliedRule(opt.NormalizeCmpMinusConst, _group, 0, 0)
								}
								return _group
							}
						}
					}
				}
			}
		}
	}

	// [NormalizeCmpConstMinus]
	{
		_minusExpr := _f.mem.NormExpr(left).AsMinus()
		if _minusExpr != nil {
			leftLeft := _minusExpr.Left()
			if _f.funcs.OnlyConstants(leftLeft) {
				leftRight := _minusExpr.Right()
				if !_f.funcs.OnlyConstants(leftRight) {
					if _f.funcs.OnlyConstants(right) {
						if _f.funcs.CanConstructBinary(opt.MinusOp, leftLeft, right) {
							if _f.matchedRule == nil || _f.matchedRule(opt.NormalizeCmpConstMinus) {
								_group = _f.ConstructGe(
									_f.ConstructMinus(
										leftLeft,
										right,
									),
									leftRight,
								)
								_f.mem.AddAltFingerprint(_geExpr.Fingerprint(), _group)
								if _f.appliedRule != nil {
									_f.appliedRule(opt.NormalizeCmpConstMinus, _group, 0, 0)
								}
								return _group
							}
						}
					}
				}
			}
		}
	}

	// [FoldNullComparisonLeft]
	{
		_nullExpr := _f.mem.NormExpr(left).AsNull()
		if _nullExpr != nil {
			if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullComparisonLeft) {
				_group = _f.ConstructNull(
					_f.funcs.BoolType(),
				)
				_f.mem.AddAltFingerprint(_geExpr.Fingerprint(), _group)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.FoldNullComparisonLeft, _group, 0, 0)
				}
				return _group
			}
		}
	}

	// [FoldNullComparisonRight]
	{
		_nullExpr := _f.mem.NormExpr(right).AsNull()
		if _nullExpr != nil {
			if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullComparisonRight) {
				_group = _f.ConstructNull(
					_f.funcs.BoolType(),
				)
				_f.mem.AddAltFingerprint(_geExpr.Fingerprint(), _group)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.FoldNullComparisonRight, _group, 0, 0)
				}
				return _group
			}
		}
	}

	// [UnifyComparisonTypes]
	{
		_variableExpr := _f.mem.NormExpr(left).AsVariable()
		if _variableExpr != nil {
			_constExpr := _f.mem.NormExpr(right).AsConst()
			if _constExpr != nil {
				result := _f.funcs.UnifyComparison(left, right)
				if _f.funcs.Succeeded(result) {
					if _f.matchedRule == nil || _f.matchedRule(opt.UnifyComparisonTypes) {
						_group = _f.ConstructGe(
							left,
							result,
						)
						_f.mem.AddAltFingerprint(_geExpr.Fingerprint(), _group)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.UnifyComparisonTypes, _group, 0, 0)
						}
						return _group
					}
				}
			}
		}
	}

	// [FoldComparison]
	{
		if _f.funcs.IsConstValueOrTuple(left) {
			if _f.funcs.IsConstValueOrTuple(right) {
				result := _f.funcs.FoldComparison(opt.GeOp, left, right)
				if _f.funcs.Succeeded(result) {
					if _f.matchedRule == nil || _f.matchedRule(opt.FoldComparison) {
						_group = result
						_f.mem.AddAltFingerprint(_geExpr.Fingerprint(), _group)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.FoldComparison, _group, 0, 0)
						}
						return _group
					}
				}
			}
		}
	}

	return _f.onConstruct(memo.Expr(_geExpr))
}

// ConstructNe constructs an expression for the Ne operator.
func (_f *Factory) ConstructNe(
	left memo.GroupID,
	right memo.GroupID,
) memo.GroupID {
	_neExpr := memo.MakeNeExpr(left, right)
	_group := _f.mem.GroupByFingerprint(_neExpr.Fingerprint())
	if _group != 0 {
		return _group
	}

	// [FoldNullComparisonLeft]
	{
		_nullExpr := _f.mem.NormExpr(left).AsNull()
		if _nullExpr != nil {
			if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullComparisonLeft) {
				_group = _f.ConstructNull(
					_f.funcs.BoolType(),
				)
				_f.mem.AddAltFingerprint(_neExpr.Fingerprint(), _group)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.FoldNullComparisonLeft, _group, 0, 0)
				}
				return _group
			}
		}
	}

	// [FoldNullComparisonRight]
	{
		_nullExpr := _f.mem.NormExpr(right).AsNull()
		if _nullExpr != nil {
			if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullComparisonRight) {
				_group = _f.ConstructNull(
					_f.funcs.BoolType(),
				)
				_f.mem.AddAltFingerprint(_neExpr.Fingerprint(), _group)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.FoldNullComparisonRight, _group, 0, 0)
				}
				return _group
			}
		}
	}

	// [CommuteVar]
	{
		_variableExpr := _f.mem.NormExpr(left).AsVariable()
		if _variableExpr == nil {
			_variableExpr2 := _f.mem.NormExpr(right).AsVariable()
			if _variableExpr2 != nil {
				if _f.matchedRule == nil || _f.matchedRule(opt.CommuteVar) {
					_group = _f.ConstructNe(
						right,
						left,
					)
					_f.mem.AddAltFingerprint(_neExpr.Fingerprint(), _group)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.CommuteVar, _group, 0, 0)
					}
					return _group
				}
			}
		}
	}

	// [CommuteConst]
	{
		if _f.funcs.OnlyConstants(left) {
			if !_f.funcs.OnlyConstants(right) {
				if _f.matchedRule == nil || _f.matchedRule(opt.CommuteConst) {
					_group = _f.ConstructNe(
						right,
						left,
					)
					_f.mem.AddAltFingerprint(_neExpr.Fingerprint(), _group)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.CommuteConst, _group, 0, 0)
					}
					return _group
				}
			}
		}
	}

	// [UnifyComparisonTypes]
	{
		_variableExpr := _f.mem.NormExpr(left).AsVariable()
		if _variableExpr != nil {
			_constExpr := _f.mem.NormExpr(right).AsConst()
			if _constExpr != nil {
				result := _f.funcs.UnifyComparison(left, right)
				if _f.funcs.Succeeded(result) {
					if _f.matchedRule == nil || _f.matchedRule(opt.UnifyComparisonTypes) {
						_group = _f.ConstructNe(
							left,
							result,
						)
						_f.mem.AddAltFingerprint(_neExpr.Fingerprint(), _group)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.UnifyComparisonTypes, _group, 0, 0)
						}
						return _group
					}
				}
			}
		}
	}

	// [FoldComparison]
	{
		if _f.funcs.IsConstValueOrTuple(left) {
			if _f.funcs.IsConstValueOrTuple(right) {
				result := _f.funcs.FoldComparison(opt.NeOp, left, right)
				if _f.funcs.Succeeded(result) {
					if _f.matchedRule == nil || _f.matchedRule(opt.FoldComparison) {
						_group = result
						_f.mem.AddAltFingerprint(_neExpr.Fingerprint(), _group)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.FoldComparison, _group, 0, 0)
						}
						return _group
					}
				}
			}
		}
	}

	return _f.onConstruct(memo.Expr(_neExpr))
}

// ConstructIn constructs an expression for the In operator.
func (_f *Factory) ConstructIn(
	left memo.GroupID,
	right memo.GroupID,
) memo.GroupID {
	_inExpr := memo.MakeInExpr(left, right)
	_group := _f.mem.GroupByFingerprint(_inExpr.Fingerprint())
	if _group != 0 {
		return _group
	}

	// [FoldNullInNonEmpty]
	{
		_nullExpr := _f.mem.NormExpr(left).AsNull()
		if _nullExpr != nil {
			_tupleExpr := _f.mem.NormExpr(right).AsTuple()
			if _tupleExpr != nil {
				if _tupleExpr.Elems().Length != 0 {
					if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullInNonEmpty) {
						_group = _f.ConstructNull(
							_f.funcs.BoolType(),
						)
						_f.mem.AddAltFingerprint(_inExpr.Fingerprint(), _group)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.FoldNullInNonEmpty, _group, 0, 0)
						}
						return _group
					}
				}
			}
		}
	}

	// [FoldNullInEmpty]
	{
		_nullExpr := _f.mem.NormExpr(left).AsNull()
		if _nullExpr != nil {
			_tupleExpr := _f.mem.NormExpr(right).AsTuple()
			if _tupleExpr != nil {
				if _tupleExpr.Elems().Length == 0 {
					if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullInEmpty) {
						_group = _f.ConstructFalse()
						_f.mem.AddAltFingerprint(_inExpr.Fingerprint(), _group)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.FoldNullInEmpty, _group, 0, 0)
						}
						return _group
					}
				}
			}
		}
	}

	// [NormalizeInConst]
	{
		_tupleExpr := _f.mem.NormExpr(right).AsTuple()
		if _tupleExpr != nil {
			elems := _tupleExpr.Elems()
			if !_f.funcs.IsSortedUniqueList(elems) {
				if _f.matchedRule == nil || _f.matchedRule(opt.NormalizeInConst) {
					_group = _f.ConstructIn(
						left,
						_f.ConstructTuple(
							_f.funcs.ConstructSortedUniqueList(elems),
						),
					)
					_f.mem.AddAltFingerprint(_inExpr.Fingerprint(), _group)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.NormalizeInConst, _group, 0, 0)
					}
					return _group
				}
			}
		}
	}

	// [FoldInNull]
	{
		_tupleExpr := _f.mem.NormExpr(right).AsTuple()
		if _tupleExpr != nil {
			if _tupleExpr.Elems().Length == 1 {
				_item := _f.mem.LookupList(_tupleExpr.Elems())[0]
				_nullExpr := _f.mem.NormExpr(_item).AsNull()
				if _nullExpr != nil {
					if _f.matchedRule == nil || _f.matchedRule(opt.FoldInNull) {
						_group = _f.ConstructNull(
							_f.funcs.BoolType(),
						)
						_f.mem.AddAltFingerprint(_inExpr.Fingerprint(), _group)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.FoldInNull, _group, 0, 0)
						}
						return _group
					}
				}
			}
		}
	}

	// [UnifyComparisonTypes]
	{
		_variableExpr := _f.mem.NormExpr(left).AsVariable()
		if _variableExpr != nil {
			_constExpr := _f.mem.NormExpr(right).AsConst()
			if _constExpr != nil {
				result := _f.funcs.UnifyComparison(left, right)
				if _f.funcs.Succeeded(result) {
					if _f.matchedRule == nil || _f.matchedRule(opt.UnifyComparisonTypes) {
						_group = _f.ConstructIn(
							left,
							result,
						)
						_f.mem.AddAltFingerprint(_inExpr.Fingerprint(), _group)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.UnifyComparisonTypes, _group, 0, 0)
						}
						return _group
					}
				}
			}
		}
	}

	// [FoldComparison]
	{
		if _f.funcs.IsConstValueOrTuple(left) {
			if _f.funcs.IsConstValueOrTuple(right) {
				result := _f.funcs.FoldComparison(opt.InOp, left, right)
				if _f.funcs.Succeeded(result) {
					if _f.matchedRule == nil || _f.matchedRule(opt.FoldComparison) {
						_group = result
						_f.mem.AddAltFingerprint(_inExpr.Fingerprint(), _group)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.FoldComparison, _group, 0, 0)
						}
						return _group
					}
				}
			}
		}
	}

	return _f.onConstruct(memo.Expr(_inExpr))
}

// ConstructNotIn constructs an expression for the NotIn operator.
func (_f *Factory) ConstructNotIn(
	left memo.GroupID,
	right memo.GroupID,
) memo.GroupID {
	_notInExpr := memo.MakeNotInExpr(left, right)
	_group := _f.mem.GroupByFingerprint(_notInExpr.Fingerprint())
	if _group != 0 {
		return _group
	}

	// [FoldNullInNonEmpty]
	{
		_nullExpr := _f.mem.NormExpr(left).AsNull()
		if _nullExpr != nil {
			_tupleExpr := _f.mem.NormExpr(right).AsTuple()
			if _tupleExpr != nil {
				if _tupleExpr.Elems().Length != 0 {
					if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullInNonEmpty) {
						_group = _f.ConstructNull(
							_f.funcs.BoolType(),
						)
						_f.mem.AddAltFingerprint(_notInExpr.Fingerprint(), _group)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.FoldNullInNonEmpty, _group, 0, 0)
						}
						return _group
					}
				}
			}
		}
	}

	// [FoldNullNotInEmpty]
	{
		_nullExpr := _f.mem.NormExpr(left).AsNull()
		if _nullExpr != nil {
			_tupleExpr := _f.mem.NormExpr(right).AsTuple()
			if _tupleExpr != nil {
				if _tupleExpr.Elems().Length == 0 {
					if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullNotInEmpty) {
						_group = _f.ConstructTrue()
						_f.mem.AddAltFingerprint(_notInExpr.Fingerprint(), _group)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.FoldNullNotInEmpty, _group, 0, 0)
						}
						return _group
					}
				}
			}
		}
	}

	// [NormalizeInConst]
	{
		_tupleExpr := _f.mem.NormExpr(right).AsTuple()
		if _tupleExpr != nil {
			elems := _tupleExpr.Elems()
			if !_f.funcs.IsSortedUniqueList(elems) {
				if _f.matchedRule == nil || _f.matchedRule(opt.NormalizeInConst) {
					_group = _f.ConstructNotIn(
						left,
						_f.ConstructTuple(
							_f.funcs.ConstructSortedUniqueList(elems),
						),
					)
					_f.mem.AddAltFingerprint(_notInExpr.Fingerprint(), _group)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.NormalizeInConst, _group, 0, 0)
					}
					return _group
				}
			}
		}
	}

	// [FoldInNull]
	{
		_tupleExpr := _f.mem.NormExpr(right).AsTuple()
		if _tupleExpr != nil {
			if _tupleExpr.Elems().Length == 1 {
				_item := _f.mem.LookupList(_tupleExpr.Elems())[0]
				_nullExpr := _f.mem.NormExpr(_item).AsNull()
				if _nullExpr != nil {
					if _f.matchedRule == nil || _f.matchedRule(opt.FoldInNull) {
						_group = _f.ConstructNull(
							_f.funcs.BoolType(),
						)
						_f.mem.AddAltFingerprint(_notInExpr.Fingerprint(), _group)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.FoldInNull, _group, 0, 0)
						}
						return _group
					}
				}
			}
		}
	}

	// [UnifyComparisonTypes]
	{
		_variableExpr := _f.mem.NormExpr(left).AsVariable()
		if _variableExpr != nil {
			_constExpr := _f.mem.NormExpr(right).AsConst()
			if _constExpr != nil {
				result := _f.funcs.UnifyComparison(left, right)
				if _f.funcs.Succeeded(result) {
					if _f.matchedRule == nil || _f.matchedRule(opt.UnifyComparisonTypes) {
						_group = _f.ConstructNotIn(
							left,
							result,
						)
						_f.mem.AddAltFingerprint(_notInExpr.Fingerprint(), _group)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.UnifyComparisonTypes, _group, 0, 0)
						}
						return _group
					}
				}
			}
		}
	}

	// [FoldComparison]
	{
		if _f.funcs.IsConstValueOrTuple(left) {
			if _f.funcs.IsConstValueOrTuple(right) {
				result := _f.funcs.FoldComparison(opt.NotInOp, left, right)
				if _f.funcs.Succeeded(result) {
					if _f.matchedRule == nil || _f.matchedRule(opt.FoldComparison) {
						_group = result
						_f.mem.AddAltFingerprint(_notInExpr.Fingerprint(), _group)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.FoldComparison, _group, 0, 0)
						}
						return _group
					}
				}
			}
		}
	}

	return _f.onConstruct(memo.Expr(_notInExpr))
}

// ConstructLike constructs an expression for the Like operator.
func (_f *Factory) ConstructLike(
	left memo.GroupID,
	right memo.GroupID,
) memo.GroupID {
	_likeExpr := memo.MakeLikeExpr(left, right)
	_group := _f.mem.GroupByFingerprint(_likeExpr.Fingerprint())
	if _group != 0 {
		return _group
	}

	// [FoldNullComparisonLeft]
	{
		_nullExpr := _f.mem.NormExpr(left).AsNull()
		if _nullExpr != nil {
			if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullComparisonLeft) {
				_group = _f.ConstructNull(
					_f.funcs.BoolType(),
				)
				_f.mem.AddAltFingerprint(_likeExpr.Fingerprint(), _group)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.FoldNullComparisonLeft, _group, 0, 0)
				}
				return _group
			}
		}
	}

	// [FoldNullComparisonRight]
	{
		_nullExpr := _f.mem.NormExpr(right).AsNull()
		if _nullExpr != nil {
			if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullComparisonRight) {
				_group = _f.ConstructNull(
					_f.funcs.BoolType(),
				)
				_f.mem.AddAltFingerprint(_likeExpr.Fingerprint(), _group)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.FoldNullComparisonRight, _group, 0, 0)
				}
				return _group
			}
		}
	}

	// [UnifyComparisonTypes]
	{
		_variableExpr := _f.mem.NormExpr(left).AsVariable()
		if _variableExpr != nil {
			_constExpr := _f.mem.NormExpr(right).AsConst()
			if _constExpr != nil {
				result := _f.funcs.UnifyComparison(left, right)
				if _f.funcs.Succeeded(result) {
					if _f.matchedRule == nil || _f.matchedRule(opt.UnifyComparisonTypes) {
						_group = _f.ConstructLike(
							left,
							result,
						)
						_f.mem.AddAltFingerprint(_likeExpr.Fingerprint(), _group)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.UnifyComparisonTypes, _group, 0, 0)
						}
						return _group
					}
				}
			}
		}
	}

	// [FoldComparison]
	{
		if _f.funcs.IsConstValueOrTuple(left) {
			if _f.funcs.IsConstValueOrTuple(right) {
				result := _f.funcs.FoldComparison(opt.LikeOp, left, right)
				if _f.funcs.Succeeded(result) {
					if _f.matchedRule == nil || _f.matchedRule(opt.FoldComparison) {
						_group = result
						_f.mem.AddAltFingerprint(_likeExpr.Fingerprint(), _group)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.FoldComparison, _group, 0, 0)
						}
						return _group
					}
				}
			}
		}
	}

	return _f.onConstruct(memo.Expr(_likeExpr))
}

// ConstructNotLike constructs an expression for the NotLike operator.
func (_f *Factory) ConstructNotLike(
	left memo.GroupID,
	right memo.GroupID,
) memo.GroupID {
	_notLikeExpr := memo.MakeNotLikeExpr(left, right)
	_group := _f.mem.GroupByFingerprint(_notLikeExpr.Fingerprint())
	if _group != 0 {
		return _group
	}

	// [FoldNullComparisonLeft]
	{
		_nullExpr := _f.mem.NormExpr(left).AsNull()
		if _nullExpr != nil {
			if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullComparisonLeft) {
				_group = _f.ConstructNull(
					_f.funcs.BoolType(),
				)
				_f.mem.AddAltFingerprint(_notLikeExpr.Fingerprint(), _group)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.FoldNullComparisonLeft, _group, 0, 0)
				}
				return _group
			}
		}
	}

	// [FoldNullComparisonRight]
	{
		_nullExpr := _f.mem.NormExpr(right).AsNull()
		if _nullExpr != nil {
			if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullComparisonRight) {
				_group = _f.ConstructNull(
					_f.funcs.BoolType(),
				)
				_f.mem.AddAltFingerprint(_notLikeExpr.Fingerprint(), _group)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.FoldNullComparisonRight, _group, 0, 0)
				}
				return _group
			}
		}
	}

	// [UnifyComparisonTypes]
	{
		_variableExpr := _f.mem.NormExpr(left).AsVariable()
		if _variableExpr != nil {
			_constExpr := _f.mem.NormExpr(right).AsConst()
			if _constExpr != nil {
				result := _f.funcs.UnifyComparison(left, right)
				if _f.funcs.Succeeded(result) {
					if _f.matchedRule == nil || _f.matchedRule(opt.UnifyComparisonTypes) {
						_group = _f.ConstructNotLike(
							left,
							result,
						)
						_f.mem.AddAltFingerprint(_notLikeExpr.Fingerprint(), _group)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.UnifyComparisonTypes, _group, 0, 0)
						}
						return _group
					}
				}
			}
		}
	}

	// [FoldComparison]
	{
		if _f.funcs.IsConstValueOrTuple(left) {
			if _f.funcs.IsConstValueOrTuple(right) {
				result := _f.funcs.FoldComparison(opt.NotLikeOp, left, right)
				if _f.funcs.Succeeded(result) {
					if _f.matchedRule == nil || _f.matchedRule(opt.FoldComparison) {
						_group = result
						_f.mem.AddAltFingerprint(_notLikeExpr.Fingerprint(), _group)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.FoldComparison, _group, 0, 0)
						}
						return _group
					}
				}
			}
		}
	}

	return _f.onConstruct(memo.Expr(_notLikeExpr))
}

// ConstructILike constructs an expression for the ILike operator.
func (_f *Factory) ConstructILike(
	left memo.GroupID,
	right memo.GroupID,
) memo.GroupID {
	_iLikeExpr := memo.MakeILikeExpr(left, right)
	_group := _f.mem.GroupByFingerprint(_iLikeExpr.Fingerprint())
	if _group != 0 {
		return _group
	}

	// [FoldNullComparisonLeft]
	{
		_nullExpr := _f.mem.NormExpr(left).AsNull()
		if _nullExpr != nil {
			if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullComparisonLeft) {
				_group = _f.ConstructNull(
					_f.funcs.BoolType(),
				)
				_f.mem.AddAltFingerprint(_iLikeExpr.Fingerprint(), _group)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.FoldNullComparisonLeft, _group, 0, 0)
				}
				return _group
			}
		}
	}

	// [FoldNullComparisonRight]
	{
		_nullExpr := _f.mem.NormExpr(right).AsNull()
		if _nullExpr != nil {
			if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullComparisonRight) {
				_group = _f.ConstructNull(
					_f.funcs.BoolType(),
				)
				_f.mem.AddAltFingerprint(_iLikeExpr.Fingerprint(), _group)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.FoldNullComparisonRight, _group, 0, 0)
				}
				return _group
			}
		}
	}

	// [UnifyComparisonTypes]
	{
		_variableExpr := _f.mem.NormExpr(left).AsVariable()
		if _variableExpr != nil {
			_constExpr := _f.mem.NormExpr(right).AsConst()
			if _constExpr != nil {
				result := _f.funcs.UnifyComparison(left, right)
				if _f.funcs.Succeeded(result) {
					if _f.matchedRule == nil || _f.matchedRule(opt.UnifyComparisonTypes) {
						_group = _f.ConstructILike(
							left,
							result,
						)
						_f.mem.AddAltFingerprint(_iLikeExpr.Fingerprint(), _group)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.UnifyComparisonTypes, _group, 0, 0)
						}
						return _group
					}
				}
			}
		}
	}

	// [FoldComparison]
	{
		if _f.funcs.IsConstValueOrTuple(left) {
			if _f.funcs.IsConstValueOrTuple(right) {
				result := _f.funcs.FoldComparison(opt.ILikeOp, left, right)
				if _f.funcs.Succeeded(result) {
					if _f.matchedRule == nil || _f.matchedRule(opt.FoldComparison) {
						_group = result
						_f.mem.AddAltFingerprint(_iLikeExpr.Fingerprint(), _group)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.FoldComparison, _group, 0, 0)
						}
						return _group
					}
				}
			}
		}
	}

	return _f.onConstruct(memo.Expr(_iLikeExpr))
}

// ConstructNotILike constructs an expression for the NotILike operator.
func (_f *Factory) ConstructNotILike(
	left memo.GroupID,
	right memo.GroupID,
) memo.GroupID {
	_notILikeExpr := memo.MakeNotILikeExpr(left, right)
	_group := _f.mem.GroupByFingerprint(_notILikeExpr.Fingerprint())
	if _group != 0 {
		return _group
	}

	// [FoldNullComparisonLeft]
	{
		_nullExpr := _f.mem.NormExpr(left).AsNull()
		if _nullExpr != nil {
			if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullComparisonLeft) {
				_group = _f.ConstructNull(
					_f.funcs.BoolType(),
				)
				_f.mem.AddAltFingerprint(_notILikeExpr.Fingerprint(), _group)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.FoldNullComparisonLeft, _group, 0, 0)
				}
				return _group
			}
		}
	}

	// [FoldNullComparisonRight]
	{
		_nullExpr := _f.mem.NormExpr(right).AsNull()
		if _nullExpr != nil {
			if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullComparisonRight) {
				_group = _f.ConstructNull(
					_f.funcs.BoolType(),
				)
				_f.mem.AddAltFingerprint(_notILikeExpr.Fingerprint(), _group)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.FoldNullComparisonRight, _group, 0, 0)
				}
				return _group
			}
		}
	}

	// [UnifyComparisonTypes]
	{
		_variableExpr := _f.mem.NormExpr(left).AsVariable()
		if _variableExpr != nil {
			_constExpr := _f.mem.NormExpr(right).AsConst()
			if _constExpr != nil {
				result := _f.funcs.UnifyComparison(left, right)
				if _f.funcs.Succeeded(result) {
					if _f.matchedRule == nil || _f.matchedRule(opt.UnifyComparisonTypes) {
						_group = _f.ConstructNotILike(
							left,
							result,
						)
						_f.mem.AddAltFingerprint(_notILikeExpr.Fingerprint(), _group)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.UnifyComparisonTypes, _group, 0, 0)
						}
						return _group
					}
				}
			}
		}
	}

	// [FoldComparison]
	{
		if _f.funcs.IsConstValueOrTuple(left) {
			if _f.funcs.IsConstValueOrTuple(right) {
				result := _f.funcs.FoldComparison(opt.NotILikeOp, left, right)
				if _f.funcs.Succeeded(result) {
					if _f.matchedRule == nil || _f.matchedRule(opt.FoldComparison) {
						_group = result
						_f.mem.AddAltFingerprint(_notILikeExpr.Fingerprint(), _group)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.FoldComparison, _group, 0, 0)
						}
						return _group
					}
				}
			}
		}
	}

	return _f.onConstruct(memo.Expr(_notILikeExpr))
}

// ConstructSimilarTo constructs an expression for the SimilarTo operator.
func (_f *Factory) ConstructSimilarTo(
	left memo.GroupID,
	right memo.GroupID,
) memo.GroupID {
	_similarToExpr := memo.MakeSimilarToExpr(left, right)
	_group := _f.mem.GroupByFingerprint(_similarToExpr.Fingerprint())
	if _group != 0 {
		return _group
	}

	// [FoldNullComparisonLeft]
	{
		_nullExpr := _f.mem.NormExpr(left).AsNull()
		if _nullExpr != nil {
			if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullComparisonLeft) {
				_group = _f.ConstructNull(
					_f.funcs.BoolType(),
				)
				_f.mem.AddAltFingerprint(_similarToExpr.Fingerprint(), _group)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.FoldNullComparisonLeft, _group, 0, 0)
				}
				return _group
			}
		}
	}

	// [FoldNullComparisonRight]
	{
		_nullExpr := _f.mem.NormExpr(right).AsNull()
		if _nullExpr != nil {
			if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullComparisonRight) {
				_group = _f.ConstructNull(
					_f.funcs.BoolType(),
				)
				_f.mem.AddAltFingerprint(_similarToExpr.Fingerprint(), _group)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.FoldNullComparisonRight, _group, 0, 0)
				}
				return _group
			}
		}
	}

	// [UnifyComparisonTypes]
	{
		_variableExpr := _f.mem.NormExpr(left).AsVariable()
		if _variableExpr != nil {
			_constExpr := _f.mem.NormExpr(right).AsConst()
			if _constExpr != nil {
				result := _f.funcs.UnifyComparison(left, right)
				if _f.funcs.Succeeded(result) {
					if _f.matchedRule == nil || _f.matchedRule(opt.UnifyComparisonTypes) {
						_group = _f.ConstructSimilarTo(
							left,
							result,
						)
						_f.mem.AddAltFingerprint(_similarToExpr.Fingerprint(), _group)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.UnifyComparisonTypes, _group, 0, 0)
						}
						return _group
					}
				}
			}
		}
	}

	// [FoldComparison]
	{
		if _f.funcs.IsConstValueOrTuple(left) {
			if _f.funcs.IsConstValueOrTuple(right) {
				result := _f.funcs.FoldComparison(opt.SimilarToOp, left, right)
				if _f.funcs.Succeeded(result) {
					if _f.matchedRule == nil || _f.matchedRule(opt.FoldComparison) {
						_group = result
						_f.mem.AddAltFingerprint(_similarToExpr.Fingerprint(), _group)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.FoldComparison, _group, 0, 0)
						}
						return _group
					}
				}
			}
		}
	}

	return _f.onConstruct(memo.Expr(_similarToExpr))
}

// ConstructNotSimilarTo constructs an expression for the NotSimilarTo operator.
func (_f *Factory) ConstructNotSimilarTo(
	left memo.GroupID,
	right memo.GroupID,
) memo.GroupID {
	_notSimilarToExpr := memo.MakeNotSimilarToExpr(left, right)
	_group := _f.mem.GroupByFingerprint(_notSimilarToExpr.Fingerprint())
	if _group != 0 {
		return _group
	}

	// [FoldNullComparisonLeft]
	{
		_nullExpr := _f.mem.NormExpr(left).AsNull()
		if _nullExpr != nil {
			if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullComparisonLeft) {
				_group = _f.ConstructNull(
					_f.funcs.BoolType(),
				)
				_f.mem.AddAltFingerprint(_notSimilarToExpr.Fingerprint(), _group)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.FoldNullComparisonLeft, _group, 0, 0)
				}
				return _group
			}
		}
	}

	// [FoldNullComparisonRight]
	{
		_nullExpr := _f.mem.NormExpr(right).AsNull()
		if _nullExpr != nil {
			if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullComparisonRight) {
				_group = _f.ConstructNull(
					_f.funcs.BoolType(),
				)
				_f.mem.AddAltFingerprint(_notSimilarToExpr.Fingerprint(), _group)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.FoldNullComparisonRight, _group, 0, 0)
				}
				return _group
			}
		}
	}

	// [UnifyComparisonTypes]
	{
		_variableExpr := _f.mem.NormExpr(left).AsVariable()
		if _variableExpr != nil {
			_constExpr := _f.mem.NormExpr(right).AsConst()
			if _constExpr != nil {
				result := _f.funcs.UnifyComparison(left, right)
				if _f.funcs.Succeeded(result) {
					if _f.matchedRule == nil || _f.matchedRule(opt.UnifyComparisonTypes) {
						_group = _f.ConstructNotSimilarTo(
							left,
							result,
						)
						_f.mem.AddAltFingerprint(_notSimilarToExpr.Fingerprint(), _group)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.UnifyComparisonTypes, _group, 0, 0)
						}
						return _group
					}
				}
			}
		}
	}

	// [FoldComparison]
	{
		if _f.funcs.IsConstValueOrTuple(left) {
			if _f.funcs.IsConstValueOrTuple(right) {
				result := _f.funcs.FoldComparison(opt.NotSimilarToOp, left, right)
				if _f.funcs.Succeeded(result) {
					if _f.matchedRule == nil || _f.matchedRule(opt.FoldComparison) {
						_group = result
						_f.mem.AddAltFingerprint(_notSimilarToExpr.Fingerprint(), _group)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.FoldComparison, _group, 0, 0)
						}
						return _group
					}
				}
			}
		}
	}

	return _f.onConstruct(memo.Expr(_notSimilarToExpr))
}

// ConstructRegMatch constructs an expression for the RegMatch operator.
func (_f *Factory) ConstructRegMatch(
	left memo.GroupID,
	right memo.GroupID,
) memo.GroupID {
	_regMatchExpr := memo.MakeRegMatchExpr(left, right)
	_group := _f.mem.GroupByFingerprint(_regMatchExpr.Fingerprint())
	if _group != 0 {
		return _group
	}

	// [FoldNullComparisonLeft]
	{
		_nullExpr := _f.mem.NormExpr(left).AsNull()
		if _nullExpr != nil {
			if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullComparisonLeft) {
				_group = _f.ConstructNull(
					_f.funcs.BoolType(),
				)
				_f.mem.AddAltFingerprint(_regMatchExpr.Fingerprint(), _group)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.FoldNullComparisonLeft, _group, 0, 0)
				}
				return _group
			}
		}
	}

	// [FoldNullComparisonRight]
	{
		_nullExpr := _f.mem.NormExpr(right).AsNull()
		if _nullExpr != nil {
			if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullComparisonRight) {
				_group = _f.ConstructNull(
					_f.funcs.BoolType(),
				)
				_f.mem.AddAltFingerprint(_regMatchExpr.Fingerprint(), _group)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.FoldNullComparisonRight, _group, 0, 0)
				}
				return _group
			}
		}
	}

	// [UnifyComparisonTypes]
	{
		_variableExpr := _f.mem.NormExpr(left).AsVariable()
		if _variableExpr != nil {
			_constExpr := _f.mem.NormExpr(right).AsConst()
			if _constExpr != nil {
				result := _f.funcs.UnifyComparison(left, right)
				if _f.funcs.Succeeded(result) {
					if _f.matchedRule == nil || _f.matchedRule(opt.UnifyComparisonTypes) {
						_group = _f.ConstructRegMatch(
							left,
							result,
						)
						_f.mem.AddAltFingerprint(_regMatchExpr.Fingerprint(), _group)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.UnifyComparisonTypes, _group, 0, 0)
						}
						return _group
					}
				}
			}
		}
	}

	// [FoldComparison]
	{
		if _f.funcs.IsConstValueOrTuple(left) {
			if _f.funcs.IsConstValueOrTuple(right) {
				result := _f.funcs.FoldComparison(opt.RegMatchOp, left, right)
				if _f.funcs.Succeeded(result) {
					if _f.matchedRule == nil || _f.matchedRule(opt.FoldComparison) {
						_group = result
						_f.mem.AddAltFingerprint(_regMatchExpr.Fingerprint(), _group)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.FoldComparison, _group, 0, 0)
						}
						return _group
					}
				}
			}
		}
	}

	return _f.onConstruct(memo.Expr(_regMatchExpr))
}

// ConstructNotRegMatch constructs an expression for the NotRegMatch operator.
func (_f *Factory) ConstructNotRegMatch(
	left memo.GroupID,
	right memo.GroupID,
) memo.GroupID {
	_notRegMatchExpr := memo.MakeNotRegMatchExpr(left, right)
	_group := _f.mem.GroupByFingerprint(_notRegMatchExpr.Fingerprint())
	if _group != 0 {
		return _group
	}

	// [FoldNullComparisonLeft]
	{
		_nullExpr := _f.mem.NormExpr(left).AsNull()
		if _nullExpr != nil {
			if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullComparisonLeft) {
				_group = _f.ConstructNull(
					_f.funcs.BoolType(),
				)
				_f.mem.AddAltFingerprint(_notRegMatchExpr.Fingerprint(), _group)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.FoldNullComparisonLeft, _group, 0, 0)
				}
				return _group
			}
		}
	}

	// [FoldNullComparisonRight]
	{
		_nullExpr := _f.mem.NormExpr(right).AsNull()
		if _nullExpr != nil {
			if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullComparisonRight) {
				_group = _f.ConstructNull(
					_f.funcs.BoolType(),
				)
				_f.mem.AddAltFingerprint(_notRegMatchExpr.Fingerprint(), _group)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.FoldNullComparisonRight, _group, 0, 0)
				}
				return _group
			}
		}
	}

	// [UnifyComparisonTypes]
	{
		_variableExpr := _f.mem.NormExpr(left).AsVariable()
		if _variableExpr != nil {
			_constExpr := _f.mem.NormExpr(right).AsConst()
			if _constExpr != nil {
				result := _f.funcs.UnifyComparison(left, right)
				if _f.funcs.Succeeded(result) {
					if _f.matchedRule == nil || _f.matchedRule(opt.UnifyComparisonTypes) {
						_group = _f.ConstructNotRegMatch(
							left,
							result,
						)
						_f.mem.AddAltFingerprint(_notRegMatchExpr.Fingerprint(), _group)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.UnifyComparisonTypes, _group, 0, 0)
						}
						return _group
					}
				}
			}
		}
	}

	// [FoldComparison]
	{
		if _f.funcs.IsConstValueOrTuple(left) {
			if _f.funcs.IsConstValueOrTuple(right) {
				result := _f.funcs.FoldComparison(opt.NotRegMatchOp, left, right)
				if _f.funcs.Succeeded(result) {
					if _f.matchedRule == nil || _f.matchedRule(opt.FoldComparison) {
						_group = result
						_f.mem.AddAltFingerprint(_notRegMatchExpr.Fingerprint(), _group)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.FoldComparison, _group, 0, 0)
						}
						return _group
					}
				}
			}
		}
	}

	return _f.onConstruct(memo.Expr(_notRegMatchExpr))
}

// ConstructRegIMatch constructs an expression for the RegIMatch operator.
func (_f *Factory) ConstructRegIMatch(
	left memo.GroupID,
	right memo.GroupID,
) memo.GroupID {
	_regIMatchExpr := memo.MakeRegIMatchExpr(left, right)
	_group := _f.mem.GroupByFingerprint(_regIMatchExpr.Fingerprint())
	if _group != 0 {
		return _group
	}

	// [FoldNullComparisonLeft]
	{
		_nullExpr := _f.mem.NormExpr(left).AsNull()
		if _nullExpr != nil {
			if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullComparisonLeft) {
				_group = _f.ConstructNull(
					_f.funcs.BoolType(),
				)
				_f.mem.AddAltFingerprint(_regIMatchExpr.Fingerprint(), _group)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.FoldNullComparisonLeft, _group, 0, 0)
				}
				return _group
			}
		}
	}

	// [FoldNullComparisonRight]
	{
		_nullExpr := _f.mem.NormExpr(right).AsNull()
		if _nullExpr != nil {
			if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullComparisonRight) {
				_group = _f.ConstructNull(
					_f.funcs.BoolType(),
				)
				_f.mem.AddAltFingerprint(_regIMatchExpr.Fingerprint(), _group)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.FoldNullComparisonRight, _group, 0, 0)
				}
				return _group
			}
		}
	}

	// [UnifyComparisonTypes]
	{
		_variableExpr := _f.mem.NormExpr(left).AsVariable()
		if _variableExpr != nil {
			_constExpr := _f.mem.NormExpr(right).AsConst()
			if _constExpr != nil {
				result := _f.funcs.UnifyComparison(left, right)
				if _f.funcs.Succeeded(result) {
					if _f.matchedRule == nil || _f.matchedRule(opt.UnifyComparisonTypes) {
						_group = _f.ConstructRegIMatch(
							left,
							result,
						)
						_f.mem.AddAltFingerprint(_regIMatchExpr.Fingerprint(), _group)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.UnifyComparisonTypes, _group, 0, 0)
						}
						return _group
					}
				}
			}
		}
	}

	// [FoldComparison]
	{
		if _f.funcs.IsConstValueOrTuple(left) {
			if _f.funcs.IsConstValueOrTuple(right) {
				result := _f.funcs.FoldComparison(opt.RegIMatchOp, left, right)
				if _f.funcs.Succeeded(result) {
					if _f.matchedRule == nil || _f.matchedRule(opt.FoldComparison) {
						_group = result
						_f.mem.AddAltFingerprint(_regIMatchExpr.Fingerprint(), _group)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.FoldComparison, _group, 0, 0)
						}
						return _group
					}
				}
			}
		}
	}

	return _f.onConstruct(memo.Expr(_regIMatchExpr))
}

// ConstructNotRegIMatch constructs an expression for the NotRegIMatch operator.
func (_f *Factory) ConstructNotRegIMatch(
	left memo.GroupID,
	right memo.GroupID,
) memo.GroupID {
	_notRegIMatchExpr := memo.MakeNotRegIMatchExpr(left, right)
	_group := _f.mem.GroupByFingerprint(_notRegIMatchExpr.Fingerprint())
	if _group != 0 {
		return _group
	}

	// [FoldNullComparisonLeft]
	{
		_nullExpr := _f.mem.NormExpr(left).AsNull()
		if _nullExpr != nil {
			if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullComparisonLeft) {
				_group = _f.ConstructNull(
					_f.funcs.BoolType(),
				)
				_f.mem.AddAltFingerprint(_notRegIMatchExpr.Fingerprint(), _group)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.FoldNullComparisonLeft, _group, 0, 0)
				}
				return _group
			}
		}
	}

	// [FoldNullComparisonRight]
	{
		_nullExpr := _f.mem.NormExpr(right).AsNull()
		if _nullExpr != nil {
			if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullComparisonRight) {
				_group = _f.ConstructNull(
					_f.funcs.BoolType(),
				)
				_f.mem.AddAltFingerprint(_notRegIMatchExpr.Fingerprint(), _group)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.FoldNullComparisonRight, _group, 0, 0)
				}
				return _group
			}
		}
	}

	// [UnifyComparisonTypes]
	{
		_variableExpr := _f.mem.NormExpr(left).AsVariable()
		if _variableExpr != nil {
			_constExpr := _f.mem.NormExpr(right).AsConst()
			if _constExpr != nil {
				result := _f.funcs.UnifyComparison(left, right)
				if _f.funcs.Succeeded(result) {
					if _f.matchedRule == nil || _f.matchedRule(opt.UnifyComparisonTypes) {
						_group = _f.ConstructNotRegIMatch(
							left,
							result,
						)
						_f.mem.AddAltFingerprint(_notRegIMatchExpr.Fingerprint(), _group)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.UnifyComparisonTypes, _group, 0, 0)
						}
						return _group
					}
				}
			}
		}
	}

	// [FoldComparison]
	{
		if _f.funcs.IsConstValueOrTuple(left) {
			if _f.funcs.IsConstValueOrTuple(right) {
				result := _f.funcs.FoldComparison(opt.NotRegIMatchOp, left, right)
				if _f.funcs.Succeeded(result) {
					if _f.matchedRule == nil || _f.matchedRule(opt.FoldComparison) {
						_group = result
						_f.mem.AddAltFingerprint(_notRegIMatchExpr.Fingerprint(), _group)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.FoldComparison, _group, 0, 0)
						}
						return _group
					}
				}
			}
		}
	}

	return _f.onConstruct(memo.Expr(_notRegIMatchExpr))
}

// ConstructIs constructs an expression for the Is operator.
func (_f *Factory) ConstructIs(
	left memo.GroupID,
	right memo.GroupID,
) memo.GroupID {
	_isExpr := memo.MakeIsExpr(left, right)
	_group := _f.mem.GroupByFingerprint(_isExpr.Fingerprint())
	if _group != 0 {
		return _group
	}

	// [FoldIsNull]
	{
		_nullExpr := _f.mem.NormExpr(left).AsNull()
		if _nullExpr != nil {
			_nullExpr2 := _f.mem.NormExpr(right).AsNull()
			if _nullExpr2 != nil {
				if _f.matchedRule == nil || _f.matchedRule(opt.FoldIsNull) {
					_group = _f.ConstructTrue()
					_f.mem.AddAltFingerprint(_isExpr.Fingerprint(), _group)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.FoldIsNull, _group, 0, 0)
					}
					return _group
				}
			}
		}
	}

	// [FoldNonNullIsNull]
	{
		_nullExpr := _f.mem.NormExpr(left).AsNull()
		if _nullExpr == nil {
			if _f.funcs.IsConstValueOrTuple(left) {
				_nullExpr2 := _f.mem.NormExpr(right).AsNull()
				if _nullExpr2 != nil {
					if _f.matchedRule == nil || _f.matchedRule(opt.FoldNonNullIsNull) {
						_group = _f.ConstructFalse()
						_f.mem.AddAltFingerprint(_isExpr.Fingerprint(), _group)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.FoldNonNullIsNull, _group, 0, 0)
						}
						return _group
					}
				}
			}
		}
	}

	// [CommuteNullIs]
	{
		_nullExpr := _f.mem.NormExpr(left).AsNull()
		if _nullExpr != nil {
			_nullExpr2 := _f.mem.NormExpr(right).AsNull()
			if _nullExpr2 == nil {
				if _f.matchedRule == nil || _f.matchedRule(opt.CommuteNullIs) {
					_group = _f.ConstructIs(
						right,
						left,
					)
					_f.mem.AddAltFingerprint(_isExpr.Fingerprint(), _group)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.CommuteNullIs, _group, 0, 0)
					}
					return _group
				}
			}
		}
	}

	// [CommuteVar]
	{
		_variableExpr := _f.mem.NormExpr(left).AsVariable()
		if _variableExpr == nil {
			_variableExpr2 := _f.mem.NormExpr(right).AsVariable()
			if _variableExpr2 != nil {
				if _f.matchedRule == nil || _f.matchedRule(opt.CommuteVar) {
					_group = _f.ConstructIs(
						right,
						left,
					)
					_f.mem.AddAltFingerprint(_isExpr.Fingerprint(), _group)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.CommuteVar, _group, 0, 0)
					}
					return _group
				}
			}
		}
	}

	// [CommuteConst]
	{
		if _f.funcs.OnlyConstants(left) {
			if !_f.funcs.OnlyConstants(right) {
				if _f.matchedRule == nil || _f.matchedRule(opt.CommuteConst) {
					_group = _f.ConstructIs(
						right,
						left,
					)
					_f.mem.AddAltFingerprint(_isExpr.Fingerprint(), _group)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.CommuteConst, _group, 0, 0)
					}
					return _group
				}
			}
		}
	}

	// [UnifyComparisonTypes]
	{
		_variableExpr := _f.mem.NormExpr(left).AsVariable()
		if _variableExpr != nil {
			_constExpr := _f.mem.NormExpr(right).AsConst()
			if _constExpr != nil {
				result := _f.funcs.UnifyComparison(left, right)
				if _f.funcs.Succeeded(result) {
					if _f.matchedRule == nil || _f.matchedRule(opt.UnifyComparisonTypes) {
						_group = _f.ConstructIs(
							left,
							result,
						)
						_f.mem.AddAltFingerprint(_isExpr.Fingerprint(), _group)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.UnifyComparisonTypes, _group, 0, 0)
						}
						return _group
					}
				}
			}
		}
	}

	// [FoldComparison]
	{
		if _f.funcs.IsConstValueOrTuple(left) {
			if _f.funcs.IsConstValueOrTuple(right) {
				result := _f.funcs.FoldComparison(opt.IsOp, left, right)
				if _f.funcs.Succeeded(result) {
					if _f.matchedRule == nil || _f.matchedRule(opt.FoldComparison) {
						_group = result
						_f.mem.AddAltFingerprint(_isExpr.Fingerprint(), _group)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.FoldComparison, _group, 0, 0)
						}
						return _group
					}
				}
			}
		}
	}

	return _f.onConstruct(memo.Expr(_isExpr))
}

// ConstructIsNot constructs an expression for the IsNot operator.
func (_f *Factory) ConstructIsNot(
	left memo.GroupID,
	right memo.GroupID,
) memo.GroupID {
	_isNotExpr := memo.MakeIsNotExpr(left, right)
	_group := _f.mem.GroupByFingerprint(_isNotExpr.Fingerprint())
	if _group != 0 {
		return _group
	}

	// [FoldIsNotNull]
	{
		_nullExpr := _f.mem.NormExpr(left).AsNull()
		if _nullExpr != nil {
			_nullExpr2 := _f.mem.NormExpr(right).AsNull()
			if _nullExpr2 != nil {
				if _f.matchedRule == nil || _f.matchedRule(opt.FoldIsNotNull) {
					_group = _f.ConstructFalse()
					_f.mem.AddAltFingerprint(_isNotExpr.Fingerprint(), _group)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.FoldIsNotNull, _group, 0, 0)
					}
					return _group
				}
			}
		}
	}

	// [FoldNonNullIsNotNull]
	{
		_nullExpr := _f.mem.NormExpr(left).AsNull()
		if _nullExpr == nil {
			if _f.funcs.IsConstValueOrTuple(left) {
				_nullExpr2 := _f.mem.NormExpr(right).AsNull()
				if _nullExpr2 != nil {
					if _f.matchedRule == nil || _f.matchedRule(opt.FoldNonNullIsNotNull) {
						_group = _f.ConstructTrue()
						_f.mem.AddAltFingerprint(_isNotExpr.Fingerprint(), _group)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.FoldNonNullIsNotNull, _group, 0, 0)
						}
						return _group
					}
				}
			}
		}
	}

	// [CommuteNullIs]
	{
		_nullExpr := _f.mem.NormExpr(left).AsNull()
		if _nullExpr != nil {
			_nullExpr2 := _f.mem.NormExpr(right).AsNull()
			if _nullExpr2 == nil {
				if _f.matchedRule == nil || _f.matchedRule(opt.CommuteNullIs) {
					_group = _f.ConstructIsNot(
						right,
						left,
					)
					_f.mem.AddAltFingerprint(_isNotExpr.Fingerprint(), _group)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.CommuteNullIs, _group, 0, 0)
					}
					return _group
				}
			}
		}
	}

	// [CommuteVar]
	{
		_variableExpr := _f.mem.NormExpr(left).AsVariable()
		if _variableExpr == nil {
			_variableExpr2 := _f.mem.NormExpr(right).AsVariable()
			if _variableExpr2 != nil {
				if _f.matchedRule == nil || _f.matchedRule(opt.CommuteVar) {
					_group = _f.ConstructIsNot(
						right,
						left,
					)
					_f.mem.AddAltFingerprint(_isNotExpr.Fingerprint(), _group)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.CommuteVar, _group, 0, 0)
					}
					return _group
				}
			}
		}
	}

	// [CommuteConst]
	{
		if _f.funcs.OnlyConstants(left) {
			if !_f.funcs.OnlyConstants(right) {
				if _f.matchedRule == nil || _f.matchedRule(opt.CommuteConst) {
					_group = _f.ConstructIsNot(
						right,
						left,
					)
					_f.mem.AddAltFingerprint(_isNotExpr.Fingerprint(), _group)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.CommuteConst, _group, 0, 0)
					}
					return _group
				}
			}
		}
	}

	// [UnifyComparisonTypes]
	{
		_variableExpr := _f.mem.NormExpr(left).AsVariable()
		if _variableExpr != nil {
			_constExpr := _f.mem.NormExpr(right).AsConst()
			if _constExpr != nil {
				result := _f.funcs.UnifyComparison(left, right)
				if _f.funcs.Succeeded(result) {
					if _f.matchedRule == nil || _f.matchedRule(opt.UnifyComparisonTypes) {
						_group = _f.ConstructIsNot(
							left,
							result,
						)
						_f.mem.AddAltFingerprint(_isNotExpr.Fingerprint(), _group)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.UnifyComparisonTypes, _group, 0, 0)
						}
						return _group
					}
				}
			}
		}
	}

	// [FoldComparison]
	{
		if _f.funcs.IsConstValueOrTuple(left) {
			if _f.funcs.IsConstValueOrTuple(right) {
				result := _f.funcs.FoldComparison(opt.IsNotOp, left, right)
				if _f.funcs.Succeeded(result) {
					if _f.matchedRule == nil || _f.matchedRule(opt.FoldComparison) {
						_group = result
						_f.mem.AddAltFingerprint(_isNotExpr.Fingerprint(), _group)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.FoldComparison, _group, 0, 0)
						}
						return _group
					}
				}
			}
		}
	}

	return _f.onConstruct(memo.Expr(_isNotExpr))
}

// ConstructContains constructs an expression for the Contains operator.
func (_f *Factory) ConstructContains(
	left memo.GroupID,
	right memo.GroupID,
) memo.GroupID {
	_containsExpr := memo.MakeContainsExpr(left, right)
	_group := _f.mem.GroupByFingerprint(_containsExpr.Fingerprint())
	if _group != 0 {
		return _group
	}

	// [FoldNullComparisonLeft]
	{
		_nullExpr := _f.mem.NormExpr(left).AsNull()
		if _nullExpr != nil {
			if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullComparisonLeft) {
				_group = _f.ConstructNull(
					_f.funcs.BoolType(),
				)
				_f.mem.AddAltFingerprint(_containsExpr.Fingerprint(), _group)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.FoldNullComparisonLeft, _group, 0, 0)
				}
				return _group
			}
		}
	}

	// [FoldNullComparisonRight]
	{
		_nullExpr := _f.mem.NormExpr(right).AsNull()
		if _nullExpr != nil {
			if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullComparisonRight) {
				_group = _f.ConstructNull(
					_f.funcs.BoolType(),
				)
				_f.mem.AddAltFingerprint(_containsExpr.Fingerprint(), _group)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.FoldNullComparisonRight, _group, 0, 0)
				}
				return _group
			}
		}
	}

	// [UnifyComparisonTypes]
	{
		_variableExpr := _f.mem.NormExpr(left).AsVariable()
		if _variableExpr != nil {
			_constExpr := _f.mem.NormExpr(right).AsConst()
			if _constExpr != nil {
				result := _f.funcs.UnifyComparison(left, right)
				if _f.funcs.Succeeded(result) {
					if _f.matchedRule == nil || _f.matchedRule(opt.UnifyComparisonTypes) {
						_group = _f.ConstructContains(
							left,
							result,
						)
						_f.mem.AddAltFingerprint(_containsExpr.Fingerprint(), _group)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.UnifyComparisonTypes, _group, 0, 0)
						}
						return _group
					}
				}
			}
		}
	}

	// [NormalizeJSONContains]
	{
		_fetchValExpr := _f.mem.NormExpr(left).AsFetchVal()
		if _fetchValExpr != nil {
			val := _fetchValExpr.Json()
			key := _fetchValExpr.Index()
			_constExpr := _f.mem.NormExpr(_fetchValExpr.Index()).AsConst()
			if _constExpr != nil {
				if _f.funcs.IsString(key) {
					_constExpr2 := _f.mem.NormExpr(right).AsConst()
					if _constExpr2 != nil {
						if !_f.funcs.IsJSONScalar(right) {
							if _f.matchedRule == nil || _f.matchedRule(opt.NormalizeJSONContains) {
								_group = _f.ConstructContains(
									val,
									_f.funcs.MakeSingleKeyJSONObject(key, right),
								)
								_f.mem.AddAltFingerprint(_containsExpr.Fingerprint(), _group)
								if _f.appliedRule != nil {
									_f.appliedRule(opt.NormalizeJSONContains, _group, 0, 0)
								}
								return _group
							}
						}
					}
				}
			}
		}
	}

	// [FoldComparison]
	{
		if _f.funcs.IsConstValueOrTuple(left) {
			if _f.funcs.IsConstValueOrTuple(right) {
				result := _f.funcs.FoldComparison(opt.ContainsOp, left, right)
				if _f.funcs.Succeeded(result) {
					if _f.matchedRule == nil || _f.matchedRule(opt.FoldComparison) {
						_group = result
						_f.mem.AddAltFingerprint(_containsExpr.Fingerprint(), _group)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.FoldComparison, _group, 0, 0)
						}
						return _group
					}
				}
			}
		}
	}

	return _f.onConstruct(memo.Expr(_containsExpr))
}

// ConstructJsonExists constructs an expression for the JsonExists operator.
func (_f *Factory) ConstructJsonExists(
	left memo.GroupID,
	right memo.GroupID,
) memo.GroupID {
	_jsonExistsExpr := memo.MakeJsonExistsExpr(left, right)
	_group := _f.mem.GroupByFingerprint(_jsonExistsExpr.Fingerprint())
	if _group != 0 {
		return _group
	}

	// [FoldNullComparisonLeft]
	{
		_nullExpr := _f.mem.NormExpr(left).AsNull()
		if _nullExpr != nil {
			if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullComparisonLeft) {
				_group = _f.ConstructNull(
					_f.funcs.BoolType(),
				)
				_f.mem.AddAltFingerprint(_jsonExistsExpr.Fingerprint(), _group)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.FoldNullComparisonLeft, _group, 0, 0)
				}
				return _group
			}
		}
	}

	// [FoldNullComparisonRight]
	{
		_nullExpr := _f.mem.NormExpr(right).AsNull()
		if _nullExpr != nil {
			if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullComparisonRight) {
				_group = _f.ConstructNull(
					_f.funcs.BoolType(),
				)
				_f.mem.AddAltFingerprint(_jsonExistsExpr.Fingerprint(), _group)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.FoldNullComparisonRight, _group, 0, 0)
				}
				return _group
			}
		}
	}

	// [UnifyComparisonTypes]
	{
		_variableExpr := _f.mem.NormExpr(left).AsVariable()
		if _variableExpr != nil {
			_constExpr := _f.mem.NormExpr(right).AsConst()
			if _constExpr != nil {
				result := _f.funcs.UnifyComparison(left, right)
				if _f.funcs.Succeeded(result) {
					if _f.matchedRule == nil || _f.matchedRule(opt.UnifyComparisonTypes) {
						_group = _f.ConstructJsonExists(
							left,
							result,
						)
						_f.mem.AddAltFingerprint(_jsonExistsExpr.Fingerprint(), _group)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.UnifyComparisonTypes, _group, 0, 0)
						}
						return _group
					}
				}
			}
		}
	}

	// [FoldComparison]
	{
		if _f.funcs.IsConstValueOrTuple(left) {
			if _f.funcs.IsConstValueOrTuple(right) {
				result := _f.funcs.FoldComparison(opt.JsonExistsOp, left, right)
				if _f.funcs.Succeeded(result) {
					if _f.matchedRule == nil || _f.matchedRule(opt.FoldComparison) {
						_group = result
						_f.mem.AddAltFingerprint(_jsonExistsExpr.Fingerprint(), _group)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.FoldComparison, _group, 0, 0)
						}
						return _group
					}
				}
			}
		}
	}

	return _f.onConstruct(memo.Expr(_jsonExistsExpr))
}

// ConstructJsonAllExists constructs an expression for the JsonAllExists operator.
func (_f *Factory) ConstructJsonAllExists(
	left memo.GroupID,
	right memo.GroupID,
) memo.GroupID {
	_jsonAllExistsExpr := memo.MakeJsonAllExistsExpr(left, right)
	_group := _f.mem.GroupByFingerprint(_jsonAllExistsExpr.Fingerprint())
	if _group != 0 {
		return _group
	}

	// [FoldNullComparisonLeft]
	{
		_nullExpr := _f.mem.NormExpr(left).AsNull()
		if _nullExpr != nil {
			if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullComparisonLeft) {
				_group = _f.ConstructNull(
					_f.funcs.BoolType(),
				)
				_f.mem.AddAltFingerprint(_jsonAllExistsExpr.Fingerprint(), _group)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.FoldNullComparisonLeft, _group, 0, 0)
				}
				return _group
			}
		}
	}

	// [FoldNullComparisonRight]
	{
		_nullExpr := _f.mem.NormExpr(right).AsNull()
		if _nullExpr != nil {
			if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullComparisonRight) {
				_group = _f.ConstructNull(
					_f.funcs.BoolType(),
				)
				_f.mem.AddAltFingerprint(_jsonAllExistsExpr.Fingerprint(), _group)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.FoldNullComparisonRight, _group, 0, 0)
				}
				return _group
			}
		}
	}

	// [UnifyComparisonTypes]
	{
		_variableExpr := _f.mem.NormExpr(left).AsVariable()
		if _variableExpr != nil {
			_constExpr := _f.mem.NormExpr(right).AsConst()
			if _constExpr != nil {
				result := _f.funcs.UnifyComparison(left, right)
				if _f.funcs.Succeeded(result) {
					if _f.matchedRule == nil || _f.matchedRule(opt.UnifyComparisonTypes) {
						_group = _f.ConstructJsonAllExists(
							left,
							result,
						)
						_f.mem.AddAltFingerprint(_jsonAllExistsExpr.Fingerprint(), _group)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.UnifyComparisonTypes, _group, 0, 0)
						}
						return _group
					}
				}
			}
		}
	}

	// [FoldComparison]
	{
		if _f.funcs.IsConstValueOrTuple(left) {
			if _f.funcs.IsConstValueOrTuple(right) {
				result := _f.funcs.FoldComparison(opt.JsonAllExistsOp, left, right)
				if _f.funcs.Succeeded(result) {
					if _f.matchedRule == nil || _f.matchedRule(opt.FoldComparison) {
						_group = result
						_f.mem.AddAltFingerprint(_jsonAllExistsExpr.Fingerprint(), _group)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.FoldComparison, _group, 0, 0)
						}
						return _group
					}
				}
			}
		}
	}

	return _f.onConstruct(memo.Expr(_jsonAllExistsExpr))
}

// ConstructJsonSomeExists constructs an expression for the JsonSomeExists operator.
func (_f *Factory) ConstructJsonSomeExists(
	left memo.GroupID,
	right memo.GroupID,
) memo.GroupID {
	_jsonSomeExistsExpr := memo.MakeJsonSomeExistsExpr(left, right)
	_group := _f.mem.GroupByFingerprint(_jsonSomeExistsExpr.Fingerprint())
	if _group != 0 {
		return _group
	}

	// [FoldNullComparisonLeft]
	{
		_nullExpr := _f.mem.NormExpr(left).AsNull()
		if _nullExpr != nil {
			if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullComparisonLeft) {
				_group = _f.ConstructNull(
					_f.funcs.BoolType(),
				)
				_f.mem.AddAltFingerprint(_jsonSomeExistsExpr.Fingerprint(), _group)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.FoldNullComparisonLeft, _group, 0, 0)
				}
				return _group
			}
		}
	}

	// [FoldNullComparisonRight]
	{
		_nullExpr := _f.mem.NormExpr(right).AsNull()
		if _nullExpr != nil {
			if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullComparisonRight) {
				_group = _f.ConstructNull(
					_f.funcs.BoolType(),
				)
				_f.mem.AddAltFingerprint(_jsonSomeExistsExpr.Fingerprint(), _group)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.FoldNullComparisonRight, _group, 0, 0)
				}
				return _group
			}
		}
	}

	// [UnifyComparisonTypes]
	{
		_variableExpr := _f.mem.NormExpr(left).AsVariable()
		if _variableExpr != nil {
			_constExpr := _f.mem.NormExpr(right).AsConst()
			if _constExpr != nil {
				result := _f.funcs.UnifyComparison(left, right)
				if _f.funcs.Succeeded(result) {
					if _f.matchedRule == nil || _f.matchedRule(opt.UnifyComparisonTypes) {
						_group = _f.ConstructJsonSomeExists(
							left,
							result,
						)
						_f.mem.AddAltFingerprint(_jsonSomeExistsExpr.Fingerprint(), _group)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.UnifyComparisonTypes, _group, 0, 0)
						}
						return _group
					}
				}
			}
		}
	}

	// [FoldComparison]
	{
		if _f.funcs.IsConstValueOrTuple(left) {
			if _f.funcs.IsConstValueOrTuple(right) {
				result := _f.funcs.FoldComparison(opt.JsonSomeExistsOp, left, right)
				if _f.funcs.Succeeded(result) {
					if _f.matchedRule == nil || _f.matchedRule(opt.FoldComparison) {
						_group = result
						_f.mem.AddAltFingerprint(_jsonSomeExistsExpr.Fingerprint(), _group)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.FoldComparison, _group, 0, 0)
						}
						return _group
					}
				}
			}
		}
	}

	return _f.onConstruct(memo.Expr(_jsonSomeExistsExpr))
}

// ConstructAnyScalar constructs an expression for the AnyScalar operator.
// AnyScalar is the form of ANY which refers to an ANY operation on a
// tuple or array, as opposed to Any which operates on a subquery.
func (_f *Factory) ConstructAnyScalar(
	left memo.GroupID,
	right memo.GroupID,
	cmp memo.PrivateID,
) memo.GroupID {
	_anyScalarExpr := memo.MakeAnyScalarExpr(left, right, cmp)
	_group := _f.mem.GroupByFingerprint(_anyScalarExpr.Fingerprint())
	if _group != 0 {
		return _group
	}

	// [SimplifyEqualsAnyTuple]
	{
		input := left
		tuple := right
		_tupleExpr := _f.mem.NormExpr(right).AsTuple()
		if _tupleExpr != nil {
			if _f.funcs.IsEquality(cmp) {
				if _f.matchedRule == nil || _f.matchedRule(opt.SimplifyEqualsAnyTuple) {
					_group = _f.ConstructIn(
						input,
						tuple,
					)
					_f.mem.AddAltFingerprint(_anyScalarExpr.Fingerprint(), _group)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.SimplifyEqualsAnyTuple, _group, 0, 0)
					}
					return _group
				}
			}
		}
	}

	// [SimplifyAnyScalarArray]
	{
		input := left
		ary := right
		_constExpr := _f.mem.NormExpr(right).AsConst()
		if _constExpr != nil {
			if _f.funcs.IsArray(ary) {
				if _f.matchedRule == nil || _f.matchedRule(opt.SimplifyAnyScalarArray) {
					_group = _f.ConstructAnyScalar(
						input,
						_f.funcs.ConvertConstArrayToTuple(ary),
						cmp,
					)
					_f.mem.AddAltFingerprint(_anyScalarExpr.Fingerprint(), _group)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.SimplifyAnyScalarArray, _group, 0, 0)
					}
					return _group
				}
			}
		}
	}

	return _f.onConstruct(memo.Expr(_anyScalarExpr))
}

// ConstructBitand constructs an expression for the Bitand operator.
func (_f *Factory) ConstructBitand(
	left memo.GroupID,
	right memo.GroupID,
) memo.GroupID {
	_bitandExpr := memo.MakeBitandExpr(left, right)
	_group := _f.mem.GroupByFingerprint(_bitandExpr.Fingerprint())
	if _group != 0 {
		return _group
	}

	// [CommuteVar]
	{
		_variableExpr := _f.mem.NormExpr(left).AsVariable()
		if _variableExpr == nil {
			_variableExpr2 := _f.mem.NormExpr(right).AsVariable()
			if _variableExpr2 != nil {
				if _f.matchedRule == nil || _f.matchedRule(opt.CommuteVar) {
					_group = _f.ConstructBitand(
						right,
						left,
					)
					_f.mem.AddAltFingerprint(_bitandExpr.Fingerprint(), _group)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.CommuteVar, _group, 0, 0)
					}
					return _group
				}
			}
		}
	}

	// [CommuteConst]
	{
		if _f.funcs.OnlyConstants(left) {
			if !_f.funcs.OnlyConstants(right) {
				if _f.matchedRule == nil || _f.matchedRule(opt.CommuteConst) {
					_group = _f.ConstructBitand(
						right,
						left,
					)
					_f.mem.AddAltFingerprint(_bitandExpr.Fingerprint(), _group)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.CommuteConst, _group, 0, 0)
					}
					return _group
				}
			}
		}
	}

	// [FoldNullBinaryLeft]
	{
		_nullExpr := _f.mem.NormExpr(left).AsNull()
		if _nullExpr != nil {
			if !_f.funcs.AllowNullArgs(opt.BitandOp, left, right) {
				if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullBinaryLeft) {
					_group = _f.funcs.FoldNullBinary(opt.BitandOp, left, right)
					_f.mem.AddAltFingerprint(_bitandExpr.Fingerprint(), _group)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.FoldNullBinaryLeft, _group, 0, 0)
					}
					return _group
				}
			}
		}
	}

	// [FoldNullBinaryRight]
	{
		_nullExpr := _f.mem.NormExpr(right).AsNull()
		if _nullExpr != nil {
			if !_f.funcs.AllowNullArgs(opt.BitandOp, left, right) {
				if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullBinaryRight) {
					_group = _f.funcs.FoldNullBinary(opt.BitandOp, left, right)
					_f.mem.AddAltFingerprint(_bitandExpr.Fingerprint(), _group)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.FoldNullBinaryRight, _group, 0, 0)
					}
					return _group
				}
			}
		}
	}

	// [FoldBinary]
	{
		if _f.funcs.IsConstValueOrTuple(left) {
			if _f.funcs.IsConstValueOrTuple(right) {
				result := _f.funcs.FoldBinary(opt.BitandOp, left, right)
				if _f.funcs.Succeeded(result) {
					if _f.matchedRule == nil || _f.matchedRule(opt.FoldBinary) {
						_group = result
						_f.mem.AddAltFingerprint(_bitandExpr.Fingerprint(), _group)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.FoldBinary, _group, 0, 0)
						}
						return _group
					}
				}
			}
		}
	}

	return _f.onConstruct(memo.Expr(_bitandExpr))
}

// ConstructBitor constructs an expression for the Bitor operator.
func (_f *Factory) ConstructBitor(
	left memo.GroupID,
	right memo.GroupID,
) memo.GroupID {
	_bitorExpr := memo.MakeBitorExpr(left, right)
	_group := _f.mem.GroupByFingerprint(_bitorExpr.Fingerprint())
	if _group != 0 {
		return _group
	}

	// [CommuteVar]
	{
		_variableExpr := _f.mem.NormExpr(left).AsVariable()
		if _variableExpr == nil {
			_variableExpr2 := _f.mem.NormExpr(right).AsVariable()
			if _variableExpr2 != nil {
				if _f.matchedRule == nil || _f.matchedRule(opt.CommuteVar) {
					_group = _f.ConstructBitor(
						right,
						left,
					)
					_f.mem.AddAltFingerprint(_bitorExpr.Fingerprint(), _group)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.CommuteVar, _group, 0, 0)
					}
					return _group
				}
			}
		}
	}

	// [CommuteConst]
	{
		if _f.funcs.OnlyConstants(left) {
			if !_f.funcs.OnlyConstants(right) {
				if _f.matchedRule == nil || _f.matchedRule(opt.CommuteConst) {
					_group = _f.ConstructBitor(
						right,
						left,
					)
					_f.mem.AddAltFingerprint(_bitorExpr.Fingerprint(), _group)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.CommuteConst, _group, 0, 0)
					}
					return _group
				}
			}
		}
	}

	// [FoldNullBinaryLeft]
	{
		_nullExpr := _f.mem.NormExpr(left).AsNull()
		if _nullExpr != nil {
			if !_f.funcs.AllowNullArgs(opt.BitorOp, left, right) {
				if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullBinaryLeft) {
					_group = _f.funcs.FoldNullBinary(opt.BitorOp, left, right)
					_f.mem.AddAltFingerprint(_bitorExpr.Fingerprint(), _group)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.FoldNullBinaryLeft, _group, 0, 0)
					}
					return _group
				}
			}
		}
	}

	// [FoldNullBinaryRight]
	{
		_nullExpr := _f.mem.NormExpr(right).AsNull()
		if _nullExpr != nil {
			if !_f.funcs.AllowNullArgs(opt.BitorOp, left, right) {
				if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullBinaryRight) {
					_group = _f.funcs.FoldNullBinary(opt.BitorOp, left, right)
					_f.mem.AddAltFingerprint(_bitorExpr.Fingerprint(), _group)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.FoldNullBinaryRight, _group, 0, 0)
					}
					return _group
				}
			}
		}
	}

	// [FoldBinary]
	{
		if _f.funcs.IsConstValueOrTuple(left) {
			if _f.funcs.IsConstValueOrTuple(right) {
				result := _f.funcs.FoldBinary(opt.BitorOp, left, right)
				if _f.funcs.Succeeded(result) {
					if _f.matchedRule == nil || _f.matchedRule(opt.FoldBinary) {
						_group = result
						_f.mem.AddAltFingerprint(_bitorExpr.Fingerprint(), _group)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.FoldBinary, _group, 0, 0)
						}
						return _group
					}
				}
			}
		}
	}

	return _f.onConstruct(memo.Expr(_bitorExpr))
}

// ConstructBitxor constructs an expression for the Bitxor operator.
func (_f *Factory) ConstructBitxor(
	left memo.GroupID,
	right memo.GroupID,
) memo.GroupID {
	_bitxorExpr := memo.MakeBitxorExpr(left, right)
	_group := _f.mem.GroupByFingerprint(_bitxorExpr.Fingerprint())
	if _group != 0 {
		return _group
	}

	// [CommuteVar]
	{
		_variableExpr := _f.mem.NormExpr(left).AsVariable()
		if _variableExpr == nil {
			_variableExpr2 := _f.mem.NormExpr(right).AsVariable()
			if _variableExpr2 != nil {
				if _f.matchedRule == nil || _f.matchedRule(opt.CommuteVar) {
					_group = _f.ConstructBitxor(
						right,
						left,
					)
					_f.mem.AddAltFingerprint(_bitxorExpr.Fingerprint(), _group)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.CommuteVar, _group, 0, 0)
					}
					return _group
				}
			}
		}
	}

	// [CommuteConst]
	{
		if _f.funcs.OnlyConstants(left) {
			if !_f.funcs.OnlyConstants(right) {
				if _f.matchedRule == nil || _f.matchedRule(opt.CommuteConst) {
					_group = _f.ConstructBitxor(
						right,
						left,
					)
					_f.mem.AddAltFingerprint(_bitxorExpr.Fingerprint(), _group)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.CommuteConst, _group, 0, 0)
					}
					return _group
				}
			}
		}
	}

	// [FoldNullBinaryLeft]
	{
		_nullExpr := _f.mem.NormExpr(left).AsNull()
		if _nullExpr != nil {
			if !_f.funcs.AllowNullArgs(opt.BitxorOp, left, right) {
				if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullBinaryLeft) {
					_group = _f.funcs.FoldNullBinary(opt.BitxorOp, left, right)
					_f.mem.AddAltFingerprint(_bitxorExpr.Fingerprint(), _group)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.FoldNullBinaryLeft, _group, 0, 0)
					}
					return _group
				}
			}
		}
	}

	// [FoldNullBinaryRight]
	{
		_nullExpr := _f.mem.NormExpr(right).AsNull()
		if _nullExpr != nil {
			if !_f.funcs.AllowNullArgs(opt.BitxorOp, left, right) {
				if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullBinaryRight) {
					_group = _f.funcs.FoldNullBinary(opt.BitxorOp, left, right)
					_f.mem.AddAltFingerprint(_bitxorExpr.Fingerprint(), _group)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.FoldNullBinaryRight, _group, 0, 0)
					}
					return _group
				}
			}
		}
	}

	// [FoldBinary]
	{
		if _f.funcs.IsConstValueOrTuple(left) {
			if _f.funcs.IsConstValueOrTuple(right) {
				result := _f.funcs.FoldBinary(opt.BitxorOp, left, right)
				if _f.funcs.Succeeded(result) {
					if _f.matchedRule == nil || _f.matchedRule(opt.FoldBinary) {
						_group = result
						_f.mem.AddAltFingerprint(_bitxorExpr.Fingerprint(), _group)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.FoldBinary, _group, 0, 0)
						}
						return _group
					}
				}
			}
		}
	}

	return _f.onConstruct(memo.Expr(_bitxorExpr))
}

// ConstructPlus constructs an expression for the Plus operator.
func (_f *Factory) ConstructPlus(
	left memo.GroupID,
	right memo.GroupID,
) memo.GroupID {
	_plusExpr := memo.MakePlusExpr(left, right)
	_group := _f.mem.GroupByFingerprint(_plusExpr.Fingerprint())
	if _group != 0 {
		return _group
	}

	// [FoldPlusZero]
	{
		_constExpr := _f.mem.NormExpr(right).AsConst()
		if _constExpr != nil {
			if _f.funcs.EqualsNumber(_constExpr.Value(), 0) {
				if _f.matchedRule == nil || _f.matchedRule(opt.FoldPlusZero) {
					_group = left
					_f.mem.AddAltFingerprint(_plusExpr.Fingerprint(), _group)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.FoldPlusZero, _group, 0, 0)
					}
					return _group
				}
			}
		}
	}

	// [FoldZeroPlus]
	{
		_constExpr := _f.mem.NormExpr(left).AsConst()
		if _constExpr != nil {
			if _f.funcs.EqualsNumber(_constExpr.Value(), 0) {
				if _f.matchedRule == nil || _f.matchedRule(opt.FoldZeroPlus) {
					_group = right
					_f.mem.AddAltFingerprint(_plusExpr.Fingerprint(), _group)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.FoldZeroPlus, _group, 0, 0)
					}
					return _group
				}
			}
		}
	}

	// [CommuteVar]
	{
		_variableExpr := _f.mem.NormExpr(left).AsVariable()
		if _variableExpr == nil {
			_variableExpr2 := _f.mem.NormExpr(right).AsVariable()
			if _variableExpr2 != nil {
				if _f.matchedRule == nil || _f.matchedRule(opt.CommuteVar) {
					_group = _f.ConstructPlus(
						right,
						left,
					)
					_f.mem.AddAltFingerprint(_plusExpr.Fingerprint(), _group)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.CommuteVar, _group, 0, 0)
					}
					return _group
				}
			}
		}
	}

	// [CommuteConst]
	{
		if _f.funcs.OnlyConstants(left) {
			if !_f.funcs.OnlyConstants(right) {
				if _f.matchedRule == nil || _f.matchedRule(opt.CommuteConst) {
					_group = _f.ConstructPlus(
						right,
						left,
					)
					_f.mem.AddAltFingerprint(_plusExpr.Fingerprint(), _group)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.CommuteConst, _group, 0, 0)
					}
					return _group
				}
			}
		}
	}

	// [FoldNullBinaryLeft]
	{
		_nullExpr := _f.mem.NormExpr(left).AsNull()
		if _nullExpr != nil {
			if !_f.funcs.AllowNullArgs(opt.PlusOp, left, right) {
				if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullBinaryLeft) {
					_group = _f.funcs.FoldNullBinary(opt.PlusOp, left, right)
					_f.mem.AddAltFingerprint(_plusExpr.Fingerprint(), _group)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.FoldNullBinaryLeft, _group, 0, 0)
					}
					return _group
				}
			}
		}
	}

	// [FoldNullBinaryRight]
	{
		_nullExpr := _f.mem.NormExpr(right).AsNull()
		if _nullExpr != nil {
			if !_f.funcs.AllowNullArgs(opt.PlusOp, left, right) {
				if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullBinaryRight) {
					_group = _f.funcs.FoldNullBinary(opt.PlusOp, left, right)
					_f.mem.AddAltFingerprint(_plusExpr.Fingerprint(), _group)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.FoldNullBinaryRight, _group, 0, 0)
					}
					return _group
				}
			}
		}
	}

	// [FoldBinary]
	{
		if _f.funcs.IsConstValueOrTuple(left) {
			if _f.funcs.IsConstValueOrTuple(right) {
				result := _f.funcs.FoldBinary(opt.PlusOp, left, right)
				if _f.funcs.Succeeded(result) {
					if _f.matchedRule == nil || _f.matchedRule(opt.FoldBinary) {
						_group = result
						_f.mem.AddAltFingerprint(_plusExpr.Fingerprint(), _group)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.FoldBinary, _group, 0, 0)
						}
						return _group
					}
				}
			}
		}
	}

	return _f.onConstruct(memo.Expr(_plusExpr))
}

// ConstructMinus constructs an expression for the Minus operator.
func (_f *Factory) ConstructMinus(
	left memo.GroupID,
	right memo.GroupID,
) memo.GroupID {
	_minusExpr := memo.MakeMinusExpr(left, right)
	_group := _f.mem.GroupByFingerprint(_minusExpr.Fingerprint())
	if _group != 0 {
		return _group
	}

	// [FoldMinusZero]
	{
		_constExpr := _f.mem.NormExpr(right).AsConst()
		if _constExpr != nil {
			if _f.funcs.EqualsNumber(_constExpr.Value(), 0) {
				if _f.matchedRule == nil || _f.matchedRule(opt.FoldMinusZero) {
					_group = left
					_f.mem.AddAltFingerprint(_minusExpr.Fingerprint(), _group)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.FoldMinusZero, _group, 0, 0)
					}
					return _group
				}
			}
		}
	}

	// [FoldNullBinaryLeft]
	{
		_nullExpr := _f.mem.NormExpr(left).AsNull()
		if _nullExpr != nil {
			if !_f.funcs.AllowNullArgs(opt.MinusOp, left, right) {
				if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullBinaryLeft) {
					_group = _f.funcs.FoldNullBinary(opt.MinusOp, left, right)
					_f.mem.AddAltFingerprint(_minusExpr.Fingerprint(), _group)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.FoldNullBinaryLeft, _group, 0, 0)
					}
					return _group
				}
			}
		}
	}

	// [FoldNullBinaryRight]
	{
		_nullExpr := _f.mem.NormExpr(right).AsNull()
		if _nullExpr != nil {
			if !_f.funcs.AllowNullArgs(opt.MinusOp, left, right) {
				if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullBinaryRight) {
					_group = _f.funcs.FoldNullBinary(opt.MinusOp, left, right)
					_f.mem.AddAltFingerprint(_minusExpr.Fingerprint(), _group)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.FoldNullBinaryRight, _group, 0, 0)
					}
					return _group
				}
			}
		}
	}

	// [FoldBinary]
	{
		if _f.funcs.IsConstValueOrTuple(left) {
			if _f.funcs.IsConstValueOrTuple(right) {
				result := _f.funcs.FoldBinary(opt.MinusOp, left, right)
				if _f.funcs.Succeeded(result) {
					if _f.matchedRule == nil || _f.matchedRule(opt.FoldBinary) {
						_group = result
						_f.mem.AddAltFingerprint(_minusExpr.Fingerprint(), _group)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.FoldBinary, _group, 0, 0)
						}
						return _group
					}
				}
			}
		}
	}

	return _f.onConstruct(memo.Expr(_minusExpr))
}

// ConstructMult constructs an expression for the Mult operator.
func (_f *Factory) ConstructMult(
	left memo.GroupID,
	right memo.GroupID,
) memo.GroupID {
	_multExpr := memo.MakeMultExpr(left, right)
	_group := _f.mem.GroupByFingerprint(_multExpr.Fingerprint())
	if _group != 0 {
		return _group
	}

	// [FoldMultOne]
	{
		_constExpr := _f.mem.NormExpr(right).AsConst()
		if _constExpr != nil {
			if _f.funcs.EqualsNumber(_constExpr.Value(), 1) {
				if _f.matchedRule == nil || _f.matchedRule(opt.FoldMultOne) {
					_group = left
					_f.mem.AddAltFingerprint(_multExpr.Fingerprint(), _group)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.FoldMultOne, _group, 0, 0)
					}
					return _group
				}
			}
		}
	}

	// [FoldOneMult]
	{
		_constExpr := _f.mem.NormExpr(left).AsConst()
		if _constExpr != nil {
			if _f.funcs.EqualsNumber(_constExpr.Value(), 1) {
				if _f.matchedRule == nil || _f.matchedRule(opt.FoldOneMult) {
					_group = right
					_f.mem.AddAltFingerprint(_multExpr.Fingerprint(), _group)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.FoldOneMult, _group, 0, 0)
					}
					return _group
				}
			}
		}
	}

	// [CommuteVar]
	{
		_variableExpr := _f.mem.NormExpr(left).AsVariable()
		if _variableExpr == nil {
			_variableExpr2 := _f.mem.NormExpr(right).AsVariable()
			if _variableExpr2 != nil {
				if _f.matchedRule == nil || _f.matchedRule(opt.CommuteVar) {
					_group = _f.ConstructMult(
						right,
						left,
					)
					_f.mem.AddAltFingerprint(_multExpr.Fingerprint(), _group)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.CommuteVar, _group, 0, 0)
					}
					return _group
				}
			}
		}
	}

	// [CommuteConst]
	{
		if _f.funcs.OnlyConstants(left) {
			if !_f.funcs.OnlyConstants(right) {
				if _f.matchedRule == nil || _f.matchedRule(opt.CommuteConst) {
					_group = _f.ConstructMult(
						right,
						left,
					)
					_f.mem.AddAltFingerprint(_multExpr.Fingerprint(), _group)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.CommuteConst, _group, 0, 0)
					}
					return _group
				}
			}
		}
	}

	// [FoldNullBinaryLeft]
	{
		_nullExpr := _f.mem.NormExpr(left).AsNull()
		if _nullExpr != nil {
			if !_f.funcs.AllowNullArgs(opt.MultOp, left, right) {
				if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullBinaryLeft) {
					_group = _f.funcs.FoldNullBinary(opt.MultOp, left, right)
					_f.mem.AddAltFingerprint(_multExpr.Fingerprint(), _group)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.FoldNullBinaryLeft, _group, 0, 0)
					}
					return _group
				}
			}
		}
	}

	// [FoldNullBinaryRight]
	{
		_nullExpr := _f.mem.NormExpr(right).AsNull()
		if _nullExpr != nil {
			if !_f.funcs.AllowNullArgs(opt.MultOp, left, right) {
				if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullBinaryRight) {
					_group = _f.funcs.FoldNullBinary(opt.MultOp, left, right)
					_f.mem.AddAltFingerprint(_multExpr.Fingerprint(), _group)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.FoldNullBinaryRight, _group, 0, 0)
					}
					return _group
				}
			}
		}
	}

	// [FoldBinary]
	{
		if _f.funcs.IsConstValueOrTuple(left) {
			if _f.funcs.IsConstValueOrTuple(right) {
				result := _f.funcs.FoldBinary(opt.MultOp, left, right)
				if _f.funcs.Succeeded(result) {
					if _f.matchedRule == nil || _f.matchedRule(opt.FoldBinary) {
						_group = result
						_f.mem.AddAltFingerprint(_multExpr.Fingerprint(), _group)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.FoldBinary, _group, 0, 0)
						}
						return _group
					}
				}
			}
		}
	}

	return _f.onConstruct(memo.Expr(_multExpr))
}

// ConstructDiv constructs an expression for the Div operator.
func (_f *Factory) ConstructDiv(
	left memo.GroupID,
	right memo.GroupID,
) memo.GroupID {
	_divExpr := memo.MakeDivExpr(left, right)
	_group := _f.mem.GroupByFingerprint(_divExpr.Fingerprint())
	if _group != 0 {
		return _group
	}

	// [FoldDivOne]
	{
		_constExpr := _f.mem.NormExpr(right).AsConst()
		if _constExpr != nil {
			if _f.funcs.EqualsNumber(_constExpr.Value(), 1) {
				if _f.matchedRule == nil || _f.matchedRule(opt.FoldDivOne) {
					_group = left
					_f.mem.AddAltFingerprint(_divExpr.Fingerprint(), _group)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.FoldDivOne, _group, 0, 0)
					}
					return _group
				}
			}
		}
	}

	// [FoldNullBinaryLeft]
	{
		_nullExpr := _f.mem.NormExpr(left).AsNull()
		if _nullExpr != nil {
			if !_f.funcs.AllowNullArgs(opt.DivOp, left, right) {
				if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullBinaryLeft) {
					_group = _f.funcs.FoldNullBinary(opt.DivOp, left, right)
					_f.mem.AddAltFingerprint(_divExpr.Fingerprint(), _group)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.FoldNullBinaryLeft, _group, 0, 0)
					}
					return _group
				}
			}
		}
	}

	// [FoldNullBinaryRight]
	{
		_nullExpr := _f.mem.NormExpr(right).AsNull()
		if _nullExpr != nil {
			if !_f.funcs.AllowNullArgs(opt.DivOp, left, right) {
				if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullBinaryRight) {
					_group = _f.funcs.FoldNullBinary(opt.DivOp, left, right)
					_f.mem.AddAltFingerprint(_divExpr.Fingerprint(), _group)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.FoldNullBinaryRight, _group, 0, 0)
					}
					return _group
				}
			}
		}
	}

	// [FoldBinary]
	{
		if _f.funcs.IsConstValueOrTuple(left) {
			if _f.funcs.IsConstValueOrTuple(right) {
				result := _f.funcs.FoldBinary(opt.DivOp, left, right)
				if _f.funcs.Succeeded(result) {
					if _f.matchedRule == nil || _f.matchedRule(opt.FoldBinary) {
						_group = result
						_f.mem.AddAltFingerprint(_divExpr.Fingerprint(), _group)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.FoldBinary, _group, 0, 0)
						}
						return _group
					}
				}
			}
		}
	}

	return _f.onConstruct(memo.Expr(_divExpr))
}

// ConstructFloorDiv constructs an expression for the FloorDiv operator.
func (_f *Factory) ConstructFloorDiv(
	left memo.GroupID,
	right memo.GroupID,
) memo.GroupID {
	_floorDivExpr := memo.MakeFloorDivExpr(left, right)
	_group := _f.mem.GroupByFingerprint(_floorDivExpr.Fingerprint())
	if _group != 0 {
		return _group
	}

	// [FoldDivOne]
	{
		_constExpr := _f.mem.NormExpr(right).AsConst()
		if _constExpr != nil {
			if _f.funcs.EqualsNumber(_constExpr.Value(), 1) {
				if _f.matchedRule == nil || _f.matchedRule(opt.FoldDivOne) {
					_group = left
					_f.mem.AddAltFingerprint(_floorDivExpr.Fingerprint(), _group)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.FoldDivOne, _group, 0, 0)
					}
					return _group
				}
			}
		}
	}

	// [FoldNullBinaryLeft]
	{
		_nullExpr := _f.mem.NormExpr(left).AsNull()
		if _nullExpr != nil {
			if !_f.funcs.AllowNullArgs(opt.FloorDivOp, left, right) {
				if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullBinaryLeft) {
					_group = _f.funcs.FoldNullBinary(opt.FloorDivOp, left, right)
					_f.mem.AddAltFingerprint(_floorDivExpr.Fingerprint(), _group)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.FoldNullBinaryLeft, _group, 0, 0)
					}
					return _group
				}
			}
		}
	}

	// [FoldNullBinaryRight]
	{
		_nullExpr := _f.mem.NormExpr(right).AsNull()
		if _nullExpr != nil {
			if !_f.funcs.AllowNullArgs(opt.FloorDivOp, left, right) {
				if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullBinaryRight) {
					_group = _f.funcs.FoldNullBinary(opt.FloorDivOp, left, right)
					_f.mem.AddAltFingerprint(_floorDivExpr.Fingerprint(), _group)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.FoldNullBinaryRight, _group, 0, 0)
					}
					return _group
				}
			}
		}
	}

	// [FoldBinary]
	{
		if _f.funcs.IsConstValueOrTuple(left) {
			if _f.funcs.IsConstValueOrTuple(right) {
				result := _f.funcs.FoldBinary(opt.FloorDivOp, left, right)
				if _f.funcs.Succeeded(result) {
					if _f.matchedRule == nil || _f.matchedRule(opt.FoldBinary) {
						_group = result
						_f.mem.AddAltFingerprint(_floorDivExpr.Fingerprint(), _group)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.FoldBinary, _group, 0, 0)
						}
						return _group
					}
				}
			}
		}
	}

	return _f.onConstruct(memo.Expr(_floorDivExpr))
}

// ConstructMod constructs an expression for the Mod operator.
func (_f *Factory) ConstructMod(
	left memo.GroupID,
	right memo.GroupID,
) memo.GroupID {
	_modExpr := memo.MakeModExpr(left, right)
	_group := _f.mem.GroupByFingerprint(_modExpr.Fingerprint())
	if _group != 0 {
		return _group
	}

	// [FoldNullBinaryLeft]
	{
		_nullExpr := _f.mem.NormExpr(left).AsNull()
		if _nullExpr != nil {
			if !_f.funcs.AllowNullArgs(opt.ModOp, left, right) {
				if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullBinaryLeft) {
					_group = _f.funcs.FoldNullBinary(opt.ModOp, left, right)
					_f.mem.AddAltFingerprint(_modExpr.Fingerprint(), _group)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.FoldNullBinaryLeft, _group, 0, 0)
					}
					return _group
				}
			}
		}
	}

	// [FoldNullBinaryRight]
	{
		_nullExpr := _f.mem.NormExpr(right).AsNull()
		if _nullExpr != nil {
			if !_f.funcs.AllowNullArgs(opt.ModOp, left, right) {
				if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullBinaryRight) {
					_group = _f.funcs.FoldNullBinary(opt.ModOp, left, right)
					_f.mem.AddAltFingerprint(_modExpr.Fingerprint(), _group)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.FoldNullBinaryRight, _group, 0, 0)
					}
					return _group
				}
			}
		}
	}

	// [FoldBinary]
	{
		if _f.funcs.IsConstValueOrTuple(left) {
			if _f.funcs.IsConstValueOrTuple(right) {
				result := _f.funcs.FoldBinary(opt.ModOp, left, right)
				if _f.funcs.Succeeded(result) {
					if _f.matchedRule == nil || _f.matchedRule(opt.FoldBinary) {
						_group = result
						_f.mem.AddAltFingerprint(_modExpr.Fingerprint(), _group)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.FoldBinary, _group, 0, 0)
						}
						return _group
					}
				}
			}
		}
	}

	return _f.onConstruct(memo.Expr(_modExpr))
}

// ConstructPow constructs an expression for the Pow operator.
func (_f *Factory) ConstructPow(
	left memo.GroupID,
	right memo.GroupID,
) memo.GroupID {
	_powExpr := memo.MakePowExpr(left, right)
	_group := _f.mem.GroupByFingerprint(_powExpr.Fingerprint())
	if _group != 0 {
		return _group
	}

	// [FoldNullBinaryLeft]
	{
		_nullExpr := _f.mem.NormExpr(left).AsNull()
		if _nullExpr != nil {
			if !_f.funcs.AllowNullArgs(opt.PowOp, left, right) {
				if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullBinaryLeft) {
					_group = _f.funcs.FoldNullBinary(opt.PowOp, left, right)
					_f.mem.AddAltFingerprint(_powExpr.Fingerprint(), _group)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.FoldNullBinaryLeft, _group, 0, 0)
					}
					return _group
				}
			}
		}
	}

	// [FoldNullBinaryRight]
	{
		_nullExpr := _f.mem.NormExpr(right).AsNull()
		if _nullExpr != nil {
			if !_f.funcs.AllowNullArgs(opt.PowOp, left, right) {
				if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullBinaryRight) {
					_group = _f.funcs.FoldNullBinary(opt.PowOp, left, right)
					_f.mem.AddAltFingerprint(_powExpr.Fingerprint(), _group)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.FoldNullBinaryRight, _group, 0, 0)
					}
					return _group
				}
			}
		}
	}

	// [FoldBinary]
	{
		if _f.funcs.IsConstValueOrTuple(left) {
			if _f.funcs.IsConstValueOrTuple(right) {
				result := _f.funcs.FoldBinary(opt.PowOp, left, right)
				if _f.funcs.Succeeded(result) {
					if _f.matchedRule == nil || _f.matchedRule(opt.FoldBinary) {
						_group = result
						_f.mem.AddAltFingerprint(_powExpr.Fingerprint(), _group)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.FoldBinary, _group, 0, 0)
						}
						return _group
					}
				}
			}
		}
	}

	return _f.onConstruct(memo.Expr(_powExpr))
}

// ConstructConcat constructs an expression for the Concat operator.
func (_f *Factory) ConstructConcat(
	left memo.GroupID,
	right memo.GroupID,
) memo.GroupID {
	_concatExpr := memo.MakeConcatExpr(left, right)
	_group := _f.mem.GroupByFingerprint(_concatExpr.Fingerprint())
	if _group != 0 {
		return _group
	}

	// [FoldNullBinaryLeft]
	{
		_nullExpr := _f.mem.NormExpr(left).AsNull()
		if _nullExpr != nil {
			if !_f.funcs.AllowNullArgs(opt.ConcatOp, left, right) {
				if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullBinaryLeft) {
					_group = _f.funcs.FoldNullBinary(opt.ConcatOp, left, right)
					_f.mem.AddAltFingerprint(_concatExpr.Fingerprint(), _group)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.FoldNullBinaryLeft, _group, 0, 0)
					}
					return _group
				}
			}
		}
	}

	// [FoldNullBinaryRight]
	{
		_nullExpr := _f.mem.NormExpr(right).AsNull()
		if _nullExpr != nil {
			if !_f.funcs.AllowNullArgs(opt.ConcatOp, left, right) {
				if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullBinaryRight) {
					_group = _f.funcs.FoldNullBinary(opt.ConcatOp, left, right)
					_f.mem.AddAltFingerprint(_concatExpr.Fingerprint(), _group)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.FoldNullBinaryRight, _group, 0, 0)
					}
					return _group
				}
			}
		}
	}

	// [FoldBinary]
	{
		if _f.funcs.IsConstValueOrTuple(left) {
			if _f.funcs.IsConstValueOrTuple(right) {
				result := _f.funcs.FoldBinary(opt.ConcatOp, left, right)
				if _f.funcs.Succeeded(result) {
					if _f.matchedRule == nil || _f.matchedRule(opt.FoldBinary) {
						_group = result
						_f.mem.AddAltFingerprint(_concatExpr.Fingerprint(), _group)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.FoldBinary, _group, 0, 0)
						}
						return _group
					}
				}
			}
		}
	}

	return _f.onConstruct(memo.Expr(_concatExpr))
}

// ConstructLShift constructs an expression for the LShift operator.
func (_f *Factory) ConstructLShift(
	left memo.GroupID,
	right memo.GroupID,
) memo.GroupID {
	_lShiftExpr := memo.MakeLShiftExpr(left, right)
	_group := _f.mem.GroupByFingerprint(_lShiftExpr.Fingerprint())
	if _group != 0 {
		return _group
	}

	// [FoldNullBinaryLeft]
	{
		_nullExpr := _f.mem.NormExpr(left).AsNull()
		if _nullExpr != nil {
			if !_f.funcs.AllowNullArgs(opt.LShiftOp, left, right) {
				if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullBinaryLeft) {
					_group = _f.funcs.FoldNullBinary(opt.LShiftOp, left, right)
					_f.mem.AddAltFingerprint(_lShiftExpr.Fingerprint(), _group)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.FoldNullBinaryLeft, _group, 0, 0)
					}
					return _group
				}
			}
		}
	}

	// [FoldNullBinaryRight]
	{
		_nullExpr := _f.mem.NormExpr(right).AsNull()
		if _nullExpr != nil {
			if !_f.funcs.AllowNullArgs(opt.LShiftOp, left, right) {
				if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullBinaryRight) {
					_group = _f.funcs.FoldNullBinary(opt.LShiftOp, left, right)
					_f.mem.AddAltFingerprint(_lShiftExpr.Fingerprint(), _group)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.FoldNullBinaryRight, _group, 0, 0)
					}
					return _group
				}
			}
		}
	}

	// [FoldBinary]
	{
		if _f.funcs.IsConstValueOrTuple(left) {
			if _f.funcs.IsConstValueOrTuple(right) {
				result := _f.funcs.FoldBinary(opt.LShiftOp, left, right)
				if _f.funcs.Succeeded(result) {
					if _f.matchedRule == nil || _f.matchedRule(opt.FoldBinary) {
						_group = result
						_f.mem.AddAltFingerprint(_lShiftExpr.Fingerprint(), _group)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.FoldBinary, _group, 0, 0)
						}
						return _group
					}
				}
			}
		}
	}

	return _f.onConstruct(memo.Expr(_lShiftExpr))
}

// ConstructRShift constructs an expression for the RShift operator.
func (_f *Factory) ConstructRShift(
	left memo.GroupID,
	right memo.GroupID,
) memo.GroupID {
	_rShiftExpr := memo.MakeRShiftExpr(left, right)
	_group := _f.mem.GroupByFingerprint(_rShiftExpr.Fingerprint())
	if _group != 0 {
		return _group
	}

	// [FoldNullBinaryLeft]
	{
		_nullExpr := _f.mem.NormExpr(left).AsNull()
		if _nullExpr != nil {
			if !_f.funcs.AllowNullArgs(opt.RShiftOp, left, right) {
				if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullBinaryLeft) {
					_group = _f.funcs.FoldNullBinary(opt.RShiftOp, left, right)
					_f.mem.AddAltFingerprint(_rShiftExpr.Fingerprint(), _group)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.FoldNullBinaryLeft, _group, 0, 0)
					}
					return _group
				}
			}
		}
	}

	// [FoldNullBinaryRight]
	{
		_nullExpr := _f.mem.NormExpr(right).AsNull()
		if _nullExpr != nil {
			if !_f.funcs.AllowNullArgs(opt.RShiftOp, left, right) {
				if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullBinaryRight) {
					_group = _f.funcs.FoldNullBinary(opt.RShiftOp, left, right)
					_f.mem.AddAltFingerprint(_rShiftExpr.Fingerprint(), _group)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.FoldNullBinaryRight, _group, 0, 0)
					}
					return _group
				}
			}
		}
	}

	// [FoldBinary]
	{
		if _f.funcs.IsConstValueOrTuple(left) {
			if _f.funcs.IsConstValueOrTuple(right) {
				result := _f.funcs.FoldBinary(opt.RShiftOp, left, right)
				if _f.funcs.Succeeded(result) {
					if _f.matchedRule == nil || _f.matchedRule(opt.FoldBinary) {
						_group = result
						_f.mem.AddAltFingerprint(_rShiftExpr.Fingerprint(), _group)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.FoldBinary, _group, 0, 0)
						}
						return _group
					}
				}
			}
		}
	}

	return _f.onConstruct(memo.Expr(_rShiftExpr))
}

// ConstructFetchVal constructs an expression for the FetchVal operator.
func (_f *Factory) ConstructFetchVal(
	json memo.GroupID,
	index memo.GroupID,
) memo.GroupID {
	_fetchValExpr := memo.MakeFetchValExpr(json, index)
	_group := _f.mem.GroupByFingerprint(_fetchValExpr.Fingerprint())
	if _group != 0 {
		return _group
	}

	// [FoldNullBinaryLeft]
	{
		left := json
		_nullExpr := _f.mem.NormExpr(json).AsNull()
		if _nullExpr != nil {
			right := index
			if !_f.funcs.AllowNullArgs(opt.FetchValOp, left, right) {
				if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullBinaryLeft) {
					_group = _f.funcs.FoldNullBinary(opt.FetchValOp, left, right)
					_f.mem.AddAltFingerprint(_fetchValExpr.Fingerprint(), _group)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.FoldNullBinaryLeft, _group, 0, 0)
					}
					return _group
				}
			}
		}
	}

	// [FoldNullBinaryRight]
	{
		left := json
		right := index
		_nullExpr := _f.mem.NormExpr(index).AsNull()
		if _nullExpr != nil {
			if !_f.funcs.AllowNullArgs(opt.FetchValOp, left, right) {
				if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullBinaryRight) {
					_group = _f.funcs.FoldNullBinary(opt.FetchValOp, left, right)
					_f.mem.AddAltFingerprint(_fetchValExpr.Fingerprint(), _group)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.FoldNullBinaryRight, _group, 0, 0)
					}
					return _group
				}
			}
		}
	}

	// [FoldBinary]
	{
		left := json
		if _f.funcs.IsConstValueOrTuple(left) {
			right := index
			if _f.funcs.IsConstValueOrTuple(right) {
				result := _f.funcs.FoldBinary(opt.FetchValOp, left, right)
				if _f.funcs.Succeeded(result) {
					if _f.matchedRule == nil || _f.matchedRule(opt.FoldBinary) {
						_group = result
						_f.mem.AddAltFingerprint(_fetchValExpr.Fingerprint(), _group)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.FoldBinary, _group, 0, 0)
						}
						return _group
					}
				}
			}
		}
	}

	return _f.onConstruct(memo.Expr(_fetchValExpr))
}

// ConstructFetchText constructs an expression for the FetchText operator.
func (_f *Factory) ConstructFetchText(
	json memo.GroupID,
	index memo.GroupID,
) memo.GroupID {
	_fetchTextExpr := memo.MakeFetchTextExpr(json, index)
	_group := _f.mem.GroupByFingerprint(_fetchTextExpr.Fingerprint())
	if _group != 0 {
		return _group
	}

	// [FoldNullBinaryLeft]
	{
		left := json
		_nullExpr := _f.mem.NormExpr(json).AsNull()
		if _nullExpr != nil {
			right := index
			if !_f.funcs.AllowNullArgs(opt.FetchTextOp, left, right) {
				if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullBinaryLeft) {
					_group = _f.funcs.FoldNullBinary(opt.FetchTextOp, left, right)
					_f.mem.AddAltFingerprint(_fetchTextExpr.Fingerprint(), _group)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.FoldNullBinaryLeft, _group, 0, 0)
					}
					return _group
				}
			}
		}
	}

	// [FoldNullBinaryRight]
	{
		left := json
		right := index
		_nullExpr := _f.mem.NormExpr(index).AsNull()
		if _nullExpr != nil {
			if !_f.funcs.AllowNullArgs(opt.FetchTextOp, left, right) {
				if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullBinaryRight) {
					_group = _f.funcs.FoldNullBinary(opt.FetchTextOp, left, right)
					_f.mem.AddAltFingerprint(_fetchTextExpr.Fingerprint(), _group)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.FoldNullBinaryRight, _group, 0, 0)
					}
					return _group
				}
			}
		}
	}

	// [FoldBinary]
	{
		left := json
		if _f.funcs.IsConstValueOrTuple(left) {
			right := index
			if _f.funcs.IsConstValueOrTuple(right) {
				result := _f.funcs.FoldBinary(opt.FetchTextOp, left, right)
				if _f.funcs.Succeeded(result) {
					if _f.matchedRule == nil || _f.matchedRule(opt.FoldBinary) {
						_group = result
						_f.mem.AddAltFingerprint(_fetchTextExpr.Fingerprint(), _group)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.FoldBinary, _group, 0, 0)
						}
						return _group
					}
				}
			}
		}
	}

	return _f.onConstruct(memo.Expr(_fetchTextExpr))
}

// ConstructFetchValPath constructs an expression for the FetchValPath operator.
func (_f *Factory) ConstructFetchValPath(
	json memo.GroupID,
	path memo.GroupID,
) memo.GroupID {
	_fetchValPathExpr := memo.MakeFetchValPathExpr(json, path)
	_group := _f.mem.GroupByFingerprint(_fetchValPathExpr.Fingerprint())
	if _group != 0 {
		return _group
	}

	// [FoldNullBinaryLeft]
	{
		left := json
		_nullExpr := _f.mem.NormExpr(json).AsNull()
		if _nullExpr != nil {
			right := path
			if !_f.funcs.AllowNullArgs(opt.FetchValPathOp, left, right) {
				if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullBinaryLeft) {
					_group = _f.funcs.FoldNullBinary(opt.FetchValPathOp, left, right)
					_f.mem.AddAltFingerprint(_fetchValPathExpr.Fingerprint(), _group)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.FoldNullBinaryLeft, _group, 0, 0)
					}
					return _group
				}
			}
		}
	}

	// [FoldNullBinaryRight]
	{
		left := json
		right := path
		_nullExpr := _f.mem.NormExpr(path).AsNull()
		if _nullExpr != nil {
			if !_f.funcs.AllowNullArgs(opt.FetchValPathOp, left, right) {
				if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullBinaryRight) {
					_group = _f.funcs.FoldNullBinary(opt.FetchValPathOp, left, right)
					_f.mem.AddAltFingerprint(_fetchValPathExpr.Fingerprint(), _group)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.FoldNullBinaryRight, _group, 0, 0)
					}
					return _group
				}
			}
		}
	}

	// [FoldBinary]
	{
		left := json
		if _f.funcs.IsConstValueOrTuple(left) {
			right := path
			if _f.funcs.IsConstValueOrTuple(right) {
				result := _f.funcs.FoldBinary(opt.FetchValPathOp, left, right)
				if _f.funcs.Succeeded(result) {
					if _f.matchedRule == nil || _f.matchedRule(opt.FoldBinary) {
						_group = result
						_f.mem.AddAltFingerprint(_fetchValPathExpr.Fingerprint(), _group)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.FoldBinary, _group, 0, 0)
						}
						return _group
					}
				}
			}
		}
	}

	return _f.onConstruct(memo.Expr(_fetchValPathExpr))
}

// ConstructFetchTextPath constructs an expression for the FetchTextPath operator.
func (_f *Factory) ConstructFetchTextPath(
	json memo.GroupID,
	path memo.GroupID,
) memo.GroupID {
	_fetchTextPathExpr := memo.MakeFetchTextPathExpr(json, path)
	_group := _f.mem.GroupByFingerprint(_fetchTextPathExpr.Fingerprint())
	if _group != 0 {
		return _group
	}

	// [FoldNullBinaryLeft]
	{
		left := json
		_nullExpr := _f.mem.NormExpr(json).AsNull()
		if _nullExpr != nil {
			right := path
			if !_f.funcs.AllowNullArgs(opt.FetchTextPathOp, left, right) {
				if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullBinaryLeft) {
					_group = _f.funcs.FoldNullBinary(opt.FetchTextPathOp, left, right)
					_f.mem.AddAltFingerprint(_fetchTextPathExpr.Fingerprint(), _group)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.FoldNullBinaryLeft, _group, 0, 0)
					}
					return _group
				}
			}
		}
	}

	// [FoldNullBinaryRight]
	{
		left := json
		right := path
		_nullExpr := _f.mem.NormExpr(path).AsNull()
		if _nullExpr != nil {
			if !_f.funcs.AllowNullArgs(opt.FetchTextPathOp, left, right) {
				if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullBinaryRight) {
					_group = _f.funcs.FoldNullBinary(opt.FetchTextPathOp, left, right)
					_f.mem.AddAltFingerprint(_fetchTextPathExpr.Fingerprint(), _group)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.FoldNullBinaryRight, _group, 0, 0)
					}
					return _group
				}
			}
		}
	}

	// [FoldBinary]
	{
		left := json
		if _f.funcs.IsConstValueOrTuple(left) {
			right := path
			if _f.funcs.IsConstValueOrTuple(right) {
				result := _f.funcs.FoldBinary(opt.FetchTextPathOp, left, right)
				if _f.funcs.Succeeded(result) {
					if _f.matchedRule == nil || _f.matchedRule(opt.FoldBinary) {
						_group = result
						_f.mem.AddAltFingerprint(_fetchTextPathExpr.Fingerprint(), _group)
						if _f.appliedRule != nil {
							_f.appliedRule(opt.FoldBinary, _group, 0, 0)
						}
						return _group
					}
				}
			}
		}
	}

	return _f.onConstruct(memo.Expr(_fetchTextPathExpr))
}

// ConstructUnaryMinus constructs an expression for the UnaryMinus operator.
func (_f *Factory) ConstructUnaryMinus(
	input memo.GroupID,
) memo.GroupID {
	_unaryMinusExpr := memo.MakeUnaryMinusExpr(input)
	_group := _f.mem.GroupByFingerprint(_unaryMinusExpr.Fingerprint())
	if _group != 0 {
		return _group
	}

	// [InvertMinus]
	{
		_minusExpr := _f.mem.NormExpr(input).AsMinus()
		if _minusExpr != nil {
			left := _minusExpr.Left()
			right := _minusExpr.Right()
			if _f.funcs.CanConstructBinary(opt.MinusOp, right, left) {
				if _f.matchedRule == nil || _f.matchedRule(opt.InvertMinus) {
					_group = _f.ConstructMinus(
						right,
						left,
					)
					_f.mem.AddAltFingerprint(_unaryMinusExpr.Fingerprint(), _group)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.InvertMinus, _group, 0, 0)
					}
					return _group
				}
			}
		}
	}

	// [EliminateUnaryMinus]
	{
		_unaryMinusExpr2 := _f.mem.NormExpr(input).AsUnaryMinus()
		if _unaryMinusExpr2 != nil {
			input := _unaryMinusExpr2.Input()
			if _f.matchedRule == nil || _f.matchedRule(opt.EliminateUnaryMinus) {
				_group = input
				_f.mem.AddAltFingerprint(_unaryMinusExpr.Fingerprint(), _group)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.EliminateUnaryMinus, _group, 0, 0)
				}
				return _group
			}
		}
	}

	// [FoldNullUnary]
	{
		_nullExpr := _f.mem.NormExpr(input).AsNull()
		if _nullExpr != nil {
			if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullUnary) {
				_group = _f.funcs.FoldNullUnary(opt.UnaryMinusOp, input)
				_f.mem.AddAltFingerprint(_unaryMinusExpr.Fingerprint(), _group)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.FoldNullUnary, _group, 0, 0)
				}
				return _group
			}
		}
	}

	// [FoldUnary]
	{
		if _f.funcs.IsConstValueOrTuple(input) {
			result := _f.funcs.FoldUnary(opt.UnaryMinusOp, input)
			if _f.funcs.Succeeded(result) {
				if _f.matchedRule == nil || _f.matchedRule(opt.FoldUnary) {
					_group = result
					_f.mem.AddAltFingerprint(_unaryMinusExpr.Fingerprint(), _group)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.FoldUnary, _group, 0, 0)
					}
					return _group
				}
			}
		}
	}

	return _f.onConstruct(memo.Expr(_unaryMinusExpr))
}

// ConstructUnaryComplement constructs an expression for the UnaryComplement operator.
func (_f *Factory) ConstructUnaryComplement(
	input memo.GroupID,
) memo.GroupID {
	_unaryComplementExpr := memo.MakeUnaryComplementExpr(input)
	_group := _f.mem.GroupByFingerprint(_unaryComplementExpr.Fingerprint())
	if _group != 0 {
		return _group
	}

	// [FoldNullUnary]
	{
		_nullExpr := _f.mem.NormExpr(input).AsNull()
		if _nullExpr != nil {
			if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullUnary) {
				_group = _f.funcs.FoldNullUnary(opt.UnaryComplementOp, input)
				_f.mem.AddAltFingerprint(_unaryComplementExpr.Fingerprint(), _group)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.FoldNullUnary, _group, 0, 0)
				}
				return _group
			}
		}
	}

	// [FoldUnary]
	{
		if _f.funcs.IsConstValueOrTuple(input) {
			result := _f.funcs.FoldUnary(opt.UnaryComplementOp, input)
			if _f.funcs.Succeeded(result) {
				if _f.matchedRule == nil || _f.matchedRule(opt.FoldUnary) {
					_group = result
					_f.mem.AddAltFingerprint(_unaryComplementExpr.Fingerprint(), _group)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.FoldUnary, _group, 0, 0)
					}
					return _group
				}
			}
		}
	}

	return _f.onConstruct(memo.Expr(_unaryComplementExpr))
}

// ConstructCast constructs an expression for the Cast operator.
// Cast converts the input expression into an expression of the target type.
// While the input's type is restricted to the datum types in the types package,
// the target type can be any of the column types in the coltypes package. For
// example, this is a legal cast:
//
//   'hello'::VARCHAR(2)
//
// That expression has the effect of truncating the string to just 'he', since
// the target data type allows a maximum of two characters. This is one example
// of a "lossy" cast.
func (_f *Factory) ConstructCast(
	input memo.GroupID,
	targetTyp memo.PrivateID,
) memo.GroupID {
	_castExpr := memo.MakeCastExpr(input, targetTyp)
	_group := _f.mem.GroupByFingerprint(_castExpr.Fingerprint())
	if _group != 0 {
		return _group
	}

	// [EliminateCast]
	{
		if _f.funcs.HasColType(input, targetTyp) {
			if _f.matchedRule == nil || _f.matchedRule(opt.EliminateCast) {
				_group = input
				_f.mem.AddAltFingerprint(_castExpr.Fingerprint(), _group)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.EliminateCast, _group, 0, 0)
				}
				return _group
			}
		}
	}

	// [FoldNullCast]
	{
		_nullExpr := _f.mem.NormExpr(input).AsNull()
		if _nullExpr != nil {
			if _f.matchedRule == nil || _f.matchedRule(opt.FoldNullCast) {
				_group = _f.ConstructNull(
					_f.funcs.ColTypeToDatumType(targetTyp),
				)
				_f.mem.AddAltFingerprint(_castExpr.Fingerprint(), _group)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.FoldNullCast, _group, 0, 0)
				}
				return _group
			}
		}
	}

	return _f.onConstruct(memo.Expr(_castExpr))
}

// ConstructCase constructs an expression for the Case operator.
// Case is a CASE statement of the form:
//   CASE [ <Input> ]
//       WHEN <condval1> THEN <expr1>
//     [ WHEN <condval2> THEN <expr2> ] ...
//     [ ELSE <expr> ]
//   END
//
// The Case operator evaluates <Input> (if not provided, Input is set to True),
// then picks the WHEN branch where <condval> is equal to
// <Input>, then evaluates and returns the corresponding THEN expression. If no
// WHEN branch matches, the ELSE expression is evaluated and returned, if any.
// Otherwise, NULL is returned.
//
// Note that the Whens list inside Case is used to represent all the WHEN
// branches as well as the ELSE statement if it exists. It is of the form:
// [(When <condval1> <expr1>),(When <condval2> <expr2>),...,<expr>]
func (_f *Factory) ConstructCase(
	input memo.GroupID,
	whens memo.ListID,
) memo.GroupID {
	_caseExpr := memo.MakeCaseExpr(input, whens)
	_group := _f.mem.GroupByFingerprint(_caseExpr.Fingerprint())
	if _group != 0 {
		return _group
	}

	// [SimplifyCaseWhenConstValue]
	{
		condition := input
		_expr := _f.mem.NormExpr(input)
		if _expr.IsConstValue() {
			for _, _item := range _f.mem.LookupList(whens) {
				_whenExpr := _f.mem.NormExpr(_item).AsWhen()
				if _whenExpr != nil {
					_expr2 := _f.mem.NormExpr(_whenExpr.Condition())
					if _expr2.IsConstValue() {
						if _f.matchedRule == nil || _f.matchedRule(opt.SimplifyCaseWhenConstValue) {
							_group = _f.funcs.SimplifyWhens(condition, whens)
							_f.mem.AddAltFingerprint(_caseExpr.Fingerprint(), _group)
							if _f.appliedRule != nil {
								_f.appliedRule(opt.SimplifyCaseWhenConstValue, _group, 0, 0)
							}
							return _group
						}
					}
				}
			}
		}
	}

	return _f.onConstruct(memo.Expr(_caseExpr))
}

// ConstructWhen constructs an expression for the When operator.
// When represents a single WHEN ... THEN ... condition inside a CASE statement.
// It is the type of each list item in Whens (except for the last item which is
// a raw expression for the ELSE statement).
func (_f *Factory) ConstructWhen(
	condition memo.GroupID,
	value memo.GroupID,
) memo.GroupID {
	_whenExpr := memo.MakeWhenExpr(condition, value)
	_group := _f.mem.GroupByFingerprint(_whenExpr.Fingerprint())
	if _group != 0 {
		return _group
	}

	return _f.onConstruct(memo.Expr(_whenExpr))
}

// ConstructArray constructs an expression for the Array operator.
// Array is an ARRAY literal of the form ARRAY[<expr1>, <expr2>, ..., <exprN>].
func (_f *Factory) ConstructArray(
	elems memo.ListID,
	typ memo.PrivateID,
) memo.GroupID {
	_arrayExpr := memo.MakeArrayExpr(elems, typ)
	_group := _f.mem.GroupByFingerprint(_arrayExpr.Fingerprint())
	if _group != 0 {
		return _group
	}

	// [FoldArray]
	{
		if _f.funcs.IsListOfConstants(elems) {
			if _f.matchedRule == nil || _f.matchedRule(opt.FoldArray) {
				_group = _f.funcs.FoldArray(elems, typ)
				_f.mem.AddAltFingerprint(_arrayExpr.Fingerprint(), _group)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.FoldArray, _group, 0, 0)
				}
				return _group
			}
		}
	}

	return _f.onConstruct(memo.Expr(_arrayExpr))
}

// ConstructFunction constructs an expression for the Function operator.
// Function invokes a builtin SQL function like CONCAT or NOW, passing the given
// arguments. The private field is a *opt.FuncOpDef struct that provides the
// name of the function as well as a pointer to the builtin overload definition.
func (_f *Factory) ConstructFunction(
	args memo.ListID,
	def memo.PrivateID,
) memo.GroupID {
	_functionExpr := memo.MakeFunctionExpr(args, def)
	_group := _f.mem.GroupByFingerprint(_functionExpr.Fingerprint())
	if _group != 0 {
		return _group
	}

	return _f.onConstruct(memo.Expr(_functionExpr))
}

// ConstructCoalesce constructs an expression for the Coalesce operator.
func (_f *Factory) ConstructCoalesce(
	args memo.ListID,
) memo.GroupID {
	_coalesceExpr := memo.MakeCoalesceExpr(args)
	_group := _f.mem.GroupByFingerprint(_coalesceExpr.Fingerprint())
	if _group != 0 {
		return _group
	}

	// [EliminateCoalesce]
	{
		if args.Length == 1 {
			_item := _f.mem.LookupList(args)[0]
			item := _item
			if _f.matchedRule == nil || _f.matchedRule(opt.EliminateCoalesce) {
				_group = item
				_f.mem.AddAltFingerprint(_coalesceExpr.Fingerprint(), _group)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.EliminateCoalesce, _group, 0, 0)
				}
				return _group
			}
		}
	}

	// [SimplifyCoalesce]
	{
		if args.Length > 0 {
			_item := _f.mem.LookupList(args)[0]
			arg := _item
			if _f.funcs.IsConstValueOrTuple(arg) {
				if _f.matchedRule == nil || _f.matchedRule(opt.SimplifyCoalesce) {
					_group = _f.funcs.SimplifyCoalesce(args)
					_f.mem.AddAltFingerprint(_coalesceExpr.Fingerprint(), _group)
					if _f.appliedRule != nil {
						_f.appliedRule(opt.SimplifyCoalesce, _group, 0, 0)
					}
					return _group
				}
			}
		}
	}

	return _f.onConstruct(memo.Expr(_coalesceExpr))
}

// ConstructColumnAccess constructs an expression for the ColumnAccess operator.
// ColumnAccess is a scalar expression that returns a column from the given
// input expression (which is assumed to be of type Tuple). Idx is the ordinal
// index of the column in Input.
func (_f *Factory) ConstructColumnAccess(
	input memo.GroupID,
	idx memo.PrivateID,
) memo.GroupID {
	_columnAccessExpr := memo.MakeColumnAccessExpr(input, idx)
	_group := _f.mem.GroupByFingerprint(_columnAccessExpr.Fingerprint())
	if _group != 0 {
		return _group
	}

	return _f.onConstruct(memo.Expr(_columnAccessExpr))
}

// ConstructUnsupportedExpr constructs an expression for the UnsupportedExpr operator.
// UnsupportedExpr is used for interfacing with the old planner code. It can
// encapsulate a TypedExpr that is otherwise not supported by the optimizer.
func (_f *Factory) ConstructUnsupportedExpr(
	value memo.PrivateID,
) memo.GroupID {
	_unsupportedExprExpr := memo.MakeUnsupportedExprExpr(value)
	_group := _f.mem.GroupByFingerprint(_unsupportedExprExpr.Fingerprint())
	if _group != 0 {
		return _group
	}

	return _f.onConstruct(memo.Expr(_unsupportedExprExpr))
}

// ConstructArrayAgg constructs an expression for the ArrayAgg operator.
func (_f *Factory) ConstructArrayAgg(
	input memo.GroupID,
) memo.GroupID {
	_arrayAggExpr := memo.MakeArrayAggExpr(input)
	_group := _f.mem.GroupByFingerprint(_arrayAggExpr.Fingerprint())
	if _group != 0 {
		return _group
	}

	return _f.onConstruct(memo.Expr(_arrayAggExpr))
}

// ConstructAvg constructs an expression for the Avg operator.
func (_f *Factory) ConstructAvg(
	input memo.GroupID,
) memo.GroupID {
	_avgExpr := memo.MakeAvgExpr(input)
	_group := _f.mem.GroupByFingerprint(_avgExpr.Fingerprint())
	if _group != 0 {
		return _group
	}

	return _f.onConstruct(memo.Expr(_avgExpr))
}

// ConstructBoolAnd constructs an expression for the BoolAnd operator.
func (_f *Factory) ConstructBoolAnd(
	input memo.GroupID,
) memo.GroupID {
	_boolAndExpr := memo.MakeBoolAndExpr(input)
	_group := _f.mem.GroupByFingerprint(_boolAndExpr.Fingerprint())
	if _group != 0 {
		return _group
	}

	// [EliminateAggDistinct]
	{
		_aggDistinctExpr := _f.mem.NormExpr(input).AsAggDistinct()
		if _aggDistinctExpr != nil {
			in := _aggDistinctExpr.Input()
			if _f.matchedRule == nil || _f.matchedRule(opt.EliminateAggDistinct) {
				_group = _f.ConstructBoolAnd(
					in,
				)
				_f.mem.AddAltFingerprint(_boolAndExpr.Fingerprint(), _group)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.EliminateAggDistinct, _group, 0, 0)
				}
				return _group
			}
		}
	}

	return _f.onConstruct(memo.Expr(_boolAndExpr))
}

// ConstructBoolOr constructs an expression for the BoolOr operator.
func (_f *Factory) ConstructBoolOr(
	input memo.GroupID,
) memo.GroupID {
	_boolOrExpr := memo.MakeBoolOrExpr(input)
	_group := _f.mem.GroupByFingerprint(_boolOrExpr.Fingerprint())
	if _group != 0 {
		return _group
	}

	// [EliminateAggDistinct]
	{
		_aggDistinctExpr := _f.mem.NormExpr(input).AsAggDistinct()
		if _aggDistinctExpr != nil {
			in := _aggDistinctExpr.Input()
			if _f.matchedRule == nil || _f.matchedRule(opt.EliminateAggDistinct) {
				_group = _f.ConstructBoolOr(
					in,
				)
				_f.mem.AddAltFingerprint(_boolOrExpr.Fingerprint(), _group)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.EliminateAggDistinct, _group, 0, 0)
				}
				return _group
			}
		}
	}

	return _f.onConstruct(memo.Expr(_boolOrExpr))
}

// ConstructConcatAgg constructs an expression for the ConcatAgg operator.
func (_f *Factory) ConstructConcatAgg(
	input memo.GroupID,
) memo.GroupID {
	_concatAggExpr := memo.MakeConcatAggExpr(input)
	_group := _f.mem.GroupByFingerprint(_concatAggExpr.Fingerprint())
	if _group != 0 {
		return _group
	}

	return _f.onConstruct(memo.Expr(_concatAggExpr))
}

// ConstructCount constructs an expression for the Count operator.
func (_f *Factory) ConstructCount(
	input memo.GroupID,
) memo.GroupID {
	_countExpr := memo.MakeCountExpr(input)
	_group := _f.mem.GroupByFingerprint(_countExpr.Fingerprint())
	if _group != 0 {
		return _group
	}

	return _f.onConstruct(memo.Expr(_countExpr))
}

// ConstructCountRows constructs an expression for the CountRows operator.
func (_f *Factory) ConstructCountRows() memo.GroupID {
	_countRowsExpr := memo.MakeCountRowsExpr()
	_group := _f.mem.GroupByFingerprint(_countRowsExpr.Fingerprint())
	if _group != 0 {
		return _group
	}

	return _f.onConstruct(memo.Expr(_countRowsExpr))
}

// ConstructMax constructs an expression for the Max operator.
func (_f *Factory) ConstructMax(
	input memo.GroupID,
) memo.GroupID {
	_maxExpr := memo.MakeMaxExpr(input)
	_group := _f.mem.GroupByFingerprint(_maxExpr.Fingerprint())
	if _group != 0 {
		return _group
	}

	// [EliminateAggDistinct]
	{
		_aggDistinctExpr := _f.mem.NormExpr(input).AsAggDistinct()
		if _aggDistinctExpr != nil {
			in := _aggDistinctExpr.Input()
			if _f.matchedRule == nil || _f.matchedRule(opt.EliminateAggDistinct) {
				_group = _f.ConstructMax(
					in,
				)
				_f.mem.AddAltFingerprint(_maxExpr.Fingerprint(), _group)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.EliminateAggDistinct, _group, 0, 0)
				}
				return _group
			}
		}
	}

	return _f.onConstruct(memo.Expr(_maxExpr))
}

// ConstructMin constructs an expression for the Min operator.
func (_f *Factory) ConstructMin(
	input memo.GroupID,
) memo.GroupID {
	_minExpr := memo.MakeMinExpr(input)
	_group := _f.mem.GroupByFingerprint(_minExpr.Fingerprint())
	if _group != 0 {
		return _group
	}

	// [EliminateAggDistinct]
	{
		_aggDistinctExpr := _f.mem.NormExpr(input).AsAggDistinct()
		if _aggDistinctExpr != nil {
			in := _aggDistinctExpr.Input()
			if _f.matchedRule == nil || _f.matchedRule(opt.EliminateAggDistinct) {
				_group = _f.ConstructMin(
					in,
				)
				_f.mem.AddAltFingerprint(_minExpr.Fingerprint(), _group)
				if _f.appliedRule != nil {
					_f.appliedRule(opt.EliminateAggDistinct, _group, 0, 0)
				}
				return _group
			}
		}
	}

	return _f.onConstruct(memo.Expr(_minExpr))
}

// ConstructSumInt constructs an expression for the SumInt operator.
func (_f *Factory) ConstructSumInt(
	input memo.GroupID,
) memo.GroupID {
	_sumIntExpr := memo.MakeSumIntExpr(input)
	_group := _f.mem.GroupByFingerprint(_sumIntExpr.Fingerprint())
	if _group != 0 {
		return _group
	}

	return _f.onConstruct(memo.Expr(_sumIntExpr))
}

// ConstructSum constructs an expression for the Sum operator.
func (_f *Factory) ConstructSum(
	input memo.GroupID,
) memo.GroupID {
	_sumExpr := memo.MakeSumExpr(input)
	_group := _f.mem.GroupByFingerprint(_sumExpr.Fingerprint())
	if _group != 0 {
		return _group
	}

	return _f.onConstruct(memo.Expr(_sumExpr))
}

// ConstructSqrDiff constructs an expression for the SqrDiff operator.
func (_f *Factory) ConstructSqrDiff(
	input memo.GroupID,
) memo.GroupID {
	_sqrDiffExpr := memo.MakeSqrDiffExpr(input)
	_group := _f.mem.GroupByFingerprint(_sqrDiffExpr.Fingerprint())
	if _group != 0 {
		return _group
	}

	return _f.onConstruct(memo.Expr(_sqrDiffExpr))
}

// ConstructVariance constructs an expression for the Variance operator.
func (_f *Factory) ConstructVariance(
	input memo.GroupID,
) memo.GroupID {
	_varianceExpr := memo.MakeVarianceExpr(input)
	_group := _f.mem.GroupByFingerprint(_varianceExpr.Fingerprint())
	if _group != 0 {
		return _group
	}

	return _f.onConstruct(memo.Expr(_varianceExpr))
}

// ConstructStdDev constructs an expression for the StdDev operator.
func (_f *Factory) ConstructStdDev(
	input memo.GroupID,
) memo.GroupID {
	_stdDevExpr := memo.MakeStdDevExpr(input)
	_group := _f.mem.GroupByFingerprint(_stdDevExpr.Fingerprint())
	if _group != 0 {
		return _group
	}

	return _f.onConstruct(memo.Expr(_stdDevExpr))
}

// ConstructXorAgg constructs an expression for the XorAgg operator.
func (_f *Factory) ConstructXorAgg(
	input memo.GroupID,
) memo.GroupID {
	_xorAggExpr := memo.MakeXorAggExpr(input)
	_group := _f.mem.GroupByFingerprint(_xorAggExpr.Fingerprint())
	if _group != 0 {
		return _group
	}

	return _f.onConstruct(memo.Expr(_xorAggExpr))
}

// ConstructJsonAgg constructs an expression for the JsonAgg operator.
func (_f *Factory) ConstructJsonAgg(
	input memo.GroupID,
) memo.GroupID {
	_jsonAggExpr := memo.MakeJsonAggExpr(input)
	_group := _f.mem.GroupByFingerprint(_jsonAggExpr.Fingerprint())
	if _group != 0 {
		return _group
	}

	return _f.onConstruct(memo.Expr(_jsonAggExpr))
}

// ConstructJsonbAgg constructs an expression for the JsonbAgg operator.
func (_f *Factory) ConstructJsonbAgg(
	input memo.GroupID,
) memo.GroupID {
	_jsonbAggExpr := memo.MakeJsonbAggExpr(input)
	_group := _f.mem.GroupByFingerprint(_jsonbAggExpr.Fingerprint())
	if _group != 0 {
		return _group
	}

	return _f.onConstruct(memo.Expr(_jsonbAggExpr))
}

// ConstructConstAgg constructs an expression for the ConstAgg operator.
// ConstAgg is used in the special case when the value of a column is known to be
// constant within a grouping set; it returns that value. If there are no rows
// in the grouping set, then ConstAgg returns NULL.
//
// ConstAgg is not part of SQL, but it's used internally to rewrite correlated
// subqueries into an efficient and convenient form.
func (_f *Factory) ConstructConstAgg(
	input memo.GroupID,
) memo.GroupID {
	_constAggExpr := memo.MakeConstAggExpr(input)
	_group := _f.mem.GroupByFingerprint(_constAggExpr.Fingerprint())
	if _group != 0 {
		return _group
	}

	return _f.onConstruct(memo.Expr(_constAggExpr))
}

// ConstructConstNotNullAgg constructs an expression for the ConstNotNullAgg operator.
// ConstNotNullAgg is used in the special case when the value of a column is
// known to be constant within a grouping set, except on some rows where it can
// have a NULL value; it returns the non-NULL constant value. If there are no
// rows in the grouping set, or all rows have a NULL value, then ConstNotNullAgg
// returns NULL.
//
// ConstNotNullAgg is not part of SQL, but it's used internally to rewrite
// correlated subqueries into an efficient and convenient form.
func (_f *Factory) ConstructConstNotNullAgg(
	input memo.GroupID,
) memo.GroupID {
	_constNotNullAggExpr := memo.MakeConstNotNullAggExpr(input)
	_group := _f.mem.GroupByFingerprint(_constNotNullAggExpr.Fingerprint())
	if _group != 0 {
		return _group
	}

	return _f.onConstruct(memo.Expr(_constNotNullAggExpr))
}

// ConstructAnyNotNullAgg constructs an expression for the AnyNotNullAgg operator.
// AnyNotNullAgg returns any non-NULL value it receives, with no other guarantees.
// If it does not receive any values, it returns NULL.
//
// AnyNotNullAgg is not part of SQL, but it's used internally to rewrite
// correlated subqueries into an efficient and convenient form.
func (_f *Factory) ConstructAnyNotNullAgg(
	input memo.GroupID,
) memo.GroupID {
	_anyNotNullAggExpr := memo.MakeAnyNotNullAggExpr(input)
	_group := _f.mem.GroupByFingerprint(_anyNotNullAggExpr.Fingerprint())
	if _group != 0 {
		return _group
	}

	return _f.onConstruct(memo.Expr(_anyNotNullAggExpr))
}

// ConstructFirstAgg constructs an expression for the FirstAgg operator.
// FirstAgg is used only by DistinctOn; it returns the value on the first row
// according to an ordering; if the ordering is unspecified (or partially
// specified), it is an arbitrary ordering but it must be the same across all
// FirstAggs in a DistinctOn.
func (_f *Factory) ConstructFirstAgg(
	input memo.GroupID,
) memo.GroupID {
	_firstAggExpr := memo.MakeFirstAggExpr(input)
	_group := _f.mem.GroupByFingerprint(_firstAggExpr.Fingerprint())
	if _group != 0 {
		return _group
	}

	return _f.onConstruct(memo.Expr(_firstAggExpr))
}

// ConstructAggDistinct constructs an expression for the AggDistinct operator.
// AggDistinct is used as a modifier that wraps the input of an aggregate
// function. It causes the respective aggregation to only process each distinct
// value once.
func (_f *Factory) ConstructAggDistinct(
	input memo.GroupID,
) memo.GroupID {
	_aggDistinctExpr := memo.MakeAggDistinctExpr(input)
	_group := _f.mem.GroupByFingerprint(_aggDistinctExpr.Fingerprint())
	if _group != 0 {
		return _group
	}

	return _f.onConstruct(memo.Expr(_aggDistinctExpr))
}

func (f *Factory) assignPlaceholders(group memo.GroupID) (memo.GroupID, error) {
	if !f.mem.GroupProperties(group).HasPlaceholder() {
		return group, nil
	}
	expr := f.mem.NormExpr(group)
	switch expr.Operator() {
	case opt.ValuesOp:
		valuesExpr := expr.AsValues()
		lb := MakeListBuilder(&f.funcs)
		for _, item := range f.mem.LookupList(valuesExpr.Rows()) {
			newItem, err := f.assignPlaceholders(item)
			if err != nil {
				return 0, err
			}
			lb.AddItem(newItem)
		}
		rows := lb.BuildList()
		cols := valuesExpr.Cols()
		return f.ConstructValues(rows, cols), nil
	case opt.SelectOp:
		selectExpr := expr.AsSelect()
		input, err := f.assignPlaceholders(selectExpr.Input())
		if err != nil {
			return 0, err
		}
		filter, err := f.assignPlaceholders(selectExpr.Filter())
		if err != nil {
			return 0, err
		}
		return f.ConstructSelect(input, filter), nil
	case opt.ProjectOp:
		projectExpr := expr.AsProject()
		input, err := f.assignPlaceholders(projectExpr.Input())
		if err != nil {
			return 0, err
		}
		projections, err := f.assignPlaceholders(projectExpr.Projections())
		if err != nil {
			return 0, err
		}
		return f.ConstructProject(input, projections), nil
	case opt.InnerJoinOp:
		innerJoinExpr := expr.AsInnerJoin()
		left, err := f.assignPlaceholders(innerJoinExpr.Left())
		if err != nil {
			return 0, err
		}
		right, err := f.assignPlaceholders(innerJoinExpr.Right())
		if err != nil {
			return 0, err
		}
		on, err := f.assignPlaceholders(innerJoinExpr.On())
		if err != nil {
			return 0, err
		}
		return f.ConstructInnerJoin(left, right, on), nil
	case opt.LeftJoinOp:
		leftJoinExpr := expr.AsLeftJoin()
		left, err := f.assignPlaceholders(leftJoinExpr.Left())
		if err != nil {
			return 0, err
		}
		right, err := f.assignPlaceholders(leftJoinExpr.Right())
		if err != nil {
			return 0, err
		}
		on, err := f.assignPlaceholders(leftJoinExpr.On())
		if err != nil {
			return 0, err
		}
		return f.ConstructLeftJoin(left, right, on), nil
	case opt.RightJoinOp:
		rightJoinExpr := expr.AsRightJoin()
		left, err := f.assignPlaceholders(rightJoinExpr.Left())
		if err != nil {
			return 0, err
		}
		right, err := f.assignPlaceholders(rightJoinExpr.Right())
		if err != nil {
			return 0, err
		}
		on, err := f.assignPlaceholders(rightJoinExpr.On())
		if err != nil {
			return 0, err
		}
		return f.ConstructRightJoin(left, right, on), nil
	case opt.FullJoinOp:
		fullJoinExpr := expr.AsFullJoin()
		left, err := f.assignPlaceholders(fullJoinExpr.Left())
		if err != nil {
			return 0, err
		}
		right, err := f.assignPlaceholders(fullJoinExpr.Right())
		if err != nil {
			return 0, err
		}
		on, err := f.assignPlaceholders(fullJoinExpr.On())
		if err != nil {
			return 0, err
		}
		return f.ConstructFullJoin(left, right, on), nil
	case opt.SemiJoinOp:
		semiJoinExpr := expr.AsSemiJoin()
		left, err := f.assignPlaceholders(semiJoinExpr.Left())
		if err != nil {
			return 0, err
		}
		right, err := f.assignPlaceholders(semiJoinExpr.Right())
		if err != nil {
			return 0, err
		}
		on, err := f.assignPlaceholders(semiJoinExpr.On())
		if err != nil {
			return 0, err
		}
		return f.ConstructSemiJoin(left, right, on), nil
	case opt.AntiJoinOp:
		antiJoinExpr := expr.AsAntiJoin()
		left, err := f.assignPlaceholders(antiJoinExpr.Left())
		if err != nil {
			return 0, err
		}
		right, err := f.assignPlaceholders(antiJoinExpr.Right())
		if err != nil {
			return 0, err
		}
		on, err := f.assignPlaceholders(antiJoinExpr.On())
		if err != nil {
			return 0, err
		}
		return f.ConstructAntiJoin(left, right, on), nil
	case opt.IndexJoinOp:
		indexJoinExpr := expr.AsIndexJoin()
		input, err := f.assignPlaceholders(indexJoinExpr.Input())
		if err != nil {
			return 0, err
		}
		def := indexJoinExpr.Def()
		return f.ConstructIndexJoin(input, def), nil
	case opt.LookupJoinOp:
		lookupJoinExpr := expr.AsLookupJoin()
		input, err := f.assignPlaceholders(lookupJoinExpr.Input())
		if err != nil {
			return 0, err
		}
		on, err := f.assignPlaceholders(lookupJoinExpr.On())
		if err != nil {
			return 0, err
		}
		def := lookupJoinExpr.Def()
		return f.ConstructLookupJoin(input, on, def), nil
	case opt.MergeJoinOp:
		mergeJoinExpr := expr.AsMergeJoin()
		left, err := f.assignPlaceholders(mergeJoinExpr.Left())
		if err != nil {
			return 0, err
		}
		right, err := f.assignPlaceholders(mergeJoinExpr.Right())
		if err != nil {
			return 0, err
		}
		mergeOn, err := f.assignPlaceholders(mergeJoinExpr.MergeOn())
		if err != nil {
			return 0, err
		}
		return f.ConstructMergeJoin(left, right, mergeOn), nil
	case opt.InnerJoinApplyOp:
		innerJoinApplyExpr := expr.AsInnerJoinApply()
		left, err := f.assignPlaceholders(innerJoinApplyExpr.Left())
		if err != nil {
			return 0, err
		}
		right, err := f.assignPlaceholders(innerJoinApplyExpr.Right())
		if err != nil {
			return 0, err
		}
		on, err := f.assignPlaceholders(innerJoinApplyExpr.On())
		if err != nil {
			return 0, err
		}
		return f.ConstructInnerJoinApply(left, right, on), nil
	case opt.LeftJoinApplyOp:
		leftJoinApplyExpr := expr.AsLeftJoinApply()
		left, err := f.assignPlaceholders(leftJoinApplyExpr.Left())
		if err != nil {
			return 0, err
		}
		right, err := f.assignPlaceholders(leftJoinApplyExpr.Right())
		if err != nil {
			return 0, err
		}
		on, err := f.assignPlaceholders(leftJoinApplyExpr.On())
		if err != nil {
			return 0, err
		}
		return f.ConstructLeftJoinApply(left, right, on), nil
	case opt.RightJoinApplyOp:
		rightJoinApplyExpr := expr.AsRightJoinApply()
		left, err := f.assignPlaceholders(rightJoinApplyExpr.Left())
		if err != nil {
			return 0, err
		}
		right, err := f.assignPlaceholders(rightJoinApplyExpr.Right())
		if err != nil {
			return 0, err
		}
		on, err := f.assignPlaceholders(rightJoinApplyExpr.On())
		if err != nil {
			return 0, err
		}
		return f.ConstructRightJoinApply(left, right, on), nil
	case opt.FullJoinApplyOp:
		fullJoinApplyExpr := expr.AsFullJoinApply()
		left, err := f.assignPlaceholders(fullJoinApplyExpr.Left())
		if err != nil {
			return 0, err
		}
		right, err := f.assignPlaceholders(fullJoinApplyExpr.Right())
		if err != nil {
			return 0, err
		}
		on, err := f.assignPlaceholders(fullJoinApplyExpr.On())
		if err != nil {
			return 0, err
		}
		return f.ConstructFullJoinApply(left, right, on), nil
	case opt.SemiJoinApplyOp:
		semiJoinApplyExpr := expr.AsSemiJoinApply()
		left, err := f.assignPlaceholders(semiJoinApplyExpr.Left())
		if err != nil {
			return 0, err
		}
		right, err := f.assignPlaceholders(semiJoinApplyExpr.Right())
		if err != nil {
			return 0, err
		}
		on, err := f.assignPlaceholders(semiJoinApplyExpr.On())
		if err != nil {
			return 0, err
		}
		return f.ConstructSemiJoinApply(left, right, on), nil
	case opt.AntiJoinApplyOp:
		antiJoinApplyExpr := expr.AsAntiJoinApply()
		left, err := f.assignPlaceholders(antiJoinApplyExpr.Left())
		if err != nil {
			return 0, err
		}
		right, err := f.assignPlaceholders(antiJoinApplyExpr.Right())
		if err != nil {
			return 0, err
		}
		on, err := f.assignPlaceholders(antiJoinApplyExpr.On())
		if err != nil {
			return 0, err
		}
		return f.ConstructAntiJoinApply(left, right, on), nil
	case opt.GroupByOp:
		groupByExpr := expr.AsGroupBy()
		input, err := f.assignPlaceholders(groupByExpr.Input())
		if err != nil {
			return 0, err
		}
		aggregations, err := f.assignPlaceholders(groupByExpr.Aggregations())
		if err != nil {
			return 0, err
		}
		def := groupByExpr.Def()
		return f.ConstructGroupBy(input, aggregations, def), nil
	case opt.ScalarGroupByOp:
		scalarGroupByExpr := expr.AsScalarGroupBy()
		input, err := f.assignPlaceholders(scalarGroupByExpr.Input())
		if err != nil {
			return 0, err
		}
		aggregations, err := f.assignPlaceholders(scalarGroupByExpr.Aggregations())
		if err != nil {
			return 0, err
		}
		def := scalarGroupByExpr.Def()
		return f.ConstructScalarGroupBy(input, aggregations, def), nil
	case opt.DistinctOnOp:
		distinctOnExpr := expr.AsDistinctOn()
		input, err := f.assignPlaceholders(distinctOnExpr.Input())
		if err != nil {
			return 0, err
		}
		aggregations, err := f.assignPlaceholders(distinctOnExpr.Aggregations())
		if err != nil {
			return 0, err
		}
		def := distinctOnExpr.Def()
		return f.ConstructDistinctOn(input, aggregations, def), nil
	case opt.UnionOp:
		unionExpr := expr.AsUnion()
		left, err := f.assignPlaceholders(unionExpr.Left())
		if err != nil {
			return 0, err
		}
		right, err := f.assignPlaceholders(unionExpr.Right())
		if err != nil {
			return 0, err
		}
		colMap := unionExpr.ColMap()
		return f.ConstructUnion(left, right, colMap), nil
	case opt.IntersectOp:
		intersectExpr := expr.AsIntersect()
		left, err := f.assignPlaceholders(intersectExpr.Left())
		if err != nil {
			return 0, err
		}
		right, err := f.assignPlaceholders(intersectExpr.Right())
		if err != nil {
			return 0, err
		}
		colMap := intersectExpr.ColMap()
		return f.ConstructIntersect(left, right, colMap), nil
	case opt.ExceptOp:
		exceptExpr := expr.AsExcept()
		left, err := f.assignPlaceholders(exceptExpr.Left())
		if err != nil {
			return 0, err
		}
		right, err := f.assignPlaceholders(exceptExpr.Right())
		if err != nil {
			return 0, err
		}
		colMap := exceptExpr.ColMap()
		return f.ConstructExcept(left, right, colMap), nil
	case opt.UnionAllOp:
		unionAllExpr := expr.AsUnionAll()
		left, err := f.assignPlaceholders(unionAllExpr.Left())
		if err != nil {
			return 0, err
		}
		right, err := f.assignPlaceholders(unionAllExpr.Right())
		if err != nil {
			return 0, err
		}
		colMap := unionAllExpr.ColMap()
		return f.ConstructUnionAll(left, right, colMap), nil
	case opt.IntersectAllOp:
		intersectAllExpr := expr.AsIntersectAll()
		left, err := f.assignPlaceholders(intersectAllExpr.Left())
		if err != nil {
			return 0, err
		}
		right, err := f.assignPlaceholders(intersectAllExpr.Right())
		if err != nil {
			return 0, err
		}
		colMap := intersectAllExpr.ColMap()
		return f.ConstructIntersectAll(left, right, colMap), nil
	case opt.ExceptAllOp:
		exceptAllExpr := expr.AsExceptAll()
		left, err := f.assignPlaceholders(exceptAllExpr.Left())
		if err != nil {
			return 0, err
		}
		right, err := f.assignPlaceholders(exceptAllExpr.Right())
		if err != nil {
			return 0, err
		}
		colMap := exceptAllExpr.ColMap()
		return f.ConstructExceptAll(left, right, colMap), nil
	case opt.LimitOp:
		limitExpr := expr.AsLimit()
		input, err := f.assignPlaceholders(limitExpr.Input())
		if err != nil {
			return 0, err
		}
		limit, err := f.assignPlaceholders(limitExpr.Limit())
		if err != nil {
			return 0, err
		}
		ordering := limitExpr.Ordering()
		return f.ConstructLimit(input, limit, ordering), nil
	case opt.OffsetOp:
		offsetExpr := expr.AsOffset()
		input, err := f.assignPlaceholders(offsetExpr.Input())
		if err != nil {
			return 0, err
		}
		offset, err := f.assignPlaceholders(offsetExpr.Offset())
		if err != nil {
			return 0, err
		}
		ordering := offsetExpr.Ordering()
		return f.ConstructOffset(input, offset, ordering), nil
	case opt.Max1RowOp:
		max1RowExpr := expr.AsMax1Row()
		input, err := f.assignPlaceholders(max1RowExpr.Input())
		if err != nil {
			return 0, err
		}
		return f.ConstructMax1Row(input), nil
	case opt.ExplainOp:
		explainExpr := expr.AsExplain()
		input, err := f.assignPlaceholders(explainExpr.Input())
		if err != nil {
			return 0, err
		}
		def := explainExpr.Def()
		return f.ConstructExplain(input, def), nil
	case opt.RowNumberOp:
		rowNumberExpr := expr.AsRowNumber()
		input, err := f.assignPlaceholders(rowNumberExpr.Input())
		if err != nil {
			return 0, err
		}
		def := rowNumberExpr.Def()
		return f.ConstructRowNumber(input, def), nil
	case opt.ZipOp:
		zipExpr := expr.AsZip()
		lb := MakeListBuilder(&f.funcs)
		for _, item := range f.mem.LookupList(zipExpr.Funcs()) {
			newItem, err := f.assignPlaceholders(item)
			if err != nil {
				return 0, err
			}
			lb.AddItem(newItem)
		}
		funcs := lb.BuildList()
		cols := zipExpr.Cols()
		return f.ConstructZip(funcs, cols), nil
	case opt.SubqueryOp:
		subqueryExpr := expr.AsSubquery()
		input, err := f.assignPlaceholders(subqueryExpr.Input())
		if err != nil {
			return 0, err
		}
		def := subqueryExpr.Def()
		return f.ConstructSubquery(input, def), nil
	case opt.AnyOp:
		anyExpr := expr.AsAny()
		input, err := f.assignPlaceholders(anyExpr.Input())
		if err != nil {
			return 0, err
		}
		scalar, err := f.assignPlaceholders(anyExpr.Scalar())
		if err != nil {
			return 0, err
		}
		def := anyExpr.Def()
		return f.ConstructAny(input, scalar, def), nil
	case opt.TupleOp:
		tupleExpr := expr.AsTuple()
		lb := MakeListBuilder(&f.funcs)
		for _, item := range f.mem.LookupList(tupleExpr.Elems()) {
			newItem, err := f.assignPlaceholders(item)
			if err != nil {
				return 0, err
			}
			lb.AddItem(newItem)
		}
		elems := lb.BuildList()
		typ := tupleExpr.Typ()
		return f.ConstructTuple(elems, typ), nil
	case opt.ProjectionsOp:
		projectionsExpr := expr.AsProjections()
		lb := MakeListBuilder(&f.funcs)
		for _, item := range f.mem.LookupList(projectionsExpr.Elems()) {
			newItem, err := f.assignPlaceholders(item)
			if err != nil {
				return 0, err
			}
			lb.AddItem(newItem)
		}
		elems := lb.BuildList()
		def := projectionsExpr.Def()
		return f.ConstructProjections(elems, def), nil
	case opt.AggregationsOp:
		aggregationsExpr := expr.AsAggregations()
		lb := MakeListBuilder(&f.funcs)
		for _, item := range f.mem.LookupList(aggregationsExpr.Aggs()) {
			newItem, err := f.assignPlaceholders(item)
			if err != nil {
				return 0, err
			}
			lb.AddItem(newItem)
		}
		aggs := lb.BuildList()
		cols := aggregationsExpr.Cols()
		return f.ConstructAggregations(aggs, cols), nil
	case opt.MergeOnOp:
		mergeOnExpr := expr.AsMergeOn()
		on, err := f.assignPlaceholders(mergeOnExpr.On())
		if err != nil {
			return 0, err
		}
		def := mergeOnExpr.Def()
		return f.ConstructMergeOn(on, def), nil
	case opt.ExistsOp:
		existsExpr := expr.AsExists()
		input, err := f.assignPlaceholders(existsExpr.Input())
		if err != nil {
			return 0, err
		}
		def := existsExpr.Def()
		return f.ConstructExists(input, def), nil
	case opt.FiltersOp:
		filtersExpr := expr.AsFilters()
		lb := MakeListBuilder(&f.funcs)
		for _, item := range f.mem.LookupList(filtersExpr.Conditions()) {
			newItem, err := f.assignPlaceholders(item)
			if err != nil {
				return 0, err
			}
			lb.AddItem(newItem)
		}
		conditions := lb.BuildList()
		return f.ConstructFilters(conditions), nil
	case opt.AndOp:
		andExpr := expr.AsAnd()
		lb := MakeListBuilder(&f.funcs)
		for _, item := range f.mem.LookupList(andExpr.Conditions()) {
			newItem, err := f.assignPlaceholders(item)
			if err != nil {
				return 0, err
			}
			lb.AddItem(newItem)
		}
		conditions := lb.BuildList()
		return f.ConstructAnd(conditions), nil
	case opt.OrOp:
		orExpr := expr.AsOr()
		lb := MakeListBuilder(&f.funcs)
		for _, item := range f.mem.LookupList(orExpr.Conditions()) {
			newItem, err := f.assignPlaceholders(item)
			if err != nil {
				return 0, err
			}
			lb.AddItem(newItem)
		}
		conditions := lb.BuildList()
		return f.ConstructOr(conditions), nil
	case opt.NotOp:
		notExpr := expr.AsNot()
		input, err := f.assignPlaceholders(notExpr.Input())
		if err != nil {
			return 0, err
		}
		return f.ConstructNot(input), nil
	case opt.EqOp:
		eqExpr := expr.AsEq()
		left, err := f.assignPlaceholders(eqExpr.Left())
		if err != nil {
			return 0, err
		}
		right, err := f.assignPlaceholders(eqExpr.Right())
		if err != nil {
			return 0, err
		}
		return f.ConstructEq(left, right), nil
	case opt.LtOp:
		ltExpr := expr.AsLt()
		left, err := f.assignPlaceholders(ltExpr.Left())
		if err != nil {
			return 0, err
		}
		right, err := f.assignPlaceholders(ltExpr.Right())
		if err != nil {
			return 0, err
		}
		return f.ConstructLt(left, right), nil
	case opt.GtOp:
		gtExpr := expr.AsGt()
		left, err := f.assignPlaceholders(gtExpr.Left())
		if err != nil {
			return 0, err
		}
		right, err := f.assignPlaceholders(gtExpr.Right())
		if err != nil {
			return 0, err
		}
		return f.ConstructGt(left, right), nil
	case opt.LeOp:
		leExpr := expr.AsLe()
		left, err := f.assignPlaceholders(leExpr.Left())
		if err != nil {
			return 0, err
		}
		right, err := f.assignPlaceholders(leExpr.Right())
		if err != nil {
			return 0, err
		}
		return f.ConstructLe(left, right), nil
	case opt.GeOp:
		geExpr := expr.AsGe()
		left, err := f.assignPlaceholders(geExpr.Left())
		if err != nil {
			return 0, err
		}
		right, err := f.assignPlaceholders(geExpr.Right())
		if err != nil {
			return 0, err
		}
		return f.ConstructGe(left, right), nil
	case opt.NeOp:
		neExpr := expr.AsNe()
		left, err := f.assignPlaceholders(neExpr.Left())
		if err != nil {
			return 0, err
		}
		right, err := f.assignPlaceholders(neExpr.Right())
		if err != nil {
			return 0, err
		}
		return f.ConstructNe(left, right), nil
	case opt.InOp:
		inExpr := expr.AsIn()
		left, err := f.assignPlaceholders(inExpr.Left())
		if err != nil {
			return 0, err
		}
		right, err := f.assignPlaceholders(inExpr.Right())
		if err != nil {
			return 0, err
		}
		return f.ConstructIn(left, right), nil
	case opt.NotInOp:
		notInExpr := expr.AsNotIn()
		left, err := f.assignPlaceholders(notInExpr.Left())
		if err != nil {
			return 0, err
		}
		right, err := f.assignPlaceholders(notInExpr.Right())
		if err != nil {
			return 0, err
		}
		return f.ConstructNotIn(left, right), nil
	case opt.LikeOp:
		likeExpr := expr.AsLike()
		left, err := f.assignPlaceholders(likeExpr.Left())
		if err != nil {
			return 0, err
		}
		right, err := f.assignPlaceholders(likeExpr.Right())
		if err != nil {
			return 0, err
		}
		return f.ConstructLike(left, right), nil
	case opt.NotLikeOp:
		notLikeExpr := expr.AsNotLike()
		left, err := f.assignPlaceholders(notLikeExpr.Left())
		if err != nil {
			return 0, err
		}
		right, err := f.assignPlaceholders(notLikeExpr.Right())
		if err != nil {
			return 0, err
		}
		return f.ConstructNotLike(left, right), nil
	case opt.ILikeOp:
		iLikeExpr := expr.AsILike()
		left, err := f.assignPlaceholders(iLikeExpr.Left())
		if err != nil {
			return 0, err
		}
		right, err := f.assignPlaceholders(iLikeExpr.Right())
		if err != nil {
			return 0, err
		}
		return f.ConstructILike(left, right), nil
	case opt.NotILikeOp:
		notILikeExpr := expr.AsNotILike()
		left, err := f.assignPlaceholders(notILikeExpr.Left())
		if err != nil {
			return 0, err
		}
		right, err := f.assignPlaceholders(notILikeExpr.Right())
		if err != nil {
			return 0, err
		}
		return f.ConstructNotILike(left, right), nil
	case opt.SimilarToOp:
		similarToExpr := expr.AsSimilarTo()
		left, err := f.assignPlaceholders(similarToExpr.Left())
		if err != nil {
			return 0, err
		}
		right, err := f.assignPlaceholders(similarToExpr.Right())
		if err != nil {
			return 0, err
		}
		return f.ConstructSimilarTo(left, right), nil
	case opt.NotSimilarToOp:
		notSimilarToExpr := expr.AsNotSimilarTo()
		left, err := f.assignPlaceholders(notSimilarToExpr.Left())
		if err != nil {
			return 0, err
		}
		right, err := f.assignPlaceholders(notSimilarToExpr.Right())
		if err != nil {
			return 0, err
		}
		return f.ConstructNotSimilarTo(left, right), nil
	case opt.RegMatchOp:
		regMatchExpr := expr.AsRegMatch()
		left, err := f.assignPlaceholders(regMatchExpr.Left())
		if err != nil {
			return 0, err
		}
		right, err := f.assignPlaceholders(regMatchExpr.Right())
		if err != nil {
			return 0, err
		}
		return f.ConstructRegMatch(left, right), nil
	case opt.NotRegMatchOp:
		notRegMatchExpr := expr.AsNotRegMatch()
		left, err := f.assignPlaceholders(notRegMatchExpr.Left())
		if err != nil {
			return 0, err
		}
		right, err := f.assignPlaceholders(notRegMatchExpr.Right())
		if err != nil {
			return 0, err
		}
		return f.ConstructNotRegMatch(left, right), nil
	case opt.RegIMatchOp:
		regIMatchExpr := expr.AsRegIMatch()
		left, err := f.assignPlaceholders(regIMatchExpr.Left())
		if err != nil {
			return 0, err
		}
		right, err := f.assignPlaceholders(regIMatchExpr.Right())
		if err != nil {
			return 0, err
		}
		return f.ConstructRegIMatch(left, right), nil
	case opt.NotRegIMatchOp:
		notRegIMatchExpr := expr.AsNotRegIMatch()
		left, err := f.assignPlaceholders(notRegIMatchExpr.Left())
		if err != nil {
			return 0, err
		}
		right, err := f.assignPlaceholders(notRegIMatchExpr.Right())
		if err != nil {
			return 0, err
		}
		return f.ConstructNotRegIMatch(left, right), nil
	case opt.IsOp:
		isExpr := expr.AsIs()
		left, err := f.assignPlaceholders(isExpr.Left())
		if err != nil {
			return 0, err
		}
		right, err := f.assignPlaceholders(isExpr.Right())
		if err != nil {
			return 0, err
		}
		return f.ConstructIs(left, right), nil
	case opt.IsNotOp:
		isNotExpr := expr.AsIsNot()
		left, err := f.assignPlaceholders(isNotExpr.Left())
		if err != nil {
			return 0, err
		}
		right, err := f.assignPlaceholders(isNotExpr.Right())
		if err != nil {
			return 0, err
		}
		return f.ConstructIsNot(left, right), nil
	case opt.ContainsOp:
		containsExpr := expr.AsContains()
		left, err := f.assignPlaceholders(containsExpr.Left())
		if err != nil {
			return 0, err
		}
		right, err := f.assignPlaceholders(containsExpr.Right())
		if err != nil {
			return 0, err
		}
		return f.ConstructContains(left, right), nil
	case opt.JsonExistsOp:
		jsonExistsExpr := expr.AsJsonExists()
		left, err := f.assignPlaceholders(jsonExistsExpr.Left())
		if err != nil {
			return 0, err
		}
		right, err := f.assignPlaceholders(jsonExistsExpr.Right())
		if err != nil {
			return 0, err
		}
		return f.ConstructJsonExists(left, right), nil
	case opt.JsonAllExistsOp:
		jsonAllExistsExpr := expr.AsJsonAllExists()
		left, err := f.assignPlaceholders(jsonAllExistsExpr.Left())
		if err != nil {
			return 0, err
		}
		right, err := f.assignPlaceholders(jsonAllExistsExpr.Right())
		if err != nil {
			return 0, err
		}
		return f.ConstructJsonAllExists(left, right), nil
	case opt.JsonSomeExistsOp:
		jsonSomeExistsExpr := expr.AsJsonSomeExists()
		left, err := f.assignPlaceholders(jsonSomeExistsExpr.Left())
		if err != nil {
			return 0, err
		}
		right, err := f.assignPlaceholders(jsonSomeExistsExpr.Right())
		if err != nil {
			return 0, err
		}
		return f.ConstructJsonSomeExists(left, right), nil
	case opt.AnyScalarOp:
		anyScalarExpr := expr.AsAnyScalar()
		left, err := f.assignPlaceholders(anyScalarExpr.Left())
		if err != nil {
			return 0, err
		}
		right, err := f.assignPlaceholders(anyScalarExpr.Right())
		if err != nil {
			return 0, err
		}
		cmp := anyScalarExpr.Cmp()
		return f.ConstructAnyScalar(left, right, cmp), nil
	case opt.BitandOp:
		bitandExpr := expr.AsBitand()
		left, err := f.assignPlaceholders(bitandExpr.Left())
		if err != nil {
			return 0, err
		}
		right, err := f.assignPlaceholders(bitandExpr.Right())
		if err != nil {
			return 0, err
		}
		return f.ConstructBitand(left, right), nil
	case opt.BitorOp:
		bitorExpr := expr.AsBitor()
		left, err := f.assignPlaceholders(bitorExpr.Left())
		if err != nil {
			return 0, err
		}
		right, err := f.assignPlaceholders(bitorExpr.Right())
		if err != nil {
			return 0, err
		}
		return f.ConstructBitor(left, right), nil
	case opt.BitxorOp:
		bitxorExpr := expr.AsBitxor()
		left, err := f.assignPlaceholders(bitxorExpr.Left())
		if err != nil {
			return 0, err
		}
		right, err := f.assignPlaceholders(bitxorExpr.Right())
		if err != nil {
			return 0, err
		}
		return f.ConstructBitxor(left, right), nil
	case opt.PlusOp:
		plusExpr := expr.AsPlus()
		left, err := f.assignPlaceholders(plusExpr.Left())
		if err != nil {
			return 0, err
		}
		right, err := f.assignPlaceholders(plusExpr.Right())
		if err != nil {
			return 0, err
		}
		return f.ConstructPlus(left, right), nil
	case opt.MinusOp:
		minusExpr := expr.AsMinus()
		left, err := f.assignPlaceholders(minusExpr.Left())
		if err != nil {
			return 0, err
		}
		right, err := f.assignPlaceholders(minusExpr.Right())
		if err != nil {
			return 0, err
		}
		return f.ConstructMinus(left, right), nil
	case opt.MultOp:
		multExpr := expr.AsMult()
		left, err := f.assignPlaceholders(multExpr.Left())
		if err != nil {
			return 0, err
		}
		right, err := f.assignPlaceholders(multExpr.Right())
		if err != nil {
			return 0, err
		}
		return f.ConstructMult(left, right), nil
	case opt.DivOp:
		divExpr := expr.AsDiv()
		left, err := f.assignPlaceholders(divExpr.Left())
		if err != nil {
			return 0, err
		}
		right, err := f.assignPlaceholders(divExpr.Right())
		if err != nil {
			return 0, err
		}
		return f.ConstructDiv(left, right), nil
	case opt.FloorDivOp:
		floorDivExpr := expr.AsFloorDiv()
		left, err := f.assignPlaceholders(floorDivExpr.Left())
		if err != nil {
			return 0, err
		}
		right, err := f.assignPlaceholders(floorDivExpr.Right())
		if err != nil {
			return 0, err
		}
		return f.ConstructFloorDiv(left, right), nil
	case opt.ModOp:
		modExpr := expr.AsMod()
		left, err := f.assignPlaceholders(modExpr.Left())
		if err != nil {
			return 0, err
		}
		right, err := f.assignPlaceholders(modExpr.Right())
		if err != nil {
			return 0, err
		}
		return f.ConstructMod(left, right), nil
	case opt.PowOp:
		powExpr := expr.AsPow()
		left, err := f.assignPlaceholders(powExpr.Left())
		if err != nil {
			return 0, err
		}
		right, err := f.assignPlaceholders(powExpr.Right())
		if err != nil {
			return 0, err
		}
		return f.ConstructPow(left, right), nil
	case opt.ConcatOp:
		concatExpr := expr.AsConcat()
		left, err := f.assignPlaceholders(concatExpr.Left())
		if err != nil {
			return 0, err
		}
		right, err := f.assignPlaceholders(concatExpr.Right())
		if err != nil {
			return 0, err
		}
		return f.ConstructConcat(left, right), nil
	case opt.LShiftOp:
		lShiftExpr := expr.AsLShift()
		left, err := f.assignPlaceholders(lShiftExpr.Left())
		if err != nil {
			return 0, err
		}
		right, err := f.assignPlaceholders(lShiftExpr.Right())
		if err != nil {
			return 0, err
		}
		return f.ConstructLShift(left, right), nil
	case opt.RShiftOp:
		rShiftExpr := expr.AsRShift()
		left, err := f.assignPlaceholders(rShiftExpr.Left())
		if err != nil {
			return 0, err
		}
		right, err := f.assignPlaceholders(rShiftExpr.Right())
		if err != nil {
			return 0, err
		}
		return f.ConstructRShift(left, right), nil
	case opt.FetchValOp:
		fetchValExpr := expr.AsFetchVal()
		json, err := f.assignPlaceholders(fetchValExpr.Json())
		if err != nil {
			return 0, err
		}
		index, err := f.assignPlaceholders(fetchValExpr.Index())
		if err != nil {
			return 0, err
		}
		return f.ConstructFetchVal(json, index), nil
	case opt.FetchTextOp:
		fetchTextExpr := expr.AsFetchText()
		json, err := f.assignPlaceholders(fetchTextExpr.Json())
		if err != nil {
			return 0, err
		}
		index, err := f.assignPlaceholders(fetchTextExpr.Index())
		if err != nil {
			return 0, err
		}
		return f.ConstructFetchText(json, index), nil
	case opt.FetchValPathOp:
		fetchValPathExpr := expr.AsFetchValPath()
		json, err := f.assignPlaceholders(fetchValPathExpr.Json())
		if err != nil {
			return 0, err
		}
		path, err := f.assignPlaceholders(fetchValPathExpr.Path())
		if err != nil {
			return 0, err
		}
		return f.ConstructFetchValPath(json, path), nil
	case opt.FetchTextPathOp:
		fetchTextPathExpr := expr.AsFetchTextPath()
		json, err := f.assignPlaceholders(fetchTextPathExpr.Json())
		if err != nil {
			return 0, err
		}
		path, err := f.assignPlaceholders(fetchTextPathExpr.Path())
		if err != nil {
			return 0, err
		}
		return f.ConstructFetchTextPath(json, path), nil
	case opt.UnaryMinusOp:
		unaryMinusExpr := expr.AsUnaryMinus()
		input, err := f.assignPlaceholders(unaryMinusExpr.Input())
		if err != nil {
			return 0, err
		}
		return f.ConstructUnaryMinus(input), nil
	case opt.UnaryComplementOp:
		unaryComplementExpr := expr.AsUnaryComplement()
		input, err := f.assignPlaceholders(unaryComplementExpr.Input())
		if err != nil {
			return 0, err
		}
		return f.ConstructUnaryComplement(input), nil
	case opt.CastOp:
		castExpr := expr.AsCast()
		input, err := f.assignPlaceholders(castExpr.Input())
		if err != nil {
			return 0, err
		}
		targetTyp := castExpr.TargetTyp()
		return f.ConstructCast(input, targetTyp), nil
	case opt.CaseOp:
		caseExpr := expr.AsCase()
		lb := MakeListBuilder(&f.funcs)
		input, err := f.assignPlaceholders(caseExpr.Input())
		if err != nil {
			return 0, err
		}
		for _, item := range f.mem.LookupList(caseExpr.Whens()) {
			newItem, err := f.assignPlaceholders(item)
			if err != nil {
				return 0, err
			}
			lb.AddItem(newItem)
		}
		whens := lb.BuildList()
		return f.ConstructCase(input, whens), nil
	case opt.WhenOp:
		whenExpr := expr.AsWhen()
		condition, err := f.assignPlaceholders(whenExpr.Condition())
		if err != nil {
			return 0, err
		}
		value, err := f.assignPlaceholders(whenExpr.Value())
		if err != nil {
			return 0, err
		}
		return f.ConstructWhen(condition, value), nil
	case opt.ArrayOp:
		arrayExpr := expr.AsArray()
		lb := MakeListBuilder(&f.funcs)
		for _, item := range f.mem.LookupList(arrayExpr.Elems()) {
			newItem, err := f.assignPlaceholders(item)
			if err != nil {
				return 0, err
			}
			lb.AddItem(newItem)
		}
		elems := lb.BuildList()
		typ := arrayExpr.Typ()
		return f.ConstructArray(elems, typ), nil
	case opt.FunctionOp:
		functionExpr := expr.AsFunction()
		lb := MakeListBuilder(&f.funcs)
		for _, item := range f.mem.LookupList(functionExpr.Args()) {
			newItem, err := f.assignPlaceholders(item)
			if err != nil {
				return 0, err
			}
			lb.AddItem(newItem)
		}
		args := lb.BuildList()
		def := functionExpr.Def()
		return f.ConstructFunction(args, def), nil
	case opt.CoalesceOp:
		coalesceExpr := expr.AsCoalesce()
		lb := MakeListBuilder(&f.funcs)
		for _, item := range f.mem.LookupList(coalesceExpr.Args()) {
			newItem, err := f.assignPlaceholders(item)
			if err != nil {
				return 0, err
			}
			lb.AddItem(newItem)
		}
		args := lb.BuildList()
		return f.ConstructCoalesce(args), nil
	case opt.ColumnAccessOp:
		columnAccessExpr := expr.AsColumnAccess()
		input, err := f.assignPlaceholders(columnAccessExpr.Input())
		if err != nil {
			return 0, err
		}
		idx := columnAccessExpr.Idx()
		return f.ConstructColumnAccess(input, idx), nil
	case opt.AggDistinctOp:
		aggDistinctExpr := expr.AsAggDistinct()
		input, err := f.assignPlaceholders(aggDistinctExpr.Input())
		if err != nil {
			return 0, err
		}
		return f.ConstructAggDistinct(input), nil
	case opt.PlaceholderOp:
		value := expr.AsPlaceholder().Value()
		placeholder := f.mem.LookupPrivate(value).(*tree.Placeholder)
		d, err := placeholder.Eval(f.evalCtx)
		if err != nil {
			return 0, err
		}
		return f.ConstructConstVal(d), nil
	}
	panic("unhandled operator")
}

type dynConstructFunc func(f *Factory, operands memo.DynamicOperands) memo.GroupID

var dynConstructLookup [opt.NumOperators]dynConstructFunc

func init() {
	// UnknownOp
	dynConstructLookup[opt.UnknownOp] = func(f *Factory, operands memo.DynamicOperands) memo.GroupID {
		panic("op type not initialized")
	}

	// ScanOp
	dynConstructLookup[opt.ScanOp] = func(f *Factory, operands memo.DynamicOperands) memo.GroupID {
		return f.ConstructScan(memo.PrivateID(operands[0]))
	}

	// VirtualScanOp
	dynConstructLookup[opt.VirtualScanOp] = func(f *Factory, operands memo.DynamicOperands) memo.GroupID {
		return f.ConstructVirtualScan(memo.PrivateID(operands[0]))
	}

	// ValuesOp
	dynConstructLookup[opt.ValuesOp] = func(f *Factory, operands memo.DynamicOperands) memo.GroupID {
		return f.ConstructValues(operands[0].ListID(), memo.PrivateID(operands[1]))
	}

	// SelectOp
	dynConstructLookup[opt.SelectOp] = func(f *Factory, operands memo.DynamicOperands) memo.GroupID {
		return f.ConstructSelect(memo.GroupID(operands[0]), memo.GroupID(operands[1]))
	}

	// ProjectOp
	dynConstructLookup[opt.ProjectOp] = func(f *Factory, operands memo.DynamicOperands) memo.GroupID {
		return f.ConstructProject(memo.GroupID(operands[0]), memo.GroupID(operands[1]))
	}

	// InnerJoinOp
	dynConstructLookup[opt.InnerJoinOp] = func(f *Factory, operands memo.DynamicOperands) memo.GroupID {
		return f.ConstructInnerJoin(memo.GroupID(operands[0]), memo.GroupID(operands[1]), memo.GroupID(operands[2]))
	}

	// LeftJoinOp
	dynConstructLookup[opt.LeftJoinOp] = func(f *Factory, operands memo.DynamicOperands) memo.GroupID {
		return f.ConstructLeftJoin(memo.GroupID(operands[0]), memo.GroupID(operands[1]), memo.GroupID(operands[2]))
	}

	// RightJoinOp
	dynConstructLookup[opt.RightJoinOp] = func(f *Factory, operands memo.DynamicOperands) memo.GroupID {
		return f.ConstructRightJoin(memo.GroupID(operands[0]), memo.GroupID(operands[1]), memo.GroupID(operands[2]))
	}

	// FullJoinOp
	dynConstructLookup[opt.FullJoinOp] = func(f *Factory, operands memo.DynamicOperands) memo.GroupID {
		return f.ConstructFullJoin(memo.GroupID(operands[0]), memo.GroupID(operands[1]), memo.GroupID(operands[2]))
	}

	// SemiJoinOp
	dynConstructLookup[opt.SemiJoinOp] = func(f *Factory, operands memo.DynamicOperands) memo.GroupID {
		return f.ConstructSemiJoin(memo.GroupID(operands[0]), memo.GroupID(operands[1]), memo.GroupID(operands[2]))
	}

	// AntiJoinOp
	dynConstructLookup[opt.AntiJoinOp] = func(f *Factory, operands memo.DynamicOperands) memo.GroupID {
		return f.ConstructAntiJoin(memo.GroupID(operands[0]), memo.GroupID(operands[1]), memo.GroupID(operands[2]))
	}

	// IndexJoinOp
	dynConstructLookup[opt.IndexJoinOp] = func(f *Factory, operands memo.DynamicOperands) memo.GroupID {
		return f.ConstructIndexJoin(memo.GroupID(operands[0]), memo.PrivateID(operands[1]))
	}

	// LookupJoinOp
	dynConstructLookup[opt.LookupJoinOp] = func(f *Factory, operands memo.DynamicOperands) memo.GroupID {
		return f.ConstructLookupJoin(memo.GroupID(operands[0]), memo.GroupID(operands[1]), memo.PrivateID(operands[2]))
	}

	// MergeJoinOp
	dynConstructLookup[opt.MergeJoinOp] = func(f *Factory, operands memo.DynamicOperands) memo.GroupID {
		return f.ConstructMergeJoin(memo.GroupID(operands[0]), memo.GroupID(operands[1]), memo.GroupID(operands[2]))
	}

	// InnerJoinApplyOp
	dynConstructLookup[opt.InnerJoinApplyOp] = func(f *Factory, operands memo.DynamicOperands) memo.GroupID {
		return f.ConstructInnerJoinApply(memo.GroupID(operands[0]), memo.GroupID(operands[1]), memo.GroupID(operands[2]))
	}

	// LeftJoinApplyOp
	dynConstructLookup[opt.LeftJoinApplyOp] = func(f *Factory, operands memo.DynamicOperands) memo.GroupID {
		return f.ConstructLeftJoinApply(memo.GroupID(operands[0]), memo.GroupID(operands[1]), memo.GroupID(operands[2]))
	}

	// RightJoinApplyOp
	dynConstructLookup[opt.RightJoinApplyOp] = func(f *Factory, operands memo.DynamicOperands) memo.GroupID {
		return f.ConstructRightJoinApply(memo.GroupID(operands[0]), memo.GroupID(operands[1]), memo.GroupID(operands[2]))
	}

	// FullJoinApplyOp
	dynConstructLookup[opt.FullJoinApplyOp] = func(f *Factory, operands memo.DynamicOperands) memo.GroupID {
		return f.ConstructFullJoinApply(memo.GroupID(operands[0]), memo.GroupID(operands[1]), memo.GroupID(operands[2]))
	}

	// SemiJoinApplyOp
	dynConstructLookup[opt.SemiJoinApplyOp] = func(f *Factory, operands memo.DynamicOperands) memo.GroupID {
		return f.ConstructSemiJoinApply(memo.GroupID(operands[0]), memo.GroupID(operands[1]), memo.GroupID(operands[2]))
	}

	// AntiJoinApplyOp
	dynConstructLookup[opt.AntiJoinApplyOp] = func(f *Factory, operands memo.DynamicOperands) memo.GroupID {
		return f.ConstructAntiJoinApply(memo.GroupID(operands[0]), memo.GroupID(operands[1]), memo.GroupID(operands[2]))
	}

	// GroupByOp
	dynConstructLookup[opt.GroupByOp] = func(f *Factory, operands memo.DynamicOperands) memo.GroupID {
		return f.ConstructGroupBy(memo.GroupID(operands[0]), memo.GroupID(operands[1]), memo.PrivateID(operands[2]))
	}

	// ScalarGroupByOp
	dynConstructLookup[opt.ScalarGroupByOp] = func(f *Factory, operands memo.DynamicOperands) memo.GroupID {
		return f.ConstructScalarGroupBy(memo.GroupID(operands[0]), memo.GroupID(operands[1]), memo.PrivateID(operands[2]))
	}

	// DistinctOnOp
	dynConstructLookup[opt.DistinctOnOp] = func(f *Factory, operands memo.DynamicOperands) memo.GroupID {
		return f.ConstructDistinctOn(memo.GroupID(operands[0]), memo.GroupID(operands[1]), memo.PrivateID(operands[2]))
	}

	// UnionOp
	dynConstructLookup[opt.UnionOp] = func(f *Factory, operands memo.DynamicOperands) memo.GroupID {
		return f.ConstructUnion(memo.GroupID(operands[0]), memo.GroupID(operands[1]), memo.PrivateID(operands[2]))
	}

	// IntersectOp
	dynConstructLookup[opt.IntersectOp] = func(f *Factory, operands memo.DynamicOperands) memo.GroupID {
		return f.ConstructIntersect(memo.GroupID(operands[0]), memo.GroupID(operands[1]), memo.PrivateID(operands[2]))
	}

	// ExceptOp
	dynConstructLookup[opt.ExceptOp] = func(f *Factory, operands memo.DynamicOperands) memo.GroupID {
		return f.ConstructExcept(memo.GroupID(operands[0]), memo.GroupID(operands[1]), memo.PrivateID(operands[2]))
	}

	// UnionAllOp
	dynConstructLookup[opt.UnionAllOp] = func(f *Factory, operands memo.DynamicOperands) memo.GroupID {
		return f.ConstructUnionAll(memo.GroupID(operands[0]), memo.GroupID(operands[1]), memo.PrivateID(operands[2]))
	}

	// IntersectAllOp
	dynConstructLookup[opt.IntersectAllOp] = func(f *Factory, operands memo.DynamicOperands) memo.GroupID {
		return f.ConstructIntersectAll(memo.GroupID(operands[0]), memo.GroupID(operands[1]), memo.PrivateID(operands[2]))
	}

	// ExceptAllOp
	dynConstructLookup[opt.ExceptAllOp] = func(f *Factory, operands memo.DynamicOperands) memo.GroupID {
		return f.ConstructExceptAll(memo.GroupID(operands[0]), memo.GroupID(operands[1]), memo.PrivateID(operands[2]))
	}

	// LimitOp
	dynConstructLookup[opt.LimitOp] = func(f *Factory, operands memo.DynamicOperands) memo.GroupID {
		return f.ConstructLimit(memo.GroupID(operands[0]), memo.GroupID(operands[1]), memo.PrivateID(operands[2]))
	}

	// OffsetOp
	dynConstructLookup[opt.OffsetOp] = func(f *Factory, operands memo.DynamicOperands) memo.GroupID {
		return f.ConstructOffset(memo.GroupID(operands[0]), memo.GroupID(operands[1]), memo.PrivateID(operands[2]))
	}

	// Max1RowOp
	dynConstructLookup[opt.Max1RowOp] = func(f *Factory, operands memo.DynamicOperands) memo.GroupID {
		return f.ConstructMax1Row(memo.GroupID(operands[0]))
	}

	// ExplainOp
	dynConstructLookup[opt.ExplainOp] = func(f *Factory, operands memo.DynamicOperands) memo.GroupID {
		return f.ConstructExplain(memo.GroupID(operands[0]), memo.PrivateID(operands[1]))
	}

	// ShowTraceForSessionOp
	dynConstructLookup[opt.ShowTraceForSessionOp] = func(f *Factory, operands memo.DynamicOperands) memo.GroupID {
		return f.ConstructShowTraceForSession(memo.PrivateID(operands[0]))
	}

	// RowNumberOp
	dynConstructLookup[opt.RowNumberOp] = func(f *Factory, operands memo.DynamicOperands) memo.GroupID {
		return f.ConstructRowNumber(memo.GroupID(operands[0]), memo.PrivateID(operands[1]))
	}

	// ZipOp
	dynConstructLookup[opt.ZipOp] = func(f *Factory, operands memo.DynamicOperands) memo.GroupID {
		return f.ConstructZip(operands[0].ListID(), memo.PrivateID(operands[1]))
	}

	// SubqueryOp
	dynConstructLookup[opt.SubqueryOp] = func(f *Factory, operands memo.DynamicOperands) memo.GroupID {
		return f.ConstructSubquery(memo.GroupID(operands[0]), memo.PrivateID(operands[1]))
	}

	// AnyOp
	dynConstructLookup[opt.AnyOp] = func(f *Factory, operands memo.DynamicOperands) memo.GroupID {
		return f.ConstructAny(memo.GroupID(operands[0]), memo.GroupID(operands[1]), memo.PrivateID(operands[2]))
	}

	// VariableOp
	dynConstructLookup[opt.VariableOp] = func(f *Factory, operands memo.DynamicOperands) memo.GroupID {
		return f.ConstructVariable(memo.PrivateID(operands[0]))
	}

	// ConstOp
	dynConstructLookup[opt.ConstOp] = func(f *Factory, operands memo.DynamicOperands) memo.GroupID {
		return f.ConstructConst(memo.PrivateID(operands[0]))
	}

	// NullOp
	dynConstructLookup[opt.NullOp] = func(f *Factory, operands memo.DynamicOperands) memo.GroupID {
		return f.ConstructNull(memo.PrivateID(operands[0]))
	}

	// TrueOp
	dynConstructLookup[opt.TrueOp] = func(f *Factory, operands memo.DynamicOperands) memo.GroupID {
		return f.ConstructTrue()
	}

	// FalseOp
	dynConstructLookup[opt.FalseOp] = func(f *Factory, operands memo.DynamicOperands) memo.GroupID {
		return f.ConstructFalse()
	}

	// PlaceholderOp
	dynConstructLookup[opt.PlaceholderOp] = func(f *Factory, operands memo.DynamicOperands) memo.GroupID {
		return f.ConstructPlaceholder(memo.PrivateID(operands[0]))
	}

	// TupleOp
	dynConstructLookup[opt.TupleOp] = func(f *Factory, operands memo.DynamicOperands) memo.GroupID {
		return f.ConstructTuple(operands[0].ListID(), memo.PrivateID(operands[1]))
	}

	// ProjectionsOp
	dynConstructLookup[opt.ProjectionsOp] = func(f *Factory, operands memo.DynamicOperands) memo.GroupID {
		return f.ConstructProjections(operands[0].ListID(), memo.PrivateID(operands[1]))
	}

	// AggregationsOp
	dynConstructLookup[opt.AggregationsOp] = func(f *Factory, operands memo.DynamicOperands) memo.GroupID {
		return f.ConstructAggregations(operands[0].ListID(), memo.PrivateID(operands[1]))
	}

	// MergeOnOp
	dynConstructLookup[opt.MergeOnOp] = func(f *Factory, operands memo.DynamicOperands) memo.GroupID {
		return f.ConstructMergeOn(memo.GroupID(operands[0]), memo.PrivateID(operands[1]))
	}

	// ExistsOp
	dynConstructLookup[opt.ExistsOp] = func(f *Factory, operands memo.DynamicOperands) memo.GroupID {
		return f.ConstructExists(memo.GroupID(operands[0]), memo.PrivateID(operands[1]))
	}

	// FiltersOp
	dynConstructLookup[opt.FiltersOp] = func(f *Factory, operands memo.DynamicOperands) memo.GroupID {
		return f.ConstructFilters(operands[0].ListID())
	}

	// AndOp
	dynConstructLookup[opt.AndOp] = func(f *Factory, operands memo.DynamicOperands) memo.GroupID {
		return f.ConstructAnd(operands[0].ListID())
	}

	// OrOp
	dynConstructLookup[opt.OrOp] = func(f *Factory, operands memo.DynamicOperands) memo.GroupID {
		return f.ConstructOr(operands[0].ListID())
	}

	// NotOp
	dynConstructLookup[opt.NotOp] = func(f *Factory, operands memo.DynamicOperands) memo.GroupID {
		return f.ConstructNot(memo.GroupID(operands[0]))
	}

	// EqOp
	dynConstructLookup[opt.EqOp] = func(f *Factory, operands memo.DynamicOperands) memo.GroupID {
		return f.ConstructEq(memo.GroupID(operands[0]), memo.GroupID(operands[1]))
	}

	// LtOp
	dynConstructLookup[opt.LtOp] = func(f *Factory, operands memo.DynamicOperands) memo.GroupID {
		return f.ConstructLt(memo.GroupID(operands[0]), memo.GroupID(operands[1]))
	}

	// GtOp
	dynConstructLookup[opt.GtOp] = func(f *Factory, operands memo.DynamicOperands) memo.GroupID {
		return f.ConstructGt(memo.GroupID(operands[0]), memo.GroupID(operands[1]))
	}

	// LeOp
	dynConstructLookup[opt.LeOp] = func(f *Factory, operands memo.DynamicOperands) memo.GroupID {
		return f.ConstructLe(memo.GroupID(operands[0]), memo.GroupID(operands[1]))
	}

	// GeOp
	dynConstructLookup[opt.GeOp] = func(f *Factory, operands memo.DynamicOperands) memo.GroupID {
		return f.ConstructGe(memo.GroupID(operands[0]), memo.GroupID(operands[1]))
	}

	// NeOp
	dynConstructLookup[opt.NeOp] = func(f *Factory, operands memo.DynamicOperands) memo.GroupID {
		return f.ConstructNe(memo.GroupID(operands[0]), memo.GroupID(operands[1]))
	}

	// InOp
	dynConstructLookup[opt.InOp] = func(f *Factory, operands memo.DynamicOperands) memo.GroupID {
		return f.ConstructIn(memo.GroupID(operands[0]), memo.GroupID(operands[1]))
	}

	// NotInOp
	dynConstructLookup[opt.NotInOp] = func(f *Factory, operands memo.DynamicOperands) memo.GroupID {
		return f.ConstructNotIn(memo.GroupID(operands[0]), memo.GroupID(operands[1]))
	}

	// LikeOp
	dynConstructLookup[opt.LikeOp] = func(f *Factory, operands memo.DynamicOperands) memo.GroupID {
		return f.ConstructLike(memo.GroupID(operands[0]), memo.GroupID(operands[1]))
	}

	// NotLikeOp
	dynConstructLookup[opt.NotLikeOp] = func(f *Factory, operands memo.DynamicOperands) memo.GroupID {
		return f.ConstructNotLike(memo.GroupID(operands[0]), memo.GroupID(operands[1]))
	}

	// ILikeOp
	dynConstructLookup[opt.ILikeOp] = func(f *Factory, operands memo.DynamicOperands) memo.GroupID {
		return f.ConstructILike(memo.GroupID(operands[0]), memo.GroupID(operands[1]))
	}

	// NotILikeOp
	dynConstructLookup[opt.NotILikeOp] = func(f *Factory, operands memo.DynamicOperands) memo.GroupID {
		return f.ConstructNotILike(memo.GroupID(operands[0]), memo.GroupID(operands[1]))
	}

	// SimilarToOp
	dynConstructLookup[opt.SimilarToOp] = func(f *Factory, operands memo.DynamicOperands) memo.GroupID {
		return f.ConstructSimilarTo(memo.GroupID(operands[0]), memo.GroupID(operands[1]))
	}

	// NotSimilarToOp
	dynConstructLookup[opt.NotSimilarToOp] = func(f *Factory, operands memo.DynamicOperands) memo.GroupID {
		return f.ConstructNotSimilarTo(memo.GroupID(operands[0]), memo.GroupID(operands[1]))
	}

	// RegMatchOp
	dynConstructLookup[opt.RegMatchOp] = func(f *Factory, operands memo.DynamicOperands) memo.GroupID {
		return f.ConstructRegMatch(memo.GroupID(operands[0]), memo.GroupID(operands[1]))
	}

	// NotRegMatchOp
	dynConstructLookup[opt.NotRegMatchOp] = func(f *Factory, operands memo.DynamicOperands) memo.GroupID {
		return f.ConstructNotRegMatch(memo.GroupID(operands[0]), memo.GroupID(operands[1]))
	}

	// RegIMatchOp
	dynConstructLookup[opt.RegIMatchOp] = func(f *Factory, operands memo.DynamicOperands) memo.GroupID {
		return f.ConstructRegIMatch(memo.GroupID(operands[0]), memo.GroupID(operands[1]))
	}

	// NotRegIMatchOp
	dynConstructLookup[opt.NotRegIMatchOp] = func(f *Factory, operands memo.DynamicOperands) memo.GroupID {
		return f.ConstructNotRegIMatch(memo.GroupID(operands[0]), memo.GroupID(operands[1]))
	}

	// IsOp
	dynConstructLookup[opt.IsOp] = func(f *Factory, operands memo.DynamicOperands) memo.GroupID {
		return f.ConstructIs(memo.GroupID(operands[0]), memo.GroupID(operands[1]))
	}

	// IsNotOp
	dynConstructLookup[opt.IsNotOp] = func(f *Factory, operands memo.DynamicOperands) memo.GroupID {
		return f.ConstructIsNot(memo.GroupID(operands[0]), memo.GroupID(operands[1]))
	}

	// ContainsOp
	dynConstructLookup[opt.ContainsOp] = func(f *Factory, operands memo.DynamicOperands) memo.GroupID {
		return f.ConstructContains(memo.GroupID(operands[0]), memo.GroupID(operands[1]))
	}

	// JsonExistsOp
	dynConstructLookup[opt.JsonExistsOp] = func(f *Factory, operands memo.DynamicOperands) memo.GroupID {
		return f.ConstructJsonExists(memo.GroupID(operands[0]), memo.GroupID(operands[1]))
	}

	// JsonAllExistsOp
	dynConstructLookup[opt.JsonAllExistsOp] = func(f *Factory, operands memo.DynamicOperands) memo.GroupID {
		return f.ConstructJsonAllExists(memo.GroupID(operands[0]), memo.GroupID(operands[1]))
	}

	// JsonSomeExistsOp
	dynConstructLookup[opt.JsonSomeExistsOp] = func(f *Factory, operands memo.DynamicOperands) memo.GroupID {
		return f.ConstructJsonSomeExists(memo.GroupID(operands[0]), memo.GroupID(operands[1]))
	}

	// AnyScalarOp
	dynConstructLookup[opt.AnyScalarOp] = func(f *Factory, operands memo.DynamicOperands) memo.GroupID {
		return f.ConstructAnyScalar(memo.GroupID(operands[0]), memo.GroupID(operands[1]), memo.PrivateID(operands[2]))
	}

	// BitandOp
	dynConstructLookup[opt.BitandOp] = func(f *Factory, operands memo.DynamicOperands) memo.GroupID {
		return f.ConstructBitand(memo.GroupID(operands[0]), memo.GroupID(operands[1]))
	}

	// BitorOp
	dynConstructLookup[opt.BitorOp] = func(f *Factory, operands memo.DynamicOperands) memo.GroupID {
		return f.ConstructBitor(memo.GroupID(operands[0]), memo.GroupID(operands[1]))
	}

	// BitxorOp
	dynConstructLookup[opt.BitxorOp] = func(f *Factory, operands memo.DynamicOperands) memo.GroupID {
		return f.ConstructBitxor(memo.GroupID(operands[0]), memo.GroupID(operands[1]))
	}

	// PlusOp
	dynConstructLookup[opt.PlusOp] = func(f *Factory, operands memo.DynamicOperands) memo.GroupID {
		return f.ConstructPlus(memo.GroupID(operands[0]), memo.GroupID(operands[1]))
	}

	// MinusOp
	dynConstructLookup[opt.MinusOp] = func(f *Factory, operands memo.DynamicOperands) memo.GroupID {
		return f.ConstructMinus(memo.GroupID(operands[0]), memo.GroupID(operands[1]))
	}

	// MultOp
	dynConstructLookup[opt.MultOp] = func(f *Factory, operands memo.DynamicOperands) memo.GroupID {
		return f.ConstructMult(memo.GroupID(operands[0]), memo.GroupID(operands[1]))
	}

	// DivOp
	dynConstructLookup[opt.DivOp] = func(f *Factory, operands memo.DynamicOperands) memo.GroupID {
		return f.ConstructDiv(memo.GroupID(operands[0]), memo.GroupID(operands[1]))
	}

	// FloorDivOp
	dynConstructLookup[opt.FloorDivOp] = func(f *Factory, operands memo.DynamicOperands) memo.GroupID {
		return f.ConstructFloorDiv(memo.GroupID(operands[0]), memo.GroupID(operands[1]))
	}

	// ModOp
	dynConstructLookup[opt.ModOp] = func(f *Factory, operands memo.DynamicOperands) memo.GroupID {
		return f.ConstructMod(memo.GroupID(operands[0]), memo.GroupID(operands[1]))
	}

	// PowOp
	dynConstructLookup[opt.PowOp] = func(f *Factory, operands memo.DynamicOperands) memo.GroupID {
		return f.ConstructPow(memo.GroupID(operands[0]), memo.GroupID(operands[1]))
	}

	// ConcatOp
	dynConstructLookup[opt.ConcatOp] = func(f *Factory, operands memo.DynamicOperands) memo.GroupID {
		return f.ConstructConcat(memo.GroupID(operands[0]), memo.GroupID(operands[1]))
	}

	// LShiftOp
	dynConstructLookup[opt.LShiftOp] = func(f *Factory, operands memo.DynamicOperands) memo.GroupID {
		return f.ConstructLShift(memo.GroupID(operands[0]), memo.GroupID(operands[1]))
	}

	// RShiftOp
	dynConstructLookup[opt.RShiftOp] = func(f *Factory, operands memo.DynamicOperands) memo.GroupID {
		return f.ConstructRShift(memo.GroupID(operands[0]), memo.GroupID(operands[1]))
	}

	// FetchValOp
	dynConstructLookup[opt.FetchValOp] = func(f *Factory, operands memo.DynamicOperands) memo.GroupID {
		return f.ConstructFetchVal(memo.GroupID(operands[0]), memo.GroupID(operands[1]))
	}

	// FetchTextOp
	dynConstructLookup[opt.FetchTextOp] = func(f *Factory, operands memo.DynamicOperands) memo.GroupID {
		return f.ConstructFetchText(memo.GroupID(operands[0]), memo.GroupID(operands[1]))
	}

	// FetchValPathOp
	dynConstructLookup[opt.FetchValPathOp] = func(f *Factory, operands memo.DynamicOperands) memo.GroupID {
		return f.ConstructFetchValPath(memo.GroupID(operands[0]), memo.GroupID(operands[1]))
	}

	// FetchTextPathOp
	dynConstructLookup[opt.FetchTextPathOp] = func(f *Factory, operands memo.DynamicOperands) memo.GroupID {
		return f.ConstructFetchTextPath(memo.GroupID(operands[0]), memo.GroupID(operands[1]))
	}

	// UnaryMinusOp
	dynConstructLookup[opt.UnaryMinusOp] = func(f *Factory, operands memo.DynamicOperands) memo.GroupID {
		return f.ConstructUnaryMinus(memo.GroupID(operands[0]))
	}

	// UnaryComplementOp
	dynConstructLookup[opt.UnaryComplementOp] = func(f *Factory, operands memo.DynamicOperands) memo.GroupID {
		return f.ConstructUnaryComplement(memo.GroupID(operands[0]))
	}

	// CastOp
	dynConstructLookup[opt.CastOp] = func(f *Factory, operands memo.DynamicOperands) memo.GroupID {
		return f.ConstructCast(memo.GroupID(operands[0]), memo.PrivateID(operands[1]))
	}

	// CaseOp
	dynConstructLookup[opt.CaseOp] = func(f *Factory, operands memo.DynamicOperands) memo.GroupID {
		return f.ConstructCase(memo.GroupID(operands[0]), operands[1].ListID())
	}

	// WhenOp
	dynConstructLookup[opt.WhenOp] = func(f *Factory, operands memo.DynamicOperands) memo.GroupID {
		return f.ConstructWhen(memo.GroupID(operands[0]), memo.GroupID(operands[1]))
	}

	// ArrayOp
	dynConstructLookup[opt.ArrayOp] = func(f *Factory, operands memo.DynamicOperands) memo.GroupID {
		return f.ConstructArray(operands[0].ListID(), memo.PrivateID(operands[1]))
	}

	// FunctionOp
	dynConstructLookup[opt.FunctionOp] = func(f *Factory, operands memo.DynamicOperands) memo.GroupID {
		return f.ConstructFunction(operands[0].ListID(), memo.PrivateID(operands[1]))
	}

	// CoalesceOp
	dynConstructLookup[opt.CoalesceOp] = func(f *Factory, operands memo.DynamicOperands) memo.GroupID {
		return f.ConstructCoalesce(operands[0].ListID())
	}

	// ColumnAccessOp
	dynConstructLookup[opt.ColumnAccessOp] = func(f *Factory, operands memo.DynamicOperands) memo.GroupID {
		return f.ConstructColumnAccess(memo.GroupID(operands[0]), memo.PrivateID(operands[1]))
	}

	// UnsupportedExprOp
	dynConstructLookup[opt.UnsupportedExprOp] = func(f *Factory, operands memo.DynamicOperands) memo.GroupID {
		return f.ConstructUnsupportedExpr(memo.PrivateID(operands[0]))
	}

	// ArrayAggOp
	dynConstructLookup[opt.ArrayAggOp] = func(f *Factory, operands memo.DynamicOperands) memo.GroupID {
		return f.ConstructArrayAgg(memo.GroupID(operands[0]))
	}

	// AvgOp
	dynConstructLookup[opt.AvgOp] = func(f *Factory, operands memo.DynamicOperands) memo.GroupID {
		return f.ConstructAvg(memo.GroupID(operands[0]))
	}

	// BoolAndOp
	dynConstructLookup[opt.BoolAndOp] = func(f *Factory, operands memo.DynamicOperands) memo.GroupID {
		return f.ConstructBoolAnd(memo.GroupID(operands[0]))
	}

	// BoolOrOp
	dynConstructLookup[opt.BoolOrOp] = func(f *Factory, operands memo.DynamicOperands) memo.GroupID {
		return f.ConstructBoolOr(memo.GroupID(operands[0]))
	}

	// ConcatAggOp
	dynConstructLookup[opt.ConcatAggOp] = func(f *Factory, operands memo.DynamicOperands) memo.GroupID {
		return f.ConstructConcatAgg(memo.GroupID(operands[0]))
	}

	// CountOp
	dynConstructLookup[opt.CountOp] = func(f *Factory, operands memo.DynamicOperands) memo.GroupID {
		return f.ConstructCount(memo.GroupID(operands[0]))
	}

	// CountRowsOp
	dynConstructLookup[opt.CountRowsOp] = func(f *Factory, operands memo.DynamicOperands) memo.GroupID {
		return f.ConstructCountRows()
	}

	// MaxOp
	dynConstructLookup[opt.MaxOp] = func(f *Factory, operands memo.DynamicOperands) memo.GroupID {
		return f.ConstructMax(memo.GroupID(operands[0]))
	}

	// MinOp
	dynConstructLookup[opt.MinOp] = func(f *Factory, operands memo.DynamicOperands) memo.GroupID {
		return f.ConstructMin(memo.GroupID(operands[0]))
	}

	// SumIntOp
	dynConstructLookup[opt.SumIntOp] = func(f *Factory, operands memo.DynamicOperands) memo.GroupID {
		return f.ConstructSumInt(memo.GroupID(operands[0]))
	}

	// SumOp
	dynConstructLookup[opt.SumOp] = func(f *Factory, operands memo.DynamicOperands) memo.GroupID {
		return f.ConstructSum(memo.GroupID(operands[0]))
	}

	// SqrDiffOp
	dynConstructLookup[opt.SqrDiffOp] = func(f *Factory, operands memo.DynamicOperands) memo.GroupID {
		return f.ConstructSqrDiff(memo.GroupID(operands[0]))
	}

	// VarianceOp
	dynConstructLookup[opt.VarianceOp] = func(f *Factory, operands memo.DynamicOperands) memo.GroupID {
		return f.ConstructVariance(memo.GroupID(operands[0]))
	}

	// StdDevOp
	dynConstructLookup[opt.StdDevOp] = func(f *Factory, operands memo.DynamicOperands) memo.GroupID {
		return f.ConstructStdDev(memo.GroupID(operands[0]))
	}

	// XorAggOp
	dynConstructLookup[opt.XorAggOp] = func(f *Factory, operands memo.DynamicOperands) memo.GroupID {
		return f.ConstructXorAgg(memo.GroupID(operands[0]))
	}

	// JsonAggOp
	dynConstructLookup[opt.JsonAggOp] = func(f *Factory, operands memo.DynamicOperands) memo.GroupID {
		return f.ConstructJsonAgg(memo.GroupID(operands[0]))
	}

	// JsonbAggOp
	dynConstructLookup[opt.JsonbAggOp] = func(f *Factory, operands memo.DynamicOperands) memo.GroupID {
		return f.ConstructJsonbAgg(memo.GroupID(operands[0]))
	}

	// ConstAggOp
	dynConstructLookup[opt.ConstAggOp] = func(f *Factory, operands memo.DynamicOperands) memo.GroupID {
		return f.ConstructConstAgg(memo.GroupID(operands[0]))
	}

	// ConstNotNullAggOp
	dynConstructLookup[opt.ConstNotNullAggOp] = func(f *Factory, operands memo.DynamicOperands) memo.GroupID {
		return f.ConstructConstNotNullAgg(memo.GroupID(operands[0]))
	}

	// AnyNotNullAggOp
	dynConstructLookup[opt.AnyNotNullAggOp] = func(f *Factory, operands memo.DynamicOperands) memo.GroupID {
		return f.ConstructAnyNotNullAgg(memo.GroupID(operands[0]))
	}

	// FirstAggOp
	dynConstructLookup[opt.FirstAggOp] = func(f *Factory, operands memo.DynamicOperands) memo.GroupID {
		return f.ConstructFirstAgg(memo.GroupID(operands[0]))
	}

	// AggDistinctOp
	dynConstructLookup[opt.AggDistinctOp] = func(f *Factory, operands memo.DynamicOperands) memo.GroupID {
		return f.ConstructAggDistinct(memo.GroupID(operands[0]))
	}

}

func (f *Factory) DynamicConstruct(op opt.Operator, operands memo.DynamicOperands) memo.GroupID {
	return dynConstructLookup[op](f, operands)
}
