// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package acl

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// CreateACLFrontendCreatedCode is the HTTP code returned for type CreateACLFrontendCreated
const CreateACLFrontendCreatedCode int = 201

/*
CreateACLFrontendCreated ACL line created

swagger:response createAclFrontendCreated
*/
type CreateACLFrontendCreated struct {

	/*
	  In: Body
	*/
	Payload *models.ACL `json:"body,omitempty"`
}

// NewCreateACLFrontendCreated creates CreateACLFrontendCreated with default headers values
func NewCreateACLFrontendCreated() *CreateACLFrontendCreated {

	return &CreateACLFrontendCreated{}
}

// WithPayload adds the payload to the create Acl frontend created response
func (o *CreateACLFrontendCreated) WithPayload(payload *models.ACL) *CreateACLFrontendCreated {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create Acl frontend created response
func (o *CreateACLFrontendCreated) SetPayload(payload *models.ACL) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateACLFrontendCreated) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(201)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// CreateACLFrontendAcceptedCode is the HTTP code returned for type CreateACLFrontendAccepted
const CreateACLFrontendAcceptedCode int = 202

/*
CreateACLFrontendAccepted Configuration change accepted and reload requested

swagger:response createAclFrontendAccepted
*/
type CreateACLFrontendAccepted struct {
	/*ID of the requested reload

	 */
	ReloadID string `json:"Reload-ID"`

	/*
	  In: Body
	*/
	Payload *models.ACL `json:"body,omitempty"`
}

// NewCreateACLFrontendAccepted creates CreateACLFrontendAccepted with default headers values
func NewCreateACLFrontendAccepted() *CreateACLFrontendAccepted {

	return &CreateACLFrontendAccepted{}
}

// WithReloadID adds the reloadId to the create Acl frontend accepted response
func (o *CreateACLFrontendAccepted) WithReloadID(reloadID string) *CreateACLFrontendAccepted {
	o.ReloadID = reloadID
	return o
}

// SetReloadID sets the reloadId to the create Acl frontend accepted response
func (o *CreateACLFrontendAccepted) SetReloadID(reloadID string) {
	o.ReloadID = reloadID
}

// WithPayload adds the payload to the create Acl frontend accepted response
func (o *CreateACLFrontendAccepted) WithPayload(payload *models.ACL) *CreateACLFrontendAccepted {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create Acl frontend accepted response
func (o *CreateACLFrontendAccepted) SetPayload(payload *models.ACL) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateACLFrontendAccepted) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Reload-ID

	reloadID := o.ReloadID
	if reloadID != "" {
		rw.Header().Set("Reload-ID", reloadID)
	}

	rw.WriteHeader(202)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// CreateACLFrontendBadRequestCode is the HTTP code returned for type CreateACLFrontendBadRequest
const CreateACLFrontendBadRequestCode int = 400

/*
CreateACLFrontendBadRequest Bad request

swagger:response createAclFrontendBadRequest
*/
type CreateACLFrontendBadRequest struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewCreateACLFrontendBadRequest creates CreateACLFrontendBadRequest with default headers values
func NewCreateACLFrontendBadRequest() *CreateACLFrontendBadRequest {

	return &CreateACLFrontendBadRequest{}
}

// WithConfigurationVersion adds the configurationVersion to the create Acl frontend bad request response
func (o *CreateACLFrontendBadRequest) WithConfigurationVersion(configurationVersion string) *CreateACLFrontendBadRequest {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the create Acl frontend bad request response
func (o *CreateACLFrontendBadRequest) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the create Acl frontend bad request response
func (o *CreateACLFrontendBadRequest) WithPayload(payload *models.Error) *CreateACLFrontendBadRequest {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create Acl frontend bad request response
func (o *CreateACLFrontendBadRequest) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateACLFrontendBadRequest) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(400)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// CreateACLFrontendConflictCode is the HTTP code returned for type CreateACLFrontendConflict
const CreateACLFrontendConflictCode int = 409

/*
CreateACLFrontendConflict The specified resource already exists

swagger:response createAclFrontendConflict
*/
type CreateACLFrontendConflict struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewCreateACLFrontendConflict creates CreateACLFrontendConflict with default headers values
func NewCreateACLFrontendConflict() *CreateACLFrontendConflict {

	return &CreateACLFrontendConflict{}
}

// WithConfigurationVersion adds the configurationVersion to the create Acl frontend conflict response
func (o *CreateACLFrontendConflict) WithConfigurationVersion(configurationVersion string) *CreateACLFrontendConflict {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the create Acl frontend conflict response
func (o *CreateACLFrontendConflict) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the create Acl frontend conflict response
func (o *CreateACLFrontendConflict) WithPayload(payload *models.Error) *CreateACLFrontendConflict {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create Acl frontend conflict response
func (o *CreateACLFrontendConflict) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateACLFrontendConflict) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(409)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
CreateACLFrontendDefault General Error

swagger:response createAclFrontendDefault
*/
type CreateACLFrontendDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewCreateACLFrontendDefault creates CreateACLFrontendDefault with default headers values
func NewCreateACLFrontendDefault(code int) *CreateACLFrontendDefault {
	if code <= 0 {
		code = 500
	}

	return &CreateACLFrontendDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the create Acl frontend default response
func (o *CreateACLFrontendDefault) WithStatusCode(code int) *CreateACLFrontendDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the create Acl frontend default response
func (o *CreateACLFrontendDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the create Acl frontend default response
func (o *CreateACLFrontendDefault) WithConfigurationVersion(configurationVersion string) *CreateACLFrontendDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the create Acl frontend default response
func (o *CreateACLFrontendDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the create Acl frontend default response
func (o *CreateACLFrontendDefault) WithPayload(payload *models.Error) *CreateACLFrontendDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create Acl frontend default response
func (o *CreateACLFrontendDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateACLFrontendDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
