// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package bind

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// DeleteBindPeerAcceptedCode is the HTTP code returned for type DeleteBindPeerAccepted
const DeleteBindPeerAcceptedCode int = 202

/*
DeleteBindPeerAccepted Configuration change accepted and reload requested

swagger:response deleteBindPeerAccepted
*/
type DeleteBindPeerAccepted struct {
	/*ID of the requested reload

	 */
	ReloadID string `json:"Reload-ID"`
}

// NewDeleteBindPeerAccepted creates DeleteBindPeerAccepted with default headers values
func NewDeleteBindPeerAccepted() *DeleteBindPeerAccepted {

	return &DeleteBindPeerAccepted{}
}

// WithReloadID adds the reloadId to the delete bind peer accepted response
func (o *DeleteBindPeerAccepted) WithReloadID(reloadID string) *DeleteBindPeerAccepted {
	o.ReloadID = reloadID
	return o
}

// SetReloadID sets the reloadId to the delete bind peer accepted response
func (o *DeleteBindPeerAccepted) SetReloadID(reloadID string) {
	o.ReloadID = reloadID
}

// WriteResponse to the client
func (o *DeleteBindPeerAccepted) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Reload-ID

	reloadID := o.ReloadID
	if reloadID != "" {
		rw.Header().Set("Reload-ID", reloadID)
	}

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(202)
}

// DeleteBindPeerNoContentCode is the HTTP code returned for type DeleteBindPeerNoContent
const DeleteBindPeerNoContentCode int = 204

/*
DeleteBindPeerNoContent Bind deleted

swagger:response deleteBindPeerNoContent
*/
type DeleteBindPeerNoContent struct {
}

// NewDeleteBindPeerNoContent creates DeleteBindPeerNoContent with default headers values
func NewDeleteBindPeerNoContent() *DeleteBindPeerNoContent {

	return &DeleteBindPeerNoContent{}
}

// WriteResponse to the client
func (o *DeleteBindPeerNoContent) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(204)
}

// DeleteBindPeerNotFoundCode is the HTTP code returned for type DeleteBindPeerNotFound
const DeleteBindPeerNotFoundCode int = 404

/*
DeleteBindPeerNotFound The specified resource was not found

swagger:response deleteBindPeerNotFound
*/
type DeleteBindPeerNotFound struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewDeleteBindPeerNotFound creates DeleteBindPeerNotFound with default headers values
func NewDeleteBindPeerNotFound() *DeleteBindPeerNotFound {

	return &DeleteBindPeerNotFound{}
}

// WithConfigurationVersion adds the configurationVersion to the delete bind peer not found response
func (o *DeleteBindPeerNotFound) WithConfigurationVersion(configurationVersion string) *DeleteBindPeerNotFound {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the delete bind peer not found response
func (o *DeleteBindPeerNotFound) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the delete bind peer not found response
func (o *DeleteBindPeerNotFound) WithPayload(payload *models.Error) *DeleteBindPeerNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the delete bind peer not found response
func (o *DeleteBindPeerNotFound) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *DeleteBindPeerNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
DeleteBindPeerDefault General Error

swagger:response deleteBindPeerDefault
*/
type DeleteBindPeerDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewDeleteBindPeerDefault creates DeleteBindPeerDefault with default headers values
func NewDeleteBindPeerDefault(code int) *DeleteBindPeerDefault {
	if code <= 0 {
		code = 500
	}

	return &DeleteBindPeerDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the delete bind peer default response
func (o *DeleteBindPeerDefault) WithStatusCode(code int) *DeleteBindPeerDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the delete bind peer default response
func (o *DeleteBindPeerDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the delete bind peer default response
func (o *DeleteBindPeerDefault) WithConfigurationVersion(configurationVersion string) *DeleteBindPeerDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the delete bind peer default response
func (o *DeleteBindPeerDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the delete bind peer default response
func (o *DeleteBindPeerDefault) WithPayload(payload *models.Error) *DeleteBindPeerDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the delete bind peer default response
func (o *DeleteBindPeerDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *DeleteBindPeerDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
