// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package crt_load

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// GetCrtLoadOKCode is the HTTP code returned for type GetCrtLoadOK
const GetCrtLoadOKCode int = 200

/*
GetCrtLoadOK Successful operation

swagger:response getCrtLoadOK
*/
type GetCrtLoadOK struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.CrtLoad `json:"body,omitempty"`
}

// NewGetCrtLoadOK creates GetCrtLoadOK with default headers values
func NewGetCrtLoadOK() *GetCrtLoadOK {

	return &GetCrtLoadOK{}
}

// WithConfigurationVersion adds the configurationVersion to the get crt load o k response
func (o *GetCrtLoadOK) WithConfigurationVersion(configurationVersion string) *GetCrtLoadOK {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get crt load o k response
func (o *GetCrtLoadOK) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get crt load o k response
func (o *GetCrtLoadOK) WithPayload(payload *models.CrtLoad) *GetCrtLoadOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get crt load o k response
func (o *GetCrtLoadOK) SetPayload(payload *models.CrtLoad) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetCrtLoadOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(200)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// GetCrtLoadNotFoundCode is the HTTP code returned for type GetCrtLoadNotFound
const GetCrtLoadNotFoundCode int = 404

/*
GetCrtLoadNotFound The specified resource was not found

swagger:response getCrtLoadNotFound
*/
type GetCrtLoadNotFound struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetCrtLoadNotFound creates GetCrtLoadNotFound with default headers values
func NewGetCrtLoadNotFound() *GetCrtLoadNotFound {

	return &GetCrtLoadNotFound{}
}

// WithConfigurationVersion adds the configurationVersion to the get crt load not found response
func (o *GetCrtLoadNotFound) WithConfigurationVersion(configurationVersion string) *GetCrtLoadNotFound {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get crt load not found response
func (o *GetCrtLoadNotFound) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get crt load not found response
func (o *GetCrtLoadNotFound) WithPayload(payload *models.Error) *GetCrtLoadNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get crt load not found response
func (o *GetCrtLoadNotFound) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetCrtLoadNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
GetCrtLoadDefault General Error

swagger:response getCrtLoadDefault
*/
type GetCrtLoadDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetCrtLoadDefault creates GetCrtLoadDefault with default headers values
func NewGetCrtLoadDefault(code int) *GetCrtLoadDefault {
	if code <= 0 {
		code = 500
	}

	return &GetCrtLoadDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the get crt load default response
func (o *GetCrtLoadDefault) WithStatusCode(code int) *GetCrtLoadDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the get crt load default response
func (o *GetCrtLoadDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the get crt load default response
func (o *GetCrtLoadDefault) WithConfigurationVersion(configurationVersion string) *GetCrtLoadDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get crt load default response
func (o *GetCrtLoadDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get crt load default response
func (o *GetCrtLoadDefault) WithPayload(payload *models.Error) *GetCrtLoadDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get crt load default response
func (o *GetCrtLoadDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetCrtLoadDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
