// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package http_check

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// GetHTTPCheckBackendOKCode is the HTTP code returned for type GetHTTPCheckBackendOK
const GetHTTPCheckBackendOKCode int = 200

/*
GetHTTPCheckBackendOK Successful operation

swagger:response getHttpCheckBackendOK
*/
type GetHTTPCheckBackendOK struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.HTTPCheck `json:"body,omitempty"`
}

// NewGetHTTPCheckBackendOK creates GetHTTPCheckBackendOK with default headers values
func NewGetHTTPCheckBackendOK() *GetHTTPCheckBackendOK {

	return &GetHTTPCheckBackendOK{}
}

// WithConfigurationVersion adds the configurationVersion to the get Http check backend o k response
func (o *GetHTTPCheckBackendOK) WithConfigurationVersion(configurationVersion string) *GetHTTPCheckBackendOK {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get Http check backend o k response
func (o *GetHTTPCheckBackendOK) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get Http check backend o k response
func (o *GetHTTPCheckBackendOK) WithPayload(payload *models.HTTPCheck) *GetHTTPCheckBackendOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get Http check backend o k response
func (o *GetHTTPCheckBackendOK) SetPayload(payload *models.HTTPCheck) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetHTTPCheckBackendOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(200)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// GetHTTPCheckBackendNotFoundCode is the HTTP code returned for type GetHTTPCheckBackendNotFound
const GetHTTPCheckBackendNotFoundCode int = 404

/*
GetHTTPCheckBackendNotFound The specified resource was not found

swagger:response getHttpCheckBackendNotFound
*/
type GetHTTPCheckBackendNotFound struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetHTTPCheckBackendNotFound creates GetHTTPCheckBackendNotFound with default headers values
func NewGetHTTPCheckBackendNotFound() *GetHTTPCheckBackendNotFound {

	return &GetHTTPCheckBackendNotFound{}
}

// WithConfigurationVersion adds the configurationVersion to the get Http check backend not found response
func (o *GetHTTPCheckBackendNotFound) WithConfigurationVersion(configurationVersion string) *GetHTTPCheckBackendNotFound {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get Http check backend not found response
func (o *GetHTTPCheckBackendNotFound) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get Http check backend not found response
func (o *GetHTTPCheckBackendNotFound) WithPayload(payload *models.Error) *GetHTTPCheckBackendNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get Http check backend not found response
func (o *GetHTTPCheckBackendNotFound) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetHTTPCheckBackendNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
GetHTTPCheckBackendDefault General Error

swagger:response getHttpCheckBackendDefault
*/
type GetHTTPCheckBackendDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetHTTPCheckBackendDefault creates GetHTTPCheckBackendDefault with default headers values
func NewGetHTTPCheckBackendDefault(code int) *GetHTTPCheckBackendDefault {
	if code <= 0 {
		code = 500
	}

	return &GetHTTPCheckBackendDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the get HTTP check backend default response
func (o *GetHTTPCheckBackendDefault) WithStatusCode(code int) *GetHTTPCheckBackendDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the get HTTP check backend default response
func (o *GetHTTPCheckBackendDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the get HTTP check backend default response
func (o *GetHTTPCheckBackendDefault) WithConfigurationVersion(configurationVersion string) *GetHTTPCheckBackendDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get HTTP check backend default response
func (o *GetHTTPCheckBackendDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get HTTP check backend default response
func (o *GetHTTPCheckBackendDefault) WithPayload(payload *models.Error) *GetHTTPCheckBackendDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get HTTP check backend default response
func (o *GetHTTPCheckBackendDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetHTTPCheckBackendDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
