// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package http_response_rule

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// ReplaceAllHTTPResponseRuleBackendOKCode is the HTTP code returned for type ReplaceAllHTTPResponseRuleBackendOK
const ReplaceAllHTTPResponseRuleBackendOKCode int = 200

/*
ReplaceAllHTTPResponseRuleBackendOK All HTTP Response Rule lines replaced

swagger:response replaceAllHttpResponseRuleBackendOK
*/
type ReplaceAllHTTPResponseRuleBackendOK struct {

	/*
	  In: Body
	*/
	Payload models.HTTPResponseRules `json:"body,omitempty"`
}

// NewReplaceAllHTTPResponseRuleBackendOK creates ReplaceAllHTTPResponseRuleBackendOK with default headers values
func NewReplaceAllHTTPResponseRuleBackendOK() *ReplaceAllHTTPResponseRuleBackendOK {

	return &ReplaceAllHTTPResponseRuleBackendOK{}
}

// WithPayload adds the payload to the replace all Http response rule backend o k response
func (o *ReplaceAllHTTPResponseRuleBackendOK) WithPayload(payload models.HTTPResponseRules) *ReplaceAllHTTPResponseRuleBackendOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace all Http response rule backend o k response
func (o *ReplaceAllHTTPResponseRuleBackendOK) SetPayload(payload models.HTTPResponseRules) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceAllHTTPResponseRuleBackendOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(200)
	payload := o.Payload
	if payload == nil {
		// return empty array
		payload = models.HTTPResponseRules{}
	}

	if err := producer.Produce(rw, payload); err != nil {
		panic(err) // let the recovery middleware deal with this
	}
}

// ReplaceAllHTTPResponseRuleBackendAcceptedCode is the HTTP code returned for type ReplaceAllHTTPResponseRuleBackendAccepted
const ReplaceAllHTTPResponseRuleBackendAcceptedCode int = 202

/*
ReplaceAllHTTPResponseRuleBackendAccepted Configuration change accepted and reload requested

swagger:response replaceAllHttpResponseRuleBackendAccepted
*/
type ReplaceAllHTTPResponseRuleBackendAccepted struct {
	/*ID of the requested reload

	 */
	ReloadID string `json:"Reload-ID"`

	/*
	  In: Body
	*/
	Payload models.HTTPResponseRules `json:"body,omitempty"`
}

// NewReplaceAllHTTPResponseRuleBackendAccepted creates ReplaceAllHTTPResponseRuleBackendAccepted with default headers values
func NewReplaceAllHTTPResponseRuleBackendAccepted() *ReplaceAllHTTPResponseRuleBackendAccepted {

	return &ReplaceAllHTTPResponseRuleBackendAccepted{}
}

// WithReloadID adds the reloadId to the replace all Http response rule backend accepted response
func (o *ReplaceAllHTTPResponseRuleBackendAccepted) WithReloadID(reloadID string) *ReplaceAllHTTPResponseRuleBackendAccepted {
	o.ReloadID = reloadID
	return o
}

// SetReloadID sets the reloadId to the replace all Http response rule backend accepted response
func (o *ReplaceAllHTTPResponseRuleBackendAccepted) SetReloadID(reloadID string) {
	o.ReloadID = reloadID
}

// WithPayload adds the payload to the replace all Http response rule backend accepted response
func (o *ReplaceAllHTTPResponseRuleBackendAccepted) WithPayload(payload models.HTTPResponseRules) *ReplaceAllHTTPResponseRuleBackendAccepted {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace all Http response rule backend accepted response
func (o *ReplaceAllHTTPResponseRuleBackendAccepted) SetPayload(payload models.HTTPResponseRules) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceAllHTTPResponseRuleBackendAccepted) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Reload-ID

	reloadID := o.ReloadID
	if reloadID != "" {
		rw.Header().Set("Reload-ID", reloadID)
	}

	rw.WriteHeader(202)
	payload := o.Payload
	if payload == nil {
		// return empty array
		payload = models.HTTPResponseRules{}
	}

	if err := producer.Produce(rw, payload); err != nil {
		panic(err) // let the recovery middleware deal with this
	}
}

// ReplaceAllHTTPResponseRuleBackendBadRequestCode is the HTTP code returned for type ReplaceAllHTTPResponseRuleBackendBadRequest
const ReplaceAllHTTPResponseRuleBackendBadRequestCode int = 400

/*
ReplaceAllHTTPResponseRuleBackendBadRequest Bad request

swagger:response replaceAllHttpResponseRuleBackendBadRequest
*/
type ReplaceAllHTTPResponseRuleBackendBadRequest struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceAllHTTPResponseRuleBackendBadRequest creates ReplaceAllHTTPResponseRuleBackendBadRequest with default headers values
func NewReplaceAllHTTPResponseRuleBackendBadRequest() *ReplaceAllHTTPResponseRuleBackendBadRequest {

	return &ReplaceAllHTTPResponseRuleBackendBadRequest{}
}

// WithConfigurationVersion adds the configurationVersion to the replace all Http response rule backend bad request response
func (o *ReplaceAllHTTPResponseRuleBackendBadRequest) WithConfigurationVersion(configurationVersion string) *ReplaceAllHTTPResponseRuleBackendBadRequest {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace all Http response rule backend bad request response
func (o *ReplaceAllHTTPResponseRuleBackendBadRequest) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace all Http response rule backend bad request response
func (o *ReplaceAllHTTPResponseRuleBackendBadRequest) WithPayload(payload *models.Error) *ReplaceAllHTTPResponseRuleBackendBadRequest {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace all Http response rule backend bad request response
func (o *ReplaceAllHTTPResponseRuleBackendBadRequest) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceAllHTTPResponseRuleBackendBadRequest) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(400)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
ReplaceAllHTTPResponseRuleBackendDefault General Error

swagger:response replaceAllHttpResponseRuleBackendDefault
*/
type ReplaceAllHTTPResponseRuleBackendDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceAllHTTPResponseRuleBackendDefault creates ReplaceAllHTTPResponseRuleBackendDefault with default headers values
func NewReplaceAllHTTPResponseRuleBackendDefault(code int) *ReplaceAllHTTPResponseRuleBackendDefault {
	if code <= 0 {
		code = 500
	}

	return &ReplaceAllHTTPResponseRuleBackendDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the replace all HTTP response rule backend default response
func (o *ReplaceAllHTTPResponseRuleBackendDefault) WithStatusCode(code int) *ReplaceAllHTTPResponseRuleBackendDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the replace all HTTP response rule backend default response
func (o *ReplaceAllHTTPResponseRuleBackendDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the replace all HTTP response rule backend default response
func (o *ReplaceAllHTTPResponseRuleBackendDefault) WithConfigurationVersion(configurationVersion string) *ReplaceAllHTTPResponseRuleBackendDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace all HTTP response rule backend default response
func (o *ReplaceAllHTTPResponseRuleBackendDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace all HTTP response rule backend default response
func (o *ReplaceAllHTTPResponseRuleBackendDefault) WithPayload(payload *models.Error) *ReplaceAllHTTPResponseRuleBackendDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace all HTTP response rule backend default response
func (o *ReplaceAllHTTPResponseRuleBackendDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceAllHTTPResponseRuleBackendDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
