// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package log_target

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// ReplaceAllLogTargetBackendOKCode is the HTTP code returned for type ReplaceAllLogTargetBackendOK
const ReplaceAllLogTargetBackendOKCode int = 200

/*
ReplaceAllLogTargetBackendOK All Log Target lines replaced

swagger:response replaceAllLogTargetBackendOK
*/
type ReplaceAllLogTargetBackendOK struct {

	/*
	  In: Body
	*/
	Payload models.LogTargets `json:"body,omitempty"`
}

// NewReplaceAllLogTargetBackendOK creates ReplaceAllLogTargetBackendOK with default headers values
func NewReplaceAllLogTargetBackendOK() *ReplaceAllLogTargetBackendOK {

	return &ReplaceAllLogTargetBackendOK{}
}

// WithPayload adds the payload to the replace all log target backend o k response
func (o *ReplaceAllLogTargetBackendOK) WithPayload(payload models.LogTargets) *ReplaceAllLogTargetBackendOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace all log target backend o k response
func (o *ReplaceAllLogTargetBackendOK) SetPayload(payload models.LogTargets) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceAllLogTargetBackendOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(200)
	payload := o.Payload
	if payload == nil {
		// return empty array
		payload = models.LogTargets{}
	}

	if err := producer.Produce(rw, payload); err != nil {
		panic(err) // let the recovery middleware deal with this
	}
}

// ReplaceAllLogTargetBackendAcceptedCode is the HTTP code returned for type ReplaceAllLogTargetBackendAccepted
const ReplaceAllLogTargetBackendAcceptedCode int = 202

/*
ReplaceAllLogTargetBackendAccepted Configuration change accepted and reload requested

swagger:response replaceAllLogTargetBackendAccepted
*/
type ReplaceAllLogTargetBackendAccepted struct {
	/*ID of the requested reload

	 */
	ReloadID string `json:"Reload-ID"`

	/*
	  In: Body
	*/
	Payload models.LogTargets `json:"body,omitempty"`
}

// NewReplaceAllLogTargetBackendAccepted creates ReplaceAllLogTargetBackendAccepted with default headers values
func NewReplaceAllLogTargetBackendAccepted() *ReplaceAllLogTargetBackendAccepted {

	return &ReplaceAllLogTargetBackendAccepted{}
}

// WithReloadID adds the reloadId to the replace all log target backend accepted response
func (o *ReplaceAllLogTargetBackendAccepted) WithReloadID(reloadID string) *ReplaceAllLogTargetBackendAccepted {
	o.ReloadID = reloadID
	return o
}

// SetReloadID sets the reloadId to the replace all log target backend accepted response
func (o *ReplaceAllLogTargetBackendAccepted) SetReloadID(reloadID string) {
	o.ReloadID = reloadID
}

// WithPayload adds the payload to the replace all log target backend accepted response
func (o *ReplaceAllLogTargetBackendAccepted) WithPayload(payload models.LogTargets) *ReplaceAllLogTargetBackendAccepted {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace all log target backend accepted response
func (o *ReplaceAllLogTargetBackendAccepted) SetPayload(payload models.LogTargets) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceAllLogTargetBackendAccepted) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Reload-ID

	reloadID := o.ReloadID
	if reloadID != "" {
		rw.Header().Set("Reload-ID", reloadID)
	}

	rw.WriteHeader(202)
	payload := o.Payload
	if payload == nil {
		// return empty array
		payload = models.LogTargets{}
	}

	if err := producer.Produce(rw, payload); err != nil {
		panic(err) // let the recovery middleware deal with this
	}
}

// ReplaceAllLogTargetBackendBadRequestCode is the HTTP code returned for type ReplaceAllLogTargetBackendBadRequest
const ReplaceAllLogTargetBackendBadRequestCode int = 400

/*
ReplaceAllLogTargetBackendBadRequest Bad request

swagger:response replaceAllLogTargetBackendBadRequest
*/
type ReplaceAllLogTargetBackendBadRequest struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceAllLogTargetBackendBadRequest creates ReplaceAllLogTargetBackendBadRequest with default headers values
func NewReplaceAllLogTargetBackendBadRequest() *ReplaceAllLogTargetBackendBadRequest {

	return &ReplaceAllLogTargetBackendBadRequest{}
}

// WithConfigurationVersion adds the configurationVersion to the replace all log target backend bad request response
func (o *ReplaceAllLogTargetBackendBadRequest) WithConfigurationVersion(configurationVersion string) *ReplaceAllLogTargetBackendBadRequest {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace all log target backend bad request response
func (o *ReplaceAllLogTargetBackendBadRequest) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace all log target backend bad request response
func (o *ReplaceAllLogTargetBackendBadRequest) WithPayload(payload *models.Error) *ReplaceAllLogTargetBackendBadRequest {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace all log target backend bad request response
func (o *ReplaceAllLogTargetBackendBadRequest) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceAllLogTargetBackendBadRequest) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(400)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
ReplaceAllLogTargetBackendDefault General Error

swagger:response replaceAllLogTargetBackendDefault
*/
type ReplaceAllLogTargetBackendDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceAllLogTargetBackendDefault creates ReplaceAllLogTargetBackendDefault with default headers values
func NewReplaceAllLogTargetBackendDefault(code int) *ReplaceAllLogTargetBackendDefault {
	if code <= 0 {
		code = 500
	}

	return &ReplaceAllLogTargetBackendDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the replace all log target backend default response
func (o *ReplaceAllLogTargetBackendDefault) WithStatusCode(code int) *ReplaceAllLogTargetBackendDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the replace all log target backend default response
func (o *ReplaceAllLogTargetBackendDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the replace all log target backend default response
func (o *ReplaceAllLogTargetBackendDefault) WithConfigurationVersion(configurationVersion string) *ReplaceAllLogTargetBackendDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace all log target backend default response
func (o *ReplaceAllLogTargetBackendDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace all log target backend default response
func (o *ReplaceAllLogTargetBackendDefault) WithPayload(payload *models.Error) *ReplaceAllLogTargetBackendDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace all log target backend default response
func (o *ReplaceAllLogTargetBackendDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceAllLogTargetBackendDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
