// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package mailers

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// CreateMailersSectionCreatedCode is the HTTP code returned for type CreateMailersSectionCreated
const CreateMailersSectionCreatedCode int = 201

/*
CreateMailersSectionCreated Mailers created

swagger:response createMailersSectionCreated
*/
type CreateMailersSectionCreated struct {

	/*
	  In: Body
	*/
	Payload *models.MailersSection `json:"body,omitempty"`
}

// NewCreateMailersSectionCreated creates CreateMailersSectionCreated with default headers values
func NewCreateMailersSectionCreated() *CreateMailersSectionCreated {

	return &CreateMailersSectionCreated{}
}

// WithPayload adds the payload to the create mailers section created response
func (o *CreateMailersSectionCreated) WithPayload(payload *models.MailersSection) *CreateMailersSectionCreated {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create mailers section created response
func (o *CreateMailersSectionCreated) SetPayload(payload *models.MailersSection) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateMailersSectionCreated) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(201)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// CreateMailersSectionAcceptedCode is the HTTP code returned for type CreateMailersSectionAccepted
const CreateMailersSectionAcceptedCode int = 202

/*
CreateMailersSectionAccepted Configuration change accepted and reload requested

swagger:response createMailersSectionAccepted
*/
type CreateMailersSectionAccepted struct {
	/*ID of the requested reload

	 */
	ReloadID string `json:"Reload-ID"`

	/*
	  In: Body
	*/
	Payload *models.MailersSection `json:"body,omitempty"`
}

// NewCreateMailersSectionAccepted creates CreateMailersSectionAccepted with default headers values
func NewCreateMailersSectionAccepted() *CreateMailersSectionAccepted {

	return &CreateMailersSectionAccepted{}
}

// WithReloadID adds the reloadId to the create mailers section accepted response
func (o *CreateMailersSectionAccepted) WithReloadID(reloadID string) *CreateMailersSectionAccepted {
	o.ReloadID = reloadID
	return o
}

// SetReloadID sets the reloadId to the create mailers section accepted response
func (o *CreateMailersSectionAccepted) SetReloadID(reloadID string) {
	o.ReloadID = reloadID
}

// WithPayload adds the payload to the create mailers section accepted response
func (o *CreateMailersSectionAccepted) WithPayload(payload *models.MailersSection) *CreateMailersSectionAccepted {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create mailers section accepted response
func (o *CreateMailersSectionAccepted) SetPayload(payload *models.MailersSection) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateMailersSectionAccepted) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Reload-ID

	reloadID := o.ReloadID
	if reloadID != "" {
		rw.Header().Set("Reload-ID", reloadID)
	}

	rw.WriteHeader(202)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// CreateMailersSectionBadRequestCode is the HTTP code returned for type CreateMailersSectionBadRequest
const CreateMailersSectionBadRequestCode int = 400

/*
CreateMailersSectionBadRequest Bad request

swagger:response createMailersSectionBadRequest
*/
type CreateMailersSectionBadRequest struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewCreateMailersSectionBadRequest creates CreateMailersSectionBadRequest with default headers values
func NewCreateMailersSectionBadRequest() *CreateMailersSectionBadRequest {

	return &CreateMailersSectionBadRequest{}
}

// WithConfigurationVersion adds the configurationVersion to the create mailers section bad request response
func (o *CreateMailersSectionBadRequest) WithConfigurationVersion(configurationVersion string) *CreateMailersSectionBadRequest {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the create mailers section bad request response
func (o *CreateMailersSectionBadRequest) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the create mailers section bad request response
func (o *CreateMailersSectionBadRequest) WithPayload(payload *models.Error) *CreateMailersSectionBadRequest {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create mailers section bad request response
func (o *CreateMailersSectionBadRequest) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateMailersSectionBadRequest) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(400)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// CreateMailersSectionConflictCode is the HTTP code returned for type CreateMailersSectionConflict
const CreateMailersSectionConflictCode int = 409

/*
CreateMailersSectionConflict The specified resource already exists

swagger:response createMailersSectionConflict
*/
type CreateMailersSectionConflict struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewCreateMailersSectionConflict creates CreateMailersSectionConflict with default headers values
func NewCreateMailersSectionConflict() *CreateMailersSectionConflict {

	return &CreateMailersSectionConflict{}
}

// WithConfigurationVersion adds the configurationVersion to the create mailers section conflict response
func (o *CreateMailersSectionConflict) WithConfigurationVersion(configurationVersion string) *CreateMailersSectionConflict {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the create mailers section conflict response
func (o *CreateMailersSectionConflict) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the create mailers section conflict response
func (o *CreateMailersSectionConflict) WithPayload(payload *models.Error) *CreateMailersSectionConflict {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create mailers section conflict response
func (o *CreateMailersSectionConflict) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateMailersSectionConflict) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(409)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
CreateMailersSectionDefault General Error

swagger:response createMailersSectionDefault
*/
type CreateMailersSectionDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewCreateMailersSectionDefault creates CreateMailersSectionDefault with default headers values
func NewCreateMailersSectionDefault(code int) *CreateMailersSectionDefault {
	if code <= 0 {
		code = 500
	}

	return &CreateMailersSectionDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the create mailers section default response
func (o *CreateMailersSectionDefault) WithStatusCode(code int) *CreateMailersSectionDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the create mailers section default response
func (o *CreateMailersSectionDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the create mailers section default response
func (o *CreateMailersSectionDefault) WithConfigurationVersion(configurationVersion string) *CreateMailersSectionDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the create mailers section default response
func (o *CreateMailersSectionDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the create mailers section default response
func (o *CreateMailersSectionDefault) WithPayload(payload *models.Error) *CreateMailersSectionDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create mailers section default response
func (o *CreateMailersSectionDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateMailersSectionDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
