// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package nameserver

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// ReplaceNameserverOKCode is the HTTP code returned for type ReplaceNameserverOK
const ReplaceNameserverOKCode int = 200

/*
ReplaceNameserverOK Nameserver replaced

swagger:response replaceNameserverOK
*/
type ReplaceNameserverOK struct {

	/*
	  In: Body
	*/
	Payload *models.Nameserver `json:"body,omitempty"`
}

// NewReplaceNameserverOK creates ReplaceNameserverOK with default headers values
func NewReplaceNameserverOK() *ReplaceNameserverOK {

	return &ReplaceNameserverOK{}
}

// WithPayload adds the payload to the replace nameserver o k response
func (o *ReplaceNameserverOK) WithPayload(payload *models.Nameserver) *ReplaceNameserverOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace nameserver o k response
func (o *ReplaceNameserverOK) SetPayload(payload *models.Nameserver) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceNameserverOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(200)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// ReplaceNameserverAcceptedCode is the HTTP code returned for type ReplaceNameserverAccepted
const ReplaceNameserverAcceptedCode int = 202

/*
ReplaceNameserverAccepted Configuration change accepted and reload requested

swagger:response replaceNameserverAccepted
*/
type ReplaceNameserverAccepted struct {
	/*ID of the requested reload

	 */
	ReloadID string `json:"Reload-ID"`

	/*
	  In: Body
	*/
	Payload *models.Nameserver `json:"body,omitempty"`
}

// NewReplaceNameserverAccepted creates ReplaceNameserverAccepted with default headers values
func NewReplaceNameserverAccepted() *ReplaceNameserverAccepted {

	return &ReplaceNameserverAccepted{}
}

// WithReloadID adds the reloadId to the replace nameserver accepted response
func (o *ReplaceNameserverAccepted) WithReloadID(reloadID string) *ReplaceNameserverAccepted {
	o.ReloadID = reloadID
	return o
}

// SetReloadID sets the reloadId to the replace nameserver accepted response
func (o *ReplaceNameserverAccepted) SetReloadID(reloadID string) {
	o.ReloadID = reloadID
}

// WithPayload adds the payload to the replace nameserver accepted response
func (o *ReplaceNameserverAccepted) WithPayload(payload *models.Nameserver) *ReplaceNameserverAccepted {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace nameserver accepted response
func (o *ReplaceNameserverAccepted) SetPayload(payload *models.Nameserver) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceNameserverAccepted) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Reload-ID

	reloadID := o.ReloadID
	if reloadID != "" {
		rw.Header().Set("Reload-ID", reloadID)
	}

	rw.WriteHeader(202)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// ReplaceNameserverBadRequestCode is the HTTP code returned for type ReplaceNameserverBadRequest
const ReplaceNameserverBadRequestCode int = 400

/*
ReplaceNameserverBadRequest Bad request

swagger:response replaceNameserverBadRequest
*/
type ReplaceNameserverBadRequest struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceNameserverBadRequest creates ReplaceNameserverBadRequest with default headers values
func NewReplaceNameserverBadRequest() *ReplaceNameserverBadRequest {

	return &ReplaceNameserverBadRequest{}
}

// WithConfigurationVersion adds the configurationVersion to the replace nameserver bad request response
func (o *ReplaceNameserverBadRequest) WithConfigurationVersion(configurationVersion string) *ReplaceNameserverBadRequest {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace nameserver bad request response
func (o *ReplaceNameserverBadRequest) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace nameserver bad request response
func (o *ReplaceNameserverBadRequest) WithPayload(payload *models.Error) *ReplaceNameserverBadRequest {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace nameserver bad request response
func (o *ReplaceNameserverBadRequest) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceNameserverBadRequest) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(400)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// ReplaceNameserverNotFoundCode is the HTTP code returned for type ReplaceNameserverNotFound
const ReplaceNameserverNotFoundCode int = 404

/*
ReplaceNameserverNotFound The specified resource was not found

swagger:response replaceNameserverNotFound
*/
type ReplaceNameserverNotFound struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceNameserverNotFound creates ReplaceNameserverNotFound with default headers values
func NewReplaceNameserverNotFound() *ReplaceNameserverNotFound {

	return &ReplaceNameserverNotFound{}
}

// WithConfigurationVersion adds the configurationVersion to the replace nameserver not found response
func (o *ReplaceNameserverNotFound) WithConfigurationVersion(configurationVersion string) *ReplaceNameserverNotFound {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace nameserver not found response
func (o *ReplaceNameserverNotFound) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace nameserver not found response
func (o *ReplaceNameserverNotFound) WithPayload(payload *models.Error) *ReplaceNameserverNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace nameserver not found response
func (o *ReplaceNameserverNotFound) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceNameserverNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
ReplaceNameserverDefault General Error

swagger:response replaceNameserverDefault
*/
type ReplaceNameserverDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceNameserverDefault creates ReplaceNameserverDefault with default headers values
func NewReplaceNameserverDefault(code int) *ReplaceNameserverDefault {
	if code <= 0 {
		code = 500
	}

	return &ReplaceNameserverDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the replace nameserver default response
func (o *ReplaceNameserverDefault) WithStatusCode(code int) *ReplaceNameserverDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the replace nameserver default response
func (o *ReplaceNameserverDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the replace nameserver default response
func (o *ReplaceNameserverDefault) WithConfigurationVersion(configurationVersion string) *ReplaceNameserverDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace nameserver default response
func (o *ReplaceNameserverDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace nameserver default response
func (o *ReplaceNameserverDefault) WithPayload(payload *models.Error) *ReplaceNameserverDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace nameserver default response
func (o *ReplaceNameserverDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceNameserverDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
