// Code generated by sdkgen. DO NOT EDIT.

// nolint
package billing

import (
	"context"

	"google.golang.org/grpc"

	billing "github.com/yandex-cloud/go-genproto/yandex/cloud/billing/v1"
)

//revive:disable

// SkuServiceClient is a billing.SkuServiceClient with
// lazy GRPC connection initialization.
type SkuServiceClient struct {
	getConn func(ctx context.Context) (*grpc.ClientConn, error)
}

// Get implements billing.SkuServiceClient
func (c *SkuServiceClient) Get(ctx context.Context, in *billing.GetSkuRequest, opts ...grpc.CallOption) (*billing.Sku, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return billing.NewSkuServiceClient(conn).Get(ctx, in, opts...)
}

// List implements billing.SkuServiceClient
func (c *SkuServiceClient) List(ctx context.Context, in *billing.ListSkusRequest, opts ...grpc.CallOption) (*billing.ListSkusResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return billing.NewSkuServiceClient(conn).List(ctx, in, opts...)
}

type SkuIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err           error
	started       bool
	requestedSize int64
	pageSize      int64

	client  *SkuServiceClient
	request *billing.ListSkusRequest

	items []*billing.Sku
}

func (c *SkuServiceClient) SkuIterator(ctx context.Context, req *billing.ListSkusRequest, opts ...grpc.CallOption) *SkuIterator {
	var pageSize int64
	const defaultPageSize = 1000
	pageSize = req.PageSize
	if pageSize == 0 {
		pageSize = defaultPageSize
	}
	return &SkuIterator{
		ctx:      ctx,
		opts:     opts,
		client:   c,
		request:  req,
		pageSize: pageSize,
	}
}

func (it *SkuIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started && it.request.PageToken == "" {
		return false
	}
	it.started = true

	if it.requestedSize == 0 || it.requestedSize > it.pageSize {
		it.request.PageSize = it.pageSize
	} else {
		it.request.PageSize = it.requestedSize
	}

	response, err := it.client.List(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.Skus
	it.request.PageToken = response.NextPageToken
	return len(it.items) > 0
}

func (it *SkuIterator) Take(size int64) ([]*billing.Sku, error) {
	if it.err != nil {
		return nil, it.err
	}

	if size == 0 {
		size = 1 << 32 // something insanely large
	}
	it.requestedSize = size
	defer func() {
		// reset iterator for future calls.
		it.requestedSize = 0
	}()

	var result []*billing.Sku

	for it.requestedSize > 0 && it.Next() {
		it.requestedSize--
		result = append(result, it.Value())
	}

	if it.err != nil {
		return nil, it.err
	}

	return result, nil
}

func (it *SkuIterator) TakeAll() ([]*billing.Sku, error) {
	return it.Take(0)
}

func (it *SkuIterator) Value() *billing.Sku {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *SkuIterator) Error() error {
	return it.err
}
