/*
 * cmon - connection monitor
 *
 * TODO
 *
 *
 * Copyright (C) 2002 Thomas Graf <tgr@reeler.org>
 *
 * This file belongs to the nstats package, see COPYING for more information.
 *
 */

#include <stdio.h>
#include <curses.h>
#include <stdarg.h>
#include <stdlib.h>
#include <time.h>
#include <signal.h>
#include <unistd.h>

#include "../config.h"

#include "curs_util.h"
#include "aconn.h"
#include "pcap.h"

static int quit_done = 0;

time_t now = 0;

int do_resolve = 0;
char dname[255];

RETSIGTYPE
finish(int sig)
{
    exit(0);
}

void
doexit(void)
{
    if (!quit_done) {
        endwin();
        pcap_stop_all();
    }
    quit_done=1;
}

void
quit(const char *fmt, ...)
{
    va_list args;

    doexit();

    va_start(args, fmt);
    vfprintf(stderr, fmt, args);
    va_end(args);

    exit(-1);
}

void
draw(void)
{
    time_t t;
    char dstr[30];

    row = 0;
    
    aconn_sort();
    aconn_print_connections();

    row = LINES-1;
    move(row,0);
    attrset(A_REVERSE);

    print_full_line(" nmon 0.4.0  [ResolveDNS: %s]",
        (do_resolve) ? "Yes" : "No");

    move(row,COLS-16);
    t = time(0);
    strftime(dstr, sizeof(dstr), "%b %d %H:%M:%S", localtime(&t));
    printw("%s", dstr);
    
    attroff(A_REVERSE);

    refresh();
}

int
main(int argc, char *argv[])
{
    time_t bt = time(0);

    atexit(&doexit);

    if (signal(SIGINT, finish) < 0) {   /* clean exit upon interrupt */
        perror("signal");
        finish(-1);
    }

    pcap_listen_on_all(0);

    curs_init();

    for (;;) {

        now = time(0);

        for (;;) {

            int ch = getch();

            if (ch == 'q')
                finish(0);
            else if (ch == 'n') {
                if (do_resolve)
                    do_resolve = 0;
                else
                    do_resolve = 1;
            } else if (ch == 12) {
                clear();
                draw();
            }

            if ( aconn_handle_input(ch) )
                draw();

            if (ch == -1)
                break;
        }

        pcap_handle();

        /*
         * calculate and display stuff at least once a second
         */
        if ( (now - bt) >= 1) {

            aconn_mark();
            aconn_read_tcp("/proc/net/tcp");
            aconn_delete_marked();
            aconn_calc_rate();

            draw();

            bt = now;
        }

        usleep(20000);
    }

    return 0; /* will never be reached */
}
