/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.math.statistics.distribution;

import Jama.Matrix;
import java.util.Random;
import org.openimaj.math.statistics.MeanAndCovariance;
import org.openimaj.math.statistics.distribution.AbstractMultivariateGaussian;
import org.openimaj.math.statistics.distribution.MultivariateGaussian;

public class CachingMultivariateGaussian
extends AbstractMultivariateGaussian
implements MultivariateGaussian {
    protected Matrix covar;
    protected int N;
    private Matrix inv_covar;
    private double pdf_const_factor;
    private Matrix chol;

    protected CachingMultivariateGaussian() {
    }

    public CachingMultivariateGaussian(Matrix mean, Matrix covar) {
        this.N = mean.getColumnDimension();
        this.mean = mean;
        this.covar = covar;
        this.cacheValues();
    }

    public CachingMultivariateGaussian(int ndims) {
        this.N = ndims;
        this.mean = new Matrix(1, this.N);
        this.covar = Matrix.identity((int)this.N, (int)this.N);
        this.cacheValues();
    }

    protected void cacheValues() {
        this.inv_covar = this.covar.inverse();
        this.pdf_const_factor = 1.0 / Math.sqrt(Math.pow(Math.PI * 2, this.N) * this.covar.det());
        this.chol = this.covar.chol().getL();
    }

    public static CachingMultivariateGaussian estimate(float[][] samples) {
        int ndims = samples[0].length;
        CachingMultivariateGaussian gauss = new CachingMultivariateGaussian();
        gauss.N = ndims;
        MeanAndCovariance res = new MeanAndCovariance(samples);
        gauss.mean = res.mean;
        gauss.covar = res.covar;
        gauss.cacheValues();
        return gauss;
    }

    public static MultivariateGaussian estimate(Matrix samples) {
        return CachingMultivariateGaussian.estimate(samples.getArray());
    }

    public static MultivariateGaussian estimate(double[][] samples) {
        int ndims = samples[0].length;
        CachingMultivariateGaussian gauss = new CachingMultivariateGaussian();
        gauss.N = ndims;
        MeanAndCovariance res = new MeanAndCovariance(samples);
        gauss.mean = res.mean;
        gauss.covar = res.covar;
        gauss.cacheValues();
        return gauss;
    }

    @Override
    public double estimateProbability(double[] sample) {
        Matrix xm = new Matrix(1, this.N);
        for (int i = 0; i < this.N; ++i) {
            xm.set(0, i, sample[i] - this.mean.get(0, i));
        }
        Matrix xmt = xm.transpose();
        double v = xm.times(this.inv_covar.times(xmt)).get(0, 0);
        return this.pdf_const_factor * Math.exp(-0.5 * v);
    }

    public double estimateProbability(Float[] sample) {
        Matrix xm = new Matrix(1, this.N);
        for (int i = 0; i < this.N; ++i) {
            xm.set(0, i, (double)sample[i].floatValue() - this.mean.get(0, i));
        }
        Matrix xmt = xm.transpose();
        double v = xm.times(this.inv_covar.times(xmt)).get(0, 0);
        return this.pdf_const_factor * Math.exp(-0.5 * v);
    }

    @Override
    public double estimateLogProbability(double[] sample) {
        Matrix xm = new Matrix(1, this.N);
        for (int i = 0; i < this.N; ++i) {
            xm.set(0, i, sample[i] - this.mean.get(0, i));
        }
        Matrix xmt = xm.transpose();
        double v = xm.times(this.inv_covar.times(xmt)).get(0, 0);
        return Math.log(this.pdf_const_factor) + -0.5 * v;
    }

    @Override
    public Matrix getCovariance() {
        return this.covar;
    }

    @Override
    public int numDims() {
        return this.N;
    }

    @Override
    public double[] sample(Random rng) {
        Matrix vec = new Matrix(this.N, 1);
        for (int i = 0; i < this.N; ++i) {
            vec.set(i, 0, rng.nextGaussian());
        }
        Matrix result = this.mean.plus(this.chol.times(vec).transpose());
        return result.getArray()[0];
    }

    @Override
    public double[][] sample(int count, Random rng) {
        double[][] samples = new double[count][];
        for (int i = 0; i < count; ++i) {
            samples[i] = this.sample(rng);
        }
        return samples;
    }

    @Override
    public double getCovariance(int row, int column) {
        return this.covar.get(row, column);
    }
}

