/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.nvm;

import org.nlogo.core.FrontEndProcedure;
import org.nlogo.nvm.Binding;
import org.nlogo.nvm.Command;
import org.nlogo.nvm.Procedure;
import scala.Option;

public strictfp final class Activation
implements org.nlogo.api.Activation {
    private static final Object[] NO_ARGS = new Object[0];
    public final Procedure procedure;
    public final Activation parent;
    final int returnAddress;
    public final Object[] args;
    final Command[] code;
    public Binding binding;

    public Activation(Procedure procedure, Activation parent, Object[] args, int returnAddress, Binding binding) {
        this.procedure = procedure;
        this.parent = parent;
        this.args = args;
        this.returnAddress = returnAddress;
        this.code = procedure._code;
        this.binding = binding;
    }

    public Activation(Procedure procedure, Activation parent, Object[] args, int returnAddress) {
        this.procedure = procedure;
        this.code = procedure._code;
        this.parent = parent;
        this.args = args;
        this.returnAddress = returnAddress;
        this.binding = new Binding();
    }

    public Activation(Procedure procedure, Activation parent, int returnAddress) {
        this.procedure = procedure;
        this.code = procedure._code;
        this.parent = parent;
        this.returnAddress = returnAddress;
        this.binding = new Binding();
        this.args = procedure.size() == 0 ? NO_ARGS : new Object[procedure.size()];
    }

    public Option<Activation> parent() {
        return Option.apply(this.parent);
    }

    @Override
    public FrontEndProcedure procedure() {
        return this.procedure;
    }

    Activation parentOrNull() {
        return this.parent;
    }

    public static Activation forRunOrRunresult(Procedure procedure, Activation parent, int returnAddress) {
        Object[] args = new Object[Math.max(procedure.size(), parent.args.length)];
        System.arraycopy(parent.args, 0, args, 0, parent.procedure.args().size());
        return new Activation(procedure, parent, args, returnAddress, parent.binding);
    }

    public String toString() {
        String result = super.toString();
        result = result + ":" + this.procedure.name() + "(" + this.args.length + " args";
        result = result + ", return address = " + this.returnAddress + ")\n";
        for (int i = 0; i < this.args.length; ++i) {
            result = result + "  arg " + i + " = " + this.args[i] + "\n";
        }
        return result;
    }

    public Activation nonLambdaActivation() {
        if (this.procedure.isLambda() && this.parent != null) {
            return this.parent.nonLambdaActivation();
        }
        return this;
    }
}

