/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.parse;

import java.io.Serializable;
import org.nlogo.core.Application;
import org.nlogo.core.Command;
import org.nlogo.core.CommandBlock;
import org.nlogo.core.Expression;
import org.nlogo.core.Fail$;
import org.nlogo.core.FrontEndProcedure;
import org.nlogo.core.I18N$;
import org.nlogo.core.LogoList;
import org.nlogo.core.ProcedureDefinition;
import org.nlogo.core.Reporter;
import org.nlogo.core.ReporterApp;
import org.nlogo.core.ReporterBlock;
import org.nlogo.core.SourceLocatable;
import org.nlogo.core.SourceLocation;
import org.nlogo.core.Statement;
import org.nlogo.core.Statements;
import org.nlogo.core.Syntax;
import org.nlogo.core.Syntax$;
import org.nlogo.core.Token;
import org.nlogo.core.TokenType;
import org.nlogo.core.TokenType$CloseBracket$;
import org.nlogo.core.TokenType$CloseParen$;
import org.nlogo.core.TokenType$Command$;
import org.nlogo.core.TokenType$Eof$;
import org.nlogo.core.TokenType$Literal$;
import org.nlogo.core.TokenType$OpenBracket$;
import org.nlogo.core.TokenType$OpenParen$;
import org.nlogo.core.TokenType$Reporter$;
import org.nlogo.core.TypeNames$;
import org.nlogo.core.prim.Lambda;
import org.nlogo.core.prim._commandlambda;
import org.nlogo.core.prim._const;
import org.nlogo.core.prim._constcodeblock;
import org.nlogo.core.prim._lambdavariable;
import org.nlogo.core.prim._minus;
import org.nlogo.core.prim._reporterlambda;
import org.nlogo.core.prim._symbol;
import org.nlogo.core.prim._unaryminus;
import org.nlogo.core.prim._unknownidentifier;
import org.nlogo.parse.AmbiguousDelayedBlock;
import org.nlogo.parse.ArrowLambdaBlock;
import org.nlogo.parse.DelayedBlock;
import org.nlogo.parse.DelayedBlock$;
import org.nlogo.parse.ExpressionParser;
import org.nlogo.parse.LetScope$;
import org.nlogo.parse.LetVariableScope$;
import org.nlogo.parse.LiteralParser;
import org.nlogo.parse.NullImportHandler$;
import org.nlogo.parse.SymbolTable;
import org.nlogo.parse.SymbolType$LambdaVariable$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.UninitializedFieldError;
import scala.collection.BufferedIterator;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.UnrolledBuffer;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0$mcI$sp;
import scala.runtime.java8.JFunction1$mcZI$sp;
import scala.sys.package$;

public final class ExpressionParser$ {
    public static ExpressionParser$ MODULE$;
    private final int MinPrecedence;
    private final String ExpectedCommand;
    private final String ExpectedCloseBracket;
    private final String ExpectedCloseParen;
    private final String ExpectedReporter;
    private final String InvalidVariadicContext;
    private final String MissingCloseBracket;
    private final String MissingCloseParen;
    private final String MissingInputOnLeft;
    private volatile int bitmap$init$0;

    static {
        new ExpressionParser$();
    }

    private int MinPrecedence() {
        if ((this.bitmap$init$0 & 1) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /media/sf_NetLogo/parser-core/src/main/parse/ExpressionParser.scala: 23");
        }
        return this.MinPrecedence;
    }

    public ProcedureDefinition apply(FrontEndProcedure procedureDeclaration, Iterator<Token> tokens, SymbolTable scope) {
        BufferedIterator<Token> buffered = tokens.buffered();
        Seq<Statement> statementList = this.parseStatements(buffered, scope, TokenType$Eof$.MODULE$, (Function2<BufferedIterator<Token>, SymbolTable, Tuple2<Statement, SymbolTable>>)(Function2<BufferedIterator, SymbolTable, Tuple2> & Serializable & scala.Serializable)(x$1, x$2) -> MODULE$.parseStatement((BufferedIterator<Token>)x$1, false, (SymbolTable)x$2));
        Statements stmts = new Statements(((SourceLocatable)buffered.head()).filename(), statementList, false);
        int end = ((SourceLocatable)buffered.head()).end() < Integer.MAX_VALUE ? ((SourceLocatable)buffered.head()).start() : stmts.end();
        return new ProcedureDefinition(procedureDeclaration, stmts, end);
    }

    /*
     * WARNING - void declaration
     */
    private Seq<Statement> parseStatements(BufferedIterator<Token> tokens, SymbolTable scope, TokenType terminator, Function2<BufferedIterator<Token>, SymbolTable, Tuple2<Statement, SymbolTable>> f) {
        Buffer b = (Buffer)Buffer$.MODULE$.apply(Nil$.MODULE$);
        SymbolTable activeScope = scope;
        while (true) {
            void var9_9;
            void var8_8;
            TokenType tokenType2 = tokens.head().tpe();
            if (!(tokenType2 == null ? terminator != null : !tokenType2.equals(terminator))) break;
            Tuple2<Statement, SymbolTable> tuple2 = f.apply(tokens, activeScope);
            if (tuple2 == null) {
                throw new MatchError((Object)null);
            }
            Statement stmt = tuple2._1();
            SymbolTable s = tuple2._2();
            void stmt2 = var8_8;
            activeScope = var9_9;
            b.$plus$eq(stmt2);
        }
        return b.toSeq();
    }

    /*
     * WARNING - void declaration
     */
    private Tuple2<Statement, SymbolTable> parseStatement(BufferedIterator<Token> tokens, boolean variadic, SymbolTable scope) {
        Tuple2<Statement, void> tuple2;
        block10: {
            TokenType tokenType2;
            Token token;
            block7: {
                void var10_8;
                void var12_10;
                void var11_9;
                Tuple2 tuple22;
                block9: {
                    Tuple2 tuple23;
                    block8: {
                        token = tokens.head();
                        tokenType2 = token.tpe();
                        if (!TokenType$OpenParen$.MODULE$.equals(tokenType2)) break block7;
                        tuple23 = this.parseParenthesized(tokens, (Function1<BufferedIterator, Tuple2> & Serializable & scala.Serializable)x$4 -> MODULE$.parseStatement((BufferedIterator<Token>)x$4, true, scope), token.filename());
                        if (tuple23 == null) break block8;
                        tuple22 = (Tuple2)tuple23._1();
                        SourceLocation loc = tuple23._2();
                        if (tuple22 != null) break block9;
                    }
                    throw new MatchError(tuple23);
                }
                Statement stmt = (Statement)tuple22._1();
                SymbolTable newScope = (SymbolTable)tuple22._2();
                void stmt2 = var11_9;
                void newScope2 = var12_10;
                void loc = var10_8;
                tuple2 = new Tuple2<Statement, void>(stmt2.changeLocation((SourceLocation)loc), newScope2);
                break block10;
            }
            if (TokenType$Command$.MODULE$.equals(tokenType2)) {
                void var21_20;
                void var20_19;
                tokens.next();
                Command coreCommand = (Command)token.value();
                TokenType tokenType3 = tokens.head().tpe();
                TokenType$Eof$ tokenType$Eof$ = TokenType$Eof$.MODULE$;
                None$ nameToken = (tokenType3 == null ? tokenType$Eof$ != null : !tokenType3.equals(tokenType$Eof$)) ? new Some<Token>(tokens.head()) : None$.MODULE$;
                Tuple2 tuple24 = (Tuple2)LetScope$.MODULE$.apply(coreCommand, nameToken, scope).map((Function1<Tuple2, Tuple2> & Serializable & scala.Serializable)x0$1 -> {
                    if (x0$1 == null) {
                        throw new MatchError((Object)null);
                    }
                    Command letCommand = (Command)x0$1._1();
                    SymbolTable newScope = (SymbolTable)x0$1._2();
                    Tuple2<Statement, SymbolTable> tuple2 = new Tuple2<Statement, SymbolTable>(new Statement(letCommand, token.sourceLocation()), newScope);
                    return tuple2;
                }).getOrElse((Function0<Tuple2> & Serializable & scala.Serializable)() -> new Tuple2<Statement, SymbolTable>(new Statement(coreCommand, token.sourceLocation()), scope));
                if (tuple24 == null) {
                    throw new MatchError((Object)null);
                }
                Statement stmt = (Statement)tuple24._1();
                SymbolTable newScope = (SymbolTable)tuple24._2();
                void stmt3 = var20_19;
                void newScope3 = var21_20;
                Seq<Expression> arguments = this.parsePotentiallyVariadicArgumentList(coreCommand.syntax(), variadic, (Application)stmt3, tokens, (SymbolTable)newScope3);
                tuple2 = new Tuple2<Statement, void>(stmt3.withArguments(arguments), newScope3);
            } else {
                Object object = token.value();
                boolean bl = object instanceof _symbol ? true : object instanceof _unknownidentifier;
                if (bl && !scope.contains(token.text().toUpperCase())) {
                    throw Fail$.MODULE$.exception(I18N$.MODULE$.errors().getN("compiler.LetVariable.notDefined", Predef$.MODULE$.wrapRefArray(new Object[]{token.text().toUpperCase()})), token);
                }
                throw Fail$.MODULE$.exception(this.ExpectedCommand(), token);
            }
        }
        return tuple2;
    }

    private Seq<Expression> parsePotentiallyVariadicArgumentList(Syntax syntax, boolean variadicContext, Application app, BufferedIterator<Token> tokens, SymbolTable scope) {
        Seq<Expression> untypedArgs = variadicContext && syntax.isVariadic() ? this.parseVarArgs(syntax, app.sourceLocation(), app.instruction().displayName(), tokens, scope) : this.parseArguments(syntax, app.sourceLocation(), app.instruction().displayName(), tokens, scope);
        return this.resolveTypes(syntax, untypedArgs, app.sourceLocation(), app.instruction().displayName(), scope);
    }

    private Seq<Expression> resolveTypes(Syntax syntax, Seq<Expression> untypedArgs, SourceLocation location, String displayName, SymbolTable scope) {
        scala.collection.mutable.Seq typedArgs = (scala.collection.mutable.Seq)scala.collection.mutable.Seq$.MODULE$.apply(untypedArgs);
        int actual1 = 0;
        if (syntax.isInfix()) {
            int tpe = syntax.left();
            Fail$.MODULE$.cAssert(untypedArgs.size() >= 1, (Function0<String> & Serializable & scala.Serializable)() -> MODULE$.missingInput(syntax, displayName, false), location);
            typedArgs.update(0, this.resolveType(tpe, (Expression)untypedArgs.apply(false), displayName, scope));
            actual1 = 1;
        }
        int formal1 = 0;
        List<Object> types = syntax.right();
        while (formal1 < types.length() && !Syntax$.MODULE$.compatible(Syntax$.MODULE$.RepeatableType(), BoxesRunTime.unboxToInt(types.apply(formal1)))) {
            if (formal1 == types.length() - 1 && untypedArgs.size() == types.length() - 1 && Syntax$.MODULE$.compatible(Syntax$.MODULE$.OptionalType(), BoxesRunTime.unboxToInt(types.apply(formal1)))) {
                return (Seq)Seq$.MODULE$.apply(typedArgs);
            }
            Fail$.MODULE$.cAssert(untypedArgs.size() > actual1, (Function0<String> & Serializable & scala.Serializable)() -> MODULE$.missingInput(syntax, displayName, true), location);
            typedArgs.update(actual1, this.resolveType(BoxesRunTime.unboxToInt(types.apply(formal1)), (Expression)untypedArgs.apply(actual1), displayName, scope));
            ++formal1;
            ++actual1;
        }
        if (formal1 < types.length()) {
            int actual2 = untypedArgs.size() - 1;
            int formal2 = types.length() - 1;
            while (formal2 >= 0 && !Syntax$.MODULE$.compatible(Syntax$.MODULE$.RepeatableType(), BoxesRunTime.unboxToInt(types.apply(formal2)))) {
                Fail$.MODULE$.cAssert(untypedArgs.size() > actual2 && actual2 > -1, (Function0<String> & Serializable & scala.Serializable)() -> MODULE$.missingInput(syntax, displayName, true), location);
                typedArgs.update(actual2, this.resolveType(BoxesRunTime.unboxToInt(types.apply(formal2)), (Expression)untypedArgs.apply(actual2), displayName, scope));
                --formal2;
                --actual2;
            }
            while (actual1 <= actual2) {
                typedArgs.update(actual1, this.resolveType(BoxesRunTime.unboxToInt(types.apply(formal1)), (Expression)untypedArgs.apply(actual1), displayName, scope));
                ++actual1;
            }
        }
        return (Seq)Seq$.MODULE$.apply(typedArgs);
    }

    private Seq<Expression> parseArguments(Syntax syntax, SourceLocation sourceLocation, String displayName, BufferedIterator<Token> tokens, SymbolTable scope) {
        Buffer args = (Buffer)Buffer$.MODULE$.apply(Nil$.MODULE$);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), syntax.rightDefault()).foreach((Function1<Object, Buffer> & Serializable & scala.Serializable)i -> args.$plus$eq(ExpressionParser$.MODULE$.parseArgExpression(syntax, tokens, sourceLocation, displayName, BoxesRunTime.unboxToInt(syntax.right().apply(RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(BoxesRunTime.unboxToInt(i)), syntax.right().size() - 1))), scope)));
        if (syntax.takesOptionalCommandBlock()) {
            Expression expression;
            TokenType tokenType2 = tokens.head().tpe();
            TokenType$OpenBracket$ tokenType$OpenBracket$ = TokenType$OpenBracket$.MODULE$;
            if (!(tokenType2 != null ? !tokenType2.equals(tokenType$OpenBracket$) : tokenType$OpenBracket$ != null)) {
                expression = this.parseArgExpression(syntax, tokens, sourceLocation, displayName, BoxesRunTime.unboxToInt(syntax.right().last()), scope);
            } else {
                String file = ((SourceLocatable)tokens.head()).filename();
                int location = BoxesRunTime.unboxToInt(args.lastOption().map((Function1<Expression, Object> & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToInteger(x$7.end())).getOrElse((JFunction0$mcI$sp & scala.Serializable)() -> sourceLocation.end()));
                expression = new CommandBlock(new Statements(file), new SourceLocation(location, location, file), true);
            }
            Expression newExp = expression;
            args.$plus$eq(newExp);
        }
        return args.toSeq();
    }

    private Seq<Expression> parseVarArgs(Syntax syntax, SourceLocation sourceLocation, String displayName, BufferedIterator<Token> tokens, SymbolTable scope) {
        return this.parseArgument$1(tokens, syntax.right(), scope, Nil$.MODULE$, syntax, sourceLocation, displayName);
    }

    private Expression parseArgExpression(Syntax syntax, BufferedIterator<Token> tokens, SourceLocation sourceLocation, String displayName, int goalType, SymbolTable scope) {
        try {
            return this.parseExpressionInternal(tokens, false, syntax.precedence(), goalType, scope);
        }
        catch (Throwable throwable) {
            boolean bl = throwable instanceof ExpressionParser.MissingPrefixException ? true : throwable instanceof ExpressionParser.UnexpectedTokenException;
            if (bl) {
                throw Fail$.MODULE$.exception(this.missingInput(syntax, displayName, true), sourceLocation);
            }
            throw throwable;
        }
    }

    private String missingInput(Syntax syntax, String displayName, boolean right) {
        String result;
        LazyRef inputName$lzy = new LazyRef();
        LazyRef variadicQuantifier$lzy = new LazyRef();
        LazyRef infixQuantifier$lzy = new LazyRef();
        LazyRef rightArgs$lzy = new LazyRef();
        String string2 = right && syntax.isVariadic() && syntax.minimum() == 0 ? new StringBuilder(79).append(displayName).append(" expected ").append(syntax.rightDefault()).append(" ").append(ExpressionParser$.inputName$1(inputName$lzy, syntax)).append(" on the right or any number of inputs when surrounded by parentheses").toString() : (result = right ? new StringBuilder(11).append(displayName).append(" expected").append(ExpressionParser$.variadicQuantifier$1(variadicQuantifier$lzy, syntax)).append(" ").append(syntax.rightDefault()).append(" ").append(ExpressionParser$.inputName$1(inputName$lzy, syntax)).append(ExpressionParser$.infixQuantifier$1(infixQuantifier$lzy, syntax)).toString() : new StringBuilder(22).append(displayName).append(" expected ").append(TypeNames$.MODULE$.aName(syntax.left())).append(" on the left").toString());
        if (!right) {
            return result;
        }
        if (ExpressionParser$.rightArgs$1(rightArgs$lzy, syntax).forall((Function1<String, Object> & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean(ExpressionParser$.$anonfun$missingInput$2(x$9)))) {
            return new StringBuilder(1).append(result).append(".").toString();
        }
        if (ExpressionParser$.rightArgs$1(rightArgs$lzy, syntax).size() == 1) {
            return new StringBuilder(3).append(result).append(", ").append(ExpressionParser$.rightArgs$1(rightArgs$lzy, syntax).mkString()).append(".").toString();
        }
        return new StringBuilder(8).append(result).append(", ").append(ExpressionParser$.rightArgs$1(rightArgs$lzy, syntax).toList().dropRight(1).mkString(", ")).append(" and ").append(ExpressionParser$.rightArgs$1(rightArgs$lzy, syntax).last()).append(".").toString();
    }

    private Expression resolveType(int goalType, Expression originalArg, String instruction, SymbolTable scope) {
        Expression expression;
        if (originalArg instanceof DelayedBlock) {
            DelayedBlock delayedBlock = (DelayedBlock)originalArg;
            expression = this.parseDelayedBlock(delayedBlock, goalType, scope);
        } else {
            expression = originalArg;
        }
        Fail$.MODULE$.cAssert(Syntax$.MODULE$.compatible(goalType, expression.reportedType()), (Function0<String> & Serializable & scala.Serializable)() -> {
            int displayedReportedType = (goalType & Syntax$.MODULE$.ReferenceType()) == 0 && (expression.reportedType() & ~Syntax$.MODULE$.ReferenceType()) != 0 ? expression.reportedType() & ~Syntax$.MODULE$.ReferenceType() : expression.reportedType();
            return new StringBuilder(45).append(instruction).append(" expected this input to be ").append(TypeNames$.MODULE$.aName(goalType)).append(", but got ").append(TypeNames$.MODULE$.aName(displayedReportedType)).append(" instead").toString();
        }, expression);
        return expression;
    }

    public Expression parseExpression(BufferedIterator<Token> tokens, boolean variadic, int goalType, SymbolTable scope) {
        try {
            return this.parseExpressionInternal(tokens, variadic, this.MinPrecedence(), goalType, scope);
        }
        catch (ExpressionParser.MissingPrefixException e) {
            throw Fail$.MODULE$.exception(this.MissingInputOnLeft(), e.token());
        }
        catch (ExpressionParser.UnexpectedTokenException e) {
            throw Fail$.MODULE$.exception(this.ExpectedReporter(), e.token());
        }
    }

    private <A> Tuple2<A, SourceLocation> parseParenthesized(BufferedIterator<Token> tokens, Function1<BufferedIterator<Token>, A> parse2, String filename) {
        Token openParen = (Token)tokens.next();
        TokenType tokenType2 = openParen.tpe();
        TokenType$OpenParen$ tokenType$OpenParen$ = TokenType$OpenParen$.MODULE$;
        Predef$.MODULE$.assert(!(tokenType2 != null ? !tokenType2.equals(tokenType$OpenParen$) : tokenType$OpenParen$ != null));
        A node = parse2.apply(tokens);
        Token closeParen = (Token)tokens.next();
        TokenType tokenType3 = closeParen.tpe();
        TokenType$Eof$ tokenType$Eof$ = TokenType$Eof$.MODULE$;
        Fail$.MODULE$.cAssert(tokenType3 == null ? tokenType$Eof$ != null : !tokenType3.equals(tokenType$Eof$), (Function0<String> & Serializable & scala.Serializable)() -> MODULE$.MissingCloseParen(), openParen);
        TokenType tokenType4 = closeParen.tpe();
        TokenType$CloseParen$ tokenType$CloseParen$ = TokenType$CloseParen$.MODULE$;
        Fail$.MODULE$.cAssert(!(tokenType4 != null ? !tokenType4.equals(tokenType$CloseParen$) : tokenType$CloseParen$ != null), (Function0<String> & Serializable & scala.Serializable)() -> MODULE$.ExpectedCloseParen(), closeParen);
        return new Tuple2<A, SourceLocation>(node, new SourceLocation(openParen.start(), closeParen.end(), filename));
    }

    /*
     * WARNING - void declaration
     */
    private Expression parseExpressionInternal(BufferedIterator<Token> tokens, boolean variadic, int precedence, int goalType, SymbolTable scope) {
        Expression expression;
        Token token = tokens.head();
        boolean wantAnyLambda = goalType == (Syntax$.MODULE$.ReporterType() | Syntax$.MODULE$.CommandType());
        boolean wantReporterLambda = wantAnyLambda || goalType == Syntax$.MODULE$.ReporterType();
        boolean wantCommandLambda = wantAnyLambda || goalType == Syntax$.MODULE$.CommandType();
        TokenType tokenType2 = token.tpe();
        if (TokenType$OpenParen$.MODULE$.equals(tokenType2)) {
            void var17_13;
            void var16_12;
            Tuple2 tuple2 = this.parseParenthesized(tokens, (Function1<BufferedIterator, Expression> & Serializable & scala.Serializable)ts -> {
                Expression exp = MODULE$.parseExpression((BufferedIterator<Token>)ts, true, goalType, scope);
                TokenType tokenType2 = ((Token)ts.head()).tpe();
                TokenType$Command$ tokenType$Command$ = TokenType$Command$.MODULE$;
                Fail$.MODULE$.cAssert(tokenType2 == null ? tokenType$Command$ != null : !tokenType2.equals(tokenType$Command$), (Function0<String> & Serializable & scala.Serializable)() -> MODULE$.MissingCloseParen(), token);
                return exp;
            }, token.filename());
            if (tuple2 == null) {
                throw new MatchError((Object)null);
            }
            Expression expr = (Expression)tuple2._1();
            SourceLocation loc = tuple2._2();
            void expr2 = var16_12;
            void loc2 = var17_13;
            expression = expr2.changeLocation((SourceLocation)loc2);
        } else if (TokenType$OpenBracket$.MODULE$.equals(tokenType2)) {
            expression = this.delayBlock(token, tokens, scope);
        } else {
            boolean bl = TokenType$Reporter$.MODULE$.equals(tokenType2) ? true : TokenType$Command$.MODULE$.equals(tokenType2);
            if (bl && Syntax$.MODULE$.compatible(goalType, Syntax$.MODULE$.SymbolType())) {
                tokens.next();
                _symbol symbol = new _symbol();
                token.refine(symbol, token.refine$default$2(), token.refine$default$3());
                expression = new ReporterApp(symbol, token.sourceLocation());
            } else {
                boolean bl2 = TokenType$Reporter$.MODULE$.equals(tokenType2) ? true : TokenType$Literal$.MODULE$.equals(tokenType2);
                if (bl2) {
                    void var26_26;
                    void var25_25;
                    Tuple2 tuple2;
                    tokens.next();
                    TokenType tokenType3 = token.tpe();
                    if (TokenType$Literal$.MODULE$.equals(tokenType3)) {
                        _const coreReporter = new _const(token.value());
                        coreReporter.token_$eq(token);
                        tuple2 = new Tuple2(coreReporter.syntax(), new ReporterApp(coreReporter, token.sourceLocation()));
                    } else if (TokenType$Reporter$.MODULE$.equals(tokenType3)) {
                        Tuple2 tuple22;
                        Reporter coreReporter = (Reporter)token.value();
                        if (coreReporter instanceof _symbol || coreReporter instanceof _unknownidentifier) {
                            tuple22 = goalType == Syntax$.MODULE$.SymbolType() ? new Tuple2(coreReporter.syntax(), new ReporterApp(coreReporter, token.sourceLocation())) : (Tuple2)LetVariableScope$.MODULE$.apply(coreReporter, token, scope).map((Function1<Tuple2, Tuple2> & Serializable & scala.Serializable)x0$1 -> {
                                if (x0$1 == null) {
                                    throw new MatchError((Object)null);
                                }
                                Reporter letReporter = (Reporter)x0$1._1();
                                Tuple2<Syntax, ReporterApp> tuple2 = new Tuple2<Syntax, ReporterApp>(letReporter.syntax(), new ReporterApp(letReporter, token.sourceLocation()));
                                return tuple2;
                            }).getOrElse((Function0<Nothing$> & Serializable & scala.Serializable)() -> Fail$.MODULE$.exception(I18N$.MODULE$.errors().getN("compiler.LetVariable.notDefined", Predef$.MODULE$.wrapRefArray(new Object[]{token.text().toUpperCase()})), token));
                        } else if (!coreReporter.syntax().isInfix() || wantReporterLambda) {
                            tuple22 = new Tuple2<Syntax, ReporterApp>(coreReporter.syntax(), new ReporterApp(coreReporter, token.sourceLocation()));
                        } else {
                            if (!(coreReporter instanceof _minus) || !variadic) {
                                throw new ExpressionParser.MissingPrefixException(token);
                            }
                            _unaryminus r2 = new _unaryminus();
                            r2.token_$eq(token);
                            tuple22 = new Tuple2<Syntax, ReporterApp>(r2.syntax(), new ReporterApp(r2, token.sourceLocation()));
                        }
                        tuple2 = tuple22;
                    } else {
                        throw package$.MODULE$.error(new StringBuilder(23).append("unexpected token type: ").append(token.tpe()).toString());
                    }
                    if (tuple2 == null) {
                        throw new MatchError((Object)null);
                    }
                    Syntax syntax = tuple2._1();
                    ReporterApp rApp = (ReporterApp)tuple2._2();
                    void syntax2 = var25_25;
                    void rApp2 = var26_26;
                    expression = wantReporterLambda && !variadic && !this.wantsSymbolicValue(rApp2.reporter()) && (wantAnyLambda || syntax2.totalDefault() > 0) ? this.expandConciseReporterLambda((ReporterApp)rApp2, rApp2.reporter(), scope) : rApp2.withArguments(this.parsePotentiallyVariadicArgumentList((Syntax)syntax2, variadic, (Application)rApp2, tokens, scope));
                } else if (TokenType$Command$.MODULE$.equals(tokenType2) && wantCommandLambda) {
                    tokens.next();
                    expression = this.expandConciseCommandLambda(token, scope);
                } else {
                    throw new ExpressionParser.UnexpectedTokenException(token);
                }
            }
        }
        return this.parseMore(expression, tokens, precedence, scope);
    }

    /*
     * WARNING - void declaration
     */
    private Tuple2<Seq<String>, Seq<ReporterApp>> syntheticVariables(int count, Token token, SymbolTable scope) {
        void var5_5;
        Tuple2<Nil$, SymbolTable> tuple2 = RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), count).foldLeft(new Tuple2<Nil$, SymbolTable>(Nil$.MODULE$, scope), (Function2<Tuple2, Object, Tuple2> & Serializable & scala.Serializable)(x0$1, x1$1) -> ExpressionParser$.$anonfun$syntheticVariables$1(x0$1, BoxesRunTime.unboxToInt(x1$1)));
        if (tuple2 == null) {
            throw new MatchError((Object)null);
        }
        Seq varNames = tuple2._1();
        Seq varApps = var5_5.map((Function1<String, ReporterApp> & Serializable & scala.Serializable)vn -> {
            _lambdavariable lv = new _lambdavariable((String)vn, true);
            lv.token_$eq(token);
            return new ReporterApp(lv, new SourceLocation(token.start(), token.end(), token.filename()));
        }, scala.collection.Seq$.MODULE$.canBuildFrom());
        return new Tuple2(var5_5, varApps);
    }

    /*
     * WARNING - void declaration
     */
    private ReporterApp expandConciseReporterLambda(ReporterApp rApp, Reporter reporter, SymbolTable scope) {
        void var6_6;
        void var5_5;
        Tuple2<Seq<String>, Seq<ReporterApp>> tuple2 = this.syntheticVariables(reporter.syntax().totalDefault(), reporter.token(), scope);
        if (tuple2 == null) {
            throw new MatchError((Object)null);
        }
        Seq<String> varNames = tuple2._1();
        Seq<ReporterApp> varApps = tuple2._2();
        void varNames2 = var5_5;
        void varApps2 = var6_6;
        _reporterlambda lambda = new _reporterlambda(new Lambda.ConciseArguments((Seq<String>)varNames2));
        lambda.token_$eq(reporter.token());
        return new ReporterApp(lambda, new $colon$colon<Nothing$>((Nothing$)((Object)rApp.withArguments((Seq<Expression>)varApps2)), Nil$.MODULE$), reporter.token().sourceLocation());
    }

    /*
     * WARNING - void declaration
     */
    private ReporterApp expandConciseCommandLambda(Token token, SymbolTable scope) {
        void var6_6;
        void var5_5;
        Command coreCommand = (Command)token.value();
        if (!coreCommand.syntax().canBeConcise()) {
            throw new ExpressionParser.UnexpectedTokenException(token);
        }
        Tuple2<Seq<String>, Seq<ReporterApp>> tuple2 = this.syntheticVariables(coreCommand.syntax().totalDefault(), coreCommand.token(), scope);
        if (tuple2 == null) {
            throw new MatchError((Object)null);
        }
        Seq<String> varNames = tuple2._1();
        Seq<ReporterApp> varApps = tuple2._2();
        void varNames2 = var5_5;
        void varApps2 = var6_6;
        void stmtArgs = coreCommand.syntax().takesOptionalCommandBlock() ? varApps2.$colon$plus(new CommandBlock(new Statements(token.filename()), token.sourceLocation(), true), scala.collection.Seq$.MODULE$.canBuildFrom()) : varApps2;
        _commandlambda lambda = new _commandlambda(new Lambda.ConciseArguments((Seq<String>)varNames2));
        lambda.token_$eq(token);
        Statement stmt = new Statement(coreCommand, (Seq<Expression>)stmtArgs, token.sourceLocation());
        CommandBlock commandBlock = this.commandBlockWithStatements(token.sourceLocation(), new $colon$colon<Nothing$>((Nothing$)((Object)stmt), Nil$.MODULE$), true);
        return new ReporterApp(lambda, new $colon$colon<Nothing$>((Nothing$)((Object)commandBlock), Nil$.MODULE$), token.sourceLocation());
    }

    private CommandBlock commandBlockWithStatements(SourceLocation sourceLocation, Seq<Statement> stmts, boolean synthetic) {
        Statements statements = new Statements(sourceLocation.filename(), stmts);
        return new CommandBlock(statements, sourceLocation, synthetic);
    }

    private boolean commandBlockWithStatements$default$3() {
        return false;
    }

    public Expression parseMore(Expression originalExpr, BufferedIterator<Token> tokens, int precedence, SymbolTable scope) {
        Expression expr = originalExpr;
        boolean done = false;
        while (!done) {
            Token token = tokens.head();
            TokenType tokenType2 = token.tpe();
            TokenType$Reporter$ tokenType$Reporter$ = TokenType$Reporter$.MODULE$;
            if (!(tokenType2 != null ? !tokenType2.equals(tokenType$Reporter$) : tokenType$Reporter$ != null)) {
                Reporter coreReporter = (Reporter)token.value();
                Syntax syntax = coreReporter.syntax();
                if (syntax.isInfix() && (syntax.precedence() > precedence || syntax.isRightAssociative() && syntax.precedence() == precedence)) {
                    tokens.next();
                    Fail$.MODULE$.cAssert(expr != null, (Function0<String> & Serializable & scala.Serializable)() -> MODULE$.MissingInputOnLeft(), token);
                    SourceLocation sourceLocation = new SourceLocation(expr.start(), token.end(), token.filename());
                    Seq<Expression> untypedArgs = this.parseArguments(syntax, sourceLocation, coreReporter.displayName(), tokens, scope);
                    Seq<Expression> typedArgs = this.resolveTypes(syntax, untypedArgs.$plus$colon(expr, scala.collection.Seq$.MODULE$.canBuildFrom()), sourceLocation, coreReporter.displayName(), scope);
                    int x$1 = ((SourceLocatable)typedArgs.last()).end();
                    int x$2 = sourceLocation.copy$default$1();
                    String x$3 = sourceLocation.copy$default$3();
                    expr = new ReporterApp(coreReporter, typedArgs, sourceLocation.copy(x$2, x$1, x$3));
                    continue;
                }
                done = true;
                continue;
            }
            done = true;
        }
        return expr;
    }

    private DelayedBlock delayBlock(Token openBracket, BufferedIterator<Token> tokens, SymbolTable scope) {
        Seq collectedBlock = this.collect$1(tokens, new UnrolledBuffer(ClassTag$.MODULE$.apply(Token.class)), 0, openBracket).toSeq();
        return DelayedBlock$.MODULE$.apply(openBracket, (Seq)collectedBlock.tail(), scope);
    }

    /*
     * WARNING - void declaration
     */
    private Expression parseDelayedBlock(DelayedBlock block, int goalType, SymbolTable scope) {
        boolean listNotWanted;
        BufferedIterator<Token> tokens = ((IterableLike)block.tokens().tail()).iterator().buffered();
        boolean bl = listNotWanted = !Syntax$.MODULE$.compatible(goalType, Syntax$.MODULE$.ListType());
        if (Syntax$.MODULE$.compatible(goalType, Syntax$.MODULE$.CodeBlockType())) {
            return this.parseCodeBlock(block, tokens);
        }
        if (block.isArrowLambda() && !block.isCommand()) {
            return this.buildReporterLambda$1(((ArrowLambdaBlock)block).arguments(), tokens, block);
        }
        if (block.isArrowLambda() && block.isCommand()) {
            return this.buildCommandLambda$1(((ArrowLambdaBlock)block).arguments(), tokens, block);
        }
        if (Syntax$.MODULE$.compatible(goalType, Syntax$.MODULE$.ReporterBlockType())) {
            void var8_8;
            void var7_7;
            Tuple2 tuple2 = this.reporterApp$1(tokens, goalType, scope, tokens, block);
            if (tuple2 == null) {
                throw new MatchError((Object)null);
            }
            ReporterApp expr = (ReporterApp)tuple2._1();
            Token lastToken = (Token)tuple2._2();
            void expr2 = var7_7;
            void lastToken2 = var8_8;
            return new ReporterBlock((ReporterApp)expr2, new SourceLocation(block.openBracket().start(), lastToken2.end(), lastToken2.filename()));
        }
        if (Syntax$.MODULE$.compatible(goalType, Syntax$.MODULE$.CommandBlockType())) {
            void var13_13;
            void var12_12;
            Tuple2 tuple2 = this.statementList$1(tokens, scope, block);
            if (tuple2 == null) {
                throw new MatchError((Object)null);
            }
            Seq stmtList = (Seq)tuple2._1();
            Token lastToken = (Token)tuple2._2();
            void stmtList2 = var12_12;
            void lastToken3 = var13_13;
            return this.commandBlockWithStatements(lastToken3.sourceLocation().copy(block.openBracket().start(), lastToken3.sourceLocation().copy$default$2(), lastToken3.sourceLocation().copy$default$3()), (Seq<Statement>)stmtList2, this.commandBlockWithStatements$default$3());
        }
        if (Syntax$.MODULE$.compatible(goalType, Syntax$.MODULE$.ReporterType()) && !block.isCommand() && listNotWanted) {
            return this.buildReporterLambda$1(new Lambda.NoArguments(false), tokens, block);
        }
        if (Syntax$.MODULE$.compatible(goalType, Syntax$.MODULE$.CommandType()) && block.isCommand() && listNotWanted) {
            return this.buildCommandLambda$1(new Lambda.NoArguments(false), tokens, block);
        }
        if (Syntax$.MODULE$.compatible(goalType, Syntax$.MODULE$.ListType())) {
            void var18_18;
            void var17_17;
            Tuple2<LogoList, Token> tuple2 = new LiteralParser(NullImportHandler$.MODULE$).parseLiteralList(block.openBracket(), tokens);
            if (tuple2 == null) {
                throw new MatchError((Object)null);
            }
            LogoList list = tuple2._1();
            Token closeBracket = tuple2._2();
            void list2 = var17_17;
            void closeBracket2 = var18_18;
            _const tmp = new _const(list2);
            tmp.token_$eq(new Token("", TokenType$Literal$.MODULE$, null, new SourceLocation(block.openBracket().start(), closeBracket2.end(), closeBracket2.filename())));
            return new ReporterApp(tmp, new SourceLocation(block.openBracket().start(), closeBracket2.end(), closeBracket2.filename()));
        }
        throw Fail$.MODULE$.exception(new StringBuilder(44).append("Expected ").append(TypeNames$.MODULE$.aName(goalType)).append(" here, rather than a list or block.").toString(), block);
    }

    private ReporterApp parseCodeBlock(DelayedBlock block, BufferedIterator<Token> tokens) {
        Seq<Token> seq;
        if (block instanceof ArrowLambdaBlock) {
            seq = ((ArrowLambdaBlock)block).allTokens();
        } else if (block instanceof AmbiguousDelayedBlock) {
            seq = ((AmbiguousDelayedBlock)block).tokens();
        } else {
            throw new MatchError(block);
        }
        this.check$1((Seq)seq.dropRight(2), ExpressionParser$.check$default$2$1(), block);
        _constcodeblock tmp = new _constcodeblock((Seq)((IterableLike)seq.tail()).dropRight(2));
        tmp.token_$eq((Token)seq.head());
        return new ReporterApp(tmp, new SourceLocation(((SourceLocatable)seq.head()).start(), block.end(), ((SourceLocatable)seq.head()).filename()));
    }

    private boolean wantsSymbolicValue(Reporter reporter) {
        return Syntax$.MODULE$.compatible(reporter.syntax().left(), Syntax$.MODULE$.CodeBlockType() | Syntax$.MODULE$.SymbolType()) || reporter.syntax().right().exists((JFunction1$mcZI$sp & scala.Serializable)arg -> Syntax$.MODULE$.compatible(arg, Syntax$.MODULE$.CodeBlockType() | Syntax$.MODULE$.SymbolType()));
    }

    private String ExpectedCommand() {
        if ((this.bitmap$init$0 & 2) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /media/sf_NetLogo/parser-core/src/main/parse/ExpressionParser.scala: 698");
        }
        return this.ExpectedCommand;
    }

    private String ExpectedCloseBracket() {
        if ((this.bitmap$init$0 & 4) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /media/sf_NetLogo/parser-core/src/main/parse/ExpressionParser.scala: 699");
        }
        return this.ExpectedCloseBracket;
    }

    private String ExpectedCloseParen() {
        if ((this.bitmap$init$0 & 8) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /media/sf_NetLogo/parser-core/src/main/parse/ExpressionParser.scala: 700");
        }
        return this.ExpectedCloseParen;
    }

    private String ExpectedReporter() {
        if ((this.bitmap$init$0 & 0x10) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /media/sf_NetLogo/parser-core/src/main/parse/ExpressionParser.scala: 701");
        }
        return this.ExpectedReporter;
    }

    private String InvalidVariadicContext() {
        if ((this.bitmap$init$0 & 0x20) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /media/sf_NetLogo/parser-core/src/main/parse/ExpressionParser.scala: 702");
        }
        return this.InvalidVariadicContext;
    }

    private String MissingCloseBracket() {
        if ((this.bitmap$init$0 & 0x40) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /media/sf_NetLogo/parser-core/src/main/parse/ExpressionParser.scala: 704");
        }
        return this.MissingCloseBracket;
    }

    private String MissingCloseParen() {
        if ((this.bitmap$init$0 & 0x80) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /media/sf_NetLogo/parser-core/src/main/parse/ExpressionParser.scala: 705");
        }
        return this.MissingCloseParen;
    }

    private String MissingInputOnLeft() {
        if ((this.bitmap$init$0 & 0x100) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /media/sf_NetLogo/parser-core/src/main/parse/ExpressionParser.scala: 706");
        }
        return this.MissingInputOnLeft;
    }

    private final Seq parseArgument$1(BufferedIterator toks, List goalTypes, SymbolTable scope, Seq parsedArgs, Syntax syntax$3, SourceLocation sourceLocation$2, String displayName$3) {
        TokenType tokenType2;
        Token token;
        while ((token = (Token)toks.head()) == null || !TokenType$CloseParen$.MODULE$.equals(tokenType2 = token.tpe())) {
            if (token != null) {
                TokenType tokenType3 = token.tpe();
                Object rep = token.value();
                if (TokenType$Reporter$.MODULE$.equals(tokenType3) && rep instanceof Reporter) {
                    Reporter reporter = (Reporter)rep;
                    if (BoxesRunTime.unboxToInt(goalTypes.head()) != Syntax$.MODULE$.ReporterType() && reporter.syntax().isInfix()) {
                        Fail$.MODULE$.cAssert(parsedArgs.size() == syntax$3.totalDefault(), (Function0<String> & Serializable & scala.Serializable)() -> MODULE$.InvalidVariadicContext(), sourceLocation$2);
                        break;
                    }
                }
            }
            Expression newExp = this.parseArgExpression(syntax$3, toks, sourceLocation$2, displayName$3, BoxesRunTime.unboxToInt(goalTypes.head()), scope);
            List newGoals = ((TraversableOnce)goalTypes.tail()).nonEmpty() ? (List)goalTypes.tail() : goalTypes;
            parsedArgs = parsedArgs.$colon$plus(newExp, scala.collection.Seq$.MODULE$.canBuildFrom());
            goalTypes = newGoals;
        }
        return parsedArgs;
    }

    private static final /* synthetic */ String inputName$lzycompute$1(LazyRef inputName$lzy$1, Syntax syntax$4) {
        synchronized (inputName$lzy$1) {
            String string2 = inputName$lzy$1.initialized() ? (String)inputName$lzy$1.value() : inputName$lzy$1.initialize(syntax$4.rightDefault() > 1 ? "inputs" : "input");
            return string2;
        }
    }

    private static final String inputName$1(LazyRef inputName$lzy$1, Syntax syntax$4) {
        if (inputName$lzy$1.initialized()) {
            return (String)inputName$lzy$1.value();
        }
        return ExpressionParser$.inputName$lzycompute$1(inputName$lzy$1, syntax$4);
    }

    private static final /* synthetic */ String variadicQuantifier$lzycompute$1(LazyRef variadicQuantifier$lzy$1, Syntax syntax$4) {
        synchronized (variadicQuantifier$lzy$1) {
            String string2 = variadicQuantifier$lzy$1.initialized() ? (String)variadicQuantifier$lzy$1.value() : variadicQuantifier$lzy$1.initialize(syntax$4.isVariadic() ? " at least" : "");
            return string2;
        }
    }

    private static final String variadicQuantifier$1(LazyRef variadicQuantifier$lzy$1, Syntax syntax$4) {
        if (variadicQuantifier$lzy$1.initialized()) {
            return (String)variadicQuantifier$lzy$1.value();
        }
        return ExpressionParser$.variadicQuantifier$lzycompute$1(variadicQuantifier$lzy$1, syntax$4);
    }

    private static final /* synthetic */ String infixQuantifier$lzycompute$1(LazyRef infixQuantifier$lzy$1, Syntax syntax$4) {
        synchronized (infixQuantifier$lzy$1) {
            String string2 = infixQuantifier$lzy$1.initialized() ? (String)infixQuantifier$lzy$1.value() : infixQuantifier$lzy$1.initialize(syntax$4.isInfix() ? " on the right" : "");
            return string2;
        }
    }

    private static final String infixQuantifier$1(LazyRef infixQuantifier$lzy$1, Syntax syntax$4) {
        if (infixQuantifier$lzy$1.initialized()) {
            return (String)infixQuantifier$lzy$1.value();
        }
        return ExpressionParser$.infixQuantifier$lzycompute$1(infixQuantifier$lzy$1, syntax$4);
    }

    public static final /* synthetic */ String $anonfun$missingInput$1(int x$8) {
        return TypeNames$.MODULE$.aName(x$8).replaceFirst("anything", "any input");
    }

    private static final /* synthetic */ List rightArgs$lzycompute$1(LazyRef rightArgs$lzy$1, Syntax syntax$4) {
        synchronized (rightArgs$lzy$1) {
            List list = rightArgs$lzy$1.initialized() ? (List)rightArgs$lzy$1.value() : rightArgs$lzy$1.initialize(syntax$4.right().map((Function1<Object, String> & Serializable & scala.Serializable)x$8 -> ExpressionParser$.$anonfun$missingInput$1(BoxesRunTime.unboxToInt(x$8)), List$.MODULE$.canBuildFrom()));
            return list;
        }
    }

    private static final List rightArgs$1(LazyRef rightArgs$lzy$1, Syntax syntax$4) {
        if (rightArgs$lzy$1.initialized()) {
            return (List)rightArgs$lzy$1.value();
        }
        return ExpressionParser$.rightArgs$lzycompute$1(rightArgs$lzy$1, syntax$4);
    }

    public static final /* synthetic */ boolean $anonfun$missingInput$2(String x$9) {
        String string2 = x$9;
        String string3 = "any input";
        return string2 != null && string2.equals(string3);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ Tuple2 $anonfun$syntheticVariables$1(Tuple2 x0$1, int x1$1) {
        void var9_9;
        void var8_8;
        Seq acc;
        Integer n = BoxesRunTime.boxToInteger(x1$1);
        Tuple2<Tuple2, Integer> tuple2 = new Tuple2<Tuple2, Integer>(x0$1, n);
        Tuple2 tuple22 = x0$1;
        if (tuple22 != null) {
            acc = (Seq)tuple22._1();
            SymbolTable s = (SymbolTable)tuple22._2();
            Tuple2<String, SymbolTable> tuple23 = s.withFreshSymbol(SymbolType$LambdaVariable$.MODULE$, s.withFreshSymbol$default$2());
            if (tuple23 == null) {
                throw new MatchError((Object)null);
            }
            String varName = tuple23._1();
            SymbolTable newScope = tuple23._2();
        } else {
            throw new MatchError(tuple2);
        }
        void varName = var8_8;
        void newScope = var9_9;
        Tuple2 tuple24 = new Tuple2(acc.$colon$plus(varName, scala.collection.Seq$.MODULE$.canBuildFrom()), newScope);
        return tuple24;
    }

    private final Seq collect$1(BufferedIterator tokens, Buffer acc, int nesting, Token openBracket$1) {
        while (true) {
            Token token = (Token)tokens.next();
            TokenType tokenType2 = token.tpe();
            TokenType$OpenBracket$ tokenType$OpenBracket$ = TokenType$OpenBracket$.MODULE$;
            if (!(tokenType2 != null ? !tokenType2.equals(tokenType$OpenBracket$) : tokenType$OpenBracket$ != null)) {
                ++nesting;
                acc = acc.$plus$eq(token);
                continue;
            }
            TokenType tokenType3 = token.tpe();
            TokenType$CloseBracket$ tokenType$CloseBracket$ = TokenType$CloseBracket$.MODULE$;
            if (!(tokenType3 != null ? !tokenType3.equals(tokenType$CloseBracket$) : tokenType$CloseBracket$ != null)) {
                if (nesting == 1) {
                    return acc.$plus$eq(token).toSeq();
                }
                --nesting;
                acc = acc.$plus$eq(token);
                continue;
            }
            TokenType tokenType4 = token.tpe();
            TokenType$Eof$ tokenType$Eof$ = TokenType$Eof$.MODULE$;
            if (!(tokenType4 == null ? tokenType$Eof$ != null : !tokenType4.equals(tokenType$Eof$))) break;
            acc = acc.$plus$eq(token);
        }
        throw Fail$.MODULE$.exception(this.MissingCloseBracket(), openBracket$1);
    }

    private final Tuple2 statementList$1(BufferedIterator i, SymbolTable scope, DelayedBlock block$1) {
        Seq<Statement> stmts = this.parseStatements(i, scope, TokenType$CloseBracket$.MODULE$, (Function2<BufferedIterator<Token>, SymbolTable, Tuple2<Statement, SymbolTable>>)(Function2<BufferedIterator, SymbolTable, Tuple2> & Serializable & scala.Serializable)(ts, s) -> {
            TokenType tokenType2 = ((Token)ts.head()).tpe();
            TokenType$Eof$ tokenType$Eof$ = TokenType$Eof$.MODULE$;
            Fail$.MODULE$.cAssert(tokenType2 == null ? tokenType$Eof$ != null : !tokenType2.equals(tokenType$Eof$), (Function0<String> & Serializable & scala.Serializable)() -> MODULE$.MissingCloseBracket(), block$1.openBracket());
            return MODULE$.parseStatement((BufferedIterator<Token>)ts, false, (SymbolTable)s);
        });
        return new Tuple2(stmts, i.next());
    }

    private final Tuple2 reporterApp$1(BufferedIterator i, int expressionGoal, SymbolTable scope, BufferedIterator tokens$2, DelayedBlock block$1) {
        Expression expr = this.resolveType(Syntax$.MODULE$.WildcardType(), this.parseExpression(tokens$2, false, expressionGoal, scope), null, scope);
        Token lastToken = (Token)tokens$2.next();
        TokenType tokenType2 = lastToken.tpe();
        TokenType$Eof$ tokenType$Eof$ = TokenType$Eof$.MODULE$;
        Fail$.MODULE$.cAssert(tokenType2 == null ? tokenType$Eof$ != null : !tokenType2.equals(tokenType$Eof$), (Function0<String> & Serializable & scala.Serializable)() -> MODULE$.MissingCloseBracket(), block$1.openBracket());
        TokenType tokenType3 = lastToken.tpe();
        TokenType$CloseBracket$ tokenType$CloseBracket$ = TokenType$CloseBracket$.MODULE$;
        Fail$.MODULE$.cAssert(!(tokenType3 != null ? !tokenType3.equals(tokenType$CloseBracket$) : tokenType$CloseBracket$ != null), (Function0<String> & Serializable & scala.Serializable)() -> MODULE$.ExpectedCloseBracket(), lastToken);
        return new Tuple2<ReporterApp, Token>((ReporterApp)expr, lastToken);
    }

    /*
     * WARNING - void declaration
     */
    private final ReporterApp buildReporterLambda$1(Lambda.Arguments args, BufferedIterator tokens$2, DelayedBlock block$1) {
        void var6_6;
        void var5_5;
        Tuple2 tuple2 = this.reporterApp$1(tokens$2, Syntax$.MODULE$.WildcardType(), block$1.internalScope(), tokens$2, block$1);
        if (tuple2 == null) {
            throw new MatchError((Object)null);
        }
        ReporterApp expr = (ReporterApp)tuple2._1();
        Token closeBracket = (Token)tuple2._2();
        void expr2 = var5_5;
        void closeBracket2 = var6_6;
        _reporterlambda lambda = new _reporterlambda(args);
        lambda.token_$eq(block$1.openBracket());
        return new ReporterApp(lambda, new $colon$colon<Nothing$>((Nothing$)expr2, Nil$.MODULE$), new SourceLocation(block$1.openBracket().start(), closeBracket2.end(), block$1.filename()));
    }

    /*
     * WARNING - void declaration
     */
    private final ReporterApp buildCommandLambda$1(Lambda.Arguments args, BufferedIterator tokens$2, DelayedBlock block$1) {
        void var6_6;
        void var5_5;
        Tuple2 tuple2 = this.statementList$1(tokens$2, block$1.internalScope(), block$1);
        if (tuple2 == null) {
            throw new MatchError((Object)null);
        }
        Seq stmtList = (Seq)tuple2._1();
        Token closeBracket = (Token)tuple2._2();
        void stmtList2 = var5_5;
        void closeBracket2 = var6_6;
        _commandlambda lambda = new _commandlambda(args);
        lambda.token_$eq(block$1.openBracket());
        CommandBlock blockArg = this.commandBlockWithStatements(new SourceLocation(block$1.openBracket().start(), closeBracket2.end(), block$1.filename()), (Seq<Statement>)stmtList2, this.commandBlockWithStatements$default$3());
        return new ReporterApp(lambda, new $colon$colon<Nothing$>((Nothing$)((Object)blockArg), Nil$.MODULE$), new SourceLocation(block$1.openBracket().start(), closeBracket2.end(), block$1.filename()));
    }

    private final void check$1(Seq remaining, Seq stack, DelayedBlock block$2) {
        while (true) {
            block22: {
                block24: {
                    block23: {
                        block19: {
                            block21: {
                                block20: {
                                    if (remaining.isEmpty()) {
                                        if (stack.isEmpty()) break;
                                        TokenType tokenType2 = ((Token)stack.head()).tpe();
                                        TokenType$OpenParen$ tokenType$OpenParen$ = TokenType$OpenParen$.MODULE$;
                                        if (tokenType2 == null) {
                                            if (tokenType$OpenParen$ != null) {
                                                return;
                                            }
                                        } else if (!tokenType2.equals(tokenType$OpenParen$)) break;
                                        throw Fail$.MODULE$.exception("Expected close paren here", (SourceLocatable)block$2.tokens().last());
                                    }
                                    TokenType tokenType3 = ((Token)remaining.head()).tpe();
                                    TokenType$OpenBracket$ tokenType$OpenBracket$ = TokenType$OpenBracket$.MODULE$;
                                    if (!(tokenType3 != null ? !tokenType3.equals(tokenType$OpenBracket$) : tokenType$OpenBracket$ != null)) {
                                        Token token = (Token)remaining.head();
                                        stack = stack.$plus$colon(token, scala.collection.Seq$.MODULE$.canBuildFrom());
                                        remaining = (Seq)remaining.tail();
                                        continue;
                                    }
                                    TokenType tokenType4 = ((Token)remaining.head()).tpe();
                                    TokenType$OpenParen$ tokenType$OpenParen$ = TokenType$OpenParen$.MODULE$;
                                    if (!(tokenType4 != null ? !tokenType4.equals(tokenType$OpenParen$) : tokenType$OpenParen$ != null)) {
                                        Token token = (Token)remaining.head();
                                        stack = stack.$plus$colon(token, scala.collection.Seq$.MODULE$.canBuildFrom());
                                        remaining = (Seq)remaining.tail();
                                        continue;
                                    }
                                    TokenType tokenType5 = ((Token)remaining.head()).tpe();
                                    TokenType$CloseBracket$ tokenType$CloseBracket$ = TokenType$CloseBracket$.MODULE$;
                                    if (tokenType5 != null ? !tokenType5.equals(tokenType$CloseBracket$) : tokenType$CloseBracket$ != null) break block19;
                                    if (!stack.isEmpty()) {
                                        TokenType tokenType6 = ((Token)stack.head()).tpe();
                                        TokenType$OpenParen$ tokenType$OpenParen$2 = TokenType$OpenParen$.MODULE$;
                                        if (!(tokenType6 != null ? !tokenType6.equals(tokenType$OpenParen$2) : tokenType$OpenParen$2 != null)) {
                                            throw Fail$.MODULE$.exception("Expected close paren before close bracket here", (SourceLocatable)remaining.head());
                                        }
                                    }
                                    if (stack.isEmpty()) break block20;
                                    TokenType tokenType7 = ((Token)stack.head()).tpe();
                                    TokenType$OpenBracket$ tokenType$OpenBracket$2 = TokenType$OpenBracket$.MODULE$;
                                    if (!(tokenType7 == null ? tokenType$OpenBracket$2 != null : !tokenType7.equals(tokenType$OpenBracket$2))) break block21;
                                }
                                throw Fail$.MODULE$.exception("Closing bracket has no matching open bracket here", (SourceLocatable)remaining.head());
                            }
                            stack = (Seq)stack.tail();
                            remaining = (Seq)remaining.tail();
                            continue;
                        }
                        TokenType tokenType8 = ((Token)remaining.head()).tpe();
                        TokenType$CloseParen$ tokenType$CloseParen$ = TokenType$CloseParen$.MODULE$;
                        if (tokenType8 != null ? !tokenType8.equals(tokenType$CloseParen$) : tokenType$CloseParen$ != null) break block22;
                        if (!stack.isEmpty()) {
                            TokenType tokenType9 = ((Token)stack.head()).tpe();
                            TokenType$OpenBracket$ tokenType$OpenBracket$ = TokenType$OpenBracket$.MODULE$;
                            if (!(tokenType9 != null ? !tokenType9.equals(tokenType$OpenBracket$) : tokenType$OpenBracket$ != null)) {
                                throw Fail$.MODULE$.exception("Expected close bracket before close paren here", (SourceLocatable)remaining.head());
                            }
                        }
                        if (stack.isEmpty()) break block23;
                        TokenType tokenType10 = ((Token)stack.head()).tpe();
                        TokenType$OpenParen$ tokenType$OpenParen$ = TokenType$OpenParen$.MODULE$;
                        if (!(tokenType10 == null ? tokenType$OpenParen$ != null : !tokenType10.equals(tokenType$OpenParen$))) break block24;
                    }
                    throw Fail$.MODULE$.exception("Closing paren has no matching open paren here", (SourceLocatable)remaining.head());
                }
                stack = (Seq)stack.tail();
                remaining = (Seq)remaining.tail();
                continue;
            }
            remaining = (Seq)remaining.tail();
        }
    }

    private static final Seq check$default$2$1() {
        return Nil$.MODULE$;
    }

    private ExpressionParser$() {
        MODULE$ = this;
        this.MinPrecedence = -1;
        this.bitmap$init$0 |= 1;
        this.ExpectedCommand = "Expected command.";
        this.bitmap$init$0 |= 2;
        this.ExpectedCloseBracket = "Expected closing bracket.";
        this.bitmap$init$0 |= 4;
        this.ExpectedCloseParen = "Expected a closing parenthesis here.";
        this.bitmap$init$0 |= 8;
        this.ExpectedReporter = "Expected reporter.";
        this.bitmap$init$0 |= 0x10;
        this.InvalidVariadicContext = "To use a non-default number of inputs, you need to put parentheses around this.";
        this.bitmap$init$0 |= 0x20;
        this.MissingCloseBracket = "No closing bracket for this open bracket.";
        this.bitmap$init$0 |= 0x40;
        this.MissingCloseParen = "No closing parenthesis for this open parenthesis.";
        this.bitmap$init$0 |= 0x80;
        this.MissingInputOnLeft = "Missing input on the left.";
        this.bitmap$init$0 |= 0x100;
    }
}

