/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.plot;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import org.nlogo.plot.Plot;
import org.nlogo.plot.PlotPen;
import org.nlogo.plot.PlotPen$;
import org.nlogo.plot.PlotPoint;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.UninitializedFieldError;
import scala.collection.AbstractTraversable;
import scala.collection.Seq;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1$mcVI$sp;

@ScalaSignature(bytes="\u0006\u0001\u0005]b\u0001B\r\u001b\u0001\u0005B\u0001b\u0007\u0001\u0003\u0002\u0003\u0006I\u0001\u000b\u0005\u0006Y\u0001!\t!\f\u0005\ba\u0001\u0001\r\u0011\"\u00032\u0011\u001dQ\u0004\u00011A\u0005\nmBa!\u0011\u0001!B\u0013\u0011\u0004b\u0002\"\u0001\u0001\u0004%Ia\u0011\u0005\b\u0015\u0002\u0001\r\u0011\"\u0003L\u0011\u0019i\u0005\u0001)Q\u0005\t\"9a\n\u0001a\u0001\n\u0013y\u0005bB*\u0001\u0001\u0004%I\u0001\u0016\u0005\u0007-\u0002\u0001\u000b\u0015\u0002)\t\u000f]\u0003\u0001\u0019!C\u0005\u001f\"9\u0001\f\u0001a\u0001\n\u0013I\u0006BB.\u0001A\u0003&\u0001\u000bC\u0003]\u0001\u0011\u0005Q\fC\u0003a\u0001\u0011\u0005\u0011\rC\u0003e\u0001\u0011\u0005Q\rC\u0003g\u0001\u0011%q\rC\u0003}\u0001\u0011%Q\u0010C\u0004\u0002\u0004\u0001!I!!\u0002\t\u000f\u00055\u0001\u0001\"\u0003\u0002\u0010!9\u00111\u0004\u0001\u0005\n\u0005u\u0001bBA\u0015\u0001\u0011%\u00111\u0006\u0005\b\u0003c\u0001A\u0011BA\u001a\u0005-\u0001Fn\u001c;QC&tG/\u001a:\u000b\u0005ma\u0012\u0001\u00029m_RT!!\b\u0010\u0002\u000b9dwnZ8\u000b\u0003}\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\u0012\u0011\u0005\r2S\"\u0001\u0013\u000b\u0003\u0015\nQa]2bY\u0006L!a\n\u0013\u0003\r\u0005s\u0017PU3g!\tI#&D\u0001\u001b\u0013\tY#D\u0001\u0003QY>$\u0018A\u0002\u001fj]&$h\b\u0006\u0002/_A\u0011\u0011\u0006\u0001\u0005\u00067\t\u0001\r\u0001K\u0001\u0005O>3g-F\u00013!\t\u0019\u0004(D\u00015\u0015\t)d'A\u0002boRT\u0011aN\u0001\u0005U\u00064\u0018-\u0003\u0002:i\tAqI]1qQ&\u001c7/\u0001\u0005h\u001f\u001a4w\fJ3r)\tat\b\u0005\u0002${%\u0011a\b\n\u0002\u0005+:LG\u000fC\u0004A\t\u0005\u0005\t\u0019\u0001\u001a\u0002\u0007a$\u0013'A\u0003h\u001f\u001a4\u0007%\u0001\bpM\u001a\u001c6M]3f]&k\u0017mZ3\u0016\u0003\u0011\u0003\"!\u0012%\u000e\u0003\u0019S!a\u0012\u001b\u0002\u000b%l\u0017mZ3\n\u0005%3%!\u0004\"vM\u001a,'/\u001a3J[\u0006<W-\u0001\npM\u001a\u001c6M]3f]&k\u0017mZ3`I\u0015\fHC\u0001\u001fM\u0011\u001d\u0001u!!AA\u0002\u0011\u000bqb\u001c4g'\u000e\u0014X-\u001a8J[\u0006<W\rI\u0001\u0007Q\u0016Lw\r\u001b;\u0016\u0003A\u0003\"aI)\n\u0005I##aA%oi\u0006Q\u0001.Z5hQR|F%Z9\u0015\u0005q*\u0006b\u0002!\u000b\u0003\u0003\u0005\r\u0001U\u0001\bQ\u0016Lw\r\u001b;!\u0003\u00159\u0018\u000e\u001a;i\u0003%9\u0018\u000e\u001a;i?\u0012*\u0017\u000f\u0006\u0002=5\"9\u0001)DA\u0001\u0002\u0004\u0001\u0016AB<jIRD\u0007%A\ntKR,\bo\u00144gg\u000e\u0014X-\u001a8J[\u0006<W\rF\u0002==~CQaV\bA\u0002ACQAT\bA\u0002A\u000b\u0011\u0002\u001a:bo&k\u0017mZ3\u0015\u0005q\u0012\u0007\"B2\u0011\u0001\u0004\u0011\u0014!A4\u0002\u000fI,gM]3tQR\tA(\u0001\rd_2dWm\u0019;Q_&tGo\u001d$peB\u000b\u0017N\u001c;j]\u001e$\"\u0001[<\u0011\u0007%\fHO\u0004\u0002k_:\u00111N\\\u0007\u0002Y*\u0011Q\u000eI\u0001\u0007yI|w\u000e\u001e \n\u0003\u0015J!\u0001\u001d\u0013\u0002\u000fA\f7m[1hK&\u0011!o\u001d\u0002\u0004'\u0016\f(B\u00019%!\tIS/\u0003\u0002w5\tI\u0001\u000b\\8u!>Lg\u000e\u001e\u0005\u0006qJ\u0001\r!_\u0001\u0004a\u0016t\u0007CA\u0015{\u0013\tY(DA\u0004QY>$\b+\u001a8\u0002\u0015I,gM]3tQB+g\u000eF\u0002=}~DQ\u0001_\nA\u0002eDa!!\u0001\u0014\u0001\u0004A\u0017\u0001\u00049pS:$8\u000fV8QY>$\u0018!\u00033sC^\u0004v.\u001b8u)\u0015a\u0014qAA\u0005\u0011\u0015\u0019G\u00031\u00013\u0011\u0019\tY\u0001\u0006a\u0001i\u0006\t\u0001/\u0001\u0005ee\u0006<X\tZ4f)\u001da\u0014\u0011CA\n\u0003/AQaY\u000bA\u0002IBa!!\u0006\u0016\u0001\u0004!\u0018A\u000192\u0011\u0019\tI\"\u0006a\u0001i\u0006\u0011\u0001OM\u0001\bg\u000e\u0014X-\u001a8Y)\r\u0001\u0016q\u0004\u0005\b\u0003C1\u0002\u0019AA\u0012\u0003\u0005A\bcA\u0012\u0002&%\u0019\u0011q\u0005\u0013\u0003\r\u0011{WO\u00197f\u0003\u001d\u00198M]3f]f#2\u0001UA\u0017\u0011\u001d\tyc\u0006a\u0001\u0003G\t\u0011!_\u0001\u0007g\u000e\u0014X-\u001a8\u0015\u0007A\u000b)\u0004C\u0004\u0002\fa\u0001\r!a\t")
public class PlotPainter {
    private final Plot plot;
    private Graphics gOff;
    private BufferedImage offScreenImage;
    private int height;
    private int width;
    private volatile byte bitmap$init$0;

    private Graphics gOff() {
        if ((byte)(this.bitmap$init$0 & 1) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /media/sf_NetLogo/netlogo-gui/src/main/plot/PlotPainter.scala: 9");
        }
        return this.gOff;
    }

    private void gOff_$eq(Graphics x$1) {
        this.gOff = x$1;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
    }

    private BufferedImage offScreenImage() {
        if ((byte)(this.bitmap$init$0 & 2) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /media/sf_NetLogo/netlogo-gui/src/main/plot/PlotPainter.scala: 10");
        }
        return this.offScreenImage;
    }

    private void offScreenImage_$eq(BufferedImage x$1) {
        this.offScreenImage = x$1;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
    }

    private int height() {
        if ((byte)(this.bitmap$init$0 & 4) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /media/sf_NetLogo/netlogo-gui/src/main/plot/PlotPainter.scala: 12");
        }
        return this.height;
    }

    private void height_$eq(int x$1) {
        this.height = x$1;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 4);
    }

    private int width() {
        if ((byte)(this.bitmap$init$0 & 8) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /media/sf_NetLogo/netlogo-gui/src/main/plot/PlotPainter.scala: 13");
        }
        return this.width;
    }

    private void width_$eq(int x$1) {
        this.width = x$1;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 8);
    }

    public void setupOffscreenImage(int width, int height) {
        if (this.offScreenImage() == null || this.width() != width || this.height() != height) {
            this.width_$eq(width);
            this.height_$eq(height);
            if (this.offScreenImage() != null) {
                this.offScreenImage().flush();
                this.offScreenImage_$eq(null);
            }
            this.offScreenImage_$eq(new BufferedImage(width, height, 2));
            if (this.gOff() != null) {
                this.gOff().dispose();
            }
            this.gOff_$eq(this.offScreenImage().getGraphics());
            this.gOff().setColor(new Color(this.plot.backgroundColor()));
            this.gOff().fillRect(0, 0, width, height);
            this.refresh();
        }
    }

    public void drawImage(Graphics g) {
        g.drawImage(this.offScreenImage(), 0, 0, null);
    }

    public void refresh() {
        this.gOff().setColor(new Color(this.plot.backgroundColor()));
        this.gOff().fillRect(0, 0, this.offScreenImage().getWidth(), this.offScreenImage().getHeight());
        ((AbstractTraversable)((Object)this.plot.pens())).withFilter((Function1<PlotPen, Object> & Serializable & scala.Serializable)pen -> BoxesRunTime.boxToBoolean(PlotPainter.$anonfun$refresh$1(pen))).foreach((Function1<PlotPen, Object> & Serializable & scala.Serializable)pen -> {
            PlotPainter.$anonfun$refresh$2(this, pen);
            return BoxedUnit.UNIT;
        });
    }

    private Seq<PlotPoint> collectPointsForPainting(PlotPen pen) {
        Seq seq;
        int n = pen.mode();
        boolean bl = PlotPen$.MODULE$.POINT_MODE() == n ? true : PlotPen$.MODULE$.LINE_MODE() == n;
        if (bl) {
            seq = pen.points();
        } else if (PlotPen$.MODULE$.BAR_MODE() == n) {
            seq = pen.points().flatMap((Function1<PlotPoint, Seq> & Serializable & scala.Serializable)old -> {
                double x$1 = 0.0;
                boolean x$2 = true;
                double x$3 = old.copy$default$1();
                int x$4 = old.copy$default$4();
                boolean x$5 = true;
                double x$6 = old.copy$default$1();
                double x$7 = old.copy$default$2();
                int x$8 = old.copy$default$4();
                double x$9 = old.x() + pen.interval();
                boolean x$10 = true;
                double x$11 = old.copy$default$2();
                int x$12 = old.copy$default$4();
                return new $colon$colon<Nothing$>((Nothing$)((Object)old.copy(x$3, x$1, x$2, x$4)), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)old.copy(x$6, x$7, x$5, x$8)), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)old.copy(x$9, x$11, x$10, x$12)), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)old.copy(old.x() + pen.interval(), 0.0, true, old.copy$default$4())), Nil$.MODULE$))));
            }, Buffer$.MODULE$.canBuildFrom());
        } else {
            throw new MatchError(BoxesRunTime.boxToInteger(n));
        }
        return seq;
    }

    private void refreshPen(PlotPen pen, Seq<PlotPoint> pointsToPlot) {
        ObjectRef<Object> last = ObjectRef.create(null);
        IntRef color = IntRef.create(0);
        int n = 0;
        IntRef minY = IntRef.create(0);
        IntRef maxY = IntRef.create(n);
        BooleanRef coalescing = BooleanRef.create(false);
        ((Graphics2D)this.gOff()).setRenderingHint(RenderingHints.KEY_ANTIALIASING, pen.mode() == PlotPen$.MODULE$.POINT_MODE() ? RenderingHints.VALUE_ANTIALIAS_OFF : RenderingHints.VALUE_ANTIALIAS_ON);
        int size = pointsToPlot.size();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), size).foreach$mVc$sp((JFunction1$mcVI$sp & scala.Serializable)i -> {
            PlotPoint next = (PlotPoint)pointsToPlot.apply(i);
            if (next.color() != color$1.elem) {
                color$1.elem = next.color();
                this.gOff().setColor(new Color(color$1.elem));
            }
            if (pen.mode() == PlotPen$.MODULE$.POINT_MODE()) {
                this.drawPoint(this.gOff(), next);
            } else if ((PlotPoint)last$1.elem == null) {
                this.drawEdge(this.gOff(), next, next);
            } else if (i != size - 1 && this.screenX(((PlotPoint)last$1.elem).x()) == this.screenX(next.x()) && ((PlotPoint)last$1.elem).color() == next.color() && ((PlotPoint)last$1.elem).isDown() && next.isDown()) {
                int y = this.screenY(next.y());
                if (coalescing$1.elem) {
                    if (y < minY$1.elem) {
                        minY$1.elem = y;
                    }
                    if (y > maxY$1.elem) {
                        maxY$1.elem = y;
                    }
                } else {
                    ((Graphics2D)this.gOff()).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                    this.drawEdge(this.gOff(), (PlotPoint)last$1.elem, next);
                    coalescing$1.elem = true;
                    minY$1.elem = y;
                    maxY$1.elem = y;
                }
            } else {
                if (coalescing$1.elem) {
                    this.gOff().setColor(new Color(((PlotPoint)last$1.elem).color()));
                    this.gOff().fillRect(this.screenX(((PlotPoint)last$1.elem).x()), minY$1.elem, 1, maxY$1.elem - minY$1.elem + 1);
                    coalescing$1.elem = false;
                    ((Graphics2D)this.gOff()).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    this.gOff().setColor(new Color(color$1.elem));
                }
                if (next.isDown()) {
                    this.drawEdge(this.gOff(), (PlotPoint)last$1.elem, next);
                }
            }
            last$1.elem = next;
        });
    }

    private void drawPoint(Graphics g, PlotPoint p) {
        g.drawRect(this.screenX(p.x()), this.screenY(p.y()), 1, 1);
    }

    private void drawEdge(Graphics g, PlotPoint p1, PlotPoint p2) {
        int x1 = this.screenX(p1.x());
        int y1 = this.screenY(p1.y());
        int x2 = this.screenX(p2.x());
        int y2 = this.screenY(p2.y());
        if (!(x1 < 0 && x2 < 0 || x1 > this.width() && x2 > this.width() || y1 < 0 && y2 < 0 || y1 > this.height() && y2 > this.height())) {
            g.drawLine(x1, y1, x2, y2);
        }
    }

    private int screenX(double x) {
        double scale = (this.plot.xMax() - this.plot.xMin()) / (double)(this.width() - 1);
        return this.screen(StrictMath.rint((x - this.plot.xMin()) / scale));
    }

    private int screenY(double y) {
        double scale = (this.plot.yMax() - this.plot.yMin()) / (double)(this.height() - 1);
        return this.screen(StrictMath.rint((double)(this.height() - 1) - (y - this.plot.yMin()) / scale));
    }

    private int screen(double p) {
        if (p > (double)16383) {
            return 16383;
        }
        if (p < (double)-16383) {
            return -16383;
        }
        return (int)p;
    }

    public static final /* synthetic */ boolean $anonfun$refresh$1(PlotPen pen) {
        return !pen.hidden();
    }

    public static final /* synthetic */ void $anonfun$refresh$2(PlotPainter $this, PlotPen pen) {
        pen.penModeChanged_$eq(false);
        $this.refreshPen(pen, $this.collectPointsForPainting(pen));
    }

    public PlotPainter(Plot plot) {
        this.plot = plot;
        this.gOff = null;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
        this.offScreenImage = null;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
        this.height = 0;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 4);
        this.width = 0;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 8);
    }
}

