/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.audio.samples;

import org.openimaj.audio.AudioFormat;
import org.openimaj.audio.SampleChunk;
import org.openimaj.audio.samples.SampleBuffer;
import org.openimaj.audio.samples.SampleBuffer16Bit;
import org.openimaj.audio.samples.SampleBuffer8Bit;

public abstract class SampleBufferFactory {
    public static SampleBuffer createSampleBuffer(AudioFormat af, int size) {
        switch (af.getNBits()) {
            case 8: {
                return new SampleBuffer8Bit(af, size);
            }
            case 16: {
                return new SampleBuffer16Bit(af, size);
            }
        }
        return null;
    }

    public static SampleBuffer createSampleBuffer(SampleChunk s, AudioFormat af) {
        switch (af.getNBits()) {
            case 8: {
                return new SampleBuffer8Bit(s, af);
            }
            case 16: {
                return new SampleBuffer16Bit(s, af);
            }
        }
        return null;
    }
}

