/*
 * Decompiled with CFR 0.152.
 */
package ch.akuhn.matrix.eigenvalues;

import ch.akuhn.matrix.Matrix;
import ch.akuhn.matrix.Vector;
import ch.akuhn.matrix.eigenvalues.Eigenvalues;
import java.util.Arrays;
import org.netlib.arpack.ARPACK;
import org.netlib.arpack.arpack_debug;
import org.netlib.util.doubleW;
import org.netlib.util.intW;

public abstract class FewEigenvalues
extends Eigenvalues {
    private Which which;

    public static FewEigenvalues of(final Matrix matrix) {
        assert (matrix.isSquare());
        return new FewEigenvalues(matrix.columnCount()){

            @Override
            protected Vector callback(Vector vector) {
                return matrix.mult(vector);
            }
        };
    }

    public FewEigenvalues(int n) {
        super(n);
        this.greatest(20);
    }

    private FewEigenvalues which(Which which, int nev) {
        this.which = which;
        this.nev = nev < this.n ? nev : this.n - 1;
        return this;
    }

    @Override
    public FewEigenvalues largest(int nev0) {
        return this.which(Which.LA, nev0);
    }

    public FewEigenvalues smallest(int nev0) {
        return this.which(Which.SA, nev0);
    }

    public FewEigenvalues greatest(int nev0) {
        return this.which(Which.LM, nev0);
    }

    public FewEigenvalues lowest(int nev0) {
        return this.which(Which.SM, nev0);
    }

    public FewEigenvalues fromBothEnds(int nev0) {
        return this.which(Which.BE, nev0);
    }

    @Override
    public Eigenvalues run() {
        ARPACK arpack = ARPACK.getInstance();
        intW ido = new intW(0);
        String bmat = "I";
        doubleW tol = new doubleW(0.0);
        intW info = new intW(0);
        double[] resid = new double[this.n];
        int ncv = Math.min(this.nev * 4, this.n);
        double[] v = new double[this.n * ncv];
        double[] workd = new double[3 * this.n];
        double[] workl = new double[ncv * (ncv + 8)];
        int[] iparam = new int[11];
        boolean ishfts = true;
        int maxitr = 300;
        boolean mode = true;
        iparam[0] = 1;
        iparam[2] = 300;
        iparam[6] = 1;
        int[] ipntr = new int[11];
        arpack_debug.ndigit.val = -3;
        arpack_debug.logfil.val = 6;
        arpack_debug.msgets.val = 0;
        arpack_debug.msaitr.val = 0;
        arpack_debug.msapps.val = 0;
        arpack_debug.msaupd.val = 0;
        arpack_debug.msaup2.val = 0;
        arpack_debug.mseigt.val = 0;
        arpack_debug.mseupd.val = 0;
        assert (this.n > 0);
        assert (this.nev > 0);
        assert (ncv > this.nev && ncv <= this.n);
        while (true) {
            arpack.dsaupd(ido, "I", this.n, this.which.name(), this.nev, tol, resid, ncv, v, this.n, iparam, ipntr, workd, workl, workl.length, info);
            if (ido.val != 1 && ido.val != -1) break;
            int x0 = ipntr[0] - 1;
            int y0 = ipntr[1] - 1;
            Vector x = Vector.copy(workd, x0, this.n);
            Vector y = this.callback(x);
            assert (y.size() == this.n);
            y.storeOn(workd, y0);
        }
        if (info.val != 0) {
            throw new Error("dsaupd ERRNO = " + info.val + ", see http://www.caam.rice.edu/software/ARPACK/UG/node136.html");
        }
        boolean rvec = true;
        boolean[] select = new boolean[ncv];
        double[] d = new double[ncv * 2];
        double sigma = 0.0;
        intW ierr = new intW(0);
        intW nevW = new intW(this.nev);
        arpack.dseupd(true, "All", select, d, v, this.n, 0.0, "I", this.n, this.which.name(), nevW, tol.val, resid, ncv, v, this.n, iparam, ipntr, workd, workl, workl.length, ierr);
        if (ierr.val < 0) {
            throw new Error("dseupd ERRNO = " + info.val + ", see http://www.caam.rice.edu/software/ARPACK/UG/node136.html");
        }
        int nconv = iparam[4];
        this.value = Arrays.copyOf(d, nconv);
        this.vector = new Vector[nconv];
        for (int i = 0; i < this.value.length; ++i) {
            this.vector[i] = Vector.copy(v, i * this.n, this.n);
        }
        return this;
    }

    protected abstract Vector callback(Vector var1);

    private static enum Which {
        LA,
        SA,
        LM,
        SM,
        BE;

    }
}

