/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.processor.connectedcomponent.render;

import org.openimaj.image.FImage;
import org.openimaj.image.Image;
import org.openimaj.image.MBFImage;
import org.openimaj.image.processor.connectedcomponent.ConnectedComponentProcessor;

public abstract class AbstractRenderer<T>
implements ConnectedComponentProcessor {
    protected Image<T, ?> image;
    protected T colour;

    public AbstractRenderer(Image<T, ?> image, T colour) {
        this.image = image;
        this.colour = colour;
    }

    public AbstractRenderer(int width, int height, T colour) {
        if (Float.class.isAssignableFrom(colour.getClass())) {
            this.image = new FImage(width, height);
        } else if (Float[].class.isAssignableFrom(colour.getClass())) {
            this.image = new MBFImage(width, height, ((Float[])colour).length);
        } else {
            throw new IllegalArgumentException("Unknown/unsupported type");
        }
        this.colour = colour;
    }

    public T getColour() {
        return this.colour;
    }

    public void setColour(T colour) {
        this.colour = colour;
    }

    public Image<T, ?> getImage() {
        return this.image;
    }
}

