/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.common.logging;

import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import org.jcodec.common.logging.Logger;
import org.jcodec.common.tools.MainUtils;

public class OutLogSink
implements Logger.LogSink {
    private PrintStream out;
    private MessageFormat fmt;
    public static SimpleFormat DEFAULT_FORMAT = new SimpleFormat(MainUtils.colorString("[#level]", "#color_code") + MainUtils.bold("\t#class.#method (#file:#line):") + "\t#message");

    public OutLogSink() {
        this(System.out, DEFAULT_FORMAT);
    }

    public OutLogSink(MessageFormat fmt) {
        this(System.out, fmt);
    }

    public OutLogSink(PrintStream out, MessageFormat fmt) {
        this.out = out;
        this.fmt = fmt;
    }

    @Override
    public void postMessage(Logger.Message msg) {
        this.out.println(this.fmt.formatMessage(msg));
    }

    public static class SimpleFormat
    implements MessageFormat {
        private String fmt;
        private static Map<Logger.Level, MainUtils.ANSIColor> colorMap = new HashMap<Logger.Level, MainUtils.ANSIColor>(){
            {
                this.put(Logger.Level.DEBUG, MainUtils.ANSIColor.BROWN);
                this.put(Logger.Level.INFO, MainUtils.ANSIColor.GREEN);
                this.put(Logger.Level.WARN, MainUtils.ANSIColor.MAGENTA);
                this.put(Logger.Level.ERROR, MainUtils.ANSIColor.RED);
            }
        };

        public SimpleFormat(String fmt) {
            this.fmt = fmt;
        }

        @Override
        public String formatMessage(Logger.Message msg) {
            return this.fmt.replace("#level", String.valueOf((Object)msg.getLevel())).replace("#color_code", String.valueOf(30 + colorMap.get((Object)msg.getLevel()).ordinal())).replace("#class", msg.getClassName()).replace("#method", msg.getMethodName()).replace("#file", msg.getFileName()).replace("#line", String.valueOf(msg.getLineNumber())).replace("#message", msg.getMessage());
        }
    }

    public static interface MessageFormat {
        public String formatMessage(Logger.Message var1);
    }
}

