/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.collections;

import com.sun.javafx.collections.ElementObserver;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.RandomAccess;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.ObservableListBase;
import javafx.collections.WeakListChangeListener;
import javafx.util.Callback;

public final class ElementObservableListDecorator<E>
extends ObservableListBase<E>
implements ObservableList<E> {
    private final ObservableList<E> decoratedList;
    private final ListChangeListener<E> listener;
    private ElementObserver<E> observer;

    public ElementObservableListDecorator(ObservableList<E> decorated, Callback<E, Observable[]> extractor) {
        this.observer = new ElementObserver<E>(extractor, new Callback<E, InvalidationListener>(){

            @Override
            public InvalidationListener call(final E e) {
                return new InvalidationListener(){

                    @Override
                    public void invalidated(Observable observable) {
                        int i;
                        ElementObservableListDecorator.this.beginChange();
                        if (ElementObservableListDecorator.this.decoratedList instanceof RandomAccess) {
                            int size = ElementObservableListDecorator.this.size();
                            for (i = 0; i < size; ++i) {
                                if (ElementObservableListDecorator.this.get(i) != e) continue;
                                ElementObservableListDecorator.this.nextUpdate(i);
                            }
                        } else {
                            Iterator it = ElementObservableListDecorator.this.iterator();
                            while (it.hasNext()) {
                                if (it.next() == e) {
                                    ElementObservableListDecorator.this.nextUpdate(i);
                                }
                                ++i;
                            }
                        }
                        ElementObservableListDecorator.this.endChange();
                    }
                };
            }
        }, this);
        this.decoratedList = decorated;
        int sz = this.decoratedList.size();
        for (int i = 0; i < sz; ++i) {
            this.observer.attachListener(this.decoratedList.get(i));
        }
        this.listener = new ListChangeListener<E>(){

            @Override
            public void onChanged(ListChangeListener.Change<? extends E> c) {
                while (c.next()) {
                    if (!c.wasAdded() && !c.wasRemoved()) continue;
                    int removedSize = c.getRemovedSize();
                    List removed = c.getRemoved();
                    for (int i = 0; i < removedSize; ++i) {
                        ElementObservableListDecorator.this.observer.detachListener(removed.get(i));
                    }
                    if (ElementObservableListDecorator.this.decoratedList instanceof RandomAccess) {
                        int to = c.getTo();
                        for (int i = c.getFrom(); i < to; ++i) {
                            ElementObservableListDecorator.this.observer.attachListener(ElementObservableListDecorator.this.decoratedList.get(i));
                        }
                        continue;
                    }
                    for (Object e : c.getAddedSubList()) {
                        ElementObservableListDecorator.this.observer.attachListener(e);
                    }
                }
                c.reset();
                ElementObservableListDecorator.this.fireChange(c);
            }
        };
        this.decoratedList.addListener(new WeakListChangeListener<E>(this.listener));
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.decoratedList.toArray(a);
    }

    @Override
    public Object[] toArray() {
        return this.decoratedList.toArray();
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        return this.decoratedList.subList(fromIndex, toIndex);
    }

    @Override
    public int size() {
        return this.decoratedList.size();
    }

    @Override
    public E set(int index, E element) {
        return this.decoratedList.set(index, element);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.decoratedList.retainAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.decoratedList.removeAll(c);
    }

    @Override
    public E remove(int index) {
        return this.decoratedList.remove(index);
    }

    @Override
    public boolean remove(Object o) {
        return this.decoratedList.remove(o);
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return this.decoratedList.listIterator(index);
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.decoratedList.listIterator();
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.decoratedList.lastIndexOf(o);
    }

    @Override
    public Iterator<E> iterator() {
        return this.decoratedList.iterator();
    }

    @Override
    public boolean isEmpty() {
        return this.decoratedList.isEmpty();
    }

    @Override
    public int indexOf(Object o) {
        return this.decoratedList.indexOf(o);
    }

    @Override
    public E get(int index) {
        return this.decoratedList.get(index);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.decoratedList.containsAll(c);
    }

    @Override
    public boolean contains(Object o) {
        return this.decoratedList.contains(o);
    }

    @Override
    public void clear() {
        this.decoratedList.clear();
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        return this.decoratedList.addAll(index, c);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        return this.decoratedList.addAll(c);
    }

    @Override
    public void add(int index, E element) {
        this.decoratedList.add(index, element);
    }

    @Override
    public boolean add(E e) {
        return this.decoratedList.add(e);
    }

    @Override
    public boolean setAll(Collection<? extends E> col) {
        return this.decoratedList.setAll(col);
    }

    @Override
    public boolean setAll(E ... elements) {
        return this.decoratedList.setAll(elements);
    }

    @Override
    public boolean retainAll(E ... elements) {
        return this.decoratedList.retainAll(elements);
    }

    @Override
    public boolean removeAll(E ... elements) {
        return this.decoratedList.removeAll(elements);
    }

    @Override
    public void remove(int from, int to) {
        this.decoratedList.remove(from, to);
    }

    @Override
    public boolean addAll(E ... elements) {
        return this.decoratedList.addAll(elements);
    }
}

