/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.behavior;

import com.sun.javafx.scene.control.behavior.CellBehaviorBase;
import java.util.Collections;
import javafx.scene.control.Control;
import javafx.scene.control.FocusModel;
import javafx.scene.control.IndexedCell;
import javafx.scene.control.MultipleSelectionModel;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableColumnBase;
import javafx.scene.control.TableFocusModel;
import javafx.scene.control.TablePositionBase;
import javafx.scene.control.TableSelectionModel;
import javafx.scene.input.MouseButton;

public abstract class TableCellBehaviorBase<S, T, TC extends TableColumnBase<S, ?>, C extends IndexedCell<T>>
extends CellBehaviorBase<C> {
    public TableCellBehaviorBase(C control) {
        super(control, Collections.emptyList());
    }

    protected abstract TableColumnBase<S, T> getTableColumn();

    protected abstract int getItemCount();

    @Override
    protected abstract TableSelectionModel<S> getSelectionModel();

    protected abstract TableFocusModel<S, TC> getFocusModel();

    protected abstract TablePositionBase getFocusedCell();

    protected abstract boolean isTableRowSelected();

    protected abstract int getVisibleLeafIndex(TableColumnBase<S, T> var1);

    protected abstract void focus(int var1, TableColumnBase<S, T> var2);

    @Override
    protected void doSelect(double x, double y, MouseButton button, int clickCount, boolean shiftDown, boolean shortcutDown) {
        IndexedCell tableCell = (IndexedCell)this.getControl();
        if (!tableCell.contains(x, y)) {
            return;
        }
        Control tableView = this.getCellContainer();
        if (tableView == null) {
            return;
        }
        int count = this.getItemCount();
        if (tableCell.getIndex() >= count) {
            return;
        }
        MultipleSelectionModel sm = this.getSelectionModel();
        if (sm == null) {
            return;
        }
        boolean selected = this.isSelected();
        int row = tableCell.getIndex();
        int column = this.getColumn();
        TableColumnBase<S, T> tableColumn = this.getTableColumn();
        FocusModel fm = this.getFocusModel();
        if (fm == null) {
            return;
        }
        TablePositionBase focusedCell = this.getFocusedCell();
        if (this.handleDisclosureNode(x, y)) {
            return;
        }
        if (shiftDown) {
            if (!TableCellBehaviorBase.hasNonDefaultAnchor(tableView)) {
                TableCellBehaviorBase.setAnchor(tableView, focusedCell, false);
            }
        } else {
            TableCellBehaviorBase.removeAnchor(tableView);
        }
        if (button == MouseButton.PRIMARY || button == MouseButton.SECONDARY && !selected) {
            if (sm.getSelectionMode() == SelectionMode.SINGLE) {
                this.simpleSelect(button, clickCount, shortcutDown);
            } else if (shortcutDown) {
                if (selected) {
                    ((TableSelectionModel)sm).clearSelection(row, tableColumn);
                    ((TableFocusModel)fm).focus(row, tableColumn);
                } else {
                    ((TableSelectionModel)sm).select(row, tableColumn);
                }
            } else if (shiftDown) {
                TableColumnBase<S, T> maxColumn;
                TablePositionBase anchor = TableCellBehaviorBase.getAnchor(tableView, focusedCell);
                int anchorRow = anchor.getRow();
                boolean asc = anchorRow < row;
                ((TableSelectionModel)sm).clearSelection();
                int minRow = Math.min(anchorRow, row);
                int maxRow = Math.max(anchorRow, row);
                TableColumnBase<S, T> minColumn = anchor.getColumn() < column ? anchor.getTableColumn() : tableColumn;
                TableColumnBase<S, T> tableColumnBase = maxColumn = anchor.getColumn() >= column ? anchor.getTableColumn() : tableColumn;
                if (asc) {
                    ((TableSelectionModel)sm).selectRange(minRow, minColumn, maxRow, maxColumn);
                } else {
                    ((TableSelectionModel)sm).selectRange(maxRow, minColumn, minRow, maxColumn);
                }
            } else {
                this.simpleSelect(button, clickCount, shortcutDown);
            }
        }
    }

    @Override
    protected void simpleSelect(MouseButton button, int clickCount, boolean shortcutDown) {
        TableColumnBase<S, T> column;
        int row;
        MultipleSelectionModel sm = this.getSelectionModel();
        boolean isAlreadySelected = ((TableSelectionModel)sm).isSelected(row = ((IndexedCell)this.getControl()).getIndex(), column = this.getTableColumn());
        if (isAlreadySelected && shortcutDown) {
            ((TableSelectionModel)sm).clearSelection(row, column);
            ((TableFocusModel)this.getFocusModel()).focus(row, column);
            isAlreadySelected = false;
        } else {
            ((TableSelectionModel)sm).clearAndSelect(row, column);
        }
        this.handleClicks(button, clickCount, isAlreadySelected);
    }

    private int getColumn() {
        if (((TableSelectionModel)this.getSelectionModel()).isCellSelectionEnabled()) {
            TableColumnBase<S, T> tc = this.getTableColumn();
            return this.getVisibleLeafIndex(tc);
        }
        return -1;
    }

    @Override
    protected boolean isSelected() {
        MultipleSelectionModel sm = this.getSelectionModel();
        if (sm == null) {
            return false;
        }
        if (((TableSelectionModel)sm).isCellSelectionEnabled()) {
            IndexedCell cell = (IndexedCell)this.getControl();
            return cell.isSelected();
        }
        return this.isTableRowSelected();
    }
}

