/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.scene.control.behavior.ListViewBehavior;
import com.sun.javafx.scene.control.skin.VirtualContainerBase;
import com.sun.javafx.scene.control.skin.resources.ControlResources;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Iterator;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.MapChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.collections.WeakListChangeListener;
import javafx.event.EventHandler;
import javafx.geometry.Orientation;
import javafx.scene.AccessibleAction;
import javafx.scene.AccessibleAttribute;
import javafx.scene.Node;
import javafx.scene.control.FocusModel;
import javafx.scene.control.IndexedCell;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.MultipleSelectionModel;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.StackPane;

public class ListViewSkin<T>
extends VirtualContainerBase<ListView<T>, ListViewBehavior<T>, ListCell<T>> {
    public static final String RECREATE = "listRecreateKey";
    private StackPane placeholderRegion;
    private Node placeholderNode;
    private static final String EMPTY_LIST_TEXT = ControlResources.getString("ListView.noContent");
    private static final boolean IS_PANNABLE = AccessController.doPrivileged(() -> Boolean.getBoolean("com.sun.javafx.scene.control.skin.ListViewSkin.pannable"));
    private ObservableList<T> listViewItems;
    private final InvalidationListener itemsChangeListener = observable -> this.updateListViewItems();
    private MapChangeListener<Object, Object> propertiesMapListener = c -> {
        if (!c.wasAdded()) {
            return;
        }
        if (RECREATE.equals(c.getKey())) {
            this.needCellsRebuilt = true;
            ((ListView)this.getSkinnable()).requestLayout();
            ((ListView)this.getSkinnable()).getProperties().remove(RECREATE);
        }
    };
    private final ListChangeListener<T> listViewItemsListener = new ListChangeListener<T>(){

        @Override
        public void onChanged(ListChangeListener.Change<? extends T> c) {
            while (c.next()) {
                if (c.wasReplaced()) {
                    for (int i = c.getFrom(); i < c.getTo(); ++i) {
                        ListViewSkin.this.flow.setCellDirty(i);
                    }
                    break;
                }
                if (c.getRemovedSize() != ListViewSkin.this.itemCount) continue;
                ListViewSkin.this.itemCount = 0;
                break;
            }
            ((ListView)ListViewSkin.this.getSkinnable()).edit(-1);
            ListViewSkin.this.rowCountDirty = true;
            ((ListView)ListViewSkin.this.getSkinnable()).requestLayout();
        }
    };
    private final WeakListChangeListener<T> weakListViewItemsListener = new WeakListChangeListener<T>(this.listViewItemsListener);
    private int itemCount = -1;
    private boolean needCellsRebuilt = true;
    private boolean needCellsReconfigured = false;

    public ListViewSkin(ListView<T> listView) {
        super(listView, new ListViewBehavior<T>(listView));
        this.updateListViewItems();
        this.flow.setId("virtual-flow");
        this.flow.setPannable(IS_PANNABLE);
        this.flow.setVertical(((ListView)this.getSkinnable()).getOrientation() == Orientation.VERTICAL);
        this.flow.setCreateCell(flow1 -> this.createCell());
        this.flow.setFixedCellSize(listView.getFixedCellSize());
        this.getChildren().add(this.flow);
        EventHandler<MouseEvent> ml = event -> {
            if (listView.getEditingIndex() > -1) {
                listView.edit(-1);
            }
            if (listView.isFocusTraversable()) {
                listView.requestFocus();
            }
        };
        this.flow.getVbar().addEventFilter(MouseEvent.MOUSE_PRESSED, ml);
        this.flow.getHbar().addEventFilter(MouseEvent.MOUSE_PRESSED, ml);
        this.updateRowCount();
        listView.itemsProperty().addListener(new WeakInvalidationListener(this.itemsChangeListener));
        ObservableMap<Object, Object> properties = listView.getProperties();
        properties.remove(RECREATE);
        properties.addListener(this.propertiesMapListener);
        ((ListViewBehavior)this.getBehavior()).setOnFocusPreviousRow(() -> this.onFocusPreviousCell());
        ((ListViewBehavior)this.getBehavior()).setOnFocusNextRow(() -> this.onFocusNextCell());
        ((ListViewBehavior)this.getBehavior()).setOnMoveToFirstCell(() -> this.onMoveToFirstCell());
        ((ListViewBehavior)this.getBehavior()).setOnMoveToLastCell(() -> this.onMoveToLastCell());
        ((ListViewBehavior)this.getBehavior()).setOnScrollPageDown(isFocusDriven -> this.onScrollPageDown((boolean)isFocusDriven));
        ((ListViewBehavior)this.getBehavior()).setOnScrollPageUp(isFocusDriven -> this.onScrollPageUp((boolean)isFocusDriven));
        ((ListViewBehavior)this.getBehavior()).setOnSelectPreviousRow(() -> this.onSelectPreviousCell());
        ((ListViewBehavior)this.getBehavior()).setOnSelectNextRow(() -> this.onSelectNextCell());
        this.registerChangeListener(listView.itemsProperty(), "ITEMS");
        this.registerChangeListener(listView.orientationProperty(), "ORIENTATION");
        this.registerChangeListener(listView.cellFactoryProperty(), "CELL_FACTORY");
        this.registerChangeListener(listView.parentProperty(), "PARENT");
        this.registerChangeListener(listView.placeholderProperty(), "PLACEHOLDER");
        this.registerChangeListener(listView.fixedCellSizeProperty(), "FIXED_CELL_SIZE");
    }

    @Override
    protected void handleControlPropertyChanged(String p) {
        super.handleControlPropertyChanged(p);
        if ("ITEMS".equals(p)) {
            this.updateListViewItems();
        } else if ("ORIENTATION".equals(p)) {
            this.flow.setVertical(((ListView)this.getSkinnable()).getOrientation() == Orientation.VERTICAL);
        } else if ("CELL_FACTORY".equals(p)) {
            this.flow.recreateCells();
        } else if ("PARENT".equals(p)) {
            if (((ListView)this.getSkinnable()).getParent() != null && ((ListView)this.getSkinnable()).isVisible()) {
                ((ListView)this.getSkinnable()).requestLayout();
            }
        } else if ("PLACEHOLDER".equals(p)) {
            this.updatePlaceholderRegionVisibility();
        } else if ("FIXED_CELL_SIZE".equals(p)) {
            this.flow.setFixedCellSize(((ListView)this.getSkinnable()).getFixedCellSize());
        }
    }

    public void updateListViewItems() {
        if (this.listViewItems != null) {
            this.listViewItems.removeListener(this.weakListViewItemsListener);
        }
        this.listViewItems = ((ListView)this.getSkinnable()).getItems();
        if (this.listViewItems != null) {
            this.listViewItems.addListener(this.weakListViewItemsListener);
        }
        this.rowCountDirty = true;
        ((ListView)this.getSkinnable()).requestLayout();
    }

    @Override
    public int getItemCount() {
        return this.itemCount;
    }

    @Override
    protected void updateRowCount() {
        int newCount;
        if (this.flow == null) {
            return;
        }
        int oldCount = this.itemCount;
        this.itemCount = newCount = this.listViewItems == null ? 0 : this.listViewItems.size();
        this.flow.setCellCount(newCount);
        this.updatePlaceholderRegionVisibility();
        if (newCount != oldCount) {
            this.needCellsRebuilt = true;
        } else {
            this.needCellsReconfigured = true;
        }
    }

    protected final void updatePlaceholderRegionVisibility() {
        boolean visible;
        boolean bl = visible = this.getItemCount() == 0;
        if (visible) {
            this.placeholderNode = ((ListView)this.getSkinnable()).getPlaceholder();
            if (this.placeholderNode == null && EMPTY_LIST_TEXT != null && !EMPTY_LIST_TEXT.isEmpty()) {
                this.placeholderNode = new Label();
                ((Label)this.placeholderNode).setText(EMPTY_LIST_TEXT);
            }
            if (this.placeholderNode != null) {
                if (this.placeholderRegion == null) {
                    this.placeholderRegion = new StackPane();
                    this.placeholderRegion.getStyleClass().setAll((String[])new String[]{"placeholder"});
                    this.getChildren().add(this.placeholderRegion);
                }
                this.placeholderRegion.getChildren().setAll((Node[])new Node[]{this.placeholderNode});
            }
        }
        this.flow.setVisible(!visible);
        if (this.placeholderRegion != null) {
            this.placeholderRegion.setVisible(visible);
        }
    }

    @Override
    public ListCell<T> createCell() {
        ListCell<T> cell = ((ListView)this.getSkinnable()).getCellFactory() != null ? ((ListView)this.getSkinnable()).getCellFactory().call(this.getSkinnable()) : ListViewSkin.createDefaultCellImpl();
        cell.updateListView((ListView)this.getSkinnable());
        return cell;
    }

    private static <T> ListCell<T> createDefaultCellImpl() {
        return new ListCell<T>(){

            @Override
            public void updateItem(T item, boolean empty) {
                super.updateItem(item, empty);
                if (empty) {
                    this.setText(null);
                    this.setGraphic(null);
                } else if (item instanceof Node) {
                    this.setText(null);
                    Node currentNode = this.getGraphic();
                    Node newNode = (Node)item;
                    if (currentNode == null || !currentNode.equals(newNode)) {
                        this.setGraphic(newNode);
                    }
                } else {
                    this.setText(item == null ? "null" : item.toString());
                    this.setGraphic(null);
                }
            }
        };
    }

    @Override
    protected void layoutChildren(double x, double y, double w, double h) {
        super.layoutChildren(x, y, w, h);
        if (this.needCellsRebuilt) {
            this.flow.rebuildCells();
        } else if (this.needCellsReconfigured) {
            this.flow.reconfigureCells();
        }
        this.needCellsRebuilt = false;
        this.needCellsReconfigured = false;
        if (this.getItemCount() == 0) {
            if (this.placeholderRegion != null) {
                this.placeholderRegion.setVisible(w > 0.0 && h > 0.0);
                this.placeholderRegion.resizeRelocate(x, y, w, h);
            }
        } else {
            this.flow.resizeRelocate(x, y, w, h);
        }
    }

    @Override
    protected double computePrefWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        this.checkState();
        if (this.getItemCount() == 0) {
            if (this.placeholderRegion == null) {
                this.updatePlaceholderRegionVisibility();
            }
            if (this.placeholderRegion != null) {
                return this.placeholderRegion.prefWidth(height) + leftInset + rightInset;
            }
        }
        return this.computePrefHeight(-1.0, topInset, rightInset, bottomInset, leftInset) * 0.618033987;
    }

    @Override
    protected double computePrefHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return 400.0;
    }

    private void onFocusPreviousCell() {
        FocusModel fm = ((ListView)this.getSkinnable()).getFocusModel();
        if (fm == null) {
            return;
        }
        this.flow.show(fm.getFocusedIndex());
    }

    private void onFocusNextCell() {
        FocusModel fm = ((ListView)this.getSkinnable()).getFocusModel();
        if (fm == null) {
            return;
        }
        this.flow.show(fm.getFocusedIndex());
    }

    private void onSelectPreviousCell() {
        MultipleSelectionModel sm = ((ListView)this.getSkinnable()).getSelectionModel();
        if (sm == null) {
            return;
        }
        int pos = sm.getSelectedIndex();
        this.flow.show(pos);
        Object cell = this.flow.getFirstVisibleCell();
        if (cell == null || pos < ((IndexedCell)cell).getIndex()) {
            this.flow.setPosition((double)pos / (double)this.getItemCount());
        }
    }

    private void onSelectNextCell() {
        MultipleSelectionModel sm = ((ListView)this.getSkinnable()).getSelectionModel();
        if (sm == null) {
            return;
        }
        int pos = sm.getSelectedIndex();
        this.flow.show(pos);
        ListCell cell = (ListCell)this.flow.getLastVisibleCell();
        if (cell == null || cell.getIndex() < pos) {
            this.flow.setPosition((double)pos / (double)this.getItemCount());
        }
    }

    private void onMoveToFirstCell() {
        this.flow.show(0);
        this.flow.setPosition(0.0);
    }

    private void onMoveToLastCell() {
        int endPos = this.getItemCount() - 1;
        this.flow.show(endPos);
        this.flow.setPosition(1.0);
    }

    private int onScrollPageDown(boolean isFocusDriven) {
        ListCell lastVisibleCell = (ListCell)this.flow.getLastVisibleCellWithinViewPort();
        if (lastVisibleCell == null) {
            return -1;
        }
        MultipleSelectionModel sm = ((ListView)this.getSkinnable()).getSelectionModel();
        FocusModel fm = ((ListView)this.getSkinnable()).getFocusModel();
        if (sm == null || fm == null) {
            return -1;
        }
        int lastVisibleCellIndex = lastVisibleCell.getIndex();
        boolean isSelected = false;
        if (isFocusDriven) {
            isSelected = lastVisibleCell.isFocused() || fm.isFocused(lastVisibleCellIndex);
        } else {
            boolean bl = isSelected = lastVisibleCell.isSelected() || sm.isSelected(lastVisibleCellIndex);
        }
        if (isSelected) {
            boolean isLeadIndex;
            boolean bl = isLeadIndex = isFocusDriven && fm.getFocusedIndex() == lastVisibleCellIndex || !isFocusDriven && sm.getSelectedIndex() == lastVisibleCellIndex;
            if (isLeadIndex) {
                this.flow.showAsFirst(lastVisibleCell);
                ListCell newLastVisibleCell = (ListCell)this.flow.getLastVisibleCellWithinViewPort();
                lastVisibleCell = newLastVisibleCell == null ? lastVisibleCell : newLastVisibleCell;
            }
        }
        int newSelectionIndex = lastVisibleCell.getIndex();
        this.flow.show(lastVisibleCell);
        return newSelectionIndex;
    }

    private int onScrollPageUp(boolean isFocusDriven) {
        ListCell firstVisibleCell = (ListCell)this.flow.getFirstVisibleCellWithinViewPort();
        if (firstVisibleCell == null) {
            return -1;
        }
        MultipleSelectionModel sm = ((ListView)this.getSkinnable()).getSelectionModel();
        FocusModel fm = ((ListView)this.getSkinnable()).getFocusModel();
        if (sm == null || fm == null) {
            return -1;
        }
        int firstVisibleCellIndex = firstVisibleCell.getIndex();
        boolean isSelected = false;
        if (isFocusDriven) {
            isSelected = firstVisibleCell.isFocused() || fm.isFocused(firstVisibleCellIndex);
        } else {
            boolean bl = isSelected = firstVisibleCell.isSelected() || sm.isSelected(firstVisibleCellIndex);
        }
        if (isSelected) {
            boolean isLeadIndex;
            boolean bl = isLeadIndex = isFocusDriven && fm.getFocusedIndex() == firstVisibleCellIndex || !isFocusDriven && sm.getSelectedIndex() == firstVisibleCellIndex;
            if (isLeadIndex) {
                this.flow.showAsLast(firstVisibleCell);
                ListCell newFirstVisibleCell = (ListCell)this.flow.getFirstVisibleCellWithinViewPort();
                firstVisibleCell = newFirstVisibleCell == null ? firstVisibleCell : newFirstVisibleCell;
            }
        }
        int newSelectionIndex = firstVisibleCell.getIndex();
        this.flow.show(firstVisibleCell);
        return newSelectionIndex;
    }

    @Override
    protected Object queryAccessibleAttribute(AccessibleAttribute attribute, Object ... parameters) {
        switch (attribute) {
            case FOCUS_ITEM: {
                FocusModel fm = ((ListView)this.getSkinnable()).getFocusModel();
                int focusedIndex = fm.getFocusedIndex();
                if (focusedIndex == -1) {
                    if (this.placeholderRegion != null && this.placeholderRegion.isVisible()) {
                        return this.placeholderRegion.getChildren().get(0);
                    }
                    if (this.getItemCount() > 0) {
                        focusedIndex = 0;
                    } else {
                        return null;
                    }
                }
                return this.flow.getPrivateCell(focusedIndex);
            }
            case ITEM_COUNT: {
                return this.getItemCount();
            }
            case ITEM_AT_INDEX: {
                Integer rowIndex = (Integer)parameters[0];
                if (rowIndex == null) {
                    return null;
                }
                if (0 <= rowIndex && rowIndex < this.getItemCount()) {
                    return this.flow.getPrivateCell(rowIndex);
                }
                return null;
            }
            case SELECTED_ITEMS: {
                MultipleSelectionModel sm = ((ListView)this.getSkinnable()).getSelectionModel();
                ObservableList<Integer> indices = sm.getSelectedIndices();
                ArrayList<ListCell> selection = new ArrayList<ListCell>(indices.size());
                Iterator iterator = indices.iterator();
                while (iterator.hasNext()) {
                    int i = (Integer)iterator.next();
                    ListCell row = (ListCell)this.flow.getPrivateCell(i);
                    if (row == null) continue;
                    selection.add(row);
                }
                return FXCollections.observableArrayList(selection);
            }
            case VERTICAL_SCROLLBAR: {
                return this.flow.getVbar();
            }
            case HORIZONTAL_SCROLLBAR: {
                return this.flow.getHbar();
            }
        }
        return super.queryAccessibleAttribute(attribute, parameters);
    }

    @Override
    protected void executeAccessibleAction(AccessibleAction action, Object ... parameters) {
        switch (action) {
            case SHOW_ITEM: {
                Node item = (Node)parameters[0];
                if (!(item instanceof ListCell)) break;
                ListCell cell = (ListCell)item;
                this.flow.show(cell.getIndex());
                break;
            }
            case SET_SELECTED_ITEMS: {
                MultipleSelectionModel sm;
                ObservableList items = (ObservableList)parameters[0];
                if (items == null || (sm = ((ListView)this.getSkinnable()).getSelectionModel()) == null) break;
                sm.clearSelection();
                for (Node item : items) {
                    if (!(item instanceof ListCell)) continue;
                    ListCell cell = (ListCell)item;
                    sm.select(cell.getIndex());
                }
                break;
            }
            default: {
                super.executeAccessibleAction(action, parameters);
            }
        }
    }
}

