/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.scene.control.behavior.TreeTableCellBehavior;
import com.sun.javafx.scene.control.skin.TableCellSkinBase;
import com.sun.javafx.scene.control.skin.TableRowSkinBase;
import com.sun.javafx.scene.control.skin.TreeTableRowSkin;
import java.util.Map;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeTableCell;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.control.TreeTableRow;
import javafx.scene.control.TreeTableView;

public class TreeTableCellSkin<S, T>
extends TableCellSkinBase<TreeTableCell<S, T>, TreeTableCellBehavior<S, T>> {
    private final TreeTableCell<S, T> treeTableCell;
    private final TreeTableColumn<S, T> tableColumn;

    public TreeTableCellSkin(TreeTableCell<S, T> treeTableCell) {
        super(treeTableCell, new TreeTableCellBehavior<S, T>(treeTableCell));
        this.treeTableCell = treeTableCell;
        this.tableColumn = treeTableCell.getTableColumn();
        super.init(treeTableCell);
    }

    @Override
    protected BooleanProperty columnVisibleProperty() {
        return this.tableColumn.visibleProperty();
    }

    @Override
    protected ReadOnlyDoubleProperty columnWidthProperty() {
        return this.tableColumn.widthProperty();
    }

    @Override
    protected double leftLabelPadding() {
        double leftPadding = super.leftLabelPadding();
        double height = this.getCellSize();
        TreeTableCell cell = (TreeTableCell)this.getSkinnable();
        TreeTableColumn tableColumn = cell.getTableColumn();
        if (tableColumn == null) {
            return leftPadding;
        }
        TreeTableView treeTable = cell.getTreeTableView();
        if (treeTable == null) {
            return leftPadding;
        }
        int columnIndex = treeTable.getVisibleLeafIndex(tableColumn);
        TreeTableColumn treeColumn = treeTable.getTreeColumn();
        if (treeColumn == null && columnIndex != 0 || treeColumn != null && !tableColumn.equals(treeColumn)) {
            return leftPadding;
        }
        TreeTableRow treeTableRow = cell.getTreeTableRow();
        if (treeTableRow == null) {
            return leftPadding;
        }
        TreeItem treeItem = treeTableRow.getTreeItem();
        if (treeItem == null) {
            return leftPadding;
        }
        int nodeLevel = treeTable.getTreeItemLevel(treeItem);
        if (!treeTable.isShowRoot()) {
            --nodeLevel;
        }
        double indentPerLevel = 10.0;
        if (treeTableRow.getSkin() instanceof TreeTableRowSkin) {
            indentPerLevel = ((TreeTableRowSkin)treeTableRow.getSkin()).getIndentationPerLevel();
        }
        leftPadding += (double)nodeLevel * indentPerLevel;
        Map<Control, Double> mdwp = TableRowSkinBase.maxDisclosureWidthMap;
        leftPadding += mdwp.containsKey(treeTable) ? mdwp.get(treeTable) : 0.0;
        Node graphic = treeItem.getGraphic();
        return leftPadding += graphic == null ? 0.0 : graphic.prefWidth(height);
    }

    @Override
    protected double computePrefWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        if (this.isDeferToParentForPrefWidth) {
            return super.computePrefWidth(height, topInset, rightInset, bottomInset, leftInset);
        }
        return this.columnWidthProperty().get();
    }
}

