/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webkit;

public final class SharedBuffer {
    private long nativePointer;

    SharedBuffer() {
        this.nativePointer = SharedBuffer.twkCreate();
    }

    private SharedBuffer(long nativePointer) {
        if (nativePointer == 0L) {
            throw new IllegalArgumentException("nativePointer is 0");
        }
        this.nativePointer = nativePointer;
    }

    private static SharedBuffer fwkCreate(long nativePointer) {
        return new SharedBuffer(nativePointer);
    }

    long size() {
        if (this.nativePointer == 0L) {
            throw new IllegalStateException("nativePointer is 0");
        }
        return SharedBuffer.twkSize(this.nativePointer);
    }

    int getSomeData(long position, byte[] buffer, int offset, int length) {
        if (this.nativePointer == 0L) {
            throw new IllegalStateException("nativePointer is 0");
        }
        if (position < 0L) {
            throw new IndexOutOfBoundsException("position is negative");
        }
        if (position > this.size()) {
            throw new IndexOutOfBoundsException("position is greater than size");
        }
        if (buffer == null) {
            throw new NullPointerException("buffer is null");
        }
        if (offset < 0) {
            throw new IndexOutOfBoundsException("offset is negative");
        }
        if (length < 0) {
            throw new IndexOutOfBoundsException("length is negative");
        }
        if (length > buffer.length - offset) {
            throw new IndexOutOfBoundsException("length is greater than buffer.length - offset");
        }
        return SharedBuffer.twkGetSomeData(this.nativePointer, position, buffer, offset, length);
    }

    void append(byte[] buffer, int offset, int length) {
        if (this.nativePointer == 0L) {
            throw new IllegalStateException("nativePointer is 0");
        }
        if (buffer == null) {
            throw new NullPointerException("buffer is null");
        }
        if (offset < 0) {
            throw new IndexOutOfBoundsException("offset is negative");
        }
        if (length < 0) {
            throw new IndexOutOfBoundsException("length is negative");
        }
        if (length > buffer.length - offset) {
            throw new IndexOutOfBoundsException("length is greater than buffer.length - offset");
        }
        SharedBuffer.twkAppend(this.nativePointer, buffer, offset, length);
    }

    void dispose() {
        if (this.nativePointer == 0L) {
            throw new IllegalStateException("nativePointer is 0");
        }
        SharedBuffer.twkDispose(this.nativePointer);
        this.nativePointer = 0L;
    }

    private static native long twkCreate();

    private static native long twkSize(long var0);

    private static native int twkGetSomeData(long var0, long var2, byte[] var4, int var5, int var6);

    private static native void twkAppend(long var0, byte[] var2, int var3, int var4);

    private static native void twkDispose(long var0);
}

