/*
 * Decompiled with CFR 0.152.
 */
package javafx.css;

import com.sun.javafx.css.converters.FontConverter;
import com.sun.javafx.css.converters.SizeConverter;
import com.sun.javafx.css.converters.StringConverter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.css.CssMetaData;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.css.StyleableProperty;
import javafx.scene.text.Font;
import javafx.scene.text.FontPosture;
import javafx.scene.text.FontWeight;

public abstract class FontCssMetaData<S extends Styleable>
extends CssMetaData<S, Font> {
    public FontCssMetaData(String property, Font initial) {
        super(property, FontConverter.getInstance(), initial, true, FontCssMetaData.createSubProperties(property, initial));
    }

    private static <S extends Styleable> List<CssMetaData<? extends Styleable, ?>> createSubProperties(String property, Font initial) {
        ArrayList<CssMetaData> subProperties = new ArrayList<CssMetaData>();
        Font defaultFont = initial != null ? initial : Font.getDefault();
        CssMetaData FAMILY = new CssMetaData<S, String>(property.concat("-family"), StringConverter.getInstance(), defaultFont.getFamily(), true){

            @Override
            public boolean isSettable(S styleable) {
                return false;
            }

            @Override
            public StyleableProperty<String> getStyleableProperty(S styleable) {
                return null;
            }
        };
        subProperties.add(FAMILY);
        CssMetaData SIZE = new CssMetaData<S, Number>(property.concat("-size"), SizeConverter.getInstance(), defaultFont.getSize(), true){

            @Override
            public boolean isSettable(S styleable) {
                return false;
            }

            @Override
            public StyleableProperty<Number> getStyleableProperty(S styleable) {
                return null;
            }
        };
        subProperties.add(SIZE);
        CssMetaData STYLE = new CssMetaData<S, FontPosture>(property.concat("-style"), (StyleConverter)FontConverter.FontStyleConverter.getInstance(), FontPosture.REGULAR, true){

            @Override
            public boolean isSettable(S styleable) {
                return false;
            }

            @Override
            public StyleableProperty<FontPosture> getStyleableProperty(S styleable) {
                return null;
            }
        };
        subProperties.add(STYLE);
        CssMetaData WEIGHT = new CssMetaData<S, FontWeight>(property.concat("-weight"), (StyleConverter)FontConverter.FontWeightConverter.getInstance(), FontWeight.NORMAL, true){

            @Override
            public boolean isSettable(S styleable) {
                return false;
            }

            @Override
            public StyleableProperty<FontWeight> getStyleableProperty(S styleable) {
                return null;
            }
        };
        subProperties.add(WEIGHT);
        return Collections.unmodifiableList(subProperties);
    }
}

