/*
 * Decompiled with CFR 0.152.
 */
package javafx.embed.swing;

import com.sun.javafx.application.PlatformImpl;
import java.awt.AlphaComposite;
import java.awt.EventQueue;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.SecondaryLoop;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.nio.IntBuffer;
import java.security.AccessController;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javafx.application.Platform;
import javafx.scene.image.PixelFormat;
import javafx.scene.image.PixelReader;
import javafx.scene.image.PixelWriter;
import javafx.scene.image.WritableImage;
import javafx.scene.image.WritablePixelFormat;
import javax.swing.SwingUtilities;
import sun.awt.AWTAccessor;
import sun.awt.FwDispatcher;
import sun.awt.image.IntegerComponentRaster;

public class SwingFXUtils {
    private static final Set<Object> eventLoopKeys = new HashSet<Object>();

    private SwingFXUtils() {
    }

    public static WritableImage toFXImage(BufferedImage bimg, WritableImage wimg) {
        int bw = bimg.getWidth();
        int bh = bimg.getHeight();
        switch (bimg.getType()) {
            case 2: 
            case 3: {
                break;
            }
            default: {
                BufferedImage converted = new BufferedImage(bw, bh, 3);
                Graphics2D g2d = converted.createGraphics();
                g2d.drawImage((Image)bimg, 0, 0, null);
                g2d.dispose();
                bimg = converted;
            }
        }
        if (wimg != null) {
            int iw = (int)wimg.getWidth();
            int ih = (int)wimg.getHeight();
            if (iw < bw || ih < bh) {
                wimg = null;
            } else if (bw < iw || bh < ih) {
                int[] empty = new int[iw];
                PixelWriter pw = wimg.getPixelWriter();
                WritablePixelFormat<IntBuffer> pf = PixelFormat.getIntArgbPreInstance();
                if (bw < iw) {
                    pw.setPixels(bw, 0, iw - bw, bh, pf, empty, 0, 0);
                }
                if (bh < ih) {
                    pw.setPixels(0, bh, iw, ih - bh, pf, empty, 0, 0);
                }
            }
        }
        if (wimg == null) {
            wimg = new WritableImage(bw, bh);
        }
        PixelWriter pw = wimg.getPixelWriter();
        IntegerComponentRaster icr = (IntegerComponentRaster)bimg.getRaster();
        int[] data = icr.getDataStorage();
        int offset = icr.getDataOffset(0);
        int scan = icr.getScanlineStride();
        WritablePixelFormat<IntBuffer> pf = bimg.isAlphaPremultiplied() ? PixelFormat.getIntArgbPreInstance() : PixelFormat.getIntArgbInstance();
        pw.setPixels(0, 0, bw, bh, pf, data, offset, scan);
        return wimg;
    }

    private static int getBestBufferedImageType(PixelFormat<?> fxFormat, BufferedImage bimg) {
        int bimgType;
        if (bimg != null && ((bimgType = bimg.getType()) == 2 || bimgType == 3)) {
            return bimgType;
        }
        switch (fxFormat.getType()) {
            default: {
                return 3;
            }
            case BYTE_BGRA: 
            case INT_ARGB: {
                return 2;
            }
            case BYTE_RGB: {
                return 1;
            }
            case BYTE_INDEXED: 
        }
        return fxFormat.isPremultiplied() ? 3 : 2;
    }

    private static WritablePixelFormat<IntBuffer> getAssociatedPixelFormat(BufferedImage bimg) {
        switch (bimg.getType()) {
            case 1: 
            case 3: {
                return PixelFormat.getIntArgbPreInstance();
            }
            case 2: {
                return PixelFormat.getIntArgbInstance();
            }
        }
        throw new InternalError("Failed to validate BufferedImage type");
    }

    public static BufferedImage fromFXImage(javafx.scene.image.Image img, BufferedImage bimg) {
        PixelReader pr = img.getPixelReader();
        if (pr == null) {
            return null;
        }
        int iw = (int)img.getWidth();
        int ih = (int)img.getHeight();
        int prefBimgType = SwingFXUtils.getBestBufferedImageType(pr.getPixelFormat(), bimg);
        if (bimg != null) {
            int bw = bimg.getWidth();
            int bh = bimg.getHeight();
            if (bw < iw || bh < ih || bimg.getType() != prefBimgType) {
                bimg = null;
            } else if (iw < bw || ih < bh) {
                Graphics2D g2d = bimg.createGraphics();
                g2d.setComposite(AlphaComposite.Clear);
                g2d.fillRect(0, 0, bw, bh);
                g2d.dispose();
            }
        }
        if (bimg == null) {
            bimg = new BufferedImage(iw, ih, prefBimgType);
        }
        IntegerComponentRaster icr = (IntegerComponentRaster)bimg.getRaster();
        int offset = icr.getDataOffset(0);
        int scan = icr.getScanlineStride();
        int[] data = icr.getDataStorage();
        WritablePixelFormat<IntBuffer> pf = SwingFXUtils.getAssociatedPixelFormat(bimg);
        pr.getPixels(0, 0, iw, ih, pf, data, offset, scan);
        return bimg;
    }

    static void runOnFxThread(Runnable runnable) {
        if (Platform.isFxApplicationThread()) {
            runnable.run();
        } else {
            Platform.runLater(runnable);
        }
    }

    static void runOnEDT(Runnable r) {
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            SwingUtilities.invokeLater(r);
        }
    }

    static void runOnEDTAndWait(Object nestedLoopKey, Runnable r) {
        com.sun.javafx.tk.Toolkit.getToolkit().checkFxUserThread();
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            eventLoopKeys.add(nestedLoopKey);
            SwingUtilities.invokeLater(r);
            com.sun.javafx.tk.Toolkit.getToolkit().enterNestedEventLoop(nestedLoopKey);
        }
    }

    static void leaveFXNestedLoop(Object nestedLoopKey) {
        if (!eventLoopKeys.contains(nestedLoopKey)) {
            return;
        }
        if (Platform.isFxApplicationThread()) {
            com.sun.javafx.tk.Toolkit.getToolkit().exitNestedEventLoop(nestedLoopKey, null);
        } else {
            Platform.runLater(() -> com.sun.javafx.tk.Toolkit.getToolkit().exitNestedEventLoop(nestedLoopKey, null));
        }
        eventLoopKeys.remove(nestedLoopKey);
    }

    private static EventQueue getEventQueue() {
        return AccessController.doPrivileged(() -> Toolkit.getDefaultToolkit().getSystemEventQueue());
    }

    private static void installFwEventQueue() {
        AWTAccessor.getEventQueueAccessor().setFwDispatcher(SwingFXUtils.getEventQueue(), new FXDispatcher());
    }

    private static void removeFwEventQueue() {
        AWTAccessor.getEventQueueAccessor().setFwDispatcher(SwingFXUtils.getEventQueue(), null);
    }

    private static class FXDispatcher
    implements FwDispatcher {
        private FXDispatcher() {
        }

        @Override
        public boolean isDispatchThread() {
            return Platform.isFxApplicationThread();
        }

        @Override
        public void scheduleDispatch(Runnable runnable) {
            Platform.runLater(runnable);
        }

        @Override
        public SecondaryLoop createSecondaryLoop() {
            return new FwSecondaryLoop();
        }
    }

    private static class FwSecondaryLoop
    implements SecondaryLoop {
        private final AtomicBoolean isRunning = new AtomicBoolean(false);

        private FwSecondaryLoop() {
        }

        @Override
        public boolean enter() {
            if (this.isRunning.compareAndSet(false, true)) {
                PlatformImpl.runAndWait(() -> com.sun.javafx.tk.Toolkit.getToolkit().enterNestedEventLoop(this));
                return true;
            }
            return false;
        }

        @Override
        public boolean exit() {
            if (this.isRunning.compareAndSet(true, false)) {
                PlatformImpl.runAndWait(() -> com.sun.javafx.tk.Toolkit.getToolkit().exitNestedEventLoop(this, null));
                return true;
            }
            return false;
        }
    }
}

