/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.input;

import javafx.beans.NamedArg;
import javafx.event.EventTarget;
import javafx.event.EventType;
import javafx.scene.input.GestureEvent;
import javafx.scene.input.PickResult;

public final class RotateEvent
extends GestureEvent {
    private static final long serialVersionUID = 20121107L;
    public static final EventType<RotateEvent> ANY = new EventType<GestureEvent>(GestureEvent.ANY, "ANY_ROTATE");
    public static final EventType<RotateEvent> ROTATE = new EventType<RotateEvent>(ANY, "ROTATE");
    public static final EventType<RotateEvent> ROTATION_STARTED = new EventType<RotateEvent>(ANY, "ROTATION_STARTED");
    public static final EventType<RotateEvent> ROTATION_FINISHED = new EventType<RotateEvent>(ANY, "ROTATION_FINISHED");
    private final double angle;
    private final double totalAngle;

    public RotateEvent(@NamedArg(value="source") Object source, @NamedArg(value="target") EventTarget target, @NamedArg(value="eventType") EventType<RotateEvent> eventType, @NamedArg(value="x") double x, @NamedArg(value="y") double y, @NamedArg(value="screenX") double screenX, @NamedArg(value="screenY") double screenY, @NamedArg(value="shiftDown") boolean shiftDown, @NamedArg(value="controlDown") boolean controlDown, @NamedArg(value="altDown") boolean altDown, @NamedArg(value="metaDown") boolean metaDown, @NamedArg(value="direct") boolean direct, @NamedArg(value="inertia") boolean inertia, @NamedArg(value="angle") double angle, @NamedArg(value="totalAngle") double totalAngle, @NamedArg(value="pickResult") PickResult pickResult) {
        super(source, target, eventType, x, y, screenX, screenY, shiftDown, controlDown, altDown, metaDown, direct, inertia, pickResult);
        this.angle = angle;
        this.totalAngle = totalAngle;
    }

    public RotateEvent(@NamedArg(value="eventType") EventType<RotateEvent> eventType, @NamedArg(value="x") double x, @NamedArg(value="y") double y, @NamedArg(value="screenX") double screenX, @NamedArg(value="screenY") double screenY, @NamedArg(value="shiftDown") boolean shiftDown, @NamedArg(value="controlDown") boolean controlDown, @NamedArg(value="altDown") boolean altDown, @NamedArg(value="metaDown") boolean metaDown, @NamedArg(value="direct") boolean direct, @NamedArg(value="inertia") boolean inertia, @NamedArg(value="angle") double angle, @NamedArg(value="totalAngle") double totalAngle, @NamedArg(value="pickResult") PickResult pickResult) {
        this(null, null, eventType, x, y, screenX, screenY, shiftDown, controlDown, altDown, metaDown, direct, inertia, angle, totalAngle, pickResult);
    }

    public double getAngle() {
        return this.angle;
    }

    public double getTotalAngle() {
        return this.totalAngle;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("RotateEvent [");
        sb.append("source = ").append(this.getSource());
        sb.append(", target = ").append(this.getTarget());
        sb.append(", eventType = ").append(this.getEventType());
        sb.append(", consumed = ").append(this.isConsumed());
        sb.append(", angle = ").append(this.getAngle());
        sb.append(", totalAngle = ").append(this.getTotalAngle());
        sb.append(", x = ").append(this.getX()).append(", y = ").append(this.getY()).append(", z = ").append(this.getZ());
        sb.append(this.isDirect() ? ", direct" : ", indirect");
        if (this.isInertia()) {
            sb.append(", inertia");
        }
        if (this.isShiftDown()) {
            sb.append(", shiftDown");
        }
        if (this.isControlDown()) {
            sb.append(", controlDown");
        }
        if (this.isAltDown()) {
            sb.append(", altDown");
        }
        if (this.isMetaDown()) {
            sb.append(", metaDown");
        }
        if (this.isShortcutDown()) {
            sb.append(", shortcutDown");
        }
        sb.append(", pickResult = ").append(this.getPickResult());
        return sb.append("]").toString();
    }

    @Override
    public RotateEvent copyFor(Object newSource, EventTarget newTarget) {
        return (RotateEvent)super.copyFor(newSource, newTarget);
    }

    public RotateEvent copyFor(Object newSource, EventTarget newTarget, EventType<RotateEvent> type) {
        RotateEvent e = this.copyFor(newSource, newTarget);
        e.eventType = type;
        return e;
    }

    public EventType<RotateEvent> getEventType() {
        return super.getEventType();
    }
}

