/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.layout;

import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.geometry.VPos;
import javafx.scene.layout.ConstraintsBase;
import javafx.scene.layout.Priority;

public class RowConstraints
extends ConstraintsBase {
    private DoubleProperty minHeight;
    private DoubleProperty prefHeight;
    private DoubleProperty maxHeight;
    private DoubleProperty percentHeight;
    private ObjectProperty<Priority> vgrow;
    private ObjectProperty<VPos> valignment;
    private BooleanProperty fillHeight;

    public RowConstraints() {
    }

    public RowConstraints(double height) {
        this();
        this.setMinHeight(Double.NEGATIVE_INFINITY);
        this.setPrefHeight(height);
        this.setMaxHeight(Double.NEGATIVE_INFINITY);
    }

    public RowConstraints(double minHeight, double prefHeight, double maxHeight) {
        this();
        this.setMinHeight(minHeight);
        this.setPrefHeight(prefHeight);
        this.setMaxHeight(maxHeight);
    }

    public RowConstraints(double minHeight, double prefHeight, double maxHeight, Priority vgrow, VPos valignment, boolean fillHeight) {
        this(minHeight, prefHeight, maxHeight);
        this.setVgrow(vgrow);
        this.setValignment(valignment);
        this.setFillHeight(fillHeight);
    }

    public final void setMinHeight(double value) {
        this.minHeightProperty().set(value);
    }

    public final double getMinHeight() {
        return this.minHeight == null ? -1.0 : this.minHeight.get();
    }

    public final DoubleProperty minHeightProperty() {
        if (this.minHeight == null) {
            this.minHeight = new DoublePropertyBase(-1.0){

                @Override
                protected void invalidated() {
                    RowConstraints.this.requestLayout();
                }

                @Override
                public Object getBean() {
                    return RowConstraints.this;
                }

                @Override
                public String getName() {
                    return "minHeight";
                }
            };
        }
        return this.minHeight;
    }

    public final void setPrefHeight(double value) {
        this.prefHeightProperty().set(value);
    }

    public final double getPrefHeight() {
        return this.prefHeight == null ? -1.0 : this.prefHeight.get();
    }

    public final DoubleProperty prefHeightProperty() {
        if (this.prefHeight == null) {
            this.prefHeight = new DoublePropertyBase(-1.0){

                @Override
                protected void invalidated() {
                    RowConstraints.this.requestLayout();
                }

                @Override
                public Object getBean() {
                    return RowConstraints.this;
                }

                @Override
                public String getName() {
                    return "prefHeight";
                }
            };
        }
        return this.prefHeight;
    }

    public final void setMaxHeight(double value) {
        this.maxHeightProperty().set(value);
    }

    public final double getMaxHeight() {
        return this.maxHeight == null ? -1.0 : this.maxHeight.get();
    }

    public final DoubleProperty maxHeightProperty() {
        if (this.maxHeight == null) {
            this.maxHeight = new DoublePropertyBase(-1.0){

                @Override
                protected void invalidated() {
                    RowConstraints.this.requestLayout();
                }

                @Override
                public Object getBean() {
                    return RowConstraints.this;
                }

                @Override
                public String getName() {
                    return "maxHeight";
                }
            };
        }
        return this.maxHeight;
    }

    public final void setPercentHeight(double value) {
        this.percentHeightProperty().set(value);
    }

    public final double getPercentHeight() {
        return this.percentHeight == null ? -1.0 : this.percentHeight.get();
    }

    public final DoubleProperty percentHeightProperty() {
        if (this.percentHeight == null) {
            this.percentHeight = new DoublePropertyBase(-1.0){

                @Override
                protected void invalidated() {
                    RowConstraints.this.requestLayout();
                }

                @Override
                public Object getBean() {
                    return RowConstraints.this;
                }

                @Override
                public String getName() {
                    return "percentHeight";
                }
            };
        }
        return this.percentHeight;
    }

    public final void setVgrow(Priority value) {
        this.vgrowProperty().set(value);
    }

    public final Priority getVgrow() {
        return this.vgrow == null ? null : (Priority)((Object)this.vgrow.get());
    }

    public final ObjectProperty<Priority> vgrowProperty() {
        if (this.vgrow == null) {
            this.vgrow = new ObjectPropertyBase<Priority>(){

                @Override
                protected void invalidated() {
                    RowConstraints.this.requestLayout();
                }

                @Override
                public Object getBean() {
                    return RowConstraints.this;
                }

                @Override
                public String getName() {
                    return "vgrow";
                }
            };
        }
        return this.vgrow;
    }

    public final void setValignment(VPos value) {
        this.valignmentProperty().set(value);
    }

    public final VPos getValignment() {
        return this.valignment == null ? null : (VPos)((Object)this.valignment.get());
    }

    public final ObjectProperty<VPos> valignmentProperty() {
        if (this.valignment == null) {
            this.valignment = new ObjectPropertyBase<VPos>(){

                @Override
                protected void invalidated() {
                    RowConstraints.this.requestLayout();
                }

                @Override
                public Object getBean() {
                    return RowConstraints.this;
                }

                @Override
                public String getName() {
                    return "valignment";
                }
            };
        }
        return this.valignment;
    }

    public final void setFillHeight(boolean value) {
        this.fillHeightProperty().set(value);
    }

    public final boolean isFillHeight() {
        return this.fillHeight == null ? true : this.fillHeight.get();
    }

    public final BooleanProperty fillHeightProperty() {
        if (this.fillHeight == null) {
            this.fillHeight = new BooleanPropertyBase(true){

                @Override
                protected void invalidated() {
                    RowConstraints.this.requestLayout();
                }

                @Override
                public Object getBean() {
                    return RowConstraints.this;
                }

                @Override
                public String getName() {
                    return "fillHeight";
                }
            };
        }
        return this.fillHeight;
    }

    public String toString() {
        return "RowConstraints percentHeight=" + this.getPercentHeight() + " minHeight=" + this.getMinHeight() + " prefHeight=" + this.getPrefHeight() + " maxHeight=" + this.getMaxHeight() + " vgrow=" + (Object)((Object)this.getVgrow()) + " fillHeight=" + this.isFillHeight() + " valignment=" + (Object)((Object)this.getValignment());
    }
}

