/*
 * Decompiled with CFR 0.152.
 */
package javafx.util.converter;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import javafx.util.StringConverter;

public class DateTimeStringConverter
extends StringConverter<Date> {
    protected final Locale locale;
    protected final String pattern;
    protected final DateFormat dateFormat;
    protected final int dateStyle;
    protected final int timeStyle;

    public DateTimeStringConverter() {
        this(null, null, null, 2, 2);
    }

    public DateTimeStringConverter(int dateStyle, int timeStyle) {
        this(null, null, null, dateStyle, timeStyle);
    }

    public DateTimeStringConverter(Locale locale) {
        this(locale, null, null, 2, 2);
    }

    public DateTimeStringConverter(Locale locale, int dateStyle, int timeStyle) {
        this(locale, null, null, dateStyle, timeStyle);
    }

    public DateTimeStringConverter(String pattern) {
        this(null, pattern, null, 2, 2);
    }

    public DateTimeStringConverter(Locale locale, String pattern) {
        this(locale, pattern, null, 2, 2);
    }

    public DateTimeStringConverter(DateFormat dateFormat) {
        this(null, null, dateFormat, 2, 2);
    }

    DateTimeStringConverter(Locale locale, String pattern, DateFormat dateFormat, int dateStyle, int timeStyle) {
        this.locale = locale != null ? locale : Locale.getDefault(Locale.Category.FORMAT);
        this.pattern = pattern;
        this.dateFormat = dateFormat;
        this.dateStyle = dateStyle;
        this.timeStyle = timeStyle;
    }

    @Override
    public Date fromString(String value) {
        try {
            if (value == null) {
                return null;
            }
            if ((value = value.trim()).length() < 1) {
                return null;
            }
            DateFormat parser = this.getDateFormat();
            return parser.parse(value);
        }
        catch (ParseException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public String toString(Date value) {
        if (value == null) {
            return "";
        }
        DateFormat formatter = this.getDateFormat();
        return formatter.format(value);
    }

    protected DateFormat getDateFormat() {
        DateFormat df = null;
        if (this.dateFormat != null) {
            return this.dateFormat;
        }
        df = this.pattern != null ? new SimpleDateFormat(this.pattern, this.locale) : DateFormat.getDateTimeInstance(this.dateStyle, this.timeStyle, this.locale);
        df.setLenient(false);
        return df;
    }
}

