/*
 * Decompiled with CFR 0.152.
 */
package org.la4j.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Locale;
import java.util.StringTokenizer;
import org.la4j.factory.Factory;
import org.la4j.io.AbstractStream;
import org.la4j.io.MatrixStream;
import org.la4j.io.VectorStream;
import org.la4j.matrix.Matrices;
import org.la4j.matrix.Matrix;
import org.la4j.vector.Vector;
import org.la4j.vector.Vectors;

public class SymbolSeparatedStream
extends AbstractStream
implements MatrixStream,
VectorStream {
    private String separator;

    public SymbolSeparatedStream(InputStream in) {
        this(in, ", ");
    }

    public SymbolSeparatedStream(InputStream in, String separator) {
        super(in);
        this.separator = separator;
    }

    public SymbolSeparatedStream(OutputStream out) {
        this(out, ", ");
    }

    public SymbolSeparatedStream(OutputStream out, String separator) {
        super(out);
        this.separator = separator;
    }

    @Override
    public Vector readVector() throws IOException {
        return this.readVector(Vectors.DEFAULT_FACTORY);
    }

    @Override
    public Vector readVector(Factory factory) throws IOException {
        this.ensureReaderInitialized();
        Vector vector = factory.createVector(10);
        StringTokenizer tokenizer = new StringTokenizer(this.reader.readLine(), this.separator);
        int length = 0;
        while (tokenizer.hasMoreTokens()) {
            if (length == vector.length()) {
                vector = vector.resize(vector.length() * 3 / 2 + 1);
            }
            vector.set(length++, Double.valueOf(tokenizer.nextToken()));
        }
        vector = vector.resize(length);
        this.closeReader();
        return vector;
    }

    @Override
    public void writeVector(Vector vector) throws IOException {
        this.ensureWriterInitialized();
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < vector.length(); ++i) {
            double value = vector.get(i);
            builder.append(String.format(Locale.US, "%.12f", value));
            if (i + 1 >= vector.length()) continue;
            builder.append(this.separator);
        }
        this.writer.write(builder.toString());
        this.writer.newLine();
        this.closeWriter();
    }

    @Override
    public Matrix readMatrix() throws IOException {
        return this.readMatrix(Matrices.DEFAULT_FACTORY);
    }

    @Override
    public Matrix readMatrix(Factory factory) throws IOException {
        this.ensureReaderInitialized();
        Matrix matrix = factory.createMatrix(10, 10);
        int rows = 0;
        int columns = 0;
        String line = this.reader.readLine();
        while (line != null) {
            if (rows == matrix.rows()) {
                matrix = matrix.resizeRows(matrix.rows() * 3 / 2 + 1);
            }
            StringTokenizer tokenizer = new StringTokenizer(line, this.separator);
            int j = 0;
            while (tokenizer.hasMoreTokens()) {
                if (j == matrix.columns()) {
                    matrix = matrix.resizeColumns(matrix.columns() * 3 / 2 + 1);
                }
                double value = Double.valueOf(tokenizer.nextToken());
                matrix.set(rows, j++, value);
            }
            columns = j > columns ? j : columns;
            line = this.reader.readLine();
            ++rows;
        }
        matrix = matrix.resize(rows, columns);
        this.closeReader();
        return matrix;
    }

    @Override
    public void writeMatrix(Matrix matrix) throws IOException {
        this.ensureWriterInitialized();
        for (int i = 0; i < matrix.rows(); ++i) {
            StringBuilder builder = new StringBuilder();
            for (int j = 0; j < matrix.columns(); ++j) {
                double value = matrix.get(i, j);
                builder.append(String.format(Locale.US, "%.12f", value));
                if (j + 1 >= matrix.columns()) continue;
                builder.append(this.separator);
            }
            this.writer.write(builder.toString());
            this.writer.newLine();
        }
        this.closeWriter();
    }
}

