/*
 * Decompiled with CFR 0.152.
 */
package org.la4j.linear;

import org.la4j.factory.Factory;
import org.la4j.linear.LinearSystem;
import org.la4j.linear.LinearSystemSolver;
import org.la4j.matrix.Matrices;
import org.la4j.matrix.Matrix;
import org.la4j.vector.Vector;

public class GaussianSolver
implements LinearSystemSolver {
    private static final long serialVersionUID = 4071505L;

    @Override
    public Vector solve(LinearSystem linearSystem, Factory factory) {
        int columns = linearSystem.variables();
        Matrix a = linearSystem.coefficientsMatrix().resizeColumns(columns + 1);
        Vector b = linearSystem.rightHandVector().copy();
        a.setColumn(columns, b);
        Matrix triangle = this.createExtendTriangleMatrix(a);
        return this.retraceGaus(triangle, factory);
    }

    private Matrix createExtendTriangleMatrix(Matrix matrix) {
        Matrix result = matrix.copy();
        for (int i = 0; i < result.rows(); ++i) {
            int maxIndex = 0;
            double maxItem = result.get(i, i);
            for (int k = i + 1; k < result.rows(); ++k) {
                if (!(Math.abs(result.get(k, i)) > maxItem)) continue;
                maxItem = Math.abs(result.get(k, i));
                maxIndex = k;
            }
            if (Math.abs(maxItem) < Matrices.EPS) {
                throw new IllegalArgumentException("This system can't be solved.");
            }
            if (maxIndex > i) {
                result.swapRows(maxIndex, i);
            }
            for (int j = i + 1; j < result.rows(); ++j) {
                double C = result.get(j, i) / result.get(i, i);
                result.set(j, i, C);
                for (int k = i + 1; k < result.columns(); ++k) {
                    result.update(j, k, Matrices.asMinusFunction(result.get(i, k) * C));
                }
            }
        }
        return result;
    }

    private Vector retraceGaus(Matrix matrix, Factory factory) {
        if (Math.abs(matrix.product()) < Matrices.EPS) {
            throw new IllegalArgumentException("This system hasn't solution.");
        }
        Vector result = factory.createVector(matrix.columns() - 1);
        for (int i = result.length() - 1; i >= 0; --i) {
            double summand = 0.0;
            for (int j = i + 1; j < result.length(); ++j) {
                summand += result.get(j) * matrix.get(i, j);
            }
            result.set(i, (matrix.get(i, matrix.columns() - 1) - summand) / matrix.get(i, i));
        }
        return result;
    }

    @Override
    public boolean suitableFor(LinearSystem linearSystem) {
        return true;
    }
}

