/*
 * Decompiled with CFR 0.152.
 */
package org.la4j.matrix;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.la4j.decomposition.MatrixDecompositor;
import org.la4j.factory.Factory;
import org.la4j.inversion.MatrixInvertor;
import org.la4j.matrix.Matrix;
import org.la4j.matrix.functor.MatrixAccumulator;
import org.la4j.matrix.functor.MatrixFunction;
import org.la4j.matrix.functor.MatrixPredicate;
import org.la4j.matrix.functor.MatrixProcedure;
import org.la4j.vector.Vector;

public abstract class AbstractSafeMatrix
implements Matrix {
    protected Matrix self;
    protected Factory factory;

    protected AbstractSafeMatrix(Matrix matrix) {
        this.self = matrix;
        this.factory = matrix.factory().safe();
    }

    @Override
    public double get(int i, int j) {
        this.ensureIndexInRows(i);
        this.ensureIndexInColumns(j);
        return this.self.get(i, j);
    }

    @Override
    public void set(int i, int j, double value) {
        this.ensureIndexInRows(i);
        this.ensureIndexInColumns(j);
        this.self.set(i, j, value);
    }

    @Override
    public void assign(double value) {
        this.self.assign(value);
    }

    @Override
    public void swapRows(int i, int j) {
        this.ensureIndexInRows(i);
        this.ensureIndexInRows(j);
        this.self.swapRows(i, j);
    }

    @Override
    public void swapColumns(int i, int j) {
        this.ensureIndexInColumns(i);
        this.ensureIndexInColumns(j);
        this.self.swapColumns(i, j);
    }

    @Override
    public int rows() {
        return this.self.rows();
    }

    @Override
    public int columns() {
        return this.self.columns();
    }

    @Override
    public Matrix transpose() {
        return this.self.transpose(this.factory);
    }

    @Override
    public Matrix transpose(Factory factory) {
        return this.self.transpose(factory);
    }

    @Override
    public Matrix multiply(double value) {
        return this.self.multiply(value, this.factory);
    }

    @Override
    public Matrix multiply(double value, Factory factory) {
        return this.self.multiply(value, factory);
    }

    @Override
    public Vector multiply(Vector vector) {
        return this.self.multiply(vector, this.factory);
    }

    @Override
    public Vector multiply(Vector vector, Factory factory) {
        return this.self.multiply(vector, factory);
    }

    @Override
    public Matrix multiply(Matrix matrix) {
        return this.self.multiply(matrix, this.factory);
    }

    @Override
    public Matrix multiply(Matrix matrix, Factory factory) {
        return this.self.multiply(matrix, factory);
    }

    @Override
    public Matrix subtract(double value) {
        return this.self.subtract(value, this.factory);
    }

    @Override
    public Matrix subtract(double value, Factory factory) {
        return this.self.subtract(value, factory);
    }

    @Override
    public Matrix subtract(Matrix matrix) {
        return this.self.subtract(matrix, this.factory);
    }

    @Override
    public Matrix subtract(Matrix matrix, Factory factory) {
        return this.self.subtract(matrix, factory);
    }

    @Override
    public Matrix add(double value) {
        return this.self.add(value, this.factory);
    }

    @Override
    public Matrix add(double value, Factory factory) {
        return this.self.add(value, factory);
    }

    @Override
    public Matrix add(Matrix matrix) {
        return this.self.add(matrix, this.factory);
    }

    @Override
    public Matrix add(Matrix matrix, Factory factory) {
        return this.self.add(matrix, factory);
    }

    @Override
    public Matrix divide(double value) {
        return this.self.divide(value, this.factory);
    }

    @Override
    public Matrix divide(double value, Factory factory) {
        return this.self.divide(value, factory);
    }

    @Override
    public Matrix kronecker(Matrix matrix) {
        return this.self.kronecker(matrix, this.factory);
    }

    @Override
    public Matrix kronecker(Matrix matrix, Factory factory) {
        return this.self.kronecker(matrix, factory);
    }

    @Override
    public double trace() {
        return this.self.trace();
    }

    @Override
    public double product() {
        return this.self.product();
    }

    @Override
    public double determinant() {
        return this.self.determinant();
    }

    @Override
    public int rank() {
        return this.self.rank();
    }

    @Override
    public Vector getRow(int i) {
        this.ensureIndexInRows(i);
        return this.self.getRow(i, this.factory);
    }

    @Override
    public Vector getRow(int i, Factory factory) {
        this.ensureIndexInRows(i);
        return this.self.getRow(i, factory);
    }

    @Override
    public Vector getColumn(int j) {
        this.ensureIndexInColumns(j);
        return this.self.getColumn(j, this.factory);
    }

    @Override
    public Vector getColumn(int j, Factory factory) {
        this.ensureIndexInColumns(j);
        return this.self.getColumn(j, factory);
    }

    @Override
    public void setRow(int i, Vector row) {
        this.ensureIndexInRows(i);
        this.self.setRow(i, row);
    }

    @Override
    public void setColumn(int j, Vector column) {
        this.ensureIndexInColumns(j);
        this.self.setColumn(j, column);
    }

    @Override
    public Matrix triangularize() {
        return this.self.triangularize(this.factory);
    }

    @Override
    public Matrix triangularize(Factory factory) {
        return this.self.triangularize(factory);
    }

    @Override
    public Matrix[] decompose(MatrixDecompositor decompositor) {
        return this.self.decompose(decompositor, this.factory);
    }

    @Override
    public Matrix[] decompose(MatrixDecompositor decompositor, Factory factory) {
        return this.self.decompose(decompositor, factory);
    }

    @Override
    public Matrix inverse(MatrixInvertor invertor) {
        return this.self.inverse(invertor, this.factory);
    }

    @Override
    public Matrix inverse(MatrixInvertor invertor, Factory factory) {
        return this.self.inverse(invertor, factory);
    }

    @Override
    public Matrix blank() {
        return this.self.blank(this.factory);
    }

    @Override
    public Matrix blank(Factory factory) {
        return this.self.blank(factory);
    }

    @Override
    public Matrix copy() {
        return this.self.copy(this.factory);
    }

    @Override
    public Matrix copy(Factory factory) {
        return this.self.copy(factory);
    }

    @Override
    public Matrix resize(int rows, int columns) {
        return this.self.resize(rows, columns, this.factory);
    }

    @Override
    public Matrix resize(int rows, int columns, Factory factory) {
        return this.self.resize(rows, columns, factory);
    }

    @Override
    public Matrix resizeRows(int rows) {
        return this.self.resizeRows(rows, this.factory);
    }

    @Override
    public Matrix resizeRows(int rows, Factory factory) {
        return this.self.resizeRows(rows, factory);
    }

    @Override
    public Matrix resizeColumns(int columns) {
        return this.self.resizeColumns(columns, this.factory);
    }

    @Override
    public Matrix resizeColumns(int columns, Factory factory) {
        return this.self.resizeColumns(columns, factory);
    }

    @Override
    public Matrix slice(int fromRow, int fromColumn, int untilRow, int untilColumn) {
        return this.self.slice(fromRow, fromColumn, untilRow, untilColumn, this.factory);
    }

    @Override
    public Matrix slice(int fromRow, int fromColumn, int untilRow, int untilColumn, Factory factory) {
        return this.self.slice(fromRow, fromColumn, untilRow, untilColumn, factory);
    }

    @Override
    public Matrix sliceTopLeft(int untilRow, int untilColumn) {
        return this.self.sliceTopLeft(untilRow, untilColumn, this.factory);
    }

    @Override
    public Matrix sliceTopLeft(int untilRow, int untilColumn, Factory factory) {
        return this.self.sliceTopLeft(untilRow, untilColumn, factory);
    }

    @Override
    public Matrix sliceBottomRight(int fromRow, int fromColumn) {
        return this.self.sliceBottomRight(fromRow, fromColumn, this.factory);
    }

    @Override
    public Matrix sliceBottomRight(int fromRow, int fromColumn, Factory fac) {
        return this.self.sliceBottomRight(fromRow, fromColumn, this.factory);
    }

    @Override
    public Factory factory() {
        return this.factory;
    }

    @Override
    public void each(MatrixProcedure procedure) {
        this.self.each(procedure);
    }

    @Override
    public Matrix transform(MatrixFunction function) {
        return this.self.transform(function, this.factory);
    }

    @Override
    public Matrix transform(MatrixFunction function, Factory factory) {
        return this.self.transform(function, factory);
    }

    @Override
    public Matrix transform(int i, int j, MatrixFunction function) {
        this.ensureIndexInRows(i);
        this.ensureIndexInColumns(j);
        return this.self.transform(i, j, function, this.factory);
    }

    @Override
    public Matrix transform(int i, int j, MatrixFunction function, Factory factory) {
        this.ensureIndexInRows(i);
        this.ensureIndexInColumns(j);
        return this.self.transform(i, j, function, factory);
    }

    @Override
    public void update(MatrixFunction function) {
        this.self.update(function);
    }

    @Override
    public void update(int i, int j, MatrixFunction function) {
        this.ensureIndexInRows(i);
        this.ensureIndexInColumns(j);
        this.self.update(i, j, function);
    }

    @Override
    public double fold(MatrixAccumulator accumulator) {
        return this.self.fold(accumulator);
    }

    @Override
    public double foldRow(int i, MatrixAccumulator accumulator) {
        this.ensureIndexInRows(i);
        return this.self.foldRow(i, accumulator);
    }

    @Override
    public double foldColumn(int j, MatrixAccumulator accumulator) {
        this.ensureIndexInColumns(j);
        return this.self.foldColumn(j, accumulator);
    }

    @Override
    public boolean is(MatrixPredicate predidate) {
        return this.self.is(predidate);
    }

    @Override
    public Matrix safe() {
        return this;
    }

    @Override
    public Matrix unsafe() {
        return this.self;
    }

    public boolean equals(Object obj) {
        return this.self.equals(obj);
    }

    public int hashCode() {
        return this.self.hashCode();
    }

    public String toString() {
        return this.self.toString();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.self.readExternal(in);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.self.writeExternal(out);
    }

    protected void ensureIndexInRows(int i) {
        if (i >= this.self.rows() || i < 0) {
            throw new IllegalArgumentException("Row index out of bounds: " + i);
        }
    }

    protected void ensureIndexInColumns(int i) {
        if (i >= this.self.columns() || i < 0) {
            throw new IllegalArgumentException("Column index out of bounds: " + i);
        }
    }
}

