/*
 * Decompiled with CFR 0.152.
 */
package org.la4j.matrix.sparse;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.la4j.factory.Factory;
import org.la4j.matrix.Matrices;
import org.la4j.matrix.Matrix;
import org.la4j.matrix.functor.MatrixFunction;
import org.la4j.matrix.functor.MatrixProcedure;
import org.la4j.matrix.source.MatrixSource;
import org.la4j.matrix.sparse.AbstractCompressedMatrix;
import org.la4j.matrix.sparse.SparseMatrix;
import org.la4j.vector.Vector;
import org.la4j.vector.sparse.CompressedVector;

public class CCSMatrix
extends AbstractCompressedMatrix
implements SparseMatrix {
    private static final long serialVersionUID = 4071505L;
    private static final int MINIMUM_SIZE = 32;
    private double[] values;
    private int[] rowIndices;
    private int[] columnPointers;

    public CCSMatrix() {
        this(0, 0);
    }

    public CCSMatrix(int rows, int columns) {
        this(rows, columns, 0);
    }

    public CCSMatrix(Matrix matrix) {
        this(Matrices.asUnsafeSource(matrix));
    }

    public CCSMatrix(double[][] array) {
        this(Matrices.asArray2DSource(array));
    }

    public CCSMatrix(MatrixSource source) {
        this(source.rows(), source.columns(), 0);
        for (int j = 0; j < this.columns; ++j) {
            this.columnPointers[j] = this.cardinality;
            for (int i = 0; i < this.rows; ++i) {
                double value = source.get(i, j);
                if (!(Math.abs(value) > Matrices.EPS)) continue;
                if (this.values.length < this.cardinality + 1) {
                    this.growup();
                }
                this.values[this.cardinality] = value;
                this.rowIndices[this.cardinality] = i;
                ++this.cardinality;
            }
        }
        this.columnPointers[this.columns] = this.cardinality;
    }

    public CCSMatrix(int rows, int columns, int cardinality) {
        super(Matrices.CCS_FACTORY, rows, columns);
        int alignedSize = this.align(rows, columns, cardinality);
        this.cardinality = 0;
        this.values = new double[alignedSize];
        this.rowIndices = new int[alignedSize];
        this.columnPointers = new int[columns + 1];
    }

    public CCSMatrix(int rows, int columns, int cardinality, double[] values, int[] rowIndices, int[] columnPointers) {
        super(Matrices.CCS_FACTORY, rows, columns);
        this.cardinality = cardinality;
        this.values = values;
        this.rowIndices = rowIndices;
        this.columnPointers = columnPointers;
    }

    @Override
    public double get(int i, int j) {
        int k = this.searchForRowIndex(i, this.columnPointers[j], this.columnPointers[j + 1]);
        if (k < this.columnPointers[j + 1] && this.rowIndices[k] == i) {
            return this.values[k];
        }
        return 0.0;
    }

    @Override
    public void set(int i, int j, double value) {
        int k = this.searchForRowIndex(i, this.columnPointers[j], this.columnPointers[j + 1]);
        if (k < this.columnPointers[j + 1] && this.rowIndices[k] == i) {
            if (Math.abs(value) < Matrices.EPS) {
                this.remove(k, j);
            } else {
                this.values[k] = value;
            }
        } else {
            this.insert(k, i, j, value);
        }
    }

    @Override
    public Vector getColumn(int j) {
        int columnCardinality = this.columnPointers[j + 1] - this.columnPointers[j];
        double[] columnValues = new double[columnCardinality];
        int[] columnIndices = new int[columnCardinality];
        System.arraycopy(this.values, this.columnPointers[j], columnValues, 0, columnCardinality);
        System.arraycopy(this.rowIndices, this.columnPointers[j], columnIndices, 0, columnCardinality);
        return new CompressedVector(this.rows, columnCardinality, columnValues, columnIndices);
    }

    @Override
    public Vector getColumn(int j, Factory factory) {
        this.ensureFactoryIsNotNull(factory);
        Vector result = factory.createVector(this.rows);
        for (int jj = this.columnPointers[j]; jj < this.columnPointers[j + 1]; ++jj) {
            result.set(this.rowIndices[jj], this.values[jj]);
        }
        return result;
    }

    @Override
    public Vector getRow(int i, Factory factory) {
        this.ensureFactoryIsNotNull(factory);
        Vector result = factory.createVector(this.columns);
        int j = 0;
        while (this.columnPointers[j] < this.cardinality) {
            int k = this.searchForRowIndex(i, this.columnPointers[j], this.columnPointers[j + 1]);
            if (k < this.columnPointers[j + 1] && this.rowIndices[k] == i) {
                result.set(j, this.values[k]);
            }
            ++j;
        }
        return result;
    }

    @Override
    public Matrix copy() {
        double[] $values = new double[this.align(this.rows, this.columns, this.cardinality)];
        int[] $rowIndices = new int[this.align(this.rows, this.columns, this.cardinality)];
        int[] $columnPointers = new int[this.columns + 1];
        System.arraycopy(this.values, 0, $values, 0, this.cardinality);
        System.arraycopy(this.rowIndices, 0, $rowIndices, 0, this.cardinality);
        System.arraycopy(this.columnPointers, 0, $columnPointers, 0, this.columns + 1);
        return new CCSMatrix(this.rows, this.columns, this.cardinality, $values, $rowIndices, $columnPointers);
    }

    @Override
    public Matrix resize(int rows, int columns) {
        this.ensureDimensionsAreNotNegative(rows, columns);
        if (this.rows == rows && this.columns == columns) {
            return this.copy();
        }
        if (this.rows >= rows && this.columns >= columns) {
            double[] $values = new double[this.align(rows, columns, this.cardinality)];
            int[] $rowIndices = new int[this.align(rows, columns, this.cardinality)];
            int[] $columnPointers = new int[columns + 1];
            int $cardinality = 0;
            int k = 0;
            for (int j = 0; k < this.cardinality && j < columns; ++j) {
                $columnPointers[j] = $cardinality;
                int i = this.columnPointers[j];
                while (i < this.columnPointers[j + 1] && this.rowIndices[i] < rows) {
                    $values[$cardinality] = this.values[i];
                    $rowIndices[$cardinality] = this.rowIndices[i];
                    ++$cardinality;
                    ++i;
                    ++k;
                }
            }
            $columnPointers[columns] = $cardinality;
            return new CCSMatrix(rows, columns, $cardinality, $values, $rowIndices, $columnPointers);
        }
        if (this.columns < columns) {
            double[] $values = new double[this.align(rows, columns, this.cardinality)];
            int[] $rowIndices = new int[this.align(rows, columns, this.cardinality)];
            int[] $columnPointers = new int[columns + 1];
            System.arraycopy(this.values, 0, $values, 0, this.cardinality);
            System.arraycopy(this.rowIndices, 0, $rowIndices, 0, this.cardinality);
            System.arraycopy(this.columnPointers, 0, $columnPointers, 0, this.columns + 1);
            for (int i = this.columns; i < columns + 1; ++i) {
                $columnPointers[i] = this.cardinality;
            }
            return new CCSMatrix(rows, columns, this.cardinality, $values, $rowIndices, $columnPointers);
        }
        double[] $values = new double[this.align(rows, columns, this.cardinality)];
        int[] $rowIndices = new int[this.align(rows, columns, this.cardinality)];
        int[] $columnPointers = new int[columns + 1];
        System.arraycopy(this.values, 0, $values, 0, this.cardinality);
        System.arraycopy(this.rowIndices, 0, $rowIndices, 0, this.cardinality);
        System.arraycopy(this.columnPointers, 0, $columnPointers, 0, this.columns + 1);
        return new CCSMatrix(rows, columns, this.cardinality, $values, $rowIndices, $columnPointers);
    }

    @Override
    public void each(MatrixProcedure procedure) {
        int k = 0;
        int j = 0;
        while (k < this.cardinality) {
            int i = this.columnPointers[j];
            while (i < this.columnPointers[j + 1]) {
                procedure.apply(this.rowIndices[i], j, this.values[i]);
                ++i;
                ++k;
            }
            ++j;
        }
    }

    @Override
    public void update(int i, int j, MatrixFunction function) {
        int k = this.searchForRowIndex(i, this.columnPointers[j], this.columnPointers[j + 1]);
        if (k < this.columnPointers[j + 1] && this.rowIndices[k] == i) {
            double value = function.evaluate(i, j, this.values[k]);
            if (Math.abs(value) < Matrices.EPS) {
                this.remove(k, j);
            } else {
                this.values[k] = value;
            }
        } else {
            this.insert(k, i, j, function.evaluate(i, j, 0.0));
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.rows = in.readInt();
        this.columns = in.readInt();
        this.cardinality = in.readInt();
        int alignedSize = this.align(this.rows, this.columns, this.cardinality);
        this.values = new double[alignedSize];
        this.rowIndices = new int[alignedSize];
        this.columnPointers = new int[this.columns + 1];
        for (int k = 0; k < this.cardinality; ++k) {
            this.rowIndices[k] = in.readInt();
            int j = in.readInt();
            this.values[k] = in.readDouble();
            this.columnPointers[j + 1] = k + 1;
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.rows);
        out.writeInt(this.columns);
        out.writeInt(this.cardinality);
        int k = 0;
        int j = 0;
        while (k < this.cardinality) {
            int i = this.columnPointers[j];
            while (i < this.columnPointers[j + 1]) {
                out.writeInt(this.rowIndices[i]);
                out.writeInt(j);
                out.writeDouble(this.values[i]);
                ++i;
                ++k;
            }
            ++j;
        }
    }

    private int searchForRowIndex(int i, int left, int right) {
        if (left == right) {
            return left;
        }
        if (right - left < 8) {
            int ii;
            for (ii = left; ii < right && this.rowIndices[ii] < i; ++ii) {
            }
            return ii;
        }
        int p = (left + right) / 2;
        if (this.rowIndices[p] > i) {
            return this.searchForRowIndex(i, left, p);
        }
        if (this.rowIndices[p] < i) {
            return this.searchForRowIndex(i, p + 1, right);
        }
        return p;
    }

    private void insert(int k, int i, int j, double value) {
        if (Math.abs(value) < Matrices.EPS) {
            return;
        }
        if (this.values.length < this.cardinality + 1) {
            this.growup();
        }
        System.arraycopy(this.values, k, this.values, k + 1, this.cardinality - k);
        System.arraycopy(this.rowIndices, k, this.rowIndices, k + 1, this.cardinality - k);
        this.values[k] = value;
        this.rowIndices[k] = i;
        int jj = j + 1;
        while (jj < this.columns + 1) {
            int n = jj++;
            this.columnPointers[n] = this.columnPointers[n] + 1;
        }
        ++this.cardinality;
    }

    private void remove(int k, int j) {
        --this.cardinality;
        System.arraycopy(this.values, k + 1, this.values, k, this.cardinality - k);
        System.arraycopy(this.rowIndices, k + 1, this.rowIndices, k, this.cardinality - k);
        int jj = j + 1;
        while (jj < this.columns + 1) {
            int n = jj++;
            this.columnPointers[n] = this.columnPointers[n] - 1;
        }
    }

    private void growup() {
        if (this.values.length == this.rows * this.columns) {
            throw new IllegalStateException("This matrix can't grow up.");
        }
        int capacity = Math.min(this.rows * this.columns, this.cardinality * 3 / 2 + 1);
        double[] $values = new double[capacity];
        int[] $rowIndices = new int[capacity];
        System.arraycopy(this.values, 0, $values, 0, this.cardinality);
        System.arraycopy(this.rowIndices, 0, $rowIndices, 0, this.cardinality);
        this.values = $values;
        this.rowIndices = $rowIndices;
    }

    private int align(int rows, int columns, int cardinality) {
        return Math.min(rows * columns, (cardinality / 32 + 1) * 32);
    }
}

