/*
 * Decompiled with CFR 0.152.
 */
package org.ngs.ngunits;

import org.ngs.ngunits.Prefix;
import org.ngs.ngunits.SI;
import org.ngs.ngunits.SystemOfUnits;
import org.ngs.ngunits.Unit;
import org.ngs.ngunits.converter.LogConverter;
import org.ngs.ngunits.converter.RationalConverter;
import org.ngs.ngunits.quantity.Acceleration;
import org.ngs.ngunits.quantity.AmountOfSubstance;
import org.ngs.ngunits.quantity.Angle;
import org.ngs.ngunits.quantity.Area;
import org.ngs.ngunits.quantity.Dimensionless;
import org.ngs.ngunits.quantity.DynamicViscosity;
import org.ngs.ngunits.quantity.ElectricCharge;
import org.ngs.ngunits.quantity.ElectricCurrent;
import org.ngs.ngunits.quantity.Energy;
import org.ngs.ngunits.quantity.Force;
import org.ngs.ngunits.quantity.Illuminance;
import org.ngs.ngunits.quantity.Information;
import org.ngs.ngunits.quantity.KinematicViscosity;
import org.ngs.ngunits.quantity.Length;
import org.ngs.ngunits.quantity.MagneticFlux;
import org.ngs.ngunits.quantity.MagneticFluxDensity;
import org.ngs.ngunits.quantity.Mass;
import org.ngs.ngunits.quantity.Power;
import org.ngs.ngunits.quantity.Pressure;
import org.ngs.ngunits.quantity.RadiationDoseAbsorbed;
import org.ngs.ngunits.quantity.RadioactiveActivity;
import org.ngs.ngunits.quantity.SolidAngle;
import org.ngs.ngunits.quantity.Temperature;
import org.ngs.ngunits.quantity.Time;
import org.ngs.ngunits.quantity.Velocity;
import org.ngs.ngunits.quantity.Volume;
import org.ngs.ngunits.quantity.VolumetricFlowRate;

public final class NonSI
extends SystemOfUnits {
    public static final NonSI INSTANCE = new NonSI();
    private static final int STANDARD_GRAVITY_DIVIDEND = 980665;
    private static final int STANDARD_GRAVITY_DIVISOR = 100000;
    private static final int INTERNATIONAL_FOOT_DIVIDEND = 3048;
    private static final int INTERNATIONAL_FOOT_DIViSOR = 10000;
    private static final int AVOIRDUPOIS_POUND_DIVIDEND = 45359237;
    private static final int AVOIRDUPOIS_POUND_DIVISOR = 100000000;
    private static final double AVOGADRO_CONSTANT = 6.02214199E23;
    private static final double ELEMENTARY_CHARGE = 1.602176462E-19;
    public static final Unit<Dimensionless> PERCENT = NonSI.u(DELEGATE.one().divide(100.0));
    public static final Unit<Dimensionless> PER_MIL = NonSI.u(PERCENT.divide(10.0));
    public static final Unit<Dimensionless> DECIBEL = NonSI.u(DELEGATE.one().transform(new LogConverter.Exp(10.0).concatenate(new RationalConverter(1L, 10L))));
    public static final Unit<AmountOfSubstance> ATOM = SI.MOLE.divide(6.02214199E23);
    public static final Unit<Length> FOOT = NonSI.u(SI.METRE.multiply(3048.0).divide(10000.0));
    public static final Unit<Length> FOOT_SURVEY_US = NonSI.u(SI.METRE.multiply(1200.0).divide(3937.0));
    public static final Unit<Length> YARD = NonSI.u(FOOT.multiply(3.0));
    public static final Unit<Length> INCH = NonSI.u(FOOT.divide(12.0));
    public static final Unit<Length> MILE = NonSI.u(SI.METRE.multiply(1609344.0).divide(1000.0));
    public static final Unit<Length> NAUTICAL_MILE = NonSI.u(SI.METRE.multiply(1852.0));
    public static final Unit<Length> ANGSTROM = NonSI.u(SI.METRE.divide(1.0E10));
    public static final Unit<Length> ASTRONOMICAL_UNIT = NonSI.u(SI.METRE.multiply(1.49597870691E11));
    public static final Unit<Length> LIGHT_YEAR = NonSI.u(SI.METRE.multiply(9.460528405E15));
    public static final Unit<Length> PARSEC = NonSI.u(SI.METRE.multiply(3.085677E16));
    public static final Unit<Length> POINT = NonSI.u(INCH.multiply(13837.0).divide(1000000.0));
    public static final Unit<Length> PIXEL = NonSI.u(INCH.divide(72.0));
    public static final Unit<Length> COMPUTER_POINT = PIXEL;
    public static final Unit<Length> FOOT_MODIFIED_AMERICAN = NonSI.u(SI.METRE.multiply(12.0004584).divide(39.37));
    public static final Unit<Length> FOOT_CLARKE = NonSI.u(SI.METRE.multiply(12.0).divide(39.370432));
    public static final Unit<Length> FOOT_INDIAN = NonSI.u(SI.METRE.multiply(12.0).divide(39.370141));
    public static final Unit<Length> LINK = NonSI.u(SI.METRE.multiply(7.92).divide(39.370432));
    public static final Unit<Length> LINK_BENOIT = NonSI.u(SI.METRE.multiply(7.92).divide(39.370113));
    public static final Unit<Length> LINK_SEARS = NonSI.u(SI.METRE.multiply(7.92).divide(39.370147));
    public static final Unit<Length> CHAIN_BENOIT = NonSI.u(LINK_BENOIT.multiply(100.0));
    public static final Unit<Length> CHAIN_SEARS = NonSI.u(LINK_SEARS.multiply(100.0));
    public static final Unit<Length> YARD_SEARS = NonSI.u(SI.METRE.multiply(36.0).divide(39.370147));
    public static final Unit<Length> YARD_INDIAN = NonSI.u(FOOT_INDIAN.multiply(3.0));
    public static final Unit<Length> FATHOM = NonSI.u(YARD.multiply(2.0));
    public static final Unit<Time> MINUTE = NonSI.u(SI.SECOND.multiply(60.0));
    public static final Unit<Time> HOUR = NonSI.u(MINUTE.multiply(60.0));
    public static final Unit<Time> DAY = NonSI.u(HOUR.multiply(24.0));
    public static final Unit<Time> WEEK = NonSI.u(DAY.multiply(7.0));
    public static final Unit<Time> YEAR = NonSI.u(SI.SECOND.multiply(3.1556952E7));
    public static final Unit<Time> MONTH = NonSI.u(YEAR.divide(12.0));
    public static final Unit<Time> DAY_SIDEREAL = NonSI.u(SI.SECOND.multiply(86164.09));
    public static final Unit<Time> YEAR_SIDEREAL = NonSI.u(SI.SECOND.multiply(3.155814954E7));
    public static final Unit<Time> YEAR_CALENDAR = NonSI.u(DAY.multiply(365.0));
    public static final Unit<Time> MILLISECOND = NonSI.u(SI.SECOND.divide(1000.0));
    public static final Unit<Mass> ATOMIC_MASS = NonSI.u(SI.KILOGRAM.multiply(1.6605387280149467E-27));
    public static final Unit<Mass> ELECTRON_MASS = NonSI.u(SI.KILOGRAM.multiply(9.10938188E-31));
    public static final Unit<Mass> POUND = NonSI.u(SI.KILOGRAM.multiply(4.5359237E7).divide(1.0E8));
    public static final Unit<Mass> OUNCE = NonSI.u(POUND.divide(16.0));
    public static final Unit<Mass> TON_US = NonSI.u(POUND.multiply(2000.0));
    public static final Unit<Mass> TON_UK = NonSI.u(POUND.multiply(2240.0));
    public static final Unit<Mass> METRIC_TON = NonSI.u(SI.KILOGRAM.multiply(1000.0));
    public static final Unit<ElectricCharge> E = NonSI.u(SI.COULOMB.multiply(1.602176462E-19));
    public static final Unit<ElectricCharge> FARADAY = NonSI.u(SI.COULOMB.multiply(96485.3414719984));
    public static final Unit<ElectricCharge> FRANKLIN = NonSI.u(SI.COULOMB.multiply(3.3356E-10));
    public static final Unit<Temperature> RANKINE = NonSI.u(SI.KELVIN.multiply(5.0).divide(9.0));
    public static final Unit<Temperature> FAHRENHEIT = NonSI.u(RANKINE.add(459.67));
    public static final Unit<Angle> REVOLUTION = NonSI.u(SI.RADIAN.multiply(Math.PI * 2));
    public static final Unit<Angle> DEGREE_ANGLE = NonSI.u(REVOLUTION.divide(360.0));
    public static final Unit<Angle> MINUTE_ANGLE = NonSI.u(DEGREE_ANGLE.divide(60.0));
    public static final Unit<Angle> SECOND_ANGLE = NonSI.u(MINUTE_ANGLE.divide(60.0));
    public static final Unit<Angle> CENTIRADIAN = NonSI.u(SI.RADIAN.divide(100.0));
    public static final Unit<Angle> GRADE = NonSI.u(REVOLUTION.divide(400.0));
    public static final Unit<Velocity> MILES_PER_HOUR = NonSI.u(MILE.divide(HOUR));
    public static final Unit<Velocity> KILOMETRES_PER_HOUR = NonSI.u(SI.KILOMETRE.divide(HOUR));
    public static final Unit<Velocity> KILOMETERS_PER_HOUR = KILOMETRES_PER_HOUR;
    public static final Unit<Velocity> KNOT = NonSI.u(NAUTICAL_MILE.divide(HOUR));
    public static final Unit<Velocity> MACH = NonSI.u(SI.METRES_PER_SECOND.multiply(331.6));
    public static final Unit<Velocity> C = NonSI.u(SI.METRES_PER_SECOND.multiply(2.99792458E8));
    public static final Unit<Acceleration> G = NonSI.u(SI.METRES_PER_SQUARE_SECOND.multiply(980665.0).divide(100000.0));
    public static final Unit<Area> ARE = NonSI.u(SI.SQUARE_METRE.multiply(100.0));
    public static final Unit<Area> HECTARE = NonSI.u(ARE.multiply(100.0));
    public static final Unit<Area> SQUARE_KILOMETER = NonSI.u(SI.KILOMETER.pow(2));
    public static final Unit<Area> SQUARE_FOOT = NonSI.u(FOOT.pow(2));
    public static final Unit<Area> ACRE = NonSI.u(SQUARE_FOOT.multiply(43560.0));
    public static final Unit<Information> BYTE = NonSI.u(SI.BIT.multiply(8.0));
    public static final Unit<Information> OCTET = BYTE;
    public static final Unit<ElectricCurrent> GILBERT = NonSI.u(SI.AMPERE.multiply(0.7957747154594768));
    public static final Unit<Energy> ERG = NonSI.u(SI.JOULE.divide(1.0E7));
    public static final Unit<Energy> ELECTRON_VOLT = NonSI.u(SI.JOULE.multiply(1.602176462E-19));
    public static final Unit<Illuminance> LAMBERT = NonSI.u(SI.LUX.multiply(10000.0));
    public static final Unit<MagneticFlux> MAXWELL = NonSI.u(SI.WEBER.divide(1.0E8));
    public static final Unit<MagneticFluxDensity> GAUSS = NonSI.u(SI.TESLA.divide(10000.0));
    public static final Unit<Force> DYNE = NonSI.u(SI.NEWTON.divide(100000.0));
    public static final Unit<Force> KILOGRAM_FORCE = NonSI.u(SI.NEWTON.multiply(980665.0).divide(100000.0));
    public static final Unit<Force> POUND_FORCE = NonSI.u(SI.NEWTON.multiply(4.4482216152605E13).divide(1.0E13));
    public static final Unit<Power> HORSEPOWER = NonSI.u(SI.WATT.multiply(735.499));
    public static final Unit<Pressure> ATMOSPHERE = NonSI.u(SI.PASCAL.multiply(101325.0));
    public static final Unit<Pressure> BAR = NonSI.u(SI.PASCAL.multiply(100000.0));
    public static final Unit<Pressure> MILLIMETER_OF_MERCURY = NonSI.u(SI.PASCAL.multiply(133.322));
    public static final Unit<Pressure> INCH_OF_MERCURY = NonSI.u(SI.PASCAL.multiply(3386.388));
    public static final Unit<RadiationDoseAbsorbed> RAD = NonSI.u(SI.GRAY.divide(100.0));
    public static final Unit<RadiationDoseAbsorbed> REM = NonSI.u(SI.SIEVERT.divide(100.0));
    public static final Unit<RadioactiveActivity> CURIE = NonSI.u(SI.BECQUEREL.multiply(3.7E10));
    public static final Unit<RadioactiveActivity> RUTHERFORD = NonSI.u(SI.BECQUEREL.multiply(1000000.0));
    public static final Unit<SolidAngle> SPHERE = NonSI.u(SI.STERADIAN.multiply(Math.PI * 4));
    public static final Unit<Volume> LITRE = NonSI.u(SI.CUBIC_METRE.divide(1000.0));
    public static final Unit<Volume> LITER = LITRE;
    public static final Unit<Volume> CUBIC_INCH = NonSI.u(INCH.pow(3));
    public static final Unit<Volume> GALLON_LIQUID_US = NonSI.u(CUBIC_INCH.multiply(231.0));
    public static final Unit<Volume> OUNCE_LIQUID_US = NonSI.u(GALLON_LIQUID_US.divide(128.0));
    public static final Unit<Volume> GALLON_DRY_US = NonSI.u(CUBIC_INCH.multiply(2688025.0).divide(10000.0));
    public static final Unit<Volume> GALLON_UK = NonSI.u(LITRE.multiply(454609.0).divide(100000.0));
    public static final Unit<Volume> OUNCE_LIQUID_UK = NonSI.u(GALLON_UK.divide(160.0));
    public static final Unit<DynamicViscosity> POISE = NonSI.u(SI.GRAM.divide(Prefix.CENTI.transform(SI.METRE).multiply(SI.SECOND)));
    public static final Unit<KinematicViscosity> STOKE = NonSI.u(Prefix.CENTI.transform(SI.METRE).pow(2).divide(SI.SECOND));
    public static final Unit<VolumetricFlowRate> CFS = NonSI.u(FOOT.pow(3).divide(SI.SECOND));
    public static final Unit<?> ROENTGEN = NonSI.u(SI.COULOMB.divide(SI.KILOGRAM).multiply(2.58E-4));

    private NonSI() {
    }
}

